<?php


error_reporting(1);
spl_autoload_register(function ($mod) {
    require('../../../../../asset/mod/' . $mod . '.php');
});

// Load file autoload.php
require '../../asset/bootstrap/asset/PhpWord/autoload.php';
$clssekolah = new sekolah();
$dirImage = new dirImage();
$classBuku = new simakom_laporan;
$sekolah = $clssekolah->dataSekolah('sekolah');
$alamat = $clssekolah->dataSekolah('alamat');


// Creating the new document...
$phpWord = new \PhpOffice\PhpWord\PhpWord();
$section = $phpWord->addSection(
    array('paperSize' => 'A4', 'orientation' => 'landscape', 'marginLeft' => 1000, 'marginRight' => 900, 'marginTop' => 600, 'marginBottom' => 600)
);

$phpWord->addParagraphStyle('centerStyle', array('align' => 'center', 'spaceAfter' => 0));
$fontStyle = new \PhpOffice\PhpWord\Style\Font();

$phpWord->addFontStyle(
    'judul',
    array('name' => 'Arial', 'size' => 14, 'color' => '1B2232', 'bold' => true, 'align' => 'center')
);
$phpWord->addFontStyle(
    'umum',
    array('name' => 'Arial', 'size' => 12, 'color' => '1B2232', 'bold' => false)
);
$phpWord->addFontStyle(
    'subJudul',
    array('name' => 'Arial', 'size' => 11, 'color' => '1B2232', 'bold' => true)
);
$phpWord->addFontStyle(
    'isi',
    array('name' => 'Arial', 'size' => 8, 'color' => '1B2232', 'bold' => false)
);

// Row 1
$table = $section->addTable('');
$table->addRow(250, '');

$cell1 = $table->addCell(1000, ['vMerge' => 'restart']); // Mulai merge di kolom pertama
$logo = $dirImage->cekLogophpWord('/asset/dokumen/foto/', '../../asset/dokumen/foto/', 'logo', $cell1);
//$cell1->addImage('../../asset/dokumen/foto/logo.png', array('width' => 30, 'height' => 30, 'align' => 'left'), '');;

$table->addCell(8000, array('spacing' => 0, 'spaceBefore' => 0, 'spaceAfter' => 0, 'align' => 'left', 'valign' => 'center'))->addText(
    $sekolah,
    'Judul',
    array('name' => 'Arial', 'size' => 12, 'color' => '1B2232', 'bold' => true)
);

// Row 2
$table->addRow();
$table->addCell(1000, ['vMerge' => 'continue']); // Lanjutkan merge pada kolom pertama
$table->addCell(8000, array('spacing' => 0, 'spaceBefore' => 0, 'spaceAfter' => 0, 'align' => 'left', 'valign' => 'center'))->addText(
    $alamat,
    'Judul',
    array('name' => 'Arial', 'size' => 8, 'color' => '1B2232', 'bold' => false)
);


$rangePeriode = $classBuku->rangePeriode($bulan, $tahun, 'tanggal');

$filterTunai = $classBuku->jenisTunai();
$filterBank = $classBuku->jenisBank();
$filterPajak = $classBuku->jenisPajak();

//$saldo_bku = $classBuku->saldoBulanLalu($periode, $tahun,  $tb_transaksi, '', '1');
$saldo_bku = $classBuku->saldoBulanLalu($bulan, $tahun,  $tb_transaksi, '', '1');
$saldo_tunai = $classBuku->saldoBulanLalu($bulan, $tahun,  $tb_transaksi, "and " . $filterTunai, '2');
$saldo_bank = $classBuku->saldoBulanLalu($bulan, $tahun,  $tb_transaksi, "and " . $filterBank, '3');
$saldo_pajak = $classBuku->saldoBulanLalu($bulan, $tahun,  $tb_transaksi, "and " . $filterPajak, '4');




if ($buku == 1) {
    $jnsBuku = "BUKU KAS UMUM";
    $filterJenis = "";
    $vsaldo = $saldo_bku;
} elseif ($buku == 2) {
    $jnsBuku = "BUKU PEMBANTU KAS TUNAI";
    $filterJenis = "and " . $filterTunai;
    $vsaldo = $saldo_tunai;
} elseif ($buku == 3) {
    $jnsBuku = "BUKU PEMBANTU KAS BANK";
    $filterJenis =  "and " . $filterBank;
    $vsaldo = $saldo_bank;
} elseif ($buku == 4) {
    $jnsBuku = "BUKU PEMBANTU KAS PAJAK";
    $filterJenis =   "and " . $filterPajak;
    $vsaldo = $saldo_pajak;
};


$section->addTextBreak(1.2);

if (strlen($jnsBuku) > 3) {
    $section->addText(
        $jnsBuku,
        'judul',
        'centerStyle'
    );
};

$section->addTextBreak(1);

$styleTable = array('borderSize' => 0, 'borderColor' => 'white', 'cellMargin' => 20);
$styleTableBorder = array('borderSize' => 4, 'borderColor' => 'Black', 'cellMargin' => 0);
$styleFirstRow = array('borderBottomSize' => 0, 'borderBottomColor' => '0000FF', 'bgColor' => 'white');
$styleCell = array('valign' => 'top');
$styleCellBTLR = array('valign' => 'center', 'textDirection' => \PhpOffice\PhpWord\Style\Cell::TEXT_DIR_BTLR);
$fontStyle = array('bold' => false, 'name' => 'Arial', 'size' => 9);
$fontStyleMin = array('italic' => true, 'name' => 'Arial', 'size' => 7);
$paragrafStyle = array('align' => 'center', 'spaceAfter' => 0);

$cellRowSpan = array('vMerge' => 'restart', 'valign' => 'center', 'bgColor' => 'FFFF00');
$cellRowContinue = array('vMerge' => 'continue');
$cellColSpan = array('gridSpan' => 3, 'valign' => 'center', 'align' => 'center');
$cellHCentered = array('align' => 'center');
$cellVCentered = array('valign' => 'center');

$phpWord->addTableStyle('Menimbang', $styleTable, $styleFirstRow);
$phpWord->addTableStyle('ListNama', $styleTableBorder, $styleFirstRow);
$phpWord->addTableStyle('Kepada', $styleTable, $styleFirstRow);


//$table = $section->addTable('Menimbang');
//$table->addRow(40, '');
//$table->addCell(1400, $styleCell)->addText(htmlspecialchars('Periode'), '');
//$table->addCell(250, $styleCell)->addText(htmlspecialchars(':'), $fontStyle);
//$table->addCell(8350, $styleCell)->addText(htmlspecialchars($periode), '');

$section->addText("Periode \t : " . $periode, $fontStyle, array('indent' => 0, 'spaceAfter' => 160));


$section->addTextBreak(0, 9);
$table = $section->addTable('Menimbang');
$table->addRow(350, array('tblHeader' => true));
$table->addCell(450, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('No'), $fontStyle, $paragrafStyle);
$table->addCell(1000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('No Bukti'), $fontStyle, $paragrafStyle);
$table->addCell(1200, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('Tanggal'), $fontStyle, $paragrafStyle);
$table->addCell(6000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('Uraian'), $fontStyle, $paragrafStyle);
$table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('PPh Ps 21'), $fontStyle, array('align' => 'center', 'spaceAfter' => 0));
$table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('PPh Ps 22'), $fontStyle, array('align' => 'center', 'spaceAfter' => 0));
$table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('PPh Ps 23'), $fontStyle, array('align' => 'center', 'spaceAfter' => 0));
$table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('PPh Ps 4'), $fontStyle, array('align' => 'center', 'spaceAfter' => 0));
$table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('PPN'), $fontStyle, array('align' => 'center', 'spaceAfter' => 0));
$table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('Kredit'), $fontStyle, array('align' => 'center', 'spaceAfter' => 0));
$table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('Saldo'), $fontStyle, array('align' => 'center', 'spaceAfter' => 0));

$table->addRow(350, '');
$table->addCell(450, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('-'), 'isi', array('align' => 'center', 'spaceAfter' => 0));
$table->addCell(1000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('-'), 'isi', array('align' => 'center', 'spaceAfter' => 0));
$table->addCell(1200, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('-'), 'isi', array('align' => 'center', 'spaceAfter' => 0));
$table->addCell(6000, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('Saldo Awal'), 'isi', array('align' => 'left', 'spaceAfter' => 0));
$table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($vsaldo)), 'isi', array('align' => 'right', 'spaceAfter' => 0));
$table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('0'), 'isi', array('align' => 'right', 'spaceAfter' => 0));
$table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('0'), 'isi', array('align' => 'right', 'spaceAfter' => 0));
$table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('0'), 'isi', array('align' => 'right', 'spaceAfter' => 0));
$table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('0'), 'isi', array('align' => 'right', 'spaceAfter' => 0));
$table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars('0'), 'isi', array('align' => 'right', 'spaceAfter' => 0));
$table->addCell(1400, array('borderSize' => 0, 'borderColor' => 'Black', 'spaceAfter' => 1, 'align' => 'center', 'valign' => 'center'))->addText(htmlspecialchars($format->ribuan($vsaldo)), 'isi', array('align' => 'right', 'spaceAfter' => 0));


$class = new simakom_laporan();
$format = new format;
//$tanggalkonv = $format->dateToEng($tanggal);
if ($buku == 1) {
    $showList = $class->list_bku_word($tb_transaksi, $bulan, $tahun, $table);
} elseif ($buku == 2) {
    $showList = $class->list_bukuTunai_word($tb_transaksi, $bulan, $tahun, $table);
} elseif ($buku == 3) {
    $showList = $class->list_bukuBank_word($tb_transaksi, $bulan, $tahun, $table);
} elseif ($buku == 4) {
    $showList = $class->list_bukuPajak_word($tb_transaksi, $bulan, $tahun, $table);
} else {
    echo "";
}


$section->addTextBreak(1);

if ($buku == 1) { //Khusus BKU

    $saldoTunai = $classBuku->summarySATunai($tb_transaksi, $bulan, $tahun);
    $saldoBank = $classBuku->summarySABank($tb_transaksi, $bulan, $tahun);

    $section->addText('Pada hari ini ' . $format->hari($tanggal) . ', ' . $format->dateToIndoLong($format->dateToEng($tanggal)) . ', Buku Kas Umum bulan ' . $periode . ' ditutup dengan keadaan / kondisi Buku sebagai berikut : ', 'isi', array('indent' => 0, 'spaceAfter' => 0));
    $section->addTextBreak(1);

    $textrun = $section->addTextRun(array('lineHeight' => 1));
    $textrun->addText("Saldo Buku Kas\t\t\t", 'isi', array('indent' => 0, 'spaceAfter' => 0));
    $textrun->addText(": " . $format->ribuan($classBuku->summarySABKU($tb_transaksi, $bulan, $tahun)), 'isi', array('indent' => 0, 'spaceAfter' => 0));

    $textrun = $section->addTextRun(array('lineHeight' => 1));
    $textrun->addText("Terdiri dari \t :", 'isi', array('indent' => 0, 'spaceAfter' => 0));

    $textrun = $section->addTextRun(array('lineHeight' => 1));
    $textrun->addText("- Saldo Kas Tunai \t\t\t ", 'isi', array('indent' => 0, 'spaceAfter' => 0));
    $textrun->addText(": " . $format->ribuan($saldoTunai), 'isi', array('indent' => 0, 'spaceAfter' => 0));

    $textrun = $section->addTextRun(array('lineHeight' => 1));
    $textrun->addText("- Saldo Kas Bank \t\t\t ", 'isi', array('indent' => 0, 'spaceAfter' => 0));
    $textrun->addText(": " . $format->ribuan($saldoBank), 'isi', array('indent' => 0, 'spaceAfter' => 0));

    $section->addTextBreak(1);
};
$phpWord->addParagraphStyle(
    'tabTTD',
    array('tabs' => array(new \PhpOffice\PhpWord\Style\Tab('right', 5000)))
);

$textrun = $section->addTextRun([
    'spacing' => 0,
    'spaceBefore' => 0,
    'spaceAfter' => 0
]);
$textrun->addText("\t ", 'isi', array('indent' => 0, 'spaceAfter' => 0));
$textrun->addText("Mengetahui, \t\t\t\t\t\t\t\t\t\t\t\t\t\t", 'isi', array('indent' => 0, 'spaceAfter' => 0));
$textrun->addText($clssekolah->dataSekolah('kota') . ", " . $format->dateToIndoLong($format->dateToEng($tanggal)), 'isi', array('indent' => 0, 'spaceAfter' => 0));

$textrun = $section->addTextRun([
    'spacing' => 0,
    'spaceBefore' => 0,
    'spaceAfter' => 0
]);
$textrun->addText("\t ", 'isi', array('indent' => 0, 'spaceAfter' => 0));
$textrun->addText($simakom_atasan_jabatan . " \t\t\t\t\t\t\t\t\t\t\t\t\t\t", 'isi', array('indent' => 0, 'spaceAfter' => 0));
$textrun->addText("Bendahara, ", 'isi', array('indent' => 0, 'spaceAfter' => 0));

$section->addTextBreak(2);

$textrun = $section->addTextRun([
    'spacing' => 0,
    'spaceBefore' => 0,
    'spaceAfter' => 0
]);
$textrun->addText("\t ", 'isi', array('indent' => 0, 'spaceAfter' => 0, 'spaceBefore' => 0));
$textrun->addText($simakom_atasan_nama . " \t\t\t\t\t\t\t\t\t\t\t\t", 'isi', array('indent' => 0, 'spaceAfter' => 0, 'spaceBefore' => 0));
$textrun->addText($simakom_bendahara_nama, 'isi', array('indent' => 0, 'spaceAfter' => 0, 'spaceBefore' => 0));

$textrun = $section->addTextRun([
    'spacing' => 0,
    'spaceBefore' => 0,
    'spaceAfter' => 0
]);
//$textrun->addText("\t ", 'isi', array('indent' => 0, 'spaceAfter' => 0, 'spaceBefore' => 0));
//$textrun->addText("NIP. " . $simakom_atasan_nip . " \t\t\t\t\t\t\t\t\t\t\t\t\t\t", 'isi', array('indent' => 0, 'spaceAfter' => 0, 'spaceBefore' => 0));
//$textrun->addText("NIP. " . $simakom_bendahara_nip, 'isi', array('indent' => 0, 'spaceAfter' => 0, 'spaceBefore' => 0));

if (strlen($simakom_atasan_nip) > 5) {
    $textrun->addText("\t ", 'isi', array('indent' => 0, 'spaceAfter' => 0, 'spaceBefore' => 0));
}
if (strlen($simakom_bendahara_nip) > 5) {
    $textrun->addText("NIP. " . $simakom_bendahara_nip, 'isi', array('indent' => 0, 'spaceAfter' => 0, 'spaceBefore' => 0));
}

$objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
$objWriter->save('view/tmp/' . $jnsBuku . '_' . $periode .  '.docx');
