<?php
set_time_limit(0);
spl_autoload_register(function ($mod) {
    require('../../../../../asset/mod/' . $mod . '.php');
});

// Load file autoload.php
require '../../../../../asset/bootstrap/asset/phpspreadsheet/autoload.php';


date_default_timezone_set('Asia/Jakarta');
$tanggal = mktime(date("m"), date("d"), date("Y"));
$tglsekarang = date("d-m-Y", $tanggal);
$tahunnow = date("Y", $tanggal);

if (isset($_GET['tahun'])) {
    $tahun = $_GET['tahun'];
} else {
    $tahun = $tahunnow;
};
$tahun1 = substr($tahun, 0, 4);
$tahun2 = substr($tahun, 5, 4);

$tahun_tabel = substr($tahun, 2, 2) . substr($tahun, 7, 2);

$tb_siswa = "tb_siswa" . $tahun_tabel;
$tb_transaksi = "db_transaksi" . $tahun_tabel;
$tb_detailakun = "detail_akun" . $tahun_tabel;
$tb_setor = "setor_kjks" .  $tahun_tabel;
$tb_transaksisim = "sim_transaksi" . $tahun_tabel;



if (isset($_GET['jenjang']) && $_GET['jenjang'] != 'Semua') {
    $jenjang_lap = $_GET['jenjang'];
} else {
    $jenjang_lap = "Semua";
};

if (isset($_GET['jenis']) && $_GET['jenis'] != 'Semua') {
    $jenis_lap = $_GET['jenis'];
} else {
    $jenis_lap = "Semua";
};
if (isset($_GET['paralel']) && $_GET['paralel'] != 'Semua') {
    $paralel_lap = $_GET['paralel'];
} else {
    $paralel_lap = "Semua";
};
if (isset($_GET['kategori']) && $_GET['kategori'] != 'Semua') {
    $kategori_lap = $_GET['kategori'];
} else {
    $kategori_lap = "Semua";
};

if (isset($_GET['status']) && $_GET['status'] != 'Semua') {
    $status_lap = $_GET['status'];
} else {
    $status_lap = "Semua";
};


$optVal = new lembaga();

if (isset($_GET['bulan1'])) {
    $bulan1 = $_GET['bulan1'];
    $v_bulan1 = $optVal->ValPeriode($bulan1, $tahun1, $tahun2);
} else {
    $bulan1 = 1;
    $v_bulan1 = "'----";
};

if (isset($_GET['bulan2'])) {
    $bulan2 = $_GET['bulan2'];
    $v_bulan2 = $optVal->ValPeriode($bulan2, $tahun1, $tahun2);
} else {
    $bulan2 = 1;
    $v_bulan2 = "'----";
};
$jml_bulan = @($bulan2 - $bulan1) + 1;


if ($jml_bulan == 1) {
    $periode = $v_bulan1;
    $jml_bulan = 1;
} elseif ($jml_bulan < 1) {
    $periode = "'-##-";
    $jml_bulan = 1;
} else {
    $periode = $v_bulan1 . " - " . $v_bulan2;
    $jml_bulan = $jml_bulan;
};

$dt_jenis = new namaBayar();
$showJenis = $dt_jenis->shownamaBayar($tahun, $jenis_lap, $jenjang_lap);
$count_nb = $showJenis->rowCount();
$datajenis = $showJenis->fetch(PDO::FETCH_OBJ);
if ($count_nb > 0) {
    $namaBayar = $datajenis->nama;
} else {
    $namaBayar = "Semua";
};


//Query Tanggungan
$classTanggungan = new listTanggungan();



//Indo to Egg
function ubahformatTgl($tanggal)
{
    $pisah = explode('-', $tanggal);
    $urutan = array($pisah[2], $pisah[1], $pisah[0]);
    $satukan = implode('-', $urutan);
    return $satukan;
}
// Cara penggunaan function ubahTgl
$clssekolah = new sekolah;

// Include librari PhpSpreadsheet
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spreadsheet = new Spreadsheet();
$sheet1 = $spreadsheet->setActiveSheetIndex(0);

$spreadsheet->getActiveSheet()->getPageSetup()->setOrientation(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_PORTRAIT);
$spreadsheet->getActiveSheet()->getPageSetup()->setPaperSize(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4);
$spreadsheet->getActiveSheet()->getPageMargins()->setTop(1);
$spreadsheet->getActiveSheet()->getPageMargins()->setLeft(1);
$spreadsheet->getActiveSheet()->getPageMargins()->setRight(1);
$spreadsheet->getActiveSheet()->getPageMargins()->setBottom(1);
// Buat sebuah variabel untuk menampung pengaturan style dari header tabel
$style_judul = [
    'font' => ['bold' => true], // Set font nya jadi bold
    'font-family' => ['Arial'], // Set font nya jadi bold
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],

];
$style_col = [
    'font' => ['bold' => true], // Set font nya jadi bold
    'font-family' => ['Arial'], // Set font nya jadi bold
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
    ]
];

// Buat sebuah variabel untuk menampung pengaturan style dari isi tabel
$style_row = [
    'font-family' => ['Arial'], // Set font nya jadi bold
    'alignment' => [
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
    ]
];


$sheet1->getStyle('A1')->getFont()->setBold(true);
$sheet1->getStyle('A1')->getFont()->setSize(15);
$sheet1->getStyle('A1:F1000')->getFont()->setName('Arial');

//for ($i = 'A'; $i !=  $sheet1->getHighestColumn(); $i++) {
//    $sheet1->getColumnDimension($i)->setAutoSize(TRUE);
//}
$sheet1->getColumnDimension('A')->setWidth(5);
$sheet1->getColumnDimension('B')->setWidth(25);
$sheet1->getColumnDimension('C')->setWidth(10);
$sheet1->getColumnDimension('D')->setWidth(10);
$sheet1->getColumnDimension('E')->setWidth(10);
$sheet1->getColumnDimension('F')->setWidth(15);
$sheet1->getColumnDimension('G')->setWidth(15);
$sheet1->getColumnDimension('H')->setWidth(15);

$sheet1->setCellValue('A1', 'LAPORAN BULANAN [TP. ' . $tahun . ']');
$sheet1->setCellValue('A2', $clssekolah->dataSekolah('sekolah'));
$sheet1->mergeCells('A1:H1');
$sheet1->mergeCells('A2:H2');

$sheet1->setCellValue('A4', 'Kelas');
$sheet1->setCellValue('A5', 'Jenis Pembayaran');
$sheet1->setCellValue('A6', 'Periode');

$sheet1->setCellValue('C4', ': ' . $jenjang_lap . "-" . $paralel_lap);
$sheet1->setCellValue('C5', ': ' . $jenis_lap . " - " . $namaBayar);
$sheet1->setCellValue('C6', ': ' . $periode);

$sheet1->setCellValue('H7', 'Tgl Cetak : ' . $tglsekarang);
$sheet1->getStyle('H7')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
$sheet1->getStyle('H7')->getFont()->setSize(8);
// Buat header tabel nya pada baris ke 3
$sheet1->setCellValue('A8', 'No');
$sheet1->setCellValue('B8', 'Nama');
$sheet1->setCellValue('C8', 'NIS');
$sheet1->setCellValue('D8', 'Kelas');
$sheet1->setCellValue('E8', 'Jml  Bulan');
$sheet1->setCellValue('F8', 'Tanggungan');
$sheet1->setCellValue('G8', 'Terbayar');
$sheet1->setCellValue('H8', 'Kurang');

// Apply style header yang telah kita buat tadi ke masing-masing kolom header
$sheet1->getStyle('A1:H1')->applyFromArray($style_judul);
$sheet1->getStyle('A2:H2')->applyFromArray($style_judul);

$spreadsheet->getActiveSheet(1)->getStyle('A8:H8')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('d5dbdb');
$sheet1->getStyle('A8:H8')->applyFromArray($style_row);
// Set height baris ke 1, 2 dan 3
$sheet1->getRowDimension('1')->setRowHeight(20);


// Buat query untuk menampilkan semua data siswa

$classLaporan = new laporan();
$format = new format();

$showList = $classLaporan->showRekap($tb_siswa, $jenjang_lap, $paralel_lap, $kategori_lap, $status_lap, 'jenjang asc, paralel asc, nama asc');
$count_siswa = $showList->rowCount();
$no = 0; // Untuk penomoran tabel, di awal set dengan 1
$row = 8;
$row_end = $row + $count_siswa;
$row_jumlah = $row + $count_siswa + 1;
while ($data = $showList->fetch(PDO::FETCH_OBJ)) {

    $nis = $data->nis;
    $id = $data->id;
    $nama = $data->nama;
    $jenjang = $data->jenjang;
    $startAt = $data->startAt;
    $pembagi = 13 - $startAt;
    $paralel = $data->paralel;
    $kelas = $jenjang . '-' . $paralel;

    $classTanggungan = new listTanggungan();
    $val_tang = $classTanggungan->tanggunganByKodeOnPeriode($tahun, $jenjang, $tb_siswa, 'id', $id, $jenis_lap);
    if ($val_tang == "" || $val_tang  == 0) {
        $tanggungan = 0;
        $v_tanggungan = 0;
    } else {
        $tanggungan = $format->ribuan($val_tang);
        $v_tanggungan = $val_tang;
    };

    //tanggungan : jumlah bulan
    // $tanggungan = number_format(($v_tanggungan / $pembagi) * $jml_bulan, 0, ".", ".");
    $tanggungan = $classTanggungan->tanggunganBulanan($tahun, $jenjang, $tb_siswa, $id, $jenis_lap, $bulan1, $bulan2);
    //Terbayar & Kurang
    $classTrans = new transaksi();
    $Terbayar = $classTrans->infoterbayarOnTahapAllJenis($tahun, $jenjang, $tb_transaksi, $nis, $jenis_lap, $bulan1, $bulan2);
    $terbayar = @($format->ribuan($Terbayar));
    //$kurang = (($v_tanggungan / $pembagi) * $jml_bulan) - $Terbayar;
    $kurang = @(($tanggungan - $Terbayar));


    $no++;
    $row++;
    $sheet1->setCellValue('A' . $row, $no);
    $sheet1->setCellValue('B' . $row, $format->entityEncode($nama));
    $sheet1->setCellValue('C' . $row, $nis);
    $sheet1->setCellValue('D' . $row, $kelas);
    $sheet1->setCellValue('E' . $row, $jml_bulan);
    $sheet1->setCellValue('F' . $row, $tanggungan);
    $sheet1->setCellValue('G' . $row, $Terbayar);
    $sheet1->setCellValue('H' . $row, $kurang);

    $sheet1->getStyle('A' . $row . ':A' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet1->getStyle('B' . $row . ':B' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
    $sheet1->getStyle('C' . $row . ':C' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet1->getStyle('D' . $row . ':D' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet1->getStyle('E' . $row . ':E' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
    $sheet1->getStyle('F' . $row . ':F' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
    $sheet1->getStyle('G' . $row . ':G' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
    $sheet1->getStyle('H' . $row . ':H' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

    $sheet1->getStyle('A1:H' . $row_end)->getFont()->setName('Arial');
    $sheet1->getStyle('A9:H' . $row_end)->getFont()->setSize(10);

    $sheet1->getStyle('A' . $row . ':A' . $row_end)->applyFromArray($style_row);
    $sheet1->getStyle('B' . $row . ':B' . $row_end)->applyFromArray($style_row);
    $sheet1->getStyle('C' . $row . ':C' . $row_end)->applyFromArray($style_row);
    $sheet1->getStyle('D' . $row . ':D' . $row_end)->applyFromArray($style_row);
    $sheet1->getStyle('E' . $row . ':E' . $row_end)->applyFromArray($style_row);
    $sheet1->getStyle('F' . $row . ':F' . $row_end)->applyFromArray($style_row);
    $sheet1->getStyle('G' . $row . ':G' . $row_end)->applyFromArray($style_row);
    $sheet1->getStyle('H' . $row . ':H' . $row_end)->applyFromArray($style_row);
}

$sheet1->setCellValue('A' . $row_jumlah, 'JUMLAH');
$sheet1->mergeCells('A' . $row_jumlah . ':E' . $row_jumlah);

$sheet1->setCellValue('F' . $row_jumlah, '=SUM(F9:F' . $row_end . ')');
$sheet1->setCellValue('G' . $row_jumlah, '=SUM(G9:G' . $row_end . ')');
$sheet1->setCellValue('H' . $row_jumlah, '=SUM(H9:H' . $row_end . ')');

$sheet1->getStyle('A' . $row . ':A' . $row_jumlah)->applyFromArray($style_row);
$sheet1->getStyle('B' . $row . ':B' . $row_jumlah)->applyFromArray($style_row);
$sheet1->getStyle('C' . $row . ':C' . $row_jumlah)->applyFromArray($style_row);
$sheet1->getStyle('D' . $row . ':D' . $row_jumlah)->applyFromArray($style_row);
$sheet1->getStyle('E' . $row . ':E' . $row_jumlah)->applyFromArray($style_row);
$sheet1->getStyle('F' . $row . ':F' . $row_jumlah)->applyFromArray($style_row);
$sheet1->getStyle('G' . $row . ':G' . $row_jumlah)->applyFromArray($style_row);
$sheet1->getStyle('H' . $row . ':H' . $row_jumlah)->applyFromArray($style_row);

$sheet1->getStyle('E' . $row . ':E' . $row_jumlah)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
$sheet1->getStyle('F' . $row . ':F' . $row_jumlah)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
$sheet1->getStyle('G' . $row . ':G' . $row_jumlah)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
$sheet1->getStyle('H' . $row . ':H' . $row_jumlah)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

$sheet1->getStyle('A' . $row_jumlah . ':H' . $row_jumlah)->getFont()->setName('Arial');
$sheet1->getStyle('A' . $row_jumlah . ':H' . $row_jumlah)->getFont()->setSize(10);

$spreadsheet->getActiveSheet()->setTitle("Laporan");
// Proses file excel
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="Laporan Bulanan.xlsx"'); // Set nama file excel nya
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
