<style>
    /* Styling untuk spinner */
    #loadingSpinner {
        display: none;
        /* Default disembunyikan */
        position: fixed;
        left: 50%;
        top: 50%;
        transform: translate(-50%, -50%);
        font-size: 18px;
        text-align: center;
        color: #4cdf14;

    }

    /* Style untuk elemen spinner */
    #loadingSpinner .spinner {
        border: 4px solid #f3fbf0;
        /* Warna latar belakang spinner */
        border-top: 4px solid #4cdf14;
        /* Warna bagian atas spinner */
        border-radius: 50%;
        width: 30px;
        height: 30px;
        animation: spin 1s linear infinite;
        /* Animasi berputar */
        margin: 0 auto 10px;
        /* Centering */
    }
</style>
<div class="content-wrapper">

    <?php require('./layout/headerpage.php'); ?>

    <div class="container col-12 mb-2 pb-5">
        <div class="row">
            <div class="col-12">
                <div class="col-12">
                    <div class="card  mx-3">
                        <div class="timeline-header bg-primary py-2 pl-2">
                            <b class="text-light judul"><span class="bi bi-people"></span> Data Siswa & Tanggungan </b>

                        </div>

                        <!-- /.card-header -->
                        <div class="card-body my-2 mx-4">

                            <div class="row mt-2">

                                <div class="div d-inline">
                                    <a <?php echo $link->page('seting/siswa/siswa_create'); ?> class="btn btn-primary btn-xs mb-2 btn-rounded small px-2"> <i class="bi bi-person-plus"></i> TAMBAH</a>
                                    <button id="deleteSelected" class="btn btn-primary btn-xs mb-2 btn-rounded small px-2"> <i class="bi bi-trash"></i> HAPUS</button>
                                </div>
                                <div class="div d-inline ml-1">
                                    <?php $modal->linkModal('view/seting/siswa/modal_siswa', 'deleteAll', 'trash', 'KOSONGKAN DATA', 'primary'); ?>
                                    <a <?php echo $link->page('seting/siswa/editmulti/select'); ?> class="btn btn-primary btn-xs mb-2 btn-rounded small"> <i class="bi bi-pencil-square"></i> EDIT TANGGUNGAN MULTI</a>

                                </div>

                            </div>
                            <div class="row mb-2 float-right">
                                <div class="float-right ">
                                    <a <?php echo $link->page('seting/siswa/kategori/read'); ?> class="btn btn-primary btn-xs mb-2 btn-rounded small"> <i class="bi bi-person-plus"></i> KATEGORI SISWA</a>
                                    <?php
                                    // $modal->linkModal('view/seting/siswa/modal_siswa', 'generateID', 'qr-code', 'GENERATE ID', 'primary');
                                    echo $link->exportXlsx('seting/siswa/siswa_export', $tb_siswa);
                                    ?>
                                    <a <?php echo $link->page('seting/siswa/siswa_import'); ?> class="btn btn-primary btn-xs mb-2 btn-rounded small px-2"> <i class="bi bi-file-earmark-excel"></i> UPLOAD</a>
                                    <!--
                                    <button id="exportButtonXlsx" class="btn btn-primary btn-xs mb-2 btn-rounded small px-2"><i class='bi bi-file-earmark-x'></i> EXCEL</button>
-->
                                </div>


                            </div>
                            <div class="row">
                                <div id="loadingSpinner">
                                    <div class="spinner"></div>
                                    <div class="loading-text">Sedang Proses Download...</div>
                                </div>
                            </div>
                            <!--
                            <div class="row float-left">
                                <label class="col-lg-2 col-sm-12 col-form-label text-primary mt-0 ">View </label>
                                <div class="col-lg-2 col-sm-12">
                                    <select id="limit" class="form-control form-control-sm fontInput small">

                                        <option value="50">50</option>
                                        <option value="100">100</option>
                                        <option value="200">200</option>
                                        <option value="500">500</option>
                                        <option value="1000">1000</option>

                                    </select>
                                </div>

                                <label class="col-lg-3 col-sm-12 col-form-label text-primary mt-0">Cari Siswa </label>
                                <div class="col-lg-5 col-sm-12 mb-3">
                                    <input type="text" id="search" placeholder="Nama atau NIS" class="form-control form-control-sm fontInput">
                                </div>

                            </div>
-->
                            <div class="row mt-2">
                                <label class="col-lg-1 col-sm-12 col-form-label text-primary mt-0 ">View </label>
                                <div class="col-lg-1 col-sm-12">
                                    <select id="limit" class="form-control form-control-sm fontInput small">
                                        <option value="100">100</option>
                                        <option value="200">200</option>
                                        <option value="500">500</option>
                                        <option value="1000">1000</option>

                                    </select>
                                </div>

                                <label class="col-lg-1 col-sm-12 col-form-label text-primary mt-0">Cari Siswa </label>
                                <div class="col-lg-3 col-sm-12">
                                    <input type="text" id="search" placeholder="Nama atau NIS" class="form-control form-control-sm fontInput">
                                </div>

                            </div>
                            <table class="table table-condensed table-sm mb-4 mt-3">
                                <thead>
                                    <tr>
                                        <th><input type='checkbox' id='checkAll' class='small'></th>
                                        <th>Edit</th>
                                        <th>NIS</th>
                                        <th>Nama Siswa</th>
                                        <th>Kelas</th>
                                        <th>Telpon</th>
                                        <th>Pilih->Bayar</th>
                                        <th>Buku Pembayaran</th>
                                        <!--  <th>Foto</th>-->
                                    </tr>
                                </thead>
                                <tbody id="dataTable"></tbody>
                            </table>
                            <div id="spinner">
                                <img src="../../asset/dokumen/foto/spinner2.gif" width="60" height="60" />
                                <p class="text-success"><i>Sedang memuat Data...</i></p>
                            </div>
                            <div id="recordInfo" class="mb-2"></div>
                            <div id="pagination"></div>



                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>


<script>
    $(document).ready(function() {
        $('#spinner').show();
        const loadData = (page = 1, limit = 50, search = '') => {
            $.ajax({
                url: 'view/seting/siswa/fetch/fetch_siswa_read.php',
                type: 'GET',
                data: {
                    page,
                    limit,
                    search
                },
                success: function(data) {
                    const {
                        rows,
                        pagination,
                        totalRecords
                    } = JSON.parse(data);
                    $('#dataTable').html(rows);
                    $('#pagination').html(pagination);
                    $('#recordInfo').text(`Record : ${totalRecords} `);
                    $('#spinner').hide();
                }
            });
        };

        $('#limit').change(function() {
            loadData(1, $(this).val(), $('#search').val());
        });

        $('#pagination').on('click', 'a', function(e) {
            e.preventDefault();
            const page = $(this).data('page');
            const limit = $('#limit').val();
            loadData(page, limit, $('#search').val());
        });

        $('#checkAll').click(function() {
            $('input[name="selectRow"]').prop('checked', this.checked);
        });

        $('#deleteSelected').click(function() {
            const ids = $('input[name="selectRow"]:checked').map(function() {
                return $(this).val();
            }).get();
            if (ids.length) {
                $.post('view/seting/siswa/fetch/fetch_siswa_delete.php', {
                    ids
                }, function(response) {
                    //loadData(1, $('#limit').val(), $('#search').val());
                    const res = JSON.parse(response);
                    alert(res.message);
                    location.reload();
                });
            } else {
                alert('Tidak Ada Data yang dipilih');
            }
        });

        $('#exportButtonXlsx').click(function() {
            $('#loadingSpinner').show(); // Tampilkan spinner

            $.ajax({
                url: 'view/seting/siswa/fetch/export_siswa.php',
                type: 'POST',
                xhrFields: {
                    responseType: 'blob' // Mengatur respon sebagai file blob
                },
                success: function(data) {
                    // Buat objek URL dari blob
                    const blob = new Blob([data], {
                        type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                    });
                    const url = window.URL.createObjectURL(blob);

                    // Buat link untuk mengunduh file
                    const a = document.createElement('a');
                    a.href = url;
                    a.download = 'Data Siswa dan Tanggungan.xlsx';
                    document.body.appendChild(a);
                    a.click();

                    // Hapus link dan URL sementara
                    window.URL.revokeObjectURL(url);
                    $('#loadingSpinner').hide(); // Sembunyikan spinner
                },
                error: function() {
                    alert('Terjadi kesalahan saat mengekspor data.');
                    $('#loadingSpinner').hide(); // Sembunyikan spinner
                }
            });
        });


        $('#search').keyup(function() {
            loadData(1, $('#limit').val(), $(this).val());
        });

        loadData();
    });
</script>