<?php

error_reporting(1);
require_once "../../../../../asset/mod/autoLoad.php";
require_once "../../../layout/conn.php";
require_once "../../../layout/session.php";

$crud = new crudData;
$link = new linkpage;
$setor = new setor();
$format = new format();
$modal = new modal();


$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 5;
$search = isset($_GET['search']) ? $_GET['search'] : '';
$offset = ($page - 1) * $limit;
$orderBy = isset($_GET['orderBy']) ? $_GET['orderBy'] : 'tanggal_draf';
$orderDir = isset($_GET['orderDir']) && $_GET['orderDir'] === 'ASC' ? 'ASC' : 'DESC';

$idUser = isset($_GET['idUser']) ? $_GET['idUser'] : '';
$level = $crud->getValue('user', "where id='$idUser'", 'level');
if ($level == "admin") {
    $filterUser = "";
} else {
    $filterUser = "and penyetor='$idUser'";
};

// Pastikan kolom yang digunakan valid untuk mencegah SQL Injection
$validColumns = ['tanggal_draf', 'setor_status'];
if (!in_array($orderBy, $validColumns)) {
    $orderBy = 'tanggal_draf';
}

//$query = "SELECT  * FROM  $tb_transaksi WHERE nama LIKE :search || nis LIKE :search order by tanggal desc, jenjang asc, paralel asc, nama asc LIMIT :limit OFFSET :offset";
$query = "SELECT  * FROM  $tb_setor WHERE tanggal_draf LIKE :search $filterUser order by $orderBy $orderDir  LIMIT :limit OFFSET :offset";

$stmt = $pdo->prepare($query);
$stmt->bindValue(':search', "%$search%", PDO::PARAM_STR);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();

//$datas = $stmt->fetchAll(PDO::FETCH_ASSOC);
$datas = $stmt->fetchAll(PDO::FETCH_OBJ);

$total = $pdo->prepare("SELECT COUNT(*) FROM $tb_setor WHERE tanggal_draf LIKE :search");
$total->bindValue(':search', "%$search%", PDO::PARAM_STR);
$total->execute();
$totalRows = $total->fetchColumn();
$totalPages = ceil($totalRows / $limit);

$rows = '';
foreach ($datas as $data) {

    $tanggal = $format->dateToIndo($data->tanggal_draf);

    $penyetor = $crud->getValue('user', "where id='$data->penyetor'", 'nama');
    //
    $jumlahDraf = ($setor->jumlah($tb_transaksi, 'jumlah', "where id_setor='" . $data->id_setor . "'"));
    $jumlahSetor = $format->ribuan($setor->jumlah($tb_transaksi, 'jumlah',  "where setor>='2' and id_setor='" . $data->id_setor . "'"));

    $status = $setor->statusSetor($data->setor_status);
    if ($data->metode == 2) {
        $metode = "Bank";
    } else {
        $metode = "Tunai";
    };

    $recordTr = $crud->countData($tb_transaksi, "where id_setor='" . $data->id_setor . "'");


    if ($jumlahDraf > 0 and $data->setor_status < 2) {
        $prosesBtn = "<form name='proses' action='" . $link->pageAction('setor/setor_page_proses') . "' method='post'>
            <input name='id_setor' value='" . $data->id_setor . "' hidden>
            <input name='tahun' value='" . $tahun . "' hidden>
            <button type='submit' class='btn btn-default btn-xs'><i class='bi bi-arrow-clockwise text-success'></i><b class='text-success'> PROSES</b></button>
            </form>";
        $printPeng = "---";
    } elseif ($jumlahSetor > 0 and $data->setor_status == 2) {
        $prosesBtn = "";
        $printPeng = "<form name='cetak' action='" . $link->pageAction('setor/print_preview') . "' method='post'>
            <input name='id_setor' value='" . $data->id_setor . "' hidden>
            <input name='tahun' value='" . $tahun . "' hidden>
            <button type='submit' class='btn btn-default btn-xs'><i class='bi bi-printer text-primary'></i><b class='text-primary'> CETAK</b></button>
            </form>";
    } else {
        $prosesBtn = "<i class='text-danger'>Locked</>";
        $printPeng = "<form name='cetak' action='" . $link->pageAction('setor/print_preview') . "' method='post'>
            <input name='id_setor' value='" . $data->id_setor . "' hidden>
            <input name='tahun' value='" . $tahun . "' hidden>
            <button type='submit' class='btn btn-default btn-xs'><i class='bi bi-printer text-primary'></i><b class='text-primary'> CETAK</b></button>
            </form>";
    };

    if ($jumlahSetor > 0 and $data->setor_status == 2) {
        $batalBtn = "<form name='batal' action='" . $link->pageAction('setor/setor_page_batal') . "' method='post'>
            <input name='id_setor' value='" . $data->id_setor . "' hidden>
            <input name='tahun' value='" . $tahun . "' hidden>
            <button type='submit' class='btn btn-default btn-xs'><i class='bi bi-arrow-left-circle-fill text-danger'></i><b class='text-danger'> BATAL</b></button>
            </form>";
    } else {
        $batalBtn = "";
    };


    $no++;
    $rows .= "<tr>";
    $rows .= "<td width='5px'>$no</td>";
    $rows .= "<td align=left>" . $format->dateToIndo($data->tanggal_draf) . "</td>";
    $rows .= "<td align=left>" . strtoupper($data->id_setor) . "</td>";
    $rows .= "<td align=left>$penyetor</td>";
    $rows .= "<td align=left>$data->id_rkas</td>";
    $rows .= "<td align=right>" . $format->ribuan($jumlahDraf) . "</td>";
    $rows .= "<td align=right>$jumlahSetor</td>";
    $rows .= "<td align=left>$recordTr Transaksi</td>";
    $rows .= "<td align=left>$metode</td>";
    $rows .= "<td align=left>$status</td>";
    $rows .= "<td align=left><div style='display: flex; gap: 5px;'>$prosesBtn $batalBtn</div></td>";
    $rows .= "<td align=left>$printPeng</td>";
    $rows .= "</tr>";
}

$pagination = '';
for ($i = 1; $i <= $totalPages; $i++) {
    if ($page == $i) {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-primary mx-1 my-1 " data-page="' . $i . '">' . $i . '</a> ';
    } else {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-default mx-1 my-1 " data-page="' . $i . '">' . $i . '</a> ';
    };
}

echo json_encode(['rows' => $rows, 'pagination' => $pagination, 'totalRecords' => $totalRows]);
