<div class="content-wrapper">

    <?php require('./layout/headerpage.php'); ?>

    <div class="container col-12 mb-4 pb-5">
        <div class="row">
            <div class="col-12">
                <div class="col-12">
                    <div class="card  mx-3">
                        <div class="timeline-header bg-primary py-2 pl-2">
                            <b class="text-light judul"><span class="bi bi-person-bounding-box"></span> Data Nasabah</b>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body my-4 mx-4">
                            <div class="row float-right">
                                <div class="div d-inline mt-3">
                                    <a <?php echo $link->page('nasabah/nasabah_create'); ?> class="btn btn-primary btn-xs mb-2 btn-rounded small px-2"> <i class="bi bi-person-plus"></i> TAMBAH (Siswa)</a>
                                    <a <?php echo $link->page('nasabah/nasabah_create_umum'); ?> class="btn btn-primary btn-xs mb-2 btn-rounded small px-2"> <i class="bi bi-person-plus"></i> TAMBAH (Umum)</a>

                                    <a <?php echo $link->page('nasabah/nasabah_import'); ?> class="btn btn-primary btn-xs mb-2 btn-rounded small px-2"> <i class="bi bi-upload"></i> UPLOAD NASABAH</a>
                                    <?php echo $link->exportXlsx('nasabah/nasabah_export', $tahun); ?>
                                    <button id="deleteSelected" class="btn btn-primary btn-xs mb-2 btn-rounded small px-2"> <i class="bi bi-trash"></i> HAPUS</button>
                                </div>
                            </div>
                            <div class="row ">
                                <label class="col-lg-1 col-sm-12 col-form-label text-primary mt-0 ">View </label>
                                <div class="col-lg-1 col-sm-12">
                                    <select id="limit" class="form-control form-control-sm fontInput small">

                                        <option value="50">50</option>
                                        <option value="100">100</option>
                                        <option value="200">200</option>
                                        <option value="500">500</option>
                                        <option value="1000">1000</option>

                                    </select>
                                </div>

                                <label class="col-lg-1 col-sm-12 col-form-label text-primary mt-0">Cari Nasabah </label>
                                <div class="col-lg-5 col-sm-12 mb-3">
                                    <input type="text" id="search" placeholder="Nama || NIS || Rekening" class="form-control form-control-sm fontInput">
                                </div>

                            </div>
                            <table class="table table-condensed table-hover table-sm mb-4 mt-3">
                                <thead>
                                    <tr>
                                        <th><input type='checkbox' id='checkAll' class='small'></th>
                                        <th>Aksi</th>
                                        <th>NIS</th>
                                        <th>Nama Nasabah</th>
                                        <th>No. Rekening</th>
                                        <th>Kelas</th>
                                        <th>Saldo Awal</th>
                                        <th>Debet</th>
                                        <th>Kredit</th>
                                        <th>Saldo Akhir</th>
                                        <th>Status</th>
                                        <th width='120'>Rekam Transaksi</th>
                                        <th width='120'>Buku Tabungan</th>
                                    </tr>
                                </thead>
                                <tbody id="dataTable"></tbody>
                            </table>
                            <div id="spinner">
                                <img src="../../asset/dokumen/foto/spinner2.gif" width="60" height="60" />
                                <p class="text-success"><i>Sedang memuat Data...</i></p>
                            </div>
                            <div id="recordInfo" class="mb-2"></div>
                            <div id="pagination"></div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>


<script>
    $(document).ready(function() {
        $('#spinner').show();
        const loadData = (page = 1, limit = 50, search = '') => {
            $.ajax({
                url: 'view/nasabah/fetch/fetch_nasabah_read.php',
                type: 'GET',
                data: {
                    page,
                    limit,
                    search
                },
                success: function(data) {
                    const {
                        rows,
                        pagination,
                        totalRecords
                    } = JSON.parse(data);
                    $('#dataTable').html(rows);
                    $('#pagination').html(pagination);
                    $('#recordInfo').text(`Record : ${totalRecords} `);
                    $('#spinner').hide();
                }
            });
        };

        $('#limit').change(function() {
            loadData(1, $(this).val(), $('#search').val());
        });

        $('#pagination').on('click', 'a', function(e) {
            e.preventDefault();
            const page = $(this).data('page');
            const limit = $('#limit').val();
            loadData(page, limit, $('#search').val());
        });

        $('#checkAll').click(function() {
            $('input[name="selectRow"]').prop('checked', this.checked);
        });

        $('#deleteSelected').click(function() {
            const ids = $('input[name="selectRow"]:checked').map(function() {
                return $(this).val();
            }).get();
            if (ids.length) {
                $.post('view/nasabah/fetch/fetch_nasabah_delete.php', {
                    ids
                }, function(response) {
                    // loadData(1, $('#limit').val(), $('#search').val());
                    const res = JSON.parse(response);
                    alert(res.message);
                    location.reload();
                });
            } else {
                alert('Tidak Ada Data yang dipilih');
            }
        });



        $('#search').keyup(function() {
            loadData(1, $('#limit').val(), $(this).val());
        });

        loadData();
    });
</script>


<?php
//$ajax = new ajax;
//$output = $ajax->loadData("view/nasabah/fetch/fetch_nasabah_read.php", "", "view/nasabah/fetch/fetch_nasabah_delete.php");
