DROP TABLE IF EXISTS `sekolah`;

CREATE TABLE IF NOT EXISTS `sekolah` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `sekolah` varchar(200) NOT NULL,
  `alamat` varchar(150) NOT NULL,
  `kota` varchar(20) NOT NULL,
  `jenjang` varchar(4) NOT NULL,
  `nama_kuitansi` varchar(25) NOT NULL,
  `info_kuitansi` varchar(10) NOT NULL,
  `info_tahap` varchar(10) NOT NULL,
  `info_kettrans` varchar(20) NOT NULL,
  `bg` varchar(10) NOT NULL,
  `menu` varchar(5) NOT NULL,
  `versi` varchar(10) NOT NULL,
  `bg_color` varchar(20) NOT NULL,
  `nama_pimpinan` varchar(100) NOT NULL,
  `pimpinan` varchar(50) NOT NULL,
  `model_kw` varchar(20) NOT NULL,
  `startPeriode` varchar(20) NOT NULL,
  `tgl_backup` date NOT NULL,
  `kops1` text NOT NULL,
  `kops2` text NOT NULL,
  `simakom_bendahara_nama` varchar(250) NOT NULL,
  `simakom_bendahara_nip` varchar(18) NOT NULL,
  `simakom_atasan_nama` varchar(250) NOT NULL,
  `simakom_atasan_nip` varchar(118) NOT NULL,
  `simakom_atasan_jabatan` varchar(250) NOT NULL,
  `simakom_atasan2_nama` varchar(250) NOT NULL,
  `simakom_atasan2_jabatan` varchar(250) NOT NULL,
  `simakom_ppk_nama` varchar(200) NOT NULL,
  `simakom_ppk_nip` varchar(18) NOT NULL,
  `simakom_ppk_jabatan` varchar(200) NOT NULL,
  `notice` text DEFAULT NULL,
  `notice2` text DEFAULT NULL,
  `tk` text DEFAULT NULL,
  `tp` varchar(10) NOT NULL,
  `webaddress` text NOT NULL,
  `aksesteller` varchar(5) NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `sekolah` (`no`, `sekolah`, `alamat`, `kota`, `jenjang`, `nama_kuitansi`, `info_kuitansi`, `info_tahap`, `info_kettrans`, `bg`, `menu`, `versi`, `bg_color`, `nama_pimpinan`, `pimpinan`, `model_kw`, `startPeriode`, `tgl_backup`, `kops1`, `kops2`, `simakom_bendahara_nama`, `simakom_bendahara_nip`, `simakom_atasan_nama`, `simakom_atasan_nip`, `simakom_atasan_jabatan`, `simakom_atasan2_nama`, `simakom_atasan2_jabatan`, `simakom_ppk_nama`, `simakom_ppk_nip`, `simakom_ppk_jabatan`, `notice`, `notice2`, `tk`, `tp`, `webaddress`, `aksesteller`, `id`) VALUES
	(1,'SD PANATAGAMA ISLAMIC SCHOOL','Jl. Darmodiharjo No.23a Sukamelang Subang','Subang','SD','Nama Siswa','ya','ya','no','primary','','','primary','Adi Dwi Wibowo, B.Eng','Kepala Sekolah','6','1','2024-12-09','','','Tina Inayati, S.Pd','12345678','Adi Dwi Wibowo, B.Eng','12345678','Kepala Sekolah','','','','','','Jika ada ketidaksesuaian data, dimohon untuk segera menginformasikan kepada admin dan Kami sangat berterimakasih jika Ayah/Bunda melakukan pembayaran tepat waktu ..','','TERIMA KASIH','2025/2026','http://aks.panatagama.sch.id/sd','no','4C88C222085FD72DE2D7BC1376625660');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `serial`;

CREATE TABLE IF NOT EXISTS `serial` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `sekolah` varchar(200) NOT NULL,
  `seri` varchar(100) NOT NULL,
  `aktivasi` varchar(100) NOT NULL,
  `tanggal` date NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `serial` (`no`, `sekolah`, `seri`, `aktivasi`, `tanggal`, `id`) VALUES
	(1,'SD PANATAGAMA ISLAMIC SCHOOL','004ED2-C2770S-D254A8-BC8ED2-327002','CAB8DD3C07C3784E7ED65A546B24280494698C864FE8DFD7441','2024-12-09','4C88C222085FD72DE2D7BC1376625660');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `user`;

CREATE TABLE IF NOT EXISTS `user` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` varchar(20) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `kelamin` varchar(1) NOT NULL,
  `email` varchar(120) NOT NULL,
  `hp` varchar(18) NOT NULL,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `level` varchar(20) NOT NULL,
  `status` varchar(10) NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `user` (`no`, `id_user`, `nama`, `kelamin`, `email`, `hp`, `username`, `password`, `level`, `status`, `id`) VALUES
	(11,'9J2mFH','Admin','L','admin@gmail.com','0888888888','admin','e10adc3949ba59abbe56e057f20f883e','admin','Aktif','e3afed0047b08059d0fada10f400c1e5'),
	(26,'d0f83653fdb01ed928a4','Tabungan','P','','','tabungan','c1b1f59dbfe51b882c8b0dd09c86c1ca','tabungan','Aktif','af4b8e6465fbf4f079aea603e326b2ef'),
	(27,'606ef979469528e637f6','Tina inayati S.Pd','P','','','bendahara','c9ccd7f3c1145515a9d3f7415d5bcbea','bendahara','Aktif','a9bfc5bbfa36aac4a183ba4f4726e6c3'),
	(28,'4bc2be4245c022748235','Adi Dwi Wibowo, B.Eng','L','','','kepala','870f669e4bbbfa8a6fde65549826d1c4','monitoring','Aktif','bb2f5b60d25dca497a43fb2431cfebfe'),
	(29,'6088971c048fb45e4317','Ismawati, SE','P','','','teller','8482dfb1bca15b503101eb438f52deed','teller','Aktif','e3490b315d23ae5a67e21b60fa0f7c23'),
	(30,'2f04c425850e7ff102eb','H. Rohmat Buchori ','L','','1234556789','Pengawas','f414face756c143bb2be71c33c978073','monitoring','Aktif','2f04c425850e7ff102eb'),
	(32,'d1e3a7b716e7e91dc216','Pengelola RKAS','P','','1212433243','RKAS','0cae3894da509521aacd6b1917ad5d1e','rkas','Aktif','d1e3a7b716e7e91dc216'),
	(33,'722df1dc467b0a06e210','H. Mokh. Jaenudin / Hj. Citra Dewi','L','','','owner','72122ce96bfec66e2396d2e25225d70a','monitoring','Aktif','722df1dc467b0a06e210');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `user_siswa`;

CREATE TABLE IF NOT EXISTS `user_siswa` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `kelamin` varchar(1) NOT NULL,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `hp` varchar(15) NOT NULL,
  `email` varchar(150) NOT NULL,
  `id` text NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `nip_2` (`nis`),
  KEY `nip` (`nis`)
) ENGINE=InnoDB AUTO_INCREMENT=207 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `user_siswa` (`no`, `nis`, `nama`, `kelamin`, `username`, `password`, `hp`, `email`, `id`, `status`, `created_at`, `updated_at`, `created_by`) VALUES
	(1,'242501004','ARSHAD FIKAR ABQARY ANDRYAN','L','242501004','1c859446eff1ee582ed0188b284c2952','082118485588','','cd8cbdb3421c8593fd40','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(2,'242501005','ARTHUR PUTRA TANGGON CENDIKIA','L','242501005','de953791163163a94af1c37d5ecd9ea3','082321234444','','6416018d5ede953ded0f','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(3,'242501006','ARTYAREZI SHAQUEENA RAMADHANI','P','242501006','a8d4db7c53b87f4456bc1e714b201943','081320059567','','a24f6a6830a8d4d88eb5','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(4,'242501007','ATHA PUTRA TANGGON CENDIKIA','L','242501007','a4d3ac7b3641a2d535602542368a8781','082321234444','','54fd762577a4d3a3c089','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(5,'242501014','AZZILFA RAHMANI DAYYAN','P','242501014','1d72e74e68023358b8aa266b344de52a','085325676666','','cce42c042b1d72e7e9fc','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(6,'242501016','FATIH ILHAM AULIA','L','242501016','9fcac2a7f80ce14c633918d0d2ea4bfd','082214711106','','f5545a33579fcacd2de2','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(7,'242501018','GALUH PRAMESWARI AL ANWAR','P','242501018','f58b4e0e0000f5d9cedf31a01a3bd9e2','081394493448','','d3e4562decf58b48b74a','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(8,'242501020','JASMINE ASH-SHANUM TAZKIYA HAN','P','242501020','328438ead211ae37855553bbc270cd63','082217734765','','f9fc7ed467328439b502','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(9,'242501022','KAYRA SYIFA ZAIDA POURAN','P','242501022','d6d72a677922fd5489c465e86d4fb9b2','082217684279','','9e90995a45d6d72e8998','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(10,'242501023','KAZIM ATHAFARIZ RASYID TANJUNG','L','242501023','3b2af1a7f539f893cb7116ed0ef3b07c','082130123483','','8d0521f1363b2afc6b4b','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(11,'242501025','KHALISA NURRAMADHANI PRATILO','P','242501025','c0d1bc0acce6fcedfeca5962f66c1513','08121335286','','dab56b801ac0d1b01f3f','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(12,'242501026','KHENZY GIFFARI ANDRA','L','242501026','67b404544ba20341b82e638dd256330c','081381346107','','0c857661a867b4058e8c','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(13,'242501031','MUHAMMAD UKKASYAH AL-FATIH','L','242501031','c05e275be8481a5486974ea10b46cbf6','085220205510','','d6aaf85c26c05e254aa4','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(14,'242501036','NAUFAL RESKI HERMAWAN','L','242501036','8fd869042d2c3dd442265b83fd4f7864','082128644464','','af061ce3a08fd860f93c','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(15,'242501038','QALIFA AL QAHTHAN ROYCE','L','242501038','51c73b3a9abe70a0fe5fa4c21e7069f6','081220129116','','981f5ebca851c7350488','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(16,'242501039','QIANA ADREENA PUTRI REFIANDI','P','242501039','92b279030d1431a1694b582340dcf0b1','08112340391','','bd403f619f92b2716180','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(17,'242501040','RAJENDRA DEVIAN ALFAREZ','L','242501040','ed686025104b19f36c5925b6fcaacb58','082126524046','','7befaac709ed686e2a59','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(18,'242501041','SANDRIA HAVIKA NAURA','P','242501041','be3fda2cde63d60d26009d40ac6b339c','085315097777','','dcb8e9b2a1be3fde19f4','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(19,'242501042','SYAFIQAH BURAIRAH ALVANI','P','242501042','e578bf4ab73bb99b34bb209f888c9adf','081283200039','','f4fe574e20e578b03279','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(20,'242501043','SYAFIYAH BURAIRAH ALVANI','P','242501043','1cecb1585d1b30d79871a3061459247c','081283200039','','1ae04f4ff01cecbb7765','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(21,'242501051','KEISYA SHANUM ALFATHUNISSA','P','242501051','be97a8a4eee90d4a9745a5fb5490bc8e','','','d0c0308b2ebe97a1497a','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(22,'242501001','ABIZARD ARSHAD NUGRAHA','L','242501001','4d46448d05cf1df50b5a92c6dd11d3de','081223979959','','015b2b280c4d4640ae12','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(23,'242501002','ADARA PUTRI TANGGON CENDIKIA','P','242501002','1857c1a363346a7bc33dafaa1259e7f6','082321234444','','cf371d7d441857cf5a8e','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(24,'242501003','ADHYASTA RAQILA SEPUTRA','L','242501003','4c04f76e1f03647c73f9a35b6b269de6','081322258534','','f3fe311b3c4c04fa9832','Aktif','2024-12-12 17:01:55','2024-12-12 17:01:55','e3afed0047b08059d0fada10f400c1e5'),
	(25,'242501008','ATHAYA NABHAN ZAAHIRULHAQ','L','242501008','1b6b0f8f03bbd60793d6949acfd75699','082315418080','','a650e389ef1b6b06f9bb','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(26,'242501009','AUDRISSA HAURA ZIANAYA','P','242501009','7cb2e0263853a434ddb9be9fe9312921','081320096390','','fef2f6273a7cb2e07ff1','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(27,'242501010','AULIYA RAHMAH','P','242501010','da15767ec5a13d42c2ebe332d8e0c1a6','082246283170','','9299db2d4ada1572c585','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(28,'242501011','AURORA PUTRI TANGGON CENDIKIA','P','242501011','88010b77d71c2a9f61c6c36145b53b71','082321234444','','e4b34b66c5880105ca4b','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(29,'242501013','AZFAR RAFFASYA NURDIANSYAH','L','242501013','2cd39ce87910d1f6c2fb57d1c621f428','085320277747','','67476418ad2cd399343e','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(30,'242501015','CLARA AINUN NISYA','P','242501015','584c076627d56bf1f8d1f5ddaed26317','085295657041','','38ca528579584c0b1f79','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(31,'242501019','GHEISAN ARCELLO MAHESA','L','242501019','a2283810a861bf9026cff9f196111306','089656225339','','3f7e0608c2a22835030e','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(32,'242501021','K HANI ALFIDEVITA','P','242501021','0fe09901715cd2b6da168bacc2ae734b','08815235930','','09be416ba20fe096fe92','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(33,'242501024','KEANE MAULANA PUTRA','L','242501024','7a5bf39ed8da8e6ef793a5ebeb62d25a','085311111400','','b6e102c3d17a5bf5a2b3','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(34,'242501027','KO CAHO PRATAMA THOMAS','L','242501027','4c30ee749ac6b747e4ef4550ab82e1b2','082319239501','','706ffda6474c30e19f80','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(35,'242501028','MUHAMAD FATAHILLAH AKBAR AL FATIH','L','242501028','52eab029fa0554fd9826cac19197fb12','081283154406','','8afcf5daf852eabb3a23','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(36,'242501032','NABIL KHAIR RAMDANI','L','242501032','ef4ac8e93ac4d3eb078bd69cb5e96c5b','085214662249','','7d47d0bf90ef4accfd7d','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(37,'242501033','NADIRA ADZKIRA MAHARDIKA','P','242501033','c30d5f4cdb1fa04350685317d517ee22','085713561328','','1d5f211786c30d5ae3d3','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(38,'242501034','NAIRA GHAISANI','P','242501034','35bc2e02f99b8a2fab288bc85df54813','082240117844','','fa5fb0a65535bc2cb1c8','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(39,'242501035','NAUFAL ALKHALIFI PRASTIYO','L','242501035','919d305221bb91b4b5b77b9ceeab7ca0','085721416006','','4b403724cc919d361bb6','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(40,'242501037','NAURA RAMADHINA NURWAHIDIN','P','242501037','6dc8f7b6993564d27b1936820966a45b','081218484750','','7c9ae0c68b6dc8fdf69d','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(41,'242501044','SYIFA MAULIDA SALSABILA','P','242501044','b348f0a919719d4d7760fd8647b501d8','085294346499','','1aeda2a5d2b348f8c614','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(42,'232401005','ANANTA LASHIRA NAZAFARIN','P','232401005','54776bdf7904a7d77b6c2f4e0e46bdf7','85222744445','','69259cb9915477656a32','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(43,'232401050','ARFADHIA RAZQA ATHARUF','L','232401050','a5db990d9bf19ebbe3b9274316269fad','081809110281','','db93bbac6ba5db990f6d','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(44,'232401007','CEILO MALIK ALTAIR ','L','232401007','7f475fbd4007ad9895853dfd735e35a8','085770373766','','bb56d4b8807f475c6dcd','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(45,'232401012','FARZANA SABRINA ALMAHYRA','P','232401012','85f9bf46f9f9c24e0e00212ff3b5e4e2','082123361212','','3f56ffd92c85f9b9b610','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(46,'232401048','FELYCA RIZMA HAPSARI','P','232401048','44e1600a5abe6f17ddd3cbb70eef2d7b','08175002999','','65aafa954a44e1657fa7','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(47,'232401049','FELYRA RIZMA HAPSARI','P','232401049','dd143450e7d36a0d515d20143aa2d8cd','08175002999','','ba77b18335dd143576fc','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(48,'232401013','GALENA KAMANIYA SLAMET VALERIE','P','232401013','d72c608f720dded7a29c84b3d02f6614','0811226167','','c10105fc56d72c6e63fa','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(49,'232401018','I GUSTI  AGUNG ATHAYA KHALIANDRA NADDEAN','L','232401018','41657811605b7baf851a4e4687a03f87','08112007013','','0255e1fdc94165768b4a','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(50,'232401019','KAZUHIRO ARRAWDA ADITYA','L','232401019','21bcd106ca8facc2ab48ff2f6f2d763b','085317017157','','9c0d2cf77621bcd14e8b','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(51,'232401020','KEANU ALFARIEL ','L','232401020','2df068620ea22604ba0beebd970da410','082321111092','','00cc0a7e8c2df06152d0','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(52,'232401021','KEINAN ARAZKA PRADIPTA','L','232401021','6ee56fb15778de886f7e48ae00a46dea','82242283321','','fff908bb616ee569f698','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(53,'232401022','MILESHA SHIDQIN ALIYA FIRDAUS','P','232401022','c26c88feef3e0b66dec9a07a7f688a4e','087782089440','','96c7fdb415c26c840e99','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(54,'242502047','M ALFARIEL SIHOTANG ','L','242502047','78e56abdf9a8e40d8cb94efc7b3c23ab',' Subang','','2d0ef5f6a178e5626e7f','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(55,'232401025','MUHAMMAD ARIEF HIDAYATULLOH','L','232401025','57ebd4ca7c9be47ac67aa782bc476fa0','89694566569','','1fff440e1d57ebd43328','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(56,'232401026','MUHAMMAD KHALID ARRASYID','L','232401026','ae518e9597be065bfd808e6c3d4dcddb','87708708515','','a999f59a81ae51827eef','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(57,'232401028','MYSHA MAHARANI GUNAWAN','P','232401028','a3b01fc704f6c047bbdacfcd94e7ec49','82216482803','','281eb5dff5a3b016ef56','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(58,'232401029','NAFISHA HASNAA CARISSA ','P','232401029','2177582ef920e563c27c6c6d2a75f760','82117879988','','a49fee9a14217751d8d4','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(59,'232401031','QUONZILO AXELLE FAIVISH','L','232401031','cc3022a6c6351a68b5118d9266dd6bd7','081313771662','','8a34f37d58cc302c36b8','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(60,'232401038','SERAFINA SHANUM KIRANA YUDHA','P','232401038','5f6cb9003ccece3b67ed14871b66d2f4','082111104780','','ad2851022e5f6cb8312b','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(61,'242502052','FAYRA AZIZA ALZAFARANI ','P','242502052','8c58a56a3b4c43ecf85d04b7cca8f2c3','','','e2eab79aaa8c58a9bda8','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(62,'232401001','ABIDZAR AL GHIFARY NUGRAHA','L','232401001','5fcce6c898aa3fc437002b92605a1430','081316631461','','4f7ca39f8c5fcced9011','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(63,'232401002','ADZKIA SAUFA WIDIANA','p','232401002','4f0875331503401df8bb78c5f31637ff','81223731191','','988faefc614f0870b7f0','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(64,'232401003','ALEM VIRENDRA MULYAWAN','L','232401003','e21605f09d9e49c7f3f56ffc1934f4f4','081394730193','','da8e1d4217e216061b19','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(65,'232401004','ALWI AMMAR AL GHAZALI','L','232401004','86ebce722b2308ff8ec61f68006c9aff','085321752957','','8aa80e0d6886ebc1be7a','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(66,'232401051','ARRIZA NUR MUHAMMAD','L','232401051','ecf982c495784a212c4b50cc41d79aac','','','70672954e2ecf98ed90a','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(67,'232401006','AVRILLA PHONCHO ZAAFIRA ZULFA','P','232401006','8aa51c1badd4be14d98e73c776feb774','81222452592','','bf1936fc218aa519a9a0','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(68,'232401008','DZAKY HADIWIJAYA','L','232401008','6fe1fd7f0e1a7ec49930e7ed4257cd06','81220709789','','3025ea19b06fe1f6b027','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(69,'232401014','HAFIZ ALFARIZI','L','232401014','5bd283fe26d632993b08fc75106baf87','087828386251','','d3955ffb8b5bd287a6d3','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(70,'232401015','HAIFA AYU KIRANA','P','232401015','df8087cd1b4ca986401f583a6af3b112','082127151796','','e3357b2215df80894238','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(71,'232401016','HARITH ADSKHAN ','L','232401016','f02070ab35430b1137480873997d944b','081398769566/08','','3b6da497def0207304db','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(72,'232401017','HAURA HILWA ALIFA USMAN','P','232401017','5871379021b8572833016571f522825f','085624311112','','0a9ec2393a5871343a07','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(73,'242502046','KHALID VALERYAN RIBSYA TANJUNG ','L','242502046','8e3b2fa2f8e2e25fc45ae84c0eddeb0f','','','82795277038e3b2ab551','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(74,'232401024','MOUNIRA SERAPHINA PUTRIWIBOWO','P','232401024','f8cb967f1b70bb995a27654f699ddbc5','081223196959','','f85561fc25f8cb9c7b39','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(75,'232401027','MUHAMMAD NEVANDRA UMESYAH','L','232401027','018390a5989da4ae8d342678bad53e52','6281271386757','','5ad3bdfbbf01839907c5','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(76,'232401030','PRAMUDYA ARDHANI HAMIZAN ','L','232401030','94a83597ddfa6dfc8df41a7eed2bb75a','81221218686','','44c436382094a83dd461','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(77,'232401033','RANIA SARAH RACHMAN','P','232401033','1c5e3e92f29561d90b438ed5496aed58','8122452167','','9811fff8971c5e39e37e','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(78,'232401035','RIZKY SETIAWAN','L','232401035','aebe9058cd4e6aee6c634a2b1e45a374','6285320417920','','7e08864e23aebe954263','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(79,'232401036','SALVINA ALEESHA ALRADYA','P','232401036','429d4fa4f9f78f9dd06e6e9c956c6471','81221633301','','1122319239429d48f2a9','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(80,'232401037','SAVERIO AL MALIQUE','L','232401037','58a11bc2da6577e81ceb64d1f24741ed','081294448882','','6caedc859858a117476e','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(81,'242502050','ARZUNO MUHAMMAD RAMADHAN NOORIS ','L','242502050','0773b3c4ef3973b19c5bbaedae3c83d6','081311567100','','a5f65326460773b83aee','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(82,'222301002','ALDEBARAN HAIDAR','L','222301002','7491a4f0714741a1db0eb8e669745de3','81297187826','','367693b24e7491a37a13','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(83,'242501045','ARFA DAMAI CORDELIA','L','242501045','a507adff6e2feaeb64f7bdde86c6faab','','','a7183bcef1a507a1a539','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(84,'222301005','ARUNA SACHI KAYANA','P','222301005','33cb0787ff2b41273590b40c9684bc53','82119130412','','ecc9d4a3b133cb059a9b','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(85,'222301006','ATALLA BARCA AFRIAN','L','222301006','63b50fad0012cde777cf5502179d9ad5','087825262684','','9ba0e864fe63b506e921','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(86,'222301008','AYESHA QIANA NURDIANSYAH','P','222301008','b0efef25a90b3b78b7e1ea027f729b0f','085 320 277 747','','995d3331f1b0efe3105d','Aktif','2024-12-12 17:01:56','2024-12-12 17:01:56','e3afed0047b08059d0fada10f400c1e5'),
	(87,'222301010','AZRINA ALKHANZA AZZAHRA','P','222301010','3a44a38b8c1f27cc85d0ecdec488f677','085370220220','','ca09630ce43a44a78b38','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(88,'222301012','ELONA SAFA ALMIRA','P','222301012','1d4ca0159b5213706ea688791fc735e4','081 122 901 68','','b4df080d4d1d4ca88b2a','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(89,'222301025','KENZIE AZKA WIJAYA','L','222301025','d2a955aa853ec11acfcb44e106a22ebe','081222433625','','a75447d5d7d2a95a95e6','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(90,'222301026','KENZIE NAUFAL SRI LUGINA','L','222301026','582bf2ef272b1a55e137e8eee9407357','89680670609','','3311a399dd582bf2e4f6','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(91,'222301030','M. SYAHRIL AS SEKAR','L','222301030','5ff85346c766c636969115a384b625cf','087738511608','','f8fc52dc865ff85cb71e','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(92,'222301031','MUHAMMAD ABYAN ARKENZI AKBAR','L','222301031','d79a50b6085161e74fb6bd1b488c382c','85720446783','','1a60c827e6d79a50c653','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(93,'222301032','MUHAMMAD AZKA KHOERUL AZAM','L','222301032','4454002ef413fb17257194c11b19d932','081386844365','','644b9d880644540cd929','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(94,'222301033','MUHAMMAD DEARLY AL FATIH PERBAWA','L','222301033','24dfb9ba308b23b4ce627f25ab146cab','087 879 761 988','','e1adfc01da24dfbd62af','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(95,'222301036','NAFIZHA NUR MAULIDA','P','222301036','c9e8036ded416460a91cd51ad45e1836','81220458786','','3bc4e8ca31c9e804e842','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(96,'222301038','RAFFA ADINAKA AR RAHMAT','L','222301038','3817dab77b36dd40c190a8df64209266','085353299660','','67515c4caf3817d389b7','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(97,'222301041','REYNAND ALTAF MULYAWAN','L','222301041','41ffb6f6f6bd05fb2dabb44daa590857','081 394 730 193','','3ebd548ff541ffbfbd66','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(98,'222301042','RYUGA EL YUSUF','L','222301042','79b836f91b291cb5c1650f50112b7e99','82219082533','','99124f9c2c79b839e2c4','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(99,'242503048','REYZHEL QEVELLO ANDRA','L','242503048','6d278e60a0b40817a28511e39dde21da','81381346107','','e7c7bc40ab6d278c9eba','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(100,'222301043','SABRINA ALULLA SHANUM','P','222301043','6c4d219b372a4a1312a00d926284325f','081220003971','','9d8584fe036c4d2a59e1','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(101,'222301045','ZEFA FARZANI','L','222301045','09d0105c77c2eaa9f1d73d3949626760','082115255999','','45dcf734b409d01b392a','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(102,'222301003','ALFATHIR ARDI PRASETYO','L','222301003','a55363e6f6efd8e65a1f1c7f90417460','081214936309','','ad50eabf8da55362b920','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(103,'222301004','ALVI RIZKI MUBAROK','L','222301004','7f3cebe05e5753ced8c31978fa5ef3e5','083823188779','','8ece1f77047f3cecda24','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(104,'232402040','ARKHAN AKHMAD ATTHARIZ','L','232402040','d94d0e3d1f82482b3f088950881658d4','087778646400','','618be8c96bd94d0b3a2a','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(105,'222301009','AZKA AZFAR HAIKAL','L','222301009','9f7cc16c4df24845e7eb60a35b77e9c0','082218098854','','dd0984a72a9f7cc2e105','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(106,'232402054','AZQIARA PUTRINDA ZAKI','P','232402054','0a60a1eaa94bec35756579ab7f7eb18c','','','569e80f2790a60a0ef20','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(107,'222301013','FADIAH ANINDYA MAULA','P','222301013','6e86cb39c6ae09f88fa5504d32a6fe0b','081 395 806 966','','8f18cbf8526e86cbc3c1','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(108,'222301014','FARDAN NAJA ELANDRA','L','222301014','4b63decb49af65f79e6128c68e5666de','082124061884','','c6d1c891e54b63d08160','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(109,'222301016','FARIZ NAUFAL RABBANI T','L','222301016','6e78fdf86b00a3725b0f2c9dcb7db859','817215524','','e1e7b285426e78f05611','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(110,'222301017','GWEN AIMEE SYAREFIA PUTRI','P','222301017','dec2f4098dd81f588075ddfce5edcacb','081220292241','','4ed4e3b6aedec2fc0a73','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(111,'222301021','IBRAHIM JAFAR SIDDIQ','L','222301021','160da155e3b6bcf2a6c36219449259b5','085224880567','','4321c0d73c160daef90a','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(112,'222301022','IZAZ ABDER RAZZA','L','222301022','54e70dedef2ba7b51ef43bdd755a73fb','','','5a683b08e554e708f90b','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(113,'222301048','HAIDAR FACHRIL ARDIANSAH','L','222301048','e378981fe3ebd1a324e05a8451157915','08562825213','','0c488888bce3789eacc4','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(114,'222301023','JASMINE SALIMAH ROMADHONA','P','222301023','4092d002f282052af1b623ac4df6e0e2','081299682378','','23235789814092dbdd65','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(115,'222301024','KENJI GERRARDINO REKSO ATMODJO','L','222301024','ff5b18d3526152030dd775ec37195472','081 910 001 221','','04d7913935ff5b1c781d','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(116,'222301028','M. KEENAN PRAMADITYA H','L','222301028','948e5ff05fd744c1929a64c3975f45d9','082 317 601 251','','613cf8a78d948e5af528','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(117,'222301029','M. ROMMY ALVARO','L','222301029','3557f23f269dc38d6b566df0e2ec419f','81572252540','','354286cc333557f6cdfd','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(118,'222301034','MUHAMMAD KENZIO ARSYAD REVINZA','L','222301034','138d41ad502a9fc1fb263f61e5a9c8b9','085222277741','','fc2228102e138d4d0c03','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(119,'222301035','NABILA REVALINA','P','222301035','f0325902cc163bda5b4e5ebc9bda857b','85220021015','','d0b9cacd82f032512048','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(120,'222301039','RAISHA RAMADHINI RAKHIM','P','222301039','e28ff785cc4551ff077f610ce4fe3441','081320193703','','eb681fd0fce28ffd1326','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(121,'222301040','RASHYA DIANDRA','L','222301040','332cc886d8b31a5ba591dc96bf130cd5','085972522358','','ee1aac38c2332cca7ae4','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(122,'222301044','TATANG MAULANA WIJAYA S','L','222301044','801dc442acc7a7a07e587dbc23aa2dbb','081 321 499 133','','d5588887cf801dccac13','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(123,'222301046','ZULFA AGNA KAMILA','P','222301046','ebfcbde57c755ad0294c3dfdb34f2bc1','','','26e46d93e8ebfcb62d77','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(124,'212201002','AHZA FAWWAZ RAMADHAN','L','212201002','5595f55decd58a49bfd23a10242c4ec5','0821316261982','','b23521efb35595f4f7c9','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(125,'212201007','ATHALLA REINDRA RAMADHAN','L','212201007','7ddeb05f8df0ce633b45956629751223','081220252555','','dcdc98724b7ddebbeba6','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(126,'212201010','AURELL PERMATA H LIM','P','212201010','73ba5d9f3c753b3d45cf6ca93df9dc16','0895321188818','','8d995978fb73ba575e99','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(127,'212201012','DAIKI ARSYAD KHAIRULLAH','L','212201012','bb1e934cba8befadef00d789b01ddf35','085710494610','','ff74ca9ad8bb1e99900f','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(128,'212201015','DHAFITHA NISA NUR AZIZAH','P','212201015','6ada529bedbd29982e31095dcbd5d486','08122099714','','93e16030496ada5aae81','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(129,'212201019','FAYRUZ AILA ELZAVIRA','P','212201019','a0084d657d538c48e23ef425d5a78329','08994195110','','6e245bd88ba0084f7dde','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(130,'212201020','GAVIN ARVANDHIA WIJAYA','L','212201020','79c082d8cba6db69939579e3a0770c56','085315097777','','713eda495579c081808f','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(131,'212201022','GILENSYA BRILLIAN ABIYUSAFA','L','212201022','36acc403444ed42db9b390a299d5bfbb','6282218605211','','232a75679536acc14d77','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(132,'212201023','GUNTUR JUNA WIJAYA','L','212201023','a3f1aa24a9eaa8e1bb2ac9a8925e7763','081220088127','','48eeea84b7a3f1ae2548','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(133,'212201024','MOCHAMAD IQBAL MAULANA','L','212201024','36d489c0a208f55ff95fd0148c50d08a','08812034744','','de0f21de8d36d4867491','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(134,'212201025','MUHAMAD AFKAR KURNIAWAN','L','212201025','7a6ca400a1583aca8dd3ecd14f6bd87f','081123110046','','b28348766d7a6cabc412','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(135,'212201004','MUHAMMAD AL FAHRI VALESKA','L','212201004','dea32fea82126cb23705271c06476bff','081313029191','','2dacf390c8dea3254ace','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(136,'212201005','MUHAMMAD NAUFAL RIZKY UMESYAH','L','212201005','d54d38b5750f7e6ecf3bf20bf08438e5','081271386757','','4c2d4a21c0d54d37fede','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(137,'212201006','NADHIFA KHANSA ZAHIRANI','P','212201006','c511bfc71472a7fac0860975ac7d092c','082315418080','','a9e6493d0ac511bbcbe8','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(138,'212201011','NAUFAL ALGHAZALI RAMADAN','L','212201011','81c9b7cad470c3013e5bcb93827268b5','08994195110','','275e6ad28181c9b77c7c','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(139,'212201013','NAYLA ANDINI NURFADHILLAH','P','212201013','5bd1e1f6f16efa462bb4b08d39615ec3','089644322902','','23fbb5fea7d410d42bd69d0eba85aa1b','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(140,'212201016','NAZMI ATFHAL AZIZ','L','212201016','bacfa1368016f165bc5ef59b38f9ea85','085294346499','','24ecd425b7bacfabfbc2','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(141,'212201017','PELANGI ASSYABIYA HANDIAN','P','212201017','c6dade8346d2364461797a3f373591c1','08993129777','','a7dd1850dec6dad4a497','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(142,'212201018','RIVANY APRILIAN ANGGRA SETIAWATI','P','212201018','c4713b8c6ed3cd4acc7aab44af0a85cc','08121133661128','','2c6ee34a7cc4713490f0','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(143,'212201021','SHAQILA AJENG ADZKIYA DZAFIRA','P','212201021','c903061be35081b3eb00f93fe0a74723','085224300100','','b21a8f330dc9030738d3','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(144,'212201026','SRI AYU KENCANA','P','212201026','212cd99adf8acac236741ad4bbabe758','085215148956','','106d1dd7ec212cd6b251','Aktif','2024-12-12 17:01:57','2024-12-12 17:01:57','e3afed0047b08059d0fada10f400c1e5'),
	(145,'212201027','TYARI AFWA SHAHIA RAFANI','P','212201027','d7987a5a410615390e19c84c2ce2bf1e','082320342226','','d026c4ca24d7987912d0','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(146,'232403041','SEBASTIAN SCHUMACER','L','232403041','074b5f11f27cfb39afd82d19db495364','6282110570041','','14c3d8980a074b5a857b','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(147,'232403042','MUHAMMAD AFFAN DZAKI BACHTIAR','L','232403042','fcbad659b496d366a5506fd0e8936139','081212814184','','13f3b05591fcbadaef15','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(148,'232403052','ZAHRA NAYLA TIHANI','P','232403052','454f75bcedac84bdc74aca65b2829f56','','','37ec876d5a454f70a8e8','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(149,'202101003','AHMAD HABIBI ASYIFA','L','202101003','b64d1fce172682f92e5b8f67cbd317de','0859117343081','','18aeff5e00b64d1bcec6','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(150,'202101005','ALFRIZ ANRAGASI JAGADDITHA HUDSI','L','202101005','318962783ac3b6eaab657715b75a1a17','082214599410/08','','134b89f4573189667031','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(151,'202101008','ALWI JANUAR SIBYANI','L','202101008','f3e85cf6475df0b4f2f96578b9f2d7be','081320563214','','9f9dbe7d98f3e8523c76','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(152,'202101013','AZ - ZAHRA ASSYABIYA NAURA ','P','202101013','c0adaefdbc8570b8e1aee2fa463ab101','082124954947/08','','e2b605f861c0ada7f2a1','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(153,'202101014','AZZAHRA DIANDRA NUGROHO','P','202101014','14d0c26c155d64cf240c34c3b290532c','082127160333','','f81ac1fb2114d0c8ee6d','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(154,'202101016','CAMILO BHAMAKERTI MUHAMMAD','L','202101016','367289270d1a16f915f7a0a35c293d2b','082311272407','','a172d30abe367284f5de','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(155,'202106054','ENZO KAFFIE EL AZZAM','L','202106054','a15d4b393bd8e304eb8558151266236d','082315248644','','fa0c3c4511a15d4c0ffe','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(156,'202101017','FAIDA ANNAILA EFFENDI','P','202101017','ccd11c0bb668ede2849afb2efae6635d','082116291231','','e83cc844c5ccd11208d7','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(157,'212201029','FARAND SAVERIO KHILAL','L','212201029','2d6b022075eeca959fc8c0e4853a7552','081298118905','','f4d19b17e62d6b0d6242','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(158,'222303047','GADIZA AIDA LUVENA','P','222303047','5418074ee600927ef2dbc48231b595e3','','','7ecf956b8954180ab876','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(159,'202101018','GYAN SATYA ALARIC','L','202101018','b4eb5fca29523406ca4396ee87fffb88','082117747212','','716469f244b4eb56ee27','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(160,'202101021','HANIFAH ALDILA SYAFANA JEN','P','202101021','f53d4313c4de7bec4472218e24f2d04e','082115829084','','c6d8faa6c7f53d4c1172','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(161,'202101025','KHAYLA APRILIA KIRANA','P','202101025','c6ec883a6d15a0407619645817397350','085223792992','','6e46609a6dc6ec830edd','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(162,'202101027','MUHAMAD HAIKAL MAULANA AKBAR','L','202101027','334f850bea92f7d67b5c87d053524b17','085320407375','','c504000eff334f8859ee','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(163,'212201031','MUHAMMAD ALVARO DIRGA MAHESWARA','L','212201031','1f649e74a87cbb3e36f519b0af676c18','','','627d845fa61f649f04ce','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(164,'202101031','MUHAMMAD FAHRIZAL SEPTA','L','202101031','2bbfa8eebb85cdb29c414951591883e8','082320854473','','982d4aadff2bbfaa1ce6','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(165,'202101041','RAZEEQ SACHTI ABDALLA','L','202101041','eb3b20e61076dbd0da69988078be6b7e','085224880567','','b20b27c8c6eb3b217c77','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(166,'232404043','SATRIA PUTRA YOZA','L','232404043','cd3f02ffe11689a2760f38ffc711d612','','','09be0dd86fcd3f0eb47f','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(167,'202101046','YUNITA BELVANIA PRANATA','P','202101046','1e8d74e78c62771fda969d13f4ec2052','082121378906','','c0b641358b1e8d767456','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(168,'202101001','AABID ARFA ATTAYYA DZUBYAN','L','202101001','5defe361378527a7afce3f292e0e82f3','085325676666','','afe02ca0b85defe5dd2b','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(169,'202101002','ADZKIA KIMBERLY BALQIS A','P','202101002','98eabb1b29bcb02dab7df23c3b6ad577','082130012642','','7162b30c3898eab1ed74','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(170,'202101006','ALIF ADDIN GUNAWAN &#039;IZZA','L','202101006','c773a96dab76e90b85588244629bec31','081395806966','','c42e4b35c1c773ab7202','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(171,'202101007','ALIF ALBARRI MUBAROK','L','202101007','25d921b7d2d996a61fe97bfbf380c927','085222566906','','d6010d2f0e25d92d1c8d','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(172,'202101010','ARFAN PRADIPTA SAFA','L','202101010','7895a7155c55e5fce6433858b2233242','082216133026','','0bcb54a2eb7895a3cca2','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(173,'202101011','ARSEN ADISA ASHSHIYAAM','L','202101011','0dfc48e8d7a30333386b89753c763445','08112340130','','b5ff193d400dfc4ca034','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(174,'202101019','HAIDAR NUR ZAHID MAHMOED ','L','202101019','30ec68855bdfc5a61a9f58127239b400','087821607135','','f618c3d46530ec6b7f8e','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(175,'202101029','MUHAMMAD DAFFA RIZQI','L','202101029','aa8aa6e1c63dd41061f75300aaa71fd9','085222204586','','456625f0deaa8aa4cb47','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(176,'202101030','MUHAMMAD DARREL ALKHALIFI PERBAWA','L','202101030','fba7b153bf056cba535e06d04ea7d7e4','087879761988','','cf55a40d61fba7bac60b','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(177,'202101034','RAHMAN HILMANYSAH','L','202101034','76e7e668ec2319a6be023b3a2657544d','081380005762','','92f163a54076e7eea438','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(178,'202101035','RAIHAN FADILLAH','L','202101035','fdbd8badfb1163d7a14df1f0034637bb','082126955206/08','','276e8582ddfdbd8a013a','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(179,'202101036','RAISHA GHASSANI XAVIERA SIDDIQ','P','202101036','984f84e652fab101ee3196031e21b18a','081320563214','','66794c09e4984f865692','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(180,'202101037','RAISYA AL ZHAFIRAH','P','202101037','3ad2839fedc82c768cc6f1363822090b','081 22137 3661','','77ceb90ba13ad28be0e1','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(181,'202101040','RAKEAN WASTU HENDRAWAN','L','202101040','0087596cf55ab7c05679020f3d71a8b4','081322773131/08','','4014abb09e0087591c02','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(182,'202101042','SYAKILLA AZ DZAKIYAH JELITA HAN','P','202101042','709da735a948ffbcfe1c92c347f12903','082217734765','','77b9bec04f709da6fb24','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(183,'202101044','VANESSA ANGELINA HAUSER','P','202101044','cd187281fabfd8f3199238e843e8ea84','081298899498','','04c78a4299cd1871747f','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(184,'202101045','VYOLINA HERMINE','P','202101045','44d9336529a85702173b5fb6cbfaf5ad','0813988174646','','2d9e7b4c9444d930d42a','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(185,'242505049','ALVARO MUHAMMAD OZORA NOORIS ','L','242505049','17c6414697f654683e58afc7416c49ed','081311567100','','f8536d080917c64fbc66','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(186,'192001001','ADZANIA LETISHA PUTRI','P','192001001','4f32b4ec5bd3e9f409ef8fc9a16fb061','081224389508','','d461ed4dae4f32b53acf','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(187,'192001002','ALDYANSYAH DARAJAT','L','192001002','d5c31d50fd7cc071a1df736a65944b7a','085294518486','','2adff159e6d5c311bd66','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(188,'192001003','ANAYA MIKHAYLA SEPUTRI','P','192001003','a6bb3353603398dbc2093e074fb24a94','081322258534','','616fe5d827a6bb32552a','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(189,'192001004','ANNISA SYAKILA GINANJAR','P','192001004','af3a962a79f564478ce6b93859c1caef','081285145404','','8f2644f0d5af3a9b00e5','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(190,'192001005','ASKA DIAS MUHAMMAD RAHMAN','L','192001005','cde5b22da386aa81369218b9953dd636','081386031002','','acf49757b2cde5b34fdb','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(191,'192001007','CHANDIKA ARSYI PARAMA SETHA','L','192001007','1de77fe92a87f22391aa033f92e67700','087828488898','','50cd8f79aa1de774b7d3','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(192,'192001008','DILLIAN ABDUL HAFIZUDDIN B','L','192001008','42cc08c9795a6ebbaf254f265ba07cc3','08122047126','','82ccd744f142cc0a65ad','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(193,'192001010','FAHREZEL AYDIN EL-FAYYADH','L','192001010','64d59a165ca7586c3aa5945e97191a8e','087824207846','','85ae126b3464d598e482','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(194,'192001012','FARIZ NUR RAMDHAN','L','192001012','5e55b34ba511d5f5e461b1a65eab0e0f','082130017074','','be0c8611495e55b4a3bd','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(195,'192001014','KEANU RAJA INDRAWAN','L','192001014','1e58e4bd188b06b25704596b8a881b81','81385888137','','61a7dda6cf1e58efc7ab','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(196,'192002032','KHAIZURAN NAUFAL PRATILO','L','192002032','071757c980328444185893d206044906','08121335286','','6a1461e4c20717560057','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(197,'192001016','KIASATINA AMILIA GUNAWAN','P','192001016','9bb5773e0c330bcdca94821d184be509','081394919687','','351c1a21aa9bb57eeb8e','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(198,'192001017','MEYZHILA AURORA NOVIANDRE','P','192001017','45266b00ebe2d6ab389d7cd112268ee6','082304676247','','7c265342354526618e74','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(199,'192001018','PAKSI HEKSA UTAMA','L','192001018','34341eaf7189bad2408b7dfbe85c2b41','082214711106','','5d0304c94a34341be7a0','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(200,'192001019','QALESYA QAIREEN ROYCE','P','192001019','1a4e828a28e7929fa3fe1dac7f8d7087','088222134797','','99ce8f78d81a4e874c41','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(201,'192001020','RAFKA RACERIO GENTARA','L','192001020','ecbc64481bff7185e3ee6e6df4e70b97','081322642842','','ed896aa36becbc6ab610','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(202,'232405044','RAYYAN SANI ALFARIZZI ','L','232405044','dcff718dcda9a943ae619199223fe400','082268961010','','04e61eab11dcff7e1800','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(203,'192001023','REYZO AKENO AL-FARISI','L','192001023','f52b10389e17df89c218752c6b9fd55f','081221104793','','ca80eec47bf52b11a9dc','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(204,'192001024','SHIDIQ FAJAR DEWANTARA','L','192001024','3a31d30fd1e51617e92c974c5f6e0671','085228830712','','5f3b1c4d103a31d4a93a','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(205,'192001025','VALENCIA ZAHSY AFRIAN','P','192001025','ae1df380425f3a0ed1397121aca7dcbf','087825262684','','2b2dbb7895ae1df37f81','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5'),
	(206,'192001026','YASER MALIK IBRAHIM','L','192001026','c4b4cb534874b99522f2ca7788a1ccc3','082121729844','','3baab33c10c4b4c50de3','Aktif','2024-12-12 17:01:58','2024-12-12 17:01:58','e3afed0047b08059d0fada10f400c1e5');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_ref_akun`;

CREATE TABLE IF NOT EXISTS `simakom_ref_akun` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `akun` varchar(6) NOT NULL,
  `akun_custome` varchar(50) NOT NULL,
  `uraian` text NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=259 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_ref_akun` (`no`, `kategori`, `akun`, `akun_custome`, `uraian`, `id`) VALUES
	(17,'A','100103','100103','Penerimaan Biaya Akomodasi MMP','9ae26ff44c264acbcdb9f37bb5c08fcc9f9'),
	(18,'A','100201','100201','Penerimaan Biaya Extrakurikuler','7c7523f13ef609df9b1d9f82fed8bd1ce3c'),
	(13,'A','100000','100000','Penerimaan Saldo Kas Tahun Lalu','14ee22eaba297944f4f6fd9c6dbe2f2b555'),
	(14,'A','100101','100101','Penerimaan SPP','732e276ec85f14e5ddca80e9dd3badedebc'),
	(15,'A','100102','100102','Penerimaan Biaya Pendidikan','54ebda338d71682fb4f81166e8399d6a962'),
	(16,'A','100104','100104','Penerimaan Biaya Kelas KKO','72984ef85cbebaa1de90c11baa503343547'),
	(63,'B','200401','200401','Kegiatan PHBI (Tahun Baru Islam, Maulid Nabi, Hari Santri, Isra Mi&#039;raj)','9756342aa9434bedca5a47900243a485987'),
	(64,'B','200402','200402','Kegiatan Event (Lomba Kemerdekaan, hari kartini, hari guru, poe indung, dll)','800d427f7b19cf60b5ac5c7f6edd1a62ee2'),
	(53,'B','200101','200101','Pembuatan KOSP (dok 1)','fae1f94c506115e0a5bca9c5bb6c961bb04'),
	(54,'B','200102','200102','Raker','bc0db1ef7e8b63830d02e88b38ff853aab5'),
	(36,'A','100301','100301','Bantuan Operasional Sekolah (BOS)','a6061a0c10b13bf137460ec8e143a214b05'),
	(37,'A','199999','199999','Penerimaan Lain','174d10d8134ad94f0c285f19d5f8238d516'),
	(38,'A','100105','100105','Penerimaan Biaya Kelas Akademik','123faaaa42b5d906c7d0fa6b50781c14bca'),
	(55,'B','200103','200103','Pembuatan ATP dan Modul Ajar','bd0b3e43c34a47c3b80d3423fe4d481f779'),
	(56,'B','200201','200201','Lencana prestasi siswa (8 kategori) 3 bulan sekali','fafe0a5ad92e1f87f6d8aa13bec4bf0b609'),
	(57,'B','200202','200202','Kegiatan Olahraga Sportacullar','452bfed404cb95d00ad90691ac08b7f7aa9'),
	(58,'B','200203','200203','Kegiatan Language Festival &amp; Commancement Day','9e9bebb2682febcc493ddc5a61b18f23231'),
	(59,'B','200204','200204','Kegiatan STAR PIS (Modul) Kelas 4 &amp; 5','b543ca4b56d3cd5bd58d46ce320fed9336d'),
	(60,'B','200301','200301','Lomba Kedinasan (FLS2N, KoSN,KSN,O2SN,Sapta PAI, STQ, FTBI)','8aee09e623dfe2fdb66e9c1ae1ada55aade'),
	(61,'B','200302','200302','Lomba Keluar Sekola (Antar SD)','004ca31ed6cc0369427825e47f501097233'),
	(62,'B','200303','200303','Lomba Nasional','d9bcad1eca7b1bba44da1ad158e345975ce'),
	(50,'A','100002','100002','Penerimaan Pembayaran Piutang Tahun lalu','bb36c34eb6644abd00d2d4669de00b12fe4'),
	(51,'A','100001','100001','Penerimaan Saldo Bank Tahun Lalu','e2a6a1ace3526682325fbdf3406e4e795e5'),
	(52,'A','100401','100401','Sumbangan Wakaf Infaq dan Sodaqoh','b603648a5ab54a5ef1a2220ae5bcde23676'),
	(87,'B','200501','200501','Brosur (Penerimaan Peserta Didik Baru + Spanduk)','269727a2b342292b5cb45028bb35b124255'),
	(88,'B','200502','200502','Promosi Sekolah','e298165053c78f040c5478da10ff6c95471'),
	(89,'B','200503','200503','Wawancara dan Observasi Siswa Baru','c5a8081a0b50c26c7a646ebc5cda721ff7c'),
	(90,'B','200504','200504','Panitia PPDB','2ba1245d06438827764321300b9b0586b9c'),
	(91,'B','200505','200505','Home Visit','f586ff8517e916ef90900a540dc033e3b88'),
	(92,'B','200601','200601','Kertas HVS A4 dan F4 (Ulangan Harian &amp; Adminstrasi)','fe685cb7c788f348efa91b9e0f6bd68a4e2'),
	(93,'B','200602','200602','Penggandaan Soal  Assessment Sumatif TS, AS, AT','27982b006f030d7ed36b751123d648f5a00'),
	(94,'B','200603','200603','Tinta Printer 4 warna x 12 bulan (untuk 3 mesin printer)','2bbb64f4948501ac3ecb0bc385f853fdb60'),
	(95,'B','200604','200604','Kertas Raport','894ba5d3ca43f3bed6d2dbb43ca516ee026'),
	(96,'B','200605','200605','Spidol Whiteboard kelas','57546c17be8d31d646ef3f815738feecbfb'),
	(97,'B','200606','200606','Tinta Spidol Whiteboard','9d43605d09ea3b9bb246128ab579ea00aaf'),
	(98,'B','200607','200607','Ballpoint','9fd36857f0a75898a7eed3b418920de7d9a'),
	(99,'B','200608','200608','Stampel + tinta stampel','723ad4a76960672bc584b2c1671db7d89ce'),
	(100,'B','200609','200609','Amplop Putih Besar, Kecil','21d223e3b835300567732644f43c7c3b421'),
	(101,'B','200610','200610','Stapler dan isi','8c102a51c5ae62ede736a829d36ed4d13b8'),
	(102,'B','200611','200611','Gunting (Keperluan Siswa/ 2 kelas)','99a541b1767705fe3da79ab2e22ff347acf'),
	(103,'B','200612','200612','Solatip, Lem, Double tape','93295df6dd0f83e73af69c0993a7ab0dc27'),
	(104,'B','200613','200613','Kertas Mika + Kertas Buffalo (untuk Jilid)','28f5120653a8a33969128f48600de7b2234'),
	(105,'B','200614','200614','Copy dan Jilid Lapbul','e484924ae85ed1a44348a56d480dbc74440'),
	(106,'B','200615','200615','Buku tulis kecil','3d3c965b3e80829c84a4c06e2111ca93ffc'),
	(107,'B','200616','200616','Buku tulis besar (folio)','63376d365d6ccac3e90866dc161bb9a3a3b'),
	(108,'B','200617','200617','Penggaris Besi','8e20f33650fe7570222cf7eb9fc02a2a11c'),
	(109,'B','200618','200618','Type x','00a7955db8975a056f0bb152f5cd7697adf'),
	(110,'B','200619','200619','Penghapus karet','a81e9040b2d45e8309f64dd32b8370ed5f5'),
	(111,'B','200620','200620','Penghapus papan tulis','e6d73ff42ca37b85eb7e6e6f57e758cc029'),
	(112,'B','200621','200621','Penggaris 1 meter','78d0db637a6be95c70d6214e87008b1c80b'),
	(113,'B','200622','200622','Paper clip Besar dan Kecil','74f43b97b107bc11e4e32f289aa312455d5'),
	(114,'B','200623','200623','MAP Kertas','91296996831f9d7bb69094f6ac9770b9bb2'),
	(115,'B','200624','200624','Map plastik','40922b7f18a81586bdfad1af53c5f4178d1'),
	(116,'B','200625','200625','Kertas jasmine','5ef9934e88e3b08a06a80fc6ac5bb7b40ea'),
	(117,'B','200626','200626','Label stiker','50e6ad5ec6ecdca57e31a622c11ce1eb474'),
	(118,'B','200627','200627','Kertas kado','bb2df5082823f0227d2c9ec0a1fa213ee8b'),
	(119,'B','200628','200628','Box file','27b8bce892d9da5af8d313937b9d13a03ae'),
	(120,'B','200629','200629','Karet gelang','78162b534e46698136aa3043a6a276579f2'),
	(121,'B','200630','200630','Odner file','401e95d96df79230f38957482471acc0c1e'),
	(122,'B','200631','200631','Cutter + isi cutter','a78d9c1d169f71c48b0a424f63009a307f6'),
	(123,'B','200632','200632','Kresek buku','193872f954d96db6d5fa5fdac0802e3c229'),
	(229,'B','202106','202106','Buku Pelajaran','ca98ab2d8251636a0d69c516b3705e8b324'),
	(228,'B','202005','202005','Perjalanan Dinas dan Humas','af078f8ea7e9cffa2979ef7cade60cb9099'),
	(137,'B','200701','200701','Materai 10.000','cfe5a0b5a40b4ddd493778305923e8c6a18'),
	(227,'B','201713','201713','Peralatan maintenance (kuas, sikat, paku dll)','3283fa71cdb2342dda82af466ece9f5cbaf'),
	(226,'B','201712','201712','Pupuk taman','54934727d8e7caf43f44025a08c8e88a0f0'),
	(141,'B','200801','200801','Sabun Cuci Tangan','0196d9752bc04c255c2651561c64d93674a'),
	(142,'B','200802','200802','Masker','3e731971ec06f2d2f7d518d24c80bd8e92e'),
	(143,'B','200803','200803','UKS (Obat-obatan)','99646e8670b2b36d8e1af3138e643df4531'),
	(225,'B','201711','201711','Peralatan dapur (galon, gelas, piring dll)','a2a0a31f2194ab4ded0ed40e72742fa4376'),
	(145,'B','200901','200901','Pengadaan alat olahraga','b37fac3f1acf6c4a107ce563063bd081952'),
	(146,'B','200902','200902','Perlengkapan praktik seni rupa','d726518409653dd36aafe1ddd64015c1cb4'),
	(147,'B','200903','200903','Aparatus KBM 12 Rombel','5a304615e59a56300275ef245c7b110bc90'),
	(150,'B','201001','201001','Iuran Gugus','7205927daeeda6c1115ecfb50db9fb3e3eb'),
	(151,'B','201002','201002','Kegiatan KKG Guru (6org x 20rb x 12bln)','6191d9a03f47c612e6a720e712537cd8a32'),
	(152,'B','201003','201003','Kegiatan KKG PAI','8c0c53a416d2e93b1ebc87951b43281bab9'),
	(153,'B','201004','201004','Kegiatan KKG PJOK','e298a1f431dbdff778933626e720b4bd205'),
	(154,'B','201005','201005','Kegiatan Operator BOS','b74b3ff57c48eda94d5f409ec8a75c845d2'),
	(155,'B','201006','201006','Kegiatan Upgrading Guru','1acbf888c0941afeaed048f76546ea2a331'),
	(156,'B','201101','201101','Overhead Kepersonaliaan','8620654f6ad3e80f72c5e56d969f7f9004a'),
	(157,'B','201102','201102','THR Guru dan Pegawai','2908e9c011c6ecbefda384fc669ca0cd81d'),
	(158,'B','201103','201103','Gaji Guru dan Karyawan','89c3c88d08a913244a926f7a5cbcdb09063'),
	(159,'B','201201','201201','Seragam Guru dan Karyawan','ca294205968d8efb3e019aa60d905094f73'),
	(161,'B','201301','201301','Rapat wali murid awal tahun (Learning Contrak)','a561b35b5b7be09613b48e1d257e93a0bac'),
	(162,'B','201302','201302','Rapat wali murid rutin Smstr 1','64eca661bdf5c11ad6a00c5d356a603c41d'),
	(163,'B','201303','201303','Rapat wali murid Akhir Tahun','0808f7fe63bec870441d3f04e9123664185'),
	(165,'B','201401','201401','Maintenance AC (Kelas, R. Guru, Mushola, dll) 37 unit','e3ad01979fd466132506522211d9ac102fb'),
	(166,'B','201402','201402','Pulsa HP SD dan Operator Sekolah','9c0e545ec5666715cd81c8470eb7aec2e29'),
	(167,'B','201403','201403','Maintenance Mobil dan Motor operasional','3b213aacc80987114b3ad76070dfa89a934'),
	(168,'B','201404','201404','Maintenance Printer','b8a26aeb58dc4fec5bb06149013cc10cf3b'),
	(169,'B','201405','201405','Maintenance Komputer + Laptop','94f6d1149bdf9239a6a5a53e3598c626543'),
	(170,'B','201406','201406','Wifi dan Telfon','b3eb7f91f0799874c843b52bb677c883ac6'),
	(172,'B','201501','201501','Mading Sekolah','0b465072fdba2337561d8c2a30b7bcb05a6'),
	(173,'B','201502','201502','Papan Info Kantor','f27635bc9afbfa84a409ae48c6d9f92dec5'),
	(175,'B','201601','201601','Peremajaan Bangunan','13174a5ae720f55a58ec664d39da9cdb546'),
	(176,'B','201602','201602','Dekorasi Kelas','d8c5bb17b7dbe74acf2cff372b8cd4fccf8'),
	(178,'B','201701','201701','Tisu (1 bulan 10pcs)','a66fad44699270d0ff11d8b1c98e9df2386'),
	(179,'B','201702','201702','Bahan pembersih lantai 3 lantai','a5fad663865a88af07dfa2d8f1cdb8d8202'),
	(180,'B','201703','201703','Bahan pembersih kamar mandi 3 lantai','6e48cba0ec9358d645304bb7062215550c6'),
	(181,'B','201704','201704','Pewangi ruangan 20 ruangan','90481e4c9c0d1b1072e1c7a3b1584cd6617'),
	(182,'B','201705','201705','Serbet tangan','e1e5b84d6a4a71321d03c8514eebadf9008'),
	(183,'B','201706','201706','Plastik sampah','de4ae824e0c8af6810352b3c1572fbe3eff'),
	(184,'B','201707','201707','Ember 12 kamar mandi','430af0034a5ab049e7e9329b90befe49740'),
	(185,'B','201708','201708','Gayung','83222b4903463c6574ea7613f48eb30e556'),
	(186,'B','201709','201709','Sapu Lidi 3 lantai Sapu Ijuk 2','c06ed39e0bf0aac6b69b9fb80344e9749a5'),
	(187,'B','201710','201710','Alat pel','c5242b7f3a543288d471aa79d06755c0a90'),
	(188,'B','201801','201801','Perawatan bangunan','96ab5cc2f028ce504d5cc25ab0643ada5ba'),
	(189,'B','201802','201802','Perbaikan mebeler','451ca5ca2c6db89669fa53c5298c2b47620'),
	(190,'B','201901','201901','Listrik','7e422d8c8f68291cddfb25c52a423dd3e47'),
	(191,'B','201902','201902','Wifi','11cb8bae9fb1e6f1fb2aed7056f4aeac45a'),
	(192,'B','202001','202001','Pajak Bangunan Tahunan','16a9ef155d8347baf5a3403952d6612b59b'),
	(193,'B','202002','202002','Pajak Membangun','ce7c33ae075211a8964d7e3d1bc7c431eb0'),
	(194,'B','202003','202003','Keamanan dan Kebersihan','872b94af2e168fb7fb9570dfd0cb8e4dcb7'),
	(195,'B','202004','202004','Pajak Mobil dan Motor','a2cfaac9470f824d9aa22f13285c7d66ab5'),
	(196,'B','202101','202101','Asuransi','93877243a753b94366b1dc13887c70ac074'),
	(197,'B','202102','202102','Lanyard','4b80de6d6b1a0fba56e26bf7912f082f427'),
	(198,'B','202103','202103','Buku Saku','e8b3ed0ab3b41aff278f0bdeccbd32ad76e'),
	(199,'B','202104','202104','Seragam Marron','c0a9603234fb5a5cfa0aa0b7937e1fedf8f'),
	(200,'B','202105','202105','Uang Gedung (siswa lama)','bd42fb12a5d223cffbdccdf3379262cfb8e'),
	(201,'B','202201','202201','Tas Souvenir','8e7e5259818414f3326931494e04022d058'),
	(202,'B','202202','202202','Aplikasi BSI','d2d37b889e1a2905cd7f58e2dd018a8e14e'),
	(203,'B','202203','202203','Seragam 6 pcs','20d432840b68a8a51075ccaf923dcb72fe1'),
	(204,'B','202204','202204','Cover Raport','efa46b748973d40f0399ba971448449869f'),
	(205,'B','202205','202205','Fasilitas Siswa (siswa Baru)','4ddf353bc734809f524f198acc9bdb08c13'),
	(206,'B','202206','202206','Uang Gedung','c215b25a2c96929548a12953e7a57d03385'),
	(207,'B','201104','201104','Tunjangan Gaji Guru dari Dana BOS','e10b0e03a5bfc30223ead55fa385231783f'),
	(209,'B','200104','200104','Penyusunan Rapot','dde4acfdb0be07a6e873e292175d80c0fe0'),
	(210,'B','200105','200105','Pelaksanaan AKM','e085d8a5248ec1ce76dbfd059ae2b3f5ed0'),
	(211,'B','200106','200106','Pelaksanaan Try Out Ujian','7a303a097dd4e0255bd26e8fd16bbd8ddc8'),
	(212,'B','200107','200107','MAP Ijazah','6752ca88e78474be27051e778e92e42289e'),
	(213,'B','200205','200205','Kegiatan Gema Pramuka Kwarcab (Pendaftaran, Bendera Gugus, dll)','a73abdea647b1f98e59b3040c8058e7caca'),
	(214,'B','200206','200206','Kegiatan Market Day','b868fceef15596e7c0fc55f7ee5cbd55926'),
	(215,'B','200207','200207','Kegiatan Wisuda Tahfidz + Language Festival','0d2f083046d6716440a18f60cb1971dc1a3'),
	(216,'B','200208','200208','Kegiatan Fieldtrip / Edu Trip','41f53a6ca4b44a5d60342a784a276e3c85c'),
	(217,'B','200209','200209','Kegiatan Open House (fun fest )','0f16930fdf163dd448901a77845fd6f9726'),
	(218,'B','200210','200210','Kegiatan Expert Arrival','71464592903d1ac97ba47bf0eb66abecddf'),
	(219,'B','200211','200211','Kegiatan Edu Tour','f8ffa9755a6cba4f083c35d49c80b863ef0'),
	(220,'B','200212','200212','Kegiatan Aquatic','bd23ae2a0b3446016a34280742f9dd4e751'),
	(221,'B','200213','200213','Kegiatan Dental Check Up &amp; Medical Check Up','880cf54e3b7ac13388fba0cc17519ad0326'),
	(222,'B','200214','200214','Kegiatan Akhir Tahun Pentas Seni','818fee80025f461e614f083e5a73ff965d0'),
	(223,'B','200215','200215','Kegiatan Lailatul Ijtima','4205077d384bf98ac29482de7806a2b1a99'),
	(224,'B','200216','200216','Kegiatan First day activity','fc126f454e6ff021cb5ab12b23d0787ae70'),
	(230,'B','200217','200217','Kegiatan Pesantren Ramadhan','506bcd452219f9e3103c1b0bad21be1c56d'),
	(231,'B','200218','200218','Kegiatan Qur&#039;an Camp','3e2a561854eeb6f2d6cd6211df58e897078'),
	(232,'B','200219','200219','Kegiatan English Camp','ce660404643b52abbb69d74a5d8feae3c3c'),
	(233,'B','200904','200904','Dekorasi Kelas','d69d7ac9fea6fe0acf2cff372b8cd4fccf8'),
	(234,'B','200100','1.1','Penyusunan Kurikulum','68e9f04057c2e781950898def36bf62a493'),
	(235,'B','200200','1.2','Proses Pembelajaran dan Evaluasi','c0d29696fc1eea73f89bc04bb21fcbc0898'),
	(236,'B','200300','1.3','Pelaksanaan Pembinaan Lomba','8f9b468710bf68266d099fe49ee91951c97'),
	(237,'B','200400','1.4','Pengembangan Kegiatan Pembelajaran','2fa321697b5068480daf5a934e6459143ef'),
	(238,'B','200500','2.1','Penerimaan Peserta Didik Baru (PPDB)','58fdb9d442eece4da21512b5c3c8f6a6cf6'),
	(239,'B','200600','2.2','Alat Pendukung Proses pembelajaran','1424115d21efe35928202c5097428db6a25'),
	(240,'B','200700','2.3','Pembelian Benda Pos','ff93378f1ecc67b25ade527b821ef183519'),
	(241,'B','200800','2.4','Peralatan Kesehatan dan Keselamatan','f7ea6ec0a29aec940d816fd73ad4d629910'),
	(242,'B','200900','2.5','Pembelian Alat / Bahan Penunjang KBM','2d32bb1c4469bc0bb083b1f5f64f7574e3b'),
	(243,'B','201000','3.1','Rapat Kerja Guru dan Pegawai','4a1f48b04255aa8de5b731c878a8be5cca8'),
	(244,'B','201100','3.2','Pengembangan Managemen Sekolah','c2f3f18224af9a7e7d7ceedc933108474f0'),
	(245,'B','201200','4.1','Rapat Pengelolaan Sekolah','a5d5f5c102be98c73c6b0f9f0163b7d0a1e'),
	(246,'B','201300','4.2','Langganan Daya dan Jasa','9d88f5dcc6541b073c9544b2c74bddd9674'),
	(247,'B','201400','6.2','Pembiayaan Lain Lain','4c68da7df3e0aa6a62ba12c7ad2f3ebd292'),
	(248,'B','201500','7.1','Perlengkapan Siswa Kelas 2 s.d 5','25bde4604c0d4bb254a71b7f9091f89376d'),
	(249,'B','201600','7.2','Perlengkapan Siswa Kelas 6','34e5b2ef0d3ca635c724a63eaed7856ffef'),
	(250,'B','201700','8.1','Perlengkapan Siswa Baru','406511df6fe0bd1a60439345adb23ce5fb5'),
	(251,'B','200220','200220','Kegiatan Class Meeting','454b8dcf6c020558b82822a34c9aa5981fc'),
	(252,'B','201304','201304','Iuran Gugus','690ddbe665152441115ecfb50db9fb3e3eb'),
	(253,'B','202006','202006','Air Minum','96333c091f8ee344c3cf6aae13acda5023b'),
	(254,'B','202007','202007','BPJS','77d83f050f38312b51f25a72f1f8361e28e'),
	(255,'B','202008','202008','Makan Guru','dae922b126caaef781251b5888d8d0c6e42'),
	(256,'B','202009','202009','Overhead','c111e2209dcd2754bd3d77aa902ded54fe4'),
	(257,'B','202207','202207','Psikolog','6004b25b2674d3a6e44675aae72f6d0ddfe'),
	(258,'B','200221','200221','Kegiatan Pengenalan Gerakan Pramuka','bab74fbbae5737c09505299a50e4af7377e');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_ref_kegiatan`;

CREATE TABLE IF NOT EXISTS `simakom_ref_kegiatan` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(100) NOT NULL,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `kegiatan_custome` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=127 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_ref_kegiatan` (`no`, `id`, `kategori`, `kegiatan`, `kegiatan_custome`, `uraian`) VALUES
	(112,'a9b7ba70783b617098511567db0608bb3c3','A','1000','1000','PENERIMAAN SALDO TAHUN LALU'),
	(113,'aa68c75c4a77c872575645885b00ac6e1cb','A','1003','1003','PENERIMAAN SUMBANGAN PEMERINTAH'),
	(114,'5ec829debe54b19c1ae8815b6e0893787ba','A','1999','1999','PENERIMAAN LAINNYA'),
	(115,'b8c37e33defde51b466c24fd5b3374e006a','A','1001','1001','PENERIMAAN PENDAPATAN ASLI SEKOLAH'),
	(116,'08f90c1a41715530d57fb65210fd5641805','B','2000','2000','BELANJA PENGEMBANGAN KURIKULUM'),
	(117,'d0fb963ff976f9caa85c9573cde9eecc49c','B','2001','2001','BELANJA PENGEMBANGAN STANDARD PROSES'),
	(118,'4ba29b9f9e5732eba330560ce8dea080c85','B','2002','2002','BELANJA PENGEMBANGAN PENDIDIK DAN TENAGA  KEPENDIDIKAN'),
	(119,'a591024321c5e2be1e7995c3691c587c2b4','B','2003','2003','BELANJA PENGEMBANGAN STANDAR PENGELOLAAN'),
	(120,'b8b4b727d6f5d1b432ac766b69336db5531','B','2004','2004','BELANJA PENGEMBANGAN SARANA DAN PRASARANA'),
	(121,'d47268e9db2e9aa1a4664e16cca14a573a8','B','2005','2005','BELANJA PENGEMBANGAN STANDAR PEMBIAYAAN'),
	(122,'ea5a486c712a91e1a4664e16cca14a573a8','B','2006','2006','BELANJA PENGEMBANGAN STANDAR PEMBIAYAAN'),
	(123,'a00e5eb0973d246abeddaf41d228e0a578a','B','2007','2007','PENDAFTARAN SISWA BARU'),
	(124,'fba9d88164f3e2d7af13b734aa6b0d6a919','A','1002','1002','PENERIMAAN UANG EKSTRAKURIKULER'),
	(125,'a36e841c5230a793c0924129aa796561a71','B','2999','2999','BELANJA LAINNYA'),
	(126,'fed33392d3a48aaede08e670f8c37be7ebd','A','1004','1004','PENERIMAAN SUMBANGAN MASYARAKAT');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_nama_bayar`;

CREATE TABLE IF NOT EXISTS `tb_nama_bayar` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(10) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kode` varchar(2) NOT NULL,
  `bulanan` varchar(10) NOT NULL,
  `id` varchar(15) NOT NULL,
  `blok` varchar(20) NOT NULL,
  `kelas` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=161 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_nama_bayar` (`no`, `tp`, `nama`, `kode`, `bulanan`, `id`, `blok`, `kelas`) VALUES
	(31,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024A8','','11'),
	(32,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024A9','','12'),
	(34,'2023/2024','Sumbangan Operasional Sekolah (SOP)','B','Ya','2023/2024B10','','10'),
	(35,'2023/2024','Sumbangan Operasional Sekolah (SOP)','B','Ya','2023/2024B8','','11'),
	(36,'2023/2024','Sumbangan Operasional Sekolah (SOP)','B','Ya','2023/2024B9','','12'),
	(53,'2023/2024','Uang Kegiatan','C','Tidak','2023/2024C8','','11'),
	(54,'2023/2024','Uang Kegiatan','C','Tidak','2023/2024C9','','12'),
	(61,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024ALulus','','LULUS'),
	(62,'2023/2024','Uang Kegiatan','C','Tidak','2023/2024C7','','10'),
	(63,'2024/2025','Tunggakan Tahun lalu','A','Tidak','2024/2025A2','','2'),
	(64,'2024/2025','Tunggakan Tahun lalu','A','Tidak','2024/2025A3','','3'),
	(65,'2024/2025','Tunggakan Tahun lalu','A','Tidak','2024/2025A4','','4'),
	(66,'2024/2025','Tunggakan Tahun lalu','A','Tidak','2024/2025A5','','5'),
	(67,'2024/2025','Tunggakan Tahun lalu','A','Tidak','2024/2025A6','','6'),
	(68,'2024/2025','Tunggakan Tahun lalu','A','Tidak','2024/2025ALulus','','Lulus'),
	(69,'2024/2025','SPP','B','Ya','2024/2025B1','','1'),
	(70,'2024/2025','SPP','B','Ya','2024/2025B2','','2'),
	(71,'2024/2025','SPP','B','Ya','2024/2025B3','','3'),
	(72,'2024/2025','SPP','B','Ya','2024/2025B4','','4'),
	(73,'2024/2025','SPP','B','Ya','2024/2025B5','','5'),
	(74,'2024/2025','SPP','B','Ya','2024/2025B6','','6'),
	(75,'2024/2025','Biaya Pendidikan','C','Tidak','2024/2025C1','','1'),
	(76,'2024/2025','Biaya Pendidikan','C','Tidak','2024/2025C2','','2'),
	(77,'2024/2025','Biaya Pendidikan','C','Tidak','2024/2025C3','','3'),
	(78,'2024/2025','Biaya Pendidikan','C','Tidak','2024/2025C4','','4'),
	(79,'2024/2025','Biaya Pendidikan','C','Tidak','2024/2025C5','','5'),
	(80,'2024/2025','Biaya Pendidikan','C','Tidak','2024/2025C6','','6'),
	(81,'2024/2025','Biaya Pendidikan','C','Tidak','2024/2025CLulus','','Lulus'),
	(82,'2024/2025','SPP','B','Ya','2024/2025BLulus','','Lulus'),
	(83,'2024/2025','Extrakurikuler','D','Ya','2024/2025D1','','1'),
	(84,'2024/2025','Extrakurikuler','D','Ya','2024/2025D2','','2'),
	(85,'2024/2025','Extrakurikuler','D','Ya','2024/2025D3','','3'),
	(86,'2024/2025','Extrakurikuler','D','Ya','2024/2025D4','','4'),
	(87,'2024/2025','Extrakurikuler','D','Ya','2024/2025D5','','5'),
	(88,'2024/2025','Extrakurikuler','D','Ya','2024/2025D6','','6'),
	(89,'2024/2025','Extrakurikuler','D','Ya','2024/2025DLulus','','Lulus'),
	(110,'2024/2025','Uang Pendaftaran Siswa Baru','E','Tidak','2024/2025E1','','1'),
	(111,'2024/2025','Uang Pendaftaran Siswa Baru','E','Tidak','2024/2025E2','','2'),
	(112,'2024/2025','Uang Pendaftaran Siswa Baru','E','Tidak','2024/2025E3','','3'),
	(113,'2024/2025','Uang Pendaftaran Siswa Baru','E','Tidak','2024/2025E4','','4'),
	(114,'2024/2025','Uang Pendaftaran Siswa Baru','E','Tidak','2024/2025E5','','5'),
	(115,'2024/2025','Uang Pendaftaran Siswa Baru','E','Tidak','2024/2025E6','','6'),
	(116,'2024/2025','Shadow Teacher','F','Ya','2024/2025F1','','1'),
	(117,'2024/2025','Shadow Teacher','F','Ya','2024/2025F2','','2'),
	(118,'2024/2025','Shadow Teacher','F','Ya','2024/2025F3','','3'),
	(119,'2024/2025','Shadow Teacher','F','Ya','2024/2025F4','','4'),
	(120,'2024/2025','Shadow Teacher','F','Ya','2024/2025F5','','5'),
	(121,'2024/2025','Shadow Teacher','F','Ya','2024/2025F6','','6'),
	(122,'2025/2026','Tunggakan Tahun lalu','A','Tidak','2025/2026A2','','2'),
	(123,'2025/2026','Tunggakan Tahun lalu','A','Tidak','2025/2026A3','','3'),
	(124,'2025/2026','Tunggakan Tahun lalu','A','Tidak','2025/2026A4','','4'),
	(125,'2025/2026','Tunggakan Tahun lalu','A','Tidak','2025/2026A5','','5'),
	(126,'2025/2026','Tunggakan Tahun lalu','A','Tidak','2025/2026A6','','6'),
	(127,'2025/2026','Tunggakan Tahun lalu','A','Tidak','2025/2026ALulus','','Lulus'),
	(128,'2025/2026','SPP','B','Ya','2025/2026BLulus','','Lulus'),
	(129,'2025/2026','SPP','B','Ya','2025/2026B6','','6'),
	(130,'2025/2026','SPP','B','Ya','2025/2026B5','','5'),
	(131,'2025/2026','SPP','B','Ya','2025/2026B4','','4'),
	(132,'2025/2026','SPP','B','Ya','2025/2026B3','','3'),
	(133,'2025/2026','SPP','B','Ya','2025/2026B2','','2'),
	(134,'2025/2026','SPP','B','Ya','2025/2026B1','','1'),
	(135,'2025/2026','Biaya Pendidikan','C','Tidak','2025/2026CLulus','','Lulus'),
	(136,'2025/2026','Biaya Pendidikan','C','Tidak','2025/2026C6','','6'),
	(137,'2025/2026','Biaya Pendidikan','C','Tidak','2025/2026C5','','5'),
	(138,'2025/2026','Biaya Pendidikan','C','Tidak','2025/2026C4','','4'),
	(139,'2025/2026','Biaya Pendidikan','C','Tidak','2025/2026C3','','3'),
	(140,'2025/2026','Biaya Pendidikan','C','Tidak','2025/2026C2','','2'),
	(141,'2025/2026','Biaya Pendidikan','C','Tidak','2025/2026C1','','1'),
	(142,'2025/2026','Extrakurikuler','D','Ya','2025/2026DLulus','','Lulus'),
	(143,'2025/2026','Extrakurikuler','D','Ya','2025/2026D6','','6'),
	(144,'2025/2026','Extrakurikuler','D','Ya','2025/2026D5','','5'),
	(145,'2025/2026','Extrakurikuler','D','Ya','2025/2026D4','','4'),
	(146,'2025/2026','Extrakurikuler','D','Ya','2025/2026D3','','3'),
	(147,'2025/2026','Extrakurikuler','D','Ya','2025/2026D2','','2'),
	(148,'2025/2026','Extrakurikuler','D','Ya','2025/2026D1','','1'),
	(149,'2025/2026','Uang Pendaftaran Siswa Baru','E','Tidak','2025/2026E6','','6'),
	(150,'2025/2026','Uang Pendaftaran Siswa Baru','E','Tidak','2025/2026E5','','5'),
	(151,'2025/2026','Uang Pendaftaran Siswa Baru','E','Tidak','2025/2026E4','','4'),
	(152,'2025/2026','Uang Pendaftaran Siswa Baru','E','Tidak','2025/2026E3','','3'),
	(153,'2025/2026','Uang Pendaftaran Siswa Baru','E','Tidak','2025/2026E2','','2'),
	(154,'2025/2026','Uang Pendaftaran Siswa Baru','E','Tidak','2025/2026E1','','1'),
	(155,'2025/2026','Shadow Teacher','F','Ya','2025/2026F1','','1'),
	(156,'2025/2026','Shadow Teacher','F','Ya','2025/2026F2','','2'),
	(157,'2025/2026','Shadow Teacher','F','Ya','2025/2026F3','','3'),
	(158,'2025/2026','Shadow Teacher','F','Ya','2025/2026F4','','4'),
	(159,'2025/2026','Shadow Teacher','F','Ya','2025/2026F5','','5'),
	(160,'2025/2026','Shadow Teacher','F','Ya','2025/2026F6','','6');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_paralel`;

CREATE TABLE IF NOT EXISTS `tb_paralel` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(50) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `status` varchar(15) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_paralel` (`no`, `id`, `paralel`, `status`) VALUES
	(18,'9d5ed678fe57e75fa5704cf40','2','Aktif'),
	(21,'0d61f8370cad82c486547f599','3','Aktif'),
	(23,'7fc56270e7a70c1fbfac34ac2','1','Aktif'),
	(24,'f623e75af30e6f2052d0bd5ba','4','Aktif'),
	(25,'3a3ea00cfc35009f23e17ec68','5','Aktif');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa_kategori`;

CREATE TABLE IF NOT EXISTS `tb_siswa_kategori` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(200) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_siswa_kategori` (`no`, `kategori`, `id`, `created_at`) VALUES
	(1,'Umum','919db3a7bfc497f00ddfb51592d','2023-05-24 05:31:46'),
	(4,'MMP','606670ce12a5a75f2ada86cae30','2023-07-31 08:44:47'),
	(5,'Akademik','1603223377224863b9c36f969e2','2023-07-31 08:44:57'),
	(6,'KKO','de3ad54b3bd47253639bd484582','2023-07-31 08:45:02');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_tp`;

CREATE TABLE IF NOT EXISTS `tb_tp` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(9) NOT NULL,
  `backup` varchar(100) NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tp` (`no`, `tp`, `backup`, `time`, `id`, `created_at`, `created_by`) VALUES
	(16,'2024/2025','','2024-07-09 21:42:24','07811dc6c42276c5a4048af63','2024-07-09 21:42:24','50463efa59739fd6caf07114793ee291'),
	(17,'2025/2026','','2024-12-07 16:07:26','312351bff0792b8216c5bb69a','2024-12-07 16:07:26','50463efa59739fd6caf07114793ee291'),
	(18,'2022/2023','','2025-06-20 09:16:25','3a824154b16ebafe11507af59','2025-06-20 09:16:25','e3afed0047b08059d0fada10f400c1e5');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_walikelas`;

CREATE TABLE IF NOT EXISTS `tb_walikelas` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(9) NOT NULL,
  `jenjang` varchar(2) NOT NULL,
  `paralel` varchar(100) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `nip` varchar(18) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_walikelas` (`no`, `tp`, `jenjang`, `paralel`, `nama`, `nip`, `id`, `created_at`, `created_by`) VALUES
	(1,'2024/2025','1','1','B. Yuni &amp; B. Dian','12345678','5cc7325d556512bf769b','2024-12-10 13:35:43','50463efa59739fd6caf07114793ee291'),
	(2,'2024/2025','1','2','B. Nuy &amp; B. Zahra','12345678','7894625d55c20add91c8','2024-12-10 13:36:10','50463efa59739fd6caf07114793ee291'),
	(3,'2024/2025','2','1','B. Khayatunnisa &amp; Y. Rofik','12345678','06a1f25d553c59d05f11','2024-12-10 13:36:42','50463efa59739fd6caf07114793ee291'),
	(4,'2024/2025','2','2','B. Vinca &amp; Y. Wendy','12345678','5bd9d25d55b6d76091ca','2024-12-10 13:37:02','50463efa59739fd6caf07114793ee291'),
	(5,'2024/2025','3','1','B. Anis &amp; B. Zahro','12345678','c7df925d55c16a5f084d','2024-12-10 13:37:42','50463efa59739fd6caf07114793ee291'),
	(6,'2024/2025','3','2','B. Cut &amp; B. Rizqi','12345678','79f6625d556364ddbd94','2024-12-10 13:38:03','50463efa59739fd6caf07114793ee291'),
	(7,'2024/2025','4','1','Y. Eggy &amp; B. Lisa','12345678','8ce3325d553416a3d9af','2024-12-10 13:38:29','50463efa59739fd6caf07114793ee291'),
	(8,'2024/2025','5','1','B. Maya &amp; Y. Fauzi','12345678','c8ba725d5528380c7fc7','2024-12-10 13:38:56','50463efa59739fd6caf07114793ee291'),
	(9,'2024/2025','5','2','B. Qonita &amp; Y. Angga','12345678','aae4b25d559a115d7f78','2024-12-10 13:39:17','50463efa59739fd6caf07114793ee291'),
	(10,'2024/2025','6','1','B. Sylvia &amp; Y. Solichin','12345678','b2c1a25d557f39fda74c','2024-12-10 13:39:40','50463efa59739fd6caf07114793ee291');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `whatsapp`;

CREATE TABLE IF NOT EXISTS `whatsapp` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `aktif` varchar(1) NOT NULL,
  `sistem` varchar(2) NOT NULL,
  `key_api` text DEFAULT NULL,
  `server` text NOT NULL,
  `token` varchar(100) DEFAULT NULL,
  `device` varchar(15) DEFAULT NULL,
  `idinstance` text DEFAULT NULL,
  `admin` varchar(15) DEFAULT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `whatsapp` (`no`, `aktif`, `sistem`, `key_api`, `server`, `token`, `device`, `idinstance`, `admin`, `id`) VALUES
	(1,'','','','','0','','','0','4C88C222085FD72DE2D7BC1376625660');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_periode`;

CREATE TABLE IF NOT EXISTS `tabungan_periode` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tahun` varchar(9) NOT NULL,
  `status` varchar(6) NOT NULL,
  `created_at` datetime NOT NULL,
  `closed_at` datetime DEFAULT NULL,
  `closed_by` varchar(100) DEFAULT NULL,
  `id` varchar(25) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `tahun` (`tahun`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tabungan_periode` (`no`, `tahun`, `status`, `created_at`, `closed_at`, `closed_by`, `id`) VALUES
	(1,'2022/2023','close','2023-04-20 11:33:23','2023-10-03 05:06:19','tabungan','38eafdfa86559e303bd0'),
	(23,'2024/2025','open','2024-12-11 21:40:09','1901-01-01 00:00:00','','b97ac64fd7924f1c1b1f'),
	(24,'2025/2026','close','2025-05-18 17:38:51','1901-01-01 00:00:00','','13db618802f7003c1b1f');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_komponen2526`;

CREATE TABLE IF NOT EXISTS `simakom_komponen2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=55 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_komponen2526` (`no`, `kategori`, `kegiatan`, `komponen`, `uraian`, `kode_id`, `id`, `revisi`) VALUES
	(3,'A','1000','AA','Penerimaan Saldo Kas dan Bank Tahun Lalu','A1000AA','7fc56270e7a70faa70783b6172dffc6cb0696a3b','0'),
	(4,'A','1000','AB','Penerimaan Saldo Piutang Tahun Lalu','A1000AB','7fc56270e7a70faa70783b6176b051f63d7a2ef4','0'),
	(5,'A','1001','AA','Penerimaan SPP','A1001AA','7fc56270e7a70fae33defde512dffc6cb06e45ee','0'),
	(6,'A','1001','AB','Penerimaan Biaya Pendidikan','A1001AB','7fc56270e7a70fae33defde516b051f63d77d066','0'),
	(7,'A','1002','AA','Penerimaan Uang Extra Kurikuler','A1002AA','7fc56270e7a70fa88164f3e2d2dffc6cb06751d3','0'),
	(8,'A','1003','AA','Sumbangan Pemerintah Pusat','A1003AA','7fc56270e7a70fa75c4a77c872dffc6cb06faeac','0'),
	(9,'A','1004','AA','Sumbangan Wakaf Infaq dan Sodaqoh','A1004AA','7fc56270e7a70fa392d3a48aa2dffc6cb06d72d1','0'),
	(52,'B','2005','BB','Perlengkapan Siswa Kelas 6','B2005BB','9d5ed8e9db2e9aa048db16a7eee539e93e3618cbe725-06','0'),
	(51,'B','2005','BA','Perlengkapan Siswa Kelas 2 s.d 5','B2005BA','9d5ed8e9db2e9aa0cf62601df84b7923b9964c53e625-06','0'),
	(49,'B','2003','BB','Langganan Daya dan Jasa','B2003BB','9d5ed24321c5e2b048db16a7eee539e93e3618cbe725-06','0'),
	(50,'B','2003','BC','Pembiayaan Lain Lain','B2003BC','9d5ed24321c5e2bb377112c272bc87f3e73f10508d25-06','0'),
	(48,'B','2003','BA','Rapat Pengelolaan Sekolah','B2003BA','9d5ed24321c5e2b0cf62601df84b7923b9964c53e625-06','0'),
	(47,'B','2002','BB','Pengembangan Managemen Sekolah','B2002BB','9d5edb9f9e5732e048db16a7eee539e93e3618cbe725-06','0'),
	(46,'B','2002','BA','Rapat Kerja Guru dan Pegawai','B2002BA','9d5edb9f9e5732e0cf62601df84b7923b9964c53e625-06','0'),
	(45,'B','2001','BE','Pembelian Alat / Bahan Penunjang KBM','B2001BE','9d5ed63ff976f9c429c679f9af82eb9a3b31c4df4425-06','0'),
	(44,'B','2001','BD','Peralatan Kesehatan dan Keselamatan','B2001BD','9d5ed63ff976f9c565be4714701a8bc2354cbaea3625-06','0'),
	(43,'B','2001','BC','Pembelian Benda Pos','B2001BC','9d5ed63ff976f9cb377112c272bc87f3e73f10508d25-06','0'),
	(42,'B','2001','BB','Alat Pendukung Proses pembelajaran / ATK','B2001BB','9d5ed63ff976f9c048db16a7eee539e93e3618cbe725-06','0'),
	(40,'B','2001','BA','Penerimaan Peserta Didik Baru (PPDB)','B2001BA','9d5ed63ff976f9c0cf62601df84b7923b9964c53e625-06','0'),
	(39,'B','2000','BD','Pengembangan Kegiatan Pembelajaran','B2000BD','9d5edc1a4171553565be4714701a8bc2354cbaea3625-06','0'),
	(38,'B','2000','BC','Pelaksanaan Pembinaan Lomba','B2000BC','9d5edc1a4171553b377112c272bc87f3e73f10508d25-06','0'),
	(34,'B','2000','BA','Penyusunan Kurikulum','B2000BA','9d5edc1a41715530cf62601df84b7923b9964c53e625-06','0'),
	(37,'B','2000','BB','Proses Pembelajaran dan Evaluasi','B2000BB','9d5edc1a4171553048db16a7eee539e93e3618cbe725-06','0'),
	(33,'A','1999','AA','Kegiatan Tertentu','A1999AA','7fc56270e7a70fa9debe54b192dffc6cb061732c','0'),
	(54,'B','2007','BA','Perlengkapan Siswa Baru','B2007BA','9d5edeb0973d2460cf62601df84b7923b9964c53e625-06','0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_kegiatan2526`;

CREATE TABLE IF NOT EXISTS `simakom_kegiatan2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_kegiatan2526` (`no`, `kategori`, `kegiatan`, `uraian`, `kode_id`, `id`, `revisi`) VALUES
	(11,'A','1004','Penerimaan Sumbangan Masyarakat','A1004','7fc56270e7a70fa392d3a48aa149a87a38b751d3','0'),
	(10,'A','1003','Penerimaan Sumbangan Pemerintah','A1003','7fc56270e7a70fa75c4a77c87f97fb686b27d066','0'),
	(9,'A','1002','Penerimaan Uang Extra Kurikuler','A1002','7fc56270e7a70fa88164f3e2d9109ee7702e45ee','0'),
	(8,'A','1001','Penerimaan Pendapatan Asli sekolah','A1001','7fc56270e7a70fae33defde51cf91e1e03ea2ef4','0'),
	(7,'A','1000','Penerimaan Saldo Tahun Lalu','A1000','7fc56270e7a70faa70783b617e9998dc4dd96a3b','0'),
	(12,'A','1999','Penerimaan Lain','A1999','7fc56270e7a70fa9debe54b19a5f78d9a65faeac','0'),
	(13,'B','2000','BELANJA PENGEMBANGAN KURIKULUM','B2000','9d5ed678fe57bccc1a417155361a5c4b8d2d72d1','0'),
	(14,'B','2001','BELANJA PENGEMBANGAN STANDARD PROSES','B2001','9d5ed678fe57bcc63ff976f9c37fc81fe03fad6f','0'),
	(15,'B','2002','BELANJA PENGEMBANGAN PENDIDIKAN DAN TENAGA PENDIDIK','B2002','9d5ed678fe57bccb9f9e5732ed33761840f0a800','0'),
	(16,'B','2003','BELANJA PENGEMBANGAN STANDAR PENGELOLAAN','B2003','9d5ed678fe57bcc24321c5e2bdbd23ed35fea20a','0'),
	(17,'B','2004','BELANJA PENGEMBANGAN SARANA DAN PRASARANA','B2004','9d5ed678fe57bcc727d6f5d1b61fff7be6884eb1','0'),
	(18,'B','2005','BELANJA PENGEMBANGAN STANDAR PEMBIAYAAN','B2005','9d5ed678fe57bcc8e9db2e9aa3827bba3afd2490','0'),
	(20,'B','2007','PENERIMAAN SISWA BARU','B2007','9d5ed678fe57bcceb0973d24649a4a920fc0e510','0'),
	(21,'B','2999','BELANJA LAINNYA','B2999','9d5ed678fe57bcc41c5230a79c2102036d2af032','0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_akun2526`;

CREATE TABLE IF NOT EXISTS `simakom_akun2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `akun` float NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `akun_id` varchar(15) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=284 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_akun2526` (`no`, `kategori`, `kegiatan`, `komponen`, `akun`, `uraian`, `kode_id`, `akun_id`, `id`, `revisi`) VALUES
	(2,'A','1000','AA',100000,'Penerimaan Saldo Kas Tahun Lalu','A1000AA','A1000100000AA','7fc56270e7a70783b6172dffc6cb062eaba90611','0'),
	(3,'A','1000','AA',100001,'Penerimaan Saldo Bank Tahun Lalu','A1000AA','A1000100001AA','7fc56270e7a70783b6172dffc6cb061ace3e10e3','0'),
	(4,'A','1000','AB',100002,'Penerimaan Pembayaran Piutang Tahun lalu','A1000AB','A1000100002AB','7fc56270e7a70783b6176b051f63d734eb6898dc','0'),
	(5,'A','1001','AA',100101,'Penerimaan SPP','A1001AA','A1001100101AA','7fc56270e7e33defde512dffc6cb0676ec82b7f8','0'),
	(6,'A','1001','AB',100102,'Penerimaan Biaya Pendidikan','A1001AB','A1001100102AB','7fc56270e7e33defde516b051f63d7a338d21263','0'),
	(7,'A','1002','AA',100201,'Penerimaan Biaya Extrakurikuler','A1002AA','A1002100201AA','7fc56270e788164f3e2d2dffc6cb063f13e2028d','0'),
	(8,'A','1003','AA',100301,'Bantuan Operasional Sekolah (BOS)','A1003AA','A1003100301AA','7fc56270e775c4a77c872dffc6cb06a0c10e90b3','0'),
	(9,'A','1004','AA',100401,'Sumbangan Wakaf Infaq dan Sodaqoh','A1004AA','A1004100401AA','7fc56270e7392d3a48aa2dffc6cb0648a5acd9e5','0'),
	(279,'B','2007','BA',202203,'Seragam 6 pcs','B2007BA','B2007202203BA','840b69d5ede5eb00cf62601df84b7923b9964c53e625-06','0'),
	(271,'B','2007','BA',202202,'Aplikasi BSI','B2007BA','B2007202202BA','889e19d5ede5eb00cf62601df84b7923b9964c53e625-06','0'),
	(270,'B','2007','BA',202201,'Tas Souvenir','B2007BA','B2007202201BA','598189d5ede5eb00cf62601df84b7923b9964c53e625-06','0'),
	(269,'B','2007','BA',202106,'Buku Pelajaran','B2007BA','B2007202106BA','2d8259d5ede5eb00cf62601df84b7923b9964c53e625-06','0'),
	(280,'B','2000','BB',200208,'Kegiatan Fieldtrip / Edu Trip','B2000BB','B2000200208BB','6ca4b9d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(267,'B','2007','BA',202102,'Lanyard','B2007BA','B2007202102BA','6d6b19d5ede5eb00cf62601df84b7923b9964c53e625-06','0'),
	(266,'B','2007','BA',202101,'Asuransi','B2007BA','B2007202101BA','43a759d5ede5eb00cf62601df84b7923b9964c53e625-06','0'),
	(265,'B','2005','BB',202106,'Buku Pelajaran','B2005BB','B2005202106BB','2d8259d5ed268e9048db16a7eee539e93e3618cbe725-06','0'),
	(264,'B','2005','BB',202103,'Buku Saku','B2005BB','B2005202103BB','0ab3b9d5ed268e9048db16a7eee539e93e3618cbe725-06','0'),
	(263,'B','2005','BB',202101,'Asuransi','B2005BB','B2005202101BB','43a759d5ed268e9048db16a7eee539e93e3618cbe725-06','0'),
	(262,'B','2005','BA',202106,'Buku Pelajaran','B2005BA','B2005202106BA','2d8259d5ed268e90cf62601df84b7923b9964c53e625-06','0'),
	(261,'B','2005','BA',202103,'Buku Saku','B2005BA','B2005202103BA','0ab3b9d5ed268e90cf62601df84b7923b9964c53e625-06','0'),
	(260,'B','2005','BA',202101,'Asuransi','B2005BA','B2005202101BA','43a759d5ed268e90cf62601df84b7923b9964c53e625-06','0'),
	(259,'B','2003','BC',202008,'Makan Guru','B2003BC','B2003202008BC','b126c9d5ed10243b377112c272bc87f3e73f10508d25-06','0'),
	(255,'B','2003','BC',202007,'BPJS','B2003BC','B2003202007BC','050f39d5ed10243b377112c272bc87f3e73f10508d25-06','0'),
	(254,'B','2003','BC',202006,'Air Minum','B2003BC','B2003202006BC','091f89d5ed10243b377112c272bc87f3e73f10508d25-06','0'),
	(253,'B','2003','BC',201103,'Gaji Guru dan Karyawan','B2003BC','B2003201103BC','8d08a9d5ed10243b377112c272bc87f3e73f10508d25-06','0'),
	(252,'B','2003','BC',202003,'Keamanan dan Kebersihan','B2003BC','B2003202003BC','af2e19d5ed10243b377112c272bc87f3e73f10508d25-06','0'),
	(246,'B','2003','BB',201403,'Maintenance Mobil dan Motor operasional','B2003BB','B2003201403BB','acc809d5ed10243048db16a7eee539e93e3618cbe725-06','0'),
	(247,'B','2003','BB',201404,'Maintenance Printer','B2003BB','B2003201404BB','eb58d9d5ed10243048db16a7eee539e93e3618cbe725-06','0'),
	(248,'B','2003','BB',201405,'Maintenance Komputer + Laptop','B2003BB','B2003201405BB','149bd9d5ed10243048db16a7eee539e93e3618cbe725-06','0'),
	(249,'B','2003','BC',201901,'Listrik','B2003BC','B2003201901BC','8c8f69d5ed10243b377112c272bc87f3e73f10508d25-06','0'),
	(250,'B','2003','BC',201902,'Wifi','B2003BC','B2003201902BC','ae9fb9d5ed10243b377112c272bc87f3e73f10508d25-06','0'),
	(251,'B','2003','BC',202001,'Pajak Bangunan Tahunan','B2003BC','B2003202001BC','155d89d5ed10243b377112c272bc87f3e73f10508d25-06','0'),
	(245,'B','2003','BB',201402,'Pulsa HP SD dan Operator Sekolah','B2003BB','B2003201402BB','5ec569d5ed10243048db16a7eee539e93e3618cbe725-06','0'),
	(244,'B','2003','BB',201401,'Maintenance AC (Kelas, R. Guru, Mushola, dll) 37 unit','B2003BB','B2003201401BB','979fd9d5ed10243048db16a7eee539e93e3618cbe725-06','0'),
	(243,'B','2003','BA',201304,'Iuran Gugus','B2003BA','B2003201304BA','e66519d5ed102430cf62601df84b7923b9964c53e625-06','0'),
	(242,'B','2003','BA',201303,'Rapat wali murid Akhir Tahun','B2003BA','B2003201303BA','fe63b9d5ed102430cf62601df84b7923b9964c53e625-06','0'),
	(241,'B','2003','BA',201301,'Rapat wali murid awal tahun (Learning Contrak)','B2003BA','B2003201301BA','5b5b79d5ed102430cf62601df84b7923b9964c53e625-06','0'),
	(240,'B','2002','BB',201201,'Seragam Guru dan Karyawan','B2002BB','B2002201201BB','059689d5ed29b9f048db16a7eee539e93e3618cbe725-06','0'),
	(239,'B','2002','BA',201005,'Kegiatan Operator BOS','B2002BA','B2002201005BA','f57c49d5ed29b9f0cf62601df84b7923b9964c53e625-06','0'),
	(238,'B','2001','BE',200904,'Dekorasi Kelas','B2001BE','B2001200904BE','c9fea9d5edb963f429c679f9af82eb9a3b31c4df4425-06','0'),
	(237,'B','2001','BE',200903,'Aparatus KBM 12 Rombel','B2001BE','B2001200903BE','15e599d5edb963f429c679f9af82eb9a3b31c4df4425-06','0'),
	(236,'B','2001','BE',200902,'Perlengkapan praktik seni rupa','B2001BE','B2001200902BE','840969d5edb963f429c679f9af82eb9a3b31c4df4425-06','0'),
	(235,'B','2001','BE',200901,'Pengadaan alat olahraga','B2001BE','B2001200901BE','3f1ac9d5edb963f429c679f9af82eb9a3b31c4df4425-06','0'),
	(234,'B','2001','BD',200803,'UKS (Obat-obatan)','B2001BD','B2001200803BD','8670b9d5edb963f565be4714701a8bc2354cbaea3625-06','0'),
	(233,'B','2001','BD',200802,'Masker','B2001BD','B2001200802BD','71ec09d5edb963f565be4714701a8bc2354cbaea3625-06','0'),
	(232,'B','2001','BD',200801,'Sabun Cuci Tangan','B2001BD','B2001200801BD','752bc9d5edb963f565be4714701a8bc2354cbaea3625-06','0'),
	(231,'B','2001','BC',200701,'Materai 10.000','B2001BC','B2001200701BC','b5a409d5edb963fb377112c272bc87f3e73f10508d25-06','0'),
	(230,'B','2001','BB',200631,'Cutter + isi cutter','B2001BB','B2001200631BB','1d1699d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(229,'B','2001','BB',200630,'Odner file','B2001BB','B2001200630BB','d96df9d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(228,'B','2001','BB',200629,'Karet gelang','B2001BB','B2001200629BB','534e49d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(226,'B','2001','BB',200627,'Kertas kado','B2001BB','B2001200627BB','082829d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(227,'B','2001','BB',200628,'Box file','B2001BB','B2001200628BB','e892d9d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(225,'B','2001','BB',200626,'Label stiker','B2001BB','B2001200626BB','5ec6e9d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(223,'B','2001','BB',200624,'Map plastik','B2001BB','B2001200624BB','7f18a9d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(224,'B','2001','BB',200625,'Kertas jasmine','B2001BB','B2001200625BB','4e88e9d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(221,'B','2001','BB',200622,'Paper clip Besar dan Kecil','B2001BB','B2001200622BB','97b109d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(222,'B','2001','BB',200623,'MAP Kertas','B2001BB','B2001200623BB','968319d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(220,'B','2001','BB',200620,'Penghapus papan tulis','B2001BB','B2001200620BB','f42ca9d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(218,'B','2001','BB',200618,'Type x','B2001BB','B2001200618BB','5db899d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(219,'B','2001','BB',200619,'Penghapus karet','B2001BB','B2001200619BB','40b2d9d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(217,'B','2001','BB',200614,'Copy dan Jilid Lapbul','B2001BB','B2001200614BB','4ae859d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(204,'B','2001','BB',200601,'Kertas HVS A4 dan F4 (Ulangan Harian & Adminstrasi)','B2001BB','B2001200601BB','b7c789d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(216,'B','2001','BB',200613,'Kertas Mika + Kertas Buffalo (untuk Jilid)','B2001BB','B2001200613BB','0653a9d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(214,'B','2001','BB',200611,'Gunting (Keperluan Siswa/ 2 kelas)','B2001BB','B2001200611BB','b17679d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(215,'B','2001','BB',200612,'Solatip, Lem, Double tape','B2001BB','B2001200612BB','f6dd09d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(213,'B','2001','BB',200610,'Stapler dan isi','B2001BB','B2001200610BB','51c5a9d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(211,'B','2001','BB',200608,'Stampel + tinta stampel','B2001BB','B2001200608BB','a76969d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(212,'B','2001','BB',200609,'Amplop Putih Besar, Kecil','B2001BB','B2001200609BB','e3b839d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(210,'B','2001','BB',200607,'Ballpoint','B2001BB','B2001200607BB','57f0a9d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(209,'B','2001','BB',200606,'Tinta Spidol Whiteboard','B2001BB','B2001200606BB','5d09e9d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(208,'B','2001','BB',200605,'Spidol Whiteboard kelas','B2001BB','B2001200605BB','17be89d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(207,'B','2001','BB',200604,'Kertas Raport','B2001BB','B2001200604BB','d3ca49d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(206,'B','2001','BB',200603,'Tinta Printer 4 warna x 12 bulan (untuk 3 mesin printer)','B2001BB','B2001200603BB','f49489d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(175,'B','2001','BA',200504,'Panitia PPDB','B2001BA','B2001200504BA','5d0649d5edb963f0cf62601df84b7923b9964c53e625-06','0'),
	(278,'B','2001','BA',200502,'Promosi Sekolah','B2001BA','B2001200502BA','5053c9d5edb963f0cf62601df84b7923b9964c53e625-06','0'),
	(174,'B','2001','BA',200503,'Wawancara dan Observasi Siswa Baru','B2001BA','B2001200503BA','1a0b59d5edb963f0cf62601df84b7923b9964c53e625-06','0'),
	(176,'B','2001','BA',200505,'Home Visit','B2001BA','B2001200505BA','8517e9d5edb963f0cf62601df84b7923b9964c53e625-06','0'),
	(170,'B','2000','BD',200401,'Kegiatan PHBI (Tahun Baru Islam, Maulid Nabi, Hari Santri, Isra Mi\'raj)','B2000BD','B2000200401BD','2aa949d5ed90c1a565be4714701a8bc2354cbaea3625-06','0'),
	(171,'B','2000','BD',200402,'Kegiatan Event (Lomba Kemerdekaan, hari kartini, hari guru, poe indung, dll)','B2000BD','B2000200402BD','7f7b19d5ed90c1a565be4714701a8bc2354cbaea3625-06','0'),
	(166,'B','2000','BC',200303,'Lomba Nasional','B2000BC','B2000200303BC','1eca79d5ed90c1ab377112c272bc87f3e73f10508d25-06','0'),
	(165,'B','2000','BC',200302,'Lomba Keluar Sekola (Antar SD)','B2000BC','B2000200302BC','1ed6c9d5ed90c1ab377112c272bc87f3e73f10508d25-06','0'),
	(164,'B','2000','BC',200301,'Lomba Kedinasan (FLS2N, KoSN,KSN,O2SN,Sapta PAI, STQ, FTBI)','B2000BC','B2000200301BC','e623d9d5ed90c1ab377112c272bc87f3e73f10508d25-06','0'),
	(163,'B','2000','BB',200220,'Kegiatan Class Meeting','B2000BB','B2000200220BB','cf6c09d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(162,'B','2000','BB',200219,'Kegiatan English Camp','B2000BB','B2000200219BB','046439d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(281,'B','2000','BB',200221,'Kegiatan Pengenalan Gerakan Pramuka','B2000BB','B2000200221BB','bbae59d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(160,'B','2000','BB',200217,'Kegiatan Pesantren Ramadhan','B2000BB','B2000200217BB','452219d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(159,'B','2000','BB',200216,'Kegiatan First day activity','B2000BB','B2000200216BB','454e69d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(158,'B','2000','BB',200215,'Kegiatan Lailatul Ijtima','B2000BB','B2000200215BB','7d3849d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(277,'B','2000','BB',200212,'Kegiatan Aquatic','B2000BB','B2000200212BB','2a0b39d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(156,'B','2000','BB',200213,'Kegiatan Dental Check Up & Medical Check Up','B2000BB','B2000200213BB','4e3b79d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(154,'B','2000','BB',200211,'Kegiatan Study Tour','B2000BB','B2000200211BB','755a69d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(153,'B','2000','BB',200210,'Kegiatan Expert Arrival','B2000BB','B2000200210BB','929039d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(276,'B','2000','BB',200209,'Kegiatan Open House (fun fest )','B2000BB','B2000200209BB','0fdf19d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(275,'B','2000','BB',200207,'Kegiatan Wisuda Tahfidz + Language Festival','B2000BB','B2000200207BB','3046d9d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(149,'B','2000','BB',200206,'Kegiatan Market Day','B2000BB','B2000200206BB','eef159d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(148,'B','2000','BB',200205,'Kegiatan Gema Pramuka Kwarcab (Pendaftaran, Bendera Gugus, dll)','B2000BB','B2000200205BB','ea6479d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(147,'B','2000','BA',200107,'MAP Ijazah','B2000BA','B2000200107BA','88e789d5ed90c1a0cf62601df84b7923b9964c53e625-06','0'),
	(143,'B','2000','BA',200101,'Pembuatan KOSP (dok 1)','B2000BA','B2000200101BA','4c5069d5ed90c1a0cf62601df84b7923b9964c53e625-06','0'),
	(144,'B','2000','BA',200102,'Raker','B2000BA','B2000200102BA','ef7e89d5ed90c1a0cf62601df84b7923b9964c53e625-06','0'),
	(145,'B','2000','BA',200104,'Penyusunan Rapot','B2000BA','B2000200104BA','fdb0b9d5ed90c1a0cf62601df84b7923b9964c53e625-06','0'),
	(146,'B','2000','BA',200105,'Pelaksanaan AKM','B2000BA','B2000200105BA','a52489d5ed90c1a0cf62601df84b7923b9964c53e625-06','0'),
	(157,'B','2000','BB',200214,'Kegiatan Akhir Tahun Pentas Seni','B2000BB','B2000200214BB','800259d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(138,'A','1999','AA',199999,'Penerimaan Lain','A1999AA','A1999199999AA','d81347fc56829de2dffc6cb06a89dcb0d5c60a020625-05','0'),
	(258,'B','2003','BC',202009,'Overhead','B2003BC','B2003202009BC','209dc9d5ed10243b377112c272bc87f3e73f10508d25-06','0'),
	(257,'B','2003','BC',202005,'Perjalanan Dinas dan Humas','B2003BC','B2003202005BC','8ea7e9d5ed10243b377112c272bc87f3e73f10508d25-06','0'),
	(205,'B','2001','BB',200602,'Penggandaan Soal  Assessment Sumatif TS, AS, AT','B2001BB','B2001200602BB','006f09d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(273,'B','2007','BA',202204,'Cover Raport','B2007BA','B2007202204BA','748979d5ede5eb00cf62601df84b7923b9964c53e625-06','0'),
	(274,'B','2007','BA',202207,'Psikolog','B2007BA','B2007202207BA','5b2679d5ede5eb00cf62601df84b7923b9964c53e625-06','0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_detail2526`;

CREATE TABLE IF NOT EXISTS `simakom_detail2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `akun` float NOT NULL,
  `detail` float NOT NULL,
  `detail_id` varchar(20) NOT NULL,
  `uraian` text NOT NULL,
  `volume` varchar(15) NOT NULL,
  `satuan` varchar(50) NOT NULL,
  `unit` varchar(50) NOT NULL,
  `total` varchar(15) NOT NULL,
  `komponen_1` varchar(10) NOT NULL,
  `komponen_2` varchar(10) NOT NULL,
  `komponen_3` varchar(10) NOT NULL,
  `komponen_4` varchar(10) NOT NULL,
  `unit_1` varchar(100) NOT NULL,
  `unit_2` varchar(100) NOT NULL,
  `unit_3` varchar(100) NOT NULL,
  `unit_4` varchar(100) NOT NULL,
  `pembiayaan_id` varchar(50) NOT NULL,
  `pembiayaan_kegiatan` varchar(4) NOT NULL,
  `pembiayaan_komponen` varchar(5) NOT NULL,
  `pembiayaan_akun` varchar(6) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  `time` datetime NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=243 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_detail2526` (`no`, `kategori`, `kegiatan`, `komponen`, `akun`, `detail`, `detail_id`, `uraian`, `volume`, `satuan`, `unit`, `total`, `komponen_1`, `komponen_2`, `komponen_3`, `komponen_4`, `unit_1`, `unit_2`, `unit_3`, `unit_4`, `pembiayaan_id`, `pembiayaan_kegiatan`, `pembiayaan_komponen`, `pembiayaan_akun`, `revisi`, `time`, `kode_id`, `id`) VALUES
	(1,'A','1000','AA',100000,1,'A1000AA10000000100','Penerimaan Saldo Kas Tahun Lalu','1','0','Rp','0','','','','','','','','','','','','','0','2025-05-20 23:38:11','A1000AA','eab3d34a4230849508495cd98f0ddd8b'),
	(2,'A','1000','AA',100001,1,'A1000AA10000100100','Penerimaan Saldo Bank Tahun Lalu','1','0','Rp','0','','','','','','','','','','','','','0','2025-05-20 23:38:11','A1000AA','acef7b8a4230849508495cd98f090611'),
	(3,'A','1000','AB',100002,1,'A1000AB10000200100','Penerimaan Pembayaran Piutang Tahun lalu','1','0','Rp','0','','','','','','','','','','','','','0','2025-05-20 23:38:11','A1000AB','4eb8327a4230849508495cd98f0e10e3'),
	(4,'A','1001','AA',100101,1,'A1001AA10010100100','Penerimaan SPP','1','1221552000','Tahun','1221552000','','','','','','','','','','','','','0','2025-07-17 16:10:22','A1001AA','6ec3ce9a423065a4418a8cd98f0ed36e'),
	(5,'A','1001','AB',100102,1,'A1001AB10010200100','Penerimaan Biaya Pendidikan','1','1192940000','Tahun','1192940000','','','','','','','','','','','','','0','2025-07-17 16:10:42','A1001AB','338a738a423bdf8c02880cd98f0898dc'),
	(6,'A','1002','AA',100201,1,'A1002AA10020100100','Penerimaan Biaya Extrakurikuler Kode Detail','1','0','Rp','0','','','','','','','','','','','','','0','2025-05-20 23:38:11','A1002AA','f1308fba4230849508495cd98f02b7f8'),
	(7,'A','1003','AA',100301,1,'A1003AA10030100100','Bantuan Operasional Sekolah (BOS)','0','1','Rp','0','','','','','','','','','','','','','0','2025-07-17 16:11:25','A1003AA','0c19c09a4230849508495cd98f021263'),
	(8,'A','1004','AA',100401,1,'A1004AA10040100100','Sumbangan Wakaf Infaq dan Sodaqoh','1','0','Rp','0','','','','','','','','','','','','','0','2025-05-20 23:38:11','A1004AA','8a56005a4230849508495cd98f02028d'),
	(240,'B','2000','BB',200221,1,'B2000BB20022100100','Kegiatan Pengenalan Gerakan Pramuka','1','800000','Paket','800000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 15:35:46','B2000BB','bba04e4a423a0e8e3fa0e8e3fa338d71'),
	(239,'B','2000','BB',200208,1,'B2000BB20020800100','Kegiatan Fieldtrip / Edu Trip','211','100000','Siswa','21100000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 15:22:43','B2000BB','6ca1d2b63722eaba29d00247da338d71'),
	(238,'B','2007','BA',202207,1,'B2007BA20220700100','Psikolog','30','250000','Siswa','7500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 15:03:38','B2007BA','5b2994073cb55e038c40c930ba338d71'),
	(235,'B','2007','BA',202202,1,'B2007BA20220200100','Aplikasi BSI','30','50000','Paket','1500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 14:58:19','B2007BA','88975e273cbfd46739f021678a338d71'),
	(234,'B','2007','BA',202201,1,'B2007BA20220100100','Tas Souvenir','30','130000','Pcs','3900000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 13:57:02','B2007BA','5986f0473cbb4052609c9fe39a338d71'),
	(233,'B','2007','BA',202106,1,'B2007BA20210600100','Buku Pelajaran','21','1824000','Siswa','38304000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 13:54:44','B2007BA','2d8584f9dc0b7e03e1297de1fa338d71'),
	(232,'B','2007','BA',202102,1,'B2007BA20210200100','Lanyard','30','17000','Pcs','510000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 13:52:44','B2007BA','6d6d84473cb6452378b2864a8a338d71'),
	(225,'B','2005','BA',202101,1,'B2005BA20210100100','Asuransi','153','50000','Siswa','7650000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 13:44:45','B2005BA','43ad4363e39fd4673912ca3e9a338d71'),
	(226,'B','2005','BA',202103,1,'B2005BA20210300100','Buku Saku','153','15000','Pcs','2295000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 13:46:13','B2005BA','0abc9d93e39886c7f8106997ba338d71'),
	(227,'B','2005','BA',202106,1,'B2005BA20210600100','Buku Pelajaran','153','1824000','Siswa','279072000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 13:47:21','B2005BA','2d8584f3e39b7e03e1890f079a338d71'),
	(228,'B','2005','BB',202101,1,'B2005BB20210100100','Asuransi','37','50000','Orang','1850000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 13:48:22','B2005BB','43ad436fc9efd467393f344b6a338d71'),
	(229,'B','2005','BB',202103,1,'B2005BB20210300100','Buku Saku','37','15000','Pcs','555000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 13:49:06','B2005BB','0abc9d9fc9e886c7f823dbcd8a338d71'),
	(230,'B','2005','BB',202106,1,'B2005BB20210600100','Buku Pelajaran','37','1811000','Siswa','67007000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 13:49:48','B2005BB','2d8584ffc9ef03874e74d34d6a338d71'),
	(231,'B','2007','BA',202101,1,'B2007BA20210100100','Asuransi','21','50000','Siswa','1050000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 13:51:56','B2007BA','43ad4369dc0fd46739bb2c34ba338d71'),
	(224,'B','2003','BC',202009,1,'B2003BC20200900100','Overhead','1','20000000','Paket','20000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 13:43:53','B2003BC','209d48da423dafba9fdafba9fa338d71'),
	(223,'B','2003','BC',202008,1,'B2003BC20200800100','Makan Guru','12','5316667','Bulan','63800004','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 13:42:42','B2003BC','b12a2a8ad4dcb940a0a8b3b09a338d71'),
	(222,'B','2003','BC',202007,1,'B2003BC20200700100','BPJS','32','3150213','Bulan','100806816','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 13:24:23','B2003BC','050c697ad4dc8eec29e64b749a338d71'),
	(221,'B','2003','BC',202006,1,'B2003BC20200600100','Air Minum','12','650000','Bulan','7800000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 11:45:40','B2003BC','091b5baad4d642654cd64a15ca338d71'),
	(220,'B','2003','BC',202005,1,'B2003BC20200500100','Perjalanan Dinas dan Humas','12','150000','Bulan','1800000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 11:41:34','B2003BC','8ea9088ad4ddd62b6fc2fe464a338d71'),
	(219,'B','2003','BC',202003,1,'B2003BC20200300100','Keamanan dan Kebersihan','12','250000','Bulan','3000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 11:40:22','B2003BC','af2fdf3ad4d55e038c7cfba9aa338d71'),
	(218,'B','2003','BC',202001,1,'B2003BC20200100100','Pajak Bangunan Tahunan','1','2100000','Tahun','2100000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 11:39:19','B2003BC','155d23fa423d7fe77bd7fe77ba338d71'),
	(217,'B','2003','BC',201902,1,'B2003BC20190200100','Wifi','12','580000','Bulan','6960000','','','','','','','','','A1001AA10010100100','1001','AA','100101','0','2025-06-23 11:37:50','B2003BC','ae9dbbdad4de898129daee52a76ec85f'),
	(216,'B','2003','BC',201901,1,'B2003BC20190100100','Listrik','12','4000000','Bulan','48000000','','','','','','','','','A1001AA10010100100','1001','AA','100101','0','2025-06-23 11:36:58','B2003BC','8c849e0ad4d8c482a522bd81a76ec85f'),
	(215,'B','2003','BC',201103,1,'B2003BC20110300100','Gaji Guru dan Karyawan','13','75000000','Bulan','975000000','','','','','','','','','A1001AA10010100100','1001','AA','100101','0','2025-06-23 11:35:53','B2003BC','8d06e93ce41ec69c4999cc2c876ec85f'),
	(214,'B','2003','BB',201405,1,'B2003BB20140500100','Maintenance Komputer + Laptop','1','1000000','Paket','1000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 11:34:49','B2003BB','149f0eba423c545f84c545f84a338d71'),
	(213,'B','2003','BB',201404,1,'B2003BB20140400100','Maintenance Printer','3','250000','Bulan','750000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 11:26:33','B2003BB','eb5137abc8755e038c2973530a338d71'),
	(212,'B','2003','BB',201403,1,'B2003BB20140300100','Maintenance Mobil dan Motor operasional','10','50000','Paket','500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 11:23:53','B2003BB','accf6f89446fd46739732a294a338d71'),
	(211,'B','2003','BB',201402,1,'B2003BB20140200100','Pulsa HP SD dan Operator Sekolah','12','100000','Bulan','1200000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 11:18:00','B2003BB','5ec8b77ad4d2eaba2986626aea338d71'),
	(210,'B','2003','BB',201401,1,'B2003BB20140100100','Maintenance AC (Kelas, R. Guru, Mushola, dll) 37 unit','34','150000','Unit','5100000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 10:58:39','B2003BB','979bca59853dd62b6f3bd75a1a338d71'),
	(209,'B','2003','BA',201304,1,'B2003BA20130400100','Iuran Gugus','12','500000','Bulan','6000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 10:56:47','B2003BA','e6678e7ad4d732a294318de45a338d71'),
	(208,'B','2003','BA',201303,1,'B2003BA20130300100','Rapat wali murid Akhir Tahun','211','15000','Orang','3165000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 10:55:42','B2003BA','fe6fdc86372886c7f8a1bfe05a338d71'),
	(207,'B','2003','BA',201301,1,'B2003BA20130100100','Rapat wali murid awal tahun (Learning Contrak)','211','15000','Orang','3165000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 10:53:36','B2003BA','5b5c3436372886c7f8a1bfe05a338d71'),
	(206,'B','2002','BB',201201,1,'B2002BB20120100100','Seragam Guru dan Karyawan','37','250000','Orang','9250000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 10:51:55','B2002BB','059b9c0fc9e55e038ce6cdc5fa338d71'),
	(205,'B','2002','BA',201005,1,'B2002BA20100500100','Kegiatan Operator BOS','10','100000','Bulan','1000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 10:49:33','B2002BA','f57ae2594462eaba29c545f84a338d71'),
	(204,'B','2001','BE',200904,1,'B2001BE20090400100','Dekorasi Kelas','10','100000','Kelas','1000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 10:48:38','B2001BE','c9fe81994462eaba29c545f84a338d71'),
	(203,'B','2001','BE',200903,1,'B2001BE20090300100','Aparatus KBM 12 Rombel','10','300000','Bulan','3000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 10:46:25','B2001BE','15ef5cf944604ce9ba7cfba9aa338d71'),
	(202,'B','2001','BE',200902,1,'B2001BE20090200100','Perlengkapan praktik seni rupa','211','5000','Siswa','1055000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 10:42:56','B2001BE','84033fd63727f7fe827e1b086a338d71'),
	(201,'B','2001','BE',200901,1,'B2001BE20090100100','Pengadaan alat olahraga','211','5000','Paket','1055000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 09:06:25','B2001BE','3f15caf63727f7fe827e1b086a338d71'),
	(200,'B','2001','BD',200803,1,'B2001BD20080300100','UKS (Obat-obatan)','5','200000','Kelas','1000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 09:00:48','B2001BD','8679bc7a3b761603f6c545f84a338d71'),
	(199,'B','2001','BD',200802,1,'B2001BD20080200100','Masker','1','45000','Pack','45000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 08:59:26','B2001BD','71ebbc4a42322457232245723a338d71'),
	(198,'B','2001','BD',200801,1,'B2001BD20080100100','Sabun Cuci Tangan','12','50000','botol','600000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 15:46:01','B2001BD','7521834ad4d7f7fe826dd7ed6a338d71'),
	(197,'B','2001','BC',200701,1,'B2001BC20070100100','Materai 10.000','35','10000','Pcs','350000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 08:57:07','B2001BC','b5a8b8583cd2741f6600a1908a338d71'),
	(196,'B','2001','BB',200631,1,'B2001BB20063100100','Cutter + isi cutter','1','50000','Pack','50000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 08:55:54','B2001BB','1d1f11aa423fd46739fd46739a338d71'),
	(195,'B','2001','BB',200630,1,'B2001BB20063000100','Odner file','10','45000','Pack','450000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 08:55:14','B2001BB','d969617944622457231c580aea338d71'),
	(194,'B','2001','BB',200629,1,'B2001BB20062900100','Karet gelang','1','10000','Pack','10000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 08:54:01','B2001BB','53427f4a4232741f662741f66a338d71'),
	(193,'B','2001','BB',200628,1,'B2001BB20062800100','Box file','10','48000','Pcs','480000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 08:38:07','B2001BB','e89cc3294463d5a5308fd5fd8a338d71'),
	(192,'B','2001','BB',200627,1,'B2001BB20062700100','Kertas kado','1','50000','Pcs','50000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 08:35:54','B2001BB','082a0f2a423fd46739fd46739a338d71'),
	(191,'B','2001','BB',200626,1,'B2001BB20062600100','Label stiker','2','15000','Pack','30000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 08:32:50','B2001BB','5ec916ae728886c7f813150dea338d71'),
	(189,'B','2001','BB',200624,1,'B2001BB20062400100','Map plastik','3','35000','Pack','105000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 07:32:47','B2001BB','7f17332bc8797dcd83713ca4ea338d71'),
	(188,'B','2001','BB',200623,1,'B2001BB20062300100','MAP Kertas','3','25000','Pack','75000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 07:29:27','B2001BB','9685898bc87538106cb1bb4f5a338d71'),
	(187,'B','2001','BB',200622,1,'B2001BB20062200100','Paper clip Besar dan Kecil','2','50000','Paket','100000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 07:27:47','B2001BB','97bafc5e728fd467392eaba29a338d71'),
	(186,'B','2001','BB',200620,1,'B2001BB20062000100','Penghapus papan tulis','10','10000','Pcs','100000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 07:22:15','B2001BB','f42ea0e94462741f662eaba29a338d71'),
	(185,'B','2001','BB',200619,1,'B2001BB20061900100','Penghapus karet','10','4000','Pcs','40000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 07:19:17','B2001BB','40b39b49446c7df311048a2d0a338d71'),
	(184,'B','2001','BB',200618,1,'B2001BB20061800100','Type x','10','5000','Pcs','50000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 07:18:03','B2001BB','5dbccaf94467f7fe82fd46739a338d71'),
	(183,'B','2001','BB',200614,1,'B2001BB20061400100','Copy dan Jilid Lapbul','12','25000','Bulan','300000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 07:16:31','B2001BB','4ae3703ad4d538106c04ce9baa338d71'),
	(182,'B','2001','BB',200613,1,'B2001BB20061300100','Kertas Mika + Kertas Buffalo (untuk Jilid)','1','200000','Paket','200000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 07:14:57','B2001BB','06586a8a42361603f661603f6a338d71'),
	(181,'B','2001','BB',200612,1,'B2001BB20061200100','Solatip, Lem, Double tape','1','150000','Paket','150000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 07:13:45','B2001BB','f6da11ca423dd62b6fdd62b6fa338d71'),
	(180,'B','2001','BB',200611,1,'B2001BB20061100100','Gunting (Keperluan Siswa/ 2 kelas)','10','10000','Pcs','100000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 07:11:27','B2001BB','b171b1894462741f662eaba29a338d71'),
	(179,'B','2001','BB',200610,1,'B2001BB20061000100','Stapler dan isi','10','15000','Paket','150000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 07:10:03','B2001BB','51c59ad9446886c7f8dd62b6fa338d71'),
	(178,'B','2001','BB',200609,1,'B2001BB20060900100','Amplop Putih Besar, Kecil','3','100000','Paket','300000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 07:07:59','B2001BB','e3b1129bc872eaba2904ce9baa338d71'),
	(177,'B','2001','BB',200608,1,'B2001BB20060800100','Stampel + tinta stampel','1','100000','Paket','100000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 07:04:57','B2001BB','a7644caa4232eaba292eaba29a338d71'),
	(176,'B','2001','BB',200607,1,'B2001BB20060700100','Ballpoint','4','20000','Dus','80000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 07:03:11','B2001BB','57fcd11ff67cdf31c0d8be800a338d71'),
	(175,'B','2001','BB',200606,1,'B2001BB20060600100','Tinta Spidol Whiteboard','3','75000','Paket','225000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 07:00:23','B2001BB','5d0ce88bc87b1bb4f53d388b7a338d71'),
	(174,'B','2001','BB',200605,1,'B2001BB20060500100','Spidol Whiteboard kelas','3','85000','Dus','255000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:58:31','B2001BB','17b5bd3bc87d60c592f0a530ca338d71'),
	(173,'B','2001','BB',200604,1,'B2001BB20060400100','Kertas Raport','7','180000','Rim','1260000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:55:52','B2001BB','d3cc6224e459cbb985bfd68c3a338d71'),
	(172,'B','2001','BB',200603,1,'B2001BB20060300100','Tinta Printer 4 warna x 12 bulan (untuk 3 mesin printer)','48','95000','Pcs','4560000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 15:45:05','B2001BB','f49e44de92ed60c5925715f27a338d71'),
	(171,'B','2001','BB',200602,1,'B2001BB20060200100','enggandaan Soal Assessment Sumatif TS, AS, AT','2','1400000','Paket','2800000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:52:35','B2001BB','006953ee728c6795d4a85d1dfa338d71'),
	(170,'B','2001','BB',200601,1,'B2001BB20060100100','Kertas HVS A4 dan F4 (Ulangan Harian &amp; Adminstrasi)','170','49000','Rim','8330000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:50:35','B2001BB','b7c24bde967e8c73c4d8b369da338d71'),
	(169,'B','2001','BA',200505,1,'B2001BA20050500100','Home Visit','1','1500000','Paket','1500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:48:55','B2001BA','851c2cca423f021678f021678a338d71'),
	(168,'B','2001','BA',200504,1,'B2001BA20050400100','Panitia PPDB','30','25000','Siswa','750000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:46:48','B2001BA','5d00ce873cb538106c2973530a338d71'),
	(167,'B','2001','BA',200503,1,'B2001BA20050300100','Wawancara dan Observasi Siswa Baru','30','15000','Siswa','450000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:45:29','B2001BA','1a0100273cb886c7f81c580aea338d71'),
	(166,'B','2001','BA',200502,1,'B2001BA20050200100','Promosi Sekolah','1','3000000','Paket','3000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:43:01','B2001BA','5058661a4237cfba9a7cfba9aa338d71'),
	(165,'B','2000','BD',200402,1,'B2000BD20040200100','Kegiatan Event (Lomba Kemerdekaan, hari kartini, hari guru, poe indung, dll)','211','15000','Siswa','3165000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:40:46','B2000BD','7f715da6372886c7f8a1bfe05a338d71'),
	(164,'B','2000','BD',200401,1,'B2000BD20040100100','Kegiatan PHBI (Tahun Baru Islam, Maulid Nabi, Hari Santri, Isra Mi&#039;raj)','211','12000','Siswa','2532000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:39:31','B2000BD','2aa872d63723dd5d093dd2d66a338d71'),
	(163,'B','2000','BC',200303,1,'B2000BC20030300100','Lomba Nasional','10','100000','Siswa','1000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:37:53','B2000BC','1ec545a94462eaba29c545f84a338d71'),
	(162,'B','2000','BC',200302,1,'B2000BC20030200100','Lomba Keluar Sekola (Antar SD)','211','23000','Siswa','4853000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:36:34','B2000BC','1ed6b6e637231d2f60e8acb45a338d71'),
	(161,'B','2000','BC',200301,1,'B2000BC20030100100','Lomba Kedinasan (FLS2N, KoSN,KSN,O2SN,Sapta PAI, STQ, FTBI)','211','20000','Siswa','4220000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:35:43','B2000BC','e62b86a6372cdf31c0293ebe1a338d71'),
	(160,'B','2000','BB',200220,1,'B2000BB20022000100','Kegiatan Class Meeting','211','5000','Siswa','1055000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:34:46','B2000BB','cf66bbc63727f7fe827e1b086a338d71'),
	(159,'B','2000','BB',200219,1,'B2000BB20021900100','Kegiatan English Camp','211','7000','Siswa','1477000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:32:25','B2000BB','04625bc637271b9ab6edf2be1a338d71'),
	(158,'B','2000','BB',200217,1,'B2000BB20021700100','Kegiatan Pesantren Ramadhan','211','4000','Siswa','844000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 15:07:13','B2000BB','4529a906372048a2d00cfe30da338d71'),
	(157,'B','2000','BB',200216,1,'B2000BB20021600100','Kegiatan First day activity','1','800000','Siswa','800000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:28:27','B2000BB','454dac7a423a0e8e3fa0e8e3fa338d71'),
	(156,'B','2000','BB',200215,1,'B2000BB20021500100','Kegiatan Lailatul Ijtima','211','7000','Siswa','1477000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:11:57','B2000BB','7d31004637271b9ab6edf2be1a338d71'),
	(155,'B','2000','BB',200214,1,'B2000BB20021400100','Kegiatan Akhir Tahun Pentas Seni','211','150000','Siswa','31650000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:07:46','B2000BB','80000656372dd62b6f09eb205a338d71'),
	(154,'B','2000','BB',200213,1,'B2000BB20021300100','Kegiatan Dental Check Up &amp; Medical Check Up','211','25000','Siswa','5275000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:06:25','B2000BB','4e3e6596372538106c7d8ebfea338d71'),
	(153,'B','2000','BB',200212,1,'B2000BB20021200100','Kegiatan Aquatic','422','7500','Siswa','3165000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 15:23:50','B2000BB','2a048e2637213c828966f3ed3a338d71'),
	(152,'B','2000','BB',200211,1,'B2000BB20021100100','Kegiatan Study Tour','211','450000','Siswa','94950000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 06:02:08','B2000BB','755279c63721c580ae8c27a89a338d71'),
	(151,'B','2000','BB',200210,1,'B2000BB20021000100','Kegiatan Expert arrival','211','10000','Siswa','2110000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 05:57:13','B2000BB','929649e63722741f66069f6a9a338d71'),
	(150,'B','2000','BB',200209,1,'B2000BB20020900100','Kegiatan Open House (fun fest )','211','35000','Siswa','7385000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 05:37:08','B2000BB','0fdd490637297dcd83a847771a338d71'),
	(149,'B','2000','BB',200207,1,'B2000BB20020700100','Kegiatan Wisuda Tahfidz + Language Festival','211','50000','Siswa','10550000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 05:29:57','B2000BB','304fc556372fd46739bbcbc29a338d71'),
	(142,'B','2000','BA',200101,1,'B2000BA20010100100','Pembuatan KOSP (dok 1)','2','200000','Paket','400000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-22 23:01:52','B2000BA','4c5d21ee72861603f6d28294fa338d71'),
	(143,'B','2000','BA',200102,1,'B2000BA20010200100','Raker','1','500000','Paket','500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 05:15:37','B2000BA','ef72d98a423732a294732a294a338d71'),
	(144,'B','2000','BA',200104,1,'B2000BA20010400100','Penyusunan Rapot','1','250000','Paket','250000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 05:21:16','B2000BA','fdb1978a42355e038c55e038ca338d71'),
	(145,'B','2000','BA',200105,1,'B2000BA20010500100','Pelaksanaan AKM','1','500000','Paket','500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 05:22:04','B2000BA','a52bd08a423732a294732a294a338d71'),
	(146,'B','2000','BA',200107,1,'B2000BA20010700100','Map Ijazah','44','35000','Orang','1540000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 05:23:10','B2000BA','88eddb7771697dcd834c20e00a338d71'),
	(147,'B','2000','BB',200205,1,'B2000BB20020500100','Kegiatan Gema Pramuka Kwarcab (Pendaftaran, Bendera Gugus, dll)','211','25000','Siswa','5275000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 15:19:53','B2000BB','ea67b956372c7df31153d28fea338d71'),
	(148,'B','2000','BB',200206,1,'B2000BB20020600100','Kegiatan Market Day','211','10000','Siswa','2110000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 05:26:01','B2000BB','eef487363722741f66069f6a9a338d71'),
	(137,'A','1999','AA',199999,1,'A1999AA19999900100','Bunga bank','1','0','Tahun','0','','','','','','','','','','','','','0','2025-05-25 05:26:44','A1999AA','d81e3fba42308495d508495d5cd98f00'),
	(237,'B','2007','BA',202204,1,'B2007BA20220400100','Cover Raport','30','50000','Pcs','1500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 15:02:25','B2007BA','748612173cbfd46739f021678a338d71'),
	(236,'B','2007','BA',202203,1,'B2007BA20220300100','Seragam 6 pcs','30','1850000','Seragam','55500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 15:01:34','B2007BA','840d7e273cb3f344b626162c8a338d71'),
	(190,'B','2001','BB',200625,1,'B2001BB20062500100','Kertas jasmine','1','100000','Pack','100000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 08:30:17','B2001BB','4e88e1ba4232eaba292eaba29a338d71');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_jurnal2526`;

CREATE TABLE IF NOT EXISTS `simakom_jurnal2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  `id` varchar(40) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_revisi2526`;

CREATE TABLE IF NOT EXISTS `simakom_revisi2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `revisi` float NOT NULL,
  `tanggal` date NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_revisi2526` (`no`, `revisi`, `tanggal`, `time`, `id`) VALUES
	(2,'0','2025-05-20','2025-05-20 23:38:09','5ca2d3bcdc4583d037d3f500cbdfdea8b6e');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_transaksi2526`;

CREATE TABLE IF NOT EXISTS `simakom_transaksi2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `bukti` float NOT NULL,
  `bukti_sistem` float NOT NULL,
  `jenis` float NOT NULL,
  `kategori` varchar(3) NOT NULL,
  `rkas_kategori` varchar(1) NOT NULL,
  `rkas_kegiatan` varchar(5) NOT NULL,
  `rkas_komponen` varchar(5) NOT NULL,
  `rkas_akun` float NOT NULL,
  `rkas_detail_id` varchar(25) NOT NULL,
  `uraian` text NOT NULL,
  `debet` varchar(15) NOT NULL,
  `kredit` varchar(15) NOT NULL,
  `penerima` varchar(100) DEFAULT NULL,
  `penerima_jabatan` varchar(100) DEFAULT NULL,
  `pembiayaan_id` varchar(50) NOT NULL,
  `pembiayaan_kegiatan` varchar(4) NOT NULL,
  `pembiayaan_komponen` varchar(5) NOT NULL,
  `pembiayaan_akun` varchar(6) NOT NULL,
  `pajak` tinyint(1) NOT NULL,
  `pajak_akun` varchar(10) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  `id_setor` varchar(25) NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_lpj2526`;

CREATE TABLE IF NOT EXISTS `simakom_lpj2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `periode` varchar(2) NOT NULL,
  `tahun` varchar(9) NOT NULL,
  `bku_awal` varchar(15) NOT NULL,
  `bku_debet` varchar(15) NOT NULL,
  `bku_kredit` varchar(15) NOT NULL,
  `bku_akhir` varchar(15) NOT NULL,
  `bank_awal` varchar(15) NOT NULL,
  `bank_debet` varchar(15) NOT NULL,
  `bank_kredit` varchar(15) NOT NULL,
  `bank_akhir` varchar(15) NOT NULL,
  `tunai_awal` varchar(15) NOT NULL,
  `tunai_debet` varchar(15) NOT NULL,
  `tunai_kredit` varchar(15) NOT NULL,
  `tunai_akhir` varchar(15) NOT NULL,
  `bank_riil` varchar(15) NOT NULL,
  `tunai_riil` varchar(15) NOT NULL,
  `bank_selisih` varchar(15) NOT NULL,
  `tunai_selisih` varchar(15) NOT NULL,
  `selisihtunai_keterangan1` text NOT NULL,
  `selisihtunai_keterangan2` text NOT NULL,
  `selisihbank_keterangan1` text NOT NULL,
  `selisihbank_keterangan2` text NOT NULL,
  `rekening_nama1` text NOT NULL,
  `rekening_jumlah1` varchar(15) NOT NULL,
  `rekening_nama2` text NOT NULL,
  `rekening_jumlah2` varchar(15) NOT NULL,
  `rekening_nama3` text NOT NULL,
  `rekening_jumlah3` varchar(15) NOT NULL,
  `catatan` text NOT NULL,
  `pecahan_100` varchar(10) NOT NULL,
  `pecahan_75` varchar(10) NOT NULL,
  `pecahan_50` varchar(10) NOT NULL,
  `pecahan_20` varchar(10) NOT NULL,
  `pecahan_10` varchar(10) NOT NULL,
  `pecahan_5` varchar(10) NOT NULL,
  `pecahan_2` varchar(10) NOT NULL,
  `pecahan_1` varchar(10) NOT NULL,
  `pecahan_05` varchar(10) NOT NULL,
  `pecahan_02` varchar(10) NOT NULL,
  `pecahan_01` varchar(10) NOT NULL,
  `pecahan_005` varchar(10) NOT NULL,
  `id` varchar(30) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `db_setor2526`;

CREATE TABLE IF NOT EXISTS `db_setor2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal_draf` datetime NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  `setor_status` varchar(10) NOT NULL,
  `setor_tanggal` datetime NOT NULL,
  `terima_status` varchar(10) NOT NULL,
  `terima_tanggal` datetime NOT NULL,
  `penyetor` varchar(50) NOT NULL,
  `penerima` varchar(50) NOT NULL,
  `metode` varchar(2) NOT NULL,
  `id_rkas` varchar(50) NOT NULL,
  `tahun` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `created_by` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa_min2526`;

CREATE TABLE IF NOT EXISTS `tb_siswa_min2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1896 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_siswa_min2526` (`no`, `nama`, `nis`, `jenjang`, `paralel`, `id`) VALUES
	(1678,'ALVARO MUHAMMAD OZORA NOORIS ','242505049','6','2','17c64146970af9c4eaf3'),
	(1679,'VYOLINA HERMINE','202101045','6','2','44d9336529eeb0cc5744'),
	(1680,'VANESSA ANGELINA HAUSER','202101044','6','2','cd187281fac043c2a092'),
	(1681,'SYAKILLA AZ DZAKIYAH JELITA HAN','202101042','6','2','709da735a9465aa3bd2a'),
	(1682,'RAKEAN WASTU HENDRAWAN','202101040','6','2','0087596cf5156e32bbc0'),
	(1683,'RAISYA AL ZHAFIRAH','202101037','6','2','3ad2839fed1eaf641ae2'),
	(1684,'RAIHAN FADILLAH','202101035','6','2','fdbd8badfb0f0111a8f5'),
	(1685,'RAISHA GHASSANI XAVIERA SIDDIQ','202101036','6','2','984f84e6523259cb5674'),
	(1686,'RAHMAN HILMANYSAH','202101034','6','2','76e7e668ecf28a85f867'),
	(1687,'MUHAMMAD DARREL ALKHALIFI PERBAWA','202101030','6','2','fba7b153bfa31bccdc48'),
	(1688,'MUHAMMAD DAFFA RIZQI','202101029','6','2','aa8aa6e1c68634758f36'),
	(1689,'HAIDAR NUR ZAHID MAHMOED ','202101019','6','2','30ec68855b1425514b65'),
	(1690,'ARSEN ADISA ASHSHIYAAM','202101011','6','2','0dfc48e8d74dcbee4534'),
	(1691,'ARFAN PRADIPTA SAFA','202101010','6','2','7895a7155c7669347383'),
	(1692,'ALIF ALBARRI MUBAROK','202101007','6','2','25d921b7d25cfd6ce9c3'),
	(1693,'ALIF ADDIN GUNAWAN &amp;#039;IZZA','202101006','6','2','c773a96dab934f4548b7'),
	(1694,'ADZKIA KIMBERLY BALQIS A','202101002','6','2','98eabb1b298128b16dad'),
	(1695,'AABID ARFA ATTAYYA DZUBYAN','202101001','6','2','5defe36137445a387bc2'),
	(1696,'SATRIA PUTRA YOZA','232404043','6','1','cd3f02ffe132f9a0388f'),
	(1697,'YUNITA BELVANIA PRANATA','202101046','6','1','1e8d74e78c4b92046a08'),
	(1698,'RAZEEQ SACHTI ABDALLA','202101041','6','1','eb3b20e610b374991aa3'),
	(1699,'MUHAMMAD FAHRIZAL SEPTA','202101031','6','1','2bbfa8eebbf1d6d987fc'),
	(1700,'MUHAMAD HAIKAL MAULANA AKBAR','202101027','6','1','334f850bea4d94a4ce53'),
	(1701,'MUHAMMAD ALVARO DIRGA MAHESWARA','212201031','6','1','1f649e74a812976f1fd7'),
	(1702,'KHAYLA APRILIA KIRANA','202101025','6','1','c6ec883a6db2f11594f9'),
	(1703,'HANIFAH ALDILA SYAFANA JEN','202101021','6','1','f53d4313c47fc6f4ed49'),
	(1704,'GYAN SATYA ALARIC','202101018','6','1','b4eb5fca29d50ac01721'),
	(1705,'GADIZA AIDA LUVENA','222303047','6','1','5418074ee6d2979380e2'),
	(1706,'FAIDA ANNAILA EFFENDI','202101017','6','1','ccd11c0bb643a4c2edfb'),
	(1707,'FARAND SAVERIO KHILAL','212201029','6','1','2d6b0220759825cf0e28'),
	(1708,'ENZO KAFFIE EL AZZAM','202106054','6','1','a15d4b393b1631da597d'),
	(1709,'CAMILO BHAMAKERTI MUHAMMAD','202101016','6','1','367289270de35636cb99'),
	(1710,'AZZAHRA DIANDRA NUGROHO','202101014','6','1','14d0c26c15eed7a1a658'),
	(1711,'AZ - ZAHRA ASSYABIYA NAURA ','202101013','6','1','c0adaefdbc3beff6eadb'),
	(1712,'ALWI JANUAR SIBYANI','202101008','6','1','f3e85cf647ccb7ca2871'),
	(1713,'ALFRIZ ANRAGASI JAGADDITHA HUDSI','202101005','6','1','318962783ad79317b3fc'),
	(1714,'AHMAD HABIBI ASYIFA','202101003','6','1','b64d1fce1736b845239c'),
	(1715,'ZAHRA NAYLA TIHANI','232403052','5','1','454f75bced5264658945'),
	(1716,'SEBASTIAN SCHUMACER','232403041','5','1','074b5f11f2d86641e523'),
	(1717,'MUHAMMAD AFFAN DZAKI BACHTIAR','232403042','5','1','fcbad659b4cad9b84aaa'),
	(1718,'SRI AYU KENCANA','212201026','5','1','212cd99adf8c3d513752'),
	(1719,'TYARI AFWA SHAHIA RAFANI','212201027','5','1','d7987a5a41b19290e42a'),
	(1720,'SHAQILA AJENG ADZKIYA DZAFIRA','212201021','5','1','c903061be304b793023f'),
	(1721,'PELANGI ASSYABIYA HANDIAN','212201017','5','1','c6dade83467d14b77ede'),
	(1722,'RIVANY APRILIAN ANGGRA SETIAWATI','212201018','5','1','c4713b8c6ed71d533ab6'),
	(1723,'NAZMI ATFHAL AZIZ','212201016','5','1','bacfa13680f89e69741b'),
	(1724,'NAYLA ANDINI NURFADHILLAH','212201013','5','1','5bd1e1f6f1410d42bd69'),
	(1725,'NAUFAL ALGHAZALI RAMADAN','212201011','5','1','81c9b7cad4ff77380e30'),
	(1726,'NADHIFA KHANSA ZAHIRANI','212201006','5','1','c511bfc7145cb0688d3e'),
	(1727,'MUHAMMAD NAUFAL RIZKY UMESYAH','212201005','5','1','d54d38b5753174e27a48'),
	(1728,'MUHAMMAD AL FAHRI VALESKA','212201004','5','1','dea32fea82bd01f5bd07'),
	(1729,'MUHAMAD AFKAR KURNIAWAN','212201025','5','1','7a6ca400a12bda35273d'),
	(1730,'MOCHAMAD IQBAL MAULANA','212201024','5','1','36d489c0a25e9862adf9'),
	(1731,'GUNTUR JUNA WIJAYA','212201023','5','1','a3f1aa24a9122619fb4f'),
	(1732,'GAVIN ARVANDHIA WIJAYA','212201020','5','1','79c082d8cbf4c1834018'),
	(1733,'GILENSYA BRILLIAN ABIYUSAFA','212201022','5','1','36acc4034483fc8794b2'),
	(1734,'FAYRUZ AILA ELZAVIRA','212201019','5','1','a0084d657d6111aab0f4'),
	(1735,'DHAFITHA NISA NUR AZIZAH','212201015','5','1','6ada529bed31f75e6694'),
	(1736,'DAIKI ARSYAD KHAIRULLAH','212201012','5','1','bb1e934cbadff1f6ba45'),
	(1737,'AURELL PERMATA H LIM','212201010','5','1','73ba5d9f3c94c86eb711'),
	(1738,'ATHALLA REINDRA RAMADHAN','212201007','5','1','7ddeb05f8dcb46fbdc71'),
	(1739,'AHZA FAWWAZ RAMADHAN','212201002','5','1','5595f55dec010712e975'),
	(1740,'ZULFA AGNA KAMILA','222301046','4','2','ebfcbde57c0350af5ae6'),
	(1741,'TATANG MAULANA WIJAYA S','222301044','4','2','801dc442ac1eb3e1aa39'),
	(1742,'RAISHA RAMADHINI RAKHIM','222301039','4','2','e28ff785cca3f160a178'),
	(1743,'RASHYA DIANDRA','222301040','4','2','332cc886d8dc2a023b54'),
	(1744,'MUHAMMAD KENZIO ARSYAD REVINZA','222301034','4','2','138d41ad50acf185b843'),
	(1745,'NABILA REVALINA','222301035','4','2','f0325902cc209e4e7efc'),
	(1746,'M. ROMMY ALVARO','222301029','4','2','3557f23f26294ebb3d85'),
	(1747,'M. KEENAN PRAMADITYA H','222301028','4','2','948e5ff05fee3311b7a0'),
	(1748,'KENJI GERRARDINO REKSO ATMODJO','222301024','4','2','ff5b18d35219351b0ba1'),
	(1749,'JASMINE SALIMAH ROMADHONA','222301023','4','2','4092d002f20dd7c599e8'),
	(1750,'HAIDAR FACHRIL ARDIANSAH','222301048','4','2','e378981fe37aa60838c4'),
	(1751,'IZAZ ABDER RAZZA','222301022','4','2','54e70dedef41ba2f9a98'),
	(1752,'GWEN AIMEE SYAREFIA PUTRI','222301017','4','2','dec2f4098dfffe1d700d'),
	(1753,'IBRAHIM JAFAR SIDDIQ','222301021','4','2','160da155e36972489a0d'),
	(1754,'FARIZ NAUFAL RABBANI T','222301016','4','2','6e78fdf86bc520dd482b'),
	(1755,'FARDAN NAJA ELANDRA','222301014','4','2','4b63decb490d0551d163'),
	(1756,'AZQIARA PUTRINDA ZAKI','232402054','4','2','0a60a1eaa9c3a6b428d2'),
	(1757,'FADIAH ANINDYA MAULA','222301013','4','2','6e86cb39c6bf7d084340'),
	(1758,'AZKA AZFAR HAIKAL','222301009','4','2','9f7cc16c4dfba16d41df'),
	(1759,'ARKHAN AKHMAD ATTHARIZ','232402040','4','2','d94d0e3d1fee579fea4d'),
	(1760,'ALVI RIZKI MUBAROK','222301004','4','2','7f3cebe05ec29dfe6120'),
	(1761,'ALFATHIR ARDI PRASETYO','222301003','4','2','a55363e6f658138f6c4d'),
	(1762,'ZEFA FARZANI','222301045','4','1','09d0105c7740a922471f'),
	(1763,'REYZHEL QEVELLO ANDRA','242503048','4','1','6d278e60a0c693b9a963'),
	(1764,'SABRINA ALULLA SHANUM','222301043','4','1','6c4d219b37f9f8686683'),
	(1765,'REYNAND ALTAF MULYAWAN','222301041','4','1','41ffb6f6f6920cb4b70c'),
	(1766,'RYUGA EL YUSUF','222301042','4','1','79b836f91b988ac7abff'),
	(1767,'NAFIZHA NUR MAULIDA','222301036','4','1','c9e8036deddd1de34b86'),
	(1768,'RAFFA ADINAKA AR RAHMAT','222301038','4','1','3817dab77b75f77118fe'),
	(1769,'MUHAMMAD DEARLY AL FATIH PERBAWA','222301033','4','1','24dfb9ba3052a40acfc4'),
	(1770,'MUHAMMAD AZKA KHOERUL AZAM','222301032','4','1','4454002ef4f5aa1ef836'),
	(1771,'MUHAMMAD ABYAN ARKENZI AKBAR','222301031','4','1','d79a50b60863d115fc9f'),
	(1772,'KENZIE NAUFAL SRI LUGINA','222301026','4','1','582bf2ef2795ab7f4aa1'),
	(1773,'M. SYAHRIL AS SEKAR','222301030','4','1','5ff85346c740a547d8df'),
	(1774,'KENZIE AZKA WIJAYA','222301025','4','1','d2a955aa85dcdec522f2'),
	(1775,'ELONA SAFA ALMIRA','222301012','4','1','1d4ca0159bd36127f86d'),
	(1776,'AZRINA ALKHANZA AZZAHRA','222301010','4','1','3a44a38b8c56d3625cf9'),
	(1777,'ATALLA BARCA AFRIAN','222301006','4','1','63b50fad00e9ad0a12ae'),
	(1778,'AYESHA QIANA NURDIANSYAH','222301008','4','1','b0efef25a9dec069cf5a'),
	(1779,'ARUNA SACHI KAYANA','222301005','4','1','33cb0787ff593b4d4269'),
	(1780,'ARFA DAMAI CORDELIA','242501045','4','1','a507adff6e35456a0b53'),
	(1781,'ALDEBARAN HAIDAR','222301002','4','1','7491a4f0714b0a7cbd95'),
	(1782,'ARZUNO MUHAMMAD RAMADHAN NOORIS ','242502050','3','2','0773b3c4ef1fcdce0325'),
	(1783,'SALVINA ALEESHA ALRADYA','232401036','3','2','429d4fa4f9fea1a068a1'),
	(1784,'SAVERIO AL MALIQUE','232401037','3','2','58a11bc2dae26fd3f860'),
	(1785,'RIZKY SETIAWAN','232401035','3','2','aebe9058cd78e0050eae'),
	(1786,'RANIA SARAH RACHMAN','232401033','3','2','1c5e3e92f276f6fcf98d'),
	(1787,'PRAMUDYA ARDHANI HAMIZAN ','232401030','3','2','94a83597dda9f5080ad3'),
	(1788,'MOUNIRA SERAPHINA PUTRIWIBOWO','232401024','3','2','f8cb967f1b08156d811d'),
	(1789,'MUHAMMAD NEVANDRA UMESYAH','232401027','3','2','018390a598a1ebeaa9e8'),
	(1790,'KHALID VALERYAN RIBSYA TANJUNG ','242502046','3','2','8e3b2fa2f8568e4a4ad8'),
	(1791,'HAURA HILWA ALIFA USMAN','232401017','3','2','5871379021a5c2e471b4'),
	(1792,'HARITH ADSKHAN ','232401016','3','2','f02070ab35eef2fa8d10'),
	(1793,'HAIFA AYU KIRANA','232401015','3','2','df8087cd1ba3d94b5a82'),
	(1794,'HAFIZ ALFARIZI','232401014','3','2','5bd283fe26640e5158da'),
	(1795,'DZAKY HADIWIJAYA','232401008','3','2','6fe1fd7f0e27b5e0ed1b'),
	(1796,'ARRIZA NUR MUHAMMAD','232401051','3','2','ecf982c49593998a2717'),
	(1797,'AVRILLA PHONCHO ZAAFIRA ZULFA','232401006','3','2','8aa51c1bad89da2ccc7f'),
	(1798,'ALWI AMMAR AL GHAZALI','232401004','3','2','86ebce722bdfd05e354d'),
	(1799,'ADZKIA SAUFA WIDIANA','232401002','3','2','4f08753315b1ab6cd16a'),
	(1800,'ALEM VIRENDRA MULYAWAN','232401003','3','2','e21605f09d34ea2701dc'),
	(1801,'ABIDZAR AL GHIFARY NUGRAHA','232401001','3','2','5fcce6c8980fbad87851'),
	(1802,'FAYRA AZIZA ALZAFARANI ','242502052','3','1','8c58a56a3bc39ede9239'),
	(1803,'QUONZILO AXELLE FAIVISH','232401031','3','1','cc3022a6c6bdfe3cbb1b'),
	(1804,'SERAFINA SHANUM KIRANA YUDHA','232401038','3','1','5f6cb9003cc3df8e430d'),
	(1805,'MYSHA MAHARANI GUNAWAN','232401028','3','1','a3b01fc704e9be4ef7e6'),
	(1806,'NAFISHA HASNAA CARISSA ','232401029','3','1','2177582ef92a2443f500'),
	(1807,'MUHAMMAD KHALID ARRASYID','232401026','3','1','ae518e95970cecc24fa4'),
	(1808,'MUHAMMAD ARIEF HIDAYATULLOH','232401025','3','1','57ebd4ca7cd2aae07ca1'),
	(1809,'MILESHA SHIDQIN ALIYA FIRDAUS','232401022','3','1','c26c88feeffab207e9e3'),
	(1810,'M ALFARIEL SIHOTANG ','242502047','3','1','78e56abdf960f5cb87b4'),
	(1811,'KEINAN ARAZKA PRADIPTA','232401021','3','1','6ee56fb157c6553b4593'),
	(1812,'KEANU ALFARIEL ','232401020','3','1','2df068620e5529acf48b'),
	(1813,'I GUSTI  AGUNG ATHAYA KHALIANDRA NADDEAN','232401018','3','1','4165781160fe8fd0abbc'),
	(1814,'KAZUHIRO ARRAWDA ADITYA','232401019','3','1','21bcd106cabf41cc22d8'),
	(1815,'GALENA KAMANIYA SLAMET VALERIE','232401013','3','1','d72c608f7256ba898308'),
	(1816,'FELYCA RIZMA HAPSARI','232401048','3','1','44e1600a5a0ea9ebc00e'),
	(1817,'FELYRA RIZMA HAPSARI','232401049','3','1','dd143450e7a99e80c7a6'),
	(1818,'FARZANA SABRINA ALMAHYRA','232401012','3','1','85f9bf46f933033b70ed'),
	(1819,'CEILO MALIK ALTAIR ','232401007','3','1','7f475fbd40160527e708'),
	(1820,'ARFADHIA RAZQA ATHARUF','232401050','3','1','a5db990d9b75066c77ed'),
	(1821,'ANANTA LASHIRA NAZAFARIN','232401005','3','1','54776bdf79378f22c3c1'),
	(1822,'SYIFA MAULIDA SALSABILA','242501044','2','2','b348f0a91978115cee93'),
	(1823,'NAURA RAMADHINA NURWAHIDIN','242501037','2','2','6dc8f7b69901d1eb6851'),
	(1824,'NAIRA GHAISANI','242501034','2','2','35bc2e02f9fe7c3d578b'),
	(1825,'NAUFAL ALKHALIFI PRASTIYO','242501035','2','2','919d3052212b44bbbe9b'),
	(1826,'NADIRA ADZKIRA MAHARDIKA','242501033','2','2','c30d5f4cdbdfd85c3b7f'),
	(1827,'NABIL KHAIR RAMDANI','242501032','2','2','ef4ac8e93a95e39a99f5'),
	(1828,'MUHAMAD FATAHILLAH AKBAR AL FATIH','242501028','2','2','52eab029fa5a66fbf387'),
	(1829,'K HANI ALFIDEVITA','242501021','2','2','0fe0990171c53cf373f1'),
	(1830,'KEANE MAULANA PUTRA','242501024','2','2','7a5bf39ed8d72a1139c8'),
	(1831,'KO CAHO PRATAMA THOMAS','242501027','2','2','4c30ee749a13dc8ce920'),
	(1832,'CLARA AINUN NISYA','242501015','2','2','584c0766271569d83485'),
	(1833,'GHEISAN ARCELLO MAHESA','242501019','2','2','a2283810a88da306234a'),
	(1834,'AZFAR RAFFASYA NURDIANSYAH','242501013','2','2','2cd39ce87986470424f3'),
	(1835,'AURORA PUTRI TANGGON CENDIKIA','242501011','2','2','88010b77d737542437ad'),
	(1836,'AUDRISSA HAURA ZIANAYA','242501009','2','2','7cb2e02638972e7f63c3'),
	(1837,'AULIYA RAHMAH','242501010','2','2','da15767ec5c469cbeb9e'),
	(1838,'ATHAYA NABHAN ZAAHIRULHAQ','242501008','2','2','1b6b0f8f031ab972a5dd'),
	(1839,'ADHYASTA RAQILA SEPUTRA','242501003','2','2','4c04f76e1f56293faa17'),
	(1840,'ADARA PUTRI TANGGON CENDIKIA','242501002','2','2','1857c1a363a3d1a9ee15'),
	(1841,'ABIZARD ARSHAD NUGRAHA','242501001','2','2','4d46448d05a4fc1c0b29'),
	(1842,'SYAFIQAH BURAIRAH ALVANI','242501042','2','1','e578bf4ab7e56857d7b4'),
	(1843,'SYAFIYAH BURAIRAH ALVANI','242501043','2','1','1cecb1585d10ef35732b'),
	(1844,'KEISYA SHANUM ALFATHUNISSA','242501051','2','1','be97a8a4eef92a9d6ab5'),
	(1845,'SANDRIA HAVIKA NAURA','242501041','2','1','be3fda2cdeaf607cf1c3'),
	(1846,'RAJENDRA DEVIAN ALFAREZ','242501040','2','1','ed686025105b9ce1de71'),
	(1847,'QIANA ADREENA PUTRI REFIANDI','242501039','2','1','92b279030d09fbc1ba13'),
	(1848,'QALIFA AL QAHTHAN ROYCE','242501038','2','1','51c73b3a9ac3ac439fbb'),
	(1849,'NAUFAL RESKI HERMAWAN','242501036','2','1','8fd869042d6a09215d70'),
	(1850,'KHENZY GIFFARI ANDRA','242501026','2','1','67b404544b8d8559aef7'),
	(1851,'MUHAMMAD UKKASYAH AL-FATIH','242501031','2','1','c05e275be81931368dce'),
	(1852,'KHALISA NURRAMADHANI PRATILO','242501025','2','1','c0d1bc0acca4148363e7'),
	(1853,'KAZIM ATHAFARIZ RASYID TANJUNG','242501023','2','1','3b2af1a7f519ddc20e77'),
	(1854,'KAYRA SYIFA ZAIDA POURAN','242501022','2','1','d6d72a6779f9a2ff6455'),
	(1855,'JASMINE ASH-SHANUM TAZKIYA HAN','242501020','2','1','328438ead22518a92ea5'),
	(1856,'GALUH PRAMESWARI AL ANWAR','242501018','2','1','f58b4e0e00838c88bdca'),
	(1857,'FATIH ILHAM AULIA','242501016','2','1','9fcac2a7f8f687433604'),
	(1858,'AZZILFA RAHMANI DAYYAN','242501014','2','1','1d72e74e68f6e4a7ebb1'),
	(1859,'ATHA PUTRA TANGGON CENDIKIA','242501007','2','1','a4d3ac7b36eda78ad902'),
	(1860,'ARTYAREZI SHAQUEENA RAMADHANI','242501006','2','1','a8d4db7c53e61ac73668'),
	(1861,'ARTHUR PUTRA TANGGON CENDIKIA','242501005','2','1','de953791161e6869eeed'),
	(1862,'ARSHAD FIKAR ABQARY ANDRYAN','242501004','2','1','1c859446ef36798786cc'),
	(1863,'ABYAN REYNAND DILLAH','252601001','1','1','027c9cbef1eb2c3e8872'),
	(1864,'ALKHAFA SAUQI BATUBARA','252601003','1','1','46c6ffa2fd4c6321848c'),
	(1865,'ATTILA NARA PRADITYA','252601004','1','1','0f0cedb31d6045be804d'),
	(1866,'AURENZA AZHAR','252601005','1','1','ad57375eb5ce6f182cd9'),
	(1867,'AZ-ZAHRAH CARISSA PUTRI FAUZI','252601006','1','1','26bf0196c904ff0c30e5'),
	(1868,'ERSTA ATHARAZKA WIBOWO','252601007','1','1','86f8852e77ee95eba8c5'),
	(1869,'FELISHA BIKRUM SAKHI','252601008','1','1','ef73db56cedb83f74208'),
	(1870,'IBNU SAKTIAWAN SIHOTANG','252601009','1','1','8a656e85829e52ded8fa'),
	(1871,'KHAIRA SENANDUNG MAHLIGA','252601010','1','1','c314f3241b3107092cc3'),
	(1872,'KHALISA SHAKIRA AKBAR','252601011','1','1','57b2735e5a384505c861'),
	(1873,'MUHAMMAD FADLAN AZZUHRI','252601012','1','1','62e9e132c60202cf8515'),
	(1874,'MUHAMMAD ZAYN AL FATH','252601013','1','1','8ce8bd039a39743d8f1b'),
	(1875,'NADIA TRIAULIA RAMDANI','252601014','1','1','d729f51e61b6ac080baf'),
	(1876,'ODELINA ASKANAH RAMADHANI ISFAHANI','252601015','1','1','2ccd068c362be2763606'),
	(1877,'RANGGA RAISUL AGUSTIN','252601016','1','1','4b47bec860677917f17f'),
	(1878,'RANIA ALISHA','252601017','1','1','940e8a8f8d4cae7445a9'),
	(1879,'RAUFA SHAKEIL LESMANA','252601018','1','1','52c2723f3fbf7de027a9'),
	(1880,'RAZKA ADITYA','252601019','1','1','a623bb673f2274a9b6d0'),
	(1881,'SHANUM VALERIAN ARDAFAIS','252601020','1','1','700831b80a37107ed43e'),
	(1882,'TAMHIDAN ADINATA','252601021','1','1','106d95ad8b2798931bc1'),
	(1883,'ZAKI MAULUDIN AZKIA','252601022','1','1','90f8a7998fe81d4bc943'),
	(1884,'ALYSYA FAZRIAH','252601031','1','1','931e851f5649e02028c6'),
	(1885,'ELZIRA NURIEL ANINDITA','252601023','5','1','ccc32cbe6be1be947041'),
	(1886,'SHAFIYA ARKADEWI BERLIAN','242502053','3','2','180f97d6761098217eeb'),
	(1887,'GHAITS EL ATHAR ABDULLAH','252601025','4','1','af95a2c42fde6077a85a'),
	(1888,'GHIYATS EL ARGA ABDULLAH','252601026','2','1','0ba9d6ce5d559ab41bc1'),
	(1889,'RAFIF DIRGA ANTASENA DERLIANPUTRA','252601027','4','1','8b842f8dcee7b9ca60fa'),
	(1890,'SASCHYA AFIZA TUNGGADEWI DERLIANPUTRI','252601028','2','1','4b998777ded75d664e53'),
	(1891,'ARZACHEL JUNIAR RAMADHAN','242502054','2','1','c7ed79e253ff08ebf6d5'),
	(1892,'FACHRY GHIFARI SUBHAN','252601030','5','1','4937f2570c475f2455aa'),
	(1893,'ZAVIER AL GIBRAN','252601032','3','1','2be33f8ae839a4517b65'),
	(1894,'RADITYA ARSHA PRATAMA','252601033','1','1','997b24e865e5ec18ead4'),
	(1895,'MUHAMMAD NIZAM DIAULHAQ','252602026','1','1','9ef19ab4ca5da2ac78d0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa2526`;

CREATE TABLE IF NOT EXISTS `tb_siswa2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `kelamin` varchar(20) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `ortu` varchar(75) DEFAULT NULL,
  `alamat` text DEFAULT NULL,
  `tang_A` varchar(10) NOT NULL,
  `tang_B` varchar(10) NOT NULL,
  `tang_C` varchar(10) NOT NULL,
  `tang_D` varchar(10) NOT NULL,
  `tang_E` varchar(10) NOT NULL,
  `tang_F` varchar(10) NOT NULL,
  `tang_G` varchar(10) NOT NULL,
  `tang_H` varchar(10) NOT NULL,
  `tang_I` varchar(10) NOT NULL,
  `tang_J` varchar(10) NOT NULL,
  `tang_K` varchar(10) NOT NULL,
  `tang_L` varchar(10) NOT NULL,
  `tang_M` varchar(10) NOT NULL,
  `tang_N` varchar(10) NOT NULL,
  `tang_O` varchar(10) NOT NULL,
  `tang_P` varchar(10) NOT NULL,
  `tang_Q` varchar(10) NOT NULL,
  `tang_R` varchar(10) NOT NULL,
  `tang_S` varchar(10) NOT NULL,
  `tang_T` varchar(10) NOT NULL,
  `tang_U` varchar(10) NOT NULL,
  `tang_V` varchar(10) NOT NULL,
  `tang_W` varchar(10) NOT NULL,
  `tang_X` varchar(10) NOT NULL,
  `tang_Y` varchar(10) NOT NULL,
  `tang_Z` varchar(10) NOT NULL,
  `status` varchar(15) NOT NULL,
  `email` varchar(75) NOT NULL,
  `hp` varchar(15) NOT NULL,
  `kategori` varchar(200) NOT NULL,
  `startAt` varchar(2) NOT NULL,
  `catatan` text DEFAULT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1896 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_siswa2526` (`no`, `nama`, `nis`, `kelamin`, `jenjang`, `paralel`, `ortu`, `alamat`, `tang_A`, `tang_B`, `tang_C`, `tang_D`, `tang_E`, `tang_F`, `tang_G`, `tang_H`, `tang_I`, `tang_J`, `tang_K`, `tang_L`, `tang_M`, `tang_N`, `tang_O`, `tang_P`, `tang_Q`, `tang_R`, `tang_S`, `tang_T`, `tang_U`, `tang_V`, `tang_W`, `tang_X`, `tang_Y`, `tang_Z`, `status`, `email`, `hp`, `kategori`, `startAt`, `catatan`, `id`) VALUES
	(1678,'ALVARO MUHAMMAD OZORA NOORIS ','242505049','L','6','2','VICKY ZULFIKAR NOORIS/INNA TRI MARYAMA','Perumnas Subang','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081311567100','UMUM','1','','17c64146970af9c4eaf3'),
	(1679,'VYOLINA HERMINE','202101045','P','6','2','ANDRI SURATMAN/WIDIA MAGRIE ','PANJI CLUSTER','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0813988174646','UMUM','1','','44d9336529eeb0cc5744'),
	(1680,'VANESSA ANGELINA HAUSER','202101044','P','6','2','ZATHARBY BARNETT HANSER/NINA EFIANA','PERUM KOTA GRAHA BK A8 NO34 CIBAROLA','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081298899498','UMUM','1','','cd187281fac043c2a092'),
	(1681,'SYAKILLA AZ DZAKIYAH JELITA HAN','202101042','P','6','2','BURHAN/RISMAYANTI APIPAH','TANJUNG MULYA 1 RT 09/05 DESA GAMBAR SARI  KEC. PAGADEN','0','2880000','2600000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082217734765','UMUM','1','','709da735a9465aa3bd2a'),
	(1682,'RAKEAN WASTU HENDRAWAN','202101040','L','6','2','DEDEN HENDRAWAN/SITI NURJANAH','JLN. JAYAWISATRA KENANGA I KARANG ANYAR - SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081322773131/08','UMUM','1','','0087596cf5156e32bbc0'),
	(1683,'RAISYA AL ZHAFIRAH','202101037','P','6','2','NOVAN NUGRAHA/DEWI AGUSTINA','JL JAMBU 3 BLOK 5 NO 28 RT 44/015','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081 22137 3661','UMUM','1','','3ad2839fed1eaf641ae2'),
	(1684,'RAIHAN FADILLAH','202101035','L','6','2','MUHAAD YAZID F/NANI YUNITA','BUANA SUBANG BK C1 NO 40','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082126955206/08','UMUM','1','','fdbd8badfb0f0111a8f5'),
	(1685,'RAISHA GHASSANI XAVIERA SIDDIQ','202101036','P','6','2','ARSHADI FAISAL S/RANTI FEBRIANTI','0 RT 05/02 BATU TUNGGAL','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081320563214','UMUM','1','','984f84e6523259cb5674'),
	(1686,'RAHMAN HILMANYSAH','202101034','L','6','2','IMAM HILMANSYAH/IDA SITI C','GRIA PESONA PRAJA BK 06 RT 22/06','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081380005762','UMUM','1','','76e7e668ecf28a85f867'),
	(1687,'MUHAMMAD DARREL ALKHALIFI PERBAWA','202101030','L','6','2','FRENGGA PERBAWA/IIS RISNAWATI','MAJA ASIH RT 11/04 MAJASARI CIBOGO','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','087879761988','UMUM','1','','fba7b153bfa31bccdc48'),
	(1688,'MUHAMMAD DAFFA RIZQI','202101029','L','6','2','ADHITYA RIADI/ANKE CORNELIA','KP. SITU SAEUR RT 30/09 SUKAMELQNG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085222204586','UMUM','1','','aa8aa6e1c68634758f36'),
	(1689,'HAIDAR NUR ZAHID MAHMOED ','202101019','L','6','2','NUR FADZANI M/MILA DWI S','PERUMNAS BK 6 NO 16 RT 45/08 SUKAMELANG SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','087821607135','UMUM','1','','30ec68855b1425514b65'),
	(1690,'ARSEN ADISA ASHSHIYAAM','202101011','L','6','2','DIAZ RAHMADEYA/ROSA MAULIDA','SUKA ASIH 2 NO 15 RT 65/18','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','08112340130','UMUM','1','','0dfc48e8d74dcbee4534'),
	(1691,'ARFAN PRADIPTA SAFA','202101010','L','6','2','SAEFUL BARKAH/ERLA ERLIATI','PERUMNAS BLOK V RT 44/015 SUKAMELANG SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082216133026','UMUM','1','','7895a7155c7669347383'),
	(1692,'ALIF ALBARRI MUBAROK','202101007','L','6','2','E ROHEMAN MUBAROK/PETY NURVIANTI','CINANGSI RT 04/02 CIBOGO','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085222566906','UMUM','1','','25d921b7d25cfd6ce9c3'),
	(1693,'ALIF ADDIN GUNAWAN &amp;#039;IZZA','202101006','L','6','2','ROHMAT/NURHAYATI NATALITA','JL. OTISTA NO 296 RT 048/006 SUKAMELANG SUBANG','0','2880000','2600000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081395806966','UMUM','1','','c773a96dab934f4548b7'),
	(1694,'ADZKIA KIMBERLY BALQIS A','202101002','P','6','2','MUHMMAD ROMMY ARIFIAN/GEBBY LIZARA UANDA','HARVA SUBANG BK B24','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082130012642','UMUM','1','','98eabb1b298128b16dad'),
	(1695,'AABID ARFA ATTAYYA DZUBYAN','202101001','L','6','2','RAYAN NOVAFIANA/DEDEH JUBAEDAH','BUANA SUBANG KENCANA','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085325676666','UMUM','1','','5defe36137445a387bc2'),
	(1696,'SATRIA PUTRA YOZA','232404043','L','6','1','UCI YOLANDA','','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','cd3f02ffe132f9a0388f'),
	(1697,'YUNITA BELVANIA PRANATA','202101046','P','6','1','HENDRA PRANATA/ERINA PUTIK WIJAYA','JL. RENANG NO 138 RT 52/16','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082121378906','UMUM','1','','1e8d74e78c4b92046a08'),
	(1698,'RAZEEQ SACHTI ABDALLA','202101041','L','6','1','LUKY AWALUDDIN, ST/BETI NURBAETI','JL. AHMAD YANI NO07 PASIRKAREMBI SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085224880567','UMUM','1','','eb3b20e610b374991aa3'),
	(1699,'MUHAMMAD FAHRIZAL SEPTA','202101031','L','6','1','ENDANG HAFIHIN/NINA HERAWATI','GRIA CADIKA PERMAI BLOK AA 12 RT 25/12 DANGDEUR SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082320854473','UMUM','1','','2bbfa8eebbf1d6d987fc'),
	(1700,'MUHAMAD HAIKAL MAULANA AKBAR','202101027','L','6','1','ABDUROHMAN/BIYAH','PERUMNAS BLOK 8 RT 38/12 ','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085320407375','UMUM','1','','334f850bea4d94a4ce53'),
	(1701,'MUHAMMAD ALVARO DIRGA MAHESWARA','212201031','L','6','1','SIGIT HARIYANTO/ANISTIA RUMINDA SARI','jln. Hercules Komplek Garuda No D-21 Lanud Suryadharma','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','1f649e74a812976f1fd7'),
	(1702,'KHAYLA APRILIA KIRANA','202101025','P','6','1','FUNKY RACHMA APRIADI/MARIA FITRI HANDAYANI','BTN PUSKOPAD SUKAJAYA B38 RT 17/58','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085223792992','UMUM','1','','c6ec883a6db2f11594f9'),
	(1703,'HANIFAH ALDILA SYAFANA JEN','202101021','P','6','1','MOCH ZAENUDIN/CITRA DEWI','GAMBARSARI','0','0','0','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082115829084','UMUM','1','','f53d4313c47fc6f4ed49'),
	(1704,'GYAN SATYA ALARIC','202101018','L','6','1','YUDHA GUMILAR/RIKA RESTU JUNGJUNAN','KP. PANEMBONG RT003/001 PARUNG-SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082117747212','UMUM','1','','b4eb5fca29d50ac01721'),
	(1705,'GADIZA AIDA LUVENA','222303047','P','6','1','BUANA/PUPUNG PURNAMA DEWI','Jalan Perum Graha Pertama, Palumbonsari, Karawang','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','5418074ee6d2979380e2'),
	(1706,'FAIDA ANNAILA EFFENDI','202101017','P','6','1','RAHMAT EFFENDI/ATIN KHOFIFAH','PASIRKAREMBI SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082116291231','UMUM','1','','ccd11c0bb643a4c2edfb'),
	(1707,'FARAND SAVERIO KHILAL','212201029','L','6','1','MACHMUD KHILAL/SELVIA CAHYA ANDRIANI','SAKINAH RESINDENCE CIGADUNG SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081298118905','UMUM','1','','2d6b0220759825cf0e28'),
	(1708,'ENZO KAFFIE EL AZZAM','202106054','L','6','1','NANDANG SUGILAR/FITRI HANDAYANI','KP RANCASEEL RT 005 RW 002 MAJASARI CIBOGO SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082315248644','UMUM','1','','a15d4b393b1631da597d'),
	(1709,'CAMILO BHAMAKERTI MUHAMMAD','202101016','L','6','1','ASEP NANDANG/NADIA LESTARI','GRIA SUBANG KENCANA ','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082311272407','UMUM','1','','367289270de35636cb99'),
	(1710,'AZZAHRA DIANDRA NUGROHO','202101014','P','6','1','SUSENO SETYO NUGROHO/ANI','GRIA CADIKA PERMAI BLOK AA 12 RT 23/13 DANGDEUR SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082127160333','UMUM','1','','14d0c26c15eed7a1a658'),
	(1711,'AZ - ZAHRA ASSYABIYA NAURA ','202101013','P','6','1','HENDRA ESA PUTRA/ERLAILI','GRIA CINANGSI','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082124954947/08','UMUM','1','','c0adaefdbc3beff6eadb'),
	(1712,'ALWI JANUAR SIBYANI','202101008','L','6','1','TOAT SIBYANI/DEDEH MULYATI','PERUMNAS BLOKK 8 RE 42/12 SUKAMELANG SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081320563214','UMUM','1','','f3e85cf647ccb7ca2871'),
	(1713,'ALFRIZ ANRAGASI JAGADDITHA HUDSI','202101005','L','6','1','PRIMA RENACKY HUDSI, S.SOS/SHELMA MELIANA','JL. DI PANJAITAN SOKLAT','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082214599410/08','UMUM','1','','318962783ad79317b3fc'),
	(1714,'AHMAD HABIBI ASYIFA','202101003','L','6','1','USMAN/NINING','DUSUN RAMBUT KASIHI RT 002 RW 003 GUMULUNG TONGGOH CIREBON','0','1152000','1040000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0859117343081','UMUM','1','','b64d1fce1736b845239c'),
	(1715,'ZAHRA NAYLA TIHANI','232403052','P','5','1','FAJAR KURNIAWAN/DEWI MAYLASARI','Komplek Perumahan PT. Pertamina EP Regional 2 Zona 7 Field Subang, Jl. Raya Pegaden Pamanukan, Desa Sukamulya Kec. Pegaden, Kab. Subang Jawa Barat 412521','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','454f75bced5264658945'),
	(1716,'SEBASTIAN SCHUMACER','232403041','L','5','1','SARI','Cipeundeuy Subang','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','6282110570041','UMUM','1','','074b5f11f2d86641e523'),
	(1717,'MUHAMMAD AFFAN DZAKI BACHTIAR','232403042','L','5','1','NIZAR BACHTIAR/MEILANNY INDAH ARYANTI','Markas Yonif 312/Kala Hitam di Kabupaten Subang, Jawa Barat.','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081212814184','UMUM','1','','fcbad659b4cad9b84aaa'),
	(1718,'SRI AYU KENCANA','212201026','P','5','1','TAMIR/KASMI','KP. SUKAHURIP RT. 007/003 CISAGA CIBOGO SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085215148956','UMUM','1','','212cd99adf8c3d513752'),
	(1719,'TYARI AFWA SHAHIA RAFANI','212201027','P','5','1','YAYAT RUHIYAT/HIKMAH PARLINAH','WANGUNREJA RT.12/03 RAWALELE DAWUAN SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082320342226','UMUM','1','','d7987a5a41b19290e42a'),
	(1720,'SHAQILA AJENG ADZKIYA DZAFIRA','212201021','P','5','1','YUNI WIDIANTO/MEGA RISA OKTAVIANTY','JL. KAPTEN HANAFIAH BLOK B.59 RT. 109/030 KARANGANYAR SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085224300100','UMUM','1','','c903061be304b793023f'),
	(1721,'PELANGI ASSYABIYA HANDIAN','212201017','P','5','1','YAYAT HANDIAN/DINI WIDIANI','JL. MT. HARYONO BLOK SUKAMAJU NO. 84 CIGADUNG SUBANG','0','2880000','2600000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','08993129777','UMUM','1','','c6dade83467d14b77ede'),
	(1722,'RIVANY APRILIAN ANGGRA SETIAWATI','212201018','P','5','1','TONI SETIAWAN/ERNI ANGGRAENI','JL. RAYA PARUNG HILIR RT.017/006','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','08121133661128','UMUM','1','','c4713b8c6ed71d533ab6'),
	(1723,'NAZMI ATFHAL AZIZ','212201016','L','5','1','ENDAN YUSDIANA/RIZKI TRIANSYAH','PURI PANJI KENCANA RT. 094/022 CIGADUNG SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085294346499','UMUM','1','','bacfa13680f89e69741b'),
	(1724,'NAYLA ANDINI NURFADHILLAH','212201013','P','5','1','ANDI/SUCI APRILIANI','DUSUN III CIBOGO RT.014/005 CIBOGO SUBANG','0','2880000','2600000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','089644322902','UMUM','1','','5bd1e1f6f1410d42bd69'),
	(1725,'NAUFAL ALGHAZALI RAMADAN','212201011','L','5','1','DIAN WIDIANSYAH/SEPTIA HANDAYANI','NLOK WALAHAR RT. 047/019 DANGDEUR SUBANG ','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','08994195110','UMUM','1','','81c9b7cad4ff77380e30'),
	(1726,'NADHIFA KHANSA ZAHIRANI','212201006','P','5','1','ANDHI KURNIAWAN/HEALLI MULYAWATI','KEBON KALAPA GANG SUKUN 1 KARANGANYAR SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082315418080','UMUM','1','','c511bfc7145cb0688d3e'),
	(1727,'MUHAMMAD NAUFAL RIZKY UMESYAH','212201005','L','5','1','UMAIR/META IMELDA','JL. RAYA CIPAKU CIBOGO KM 1 CIBOGO SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081271386757','UMUM','1','','d54d38b5753174e27a48'),
	(1728,'MUHAMMAD AL FAHRI VALESKA','212201004','L','5','1','RIO VALESKA /ELFA FRESNA, S.PSI','PERUM GRIYA PESONA PRAJA RT.18/06 CINANGSI SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081313029191','UMUM','1','','dea32fea82bd01f5bd07'),
	(1729,'MUHAMAD AFKAR KURNIAWAN','212201025','L','5','1','IWAN KURNIAWAN/DEWI LESTARI','JL. ARIF RAHMAN HAKIM NO. 20 RT.21/05 KEL. DANGDEUR SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081123110046','UMUM','1','','7a6ca400a12bda35273d'),
	(1730,'MOCHAMAD IQBAL MAULANA','212201024','L','5','1','ABDUL ROSYID/ROSIDAH','KP. SIMPANGSARI RT.008/004 CISAGA CIBOGO SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','08812034744','UMUM','1','','36d489c0a25e9862adf9'),
	(1731,'GUNTUR JUNA WIJAYA','212201023','L','5','1','JIMAT ADAM ROMADONA/WINDA SURI ANDAYANI','JL. R.A. KARTINI NO. 10 RT. 027/009 PASIRKAREUMBI SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081220088127','UMUM','1','','a3f1aa24a9122619fb4f'),
	(1732,'GAVIN ARVANDHIA WIJAYA','212201020','L','5','1','DIMAS NUREKA/IMAS SRI KANDHI','PERUM BUMI ABDI NEGARA RT.052/016 PASIR KAREUMBI SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085315097777','UMUM','1','','79c082d8cbf4c1834018'),
	(1733,'GILENSYA BRILLIAN ABIYUSAFA','212201022','L','5','1','YOGI HARAPANI/ELEN AGUSTIANI','JL. PRAMUKA NO. 35 RT.25/05','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','6282218605211','UMUM','1','','36acc4034483fc8794b2'),
	(1734,'FAYRUZ AILA ELZAVIRA','212201019','P','5','1','DIAN WARDIANSYAH/AYIK YULIA ROSDIANAH','BLOK WALAHAR RT. 047/019 DANGDEUR SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','08994195110','UMUM','1','','a0084d657d6111aab0f4'),
	(1735,'DHAFITHA NISA NUR AZIZAH','212201015','P','5','1','FAISAL RAHMAN/PURWATI','JL. RA KARTINI NO.22','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','08122099714','UMUM','1','','6ada529bed31f75e6694'),
	(1736,'DAIKI ARSYAD KHAIRULLAH','212201012','L','5','1','KRISTIANTO HADI/SRI WAHYUNI','PERUMAHAN PALEM REGENCY BLOK H3 TEGAL KALAPA','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085710494610','UMUM','1','','bb1e934cbadff1f6ba45'),
	(1737,'AURELL PERMATA H LIM','212201010','P','5','1','ALIP SALIM/IIS SUKAESIH','DUSUN BELENDUNG II KEC. CIBOGO RT.010/004 BELENDUNG SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0895321188818','UMUM','1','','73ba5d9f3c94c86eb711'),
	(1738,'ATHALLA REINDRA RAMADHAN','212201007','L','5','1','R. INDRA AGUSSANTIKA K/RENI KORINA APRILIYANTI','PERUM GRAHA SUBANG KENCANA 1 BLOK I No. 9 RT.081/019 CIGADUNG SUBANG','0','5760000','5200000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081220252555','UMUM','1','','7ddeb05f8dcb46fbdc71'),
	(1739,'AHZA FAWWAZ RAMADHAN','212201002','L','5','1','ASEP ILHAS/CHACA NELIYA IZ&amp;amp;amp;amp;amp;amp;amp;#039;ZATUL','TANJUNG MULYA 2 RT.007/003 GAMBARSARI PAGADEN SUBANG','0','2880000','2600000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0821316261982','UMUM','1','','5595f55dec010712e975'),
	(1740,'ZULFA AGNA KAMILA','222301046','P','4','2','NANDANG/SRI MULYANI','GSK 2, BLOK C-29 RAWA BADAK,SUBANG','0','2880000','2400000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','ebfcbde57c0350af5ae6'),
	(1741,'TATANG MAULANA WIJAYA S','222301044','L','4','2','NANA RUHIAT/ELMA RUSTIYANA','PERUMNAS BLOK 7 RT. 041/ RW. 012 SUKAMELANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081 321 499 133','UMUM','1','','801dc442ac1eb3e1aa39'),
	(1742,'RAISHA RAMADHINI RAKHIM','222301039','P','4','2','YOPPI ISMANA RAKHMAN/TINA INAYATI','BUMI ABDI PRAJA BLOK B1 NO. 19','0','2880000','2400000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081320193703','UMUM','1','','e28ff785cca3f160a178'),
	(1743,'RASHYA DIANDRA','222301040','L','4','2','SELVIA DHARMA SUKAMANA/NISA SYAMSIAH','JL. ANGGUR RAYA NO. 21 PERUM PASIR ENDAH ','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085972522358','UMUM','1','','332cc886d8dc2a023b54'),
	(1744,'MUHAMMAD KENZIO ARSYAD REVINZA','222301034','L','4','2','MUHAMMAD SUBHAN YASIEN/FITRI YANI','JALAN H SANUSI NO 51 RT/RW 002/013 DURI KOSAMBI CENGKARENG JAKARTA BARAT','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085222277741','UMUM','1','','138d41ad50acf185b843'),
	(1745,'NABILA REVALINA','222301035','P','4','2','ARIEF BUDIMAN/WULANDARI','JL. WORTEL BLOK U2 SUKAMELANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','85220021015','UMUM','1','','f0325902cc209e4e7efc'),
	(1746,'M. ROMMY ALVARO','222301029','L','4','2','NENG ALIT','JALAN H SANUSI NO 51 RT/RW 002/013 DURI KOSAMBI CENGKARENG JAKARTA BARAT','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','81572252540','UMUM','1','','3557f23f26294ebb3d85'),
	(1747,'M. KEENAN PRAMADITYA H','222301028','L','4','2','M. SUKMA RAMDANI/RIA RIAYANASARI','GRIYA CINANGSI ASRI BLOK A 14','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082 317 601 251','UMUM','1','','948e5ff05fee3311b7a0'),
	(1748,'KENJI GERRARDINO REKSO ATMODJO','222301024','L','4','2','BAGUS TRIATMODJO REKSO ATMODJO/RINA MAELANI','HARVA SUBANG REGENCY BLOK E 21','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081 910 001 221','UMUM','1','','ff5b18d35219351b0ba1'),
	(1749,'JASMINE SALIMAH ROMADHONA','222301023','P','4','2','JEFI ROMADHONA/MUSTIKA QADAR A','KOMP. GARUDA LANUD SURYA DHARMA','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081299682378','UMUM','1','','4092d002f20dd7c599e8'),
	(1750,'HAIDAR FACHRIL ARDIANSAH','222301048','L','4','2','RIZKI ARDIANSAH/NURHASANAH','Belendung parigi Subang','0','2880000','2400000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','08562825213','UMUM','1','','e378981fe37aa60838c4'),
	(1751,'IZAZ ABDER RAZZA','222301022','L','4','2','LUKY AWALUDDIN/BETI NURBAETI','JL. AHMAD YANI NO. 07 PASIRKAREUMBI','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','54e70dedef41ba2f9a98'),
	(1752,'GWEN AIMEE SYAREFIA PUTRI','222301017','P','4','2','DEDEN HAPPY SANCOKO S/VITA PUTRI APRILIANY','BTN CIHEULEUT BLOK A3 NO. 34 RT. 045 RW.014 KEL/DS. PASIRKAREUMBI KEC. SUBANG JAWABARAT','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081220292241','UMUM','1','','dec2f4098dfffe1d700d'),
	(1753,'IBRAHIM JAFAR SIDDIQ','222301021','L','4','2','DONI RAHMAT SUGIMAN/POPON ROSIPAH','JL. PANDU III RT. 015/ RW. 010 PASIRHARJA SUKAMELANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085224880567','UMUM','1','','160da155e36972489a0d'),
	(1754,'FARIZ NAUFAL RABBANI T','222301016','L','4','2','FAHMI ABDILLAH TAUHID /NINA SAHNIAH ','PALEM ASRI REGANCY BLOCK E NO 18 RT 056/005 KEL DANGDEUR KEC SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','817215524','UMUM','1','','6e78fdf86bc520dd482b'),
	(1755,'FARDAN NAJA ELANDRA','222301014','L','4','2','YAYAT MAHPUDIN/ELA NURLAELA','Curug Lima  RT 15/05 Pasirkareumbi Subang ','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082124061884','UMUM','1','','4b63decb490d0551d163'),
	(1756,'AZQIARA PUTRINDA ZAKI','232402054','P','4','2','ACHMAD ZAKI. S.SOS, M.M, M.IPOL/WINDA RIA, S.PSI','Kodim Subang.','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','0a60a1eaa9c3a6b428d2'),
	(1757,'FADIAH ANINDYA MAULA','222301013','P','4','2','ROHMAT/NURHAYATI NATALITA','JL. OTISTA NO 296 RT 048/006 SUKAMELANG SUBANG','0','2880000','2400000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081 395 806 966','UMUM','1','','6e86cb39c6bf7d084340'),
	(1758,'AZKA AZFAR HAIKAL','222301009','L','4','2','ANGGA PRAYOGA/TANTI NOVITASARI','Cibeunying Rt/Rw 019/008 ','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082218098854','UMUM','1','','9f7cc16c4dfba16d41df'),
	(1759,'ARKHAN AKHMAD ATTHARIZ','232402040','L','4','2','BAMBANG IRAWAN, S. AN/SELVY SYLVANIA DEVIANTY, S. SOS','Jl M Dedend S Gg palasari no 3 RT 20 RW 07 cimerta Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','087778646400','UMUM','1','','d94d0e3d1fee579fea4d'),
	(1760,'ALVI RIZKI MUBAROK','222301004','L','4','2','EKO PURNOMO/LENA ROSLIANA','JL.KH MUHIDIN NO. 193 RT. 034/ RW. 008 CIGADUNG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','083823188779','UMUM','1','','7f3cebe05ec29dfe6120'),
	(1761,'ALFATHIR ARDI PRASETYO','222301003','L','4','2','DIMAS PUTRA PRASETYO/RATIH FATUROHMATIN','KP. RANCAKANDONG RT.013 RW.002 KEL. SUKAMELANG KEC. SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081214936309','UMUM','1','','a55363e6f658138f6c4d'),
	(1762,'ZEFA FARZANI','222301045','L','4','1','ADI SUDIARSYAH/TETI ANDRESTIANI','DSN. PAWELUTAN RT.005/ RW. 003 CITRAJAYA BINONG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082115255999','UMUM','1','','09d0105c7740a922471f'),
	(1763,'REYZHEL QEVELLO ANDRA','242503048','L','4','1','SOFYAN EFENDI/RANTI','Puri subang asri','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','81381346107','UMUM','1','','6d278e60a0c693b9a963'),
	(1764,'SABRINA ALULLA SHANUM','222301043','P','4','1','ILMAN MAULANA/ANI SITI NUREAENI','KOMPLEK SUBANG GREEN CITY BLOK A26 NO 12 RT/RW 28/08, CINANGSI, KAB.SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081220003971','UMUM','1','','6c4d219b37f9f8686683'),
	(1765,'REYNAND ALTAF MULYAWAN','222301041','L','4','1','ANDRI MULYAWAN/DINA NURLIAWATI WAHYONO','CILAMERI RT. 002/RW. 001 CISAGA','0','5760000','4800000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','081 394 730 193','UMUM','1','','41ffb6f6f6920cb4b70c'),
	(1766,'RYUGA EL YUSUF','222301042','L','4','1','SUMARDI/GINA RAHAYU','KP.CIPAKU RT 10/03 DESA CIBOGO KEC. CIBOGO KAB.SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','82219082533','UMUM','1','','79b836f91b988ac7abff'),
	(1767,'NAFIZHA NUR MAULIDA','222301036','P','4','1','H. NIA KURNIA, S.SOS/HJ. NANI MARYANI','KP KRAJAN NO.104 RT 06/02 DESA CINANGSI KECAMATAN CIBOGO-SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','81220458786','UMUM','1','','c9e8036deddd1de34b86'),
	(1768,'RAFFA ADINAKA AR RAHMAT','222301038','L','4','1','RAHMATULLOH. SE/FERA YULIANTI.SE','JL. RAYA SUKAMELANG RT.30/09 \nKEL. SUKAMELANG\nKEC. SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085353299660','UMUM','1','','3817dab77b75f77118fe'),
	(1769,'MUHAMMAD DEARLY AL FATIH PERBAWA','222301033','L','4','1','FRENGGA PERBAWA/IIS RISNAWATI','MAJA ASIH RT 11/04 MAJASARI CIBOGO','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','087 879 761 988','UMUM','1','','24dfb9ba3052a40acfc4'),
	(1770,'MUHAMMAD AZKA KHOERUL AZAM','222301032','L','4','1','DUDI HERMANSYAH/JULAEHA','KMP. KRAJAN RT 04 RW 01 DS.TANJUNGRASA KEC. TAMBAKDAHAN KAB. SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081386844365','UMUM','1','','4454002ef4f5aa1ef836'),
	(1771,'MUHAMMAD ABYAN ARKENZI AKBAR','222301031','L','4','1','AKBAR ANUGRAH/JEANY RINDYANTI','JL. HARAMAY NO 25 RT 014 RW 07\nKEC. PAGADEN \nKAB. SUBANG 41252','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','85720446783','UMUM','1','','d79a50b60863d115fc9f'),
	(1772,'KENZIE NAUFAL SRI LUGINA','222301026','L','4','1','BANGKIT SRI LUGINA/RITA ROYANI','DUSUN BONGAS RT 017 RW 005 DS SINDANGSARI KEC CIKAUM KAB SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','89680670609','UMUM','1','','582bf2ef2795ab7f4aa1'),
	(1773,'M. SYAHRIL AS SEKAR','222301030','L','4','1','JENAL MUTTAKIN/SAFITRI RAHAYU','Griya Cipaku Rt/RW 027/007 Blok C1 No.7','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','087738511608','UMUM','1','','5ff85346c740a547d8df'),
	(1774,'KENZIE AZKA WIJAYA','222301025','L','4','1','DANU WIJAYA/RATNASARI','JL. PANGLEJAR RT.036/ RW. 009 KARANGANYAR','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081222433625','UMUM','1','','d2a955aa85dcdec522f2'),
	(1775,'ELONA SAFA ALMIRA','222301012','P','4','1','KHAERUL RAKHMAN/DESY ARIYANTI','RSS SIDODADI BLOK D NO. 47 RT/RW 046/015 PASIRKAREUMBI SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081 122 901 68','UMUM','1','','1d4ca0159bd36127f86d'),
	(1776,'AZRINA ALKHANZA AZZAHRA','222301010','P','4','1','ZAENI FAHRUROJI/DEVI VIYANTI','PERUMNAS BLOK 7 RT. 041/ RW. 012 SUKAMELANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085370220220','UMUM','1','','3a44a38b8c56d3625cf9'),
	(1777,'ATALLA BARCA AFRIAN','222301006','L','4','1','EGGY AFRIAN S./LINDA ARYANI','DE PANJI CLUSTER NO. B5','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','087825262684','UMUM','1','','63b50fad00e9ad0a12ae'),
	(1778,'AYESHA QIANA NURDIANSYAH','222301008','P','4','1','DEDI NURDIANSYAH/LIA MINHATUL MAULA','GSK 2 BLOK E NO.3','0','2880000','2400000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085 320 277 747','UMUM','1','','b0efef25a9dec069cf5a'),
	(1779,'ARUNA SACHI KAYANA','222301005','P','4','1','DEDEN SUMARNO/INDAH DWI PATMASARI','KP.SUKAASIH 1 NO 25 RT 68 RW 18 KEL.KARANGANYAR KEC/KAB.SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','82119130412','UMUM','1','','33cb0787ff593b4d4269'),
	(1780,'ARFA DAMAI CORDELIA','242501045','L','4','1','EVON PUTRI SUSANTI','Perumnas Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','a507adff6e35456a0b53'),
	(1781,'ALDEBARAN HAIDAR','222301002','L','4','1','YUSUP/VIOLETA NEISFA','JL.LEJARMANAH RT 40/10 KELURAHAN KARANG ANYAR, KECAMATAN SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','81297187826','UMUM','1','','7491a4f0714b0a7cbd95'),
	(1782,'ARZUNO MUHAMMAD RAMADHAN NOORIS ','242502050','L','3','2','VICKY ZULFIKAR NOORIS/INNA TRI MARYAMA','Perumnas Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081311567100','UMUM','1','','0773b3c4ef1fcdce0325'),
	(1783,'SALVINA ALEESHA ALRADYA','232401036','P','3','2','SETIADI NUGROHO/RATNA WULANSARI','APAJADA LAND CLUSTER JL. MARJAN KALIJATI TIMUR','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','81221633301','UMUM','1','','429d4fa4f9fea1a068a1'),
	(1784,'SAVERIO AL MALIQUE','232401037','L','3','2','ANDRI SURATMAN/WIDIA MAGRIE','DE PANJI CLUSTER B 13','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081294448882','UMUM','1','','58a11bc2dae26fd3f860'),
	(1785,'RIZKY SETIAWAN','232401035','L','3','2','AYI SETIAWAN/IPAH ARNIPAH','Kp. Sumurbarang RT. 016/006 Sumurbarang Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','6285320417920','UMUM','1','','aebe9058cd78e0050eae'),
	(1786,'RANIA SARAH RACHMAN','232401033','P','3','2','GUGUN SAEFUL RACHMAN/YULIANTI','KOMPLEK BUMI ABDI PRAJA RT/RW 058/016 SUKAMELANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','8122452167','UMUM','1','','1c5e3e92f276f6fcf98d'),
	(1787,'PRAMUDYA ARDHANI HAMIZAN ','232401030','L','3','2','AGAH SUKMA NURZAMAN /DEVI IRNIASARI ','GRIYA CINANGSI ASRI BLOK B NO.290 RT 21 RW 07 DS.CINANGSI KEC.CIBOGO SUBANG','0','2880000','2400000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','81221218686','UMUM','1','','94a83597dda9f5080ad3'),
	(1788,'MOUNIRA SERAPHINA PUTRIWIBOWO','232401024','P','3','2','DENNY SELA/DITA NURYANTI','JL NANAS 3 NO 24 BLOK VI PERUMNAS ','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081223196959','UMUM','1','','f8cb967f1b08156d811d'),
	(1789,'MUHAMMAD NEVANDRA UMESYAH','232401027','L','3','2','UMAIR/META IMELDA','JL CIBOGO KOLOT CIBOGO SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','6281271386757','UMUM','1','','018390a598a1ebeaa9e8'),
	(1790,'KHALID VALERYAN RIBSYA TANJUNG ','242502046','L','3','2','DR.SAMSUL BAHRI TANJUNG,SP.B/DR.INTAN ARVIANTY, M.MED.SC, SP.DVE','gg Kopti No.111, Cigadung, Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','8e3b2fa2f8568e4a4ad8'),
	(1791,'HAURA HILWA ALIFA USMAN','232401017','P','3','2','ASEP USMAN/NURJAMIATUL LAELY','DUSUN MUNJUL RT 15/06 DESA WANTILAN KECAMATAN CIPEUNDEUY KABUPATEN SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085624311112','UMUM','1','','5871379021a5c2e471b4'),
	(1792,'HARITH ADSKHAN ','232401016','L','3','2','YONO/USU','KP. JAMBE ANOM RT 008/002 DESA PURWADADI BARAT KEC. PURWADADI KAB.SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081398769566/08','UMUM','1','','f02070ab35eef2fa8d10'),
	(1793,'HAIFA AYU KIRANA','232401015','P','3','2','ASEP IHLAS/CHACA NELIYA IZZATUL KHUSNA','KP CIKONDANG, PAGADEN BARAT','0','2880000','2400000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082127151796','UMUM','1','','df8087cd1ba3d94b5a82'),
	(1794,'HAFIZ ALFARIZI','232401014','L','3','2','ABDUL SAEPULOH/ANISSA SARAS WATY','PERUMAHAN BUANA SUBANG KENCANA BLOK B36 RT/RW 109/030 KELURAHAN KARANGANYAR KECAMATAN SUBANG KABUPATEN SUBANG 41211','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','087828386251','UMUM','1','','5bd283fe26640e5158da'),
	(1795,'DZAKY HADIWIJAYA','232401008','L','3','2','JIMAT ADAM ROMADONA/WINDA SURI ANDAYANI','JL. RA KARTINI NO. 10','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','81220709789','UMUM','1','','6fe1fd7f0e27b5e0ed1b'),
	(1796,'ARRIZA NUR MUHAMMAD','232401051','L','3','2','NURTAHYUDIN/MINNA MISSINA','BLOK TEGAL KALAPA RT/RW : 014/010, DANGDEUR, KEC. SUBANG, KAB. SUBANG ','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','ecf982c49593998a2717'),
	(1797,'AVRILLA PHONCHO ZAAFIRA ZULFA','232401006','P','3','2','EKO KADAR PATRI ADI, SPT./TRIANA NOVIARISTIN, SSI','JLN. SULAWESI NO 16 SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','81222452592','UMUM','1','','8aa51c1bad89da2ccc7f'),
	(1798,'ALWI AMMAR AL GHAZALI','232401004','L','3','2','PANJI AMMAR ISHAQ/ELA MULATOFAH','JLN RAYA KALIJATI TIMUR NO.129 DSN SUKAMAJU RT 18/06 KALIJATI TIMUR KECAMATAN KALIJATI','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085321752957','UMUM','1','','86ebce722bdfd05e354d'),
	(1799,'ADZKIA SAUFA WIDIANA','232401002','p','3','2','ASEP DINAR WIDIANA/YULIA CIPTA NINGRUM','BLOK RAMBUTAN, RT/RW. 049/013, KEL. CIGADUNG, KEC. SUBANG, KAB SUBANG, JAWA BARAT','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','81223731191','UMUM','1','','4f08753315b1ab6cd16a'),
	(1800,'ALEM VIRENDRA MULYAWAN','232401003','L','3','2','ANDI MULYAWAN/DINA NURLIAWATI WAHONO','CILAMERI RT 02 RW 01 DESA CISAGA SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081394730193','UMUM','1','','e21605f09d34ea2701dc'),
	(1801,'ABIDZAR AL GHIFARY NUGRAHA','232401001','L','3','2','EGI WAHYU NUGRAHA/GATI NURANISA','DSN SUKAMAJU RTLT 18/06 KEC KALIJATI TIMUR KAB SUBANG JAWA BARAT 41271','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081316631461','UMUM','1','','5fcce6c8980fbad87851'),
	(1802,'FAYRA AZIZA ALZAFARANI ','242502052','P','3','1','FAHMI/FATIMAH AZZAHRA','Perumahan Subang Green City Blok E8 No. 28, Kel Cibogo, Kec. Cinangsi, Kab. Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','8c58a56a3bc39ede9239'),
	(1803,'QUONZILO AXELLE FAIVISH','232401031','L','3','1','DIAN AGUS STYO YULIANTORO /VIA MALA','KP PARIGI RT 21 RW 08 DES BELENDUNG KECAMATAN CIBOGO SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081313771662','UMUM','1','','cc3022a6c6bdfe3cbb1b'),
	(1804,'SERAFINA SHANUM KIRANA YUDHA','232401038','P','3','1','BHARATA YUDHA/ANNISA NURUL HASANAH','KELAPA RESIDENCE BLOK A15','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082111104780','UMUM','1','','5f6cb9003cc3df8e430d'),
	(1805,'MYSHA MAHARANI GUNAWAN','232401028','P','3','1','MAHATVA GUNAWAN TANJUNG/BAYU PUSPITA RANI','BUMI PAGADEN PERMAI 3 JL.YUDISTIRA BLOK F 3 NO 55-56 PAGADEN KAB SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','82216482803','UMUM','1','','a3b01fc704e9be4ef7e6'),
	(1806,'NAFISHA HASNAA CARISSA ','232401029','P','3','1','BAMBANG WIGUNA NUGRAHA/WIWI KRESNA LESTARI','GANG BIMA NO 115 RT 029 RW 009 SUKAMELANG SUBANG JAWABARAT','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','82117879988','UMUM','1','','2177582ef92a2443f500'),
	(1807,'MUHAMMAD KHALID ARRASYID','232401026','L','3','1','ADE SUHANDA/TRIANA DEWI','JALAN SAWO RAYA NO.14 RT/RW 082/023 PERUMNAS','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','87708708515','UMUM','1','','ae518e95970cecc24fa4'),
	(1808,'MUHAMMAD ARIEF HIDAYATULLOH','232401025','L','3','1','MAHIRUDIN/USWATUNISAIL KHASANAH','KAMPUNG SUKAJAYA RT/RW 024/009 DESA BELENDUNG KECAMATAN CIBOGO','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','89694566569','UMUM','1','','57ebd4ca7cd2aae07ca1'),
	(1809,'MILESHA SHIDQIN ALIYA FIRDAUS','232401022','P','3','1','RIAN FIRDAUS/GELAR ISMAN','BLOK CIBOGO RT26 RW 18 KEL.DANGDEUR','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','087782089440','UMUM','1','','c26c88feeffab207e9e3'),
	(1810,'M ALFARIEL SIHOTANG ','242502047','L','3','1','MOHAMMAD JORDAN PANGOMOAN SIHOTANG/ELA RUMSIAWATI SUHARSONO','Komplek Pertamina Pagaden','0','5760000','4800000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','',' Subang','UMUM','1','Pindahan','78e56abdf960f5cb87b4'),
	(1811,'KEINAN ARAZKA PRADIPTA','232401021','L','3','1','ADRI PRADIPTA/TRI KUSUMA OKTAVIANA','JL. METEOR KP CONTO KEL. PASIR KAREUMBI','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','82242283321','UMUM','1','','6ee56fb157c6553b4593'),
	(1812,'KEANU ALFARIEL ','232401020','L','3','1','GILANG GUSTAMAN /NURUSTIKA ','PERUMAHAN PERMATA HIJAU 2 NO F72 CIBOGO SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082321111092','UMUM','1','','2df068620e5529acf48b'),
	(1813,'I GUSTI  AGUNG ATHAYA KHALIANDRA NADDEAN','232401018','L','3','1','I GUSTI AGUNG REZA ARHAADITYA WIBOWO/MIA NOVIANTI ','JL. SEMBUNG 2 KP. CERELEK 2 NO.40 RT. 021 RW.009','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','08112007013','UMUM','1','','4165781160fe8fd0abbc'),
	(1814,'KAZUHIRO ARRAWDA ADITYA','232401019','L','3','1','ADITYA ARTHA/HILDA SAVITRI','JALAN JAMBU RAYA NO 33 RT 004 RW 015 PERUMNAS SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085317017157','UMUM','1','','21bcd106cabf41cc22d8'),
	(1815,'GALENA KAMANIYA SLAMET VALERIE','232401013','P','3','1','GILANG GEMILANG FIRDAUS SLAMET PRATAMA/VILETTA FITRIA SAVATWINI','JL. BRIGJEN KATAMSO NO.4','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0811226167','UMUM','1','','d72c608f7256ba898308'),
	(1816,'FELYCA RIZMA HAPSARI','232401048','P','3','1','MOEHAMAD YATIM SUPRIYONO/JOICE HAPSARI FENDRINI','BTN GRIYA CINANGSI ASRI RT. 014 RW. 005 CINANGSI CIBOGO SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','08175002999','UMUM','1','','44e1600a5a0ea9ebc00e'),
	(1817,'FELYRA RIZMA HAPSARI','232401049','P','3','1','MOEHAMAD YATIM SUPRIYONO/JOICE HAPSARI FENDRINI','BTN GRIYA CINANGSI ASRI RT. 014 RW. 005 CINANGSI CIBOGO SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','08175002999','UMUM','1','','dd143450e7a99e80c7a6'),
	(1818,'FARZANA SABRINA ALMAHYRA','232401012','P','3','1','WARIS EKO PRIONO/PUPUT NOVIYANTI','SUKAASIH 1 NO 11 RT 068 RW 018 KARANGANYAR SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082123361212','UMUM','1','','85f9bf46f933033b70ed'),
	(1819,'CEILO MALIK ALTAIR ','232401007','L','3','1','SORAYA PUTRI /SORAYA PUTRI ','GRIYA PESONA PRAJA BLOK A3 NO 6 ','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085770373766','UMUM','1','','7f475fbd40160527e708'),
	(1820,'ARFADHIA RAZQA ATHARUF','232401050','L','3','1','NOTO ABI PROYO/DINA NUR AMALINA','BUANA SUBANG RAYA BLOK F4 No. 27','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081809110281','UMUM','1','','a5db990d9b75066c77ed'),
	(1821,'ANANTA LASHIRA NAZAFARIN','232401005','P','3','1','TOPIK LASHIRA NAZAFARIN/DANDE INE SUMARTINI','PERUMAHAN BUANA SUBANG KENCANA RT 051 RW 016 SOKLAT SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','85222744445','UMUM','1','','54776bdf79378f22c3c1'),
	(1822,'SYIFA MAULIDA SALSABILA','242501044','P','2','2','ENDAN YUSDIANA/RIZKI TRIANSYAH NUR AHMAD','Perum Puri Panji Kencana RT/RW : 094/022, Dusun Cigadung, Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085294346499','UMUM','1','','b348f0a91978115cee93'),
	(1823,'NAURA RAMADHINA NURWAHIDIN','242501037','P','2','2','DIDIN NURWAHIDIN/RANNI RAHMATIKA','Jl sawo 2 no 11 blok 1 perumnas Subang','0','2880000','2400000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081218484750','UMUM','1','','6dc8f7b69901d1eb6851'),
	(1824,'NAIRA GHAISANI','242501034','P','2','2','TAUFIQ NUGROHO/CINTANA DINDA FAKHRUNNISA','Blok Cibogo rt/rw : 050/006, Kel. Dangdeur, Kec. Subang, Jawa Barat','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082240117844','UMUM','1','','35bc2e02f9fe7c3d578b'),
	(1825,'NAUFAL ALKHALIFI PRASTIYO','242501035','L','2','2','TRI PRASTIYO/NENG SRIE SUGIANTI','Cijoged Pos RT 17/ RW 05 Desa Lengkong, Kecamatan Cipeundeuy, Kabupaten Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085721416006','UMUM','1','','919d3052212b44bbbe9b'),
	(1826,'NADIRA ADZKIRA MAHARDIKA','242501033','P','2','2','MUHAMMAD SUBHAN YASIEN/ANISTIA RUMINDA SARI','Komplek Jatayu H8 Lanud Suryadarma Kalijati Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085713561328','UMUM','1','','c30d5f4cdbdfd85c3b7f'),
	(1827,'NABIL KHAIR RAMDANI','242501032','L','2','2','ZAKKI DJATI DJAMIN/THESSI CAHYANINGTIAS','Jl Jambu Raya Blok IV No. 12 RT 77 RW 21 kel. Karanganyar Perumnas Subang 41211','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085214662249','UMUM','1','','ef4ac8e93a95e39a99f5'),
	(1828,'MUHAMAD FATAHILLAH AKBAR AL FATIH','242501028','L','2','2','DEDE KOSTAMAN/LENA RISMAWATI','Blok Liunggunung RT/RW : 009/002, ds. Sanca, Kec. Gantar, Indramayu','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081283154406','UMUM','1','','52eab029fa5a66fbf387'),
	(1829,'K HANI ALFIDEVITA','242501021','P','2','2','SYAIFUL GINANJAR/TITA PUSPITASARI','Kp Bantarsema rt 03/02, desa cisaga kecamatan cibogo','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','08815235930','UMUM','1','','0fe0990171c53cf373f1'),
	(1830,'KEANE MAULANA PUTRA','242501024','L','2','2','CEPI MAULANA RIDWAN/HANI HAFIYYANI','Perumahan Griya Putra Residence','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085311111400','UMUM','1','','7a5bf39ed8d72a1139c8'),
	(1831,'KO CAHO PRATAMA THOMAS','242501027','L','2','2','GAO YING/EGA PUSPITASARI','Kmp.cipacar RT09/RW02 Desa.padamulya Kec.cipunagara','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082319239501','UMUM','1','','4c30ee749a13dc8ce920'),
	(1832,'CLARA AINUN NISYA','242501015','P','2','2','SUBANDI/NENENG NURHASANAH','DUSUN GARDULANGKAP RT 004 RW 002 DESA GUNUNGSARI KEC PAGADEN KAB SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085295657041','UMUM','1','','584c0766271569d83485'),
	(1833,'GHEISAN ARCELLO MAHESA','242501019','L','2','2','AHMAD EGI HIDAYAT/ANI ARISKA','Sukamelang Rt23/04 subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','089656225339','UMUM','1','','a2283810a88da306234a'),
	(1834,'AZFAR RAFFASYA NURDIANSYAH','242501013','L','2','2','DEDI NURDIANSYAH/LIA MINHATUL MAULA','Perum GSK II Blok E No. 3','0','2880000','2400000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085320277747','UMUM','1','','2cd39ce87986470424f3'),
	(1835,'AURORA PUTRI TANGGON CENDIKIA','242501011','P','2','2','CHANDRA OKKI SEPTIAN/NESYA YUDEVISKA','Jl. Trs Pesantren Vlll M No. 133 RT/RW 004/016, Sukamiskin, Arcamanik Bandung','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082321234444','UMUM','1','','88010b77d737542437ad'),
	(1836,'AUDRISSA HAURA ZIANAYA','242501009','P','2','2','MUHAMMAD SUBHAN YASIEN/FITRI YANI','Jalan eyang rangga dipa, samping lapangan sepak bola jabong','0','5280000','4800000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','081320096390','UMUM','1','','7cb2e02638972e7f63c3'),
	(1837,'AULIYA RAHMAH','242501010','P','2','2','DENI KUSUMAH WARDANI/RA DEWI','Kp Cipacar RT 08 RW 02 Desa Padamulya Kecamatan Cipunagara Kabupaten Subang 41257','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082246283170','UMUM','1','','da15767ec5c469cbeb9e'),
	(1838,'ATHAYA NABHAN ZAAHIRULHAQ','242501008','L','2','2','ANDHI KURNIAWAN SH. MH/HEALLI MULYAWATI S, SH','Jln Mayjen DI Panjaitan Kebon Kalapa Gang Sukun I No 7 Kel.Karanganyar Kec.Subang Kab.Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082315418080','UMUM','1','','1b6b0f8f031ab972a5dd'),
	(1839,'ADHYASTA RAQILA SEPUTRA','242501003','L','2','2','ASEP SOLEH/RENA SUSANTI','Jl. Kanikir Karanganyar, Kec, Subang, Kab. Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081322258534','UMUM','1','','4c04f76e1f56293faa17'),
	(1840,'ADARA PUTRI TANGGON CENDIKIA','242501002','P','2','2','CHANDRA OKKI SEPTIAN/NESYA YUDEVISKA','Jl. Trs Pesantren Vlll M No. 133 RT/RW 004/016, Sukamiskin, Arcamanik Bandung','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082321234444','UMUM','1','','1857c1a363a3d1a9ee15'),
	(1841,'ABIZARD ARSHAD NUGRAHA','242501001','L','2','2','ROBBY NUGRAHA SURYAHANDA/SULISTIAWATI','Blok Tegal Kalapa Rt 15 rw 10 Kel Dangdeur Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081223979959','UMUM','1','','4d46448d05a4fc1c0b29'),
	(1842,'SYAFIQAH BURAIRAH ALVANI','242501042','P','2','1','M.HENDRISON/NOVANI RIA','Jl sawo 1 no 27 blok 3 perumnas subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081283200039','UMUM','1','','e578bf4ab7e56857d7b4'),
	(1843,'SYAFIYAH BURAIRAH ALVANI','242501043','P','2','1','M.HENDRISON/NOVANI RIA','Jl sawo 1 no 27 blok 3 perumnas subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081283200039','UMUM','1','','1cecb1585d10ef35732b'),
	(1844,'KEISYA SHANUM ALFATHUNISSA','242501051','P','2','1','FERY NURDIN FERDIAN/VINA FAUZIAH','Kelapa Residence','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','be97a8a4eef92a9d6ab5'),
	(1845,'SANDRIA HAVIKA NAURA','242501041','P','2','1','DIMAS NUREKA/IMA SRIKANDHI','PERUM BUMI ABDI NEGARA JL. RENANG NO. 152 SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085315097777','UMUM','1','','be3fda2cdeaf607cf1c3'),
	(1846,'RAJENDRA DEVIAN ALFAREZ','242501040','L','2','1','RYAN ANDRIANA/DEPI ALFIANI','Jl. Sukagalih 1 No. 16 RT/RW : 62/17, Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082126524046','UMUM','1','','ed686025105b9ce1de71'),
	(1847,'QIANA ADREENA PUTRI REFIANDI','242501039','P','2','1','DENDI REFIANDI/NINDYA LESTARI','Surya Cigadung Blok C 45 RT 76 RW 23, Cigadung, Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','08112340391','UMUM','1','','92b279030d09fbc1ba13'),
	(1848,'QALIFA AL QAHTHAN ROYCE','242501038','L','2','1','SENDY ROYCE RIZAL/NURLATIFAH','Jl. Kapten Hanafiah Perum GSK RT/RW 046/015, Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081220129116','UMUM','1','','51c73b3a9ac3ac439fbb'),
	(1849,'NAUFAL RESKI HERMAWAN','242501036','L','2','1','DERY HERMAWAN SUMIRAT/ELIN SUSILAWATI','Subang green city rt.26/08, cinangsi, cibogo, subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082128644464','UMUM','1','','8fd869042d6a09215d70'),
	(1850,'KHENZY GIFFARI ANDRA','242501026','L','2','1','SOFYAN EFENDI/RANTI PUTRI','PURI SUBANG ASRI','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081381346107','UMUM','1','','67b404544b8d8559aef7'),
	(1851,'MUHAMMAD UKKASYAH AL-FATIH','242501031','L','2','1','AGUNG BAYU TRISNO/NELLA MARSELLA','Komplek pesona regency no 17','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085220205510','UMUM','1','','c05e275be81931368dce'),
	(1852,'KHALISA NURRAMADHANI PRATILO','242501025','P','2','1','EKO HANDOKO PRATILO, ST/DIAN ANGGRAINI MEKSOWATI, SH., MH.','Perum Palm Asri Blok E. 16-17 Rt 056 Rw 005 Kel. Dangdeur Kec. Subang Kab. Subang 41212','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','08121335286','UMUM','1','','c0d1bc0acca4148363e7'),
	(1853,'KAZIM ATHAFARIZ RASYID TANJUNG','242501023','L','2','1','DR.SAMSUL BAHRI TANJUNG,SP.B/DR.INTAN ARVIANTY, M.MED.SC, SP.DVE','gg Kopti No.111, Cigadung, Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082130123483','UMUM','1','','3b2af1a7f519ddc20e77'),
	(1854,'KAYRA SYIFA ZAIDA POURAN','242501022','P','2','1','DEVI YULIAN MAHARDIKA/PIPIT NURUSY SYAMSIAH, S.SI, APT','Jln. APEL RAYA NO 20 RT 74 RW 20 BLOK III PERUMNAS KARANGANYAR SUBANG','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082217684279','UMUM','1','','d6d72a6779f9a2ff6455'),
	(1855,'JASMINE ASH-SHANUM TAZKIYA HAN','242501020','P','2','1','BURHAN/RISMAYANTI APIPAH','Pagaden, gambar sari','0','2880000','2400000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082217734765','UMUM','1','','328438ead22518a92ea5'),
	(1856,'GALUH PRAMESWARI AL ANWAR','242501018','P','2','1','H. ROSIHAN ANWAR/RINI NURDIYANTI','Jl. Sutaatmaja gg tongkeng RT 27/06, Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081394493448','UMUM','1','','f58b4e0e00838c88bdca'),
	(1857,'FATIH ILHAM AULIA','242501016','L','2','1','SUKADI/EUIS CARKESIH','Peundeuy RT 21 RW 05 Padamulya Cipunagara Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082214711106','UMUM','1','','9fcac2a7f8f687433604'),
	(1858,'AZZILFA RAHMANI DAYYAN','242501014','P','2','1','RAYAN NOVAFIANA/DEDEH JUBAEDAH','Buana Subang Kencana Blok A no 39 Kel Soklat','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085325676666','UMUM','1','','1d72e74e68f6e4a7ebb1'),
	(1859,'ATHA PUTRA TANGGON CENDIKIA','242501007','L','2','1','CHANDRA OKKI SEPTIAN/NESYA YUDEVISKA','Jl. Trs Pesantren Vlll M No. 133 RT/RW 004/016, Sukamiskin, Arcamanik Bandung','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082321234444','UMUM','1','','a4d3ac7b36eda78ad902'),
	(1860,'ARTYAREZI SHAQUEENA RAMADHANI','242501006','P','2','1','ARIF PERMANA/RESVA INDAH SAPUTRI','Griya Pesona Praja, RT/RW : 019/006, Cinangsi, Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','081320059567','UMUM','1','','a8d4db7c53e61ac73668'),
	(1861,'ARTHUR PUTRA TANGGON CENDIKIA','242501005','L','2','1','CHANDRA OKKI SEPTIAN/NESYA YUDEVISKA','Jl. Trs Pesantren Vlll M No. 133 RT/RW 004/016, Sukamiskin, Arcamanik Bandung','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082321234444','UMUM','1','','de953791161e6869eeed'),
	(1862,'ARSHAD FIKAR ABQARY ANDRYAN','242501004','L','2','1','ANGGI ANDRIAN PRIATNA/LENI ANGGRAENI','Jalan Apel 6 Blok 2 No 09 RT/RW 079/ 022 Perumnas Kel. Karanganyar Subang','0','5760000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','082118485588','UMUM','1','','1c859446ef36798786cc'),
	(1863,'ABYAN REYNAND DILLAH','252601001','L','1','1','','','','6600000','10000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','027c9cbef1eb2c3e8872'),
	(1864,'ALKHAFA SAUQI BATUBARA','252601003','L','1','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','46c6ffa2fd4c6321848c'),
	(1865,'ATTILA NARA PRADITYA','252601004','L','1','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','0f0cedb31d6045be804d'),
	(1866,'AURENZA AZHAR','252601005','L','1','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','ad57375eb5ce6f182cd9'),
	(1867,'AZ-ZAHRAH CARISSA PUTRI FAUZI','252601006','P','1','1','','','','6600000','10000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','26bf0196c904ff0c30e5'),
	(1868,'ERSTA ATHARAZKA WIBOWO','252601007','L','1','1','','','0','3300000','6250000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','UMUM','1','','86f8852e77ee95eba8c5'),
	(1869,'FELISHA BIKRUM SAKHI','252601008','P','1','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','ef73db56cedb83f74208'),
	(1870,'IBNU SAKTIAWAN SIHOTANG','252601009','L','1','1','','','','6600000','10000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','8a656e85829e52ded8fa'),
	(1871,'KHAIRA SENANDUNG MAHLIGA','252601010','P','1','1','','','','6600000','10000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','c314f3241b3107092cc3'),
	(1872,'KHALISA SHAKIRA AKBAR','252601011','P','1','1','','','','6600000','10000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','57b2735e5a384505c861'),
	(1873,'MUHAMMAD FADLAN AZZUHRI','252601012','L','1','1','','','','6600000','10000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','62e9e132c60202cf8515'),
	(1874,'MUHAMMAD ZAYN AL FATH','252601013','L','1','1','','','','6600000','10000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','8ce8bd039a39743d8f1b'),
	(1875,'NADIA TRIAULIA RAMDANI','252601014','P','1','1','','','','6600000','10250000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','d729f51e61b6ac080baf'),
	(1876,'ODELINA ASKANAH RAMADHANI ISFAHANI','252601015','P','1','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','2ccd068c362be2763606'),
	(1877,'RANGGA RAISUL AGUSTIN','252601016','L','1','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','4b47bec860677917f17f'),
	(1878,'RANIA ALISHA','252601017','P','1','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','940e8a8f8d4cae7445a9'),
	(1879,'RAUFA SHAKEIL LESMANA','252601018','L','1','1','','','','6600000','10000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','52c2723f3fbf7de027a9'),
	(1880,'RAZKA ADITYA','252601019','L','1','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','a623bb673f2274a9b6d0'),
	(1881,'SHANUM VALERIAN ARDAFAIS','252601020','P','1','1','','','','6600000','10000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','700831b80a37107ed43e'),
	(1882,'TAMHIDAN ADINATA','252601021','L','1','1','','','','6600000','10000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','106d95ad8b2798931bc1'),
	(1883,'ZAKI MAULUDIN AZKIA','252601022','L','1','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','90f8a7998fe81d4bc943'),
	(1884,'ALYSYA FAZRIAH','252601031','P','1','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','931e851f5649e02028c6'),
	(1885,'ELZIRA NURIEL ANINDITA','252601023','P','5','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','ccc32cbe6be1be947041'),
	(1886,'SHAFIYA ARKADEWI BERLIAN','242502053','P','3','2','','','','5760000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','180f97d6761098217eeb'),
	(1887,'GHAITS EL ATHAR ABDULLAH','252601025','L','4','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','af95a2c42fde6077a85a'),
	(1888,'GHIYATS EL ARGA ABDULLAH','252601026','L','2','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','0ba9d6ce5d559ab41bc1'),
	(1889,'RAFIF DIRGA ANTASENA DERLIANPUTRA','252601027','L','4','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','8b842f8dcee7b9ca60fa'),
	(1890,'SASCHYA AFIZA TUNGGADEWI DERLIANPUTRI','252601028','P','2','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','4b998777ded75d664e53'),
	(1891,'ARZACHEL JUNIAR RAMADHAN','242502054','L','2','1','','','','5760000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','c7ed79e253ff08ebf6d5'),
	(1892,'FACHRY GHIFARI SUBHAN','252601030','L','5','1','','','','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','4937f2570c475f2455aa'),
	(1893,'ZAVIER AL GIBRAN','252601032','L','3','1','','','0','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','2be33f8ae839a4517b65'),
	(1894,'RADITYA ARSHA PRATAMA','252601033','L','1','1','','','0','6600000','10500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','997b24e865e5ec18ead4'),
	(1895,'MUHAMMAD NIZAM DIAULHAQ','252602026','L','1','1','','','0','6600000','10500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Akademik','1','','9ef19ab4ca5da2ac78d0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_list2526`;

CREATE TABLE IF NOT EXISTS `payment_list2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(120) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `hp` varchar(18) NOT NULL,
  `email` varchar(100) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `status` varchar(15) NOT NULL,
  `keterangan` text DEFAULT NULL,
  `payment_id` varchar(50) NOT NULL,
  `tahun` varchar(9) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_list_detail2526`;

CREATE TABLE IF NOT EXISTS `payment_list_detail2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` datetime NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `jenjang` varchar(5) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `kategori` varchar(30) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `tahap` float NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `random` varchar(20) NOT NULL,
  `penerima` varchar(100) NOT NULL,
  `setor` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `metode` varchar(20) NOT NULL,
  `catatan` text DEFAULT NULL,
  `time` datetime NOT NULL,
  `ip` varchar(30) NOT NULL,
  `browser` text DEFAULT NULL,
  `id_tr` varchar(50) NOT NULL,
  `payment_id` varchar(50) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_set`;

CREATE TABLE IF NOT EXISTS `payment_set` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `aktif` varchar(1) DEFAULT NULL,
  `sistem` varchar(2) NOT NULL,
  `api` text DEFAULT NULL,
  `callback` text DEFAULT NULL,
  `fee` varchar(15) NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `payment_set` (`no`, `aktif`, `sistem`, `api`, `callback`, `fee`, `id`) VALUES
	(1,'','','','','0','4C88C222085FD72DE2D7BC1376625660');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_siswa2526`;

CREATE TABLE IF NOT EXISTS `tabungan_siswa2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `rekening` varchar(20) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `saldo` varchar(15) NOT NULL,
  `status` varchar(15) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tabungan_siswa2526` (`no`, `nama`, `nis`, `rekening`, `kelamin`, `saldo`, `status`, `id`, `created_at`, `updated_at`, `created_by`) VALUES
	(1,'ARSHAD FIKAR ABQARY ANDRYAN','242501004','0','L','0','Aktif','db342236799446e78248','2025-05-27 10:50:26','2025-05-27 10:50:26','af4b8e6465fbf4f079aea603e326b2ef');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `db_transaksi2526`;

CREATE TABLE IF NOT EXISTS `db_transaksi2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` datetime NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `jenjang` varchar(5) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `kategori` varchar(30) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `tahap` float NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `random` varchar(20) NOT NULL,
  `penerima` varchar(100) NOT NULL,
  `setor` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `metode` varchar(20) NOT NULL,
  `catatan` text DEFAULT NULL,
  `time` datetime NOT NULL,
  `ip` varchar(30) NOT NULL,
  `browser` text DEFAULT NULL,
  `id_tr` varchar(50) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=509 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `db_transaksi2526` (`no`, `tanggal`, `nis`, `nama`, `kelamin`, `jenjang`, `paralel`, `kategori`, `jenis`, `tahap`, `jumlah`, `random`, `penerima`, `setor`, `id_setor`, `metode`, `catatan`, `time`, `ip`, `browser`, `id_tr`, `id`) VALUES
	(319,'2025-07-16 00:00:00','222301038','RAFFA ADINAKA AR RAHMAT','L','4','1','UMUM','C',2,'2300000','7F4AEOOP997C','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC666','72BEB064JHM526C2BEB337043'),
	(317,'2025-07-15 00:00:00','242501027','KO CAHO PRATAMA THOMAS','L','2','2','UMUM','C',1,'4800000','E0E02NG94R60','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC664','72BEB064JHM526C2BEB337041'),
	(318,'2025-07-16 00:00:00','202101003','AHMAD HABIBI ASYIFA','L','6','1','UMUM','C',1,'1040000','1744DV50ID0D','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC665','72BEB064JHM526C2BEB337042'),
	(315,'2025-07-15 00:00:00','212201013','NAYLA ANDINI NURFADHILLAH','P','5','1','UMUM','C',1,'1100000','570FAYIXVP5F','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC662','72BEB064JHM526C2BEB337039'),
	(316,'2025-07-15 00:00:00','242501027','KO CAHO PRATAMA THOMAS','L','2','2','UMUM','B',1,'480000','E0E02O6BBVF9','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC663','72BEB064JHM526C2BEB337040'),
	(311,'2025-07-14 00:00:00','232401004','ALWI AMMAR AL GHAZALI','L','3','2','UMUM','C',2,'1748000','2F55BIN2YQD6','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC351','72BEB064JHM526C2BEB336728'),
	(312,'2025-07-14 00:00:00','212201024','MOCHAMAD IQBAL MAULANA','L','5','1','UMUM','B',1,'480000','7920D7N7IW44','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC350','72BEB064JHM526C2BEB336727'),
	(313,'2025-07-14 00:00:00','242503048','REYZHEL QEVELLO ANDRA','L','4','1','UMUM','C',2,'1200000','19BE41T38Z20','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC349','72BEB064JHM526C2BEB336726'),
	(314,'2025-07-15 00:00:00','242501020','JASMINE ASH-SHANUM TAZKIYA HAN','P','2','1','UMUM','C',3,'680000','D5731DPRPBDF','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC348','72BEB064JHM526C2BEB336725'),
	(309,'2025-07-14 00:00:00','232403052','ZAHRA NAYLA TIHANI','P','5','1','UMUM','C',1,'5200000','C37DBB1EUKD8','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC353','72BEB064JHM526C2BEB336730'),
	(310,'2025-07-14 00:00:00','222301028','M. KEENAN PRAMADITYA H','L','4','2','UMUM','C',1,'4080000','B24D8RYCPED5','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC352','72BEB064JHM526C2BEB336729'),
	(305,'2025-07-14 00:00:00','242501022','KAYRA SYIFA ZAIDA POURAN','P','2','1','UMUM','B',1,'480000','3C781TFTMQ2D','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC357','72BEB064JHM526C2BEB336734'),
	(306,'2025-07-14 00:00:00','242501038','QALIFA AL QAHTHAN ROYCE','L','2','1','UMUM','B',1,'480000','50B12DEDV02D','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC356','72BEB064JHM526C2BEB336733'),
	(307,'2025-07-14 00:00:00','202101005','ALFRIZ ANRAGASI JAGADDITHA HUDSI','L','6','1','UMUM','C',1,'5200000','4A593S8ZUOD4','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC355','72BEB064JHM526C2BEB336732'),
	(308,'2025-07-14 00:00:00','232403052','ZAHRA NAYLA TIHANI','P','5','1','UMUM','B',1,'480000','C37DB1E8AT32','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC354','72BEB064JHM526C2BEB336731'),
	(303,'2025-07-14 00:00:00','232401007','CEILO MALIK ALTAIR','L','3','1','UMUM','B',1,'483000','8353D3VK1LA9','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC359','72BEB064JHM526C2BEB336736'),
	(304,'2025-07-14 00:00:00','222301036','NAFIZHA NUR MAULIDA','P','4','1','UMUM','B',1,'480000','0F0044663N11','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC358','72BEB064JHM526C2BEB336735'),
	(302,'2025-07-14 00:00:00','202101011','ARSEN ADISA ASHSHIYAAM','L','6','2','UMUM','C',1,'5200000','103C6G62DK52','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC360','72BEB064JHM526C2BEB336737'),
	(299,'2025-07-14 00:00:00','242501023','KAZIM ATHAFARIZ RASYID TANJUNG','L','2','1','UMUM','C',1,'3000000','9D7DEFTOQOEB','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC363','72BEB064JHM526C2BEB336740'),
	(300,'2025-07-14 00:00:00','242502046','KHALID VALERYAN RIBSYA TANJUNG','L','3','2','UMUM','B',1,'480000','56B6DSYF1VE0','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC362','72BEB064JHM526C2BEB336739'),
	(301,'2025-07-14 00:00:00','242502046','KHALID VALERYAN RIBSYA TANJUNG','L','3','2','UMUM','C',1,'3000000','56B6DVV6U912','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC361','72BEB064JHM526C2BEB336738'),
	(297,'2025-07-14 00:00:00','232401038','SERAFINA SHANUM KIRANA YUDHA','P','3','1','UMUM','C',1,'4800000','0CFE1SCS5NC7','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC365','72BEB064JHM526C2BEB336742'),
	(298,'2025-07-14 00:00:00','242501023','KAZIM ATHAFARIZ RASYID TANJUNG','L','2','1','UMUM','B',1,'480000','9D7DEAMGBOE5','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC364','72BEB064JHM526C2BEB336741'),
	(296,'2025-07-14 00:00:00','202101042','SYAKILLA AZ DZAKIYAH JELITA HAN','P','6','2','UMUM','B',1,'240000','718443PDM912','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC366','72BEB064JHM526C2BEB336743'),
	(294,'2025-07-13 00:00:00','232403041','SEBASTIAN SCHUMACER','L','5','1','UMUM','B',1,'480000','B87C1FA15W0D','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC368','72BEB064JHM526C2BEB336745'),
	(295,'2025-07-14 00:00:00','232401006','AVRILLA PHONCHO ZAAFIRA ZULFA','P','3','2','UMUM','B',1,'480000','E0C51LODI7CA','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC367','72BEB064JHM526C2BEB336744'),
	(293,'2025-07-13 00:00:00','222301005','ARUNA SACHI KAYANA','P','4','1','UMUM','C',1,'4800000','8590D7CS3KFE','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC369','72BEB064JHM526C2BEB336746'),
	(292,'2025-07-13 00:00:00','242501028','MUHAMAD FATAHILLAH AKBAR AL FATIH','L','2','2','UMUM','C',1,'1600000','585C0IEQFF88','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC370','72BEB064JHM526C2BEB336747'),
	(291,'2025-07-13 00:00:00','222301005','ARUNA SACHI KAYANA','P','4','1','UMUM','B',1,'480000','8590DPZMCP2B','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC371','72BEB064JHM526C2BEB336748'),
	(289,'2025-07-13 00:00:00','242502047','M ALFARIEL SIHOTANG','L','3','1','UMUM','B',1,'480000','655CFLB8HG87','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC373','72BEB064JHM526C2BEB336750'),
	(290,'2025-07-13 00:00:00','242502047','M ALFARIEL SIHOTANG','L','3','1','UMUM','C',1,'2000000','655CFHLLU2AB','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC372','72BEB064JHM526C2BEB336749'),
	(284,'2025-07-13 00:00:00','222301038','RAFFA ADINAKA AR RAHMAT','L','4','1','UMUM','B',1,'480000','CB8AAHE6LZ99','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC378','72BEB064JHM526C2BEB336755'),
	(285,'2025-07-12 00:00:00','202101018','GYAN SATYA ALARIC','L','6','1','UMUM','C',1,'5200000','5AB26XODY7DD','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC377','72BEB064JHM526C2BEB336754'),
	(286,'2025-07-13 00:00:00','222301023','JASMINE SALIMAH ROMADHONA','P','4','2','UMUM','B',1,'480000','80D5ECJVS089','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC376','72BEB064JHM526C2BEB336753'),
	(287,'2025-07-13 00:00:00','242501002','ADARA PUTRI TANGGON CENDIKIA','P','2','2','UMUM','B',1,'480000','C08C1IUR6911','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC375','72BEB064JHM526C2BEB336752'),
	(288,'2025-07-13 00:00:00','242501011','AURORA PUTRI TANGGON CENDIKIA','P','2','2','UMUM','B',1,'480000','DB475B7RY5D1','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC374','72BEB064JHM526C2BEB336751'),
	(283,'2025-07-12 00:00:00','202101018','GYAN SATYA ALARIC','L','6','1','UMUM','B',1,'480000','5AB26LMWXT42','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC379','72BEB064JHM526C2BEB336756'),
	(281,'2025-07-12 00:00:00','242502053','SHAFIYA ARKADEWI BERLIAN','P','3','2','UMUM','B',1,'480000','B5B1FGL9IVC7','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC381','72BEB064JHM526C2BEB336758'),
	(282,'2025-07-12 00:00:00','202101014','AZZAHRA DIANDRA NUGROHO','P','6','1','UMUM','C',1,'5200000','8B977N28Q466','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC380','72BEB064JHM526C2BEB336757'),
	(280,'2025-07-12 00:00:00','242501039','QIANA ADREENA PUTRI REFIANDI','P','2','1','UMUM','C',1,'2000000','054C2TC316BC','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC382','72BEB064JHM526C2BEB336759'),
	(278,'2025-07-11 00:00:00','242501034','NAIRA GHAISANI','P','2','','UMUM','C',1,'4800000','7EA80BR58G280','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC384','72BEB064JHM526C2BEB336761'),
	(279,'2025-07-11 00:00:00','212201027','TYARI AFWA SHAHIA RAFANI','P','5','1','UMUM','B',1,'480000','B6F511U0GD61','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC383','72BEB064JHM526C2BEB336760'),
	(276,'2025-07-11 00:00:00','232404043','SATRIA PUTRA YOZA','L','6','','UMUM','C',3,'500000','7EA80BR58G277','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC386','72BEB064JHM526C2BEB336763'),
	(277,'2025-07-11 00:00:00','242501034','NAIRA GHAISANI','P','2','','UMUM','B',1,'480000','7EA80BR58G279','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC385','72BEB064JHM526C2BEB336762'),
	(274,'2025-07-11 00:00:00','202101042','SYAKILLA AZ DZAKIYAH JELITA HAN','P','6','','UMUM','C',2,'1500000','7EA80BR58G276','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC388','72BEB064JHM526C2BEB336765'),
	(275,'2025-07-11 00:00:00','242501019','GHEISAN ARCELLO MAHESA','L','2','','UMUM','C',1,'2000000','7EA80BR58G278','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC387','72BEB064JHM526C2BEB336764'),
	(273,'2025-07-11 00:00:00','242501020','JASMINE ASH-SHANUM TAZKIYA HAN','P','2','1','UMUM','C',2,'1000000','7EA80BR58G275','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC389','72BEB064JHM526C2BEB336766'),
	(272,'2025-07-11 00:00:00','242501020','JASMINE ASH-SHANUM TAZKIYA HAN','P','2','1','UMUM','B',1,'240000','7EA80BR58G274','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC390','72BEB064JHM526C2BEB336767'),
	(271,'2025-07-11 00:00:00','222301006','ATALLA BARCA AFRIAN','L','4','','UMUM','C',1,'1000000','7EA80BR58G273','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC391','72BEB064JHM526C2BEB336768'),
	(270,'2025-07-11 00:00:00','222301003','ALFATHIR ARDI PRASETYO','L','4','','UMUM','C',1,'2000000','7EA80BR58G271','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC392','72BEB064JHM526C2BEB336769'),
	(269,'2025-07-11 00:00:00','222301003','ALFATHIR ARDI PRASETYO','L','4','','UMUM','B',1,'480000','7EA80BR58G272','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC393','72BEB064JHM526C2BEB336770'),
	(267,'2025-07-10 00:00:00','232401050','ARFADHIA RAZQA ATHARUF','L','3','','UMUM','B',1,'480000','7EA80BR58G269','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC395','72BEB064JHM526C2BEB336772'),
	(268,'2025-07-10 00:00:00','222301042','RYUGA EL YUSUF','L','4','','UMUM','C',1,'4500000','7EA80BR58G270','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC394','72BEB064JHM526C2BEB336771'),
	(266,'2025-07-10 00:00:00','232403042','MUHAMMAD AFFAN DZAKI BACHTIAR','L','5','','UMUM','C',2,'5200000','7EA80BR58G268','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 5 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC396','72BEB064JHM526C2BEB336773'),
	(264,'2025-07-10 00:00:00','222301008','AYESHA QIANA NURDIANSYAH','P','4','','UMUM','C',2,'100000','7EA80BR58G266','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC398','72BEB064JHM526C2BEB336775'),
	(265,'2025-07-10 00:00:00','232403042','MUHAMMAD AFFAN DZAKI BACHTIAR','L','5','','UMUM','B',1,'480000','7EA80BR58G267','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC397','72BEB064JHM526C2BEB336774'),
	(263,'2025-07-10 00:00:00','202101040','RAKEAN WASTU HENDRAWAN','L','6','','UMUM','B',1,'480000','7EA80BR58G265','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC399','72BEB064JHM526C2BEB336776'),
	(262,'2025-07-10 00:00:00','202101040','RAKEAN WASTU HENDRAWAN','L','6','','UMUM','C',1,'2200000','7EA80BR58G264','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC400','72BEB064JHM526C2BEB336777'),
	(260,'2025-07-10 00:00:00','242501031','MUHAMMAD UKKASYAH AL-FATIH','L','2','','UMUM','B',1,'480000','7EA80BR58G263','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC401','72BEB064JHM526C2BEB336778'),
	(261,'2025-07-10 00:00:00','242501031','MUHAMMAD UKKASYAH AL-FATIH','L','2','','UMUM','C',1,'2400000','7EA80BR58G262','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC402','72BEB064JHM526C2BEB336779'),
	(259,'2025-07-10 00:00:00','202101041','RAZEEQ SACHTI ABDALLA','L','6','','UMUM','C',2,'2000000','7EA80BR58G261','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC403','72BEB064JHM526C2BEB336780'),
	(257,'2025-07-10 00:00:00','212201022','GILENSYA BRILLIAN ABIYUSAFA','L','5','','UMUM','C',1,'5200000','7EA80BR58G260','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 5 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC405','72BEB064JHM526C2BEB336782'),
	(258,'2025-07-10 00:00:00','212201022','GILENSYA BRILLIAN ABIYUSAFA','L','5','','UMUM','B',1,'480000','7EA80BR58G259','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC404','72BEB064JHM526C2BEB336781'),
	(256,'2025-07-10 00:00:00','242501005','ARTHUR PUTRA TANGGON CENDIKIA','L','2','','UMUM','B',1,'480000','7EA80BR58G258','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC406','72BEB064JHM526C2BEB336783'),
	(255,'2025-07-10 00:00:00','242501007','ATHA PUTRA TANGGON CENDIKIA','L','2','','UMUM','B',1,'480000','7EA80BR58G257','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC407','72BEB064JHM526C2BEB336784'),
	(254,'2025-07-09 00:00:00','222301024','KENJI GERRARDINO REKSO ATMODJO','L','4','','UMUM','C',2,'4150000','7EA80BR58G256','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC408','72BEB064JHM526C2BEB336785'),
	(253,'2025-07-09 00:00:00','222301024','KENJI GERRARDINO REKSO ATMODJO','L','4','','UMUM','B',1,'480000','7EA80BR58G255','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC409','72BEB064JHM526C2BEB336786'),
	(252,'2025-07-09 00:00:00','222301036','NAFIZHA NUR MAULIDA','P','4','','UMUM','C',1,'4800000','7EA80BR58G254','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC410','72BEB064JHM526C2BEB336787'),
	(251,'2025-07-09 00:00:00','222301044','TATANG MAULANA WIJAYA S','L','4','','UMUM','C',1,'4800000','7EA80BR58G253','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC411','72BEB064JHM526C2BEB336788'),
	(250,'2025-07-09 00:00:00','222301044','TATANG MAULANA WIJAYA S','L','4','','UMUM','B',1,'480000','7EA80BR58G252','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC412','72BEB064JHM526C2BEB336789'),
	(249,'2025-07-09 00:00:00','222301024','KENJI GERRARDINO REKSO ATMODJO','L','4','','UMUM','C',1,'650000','7EA80BR58G251','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC413','72BEB064JHM526C2BEB336790'),
	(246,'2025-07-09 00:00:00','232401029','NAFISHA HASNAA CARISSA','P','3','','UMUM','B',1,'480000','7EA80BR58G248','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC416','72BEB064JHM526C2BEB336793'),
	(247,'2025-07-09 00:00:00','232401029','NAFISHA HASNAA CARISSA','P','3','','UMUM','C',1,'4800000','7EA80BR58G249','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC415','72BEB064JHM526C2BEB336792'),
	(248,'2025-07-09 00:00:00','242501037','NAURA RAMADHINA NURWAHIDIN','P','2','','UMUM','C',2,'1000000','7EA80BR58G250','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC414','72BEB064JHM526C2BEB336791'),
	(244,'2025-07-09 00:00:00','242502054','ARZACHEL JUNIAR RAMADHAN','L','2','','UMUM','B',1,'480000','7EA80BR58G245','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC418','72BEB064JHM526C2BEB336795'),
	(245,'2025-07-09 00:00:00','222301021','IBRAHIM JAFAR SIDDIQ','L','4','','UMUM','C',1,'2000000','7EA80BR58G247','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC417','72BEB064JHM526C2BEB336794'),
	(243,'2025-07-09 00:00:00','222301021','IBRAHIM JAFAR SIDDIQ','L','4','','UMUM','B',1,'480000','7EA80BR58G246','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC419','72BEB064JHM526C2BEB336796'),
	(242,'2025-07-09 00:00:00','242501026','KHENZY GIFFARI ANDRA','L','2','','UMUM','C',2,'2000000','7EA80BR58G244','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC420','72BEB064JHM526C2BEB336797'),
	(241,'2025-07-09 00:00:00','242501026','KHENZY GIFFARI ANDRA','L','2','','UMUM','C',1,'500000','7EA80BR58G243','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC421','72BEB064JHM526C2BEB336798'),
	(240,'2025-07-09 00:00:00','212201015','DHAFITHA NISA NUR AZIZAH','L','5','','UMUM','B',1,'480000','7EA80BR58G242','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC422','72BEB064JHM526C2BEB336799'),
	(239,'2025-07-09 00:00:00','212201015','DHAFITHA NISA NUR AZIZAH','L','5','','UMUM','C',1,'5200000','7EA80BR58G241','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 5 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC423','72BEB064JHM526C2BEB336800'),
	(238,'2025-07-09 00:00:00','202101036','RAISHA GHASSANI XAVIERA SIDDIQ','P','6','','UMUM','B',1,'480000','7EA80BR58G240','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC424','72BEB064JHM526C2BEB336801'),
	(237,'2025-07-09 00:00:00','222301032','MUHAMMAD AZKA KHOERUL AZAM','L','4','','UMUM','C',1,'4800000','7EA80BR58G239','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC425','72BEB064JHM526C2BEB336802'),
	(236,'2025-07-08 00:00:00','232401021','KEINAN ARAZKA PRADIPTA','L','3','','UMUM','C',2,'220000','7EA80BR58G238','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC426','72BEB064JHM526C2BEB336803'),
	(234,'2025-07-08 00:00:00','242501035','NAUFAL ALKHALIFI PRASTIYO','L','2','','UMUM','C',1,'3000000','7EA80BR58G236','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC428','72BEB064JHM526C2BEB336805'),
	(235,'2025-07-08 00:00:00','202101008','ALWI JANUAR SIBYANI','L','6','','UMUM','C',1,'2000000','7EA80BR58G237','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC427','72BEB064JHM526C2BEB336804'),
	(233,'2025-07-08 00:00:00','242502050','ARZUNO MUHAMMAD RAMADHAN NOORIS','L','3','','UMUM','C',2,'200000','7EA80BR58G235','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC429','72BEB064JHM526C2BEB336806'),
	(232,'2025-07-08 00:00:00','222301040','RASHYA DIANDRA','L','4','','UMUM','C',1,'4800000','7EA80BR58G234','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC430','72BEB064JHM526C2BEB336807'),
	(231,'2025-07-08 00:00:00','202101007','ALIF ALBARRI MUBAROK','L','6','','UMUM','B',1,'480000','7EA80BR58G233','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC431','72BEB064JHM526C2BEB336808'),
	(230,'2025-07-08 00:00:00','202101007','ALIF ALBARRI MUBAROK','L','6','','UMUM','C',1,'5200000','7EA80BR58G232','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC432','72BEB064JHM526C2BEB336809'),
	(229,'2025-07-08 00:00:00','222301012','ELONA SAFA ALMIRA','P','4','','UMUM','C',2,'4800000','7EA80BR58G231','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC433','72BEB064JHM526C2BEB336810'),
	(228,'2025-07-08 00:00:00','222301012','ELONA SAFA ALMIRA','P','4','','UMUM','B',1,'5280000','7EA80BR58G230','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC434','72BEB064JHM526C2BEB336811'),
	(227,'2025-07-08 00:00:00','222301002','ALDEBARAN HAIDAR','L','4','','UMUM','C',1,'4800000','7EA80BR58G229','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC435','72BEB064JHM526C2BEB336812'),
	(226,'2025-07-08 00:00:00','242501001','ABIZARD ARSHAD NUGRAHA','L','2','','UMUM','B',1,'480000','7EA80BR58G227','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC436','72BEB064JHM526C2BEB336813'),
	(224,'2025-07-08 00:00:00','212201027','TYARI AFWA SHAHIA RAFANI','P','5','','UMUM','C',1,'5200000','7EA80BR58G228','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 5 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC437','72BEB064JHM526C2BEB336814'),
	(225,'2025-07-08 00:00:00','222301035','NABILA REVALINA','P','4','','UMUM','C',1,'4800000','7EA80BR58G226','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC438','72BEB064JHM526C2BEB336815'),
	(222,'2025-07-08 00:00:00','232401012','FARZANA SABRINA ALMAHYRA','P','3','','UMUM','B',1,'480000','7EA80BR58G224','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC440','72BEB064JHM526C2BEB336817'),
	(220,'2025-07-08 00:00:00','222301035','NABILA REVALINA','P','4','','UMUM','B',1,'480000','7EA80BR58G222','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC442','72BEB064JHM526C2BEB336819'),
	(221,'2025-07-08 00:00:00','232401012','FARZANA SABRINA ALMAHYRA','P','3','','UMUM','C',1,'4800000','7EA80BR58G223','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC441','72BEB064JHM526C2BEB336818'),
	(223,'2025-07-08 00:00:00','242501013','AZFAR RAFFASYA NURDIANSYAH','L','2','','UMUM','C',1,'400000','7EA80BR58G225','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC439','72BEB064JHM526C2BEB336816'),
	(219,'2025-07-08 00:00:00','212201031','MUHAMMAD ALVARO DIRGA MAHESWARA','L','6','','UMUM','C',1,'5200000','7EA80BR58G221','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC443','72BEB064JHM526C2BEB336820'),
	(218,'2025-07-08 00:00:00','242501033','NADIRA ADZKIRA MAHARDIKA','P','2','','UMUM','C',1,'4800000','7EA80BR58G220','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC444','72BEB064JHM526C2BEB336821'),
	(217,'2025-07-08 00:00:00','242501033','NADIRA ADZKIRA MAHARDIKA','P','2','','UMUM','B',1,'480000','7EA80BR58G219','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC445','72BEB064JHM526C2BEB336822'),
	(215,'2025-07-08 00:00:00','212201031','MUHAMMAD ALVARO DIRGA MAHESWARA','L','6','','UMUM','B',1,'480000','7EA80BR58G218','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC447','72BEB064JHM526C2BEB336824'),
	(216,'2025-07-08 00:00:00','242501036','NAUFAL RESKI HERMAWAN','L','2','','UMUM','B',1,'480000','7EA80BR58G217','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC446','72BEB064JHM526C2BEB336823'),
	(214,'2025-07-08 00:00:00','202101001','AABID ARFA ATTAYYA DZUBYAN','L','6','','UMUM','C',1,'5200000','7EA80BR58G215','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC449','72BEB064JHM526C2BEB336826'),
	(213,'2025-07-08 00:00:00','242501036','NAUFAL RESKI HERMAWAN','L','2','','UMUM','C',1,'2000000','7EA80BR58G216','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC448','72BEB064JHM526C2BEB336825'),
	(212,'2025-07-08 00:00:00','242501014','AZZILFA RAHMANI DAYYAN','P','2','','UMUM','C',1,'4800000','7EA80BR58G214','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC450','72BEB064JHM526C2BEB336827'),
	(211,'2025-07-08 00:00:00','232404043','SATRIA PUTRA YOZA','L','6','','UMUM','C',2,'1000000','7EA80BR58G213','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC451','72BEB064JHM526C2BEB336828'),
	(209,'2025-07-08 00:00:00','202101034','RAHMAN HILMANYSAH','L','6','','UMUM','B',1,'480000','7EA80BR58G211','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC453','72BEB064JHM526C2BEB336830'),
	(210,'2025-07-08 00:00:00','232404043','SATRIA PUTRA YOZA','L','6','','UMUM','B',1,'480000','7EA80BR58G212','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC452','72BEB064JHM526C2BEB336829'),
	(208,'2025-07-08 00:00:00','202101034','RAHMAN HILMANYSAH','L','6','','UMUM','C',1,'5200000','7EA80BR58G210','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC454','72BEB064JHM526C2BEB336831'),
	(206,'2025-07-08 00:00:00','212201025','MUHAMAD AFKAR KURNIAWAN','P','5','','UMUM','B',1,'480000','7EA80BR58G208','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC456','72BEB064JHM526C2BEB336833'),
	(207,'2025-07-08 00:00:00','232401014','HAFIZ ALFARIZI','L','3','','UMUM','C',2,'3315000','7EA80BR58G209','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC455','72BEB064JHM526C2BEB336832'),
	(205,'2025-07-08 00:00:00','222301029','M. ROMMY ALVARO','L','4','','UMUM','C',1,'2000000','7EA80BR58G207','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC457','72BEB064JHM526C2BEB336834'),
	(204,'2025-07-08 00:00:00','232401038','SERAFINA SHANUM KIRANA YUDHA','P','3','','UMUM','B',1,'480000','7EA80BR58G206','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC459','72BEB064JHM526C2BEB336836'),
	(203,'2025-07-08 00:00:00','202101025','KHAYLA APRILIA KIRANA','P','6','','UMUM','B',1,'480000','7EA80BR58G205','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC458','72BEB064JHM526C2BEB336835'),
	(202,'2025-07-08 00:00:00','202101025','KHAYLA APRILIA KIRANA','P','6','','UMUM','C',1,'2000000','7EA80BR58G204','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC460','72BEB064JHM526C2BEB336837'),
	(201,'2025-07-08 00:00:00','202101030','MUHAMMAD DARREL ALKHALIFI PERBAWA','L','6','','UMUM','C',1,'2000000','7EA80BR58G203','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC461','72BEB064JHM526C2BEB336838'),
	(200,'2025-07-08 00:00:00','222301033','MUHAMMAD DEARLY AL FATIH PERBAWA','L','4','','UMUM','C',2,'2000000','7EA80BR58G202','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC462','72BEB064JHM526C2BEB336839'),
	(198,'2025-07-08 00:00:00','202101030','MUHAMMAD DARREL ALKHALIFI PERBAWA','L','6','','UMUM','B',1,'480000','7EA80BR58G200','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC464','72BEB064JHM526C2BEB336841'),
	(199,'2025-07-08 00:00:00','222301033','MUHAMMAD DEARLY AL FATIH PERBAWA','L','4','','UMUM','B',1,'480000','7EA80BR58G201','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC463','72BEB064JHM526C2BEB336840'),
	(197,'2025-07-08 00:00:00','212201005','MUHAMMAD NAUFAL RIZKY UMESYAH','P','5','','UMUM','C',1,'5200000','7EA80BR58G199','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 5 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC465','72BEB064JHM526C2BEB336842'),
	(196,'2025-07-08 00:00:00','232401027','MUHAMMAD NEVANDRA UMESYAH','L','3','','UMUM','C',1,'4800000','7EA80BR58G198','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC466','72BEB064JHM526C2BEB336843'),
	(194,'2025-07-08 00:00:00','212201005','MUHAMMAD NAUFAL RIZKY UMESYAH','P','5','','UMUM','B',1,'480000','7EA80BR58G196','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC468','72BEB064JHM526C2BEB336845'),
	(195,'2025-07-08 00:00:00','232401027','MUHAMMAD NEVANDRA UMESYAH','L','3','','UMUM','B',1,'480000','7EA80BR58G197','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC467','72BEB064JHM526C2BEB336844'),
	(193,'2025-07-07 00:00:00','202101006','ALIF ADDIN GUNAWAN \'IZZA','L','6','','UMUM','B',1,'240000','7EA80BR58G194','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC470','72BEB064JHM526C2BEB336847'),
	(192,'2025-07-07 00:00:00','222301045','ZEFA FARZANI','L','4','','UMUM','B',1,'480000','7EA80BR58G195','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC469','72BEB064JHM526C2BEB336846'),
	(191,'2025-07-07 00:00:00','202101006','ALIF ADDIN GUNAWAN \'IZZA','L','6','','UMUM','C',1,'600000','7EA80BR58G193','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC471','72BEB064JHM526C2BEB336848'),
	(190,'2025-07-07 00:00:00','222301013','FADIAH ANINDYA MAULA','P','4','','UMUM','C',1,'400000','7EA80BR58G192','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC472','72BEB064JHM526C2BEB336849'),
	(189,'2025-07-07 00:00:00','242501032','NABIL KHAIR RAMDANI','L','2','','UMUM','B',1,'480000','7EA80BR58G191','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC473','72BEB064JHM526C2BEB336850'),
	(188,'2025-07-07 00:00:00','242501032','NABIL KHAIR RAMDANI','L','2','','UMUM','C',1,'4800000','7EA80BR58G190','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC474','72BEB064JHM526C2BEB336851'),
	(187,'2025-07-07 00:00:00','232401019','KAZUHIRO ARRAWDA ADITYA','L','3','','UMUM','C',2,'3000000','7EA80BR58G189','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC475','72BEB064JHM526C2BEB336852'),
	(186,'2025-07-07 00:00:00','242501010','AULIYA RAHMAH','P','2','','UMUM','C',1,'4800000','7EA80BR58G188','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC476','72BEB064JHM526C2BEB336853'),
	(183,'2025-07-07 00:00:00','232402040','ARKHAN AKHMAD ATTHARIZ','L','4','','UMUM','C',1,'4800000','7EA80BR58G186','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC478','72BEB064JHM526C2BEB336855'),
	(184,'2025-07-07 00:00:00','212201020','GAVIN ARVANDHIA WIJAYA','L','5','','UMUM','C',1,'2000000','7EA80BR58G185','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 5 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC479','72BEB064JHM526C2BEB336856'),
	(185,'2025-07-07 00:00:00','232402040','ARKHAN AKHMAD ATTHARIZ','L','4','','UMUM','B',1,'480000','7EA80BR58G187','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC477','72BEB064JHM526C2BEB336854'),
	(182,'2025-07-07 00:00:00','242501041','SANDRIA HAVIKA NAURA','P','2','','UMUM','C',1,'2000000','7EA80BR58G184','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC480','72BEB064JHM526C2BEB336857'),
	(181,'2025-07-07 00:00:00','242501010','AULIYA RAHMAH','P','2','','UMUM','B',1,'480000','7EA80BR58G183','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC481','72BEB064JHM526C2BEB336858'),
	(180,'2025-07-07 00:00:00','242501044','SYIFA MAULIDA SALSABILA','P','2','','UMUM','C',1,'4800000','7EA80BR58G182','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC482','72BEB064JHM526C2BEB336859'),
	(179,'2025-07-07 00:00:00','242501025','KHALISA NURRAMADHANI PRATILO','P','2','','UMUM','C',1,'2000000','7EA80BR58G180','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC483','72BEB064JHM526C2BEB336860'),
	(177,'2025-07-07 00:00:00','212201012','DAIKI ARSYAD KHAIRULLAH','P','5','','UMUM','B',1,'480000','7EA80BR58G178','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC486','72BEB064JHM526C2BEB336863'),
	(178,'2025-07-07 00:00:00','212201016','NAZMI ATFHAL AZIZ','L','5','','UMUM','C',1,'5200000','7EA80BR58G181','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 5 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC484','72BEB064JHM526C2BEB336861'),
	(176,'2025-07-07 00:00:00','242501025','KHALISA NURRAMADHANI PRATILO','P','2','','UMUM','B',1,'480000','7EA80BR58G179','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC485','72BEB064JHM526C2BEB336862'),
	(174,'2025-07-07 00:00:00','232401002','ADZKIA SAUFA WIDIANA','p','3','','UMUM','C',1,'4800000','7EA80BR58G176','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC488','72BEB064JHM526C2BEB336865'),
	(175,'2025-07-07 00:00:00','232401002','ADZKIA SAUFA WIDIANA','p','3','','UMUM','B',1,'5280000','7EA80BR58G177','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC487','72BEB064JHM526C2BEB336864'),
	(173,'2025-07-07 00:00:00','222301045','ZEFA FARZANI','L','4','','UMUM','C',2,'3450000','7EA80BR58G175','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC489','72BEB064JHM526C2BEB336866'),
	(172,'2025-07-07 00:00:00','212201016','NAZMI ATFHAL AZIZ','L','5','','UMUM','B',1,'480000','7EA80BR58G174','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC490','72BEB064JHM526C2BEB336867'),
	(170,'2025-07-07 00:00:00','202101029','MUHAMMAD DAFFA RIZQI','L','6','','UMUM','C',1,'2000000','7EA80BR58G172','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC492','72BEB064JHM526C2BEB336869'),
	(171,'2025-07-07 00:00:00','242501044','SYIFA MAULIDA SALSABILA','P','2','','UMUM','B',1,'480000','7EA80BR58G173','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC491','72BEB064JHM526C2BEB336868'),
	(168,'2025-07-07 00:00:00','212201029','FARAND SAVERIO KHILAL','L','6','','UMUM','B',1,'480000','7EA80BR58G170','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC494','72BEB064JHM526C2BEB336871'),
	(169,'2025-07-07 00:00:00','222301008','AYESHA QIANA NURDIANSYAH','P','4','','UMUM','C',1,'300000','7EA80BR58G171','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC493','72BEB064JHM526C2BEB336870'),
	(167,'2025-07-06 00:00:00','212201026','SRI AYU KENCANA','P','5','','UMUM','B',1,'480000','7EA80BR58G168','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC495','72BEB064JHM526C2BEB336872'),
	(166,'2025-07-07 00:00:00','212201029','FARAND SAVERIO KHILAL','L','6','','UMUM','C',1,'2000000','7EA80BR58G169','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC496','72BEB064JHM526C2BEB336873'),
	(165,'2025-07-06 00:00:00','232401051','ARRIZA NUR MUHAMMAD','L','3','','UMUM','B',1,'480000','7EA80BR58G165','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC499','72BEB064JHM526C2BEB336876'),
	(164,'2025-07-06 00:00:00','232401051','ARRIZA NUR MUHAMMAD','L','3','','UMUM','C',2,'4800000','7EA80BR58G166','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC498','72BEB064JHM526C2BEB336875'),
	(162,'2025-07-06 00:00:00','242501016','FATIH ILHAM AULIA','L','2','','UMUM','C',2,'1000000','7EA80BR58G164','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC500','72BEB064JHM526C2BEB336877'),
	(163,'2025-07-06 00:00:00','212201026','SRI AYU KENCANA','P','5','','UMUM','C',1,'5200000','7EA80BR58G167','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 5 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC497','72BEB064JHM526C2BEB336874'),
	(161,'2025-07-06 00:00:00','202101027','MUHAMAD HAIKAL MAULANA AKBAR','L','6','','UMUM','C',1,'3000000','7EA80BR58G163','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC501','72BEB064JHM526C2BEB336878'),
	(158,'2025-07-06 00:00:00','212201019','FAYRUZ AILA ELZAVIRA','P','5','','UMUM','C',1,'2000000','7EA80BR58G160','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 5 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC504','72BEB064JHM526C2BEB336881'),
	(159,'2025-07-06 00:00:00','232401050','ARFADHIA RAZQA ATHARUF','L','3','','UMUM','C',1,'4800000','7EA80BR58G161','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC503','72BEB064JHM526C2BEB336880'),
	(160,'2025-07-06 00:00:00','242501038','QALIFA AL QAHTHAN ROYCE','L','2','','UMUM','C',2,'1040000','7EA80BR58G162','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC502','72BEB064JHM526C2BEB336879'),
	(157,'2025-07-06 00:00:00','202101044','VANESSA ANGELINA HAUSER','P','6','','UMUM','B',1,'480000','7EA80BR58G159','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC505','72BEB064JHM526C2BEB336882'),
	(156,'2025-07-06 00:00:00','232401019','KAZUHIRO ARRAWDA ADITYA','L','3','','UMUM','B',1,'480000','7EA80BR58G158','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC506','72BEB064JHM526C2BEB336883'),
	(155,'2025-07-06 00:00:00','222301022','IZAZ ABDER RAZZA','L','4','','UMUM','C',1,'4800000','7EA80BR58G157','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC508','72BEB064JHM526C2BEB336885'),
	(154,'2025-07-06 00:00:00','202101041','RAZEEQ SACHTI ABDALLA','L','6','','UMUM','C',1,'3200000','7EA80BR58G156','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC507','72BEB064JHM526C2BEB336884'),
	(153,'2025-07-06 00:00:00','222301013','FADIAH ANINDYA MAULA','P','4','','UMUM','B',1,'240000','7EA80BR58G155','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC509','72BEB064JHM526C2BEB336886'),
	(152,'2025-07-06 00:00:00','202101016','CAMILO BHAMAKERTI MUHAMMAD','L','6','','UMUM','B',1,'480000','7EA80BR58G154','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC510','72BEB064JHM526C2BEB336887'),
	(151,'2025-07-06 00:00:00','232401003','ALEM VIRENDRA MULYAWAN','L','3','','UMUM','B',1,'480000','7EA80BR58G153','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC511','72BEB064JHM526C2BEB336888'),
	(149,'2025-07-06 00:00:00','232401036','SALVINA ALEESHA ALRADYA','P','3','','UMUM','B',1,'480000','7EA80BR58G151','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC513','72BEB064JHM526C2BEB336890'),
	(150,'2025-07-06 00:00:00','222301041','REYNAND ALTAF MULYAWAN','L','4','','UMUM','B',1,'480000','7EA80BR58G152','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC512','72BEB064JHM526C2BEB336889'),
	(146,'2025-07-05 00:00:00','202101019','HAIDAR NUR ZAHID MAHMOED ','L','6','','UMUM','C',2,'2200000','7EA80BR58G147','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC517','72BEB064JHM526C2BEB336894'),
	(147,'2025-07-05 00:00:00','222301040','RASHYA DIANDRA','L','4','','UMUM','B',1,'480000','7EA80BR58G149','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC515','72BEB064JHM526C2BEB336892'),
	(148,'2025-07-06 00:00:00','232401036','SALVINA ALEESHA ALRADYA','P','3','','UMUM','C',2,'3990000','7EA80BR58G150','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC514','72BEB064JHM526C2BEB336891'),
	(145,'2025-07-05 00:00:00','242501051','KEISYA SHANUM ALFATHUNISSA','P','2','','UMUM','C',1,'2000000','7EA80BR58G148','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC516','72BEB064JHM526C2BEB336893'),
	(144,'2025-07-05 00:00:00','202101019','HAIDAR NUR ZAHID MAHMOED ','L','6','','UMUM','C',1,'150000','7EA80BR58G146','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC518','72BEB064JHM526C2BEB336895'),
	(142,'2025-07-05 00:00:00','242503048','REYZHEL QEVELLO ANDRA','L','4','','UMUM','C',1,'500000','7EA80BR58G144','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC520','72BEB064JHM526C2BEB336897'),
	(143,'2025-07-05 00:00:00','202101019','HAIDAR NUR ZAHID MAHMOED ','L','6','','UMUM','B',1,'480000','7EA80BR58G145','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC519','72BEB064JHM526C2BEB336896'),
	(141,'2025-07-05 00:00:00','222301039','RAISHA RAMADHINI RAKHIM','P','4','','UMUM','C',1,'1000000','7EA80BR58G142','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC521','72BEB064JHM526C2BEB336898'),
	(139,'2025-07-05 00:00:00','222301039','RAISHA RAMADHINI RAKHIM','P','4','','UMUM','B',1,'240000','7EA80BR58G143','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC522','72BEB064JHM526C2BEB336899'),
	(140,'2025-07-04 00:00:00','232401030','PRAMUDYA ARDHANI HAMIZAN','L','3','','UMUM','B',1,'240000','7EA80BR58G141','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC523','72BEB064JHM526C2BEB336900'),
	(138,'2025-07-04 00:00:00','232401030','PRAMUDYA ARDHANI HAMIZAN','L','3','','UMUM','C',1,'400000','7EA80BR58G140','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC524','72BEB064JHM526C2BEB336901'),
	(137,'2025-07-04 00:00:00','202101011','ARSEN ADISA ASHSHIYAAM','L','6','','UMUM','B',1,'480000','7EA80BR58G138','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC526','72BEB064JHM526C2BEB336903'),
	(136,'2025-07-04 00:00:00','232401024','MOUNIRA SERAPHINA PUTRIWIBOWO','P','3','','UMUM','C',2,'4800000','7EA80BR58G139','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC525','72BEB064JHM526C2BEB336902'),
	(135,'2025-07-04 00:00:00','202106054','ENZO KAFFIE EL AZZAM','L','6','','UMUM','C',1,'2000000','7EA80BR58G137','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC527','72BEB064JHM526C2BEB336904'),
	(134,'2025-07-04 00:00:00','232401024','MOUNIRA SERAPHINA PUTRIWIBOWO','P','3','','UMUM','B',1,'5280000','7EA80BR58G136','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC528','72BEB064JHM526C2BEB336905'),
	(131,'2025-07-03 00:00:00','242501008','ATHAYA NABHAN ZAAHIRULHAQ','L','2','','UMUM','B',1,'480000','7EA80BR58G132','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC531','72BEB064JHM526C2BEB336908'),
	(132,'2025-07-04 00:00:00','242501037','NAURA RAMADHINA NURWAHIDIN','P','2','','UMUM','C',1,'100000','7EA80BR58G134','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC530','72BEB064JHM526C2BEB336907'),
	(133,'2025-07-04 00:00:00','242501037','NAURA RAMADHINA NURWAHIDIN','P','2','','UMUM','B',1,'240000','7EA80BR58G135','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC529','72BEB064JHM526C2BEB336906'),
	(130,'2025-07-04 00:00:00','232401006','AVRILLA PHONCHO ZAAFIRA ZULFA','P','3','','UMUM','C',1,'4800000','7EA80BR58G133','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC532','72BEB064JHM526C2BEB336909'),
	(129,'2025-07-03 00:00:00','212201006','NADHIFA KHANSA ZAHIRANI','P','5','','UMUM','B',1,'480000','7EA80BR58G131','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC533','72BEB064JHM526C2BEB336910'),
	(128,'2025-07-03 00:00:00','242501021','K HANI ALFIDEVITA','P','2','','UMUM','B',1,'480000','7EA80BR58G130','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC534','72BEB064JHM526C2BEB336911'),
	(127,'2025-07-03 00:00:00','242501013','AZFAR RAFFASYA NURDIANSYAH','L','2','','UMUM','B',1,'240000','7EA80BR58G129','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC535','72BEB064JHM526C2BEB336912'),
	(126,'2025-07-03 00:00:00','232401017','HAURA HILWA ALIFA USMAN','P','3','','UMUM','B',1,'480000','7EA80BR58G126','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC538','72BEB064JHM526C2BEB336915'),
	(125,'2025-07-03 00:00:00','232404043','SATRIA PUTRA YOZA','L','6','','UMUM','C',1,'1000000','7EA80BR58G127','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC537','72BEB064JHM526C2BEB336914'),
	(124,'2025-07-03 00:00:00','222301008','AYESHA QIANA NURDIANSYAH','P','4','','UMUM','B',1,'240000','7EA80BR58G128','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC536','72BEB064JHM526C2BEB336913'),
	(123,'2025-07-03 00:00:00','222301022','IZAZ ABDER RAZZA','L','4','','UMUM','B',1,'480000','7EA80BR58G125','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC539','72BEB064JHM526C2BEB336916'),
	(122,'2025-07-03 00:00:00','202101041','RAZEEQ SACHTI ABDALLA','L','6','','UMUM','B',1,'480000','7EA80BR58G124','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC540','72BEB064JHM526C2BEB336917'),
	(120,'2025-07-03 00:00:00','232401028','MYSHA MAHARANI GUNAWAN','P','3','','UMUM','C',1,'4800000','7EA80BR58G123','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC542','72BEB064JHM526C2BEB336919'),
	(121,'2025-07-03 00:00:00','232401028','MYSHA MAHARANI GUNAWAN','P','3','','UMUM','B',1,'480000','7EA80BR58G122','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC541','72BEB064JHM526C2BEB336918'),
	(119,'2025-07-03 00:00:00','242502050','ARZUNO MUHAMMAD RAMADHAN NOORIS','L','3','','UMUM','C',1,'1875000','7EA80BR58G121','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC543','72BEB064JHM526C2BEB336920'),
	(118,'2025-07-03 00:00:00','242505049','ALVARO MUHAMMAD OZORA NOORIS','L','6','','UMUM','C',2,'2075000','7EA80BR58G120','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC544','72BEB064JHM526C2BEB336921'),
	(117,'2025-07-03 00:00:00','242502050','ARZUNO MUHAMMAD RAMADHAN NOORIS','L','3','','UMUM','B',1,'480000','7EA80BR58G119','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC545','72BEB064JHM526C2BEB336922'),
	(116,'2025-07-03 00:00:00','242505049','ALVARO MUHAMMAD OZORA NOORIS','L','6','','UMUM','B',1,'480000','7EA80BR58G118','e3afed0047b08059d0fada10f400c1e5','','','Bank','SPP SD KELAS 2 S.D 6 TP 2025-2026 JULI','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC546','72BEB064JHM526C2BEB336923'),
	(115,'2025-07-02 00:00:00','232401026','MUHAMMAD KHALID ARRASYID','L','3','','UMUM','C',1,'2800000','7EA80BR58G117','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC547','72BEB064JHM526C2BEB336924'),
	(114,'2025-07-02 00:00:00','242501009','AUDRISSA HAURA ZIANAYA','P','2','','UMUM','C',1,'4800000','7EA80BR58G115','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC549','72BEB064JHM526C2BEB336926'),
	(113,'2025-07-02 00:00:00','222301034','MUHAMMAD KENZIO ARSYAD REVINZA','L','4','','UMUM','C',1,'4800000','7EA80BR58G116','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC548','72BEB064JHM526C2BEB336925'),
	(112,'2025-07-02 00:00:00','232401025','MUHAMMAD ARIEF HIDAYATULLOH','L','3','','UMUM','C',1,'4800000','7EA80BR58G114','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC550','72BEB064JHM526C2BEB336927'),
	(110,'2025-07-01 00:00:00','242501022','KAYRA SYIFA ZAIDA POURAN','P','2','','UMUM','C',1,'4800000','7EA80BR58G112','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC552','72BEB064JHM526C2BEB336929'),
	(111,'2025-07-02 00:00:00','222301046','ZULFA AGNA KAMILA','P','4','','UMUM','C',1,'1400000','7EA80BR58G113','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC551','72BEB064JHM526C2BEB336928'),
	(109,'2025-06-29 00:00:00','222301031','MUHAMMAD ABYAN ARKENZI AKBAR','L','4','','UMUM','C',1,'4800000','7EA80BR58G110','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC553','72BEB064JHM526C2BEB336930'),
	(108,'2025-06-30 00:00:00','242501015','CLARA AINUN NISYA','P','2','','UMUM','C',1,'3000000','7EA80BR58G111','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC554','72BEB064JHM526C2BEB336931'),
	(106,'2025-06-29 00:00:00','222303047','GADIZA AIDA LUVENA','P','6','','UMUM','C',1,'5200000','7EA80BR58G108','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC556','72BEB064JHM526C2BEB336933'),
	(107,'2025-06-29 00:00:00','202101037','RAISYA AL ZHAFIRAH','P','6','','UMUM','C',1,'2500000','7EA80BR58G109','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC555','72BEB064JHM526C2BEB336932'),
	(105,'2025-06-28 00:00:00','232401033','RANIA SARAH RACHMAN','P','3','','UMUM','C',1,'4800000','7EA80BR58G107','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC557','72BEB064JHM526C2BEB336934'),
	(104,'2025-06-28 00:00:00','242501021','K HANI ALFIDEVITA','P','2','','UMUM','C',1,'4800000','7EA80BR58G106','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC558','72BEB064JHM526C2BEB336935'),
	(103,'2025-06-27 00:00:00','232401017','HAURA HILWA ALIFA USMAN','P','3','','UMUM','C',2,'3300000','7EA80BR58G103','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC561','72BEB064JHM526C2BEB336938'),
	(102,'2025-06-27 00:00:00','202101036','RAISHA GHASSANI XAVIERA SIDDIQ','P','6','','UMUM','C',2,'2933000','7EA80BR58G104','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC560','72BEB064JHM526C2BEB336937'),
	(101,'2025-06-28 00:00:00','212201024','MOCHAMAD IQBAL MAULANA','L','5','','UMUM','C',1,'5200000','7EA80BR58G105','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 5 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC559','72BEB064JHM526C2BEB336936'),
	(99,'2025-06-26 00:00:00','212201006','NADHIFA KHANSA ZAHIRANI','P','5','','UMUM','C',1,'5200000','7EA80BR58G101','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 5 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC563','72BEB064JHM526C2BEB336940'),
	(100,'2025-06-26 00:00:00','242502053','SHAFIYA ARKADEWI BERLIAN','P','3','','UMUM','C',1,'4800000','7EA80BR58G102','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC562','72BEB064JHM526C2BEB336939'),
	(98,'2025-06-26 00:00:00','242501008','ATHAYA NABHAN ZAAHIRULHAQ','L','2','','UMUM','C',1,'4800000','7EA80BR58G100','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC564','72BEB064JHM526C2BEB336941'),
	(97,'2025-06-26 00:00:00','242501038','QALIFA AL QAHTHAN ROYCE','L','2','','UMUM','C',1,'960000','7EA80BR58G97','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC565','72BEB064JHM526C2BEB336942'),
	(95,'2025-06-26 00:00:00','242501001','ABIZARD ARSHAD NUGRAHA','L','2','','UMUM','C',1,'2000000','7EA80BR58G96','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC567','72BEB064JHM526C2BEB336944'),
	(96,'2025-06-26 00:00:00','242501020','JASMINE ASH-SHANUM TAZKIYA HAN','P','2','1','UMUM','C',1,'720000','7EA80BR58G99','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC566','72BEB064JHM526C2BEB336943'),
	(94,'2025-06-26 00:00:00','232401007','CEILO MALIK ALTAIR','L','3','1','UMUM','C',1,'517000','7EA80BR58G95','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC568','72BEB064JHM526C2BEB336945'),
	(93,'2025-06-26 00:00:00','232401019','KAZUHIRO ARRAWDA ADITYA','L','3','','UMUM','C',1,'1800000','7EA80BR58G94','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC569','72BEB064JHM526C2BEB336946'),
	(92,'2025-06-26 00:00:00','232401020','KEANU ALFARIEL','L','3','','UMUM','C',1,'1610000','7EA80BR58G93','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC570','72BEB064JHM526C2BEB336947'),
	(91,'2025-06-26 00:00:00','232401021','KEINAN ARAZKA PRADIPTA','L','3','','UMUM','C',1,'1780000','7EA80BR58G92','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC571','72BEB064JHM526C2BEB336948'),
	(90,'2025-06-26 00:00:00','232401001','ABIDZAR AL GHIFARY NUGRAHA','L','3','','UMUM','C',2,'3850000','7EA80BR58G90','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC573','72BEB064JHM526C2BEB336950'),
	(89,'2025-06-26 00:00:00','232401022','MILESHA SHIDQIN ALIYA FIRDAUS','P','3','','UMUM','C',1,'1805000','7EA80BR58G91','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC572','72BEB064JHM526C2BEB336949'),
	(88,'2025-06-26 00:00:00','232401003','ALEM VIRENDRA MULYAWAN','L','3','','UMUM','C',1,'4800000','7EA80BR58G89','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC574','72BEB064JHM526C2BEB336951'),
	(87,'2025-06-26 00:00:00','232401004','ALWI AMMAR AL GHAZALI','L','3','','UMUM','C',1,'395000','7EA80BR58G88','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC575','72BEB064JHM526C2BEB336952'),
	(85,'2025-06-26 00:00:00','232401015','HAIFA AYU KIRANA','P','3','','UMUM','C',1,'2400000','7EA80BR58G86','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC577','72BEB064JHM526C2BEB336954'),
	(86,'2025-06-26 00:00:00','232401014','HAFIZ ALFARIZI','L','3','','UMUM','C',1,'1485000','7EA80BR58G87','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC576','72BEB064JHM526C2BEB336953'),
	(84,'2025-06-26 00:00:00','232401016','HARITH ADSKHAN','L','3','','UMUM','C',1,'4800000','7EA80BR58G85','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC578','72BEB064JHM526C2BEB336955'),
	(83,'2025-06-26 00:00:00','232401017','HAURA HILWA ALIFA USMAN','P','3','','UMUM','C',1,'1500000','7EA80BR58G84','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC579','72BEB064JHM526C2BEB336956'),
	(82,'2025-06-26 00:00:00','232401036','SALVINA ALEESHA ALRADYA','P','3','','UMUM','C',1,'810000','7EA80BR58G83','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC580','72BEB064JHM526C2BEB336957'),
	(81,'2025-06-26 00:00:00','232401001','ABIDZAR AL GHIFARY NUGRAHA','L','3','','UMUM','C',1,'950000','7EA80BR58G82','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC581','72BEB064JHM526C2BEB336958'),
	(80,'2025-06-26 00:00:00','222301026','KENZIE NAUFAL SRI LUGINA','L','4','','UMUM','C',1,'800000','7EA80BR58G81','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC582','72BEB064JHM526C2BEB336959'),
	(79,'2025-06-26 00:00:00','222301030','M. SYAHRIL AS SEKAR','L','4','','UMUM','C',1,'4800000','7EA80BR58G80','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC583','72BEB064JHM526C2BEB336960'),
	(77,'2025-06-26 00:00:00','222301045','ZEFA FARZANI','L','4','','UMUM','C',1,'1350000','7EA80BR58G78','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC585','72BEB064JHM526C2BEB336962'),
	(78,'2025-06-26 00:00:00','222301016','FARIZ NAUFAL RABBANI T','L','4','','UMUM','C',1,'4235000','7EA80BR58G77','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC586','72BEB064JHM526C2BEB336963'),
	(76,'2025-06-26 00:00:00','222301041','REYNAND ALTAF MULYAWAN','L','4','','UMUM','C',1,'4800000','7EA80BR58G79','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 4 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC584','72BEB064JHM526C2BEB336961'),
	(75,'2025-06-26 00:00:00','212201002','AHZA FAWWAZ RAMADHAN','L','5','','UMUM','C',1,'2400000','7EA80BR58G76','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 5 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC587','72BEB064JHM526C2BEB336964'),
	(73,'2025-06-26 00:00:00','212201007','ATHALLA REINDRA RAMADHAN','L','5','1','UMUM','C',1,'4000000','7EA80BR58G74','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 5 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC589','72BEB064JHM526C2BEB336966'),
	(74,'2025-06-26 00:00:00','212201011','NAUFAL ALGHAZALI RAMADAN','L','5','','UMUM','C',1,'5200000','7EA80BR58G75','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 5 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC588','72BEB064JHM526C2BEB336965'),
	(72,'2025-06-26 00:00:00','202101036','RAISHA GHASSANI XAVIERA SIDDIQ','P','6','','UMUM','C',1,'2267000','7EA80BR58G73','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC590','72BEB064JHM526C2BEB336967'),
	(71,'2025-06-26 00:00:00','202101042','SYAKILLA AZ DZAKIYAH JELITA HAN','P','6','','UMUM','C',1,'350000','7EA80BR58G72','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC591','72BEB064JHM526C2BEB336968'),
	(70,'2025-06-26 00:00:00','232401018','I GUSTI  AGUNG ATHAYA KHALIANDRA NADDEAN','L','3','','UMUM','C',1,'3800000','7EA80BR58G71','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 3 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC592','72BEB064JHM526C2BEB336969'),
	(68,'2025-04-28 00:00:00','252601030','FACHRY GHIFARI SUBHAN','L','5','1','UMUM','C',1,'5000000','7EA80BR58G49','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC594','72BEB064JHM526C2BEB336971'),
	(69,'2025-06-25 00:00:00','202101016','CAMILO BHAMAKERTI MUHAMMAD','P','6','','UMUM','C',1,'5200000','7EA80BR58G70','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 6 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC593','72BEB064JHM526C2BEB336970'),
	(67,'2025-04-30 00:00:00','252601004','ATTILA NARA PRADITYA','L','1','1','UMUM','C',2,'1500000','7EA80BR58G50','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC596','72BEB064JHM526C2BEB336973'),
	(65,'2025-04-30 00:00:00','252601006','AZ-ZAHRAH CARISSA PUTRI FAUZI','P','1','1','UMUM','C',2,'9000000','7EA80BR58G51','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC597','72BEB064JHM526C2BEB336974'),
	(66,'2025-06-26 00:00:00','242501016','FATIH ILHAM AULIA','L','2','','UMUM','C',1,'1810000','7EA80BR58G98','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 2 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC595','72BEB064JHM526C2BEB336972'),
	(64,'2025-04-17 00:00:00','242502054','ARZACHEL JUNIAR RAMADHAN','P','2','1','UMUM','C',1,'4125000','7EA80BR58G47','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC599','72BEB064JHM526C2BEB336976'),
	(61,'2025-04-11 00:00:00','252601026','GHIYATS EL ARGA ABDULLAH','L','2','1','UMUM','C',3,'3500000','7EA80BR58G44','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC601','72BEB064JHM526C2BEB336978'),
	(62,'2025-04-14 00:00:00','252601019','RAZKA ADITYA','L','1','1','UMUM','C',1,'10500000','7EA80BR58G45','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC600','72BEB064JHM526C2BEB336977'),
	(63,'2025-04-22 00:00:00','252601022','ZAKI MAULUDIN AZKIA','L','1','1','UMUM','C',3,'2500000','7EA80BR58G48','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC598','72BEB064JHM526C2BEB336975'),
	(59,'2025-04-10 00:00:00','252601003','ALKHAFA SAUQI BATUBARA','L','1','1','UMUM','C',3,'2000000','7EA80BR58G42','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC602','72BEB064JHM526C2BEB336979'),
	(60,'2025-04-11 00:00:00','252601025','GHAITS EL ATHAR ABDULLAH','L','4','1','UMUM','C',3,'3500000','7EA80BR58G43','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC603','72BEB064JHM526C2BEB336980'),
	(58,'2025-04-09 00:00:00','252601014','NADIA TRIAULIA RAMDANI','P','1','1','UMUM','C',3,'3000000','7EA80BR58G41','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC604','72BEB064JHM526C2BEB336981'),
	(57,'2025-04-08 00:00:00','252601028','SASCHYA AFIZA TUNGGADEWI DERLIANPUTRI','P','1','1','UMUM','C',1,'250000','7EA80BR58G39','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC606','72BEB064JHM526C2BEB336983'),
	(56,'2025-04-08 00:00:00','252601018','RAUFA SHAKEIL LESMANA','L','1','1','UMUM','C',2,'5000000','7EA80BR58G40','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC605','72BEB064JHM526C2BEB336982'),
	(55,'2025-03-01 00:00:00','252601004','ATTILA NARA PRADITYA','L','1','1','UMUM','C',1,'2500000','7EA80BR58G37','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC608','72BEB064JHM526C2BEB336985'),
	(54,'2025-04-08 00:00:00','252601027','RAFIF DIRGA ANTASENA DERLIANPUTRA','L','4','1','UMUM','C',1,'250000','7EA80BR58G38','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC607','72BEB064JHM526C2BEB336984'),
	(52,'2025-02-20 00:00:00','252601014','NADIA TRIAULIA RAMDANI','P','1','1','UMUM','C',2,'250000','7EA80BR58G33','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC610','72BEB064JHM526C2BEB336987'),
	(53,'2025-02-27 00:00:00','252601001','ABYAN REYNAND DILLAH','L','1','1','UMUM','C',1,'3000000','7EA80BR58G36','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC609','72BEB064JHM526C2BEB336986'),
	(51,'2025-02-25 00:00:00','252601003','ALKHAFA SAUQI BATUBARA','L','1','1','UMUM','C',2,'2000000','7EA80BR58G35','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC611','72BEB064JHM526C2BEB336988'),
	(50,'2025-02-25 00:00:00','252601003','ALKHAFA SAUQI BATUBARA','L','1','1','UMUM','C',1,'250000','7EA80BR58G34','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC612','72BEB064JHM526C2BEB336989'),
	(49,'2025-02-18 00:00:00','252601016','RANGGA RAISUL AGUSTIN','L','1','1','UMUM','C',2,'6000000','7EA80BR58G31','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC613','72BEB064JHM526C2BEB336990'),
	(47,'2025-02-14 00:00:00','252601006','AZ-ZAHRAH CARISSA PUTRI FAUZI','P','1','1','UMUM','C',1,'1000000','7EA80BR58G30','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC615','72BEB064JHM526C2BEB336992'),
	(48,'2025-02-04 00:00:00','252601022','ZAKI MAULUDIN AZKIA','L','1','1','UMUM','C',2,'4000000','7EA80BR58G29','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC616','72BEB064JHM526C2BEB336993'),
	(46,'2025-02-19 00:00:00','252601014','NADIA TRIAULIA RAMDANI','P','1','1','UMUM','C',1,'2000000','7EA80BR58G32','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC614','72BEB064JHM526C2BEB336991'),
	(45,'2025-02-04 00:00:00','252601016','RANGGA RAISUL AGUSTIN','L','1','1','UMUM','C',1,'250000','7EA80BR58G28','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC618','72BEB064JHM526C2BEB336995'),
	(44,'2025-01-16 00:00:00','252601005','AURENZA AZHAR','P','1','1','UMUM','C',2,'11250000','7EA80BR58G27','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC617','72BEB064JHM526C2BEB336994'),
	(42,'2025-01-15 00:00:00','252601005','AURENZA AZHAR','P','1','1','UMUM','C',1,'250000','7EA80BR58G26','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC619','72BEB064JHM526C2BEB336996'),
	(43,'2025-01-06 00:00:00','252601019','RAZKA ADITYA','L','1','1','UMUM','E',1,'250000','7EA80BR58G25','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC620','72BEB064JHM526C2BEB336997'),
	(41,'2025-01-03 00:00:00','252601022','ZAKI MAULUDIN AZKIA','L','1','1','UMUM','C',1,'250000','7EA80BR58G24','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC621','72BEB064JHM526C2BEB336998'),
	(40,'2024-12-31 00:00:00','252601008','FELISHA BIKRUM SAKHI','P','1','1','UMUM','C',1,'250000','7EA80BR58G21','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC623','72BEB064JHM526C2BEB337000'),
	(39,'2024-12-31 00:00:00','252601023','ELZIRA NURIEL ANINDITA','P','1','1','UMUM','C',1,'250000','7EA80BR58G22','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC622','72BEB064JHM526C2BEB336999'),
	(38,'2024-12-17 00:00:00','252601025','GHAITS EL ATHAR ABDULLAH','L','4','1','UMUM','C',2,'1000000','7EA80BR58G17','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC625','72BEB064JHM526C2BEB337002'),
	(36,'2024-12-17 00:00:00','252601026','GHIYATS EL ARGA ABDULLAH','L','2','1','UMUM','C',1,'250000','7EA80BR58G16','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC627','72BEB064JHM526C2BEB337004'),
	(37,'2024-12-27 00:00:00','252601011','KHALISA SHAKIRA AKBAR','P','1','1','UMUM','C',1,'250000','7EA80BR58G20','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC624','72BEB064JHM526C2BEB337001'),
	(35,'2025-05-02 00:00:00','252601021','TAMHIDAN ADINATA','L','1','1','UMUM','C',1,'2000000','7EA80BR58G52','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC629','72BEB064JHM526C2BEB337006'),
	(34,'2024-12-17 00:00:00','252601025','GHAITS EL ATHAR ABDULLAH','L','4','1','UMUM','C',1,'250000','7EA80BR58G15','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC628','72BEB064JHM526C2BEB337005'),
	(33,'2024-12-17 00:00:00','252601026','GHIYATS EL ARGA ABDULLAH','L','2','1','UMUM','C',2,'1000000','7EA80BR58G18','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC626','72BEB064JHM526C2BEB337003'),
	(32,'2025-05-08 00:00:00','252601003','ALKHAFA SAUQI BATUBARA','L','1','1','UMUM','C',4,'2000000','7EA80BR58G54','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC632','72BEB064JHM526C2BEB337009'),
	(31,'2025-05-06 00:00:00','252601012','MUHAMMAD FADLAN AZZUHRI','L','1','1','UMUM','C',1,'3000000','7EA80BR58G53','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC631','72BEB064JHM526C2BEB337008'),
	(30,'2024-10-08 00:00:00','252601018','RAUFA SHAKEIL LESMANA','L','1','1','UMUM','C',1,'250000','7EA80BR58G14','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC630','72BEB064JHM526C2BEB337007'),
	(28,'2025-05-09 00:00:00','252601026','GHIYATS EL ARGA ABDULLAH','L','2','1','UMUM','C',4,'3500000','7EA80BR58G57','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC635','72BEB064JHM526C2BEB337012'),
	(29,'2025-05-09 00:00:00','252601032','ZAVIER AL GIBRAN','L','3','1','UMUM','C',1,'3750000','7EA80BR58G55','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC633','72BEB064JHM526C2BEB337010'),
	(27,'2025-05-09 00:00:00','252601025','GHAITS EL ATHAR ABDULLAH','L','4','1','UMUM','C',4,'3500000','7EA80BR58G56','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC634','72BEB064JHM526C2BEB337011'),
	(26,'2025-05-23 00:00:00','252601031','ALYSYA FAZRIAH','P','1','1','UMUM','C',1,'250000','7EA80BR58G60','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC637','72BEB064JHM526C2BEB337014'),
	(25,'2025-05-12 00:00:00','252601007','ERSTA ATHARAZKA WIBOWO','L','1','1','UMUM','C',1,'1000000','7EA80BR58G58','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC636','72BEB064JHM526C2BEB337013'),
	(24,'2025-05-20 00:00:00','252601014','NADIA TRIAULIA RAMDANI','P','1','1','UMUM','C',4,'5000000','7EA80BR58G59','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC638','72BEB064JHM526C2BEB337015'),
	(23,'2025-05-29 00:00:00','252601033','RADITYA ARSHA PRATAMA','L','1','1','UMUM','C',1,'5000000','7EA80BR58G62','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC640','72BEB064JHM526C2BEB337017'),
	(22,'2025-05-28 00:00:00','252601009','IBNU SAKTIAWAN SIHOTANG','L','1','1','UMUM','C',1,'5000000','7EA80BR58G61','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC639','72BEB064JHM526C2BEB337016'),
	(20,'2025-06-09 00:00:00','252601026','GHIYATS EL ARGA ABDULLAH','L','2','1','UMUM','C',5,'2500000','7EA80BR58G65','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC643','72BEB064JHM526C2BEB337020'),
	(21,'2025-06-02 00:00:00','252601003','ALKHAFA SAUQI BATUBARA','L','1','1','UMUM','C',5,'2000000','7EA80BR58G63','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC641','72BEB064JHM526C2BEB337018'),
	(19,'2025-06-09 00:00:00','252601025','GHAITS EL ATHAR ABDULLAH','L','4','1','UMUM','C',5,'3000000','7EA80BR58G64','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC642','72BEB064JHM526C2BEB337019'),
	(18,'2025-06-25 00:00:00','232403041','SEBASTIAN SCHUMACER','L','5','1','UMUM','C',1,'5200000','7EA80BR58G69','e3afed0047b08059d0fada10f400c1e5','','','Bank','BIAYA PENDIDIKAN KELAS 5 TP 2025-2026 SD PANATAGAMA','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC645','72BEB064JHM526C2BEB337022'),
	(17,'2025-06-11 00:00:00','252601012','MUHAMMAD FADLAN AZZUHRI','L','1','1','UMUM','C',2,'7000000','7EA80BR58G66','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC644','72BEB064JHM526C2BEB337021'),
	(16,'2025-06-15 00:00:00','252601004','ATTILA NARA PRADITYA','L','1','1','UMUM','C',3,'2000000','7EA80BR58G68','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC646','72BEB064JHM526C2BEB337023'),
	(15,'2025-07-14 00:00:00','212201004','MUHAMMAD AL FAHRI VALESKA','L','5','1','UMUM','B',1,'480000','9A987P1EVY7E','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC648','72BEB064JHM526C2BEB337025'),
	(14,'2025-06-11 00:00:00','252601031','ALYSYA FAZRIAH','P','1','1','UMUM','C',2,'10250000','7EA80BR58G67','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36','JDSFDJFHJDGVBVC647','72BEB064JHM526C2BEB337024'),
	(13,'2025-07-14 00:00:00','202101014','AZZAHRA DIANDRA NUGROHO','P','6','1','UMUM','B',1,'480000','864FAZ9IOK96','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC651','72BEB064JHM526C2BEB337028'),
	(12,'2025-07-14 00:00:00','212201023','GUNTUR JUNA WIJAYA','L','5','1','UMUM','C',1,'2000000','0DF74Z8E5510','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC650','72BEB064JHM526C2BEB337027'),
	(11,'2025-07-14 00:00:00','212201004','MUHAMMAD AL FAHRI VALESKA','L','5','1','UMUM','C',1,'1520000','32CE1I2CVH0B','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC649','72BEB064JHM526C2BEB337026'),
	(10,'2025-07-14 00:00:00','222301038','RAFFA ADINAKA AR RAHMAT','L','4','1','UMUM','C',1,'2500000','D25A3JV8EB76','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC652','72BEB064JHM526C2BEB337029'),
	(9,'2025-07-15 00:00:00','222301016','FARIZ NAUFAL RABBANI T','L','4','2','UMUM','B',1,'480000','0CA3DO2IYT42','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC653','72BEB064JHM526C2BEB337030'),
	(8,'2025-07-15 00:00:00','242501040','RAJENDRA DEVIAN ALFAREZ','L','2','1','UMUM','C',1,'4800000','537D8BHM1UA2','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC657','72BEB064JHM526C2BEB337034'),
	(7,'2025-07-15 00:00:00','242501040','RAJENDRA DEVIAN ALFAREZ','L','2','1','UMUM','B',1,'480000','537D82X8YCBB','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC656','72BEB064JHM526C2BEB337033'),
	(6,'2025-07-15 00:00:00','242501004','ARSHAD FIKAR ABQARY ANDRYAN','L','2','1','UMUM','C',1,'4100000','BF60DGGQ2829','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC655','72BEB064JHM526C2BEB337032'),
	(4,'2025-07-15 00:00:00','202101042','SYAKILLA AZ DZAKIYAH JELITA HAN','P','6','2','UMUM','C',3,'750000','3AFA9BHRO9C8','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC658','72BEB064JHM526C2BEB337035'),
	(5,'2025-07-15 00:00:00','242501004','ARSHAD FIKAR ABQARY ANDRYAN','L','2','1','UMUM','B',1,'480000','BF60DWJSS15A','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC654','72BEB064JHM526C2BEB337031'),
	(3,'2025-07-15 00:00:00','232401008','DZAKY HADIWIJAYA','L','3','2','UMUM','C',1,'2000000','0465CSWLXV8C','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC660','72BEB064JHM526C2BEB337037'),
	(2,'2025-07-15 00:00:00','212201007','ATHALLA REINDRA RAMADHAN','L','5','1','UMUM','B',1,'480000','60F9EGEBPW90','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC659','72BEB064JHM526C2BEB337036'),
	(1,'2025-07-15 00:00:00','212201013','NAYLA ANDINI NURFADHILLAH','P','5','1','UMUM','B',1,'240000','570FA7BGM344','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC661','72BEB064JHM526C2BEB337038'),
	(320,'2025-07-16 00:00:00','202101003','AHMAD HABIBI ASYIFA','L','6','1','UMUM','B',1,'96000','1744DH22TZB0','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC667','72BEB064JHM526C2BEB337044'),
	(321,'2025-07-16 00:00:00','222301017','GWEN AIMEE SYAREFIA PUTRI','P','4','2','UMUM','B',1,'480000','BE8EDTZ1VQAF','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC668','72BEB064JHM526C2BEB337045'),
	(322,'2025-07-16 00:00:00','222301017','GWEN AIMEE SYAREFIA PUTRI','P','4','2','UMUM','C',1,'2000000','BE8ED6N0CDD2','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC669','72BEB064JHM526C2BEB337046'),
	(323,'2025-07-16 00:00:00','232401004','ALWI AMMAR AL GHAZALI','L','3','2','UMUM','C',3,'2050000','500994N7KO95','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC670','72BEB064JHM526C2BEB337047'),
	(324,'2025-07-16 00:00:00','222301026','KENZIE NAUFAL SRI LUGINA','L','4','1','UMUM','B',1,'480000','674B9YQ5FP79','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC671','72BEB064JHM526C2BEB337048'),
	(325,'2025-07-16 00:00:00','222301026','KENZIE NAUFAL SRI LUGINA','L','4','1','UMUM','C',2,'4000000','674B9JV87FC7','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC672','72BEB064JHM526C2BEB337049'),
	(326,'2025-07-17 00:00:00','232401021','KEINAN ARAZKA PRADIPTA','L','3','1','UMUM','B',1,'480000','400D65M5L198','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC673','72BEB064JHM526C2BEB337050'),
	(327,'2025-07-17 00:00:00','202101002','ADZKIA KIMBERLY BALQIS A','P','6','2','UMUM','B',1,'480000','1A997S4IWBB0','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC674','72BEB064JHM526C2BEB337051'),
	(328,'2025-07-17 00:00:00','202101002','ADZKIA KIMBERLY BALQIS A','P','6','2','UMUM','C',1,'2500000','1A9979LBW14E','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC675','72BEB064JHM526C2BEB337052'),
	(329,'2025-07-17 00:00:00','212201020','GAVIN ARVANDHIA WIJAYA','L','5','1','UMUM','B',1,'480000','373C8VT6CH91','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC676','72BEB064JHM526C2BEB337053'),
	(330,'2025-07-17 00:00:00','242501041','SANDRIA HAVIKA NAURA','P','2','1','UMUM','B',1,'480000','F1A47LAYBU98','e3afed0047b08059d0fada10f400c1e5','','','Bank','','0000-00-00 00:00:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','JDSFDJFHJDGVBVC677','72BEB064JHM526C2BEB337054'),
	(331,'2025-07-17 00:00:00','242501024','KEANE MAULANA PUTRA','L','2','2','UMUM','B',1,'480000','EED5A8ZZ9J2F','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-18 06:28:36','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','07695CF39E0CFE','E160A142KE0S7IQ35749'),
	(332,'2025-07-17 00:00:00','242501024','KEANE MAULANA PUTRA','L','2','2','UMUM','C',1,'4800000','D1783C19Y74E','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-20 18:48:03','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','E20EF8F39E5858','C600B33BPDZLYP5B757A'),
	(333,'2025-07-18 00:00:00','212201012','DAIKI ARSYAD KHAIRULLAH','L','5','1','UMUM','C',1,'1000000','F917A3QBIYA4','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-20 18:51:14','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','85FD94934CCEE4','BA5AA3486S733N788EF7'),
	(334,'2025-07-18 00:00:00','222301021','IBRAHIM JAFAR SIDDIQ','L','4','2','UMUM','C',2,'2800000','5646C1S5LL72','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-20 18:52:48','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7A44D9A155E85F','57545553GTUVD3B08168'),
	(335,'2025-07-18 00:00:00','232401020','KEANU ALFARIEL ','L','3','1','UMUM','B',1,'480000','545148JVXSE7','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-20 18:54:11','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C6280968620884','3DDF35F2WG1IO5F5DFA2'),
	(336,'2025-07-18 00:00:00','232401020','KEANU ALFARIEL ','L','3','1','UMUM','C',2,'1000000','54514F9FIRA8','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-20 18:54:11','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C6280968620884','CF7E02D3EVLNST83B82A'),
	(337,'2025-07-18 00:00:00','242501043','SYAFIYAH BURAIRAH ALVANI','P','2','1','UMUM','B',1,'480000','22432I5TUDD6','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-20 18:55:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','300C2BB158BA3E','001E3130AX3DH091DA56'),
	(338,'2025-07-18 00:00:00','242501043','SYAFIYAH BURAIRAH ALVANI','P','2','1','UMUM','C',1,'2000000','898F4IVTOV48','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-20 18:55:55','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','300C2BB158BA3E','36E894BCJ2GKJK1EB228'),
	(339,'2025-07-18 00:00:00','242501028','MUHAMAD FATAHILLAH AKBAR AL FATIH','L','2','2','UMUM','C',2,'1200000','07CDABXGCU42','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-20 19:33:22','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','27AB7DB02966F4','FFC3F230NAWAEEYE2DCC'),
	(340,'2025-07-18 00:00:00','242501042','SYAFIQAH BURAIRAH ALVANI','P','2','1','UMUM','B',1,'480000','4A2E8N89B9D0','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-20 19:35:20','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4BBA0ABF4A42C0','F0E33C1CN2G8GAS9A769'),
	(341,'2025-07-18 00:00:00','242501042','SYAFIQAH BURAIRAH ALVANI','P','2','1','UMUM','C',1,'2000000','4A2E89VVJ902','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-20 19:35:20','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4BBA0ABF4A42C0','1D502C0F4CP66KF8D906'),
	(342,'2025-07-19 00:00:00','222301002','ALDEBARAN HAIDAR','L','4','1','UMUM','B',1,'480000','D40C8NYTPD09','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-20 19:37:26','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','561465A4F07DCF','67176CF3VRE8YYKCBFFF'),
	(343,'2025-07-19 00:00:00','202101013','AZ - ZAHRA ASSYABIYA NAURA ','P','6','1','UMUM','C',1,'3000000','3B582V6JZJBA','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-20 19:39:37','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','41D8D4AEFD8AB0','7F5F5BF0XCNI0X24BA5E'),
	(344,'2025-07-19 00:00:00','242501003','ADHYASTA RAQILA SEPUTRA','L','2','2','UMUM','B',1,'480000','DEABBCCM3N3D','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-20 19:41:15','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','1F22BEF76E4B07','F69D24E1E5NDLHC50436'),
	(345,'2025-07-19 00:00:00','242501003','ADHYASTA RAQILA SEPUTRA','L','2','2','UMUM','C',1,'2000000','DEABB46SD30E','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-20 19:41:15','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','1F22BEF76E4B07','08C7A69FGZICATH26D5D'),
	(347,'2025-07-20 00:00:00','202101013','AZ - ZAHRA ASSYABIYA NAURA ','P','6','1','UMUM','B',1,'480000','AE66826EKV25','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-20 20:11:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','BE721CAEFDBFC0','702FCE8AVPIR79256930'),
	(348,'2025-07-20 00:00:00','232401007','CEILO MALIK ALTAIR ','L','3','1','UMUM','C',2,'1000000','D4638DRCBK3B','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-21 09:14:20','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','434F8D5FBD4B3F','E4BB01FD9YJ68L6126CE'),
	(349,'2025-07-21 00:00:00','202101037','RAISYA AL ZHAFIRAH','P','6','2','UMUM','B',1,'480000','DE862PN377BA','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-21 09:14:58','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C67924839F9F23','D21AF06BY152S0E4C54D'),
	(350,'2025-07-21 00:00:00','242503048','REYZHEL QEVELLO ANDRA','L','4','1','UMUM','B',1,'480000','361CF9NGAU4A','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-21 09:16:09','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8A44828E60131F','C10DD478U71EBY219DD3'),
	(351,'2025-07-21 00:00:00','222301025','KENZIE AZKA WIJAYA','L','4','1','UMUM','C',1,'2000000','76D621VL9NC7','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-21 09:17:48','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','37F8A255AAE2DA','4D4AB8322L7TZQIF969F'),
	(352,'2025-07-21 00:00:00','242501009','AUDRISSA HAURA ZIANAYA','P','2','2','UMUM','B',1,'480000','E7159PLXET8F','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-21 13:51:37','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','39B0DEE0260AFE','1CB65F5BG7CUAYL25F30'),
	(353,'2025-07-21 00:00:00','242501009','AUDRISSA HAURA ZIANAYA','P','2','2','UMUM','B',2,'480000','E7159NUCAY02','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-21 13:51:37','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','39B0DEE0260AFE','089DC5DETVNZ767C3F8C'),
	(354,'2025-07-21 00:00:00','242501009','AUDRISSA HAURA ZIANAYA','P','2','2','UMUM','B',3,'480000','E7159VR1HU20','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-21 13:51:37','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','39B0DEE0260AFE','C58681CD1DVQGSHC8273'),
	(355,'2025-07-21 00:00:00','242501009','AUDRISSA HAURA ZIANAYA','P','2','2','UMUM','B',4,'480000','ACF0F3TZ4E48','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-21 13:51:38','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','39B0DEE0260AFE','B5DD21CEF1D1I4R8EAAF'),
	(356,'2025-07-21 00:00:00','242501009','AUDRISSA HAURA ZIANAYA','P','2','2','UMUM','B',5,'480000','ACF0FCAAWH0F','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-21 13:51:38','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','39B0DEE0260AFE','900AAB58QX3K6ISB3AC4'),
	(357,'2025-07-21 00:00:00','242501009','AUDRISSA HAURA ZIANAYA','P','2','2','UMUM','B',6,'480000','ACF0FT2OD2A7','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-21 13:51:38','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','39B0DEE0260AFE','5873312CZ1SRH5UF8891'),
	(358,'2025-07-21 00:00:00','242501009','AUDRISSA HAURA ZIANAYA','P','2','2','UMUM','B',7,'480000','ACF0F4LORVA7','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-21 13:51:38','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','39B0DEE0260AFE','C5708A8ACECH68VBB9DB'),
	(359,'2025-07-21 00:00:00','242501009','AUDRISSA HAURA ZIANAYA','P','2','2','UMUM','B',8,'480000','ACF0FVIMO639','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-21 13:51:38','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','39B0DEE0260AFE','744B0434A2L6C7XA4F19'),
	(360,'2025-07-21 00:00:00','242501009','AUDRISSA HAURA ZIANAYA','P','2','2','UMUM','B',9,'480000','ACF0FTFKU8E8','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-21 13:51:38','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','39B0DEE0260AFE','663785CBE7MR1IW5C611'),
	(361,'2025-07-21 00:00:00','242501009','AUDRISSA HAURA ZIANAYA','P','2','2','UMUM','B',10,'480000','53F57MTI1B39','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-21 13:51:39','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','39B0DEE0260AFE','B0BD0DDA7H23T5XEF43C'),
	(362,'2025-07-21 00:00:00','242501009','AUDRISSA HAURA ZIANAYA','P','2','2','UMUM','B',11,'480000','53F57UYXUZBE','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-21 13:51:39','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','39B0DEE0260AFE','6B71002D8EKAG1UD8BA1'),
	(363,'2025-07-21 00:00:00','222301034','MUHAMMAD KENZIO ARSYAD REVINZA','L','4','2','UMUM','B',1,'480000','DB66D8GCAND6','e3afed0047b08059d0fada10f400c1e5','','','Bank','dapat Disc 1 bulan','2025-07-21 13:54:52','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F65B6141AD912F','80258340DQFAT4TEB237'),
	(364,'2025-07-21 00:00:00','222301034','MUHAMMAD KENZIO ARSYAD REVINZA','L','4','2','UMUM','B',2,'480000','DB66D4RJXC02','e3afed0047b08059d0fada10f400c1e5','','','Bank','dapat Disc 1 bulan','2025-07-21 13:54:52','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F65B6141AD912F','404B5A3FNRPDR29751EC'),
	(365,'2025-07-21 00:00:00','222301034','MUHAMMAD KENZIO ARSYAD REVINZA','L','4','2','UMUM','B',3,'480000','03A75LF85RA7','e3afed0047b08059d0fada10f400c1e5','','','Bank','dapat Disc 1 bulan','2025-07-21 13:54:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F65B6141AD912F','97D009341P4CC2T70623'),
	(366,'2025-07-21 00:00:00','222301034','MUHAMMAD KENZIO ARSYAD REVINZA','L','4','2','UMUM','B',4,'480000','03A75PHHDGB0','e3afed0047b08059d0fada10f400c1e5','','','Bank','dapat Disc 1 bulan','2025-07-21 13:54:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F65B6141AD912F','3683EF97IWOEXGR1DCDF'),
	(367,'2025-07-21 00:00:00','222301034','MUHAMMAD KENZIO ARSYAD REVINZA','L','4','2','UMUM','B',5,'480000','03A753112F68','e3afed0047b08059d0fada10f400c1e5','','','Bank','dapat Disc 1 bulan','2025-07-21 13:54:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F65B6141AD912F','32B84482HS3RRBK8007E'),
	(368,'2025-07-21 00:00:00','222301034','MUHAMMAD KENZIO ARSYAD REVINZA','L','4','2','UMUM','B',6,'480000','03A75XLAJKBF','e3afed0047b08059d0fada10f400c1e5','','','Bank','dapat Disc 1 bulan','2025-07-21 13:54:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F65B6141AD912F','3F0B0F40V6YX3Z61BBBF'),
	(369,'2025-07-21 00:00:00','222301034','MUHAMMAD KENZIO ARSYAD REVINZA','L','4','2','UMUM','B',7,'480000','9EAFB81LKS01','e3afed0047b08059d0fada10f400c1e5','','','Bank','dapat Disc 1 bulan','2025-07-21 13:54:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F65B6141AD912F','ADBC08E3GWF2TEQF6BAC'),
	(370,'2025-07-21 00:00:00','222301034','MUHAMMAD KENZIO ARSYAD REVINZA','L','4','2','UMUM','B',8,'480000','9EAFB5U0QB82','e3afed0047b08059d0fada10f400c1e5','','','Bank','dapat Disc 1 bulan','2025-07-21 13:54:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F65B6141AD912F','44088563EY8GJ2S18A2B'),
	(371,'2025-07-21 00:00:00','222301034','MUHAMMAD KENZIO ARSYAD REVINZA','L','4','2','UMUM','B',9,'480000','9EAFB9YI7O1C','e3afed0047b08059d0fada10f400c1e5','','','Bank','dapat Disc 1 bulan','2025-07-21 13:54:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F65B6141AD912F','F6BB6C2A6UM1RXK8F34C'),
	(372,'2025-07-21 00:00:00','222301034','MUHAMMAD KENZIO ARSYAD REVINZA','L','4','2','UMUM','B',10,'480000','9EAFBQ7EACB2','e3afed0047b08059d0fada10f400c1e5','','','Bank','dapat Disc 1 bulan','2025-07-21 13:54:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F65B6141AD912F','7BD3BE8AOOD1DKMAC55F'),
	(373,'2025-07-21 00:00:00','222301034','MUHAMMAD KENZIO ARSYAD REVINZA','L','4','2','UMUM','B',11,'480000','9EAFBAE2ROF1','e3afed0047b08059d0fada10f400c1e5','','','Bank','dapat Disc 1 bulan','2025-07-21 13:54:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F65B6141AD912F','CB2299DFWJYVTPK34C68'),
	(374,'2025-07-21 00:00:00','202101045','VYOLINA HERMINE','P','6','2','UMUM','C',1,'500000','8F65A0S9CO32','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-21 13:56:52','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','851DC93365C94D','FB56825F3ZH2YL7EF822'),
	(375,'2025-07-21 00:00:00','232401037','SAVERIO AL MALIQUE','L','3','2','UMUM','C',1,'500000','5AFE00ADWX6F','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-21 13:57:25','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0B0E0F1BC24F5F','77B60DE2B40W2SB3306F'),
	(377,'2025-07-21 00:00:00','212201020','GAVIN ARVANDHIA WIJAYA','L','5','1','UMUM','C',2,'500000','1B528JN6EX28','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-21 14:14:37','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','BFD08A82D8AAF5','BF1772D26U42V6Y59DE5'),
	(378,'2025-07-21 00:00:00','202101027','MUHAMAD HAIKAL MAULANA AKBAR','L','6','1','UMUM','B',1,'480000','1913FI905K34','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-21 14:15:32','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9ADA11850B67F9','6FB2F0C6LWFKWBY7A53F'),
	(379,'2025-07-21 00:00:00','242501041','SANDRIA HAVIKA NAURA','P','2','1','UMUM','C',2,'500000','2C2BCSMFKB8D','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-21 14:17:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','213E21DA2C53A5','0111E177763JP0H34AF1'),
	(381,'2025-07-21 00:00:00','242501002','ADARA PUTRI TANGGON CENDIKIA','P','2','2','UMUM','C',1,'4800000','FDB45R6ZDD21','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-22 09:24:06','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','CA7452C1A3B323','AB926D68ODOH5PRE19B2'),
	(382,'2025-07-21 00:00:00','242501011','AURORA PUTRI TANGGON CENDIKIA','P','2','2','UMUM','C',1,'2000000','60F14V4IUE1A','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-22 09:24:42','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','1492BB0B77630A','050DDE1A5O82T6U92CF4'),
	(383,'2025-07-22 00:00:00','222301009','AZKA AZFAR HAIKAL','L','4','2','UMUM','C',1,'4800000','A3557T3E1X0B','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-22 09:25:33','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FDE5BEC16C5127','1AC682B0PNB9JL8F619E'),
	(384,'2025-07-23 00:00:00','202101045','VYOLINA HERMINE','P','6','2','UMUM','C',2,'500000','8306E43E3DBA','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-23 06:21:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F7BBCB33659865','A9345254H8JQQ11F0966'),
	(386,'2025-07-23 00:00:00','232401037','SAVERIO AL MALIQUE','L','3','2','UMUM','C',2,'500000','0A3F13CSU8FB','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-23 07:10:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','286C0D1BC2D5F6','2645A6B48A5NAKD30006'),
	(389,'2025-07-25 00:00:00','222301023','JASMINE SALIMAH ROMADHONA','P','4','2','UMUM','C',1,'1500000','1BD67TPA5BFE','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-26 08:22:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','E4C538D0024EF3','BD2983B4X8J06EIE5857'),
	(388,'2025-07-24 00:00:00','242501051','KEISYA SHANUM ALFATHUNISSA','P','2','1','UMUM','B',1,'480000','86444DEJ2V3E','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-24 14:06:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','48EE06A8A43947','834BB004PJ79TMG63720'),
	(387,'2025-07-24 00:00:00','242501016','FATIH ILHAM AULIA','L','2','1','UMUM','B',1,'480000','A2D0E16WQDF0','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-24 08:16:52','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','71F5FAC2A7D33A','BC230937DVQC2AI02CCF'),
	(390,'2025-07-26 00:00:00','202101005','ALFRIZ ANRAGASI JAGADDITHA HUDSI','L','6','1','UMUM','B',1,'480000','0BDD6VDV8G13','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-28 12:36:40','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','85845262781C30','EC9EB99E5Y7736I31CA8'),
	(391,'2025-07-28 00:00:00','222301031','MUHAMMAD ABYAN ARKENZI AKBAR','L','4','1','UMUM','B',1,'480000','49186NF5LLDD','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-28 12:37:27','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7636B350B6CDF9','68B5FE90MXLR3WY7C178'),
	(392,'2025-07-28 00:00:00','202101010','ARFAN PRADIPTA SAFA','L','6','2','UMUM','B',1,'480000','FC611ZPOYZ06','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-28 12:37:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2AB598A7159EA2','AE4D014AG7EZNTR0E906'),
	(393,'2025-07-28 00:00:00','232401013','GALENA KAMANIYA SLAMET VALERIE','P','3','1','UMUM','B',1,'480000','AC40CVY7469A','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-28 12:39:43','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','ED6944608FAAAB','12D50E446OYOKXL35A6B'),
	(394,'2025-07-28 00:00:00','232401013','GALENA KAMANIYA SLAMET VALERIE','P','3','1','UMUM','C',1,'4800000','AC40CRDMMW38','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-28 12:39:43','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','ED6944608FAAAB','B2A651856UAW7ET2E4CD'),
	(395,'2025-07-29 00:00:00','232401025','MUHAMMAD ARIEF HIDAYATULLOH','L','3','1','UMUM','B',1,'480000','21AC36C0A196','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-30 10:43:20','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','667BE7D4CAA1EE','55DFF30BODWF2GU52065'),
	(398,'2025-07-29 00:00:00','222301041','REYNAND ALTAF MULYAWAN','L','4','1','UMUM','B',2,'480000','35E61ZI5TR7A','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-30 10:56:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2BDE23B6F6C42E','0E4D63F1NARVY44119F4'),
	(397,'2025-07-29 00:00:00','222301042','RYUGA EL YUSUF','L','4','1','UMUM','B',1,'480000','6D1162R5R294','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-30 10:49:35','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2B4CD436F900BC','C4CBD561TIDD54B6346D'),
	(399,'2025-07-29 00:00:00','222301041','REYNAND ALTAF MULYAWAN','L','4','1','UMUM','B',3,'480000','35E61YW153B0','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-30 10:56:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2BDE23B6F6C42E','C077AB24UWY6Y3LCEE4E'),
	(400,'2025-07-29 00:00:00','222301041','REYNAND ALTAF MULYAWAN','L','4','1','UMUM','B',4,'480000','35E61HAP2RA4','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-30 10:56:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2BDE23B6F6C42E','51A8DC84O1YBV34B3C0E'),
	(401,'2025-07-29 00:00:00','222301041','REYNAND ALTAF MULYAWAN','L','4','1','UMUM','B',5,'480000','35E616ZW2YD9','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-30 10:56:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2BDE23B6F6C42E','0A7134FFINHAHKP358CC'),
	(402,'2025-07-29 00:00:00','222301041','REYNAND ALTAF MULYAWAN','L','4','1','UMUM','B',6,'480000','35E614PY2ABA','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-30 10:56:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2BDE23B6F6C42E','4B3E68D29W94836B6B1E'),
	(403,'2025-07-29 00:00:00','222301041','REYNAND ALTAF MULYAWAN','L','4','1','UMUM','B',7,'480000','35E61REE6Z71','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-30 10:56:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2BDE23B6F6C42E','0CE478365BBD3DX4C4CE'),
	(404,'2025-07-29 00:00:00','222301041','REYNAND ALTAF MULYAWAN','L','4','1','UMUM','B',8,'480000','35E61HDYZ710','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-30 10:56:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2BDE23B6F6C42E','ED031570NLK1KJO99995'),
	(405,'2025-07-29 00:00:00','222301041','REYNAND ALTAF MULYAWAN','L','4','1','UMUM','B',9,'480000','35E61JWCJEE7','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-30 10:56:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2BDE23B6F6C42E','1462D993FEYGIEY7993F'),
	(406,'2025-07-29 00:00:00','222301041','REYNAND ALTAF MULYAWAN','L','4','1','UMUM','B',10,'480000','35E613B2JO22','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-30 10:56:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2BDE23B6F6C42E','7AA18917Z8A9ZR3AE3C1'),
	(407,'2025-07-29 00:00:00','222301041','REYNAND ALTAF MULYAWAN','L','4','1','UMUM','B',11,'480000','35E6172A3S83','e3afed0047b08059d0fada10f400c1e5','','','Bank','Disc 1 bulan','2025-07-30 10:56:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2BDE23B6F6C42E','8519772DAJJXOUED5314'),
	(408,'2025-07-29 00:00:00','252601009','IBNU SAKTIAWAN SIHOTANG','L','1','1','UMUM','B',1,'550000','D337BN5B19E1','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-30 10:59:16','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0637116E8513FE','B944C1C5EHIRM9G979BF'),
	(409,'2025-07-29 00:00:00','252601013','MUHAMMAD ZAYN AL FATH','L','1','1','UMUM','B',1,'550000','675C7I4MYUA4','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-30 10:59:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','EA74A7BD03D86B','0668E140C0FIODVADE29'),
	(410,'2025-07-29 00:00:00','232401008','DZAKY HADIWIJAYA','L','3','2','UMUM','B',1,'480000','4BA87JZTFP33','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-30 11:00:55','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','487233FD7F02F0','75342FE5D123NOL8756D'),
	(411,'2025-07-29 00:00:00','212201023','GUNTUR JUNA WIJAYA','L','5','1','UMUM','B',1,'480000','AB92CE6CZ76A','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-30 11:02:11','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C59AA5AA24EE54','607CF88E9PLUQCMB87C5'),
	(412,'2025-07-29 00:00:00','242502047','M ALFARIEL SIHOTANG ','L','3','1','UMUM','C',2,'450000','D5D5FFVLY321','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-30 11:04:05','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','04C1CC6ABD2997','3FFF3C9EZZITXREE6237'),
	(413,'2025-07-29 00:00:00','252601003','ALKHAFA SAUQI BATUBARA','L','1','1','UMUM','B',1,'550000','0C254XNLG2D1','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-30 11:05:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9FEDAFFFA2E99D','9B08B1F3JQVZFBY26629'),
	(414,'2025-07-29 00:00:00','252601018','RAUFA SHAKEIL LESMANA','L','1','1','UMUM','B',1,'550000','04281MSYZMBA','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-30 11:08:33','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','436F73723FB192','6630EA712FB9ATL4144C'),
	(418,'2025-07-29 00:00:00','252601011','KHALISA SHAKIRA AKBAR','P','1','1','UMUM','B',1,'550000','0848CE7OUK56','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-30 11:15:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','78545C735E435F','A8990F9E4UODKKL8A471'),
	(416,'2025-07-29 00:00:00','252601012','MUHAMMAD FADLAN AZZUHRI','L','1','1','UMUM','B',1,'550000','B95D5VEDN2CE','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-30 11:11:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','06F9B7E1327860','0C052646KX1QW2JDBA97'),
	(417,'2025-07-29 00:00:00','252601022','ZAKI MAULUDIN AZKIA','L','1','1','UMUM','B',2,'6050000','EB1B92GUM47C','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-30 11:13:38','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2D471EA7996AEC','8167F4C9FO21JARD6156'),
	(420,'2025-07-30 00:00:00','252601021','TAMHIDAN ADINATA','L','1','1','UMUM','B',1,'550000','0C465RQLX1AC','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-30 11:21:35','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0A38CE95AD57BD','21D878DBBA7P4X9C96A7'),
	(421,'2025-07-30 00:00:00','242501019','GHEISAN ARCELLO MAHESA','L','2','2','UMUM','B',1,'480000','086BDBY8QXFA','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:00:48','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','E3F36E38105945','D97FD90COM51NB707056'),
	(422,'2025-07-30 00:00:00','232401016','HARITH ADSKHAN ','L','3','2','UMUM','B',1,'480000','917B8XK51G77','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:02:10','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','96495270ABBB9F','4EEBB974IR2NBYYFC6EE'),
	(423,'2025-07-30 00:00:00','252601007','ERSTA ATHARAZKA WIBOWO','L','1','1','UMUM','B',1,'275000','9209FQ9QYN44','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:05:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','E90886852E4395','B40DBF21IURRERQEE584'),
	(424,'2025-07-30 00:00:00','252601033','RADITYA ARSHA PRATAMA','L','1','1','UMUM','B',1,'550000','2F806V8UFM40','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:06:44','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F1A62A24E80CA8','21E19008GQ55HZY4F0BA'),
	(425,'2025-07-31 00:00:00','202106054','ENZO KAFFIE EL AZZAM','L','6','1','UMUM','B',1,'480000','7E5C3Z944Y2E','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:09:11','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','5818DF4B39C797','BFA13EAAFRF48A2941A9'),
	(426,'2025-07-31 00:00:00','222301032','MUHAMMAD AZKA KHOERUL AZAM','L','4','1','UMUM','B',1,'480000','24974WE88BEF','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:09:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','6774AC002E4AF6','6C861C95492VQ5JF01D0'),
	(427,'2025-07-31 00:00:00','242501034','NAIRA GHAISANI','P','2','2','UMUM','B',2,'480000','B2918M12N996','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:10:59','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7258A32E029007','343AA9A12XDZ9E7FA4D4'),
	(428,'2025-07-31 00:00:00','242501034','NAIRA GHAISANI','P','2','2','UMUM','B',3,'480000','B2918NW0YI5D','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:10:59','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7258A32E029007','4587C861I01Z4MTA1D78'),
	(429,'2025-07-31 00:00:00','242501034','NAIRA GHAISANI','P','2','2','UMUM','B',4,'480000','B2918RFJYM13','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:10:59','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7258A32E029007','07FAD36BEZBBC8PD4575'),
	(430,'2025-07-31 00:00:00','242501034','NAIRA GHAISANI','P','2','2','UMUM','B',5,'480000','B2918HCND18C','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:10:59','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7258A32E029007','B75389FFKFBLN5N445CA'),
	(431,'2025-07-31 00:00:00','242501034','NAIRA GHAISANI','P','2','2','UMUM','B',6,'480000','B2918HC3GE42','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:10:59','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7258A32E029007','3A09C745UMOEENPECBF6'),
	(432,'2025-07-31 00:00:00','242501034','NAIRA GHAISANI','P','2','2','UMUM','B',7,'480000','CFE9AYRFC20F','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:11:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7258A32E029007','D78E863C3U1RC7B0122D'),
	(433,'2025-07-31 00:00:00','242501034','NAIRA GHAISANI','P','2','2','UMUM','B',8,'480000','CFE9AXEROI45','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:11:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7258A32E029007','4AE3CBC93S76ZXL91A46'),
	(434,'2025-07-31 00:00:00','242501034','NAIRA GHAISANI','P','2','2','UMUM','B',9,'480000','CFE9AOE5TF7E','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:11:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7258A32E029007','2E54891279M2F3J045D7'),
	(435,'2025-07-31 00:00:00','242501034','NAIRA GHAISANI','P','2','2','UMUM','B',10,'480000','CFE9ARIGECA3','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:11:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7258A32E029007','75F2967BVCTYAVQC5AEA'),
	(436,'2025-07-31 00:00:00','242501034','NAIRA GHAISANI','P','2','2','UMUM','B',11,'480000','CFE9A0INXN55','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:11:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7258A32E029007','EAD4AF1EP5AP3GU63F70'),
	(437,'2025-07-31 00:00:00','242501035','NAUFAL ALKHALIFI PRASTIYO','L','2','2','UMUM','B',1,'480000','E44A7781D26F','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:12:27','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','6AEDEE3052FFE2','5EFC5D26XB4M6XGB3998'),
	(438,'2025-07-31 00:00:00','242501035','NAUFAL ALKHALIFI PRASTIYO','L','2','2','UMUM','C',2,'1800000','E44A7UVR90EE','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:12:27','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','6AEDEE3052FFE2','0B18C714YM1ZJ747D08B'),
	(439,'2025-07-31 00:00:00','232401033','RANIA SARAH RACHMAN','P','3','2','UMUM','B',1,'480000','AC015OCEUWD2','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:13:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','1A5A333E92127A','FC21382DM7HBGMU01AC6'),
	(440,'2025-07-31 00:00:00','232401038','SERAFINA SHANUM KIRANA YUDHA','P','3','1','UMUM','B',2,'480000','D028C99KX438','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:15:06','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8EF218B9004F4F','327186FA7SLRMG481725'),
	(441,'2025-07-31 00:00:00','232401038','SERAFINA SHANUM KIRANA YUDHA','P','3','1','UMUM','B',3,'480000','D028C7BXE844','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:15:06','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8EF218B9004F4F','1854DBBCK7QQCCQ0F4EC'),
	(442,'2025-07-31 00:00:00','232401038','SERAFINA SHANUM KIRANA YUDHA','P','3','1','UMUM','B',4,'480000','0E6A88N6BQC7','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:15:07','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8EF218B9004F4F','C110FC80MW18GUBFFB24'),
	(443,'2025-07-31 00:00:00','232401038','SERAFINA SHANUM KIRANA YUDHA','P','3','1','UMUM','B',5,'480000','0E6A8GG8CABF','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:15:07','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8EF218B9004F4F','882D05FCS0QUSZK73DC0'),
	(444,'2025-07-31 00:00:00','232401038','SERAFINA SHANUM KIRANA YUDHA','P','3','1','UMUM','B',6,'480000','0E6A8R71LUD1','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:15:07','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8EF218B9004F4F','95D0E5209GS3EQ49A217'),
	(445,'2025-07-31 00:00:00','232401038','SERAFINA SHANUM KIRANA YUDHA','P','3','1','UMUM','B',7,'480000','0E6A8VN7HKA7','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:15:07','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8EF218B9004F4F','A214A616KQQNWVKF0E9E'),
	(446,'2025-07-31 00:00:00','232401038','SERAFINA SHANUM KIRANA YUDHA','P','3','1','UMUM','B',8,'480000','0E6A8Y5W1A8A','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:15:07','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8EF218B9004F4F','46E6864ASE6AIFH4FAF2'),
	(447,'2025-07-31 00:00:00','232401038','SERAFINA SHANUM KIRANA YUDHA','P','3','1','UMUM','B',9,'480000','0E6A8VU517FE','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:15:07','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8EF218B9004F4F','3B58D0A9IDZTBIY45A3C'),
	(448,'2025-07-31 00:00:00','232401038','SERAFINA SHANUM KIRANA YUDHA','P','3','1','UMUM','B',10,'480000','A57FELA2FM18','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:15:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8EF218B9004F4F','91DDD30DLI5NUXDB3BB7'),
	(449,'2025-07-31 00:00:00','232401038','SERAFINA SHANUM KIRANA YUDHA','P','3','1','UMUM','B',11,'480000','A57FEZL106EE','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:15:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8EF218B9004F4F','2D9AB23F9E88MHCEDC6A'),
	(450,'2025-07-31 00:00:00','212201017','PELANGI ASSYABIYA HANDIAN','P','5','1','UMUM','B',1,'240000','A2DDD3WGV47F','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:16:21','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','AD19DFDE83EC1A','047366BA7FUGSO664A6E'),
	(451,'2025-07-31 00:00:00','212201021','SHAQILA AJENG ADZKIYA DZAFIRA','P','5','1','UMUM','C',1,'5200000','682C079KU271','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:18:16','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D58FF0061BF152','98905AC09SUOUL79D9D7'),
	(452,'2025-07-31 00:00:00','252601019','RAZKA ADITYA','L','1','1','UMUM','B',1,'550000','D6BA4F10SFC7','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:19:57','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','5EFCB4BB670326','310DDBD53VH3RKTB5264'),
	(453,'2025-07-31 00:00:00','252601017','RANIA ALISHA','P','1','1','UMUM','B',1,'550000','A8557NI4HL89','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:20:44','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8B79958A8F839F','1F92463ASVC3VQCDEC57'),
	(454,'2025-08-01 00:00:00','202101006','ALIF ADDIN GUNAWAN &#039;IZZA','L','6','2','UMUM','B',2,'240000','0E6B2O41E642','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:22:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','5A6600A96D0E69','0FC56EC25SIK042FA637'),
	(455,'2025-08-01 00:00:00','202101006','ALIF ADDIN GUNAWAN &#039;IZZA','L','6','2','UMUM','C',2,'500000','0E6B28E2GDE3','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:22:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','5A6600A96D0E69','EF5841B4MR75TG948B96'),
	(456,'2025-08-01 00:00:00','242501008','ATHAYA NABHAN ZAAHIRULHAQ','L','2','2','UMUM','B',2,'480000','F676AY4CW166','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:22:55','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','1F50CF0F8FD96D','22DF2012TU97XTH5802B'),
	(457,'2025-08-01 00:00:00','222301008','AYESHA QIANA NURDIANSYAH','P','4','1','UMUM','B',2,'240000','964E6U447D85','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:23:40','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','76123FEF25CCFA','D49CC0C88NFEBPZ6729F'),
	(458,'2025-08-01 00:00:00','242501013','AZFAR RAFFASYA NURDIANSYAH','L','2','2','UMUM','B',2,'240000','17A431X2IV1D','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:24:22','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','DFD88E9CE8F1FC','99EFEEC5Q3JIXD654FC1'),
	(476,'2025-08-01 00:00:00','242501015','CLARA AINUN NISYA','P','2','2','UMUM','B',1,'480000','8214AIVGAMAC','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 08:29:14','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','419907076601F9','975F1712SU4UVT45C55B'),
	(460,'2025-08-01 00:00:00','222301013','FADIAH ANINDYA MAULA','P','4','2','UMUM','B',2,'240000','0E530TGIUC97','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:37:38','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','DE2D67CB39EDC5','C5B577FAUY5D73O0CFED'),
	(461,'2025-08-01 00:00:00','222301013','FADIAH ANINDYA MAULA','P','4','2','UMUM','C',2,'500000','0E530GEMOT10','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:37:38','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','DE2D67CB39EDC5','EC216BA5G4ODI0G7C128'),
	(462,'2025-08-01 00:00:00','212201019','FAYRUZ AILA ELZAVIRA','P','5','1','UMUM','B',1,'480000','BE0C8YYU2NDB','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:41:20','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D3E6764D656F82','0F753DFA2WYZ77O19852'),
	(463,'2025-08-01 00:00:00','212201019','FAYRUZ AILA ELZAVIRA','P','5','1','UMUM','C',2,'3200000','BE0C82A6QGC8','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:41:20','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D3E6764D656F82','66BA10934CSLQQ2DC6F3'),
	(464,'2025-08-01 00:00:00','202101025','KHAYLA APRILIA KIRANA','P','6','1','UMUM','B',2,'480000','A86121FIHW5F','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:43:56','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C39524883A3DAA','DB142407GIBYYUTA44D6'),
	(465,'2025-08-01 00:00:00','232401022','MILESHA SHIDQIN ALIYA FIRDAUS','P','3','1','UMUM','B',1,'480000','6890DJ8IGH1E','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:46:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','E56BB688FE47EC','17E0D8F72FQA3MHF8E36'),
	(466,'2025-08-01 00:00:00','212201006','NADHIFA KHANSA ZAHIRANI','P','5','1','UMUM','B',2,'480000','7ACF0AD4AJ89','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:46:59','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FE3732BFC7552D','03AD0EB6QLMU1LTC2A11'),
	(467,'2025-08-01 00:00:00','232401029','NAFISHA HASNAA CARISSA ','P','3','1','UMUM','B',2,'480000','7AB341BM37E9','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:50:37','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','17725F582E0FCE','704EE761JOU74ZODD067'),
	(468,'2025-08-01 00:00:00','232401033','RANIA SARAH RACHMAN','P','3','2','UMUM','B',2,'480000','3952D2ZFLK4B','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:53:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9CFACF3E920262','66A95BA9TINJSU2D2A60'),
	(469,'2025-08-01 00:00:00','232401036','SALVINA ALEESHA ALRADYA','P','3','2','UMUM','B',2,'480000','D20A4A9BMI39','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:55:28','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9142594FA4B9E7','C50401ABAZKPK0297870'),
	(470,'2025-08-01 00:00:00','232401013','GALENA KAMANIYA SLAMET VALERIE','P','3','1','UMUM','B',2,'480000','4CF45CORM0DC','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:57:10','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0353F8608F731D','BEEC4E0FB743F8Q2CA52'),
	(471,'2025-08-01 00:00:00','252601032','ZAVIER AL GIBRAN','L','3','1','UMUM','B',1,'550000','04751X02ZE3B','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:58:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C922463F8AB4AB','E8BE8C7F4HGIKBR9B552'),
	(472,'2025-08-01 00:00:00','252601026','GHIYATS EL ARGA ABDULLAH','L','2','1','UMUM','B',1,'550000','3633DQLJRD2A','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 07:59:41','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F9C85DD6CE4144','A7AAE9EBO5QVJGT4A19C'),
	(473,'2025-08-01 00:00:00','252601025','GHAITS EL ATHAR ABDULLAH','L','4','1','UMUM','B',1,'550000','A2441LTAT259','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 08:00:27','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','259A6CA2C4E976','41008AB8A1PUQR3B44FE'),
	(474,'2025-08-01 00:00:00','252602026','MUHAMMAD NIZAM DIAULHAQ','L','1','1','Akademik','B',1,'550000','8240B4N9M377','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 08:07:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','694BCA9AB493FD','37181699UD55C7Z28128'),
	(475,'2025-08-01 00:00:00','242501038','QALIFA AL QAHTHAN ROYCE','L','2','1','UMUM','B',2,'480000','57007WEDKL79','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 08:25:23','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7102163B3A59D0','70FC9BFBIVLZQE75171C'),
	(477,'2025-08-02 00:00:00','232401004','ALWI AMMAR AL GHAZALI','L','3','2','UMUM','B',1,'480000','FF16BL8KIMC0','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 08:30:48','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4C214ECE726A2E','1F889DBELHAJHK1D6599'),
	(478,'2025-08-02 00:00:00','222301035','NABILA REVALINA','P','4','2','UMUM','B',2,'480000','C5C406QSE49E','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 08:31:16','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','EBC22159025C4B','C4422C13IGJN2HYB6CF7'),
	(479,'2025-08-02 00:00:00','232401030','PRAMUDYA ARDHANI HAMIZAN ','L','3','2','UMUM','B',2,'240000','2AE36VT34O04','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 08:32:29','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','895622359768D7','CD990800SDVU1L45AE8F'),
	(480,'2025-08-02 00:00:00','232401030','PRAMUDYA ARDHANI HAMIZAN ','L','3','2','UMUM','C',2,'505000','E37796XIMWCF','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 08:32:30','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','895622359768D7','3A8988C8JMHY1P72A38C'),
	(481,'2025-08-03 00:00:00','242501020','JASMINE ASH-SHANUM TAZKIYA HAN','P','2','1','UMUM','B',2,'240000','F0BADVSCC7A5','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 08:34:01','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','AD8C0F38EAE69E','34B6DD54OQEFUTW81CF4'),
	(482,'2025-08-03 00:00:00','202101042','SYAKILLA AZ DZAKIYAH JELITA HAN','P','6','2','UMUM','B',2,'240000','37415ZZYJP1E','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 08:34:39','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','32CFF0A73520C6','0423B4E3O688IQ24ACA6'),
	(483,'2025-08-03 00:00:00','222301038','RAFFA ADINAKA AR RAHMAT','L','4','1','UMUM','B',2,'480000','8DD7AR25K615','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 08:35:25','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','EBD85ADAB74DF6','B78A4BE6R4ZTE1W1A243'),
	(484,'2025-08-04 00:00:00','242501016','FATIH ILHAM AULIA','L','2','1','UMUM','B',2,'480000','4A4B2SEL7U6C','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 08:46:05','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','B7173BC2A7B4B4','129DE160RFGVTAL5A7F6'),
	(485,'2025-08-04 00:00:00','212201012','DAIKI ARSYAD KHAIRULLAH','L','5','1','UMUM','B',2,'480000','8AA50X03YKBC','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 08:59:20','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3F46A2934C6F7A','40F7F90825KDFDDA36A7'),
	(486,'2025-08-04 00:00:00','212201029','FARAND SAVERIO KHILAL','L','6','1','UMUM','B',2,'480000','A7804FGMUX51','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 08:59:45','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2C72B702200163','212353A7PLYVMRR49AE2'),
	(487,'2025-08-04 00:00:00','222301045','ZEFA FARZANI','L','4','1','UMUM','B',2,'480000','411645AG35A1','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-04 09:00:24','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','CF90F5105C9314','FCE423B2EOLNSVFB583B'),
	(488,'2025-08-04 00:00:00','242501001','ABIZARD ARSHAD NUGRAHA','L','2','2','UMUM','B',2,'480000','85F96IYDCH8F','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:10:39','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','75C56E448DCC75','93E3D4A88ZHLKUDC5158'),
	(489,'2025-08-04 00:00:00','232401003','ALEM VIRENDRA MULYAWAN','L','3','2','UMUM','B',2,'480000','B87328MJ9EB7','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:12:52','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3FEDBB05F02F87','B5EC5248NE2CSLWE6FBB'),
	(490,'2025-08-04 00:00:00','232401003','ALEM VIRENDRA MULYAWAN','L','3','2','UMUM','B',3,'480000','B8732DYI2XE9','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:12:52','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3FEDBB05F02F87','5E92DBB6A57DF0W59A69'),
	(491,'2025-08-04 00:00:00','232401003','ALEM VIRENDRA MULYAWAN','L','3','2','UMUM','B',4,'480000','8A219KQ9YK0E','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:12:53','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3FEDBB05F02F87','EEF24CABEF8QNMZEA340'),
	(492,'2025-08-04 00:00:00','232401003','ALEM VIRENDRA MULYAWAN','L','3','2','UMUM','B',5,'480000','8A219R7Z4J3D','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:12:53','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3FEDBB05F02F87','8B92DF50ZY4UNVB00486'),
	(493,'2025-08-04 00:00:00','232401003','ALEM VIRENDRA MULYAWAN','L','3','2','UMUM','B',6,'480000','8A2198XIFN47','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:12:53','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3FEDBB05F02F87','6E842968MUYUVK2E73BB'),
	(494,'2025-08-04 00:00:00','232401003','ALEM VIRENDRA MULYAWAN','L','3','2','UMUM','B',7,'480000','8A2197XM2F67','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:12:53','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3FEDBB05F02F87','0074F1C0K4HWN2HA5A01'),
	(495,'2025-08-04 00:00:00','232401003','ALEM VIRENDRA MULYAWAN','L','3','2','UMUM','B',8,'480000','8A219D444472','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:12:53','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3FEDBB05F02F87','134D39A1DONK33R1F52D'),
	(496,'2025-08-04 00:00:00','232401003','ALEM VIRENDRA MULYAWAN','L','3','2','UMUM','B',9,'480000','8A2197YJLIB6','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:12:53','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3FEDBB05F02F87','AB97E338817DJW2F982E'),
	(497,'2025-08-04 00:00:00','232401003','ALEM VIRENDRA MULYAWAN','L','3','2','UMUM','B',10,'480000','8A219CTGZ514','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:12:53','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3FEDBB05F02F87','5CFF6E40Z0YZDNB9DC4B'),
	(498,'2025-08-04 00:00:00','232401003','ALEM VIRENDRA MULYAWAN','L','3','2','UMUM','B',11,'480000','8A2199Z50L90','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:12:53','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3FEDBB05F02F87','CB7A545FKFCR3BLC2865'),
	(499,'2025-08-04 00:00:00','202101011','ARSEN ADISA ASHSHIYAAM','L','6','2','UMUM','B',2,'480000','9DEF6V9C7MA6','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:17:04','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3B07F848E8B5C8','557BE82DL6ILBS25B8B5'),
	(500,'2025-08-04 00:00:00','242501015','CLARA AINUN NISYA','P','2','2','UMUM','B',2,'480000','45799KV4ZA05','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:18:47','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4B513707661926','A339EC89SHODBGME30B2'),
	(501,'2025-08-04 00:00:00','212201019','FAYRUZ AILA ELZAVIRA','P','5','1','UMUM','B',2,'480000','7BDF39H9N34A','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:19:28','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0382774D655BB8','83BD5259S6Y64K67BDAA'),
	(502,'2025-08-04 00:00:00','212201024','MOCHAMAD IQBAL MAULANA','L','5','1','UMUM','B',2,'480000','A40EEOYUTEF7','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:22:01','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4E6F2989C07C3F','BAE9F3963FECPKK96F5B'),
	(503,'2025-08-04 00:00:00','212201016','NAZMI ATFHAL AZIZ','L','5','1','UMUM','B',2,'480000','37BCA43BJP8F','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:22:30','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','098855A1369B1B','188A3C1ECH0D4DB19D3B'),
	(504,'2025-08-04 00:00:00','242501044','SYIFA MAULIDA SALSABILA','P','2','2','UMUM','B',2,'480000','F82C1TSVY5E5','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:23:02','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C02586F0A9021E','4E3BFE796WDM7V5C0AA2'),
	(505,'2025-08-04 00:00:00','222301009','AZKA AZFAR HAIKAL','L','4','2','UMUM','B',1,'480000','19106XV19508','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:23:52','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','28D131C16C94C9','58791593C3H5R2Q98AA9'),
	(506,'2025-08-04 00:00:00','202101014','AZZAHRA DIANDRA NUGROHO','P','6','1','UMUM','B',2,'480000','AF2CBFAE0KCE','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:24:31','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','EA9E41C26C0C2A','02B184816QCRMNWFE913'),
	(507,'2025-08-05 00:00:00','212201020','GAVIN ARVANDHIA WIJAYA','L','5','1','UMUM','B',2,'480000','66DFALV7GUFB','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:30:03','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','AAE1E482D8D328','52AAD350J6TQLF15D8E5'),
	(508,'2025-08-05 00:00:00','242501041','SANDRIA HAVIKA NAURA','P','2','1','UMUM','B',2,'480000','87E0FIMWYPAB','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-08-05 08:30:36','180.254.23.3','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C18D30DA2C48BD','2BA643385KL24HQ6AFC1');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_transaksi2526`;

CREATE TABLE IF NOT EXISTS `tabungan_transaksi2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `jurnal` varchar(1) NOT NULL,
  `catatan` text NOT NULL,
  `created_by` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

