<?php

//Hak Cipta dilindungi Undang-undang. Hak Cipta : Khamdi Rahmani, Reg. Kemenkum HAM No : 000121327. Dilarang merubah isi File tanpa ijin tertulis dari pemegang Hak Cipta. 

class simakom_rkas
{
    //LIST KATEGORI
    public function list_kategori($tahun, $tb_kegiatan,  $tb_komponen, $tb_akun, $tb_detail, $tb_revisi)
    {



        $revisi = $this->maxRevisi($tb_revisi);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   simakom_ref_kategori  order by kategori asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $kategori_kode = $data->kategori;
            $kategori_uraian = $data->uraian;

            if ($kategori_kode != 'C') {
                $modal = new modal();
                $tambahkeg = $modal->modalRKAS('./view/rkas/kegiatan_tambah', 'tambah_kategori', $kategori_kode, $tahun, 'md', 'grey', 'SIMPAN', "<strong class='text-danger'>TAMBAH KEGIATAN</strong>", 'file-earmark-plus text-danger', '', 'default', 'TAMBAH KEGIATAN');
                $delete_kategori = $modal->modalRKAS('./view/rkas/kategori_delete', 'delete_kategori', $kategori_kode, $tahun, 'md', 'default', 'HAPUS', "<strong class='text-danger'>HAPUS KATEGORI</strong>", 'trash text-danger', '', 'default', 'HAPUS DATA');
            } else {
                $tambahkeg = "";
                $delete_kategori = "";
            };

            //Jumlah
            $jumlah = $this->sum($tb_detail, 'total', "where kategori='$kategori_kode'  and revisi='$revisi'");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            //Jumlah Surplus/Defisit
            $pendapatan = $this->sum($tb_detail, 'total', "where kategori='A' and revisi='$revisi'");
            $belanja = $this->sum($tb_detail, 'total', "where kategori='B' and revisi='$revisi'");
            $saldo = @($pendapatan - $belanja);
            $saldo_format = @(number_format($saldo, 0, ",", "."));

            if ($kategori_kode == "A") {
                $pd = $this->sum($tb_detail, 'total', "where kategori='B' and revisi='$revisi'");
                $pd_format = @(number_format($pd, 0, ",", "."));
                $surplus = @($jumlah - $pd);
                $surplus_format = @(number_format($surplus, 0, ",", "."));
            } else {
                $pd_format = "";
                $surplus_format = "";
            };

            if ($kategori_kode == "C") {
                $jumlah = $saldo_format;
            } else {
                $jumlah = $jumlah_format;
            };

            echo "
            <tr bgcolor=#FFFFFF >
                <td width='100'><span class='text-danger pl-1'>$kategori_kode</span></td>
                <td align=left ><span class='text-danger' style=color:#B22222>$kategori_uraian</span></td>
                <td align=right><span class='text-danger' style=color:#B22222></span></td>
                <td align=right><span class='text-danger' style=color:#B22222></span></td>
                <td align=right><span class='text-danger' style=color:#B22222></span></td>
                <td align=right><span class='text-danger' style=color:#B22222>$jumlah</span></td>
                <td align=right><span class='text-danger' style=color:#B22222>$pd_format</span></td>
                <td align=right><span class='text-danger' style=color:#B22222>$surplus_format</span></td>
                <td align='left' width='130' class='text-danger'>$tambahkeg </td>
            </tr>
			";
            $this->list_kegiatan($tahun, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kategori_kode, $tb_revisi);
            $no++;
        }

        $this->insertRKASKegiatan($tahun, $tb_kegiatan, $tb_revisi);
        $this->insertRKASKomponen($tahun, $tb_kegiatan, $tb_komponen, $tb_revisi);
        // $this->insertRKASAkun($tahun, $tb_akun, $tb_revisi, $akun);
        //$this->perhitungan();

        //Update Detail
        $cekpost = new cekissetPost();
        $id_detail = $cekpost->cek('id_detail');
        $this->deleteRKASDetail($tb_detail, $tb_revisi, $id_detail);

        //Update Akun
        //$old_akun = $cekpost->cek('old_akun');
        //$id_akun = $cekpost->cek('id_akun');
        //$akun_new = $cekpost->cek('akun_new');
        //$this->updateRKASAkun($tb_akun, $tb_detail, $old_akun, $tb_revisi, $akun_new, $id_akun);
        //$this->deleteRKASAkun($tb_akun, $tb_detail, 'id', $tb_revisi, $id_akun);

        //Update n Delete KOmponen
        $oldKomValue = $cekpost->cek('oldKomValue');
        $id_komponen = $cekpost->cek('id_komponen');
        //$this->updateRKASKomponen($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $oldKomValue,  $tb_revisi, $id_komponen, $kategori, $kegiatan, $komponen_new);
        $this->deleteRKASKomponen($tb_komponen, $tb_akun, $tb_detail, $tb_revisi);

        //Update n Delete Kegiatan
        //$id_kegiatan = $cekpost->cek('id_kegiatan');
        //$kegiatan_old = $cekpost->cek('kegiatan_old');
        //$this->updateRKASKegiatan($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kegiatan_old, $tb_revisi);
        //$this->deleteRKASKkegiatan($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $id_kegiatan, $tb_revisi);

        //Delete Kategori
        $this->deleteRKASKategori($tahun, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $tb_revisi);
    }

    //LIST KEGIATAN
    private function list_kegiatan($tahun, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kategori, $tb_revisi)
    {

        $revisi = $this->maxRevisi($tb_revisi);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_kegiatan}  WHERE kategori = '{$kategori}' and revisi='$revisi' group by kegiatan order by kegiatan asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $kegiatan_kode = $data->kegiatan;
            // $kegiatan_uraian = $data->uraian;
            $kategori_kode = $data->kategori;
            $kegiatan_id = $data->id;

            //Kode Custome
            $kegiatan_custome = $this->kodeCustome('simakom_ref_kegiatan', 'kegiatan', $kegiatan_kode, 'kegiatan_custome');
            $kegiatan_uraian = $this->kodeCustome('simakom_ref_kegiatan', 'kegiatan', $kegiatan_kode, 'uraian');

            if ($kategori_kode != 'C') {
                $modal = new modal();
                $link = new linkpage();
                $tambahkomponen = $modal->modalRKAS('./view/rkas/komponen_tambah', 'tambah_komponen', $kegiatan_kode, $tahun, 'md', 'default', 'SIMPAN', "<strong class='text-primary'>TAMBAH KOMPONEN</strong>", 'file-earmark-plus text-primary', '', 'default', 'TAMBAH KOMPONEN');
                //$kegiatan_edit = $modal->modalRKAS('./view/rkas/kegiatan_edit', 'kegiatan_edit', $kegiatan_id, $tahun, 'md', 'default', 'SIMPAN', "<strong class='text-primary'>EDIT KEGIATAN</strong>", 'pencil-square text-primary', '', 'default', 'EDIT KEGIATAN<');
                $kegiatan_edit = "<a " . $link->pageID($kegiatan_id, 'rkas/kegiatan_edit') . " class='btn btn-light btn-xs d-inline' > <i class='bi bi-pencil-square text-primary'></i></a>";
                $kegiatan_delete = "<a " . $link->pageID($kegiatan_id, 'rkas/kegiatan_delete') . " class='btn btn-light btn-xs d-inline' > <i class='bi bi-trash text-primary'></i></a>";
            } else {
                $tambahkomponen = "";
            };

            if ($kategori_kode != 'C') {
                $link = new linkpage();
                $tambahkomponen = "<a " . $link->pageID($kegiatan_kode, 'rkas/komponen_tambah') . " class='btn btn-default btn-xs d-inline' > <i class='bi bi-file-earmark-plus text-secondary'></i></a>";
                $kegiatan_edit = "<a " . $link->pageID($kegiatan_id, 'rkas/kegiatan_edit') . " class='btn btn-light btn-xs d-inline' > <i class='bi bi-pencil-square text-primary'></i></a>";
                $kegiatan_delete = "<a " . $link->pageID($kegiatan_id, 'rkas/kegiatan_delete') . " class='btn btn-light btn-xs d-inline' > <i class='bi bi-trash text-primary'></i></a>";
            } else {
                $tambahkomponen = "";
            };

            //Jumlah
            $jumlah = $this->sum($tb_detail, 'total', "where kategori='$kategori_kode' and kegiatan='$kegiatan_kode' and revisi='$revisi'");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            if ($kategori_kode == "A") {
                $pd = $this->sum($tb_detail, 'total', "where kategori='B' and pembiayaan_kegiatan='$kegiatan_kode' and revisi='$revisi'");
                $pd_format = @(number_format($pd, 0, ",", "."));
                $surplus = @($jumlah - $pd);
                $surplus_format = @(number_format($surplus, 0, ",", "."));
            } else {
                $pd_format = "";
                $surplus_format = "";
            };

            echo "
					<tr bgcolor=#FFFFFF>
                        <td align=left><span class='text-primary pl-2' style=color:#00008B>$kegiatan_custome</span></td>
                        <td align=left ><span class='text-primary pl-1' style=color:#00008B>$kegiatan_uraian</span></td>
                        <td align=right><span class='text-primary' style=color:#00008B></span></td>
                        <td align=right><span class='text-primary' style=color:#00008B></span></td>
                        <td align=right><span class='text-primary' style=color:#00008B></span></td>
                        <td align=right><span class='text-primary' style=color:#00008B>$jumlah_format</span></td>
                        <td align=right><span class='text-primary' style=color:#00008B>$pd_format</span></td>
                        <td align=right><span class='text-primary' style=color:#00008B>$surplus_format</span></td>
                        <td align=left width='130'>$tambahkomponen  $kegiatan_edit $kegiatan_delete</td>
					</tr>
					";
            $this->list_komponen($tahun, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail,  $kegiatan_kode, $tb_revisi);
            $no++;
        }
    }
    //LIST KOMPONEN
    private function list_komponen($tahun, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kegiatan, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_komponen}  WHERE kegiatan = '{$kegiatan}' and revisi='$revisi' group by komponen  order by komponen asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $komponen_kode = $data->komponen;
            $komponen_uraian = $data->uraian;
            $kode_kegiatan = $data->kegiatan;
            $komponen_id = $data->id;

            //Uraian Kegiatan
            $showkegiatan = $db->runQuery("SELECT * FROM   {$tb_kegiatan}  WHERE kegiatan = '{$kode_kegiatan}'");
            $kegiatan = $showkegiatan->fetch(PDO::FETCH_OBJ);
            $kegiatan_uraian = $kegiatan->uraian;
            $kode_kategori = $kegiatan->kategori;
            $kegiatan = $kegiatan->kegiatan;
            $uraian_kategori = $this->uraianRKAS('simakom_ref_kategori', 'kategori', $kode_kategori, 'uraian');
            $title_kegiatan = $kode_kategori . ' : ' . $uraian_kategori . '  --   ' . $kode_kegiatan .  ' : ' . $kegiatan_uraian;

            if ($kode_kategori != 'C') {
                $modal = new modal();
                $link = new linkpage();
                $tambahakun = "<a " . $link->pageID($komponen_id . $tahun, 'rkas/akun_tambah') . " class='btn btn-xs  px-1 py-1 d-inline'> <i class='bi bi-file-earmark-plus text-success'></i></a>";
            } else {
                $tambahakun = "";
            };

            //Jumlah
            $jumlah = $this->sum($tb_detail, 'total', "where kategori='$kode_kategori' and kegiatan='$kode_kegiatan' and komponen='$komponen_kode'  and revisi='$revisi' ");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            if ($kode_kategori == "A") {
                $pd = $this->sum($tb_detail, 'total', "where kategori='B' and pembiayaan_kegiatan='$kode_kegiatan' and pembiayaan_komponen='$komponen_kode'  and revisi='$revisi'");
                $pd_format = @(number_format($pd, 0, ",", "."));
                $surplus = @($jumlah - $pd);
                $surplus_format = @(number_format($surplus, 0, ",", "."));
            } else {
                $pd_format = "";
                $surplus_format = "";
            };

            $modal = new modal();
            //$edit_komponen = $modal->modalRKAS('./view/rkas/komponen_edit', 'edit_komponen', $komponen_id, $tahun, 'md', 'default', 'EDIT', "<strong class='text-success'>EDIT KOMPONEN</strong>", 'pencil-square text-success', '', 'default', 'EDIT KOMPONEN');

            $edit_komponen = "<a " . $link->pageID($komponen_id, 'rkas/komponen_edit') . " class='btn btn-light btn-xs d-inline' > <i class='bi bi-pencil-square text-success'></i></a>";

            $delete_komponen = "<a " . $link->pageID($komponen_id, 'rkas/komponen_delete') . " class='btn btn-light btn-xs d-inline' > <i class='bi bi-trash text-success'></i></a>";

            echo "
                 <tr bgcolor='#FFFFFF' title='$title_kegiatan'>
                    <td align=center><span class='text-info pl-4' style='color:32CD32'>$komponen_kode</span></td>
                    <td align=left ><span class='text-info pl-1' style='color:32CD32'>$komponen_uraian</span></td>
                    <td align=right><span class='text-info' style='color:32CD32'></span></td>
                    <td align=right><span class='text-info' style='color:32CD32'></span></td>
                    <td align=right><span class='text-info' style='color:32CD32'></span></td>
                    <td align=right><span class='text-info' style='color:32CD32'>$jumlah_format</span></td>
                    <td align=right><span class='text-info' style='color:32CD32'>$pd_format</span></td>
                    <td align=right><span class='text-info' style='color:32CD32'>$surplus_format</span></td>     
                    <td align=left width='130'>$tambahakun  $edit_komponen $delete_komponen</td>
                 </tr>
                 ";
            $this->list_akun($tahun, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kode_kegiatan, $komponen_kode, $tb_revisi);
            $no++;
        }
    }
    //LIST AKUN
    private function list_akun($tahun, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kegiatan, $komponen, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_akun}  WHERE kegiatan = '{$kegiatan}' and komponen='$komponen'  and revisi='$revisi' group by akun  order by akun asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $akun_id = $data->id;
            $akun_kode = $data->akun;
            // $akun_uraian = $data->uraian;
            $kode_kategori = $data->kategori;
            $kode_kegiatan = $data->kegiatan;
            $kode_komponen = $data->komponen;

            //Akun Custome
            $akun_custome = $this->kodeCustome('simakom_ref_akun', 'akun', $akun_kode, 'akun_custome');
            $akun_uraian = $this->kodeCustome('simakom_ref_akun', 'akun', $akun_kode, 'uraian');

            $uraian_kategori = $this->uraianRKAS('simakom_ref_kategori', 'kategori', $kode_kategori, 'uraian');
            $uraian_kegiatan = $this->uraianRKAS($tb_kegiatan, 'kegiatan', $kode_kegiatan, 'uraian');
            $uraian_komponen = $this->uraianRKAS($tb_komponen, 'komponen', $kode_komponen, 'uraian');

            $title_kegiatan = $kode_kategori . ' : ' . $uraian_kategori . '  -   ' . $kode_kegiatan .  ' : ' . $uraian_kegiatan . '  -   ' . $kode_komponen . ' : ' . $uraian_komponen;

            if ($kode_kategori != 'C') {
                $link = new linkpage();
                $tambahdetail = "<a " . $link->pageID($akun_id, 'rkas/detail_tambah') . " class='btn btn-light btn-xs d-inline' > <i class='bi bi-file-earmark-plus text-secondary'></i></a>";
            } else {
                $tambahdetail = "";
            };

            //Jumlah
            $jumlah = $this->sum($tb_detail, 'total', "where kategori='$kode_kategori' and kegiatan='$kode_kegiatan' and komponen='$kode_komponen' and akun='$akun_kode'  and revisi='$revisi'");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            if ($kode_kategori == "A") {
                $pd = $this->sum($tb_detail, 'total', "where kategori='B' and pembiayaan_kegiatan='$kode_kegiatan' and pembiayaan_komponen='$kode_komponen' and pembiayaan_akun='$akun_kode'  and revisi='$revisi'");
                $pd_format = @(number_format($pd, 0, ",", "."));
                $surplus = @($jumlah - $pd);
                $surplus_format = @(number_format($surplus, 0, ",", "."));
            } else {
                $pd_format = "";
                $surplus_format = "";
            };

            $modal = new modal();
            //$edit_akun = $modal->modalRKAS('./view/rkas/akun_edit', 'edit_akun', $akun_id, $tahun, 'lg', 'default', 'EDIT', "<strong class='text-secondary'>EDIT AKUN</strong>", 'pencil-square text-secondary', '', 'default', 'EDIT AKUN');
            //$edit_akun = "<a " . $link->pageID($akun_id . $tahun, 'rkas/akun_edit') . " class='btn btn-xs  px-1 py-1 d-inline'> <i class='bi bi-pencil-square text-secondary'></i></a>";

            // $delete_akun = $modal->modalRKAS('./view/rkas/akun_delete', 'delete_akun', $akun_id, $tahun, 'lg', 'default', 'HAPUS', "<strong class='text-secondary'>HAPUS AKUN</strong>", 'trash text-secondary', '', 'default', 'HAPUS AKUN');
            $delete_akun = "<a " . $link->pageID($akun_id, 'rkas/akun_delete') . " class='btn btn-light btn-xs d-inline' > <i class='bi bi-trash text-secondary'></i></a>";
            $edit_akun = "<a " . $link->pageID($akun_id, 'rkas/akun_edit') . " class='btn btn-light btn-xs d-inline' > <i class='bi bi-pencil-square text-secondary'></i></a>";

            echo "
                 <tr bgcolor='#FFFFFF' title='$title_kegiatan'>
                    <td align=right valign=middle><span class='text-secondary pl-5' style=color:2F4F4F>$akun_custome</span></td>
                    <td align=left valign=middle ><span class='text-secondary pl-1' style=color:2F4F4F>$akun_uraian</span></td>
                    <td align=right valign=middle><span class='text-secondary' style=color:2F4F4F></span></td>
                    <td align=right valign=middle><span class='text-secondary' style=color:2F4F4F></span></td>
                    <td align=right valign=middle><span class='text-secondary' style=color:2F4F4F></span></td>
                    <td align=right valign=middle><span class='text-secondary' style=color:2F4F4F>$jumlah_format</span></td>
                    <td align=right valign=middle><span class='text-secondary' style=color:2F4F4F>$pd_format</span></td>
                    <td align=right valign=middle><span class='text-secondary' style=color:2F4F4F>$surplus_format</span></td>
                    <td align=left width='130'>$tambahdetail $edit_akun $delete_akun</td>
                 </tr>
                 ";
            $this->list_detail($tahun, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $akun_kode, $kode_kategori, $kode_kegiatan, $kode_komponen, $tb_revisi);
            $no++;
        }
    }
    //LIST DETAIL
    private function list_detail($tahun, $tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $akun_kode, $kode_kategori, $kode_kegiatan, $kode_komponen, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        $crud = new crudData;
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_detail WHERE  kategori='{$kode_kategori}' and kegiatan='{$kode_kegiatan}' and komponen='$kode_komponen' and akun = '{$akun_kode}' and revisi='$revisi' order by detail asc, time asc");
        $no = 1;
        $row = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $akun = $data->akun;
            $id_detail = $data->id;
            $detail_uraian = $data->uraian;

            //Akun Custome
            $akun_custome = $this->kodeCustome('simakom_ref_akun', 'akun', $akun, 'akun_custome');

            $akun_uraian = $data->uraian;
            $kategori = $data->kategori;
            $kegiatan = $data->kegiatan;

            $kategori = $data->kategori;
            $kegiatan = $data->kegiatan;
            $komponen = $data->komponen;
            $akun = $data->akun;
            $detail = $data->detail;
            $detail_id = $data->detail_id;
            $uraian = $data->uraian;
            $komponen_1 = $data->komponen_1;
            $komponen_2 = $data->komponen_2;
            $komponen_3 = $data->komponen_3;
            $komponen_4 = $data->komponen_4;
            $unit_1 = $data->unit_1;
            $unit_2 = $data->unit_2;
            $unit_3 = $data->unit_3;
            $unit_4 = $data->unit_4;

            $viewPerh = $this->viewPerhitungan($komponen_1, $komponen_2, $komponen_3, $komponen_4, $unit_1, $unit_2, $unit_3, $unit_4);
            $uraian_detail = $detail_uraian . ' ' . $viewPerh;

            $volume = @(number_format($data->volume, 0, ",", "."));
            $unit = $data->unit;
            $harga = @(number_format($data->satuan, 0, ",", "."));

            $total = number_format($data->total, 0, ",", ".");
            $pembiayaan_detail = $data->pembiayaan_id;
            $pembiayaan_kegiatan = $data->pembiayaan_kegiatan;
            $pembiayaan_komponen = $data->pembiayaan_komponen;
            $pembiayaan_akun = $data->pembiayaan_akun;



            $pembiayaan = $pembiayaan_kegiatan . '.' . $pembiayaan_komponen . '.' . $pembiayaan_akun . '.' . $detail;
            // $pembiayaancode = trim('A' . $pembiayaan_kegiatan .  $pembiayaan_komponen . $pembiayaan_akun . $pembiayaan_detail . $revisi_val);
            $jmlData = $crud->countData($tb_detail, " where detail_id='$pembiayaan_detail'");
            if ($kategori == "A") {
                $kode_pembiayaan = "";
                $color_warning = "";
            } else {
                $kode_pembiayaan = $pembiayaan;
                if ($jmlData < 1) {
                    $color_warning = "text-danger";
                } else {
                    $color_warning = "";
                };
            };

            $uraian_kategori = $this->uraianRKAS('simakom_ref_kategori', 'kategori', $kategori, 'uraian');
            $uraian_kegiatan = $this->uraianRKAS($tb_kegiatan, 'kegiatan', $kegiatan, 'uraian');

            $uraian_komponen = $this->uraianRKAS($tb_komponen, 'kode_id', $kategori . $kegiatan . $komponen, 'uraian');

            $uraian_akun = $this->uraianRKAS($tb_akun, 'akun', $akun, 'uraian');
            $title_akun = $kode_kategori . ' : ' . $uraian_kategori . '  -   ' . $kegiatan .  ' : ' . $uraian_kegiatan . '  -   ' . $komponen . ' : ' . $uraian_komponen . ' - ' . $akun_custome . ' : ' . $uraian_akun;

            $link = new linkpage();
            $editdetail = "<a " . $link->pageID($id_detail, 'rkas/detail_edit') . " class='btn btn-light btn-xs d-inline' > <i class='bi bi-pencil-square text-secondary'></i></a>";

            $modal = new modal();
            //$deletedetail = $modal->modalRKAS('./view/rkas/detail_delete', 'delete_detail', $id_detail, $tahun, 'md', 'default', 'HAPUS', "<strong class='text-secondary'>HAPUS DETAIL</strong>", 'trash text-secondary', '', 'default', 'HAPUS DETAIL');
            $deletedetail = "<a " . $link->pageID($id_detail, 'rkas/detail_delete') . " class='btn btn-light btn-xs d-inline' > <i class='bi bi-trash text-secondary'></i></a>";

            $rowdetail = $akun_custome . '.' . $detail;

            //cek duplikat Detail
            //$classcekID = new cekID();
            //$countDetailID = $classcekID->count($tb_detail, 'detail_id', $detail_id);
            $crud = new crudData();
            $countDetailID = $crud->countData($tb_detail, "where detail_id='$detail_id' and revisi='$revisi'");

            if ($countDetailID > 1) {
                $warningduplikat = "#E9967A";
            } else {
                $warningduplikat = "#FFFFFF";
            };


            echo "
                 <tr bgcolor=$warningduplikat title='$title_akun'>
                     <td align=left width='104'></td>
                     <td align=left><span class='pl-1'><i class=''>$rowdetail - $uraian_detail</i></span></td>
                     <td align=center width='70'><i class=''>$volume</i></td>
                     <td align=left width='150'><i class=''>$unit</i></td>
                     <td align=right width='100'><i class=''>$harga</i></td>
                     <td align=right width='100'><i class=''>$total</i></td>
                     <td align=left width='130'><i class='$color_warning'>$kode_pembiayaan</i></td>
                     <td align=right width='130'><i class=''></i></td>
                     <td align=left width='130'><i class=''>$editdetail $deletedetail</i></td>
                 </tr>
                 ";
            $no++;
        }
    }

    //REFERENSI KATEGORI
    public function insertKegiatan()
    {
        $cekIssetPost = new cekissetPost;
        $cekID = new cekID;

        $uraian = $cekIssetPost->cek('uraian');
        $kode = $cekIssetPost->cek('kegiatan');
        $kode_cust = $cekIssetPost->cek('kegiatan_custome');

        $id = substr(md5($kode), 0, 15) . substr(md5($uraian), 5, 20);

        if ($kode >= 1000 and $kode < 2000) {
            $kategori = "A";
        } elseif ($kode >= 2000 and $kode < 3000) {
            $kategori = "B";
        } else {
            $kategori = "";
        };

        if ($kode_cust == "") {
            $kode_custome = $kode;
        } else {
            $kode_custome = $kode_cust;
        };

        if (isset($_POST['submit']) and $kategori != "") {
            $crud = new crudData();
            $array = [
                'id' => $id,
                'kegiatan' => $kode,
                'kegiatan_custome' => $kode_custome,
                'uraian' => $uraian,
                'kategori' => $kategori

            ];


            echo $cekDuplicate = $cekID->duplicate('simakom_ref_kegiatan', 'kegiatan', $kode, 'seting/kegiatan/kegiatan_read'); //cek Duplicate

            $save = $crud->insertData('simakom_ref_kegiatan', $array);
            $direct = new toast();
            echo  $direct->redirect('toast', 'save', 'seting/kegiatan/kegiatan_read');
        } elseif ($kategori == "") {
            echo "";
        } else {
            echo "";
        };
    }
    public function updateKegiatan()
    {

        $cekIssetPost = new cekissetPost;
        $cekID = new cekID;
        $classCrud = new crudData;

        $uraian = $cekIssetPost->cek('uraian');
        $kode = $cekIssetPost->cek('kegiatan');
        $kode_cust = $cekIssetPost->cek('kegiatan_custome');

        $id_old = htmlspecialchars(trim($_POST['id']));
        $id = substr(md5($kode), 0, 15) . substr(md5($uraian), 5, 20);

        $kegiatan_old = $classCrud->getValue('simakom_ref_kegiatan', "where id='$id_old'", 'kegiatan');

        if ($kode >= 1000 and $kode < 2000) {
            $kategori = "A";
        } elseif ($kode >= 2000 and $kode < 3000) {
            $kategori = "B";
        } else {
            $kategori = "";
        };
        if ($kode_cust == "") {
            $kode_custome = $kode;
        } else {
            $kode_custome = $kode_cust;
        };

        if (isset($_POST['submit']) and $kategori != "") {
            $crud = new crudData();
            $array = [
                'id' => $id,
                'kegiatan' => $kode,
                'kegiatan_custome' => $kode_custome,
                'uraian' => $uraian,
                'kategori' => $kategori
            ];

            echo  $cekID->duplicateUpdate('simakom_ref_kegiatan', 'kegiatan', $kode, $kegiatan_old, 'seting/kegiatan/kegiatan_read'); //cek Duplicate
            $update = $crud->updateData('simakom_ref_kegiatan', $array, ['id', ' = ', $id_old]);
            $direct = new toast();
            echo  $direct->redirect('toast', 'save', 'seting/kegiatan/kegiatan_read');
        } elseif ($kategori == "") {
            echo "";
        } else {
            echo "";
        };
    }

    //REFERENSI AKUN
    public function insertAkun()
    {
        $cekIssetPost = new cekissetPost;
        $cekID = new cekID;

        $uraian = $cekIssetPost->cek('uraian');
        $akun = $cekIssetPost->cek('akun');
        $akun_cust = $cekIssetPost->cek('akun_custome');

        $id = substr(md5($akun), 0, 15) . substr(md5($uraian), 5, 20);

        if ($akun >= 100000 and $akun < 200000) {
            $kategori = "A";
        } elseif ($akun >= 200000 and $akun < 300000) {
            $kategori = "B";
        } else {
            $kategori = "";
        };

        if ($akun_cust == "") {
            $akun_custome = $akun;
        } else {
            $akun_custome = $akun_cust;
        };

        if (isset($_POST['submit']) and $kategori != "") {
            $crud = new crudData();
            $array = [
                'id' => $id,
                'akun' => $akun,
                'akun_custome' => $akun_custome,
                'uraian' => $uraian,
                'kategori' => $kategori
            ];
            echo $cekDuplicate = $cekID->duplicate('simakom_ref_akun', 'akun', $akun, 'seting/akun/akun_read'); //cek Duplicate

            $save = $crud->insertData('simakom_ref_akun', $array);
            $direct = new toast();
            echo  $direct->redirect('toast', 'save', 'seting/akun/akun_read');
        } elseif ($kategori == "") {
            echo "";
        } else {
            echo "";
        };
    }
    public function updateAkun()
    {
        $cekIssetPost = new cekissetPost;
        $cekID = new cekID;
        $classCrud = new crudData;

        $uraian = $cekIssetPost->cek('uraian');
        $akun = $cekIssetPost->cek('akun');
        $akun_cust = $cekIssetPost->cek('akun_custome');

        $id_old = htmlspecialchars(trim($_POST['id']));

        $akun_old = $classCrud->getValue('simakom_ref_akun', "where id='$id_old'", 'akun');


        $id = substr(md5($akun), 0, 15) . substr(md5($uraian), 5, 20);

        if ($akun >= 100000 and $akun < 200000) {
            $kategori = "A";
        } elseif ($akun >= 200000 and $akun < 300000) {
            $kategori = "B";
        } else {
            $kategori = "";
        };

        if ($akun_cust == "") {
            $akun_custome = $akun;
        } else {
            $akun_custome = $akun_cust;
        };

        if (isset($_POST['submit']) and $kategori != "") {
            $crud = new crudData();
            $array = [
                'id' => $id,
                'akun' => $akun,
                'akun_custome' => $akun_custome,
                'uraian' => $uraian,
                'kategori' => $kategori
            ];

            echo  $cekID->duplicateUpdate('simakom_ref_akun', 'akun', $akun, $akun_old, 'seting/akun/akun_read'); //cek Duplicate

            $update = $crud->updateData('simakom_ref_akun', $array, ['id', ' = ', $id_old]);
            $direct = new toast();
            echo  $direct->redirect('toast', 'save', 'seting/akun/akun_read');
        } elseif ($kategori == "") {
            echo "";
        } else {
            echo "";
        };
    }

    //RKAS 
    public function deleteRKASKategori($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        if (isset($_POST['deletekategori'])) {
            $kategori = htmlspecialchars($_POST['kategori']);

            $db = database::getInstance();
            $del = $db->runQuery("DELETE FROM $tb_kegiatan WHERE kategori='$kategori'  and revisi='$revisi'");
            $del = $db->runQuery("DELETE FROM $tb_komponen WHERE kategori='$kategori'  and revisi='$revisi'");
            $del = $db->runQuery("DELETE FROM $tb_akun WHERE kategori='$kategori'  and revisi='$revisi'");
            $del = $db->runQuery("DELETE FROM $tb_detail WHERE kategori='$kategori'  and revisi='$revisi'");
            $direct = new toast();
            echo  $direct->redirect('toast', 'delete', 'rkas/index');
        } else {
            echo "";
        };
    }
    //Kegiatan
    public function insertRKASKegiatan($tahun, $tb_kegiatan, $tb_revisi)
    {
        if (isset($_POST['submit'])) {

            $kategori = $_POST['kategori'];
            $kegiatan = htmlspecialchars(trim($_POST['kegiatan']));

            $revisi = $this->maxRevisi($tb_revisi);
            //uraian kegiatan
            $class = new crudData();
            $sql = $class->editData('simakom_ref_kegiatan', 'kegiatan', $kegiatan);
            $data = $sql->fetch(PDO::FETCH_OBJ);
            $uraian = $data->uraian;
            $id = substr(md5($kategori), 0, 15) . substr(md5($kegiatan), 5, 20) . substr(md5($revisi), 0, 5);

            //cek duplikai
            $cek = new cekID();
            $cek->duplicate($tb_kegiatan, 'kegiatan',  $kegiatan, 'rkas/index');

            $kode_id = $kategori . $kegiatan;

            $crud = new crudData();
            $array = [
                'id' => $id,
                'kategori' => $kategori,
                'kegiatan' => $kegiatan,
                'uraian' => $uraian,
                'kode_id' => $kode_id,
                'revisi' => $revisi
            ];
            $save = $crud->insertData($tb_kegiatan, $array);
            $direct = new toast();
            echo  $direct->redirect('toast', 'save', 'rkas/index');
        } else {
            echo "";
        };
    }

    //Update RKASKegiatan
    public function updateRKASKegiatan($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kegiatan_old, $tb_revisi)
    {
        if (isset($_POST['submitUpdateKegiatan'])) {

            $kategori = htmlspecialchars($_POST['kategori']);
            $kegiatan_new = htmlspecialchars($_POST['kegiatan_new']);
            $kegiatan_old = htmlspecialchars($_POST['kegiatan_old']);
            $kegiatan_id = htmlspecialchars($_POST['kegiatan_id']);

            $kode_id = $kategori . $kegiatan_new;

            $uraian = $this->uraianRKAS('simakom_ref_kegiatan', 'kegiatan', $kegiatan_new, 'uraian');

            $revisi = $this->maxRevisi($tb_revisi);

            $crud = new crudData();
            $db = database::getInstance();
            //Update Kegaatan pada Detail
            $show_detail = $db->runQuery("SELECT * FROM   {$tb_detail}  where kategori='{$kategori}' and kegiatan='{$kegiatan_old}' and revisi='$revisi'");
            while ($data_detail = $show_detail->fetch(PDO::FETCH_OBJ)) {
                $kode = $data_detail->kode_id;
                $digit_komp = strlen($kode);
                $komp = $data_detail->komponen;
                $kode_id_detail = $kategori . $kegiatan_new . $komp;
                $detail_id = $kategori . $kegiatan_new . $data_detail->komponen . $data_detail->akun . $data_detail->detail . "00";
                $id_detail = $data_detail->id;
                $crud = new crudData();
                $array = [
                    'kategori' => $kategori,
                    'kegiatan' => $kegiatan_new,
                    'komponen' => $data_detail->komponen,
                    'akun' => $data_detail->akun,
                    'detail_id' => $detail_id,
                    'kode_id' => $kode_id_detail
                ];
                $crud->updateData($tb_detail, $array, ['id', ' = ', $id_detail]);
            }


            $array = [
                'kategori' => $kategori,
                'kegiatan' => $kegiatan_new,
                'uraian' => $uraian,
                'id' => $kegiatan_id,
                'kode_id' => $kode_id,
                'revisi' => $revisi
            ];
            $save = $crud->updateData($tb_kegiatan, $array, ['id', ' = ', $kegiatan_id]);

            //Update Kegiatan pada Komponen

            $show_komp = $db->runQuery("SELECT * FROM   {$tb_komponen}  where kategori='{$kategori}' and kegiatan='{$kegiatan_old}' and revisi='$revisi'");
            while ($data_komp = $show_komp->fetch(PDO::FETCH_OBJ)) {
                $kode = $data_komp->kode_id;
                $digit_komp = strlen($kode);
                $komp = $data_komp->komponen;
                $kode_id_detail = $kategori . $kegiatan_new . $komp;

                $crud = new crudData();
                $array = [
                    'kegiatan' => $kegiatan_new,
                    'kode_id' => $kode_id_detail
                ];
                $crud->updateData($tb_komponen, $array, ['kegiatan', ' = ', $kegiatan_old]);
            }

            //Update Kegiatan pada Akun
            $show_akun = $db->runQuery("SELECT * FROM   {$tb_akun}  where kategori='{$kategori}' and kegiatan='{$kegiatan_old}' and revisi='$revisi'");
            while ($data_akun = $show_akun->fetch(PDO::FETCH_OBJ)) {
                $kode = $data_akun->kode_id;
                $digit_komp = strlen($kode);
                $komp = $data_akun->komponen;
                $kode_id_detail = $kategori . $kegiatan_new . $komp;
                $crud = new crudData();
                $array = [
                    'kategori' => $kategori,
                    'kegiatan' => $kegiatan_new,
                    'komponen' => $data_akun->komponen,
                    'akun' => $data_akun->akun,
                    'kode_id' => $kode_id_detail
                ];
                $crud->updateData($tb_akun, $array, ['kegiatan', ' = ', $kegiatan_old]);
            }



            $direct = new toast();
            echo  $direct->redirect('toast', 'update', 'rkas/index');
        } else {
            echo "";
        };
    }

    public function deleteRKASKkegiatan($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $id_kegiatan, $tb_revisi)
    {
        if (isset($_POST['deleteKegiatan'])) {

            $kategori = htmlspecialchars($_POST['kategori']);
            $kegiatan = htmlspecialchars($_POST['kegiatan']);

            $revisi = $this->maxRevisi($tb_revisi);

            $db = database::getInstance();
            $del = $db->runQuery("DELETE FROM $tb_kegiatan WHERE id='$id_kegiatan' and revisi='$revisi' ");
            $del = $db->runQuery("DELETE FROM $tb_komponen WHERE kegiatan='$kegiatan' and revisi='$revisi'");
            $del = $db->runQuery("DELETE FROM $tb_akun WHERE kegiatan='$kegiatan' and revisi='$revisi'");
            $del = $db->runQuery("DELETE FROM $tb_detail WHERE kegiatan='$kegiatan' and revisi='$revisi'");

            $direct = new toast();
            echo  $direct->redirect('toast', 'delete', 'rkas/index');
        } else {
            echo "";
        };
    }

    //Komponen
    public function insertRKASKomponen($tahun, $tb_kegiatan, $tb_komponen, $tb_revisi)
    {
        if (isset($_POST['submitKomponen'])) {

            $time = new time;
            $kegiatan = htmlspecialchars(trim($_POST['kegiatan']));
            $class = new crudData();
            $sql = $class->editData($tb_kegiatan, 'kegiatan', $kegiatan);
            $data = $sql->fetch(PDO::FETCH_OBJ);
            $kategori = $data->kategori;

            $komponen = htmlspecialchars(trim($_POST['komponen'])); //Komponen

            $kode_id = $kategori . $kegiatan . $komponen;

            $uraian = $_POST['uraian'];
            $id = substr(md5($kategori), 0, 5) . substr(md5($kegiatan), 5, 10) . substr(md5($komponen), 5,) . substr($time->getTime(), 2, 5);

            $revisi = $this->maxRevisi($tb_revisi);

            //cek duplikai
            $cek = new cekID();
            // $cek->duplicate($tb_komponen, 'id',  $id, 'rkas/index');
            $cek->duplicateByKondisi($tb_komponen, "where kategori='$kategori' && kegiatan='$kegiatan' && komponen='$komponen'", 'rkas/index');

            $crud = new crudData();
            $array = [
                'kategori' => $kategori,
                'kegiatan' => $kegiatan,
                'komponen' => $komponen,
                'uraian' => $uraian,
                'id' => $id,
                'kode_id' => $kode_id,
                'revisi' => $revisi
            ];
            $save = $crud->insertData($tb_komponen, $array);
            $direct = new toast();
            echo  $direct->redirect('toast', 'save', 'rkas/index');
        } else {
            echo "";
        };
    }

    public function updateRKASKomponen($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $oldKomValue, $tb_revisi, $id_komponen, $kategori, $kegiatan, $komponen_old, $komponen_new)

    {
        $crud = new crudData();


        $countCodeKomp = $crud->countData($tb_komponen, "where kategori='$kategori' && kegiatan='$kegiatan' && komponen='$komponen_new'");

        if (isset($_POST['submitUpdateKomponen']) && (($countCodeKomp < 1 && $komponen_old != $komponen_new) || ($countCodeKomp >= 1 && $komponen_old == $komponen_new))) {

            $revisi = $this->maxRevisi($tb_revisi);

            $db = database::getInstance();
            //Kode_ID 
            $kategori = htmlspecialchars($_POST['kategori']);
            $kegiatan = htmlspecialchars($_POST['kegiatan']);
            $komponen_new = htmlspecialchars($_POST['komponen']);
            $uraian_new = htmlspecialchars($_POST['uraian']);
            $kode_id = $kategori . $kegiatan . $komponen_new;
            $kode_id_akun = $kategori . $kegiatan . $oldKomValue;


            //Update Komponen pada Detail
            $show_detail = $db->runQuery("SELECT * FROM   {$tb_detail}  where kategori='{$kategori}' and kegiatan='{$kegiatan}' and komponen='{$oldKomValue}' and revisi='$revisi'");
            while ($dataDetail = $show_detail->fetch(PDO::FETCH_OBJ)) {

                if (strlen($dataDetail->detail) == 1) {
                    $detail = "00" . $dataDetail->detail;
                } elseif (strlen($dataDetail->detail) == 2) {
                    $detail = "0" . $dataDetail->detail;
                } else {
                    $detail = $dataDetail->detail;
                }
                $id_detail = $dataDetail->id;
                $detail_id = $kategori . $kegiatan . $komponen_new . $dataDetail->akun . $detail . "00";

                $cek = new cekID();
                //$cek->duplicateByKondisi($tb_komponen, "where kategori='$kategori' && kegiatan='$kegiatan' && komponen='$komponen_new'", 'rkas/index');


                $crud = new crudData();
                $array = [
                    'kategori' => $kategori,
                    'kegiatan' => $kegiatan,
                    'komponen' => $komponen_new,
                    'akun' => $dataDetail->akun,
                    'detail_id' => $detail_id,
                    'kode_id' => $kode_id
                ];
                $crud->updateData($tb_detail, $array, ['id', ' = ', $id_detail]);
            }
            $array = [
                'kategori' => $kategori,
                'kegiatan' => $kegiatan,
                'komponen' => $komponen_new,
                'uraian' => $uraian_new,
                'id' => $id_komponen,
                'kode_id' => $kode_id,
                'revisi' => $revisi
            ];
            $crud->updateData($tb_komponen, $array, ['id', ' = ', $id_komponen]);

            //Update Komponen pada Akun

            $show = $db->runQuery("SELECT * FROM   {$tb_akun}  where kategori='{$kategori}' and kegiatan='{$kegiatan}' and komponen='{$oldKomValue}'  and revisi='$revisi'");
            while ($data = $show->fetch(PDO::FETCH_OBJ)) {
                $crud = new crudData();
                $array = [
                    'komponen' => $komponen_new,
                    'kode_id' => $kode_id
                ];
                $crud->updateData($tb_akun, $array, ['kode_id', ' = ', $kode_id_akun]);
            }

            $direct = new toast();
            echo  $direct->redirect('toast', 'update', 'rkas/index');
        } elseif (isset($_POST['submitUpdateKomponen']) && $countCodeKomp > 1) {
            $direct = new toast();
            echo  $direct->redirect('toast', 'duplicate', 'rkas/index');
        } else {
            echo "";
        };
    }
    public function deleteRKASKomponen($tb_komponen, $tb_akun, $tb_detail, $tb_revisi)
    {
        if (isset($_POST['deleteKomponen'])) {

            $kategori = htmlspecialchars($_POST['kategori']);
            $kegiatan = htmlspecialchars($_POST['kegiatan']);
            $komponen = htmlspecialchars($_POST['komponen']);
            $kode_id = $kategori . $kegiatan . $komponen;

            $revisi = $this->maxRevisi($tb_revisi);

            $db = database::getInstance();
            $del = $db->runQuery("DELETE FROM $tb_komponen WHERE kode_id='$kode_id' and revisi='$revisi'");
            $del = $db->runQuery("DELETE FROM $tb_akun WHERE kode_id='$kode_id' and revisi='$revisi' ");
            $del = $db->runQuery("DELETE FROM $tb_detail WHERE kode_id='$kode_id' and revisi='$revisi'");

            $direct = new toast();
            echo  $direct->redirect('toast', 'delete', 'rkas/index');
        } else {
            echo "";
        };
    }

    //Akun
    public function insertRKASAkun($tahun, $tb_akun, $tb_revisi, $akun)
    {
        if (isset($_POST['submitAkun'])) {

            $kategori = htmlspecialchars($_POST['kategori']);
            $kegiatan = htmlspecialchars($_POST['kegiatan']);
            $komponen = htmlspecialchars($_POST['komponen']);
            //$akun = $_POST['akun'];

            $kode_id = $kategori . $kegiatan . $komponen;
            $akun_id = $kategori . $kegiatan . $akun . $komponen;

            $id = substr(md5($akun), 6, 5) . substr(md5($kategori), 0, 5) . substr(md5($kegiatan), 3, 5) . substr(md5($komponen), 5, 10);

            $uraian = $this->uraianRKAS('simakom_ref_akun', 'akun', $akun, 'uraian');

            $revisi = $this->maxRevisi($tb_revisi);

            //cek duplikai
            $cek = new cekID();
            $cek->duplicateByKondisi($tb_akun, "where kategori='$kategori' && kegiatan='$kegiatan' && komponen='$komponen' && akun='$akun'", 'rkas/index');


            $crud = new crudData();
            $array = [
                'kategori' => $kategori,
                'kegiatan' => $kegiatan,
                'komponen' => $komponen,
                'akun' => $akun,
                'uraian' => $uraian,
                'id' => $id,
                'kode_id' => $kode_id,
                'akun_id' => $akun_id,
                'revisi' => $revisi
            ];
            $save = $crud->insertData($tb_akun, $array);
            $direct = new toast();
            echo  $direct->redirect('toast', 'save', 'rkas/index');
        } else {
            echo "";
        };
    }

    public function updateRKASAkun($tb_akun, $tb_detail, $oldValue, $tb_revisi, $kategori, $kegiatan, $komponen, $akun_new, $id)
    {
        if (isset($_POST['submitUpdateAkun'])) {

            //$kategori = htmlspecialchars($_POST['kategori']);
            //$kegiatan = htmlspecialchars($_POST['kegiatan']);
            //$komponen = htmlspecialchars($_POST['komponen']);

            $kode_id = $kategori . $kegiatan . $komponen;
            $akun_id = $kategori . $kegiatan . $akun_new . $komponen;

            $uraian = $this->uraianRKAS('simakom_ref_akun', 'akun', $akun_new, 'uraian');

            $revisi = $this->maxRevisi($tb_revisi);

            //cek duplikai
            $cek = new cekID();
            $cek->duplicateByKondisi($tb_akun, "where kategori='$kategori' && kegiatan='$kegiatan' && komponen='$komponen' && akun='$akun_new'", 'rkas/index');


            $crud = new crudData();

            //Update Akun pada Detail
            $db = database::getInstance();
            $show = $db->runQuery("SELECT * FROM   {$tb_detail}  where akun='{$oldValue}' and komponen='{$komponen}' and kegiatan='{$kegiatan}' and revisi='$revisi'");
            while ($dataDetail = $show->fetch(PDO::FETCH_OBJ)) {
                $id_detail = $dataDetail->id;
                if (strlen($dataDetail->detail) == 1) {
                    $detail = "00" . $dataDetail->detail;
                } elseif (strlen($dataDetail->detail) == 2) {
                    $detail = "0" . $dataDetail->detail;
                } else {
                    $detail = $dataDetail->detail;
                }
                $detail_id = $kategori . $kegiatan . $dataDetail->komponen . $akun_new . $detail . "00";


                $arraydetail = [
                    'kategori' => $kategori,
                    'kegiatan' => $kegiatan,
                    'komponen' => $komponen,
                    'akun' => $akun_new,
                    'detail_id' => $detail_id
                ];
                $crud->updateData($tb_detail, $arraydetail, ['id', ' = ', $id_detail]);
            }

            //Update Ref Akun
            $array = [
                'kategori' => $kategori,
                'kegiatan' => $kegiatan,
                'komponen' => $komponen,
                'akun' => $akun_new,
                'uraian' => $uraian,
                'id' => $id,
                'kode_id' => $kode_id,
                'akun_id' => $akun_id,
                'revisi' => $revisi
            ];
            $save = $crud->updateData($tb_akun, $array, ['id', ' = ', $id]);

            $direct = new toast();
            echo  $direct->redirect('toast', 'update', 'rkas/index');
        } else {
            echo "";
        };
    }

    public function deleteRKASAkun($tb_akun, $tb_detail, $key, $tb_revisi, $id)
    {
        if (isset($_POST['deleteAkun'])) {
            $kategori = htmlspecialchars($_POST['kategori']);
            $kegiatan = htmlspecialchars($_POST['kegiatan']);
            $komponen = htmlspecialchars($_POST['komponen']);
            $akun = htmlspecialchars(trim($_POST['old_akun']));

            $crud = new crudData();
            $crud->deleteData($tb_akun, $key, $id);

            $revisi = $this->maxRevisi($tb_revisi);

            $db = database::getInstance();
            $del = $db->runQuery("DELETE FROM $tb_detail WHERE akun='{$akun}' and komponen='{$komponen}' and kegiatan='{$kegiatan}' and kategori='{$kategori}'  and revisi='$revisi'");

            $direct = new toast();
            echo  $direct->redirect('toast', 'delete', 'rkas/index');
        } else {
            echo "";
        };
    }

    //Detail/Rincian
    public function insertRKASDetail($tb_akun, $tb_detail, $tb_revisi)
    {
        if (isset($_POST['submitDetail'])) {

            $kategori = htmlspecialchars($_POST['kategori']);
            $kegiatan = htmlspecialchars($_POST['kegiatan']);
            $komponen = htmlspecialchars($_POST['komponen']);
            $akun = htmlspecialchars(trim($_POST['akun']));

            $detail = htmlspecialchars(trim($_POST['detail']));
            if (strlen($detail) == 1) {
                $detail = "00" . $detail;
            } elseif (strlen($detail) == 2) {
                $detail = "0" . $detail;
            } else {
                $detail = $detail;
            }

            $uraian = htmlspecialchars(trim($_POST['uraian']));
            $komponen_1 = htmlspecialchars($_POST['komponen_1']);
            $komponen_2 = htmlspecialchars($_POST['komponen_2']);
            $komponen_3 = htmlspecialchars($_POST['komponen_3']);
            $komponen_4 = htmlspecialchars($_POST['komponen_4']);
            $unit_1 = htmlspecialchars($_POST['unit_1']);
            $unit_2 = htmlspecialchars($_POST['unit_2']);
            $unit_3 = htmlspecialchars($_POST['unit_3']);
            $unit_4 = htmlspecialchars($_POST['unit_4']);
            $volume = htmlspecialchars($_POST['volume']);
            $unit = htmlspecialchars($_POST['unit']);
            $harga = htmlspecialchars($_POST['harga']);
            $total = htmlspecialchars($_POST['total']);

            if (isset($_POST['pembiayaan'])) {
                $pembiayaan = htmlspecialchars($_POST['pembiayaan']);
                $class = new crudData();
                $sql_akun = $class->editData($tb_detail, 'id', $pembiayaan);
                $data_akun = $sql_akun->fetch(PDO::FETCH_OBJ);
                $pembiayaan_kegiatan = $data_akun->kegiatan;
                $pembiayaan_komponen = $data_akun->komponen;
                $pembiayaan_akun = $data_akun->akun;
                $pembiayaan_id = $data_akun->detail_id;
            } else {
                $pembiayaan_kegiatan = "";
                $pembiayaan_komponen = "";
                $pembiayaan_akun = "";
                $pembiayaan_id = "";
            };

            $id = substr(md5($akun), 6, 3) . substr(md5($uraian), 0, 4) . substr(md5($volume), 3, 4) . substr(md5($harga), 5, 7) . substr(md5($total), 5, 7) . substr(md5($pembiayaan_akun), 5, 7);
            $kode_id = $kategori . $kegiatan . $komponen;

            $class_time = new time();
            $time = $class_time->getTime();

            $revisi_ori = $this->maxRevisi($tb_revisi);
            if ($revisi_ori < 10) {
                $revisi = "0" . $revisi_ori;
            } else {
                $revisi = $revisi_ori;
            };


            //$detail_id = $kategori . $kegiatan . $komponen . $akun . $detail . $revisi;
            $detail_id = $kategori . $kegiatan . $komponen . $akun . $detail . "00";
            $crud = new crudData();
            $array = [
                'kategori' => $kategori,
                'kegiatan' => $kegiatan,
                'komponen' => $komponen,
                'akun' => $akun,
                'detail' => $detail,
                'detail_id' => $detail_id,
                'komponen_1' => $komponen_1,
                'komponen_2' => $komponen_2,
                'komponen_3' => $komponen_3,
                'komponen_4' => $komponen_4,
                'unit_1' => $unit_1,
                'unit_2' => $unit_2,
                'unit_3' => $unit_3,
                'unit_4' => $unit_4,
                'volume' => $volume,
                'unit' => $unit,
                'satuan' => $harga,
                'total' => $total,
                'uraian' => $uraian,
                'pembiayaan_id' => $pembiayaan_id,
                'pembiayaan_kegiatan' => $pembiayaan_kegiatan,
                'pembiayaan_komponen' => $pembiayaan_komponen,
                'pembiayaan_akun' => $pembiayaan_akun,
                'time' => $time,
                'id' => $id,
                'kode_id' => $kode_id,
                'revisi' => $revisi_ori
            ];
            $save = $crud->insertData($tb_detail, $array);
            $direct = new toast();
            echo  $direct->redirect('toast', 'save', 'rkas/index');
        } else {
            echo "";
        };
    }

    public function updateRKASDetail($tb_akun, $tb_detail, $tb_revisi, $id)
    {
        if (isset($_POST['submitDetail'])) {

            $kategori = htmlspecialchars($_POST['kategori']);
            $kegiatan = htmlspecialchars($_POST['kegiatan']);
            $komponen = htmlspecialchars($_POST['komponen']);
            $akun = htmlspecialchars(trim($_POST['akun']));
            $detail_ori = htmlspecialchars(trim($_POST['detail']));
            if (strlen($detail_ori) == 1) {
                $detail = "00" . $detail_ori;
            } elseif (strlen($detail_ori) == 2) {
                $detail = "0" . $detail_ori;
            } else {
                $detail = $detail_ori;
            }

            $uraian = htmlspecialchars(trim($_POST['uraian']));
            $komponen_1 = htmlspecialchars($_POST['komponen_1']);
            $komponen_2 = htmlspecialchars($_POST['komponen_2']);
            $komponen_3 = htmlspecialchars($_POST['komponen_3']);
            $komponen_4 = htmlspecialchars($_POST['komponen_4']);
            $unit_1 = htmlspecialchars($_POST['unit_1']);
            $unit_2 = htmlspecialchars($_POST['unit_2']);
            $unit_3 = htmlspecialchars($_POST['unit_3']);
            $unit_4 = htmlspecialchars($_POST['unit_4']);
            $volume = htmlspecialchars($_POST['volume']);
            $unit = htmlspecialchars($_POST['unit']);
            $harga = htmlspecialchars($_POST['harga']);
            $total = htmlspecialchars($_POST['total']);

            if (isset($_POST['pembiayaan'])) {
                $pembiayaan = htmlspecialchars($_POST['pembiayaan']);
                $class = new crudData();
                $sql_akun = $class->editData($tb_detail, 'id', $pembiayaan);
                $data_akun = $sql_akun->fetch(PDO::FETCH_OBJ);
                $pembiayaan_kegiatan = $data_akun->kegiatan;
                $pembiayaan_komponen = $data_akun->komponen;
                $pembiayaan_akun = $data_akun->akun;
                $pembiayaan_id = $data_akun->detail_id;
            } else {
                $pembiayaan_kegiatan = "";
                $pembiayaan_komponen = "";
                $pembiayaan_akun = "";
                $pembiayaan_id = "";
            };

            $kode_id = $kategori . $kegiatan . $komponen;

            $class_time = new time();
            $time = $class_time->getTime();

            $revisi_ori = $this->maxRevisi($tb_revisi);
            if ($revisi_ori < 10) {
                $revisi = "0" . $revisi_ori;
            } else {
                $revisi = $revisi_ori;
            };
            //$detail_id = $kategori . $kegiatan . $komponen . $akun . $detail . $revisi;
            $detail_id = $kategori . $kegiatan . $komponen . $akun . $detail . "00";
            $crud = new crudData();
            $array = [
                'kategori' => $kategori,
                'kegiatan' => $kegiatan,
                'komponen' => $komponen,
                'akun' => $akun,
                'detail' => $detail_ori,
                'detail_id' => $detail_id,
                'komponen_1' => $komponen_1,
                'komponen_2' => $komponen_2,
                'komponen_3' => $komponen_3,
                'komponen_4' => $komponen_4,
                'unit_1' => $unit_1,
                'unit_2' => $unit_2,
                'unit_3' => $unit_3,
                'unit_4' => $unit_4,
                'volume' => $volume,
                'unit' => $unit,
                'satuan' => $harga,
                'total' => $total,
                'uraian' => $uraian,
                'pembiayaan_id' => $pembiayaan_id,
                'pembiayaan_kegiatan' => $pembiayaan_kegiatan,
                'pembiayaan_komponen' => $pembiayaan_komponen,
                'pembiayaan_akun' => $pembiayaan_akun,
                'time' => $time,
                'id' => $id,
                'kode_id' => $kode_id,
                'revisi' => $revisi_ori
            ];

            $update = $crud->updateData($tb_detail, $array, ['id', ' = ', $id]);

            $direct = new toast();
            echo  $direct->redirect('toast', 'update', 'rkas/index');
        } else {
            echo "";
        };
    }

    //($tb_detail, $key, $tb_revisi, $detail_id);
    //deleteRKASDetail
    public function deleteRKASDetail($tb_detail, $tb_revisi, $id)
    {
        if (isset($_POST['deleteDet'])) {
            $revisi = $this->maxRevisi($tb_revisi);
            $db = database::getInstance();
            $del = $db->runQuery("DELETE FROM {$tb_detail} WHERE id='$id'");
            // and revisi='$revisi'
            $direct = new toast();
            echo  $direct->redirect('toast', 'delete', 'rkas/index');
        } else {
            echo "";
        };
    }


    public function viewPerhitungan($kom1, $kom2, $kom3, $kom4, $unit1, $unit2, $unit3, $unit4)
    {
        if ($kom1 == '' && $unit1 == '') {
            $value1 = "";
        } else {
            $value1 = $kom1 . ' ' . $unit1;
        };
        if ($kom2 == '' && $unit2 == '') {
            $value2 = "";
        } else {
            $value2 = ' x ' . $kom2 . ' ' . $unit2;
        };
        if ($kom3 == '' && $unit3 == '') {
            $value3 = "";
        } else {
            $value3 = ' x ' . $kom3 . ' ' . $unit3;
        };
        if ($kom4 == '' && $unit4 == '') {
            $value4 = "";
        } else {
            $value4 = ' x ' . $kom4 . ' ' . $unit4;
        };

        if ($kom1 == "" and $kom2 == "" and $kom3 == "" and $kom4 == "" and $unit1 == "" and $unit2 == "" and $unit3 == "" and $unit4 == "") {
            $value = "";
        } else {
            $value = "[" . $value1 . $value2 . $value3 . $value4 . "]";
        };

        return $value;
    }

    public function uraianRKAS($tabel, $key, $id, $field)
    {

        $crud = new crudData;
        if ($crud->getValue($tabel, "where {$key}='{$id}'", $field) != NUll) {
            $value = $crud->getValue($tabel, "where {$key}='{$id}'", $field);
        } else {
            $value = "";
        };
        return $value;
    }


    public function kodeCustome($tabel, $key, $id, $field)
    {
        //$db = database::getInstance();
        //$show = $db->runQuery("SELECT * FROM   {$tabel}  WHERE {$key}= '{$id}'");
        //$cust = $show->fetch(PDO::FETCH_OBJ);
        //$value = $cust->$field;

        $crud = new crudData;
        $value = $crud->getValue($tabel, "where {$key}='{$id}'", $field);
        return $value;
    }

    //REVISI 
    public function createHistory($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $tb_revisi)
    {
        $classTime = new time();
        $dateNow = $classTime->getDate();
        $timeNow = $classTime->getTime();
        $id = substr(md5($dateNow), 0, 15) . substr(md5($timeNow), 5, 20);

        $class_cekRevisi = new cekID();
        $count_revisi = $class_cekRevisi->cekRevisi($tb_revisi);

        if ($count_revisi == 0) {
            $revisi = 0;
        } elseif ($count_revisi == 1) {
            $revisi = 1;
        } else {
            $revisi = $count_revisi;
        };

        $crud = new crudData();
        $array = [
            'revisi' => $revisi,
            'tanggal' => $dateNow,
            'time' => $timeNow,
            'id' => $id
        ];
        $save = $crud->insertData($tb_revisi, $array);

        $this->copyHistoryKegiatan($tb_kegiatan, $tb_revisi);
        $this->copyHistoryKomponen($tb_komponen, $tb_revisi);
        $this->copyHistoryAkun($tb_akun, $tb_revisi);
        $this->copyHistoryDetail($tb_detail, $tb_revisi);

        $direct = new toast();
        echo  $direct->redirect('toast', 'save', 'rkas/revisi_read');
    }

    public function copyHistoryKegiatan($tb_kegiatan, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        $revisi_old = $revisi - 1;

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_kegiatan}  WHERE revisi='$revisi_old'");
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $no = $data->no;
            $kategori = $data->kategori;
            $kegiatan = $data->kegiatan;
            $uraian = $data->uraian;
            $kode_id = $data->kode_id;
            $id = substr(md5($kategori), 0, 15) . substr(md5($kegiatan), 5, 20) . substr(md5($revisi . $no), 0, 5);
            $crud = new crudData();
            $array = [
                'id' => $id,
                'kategori' => $kategori,
                'kegiatan' => $kegiatan,
                'uraian' => $uraian,
                'kode_id' => $kode_id,
                'revisi' => $revisi
            ];
            $class = new crudData();
            $save = $class->insertData($tb_kegiatan, $array);
        }
    }
    public function copyHistoryKomponen($tb_komponen, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        $revisi_old = $revisi - 1;

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_komponen}  WHERE revisi='$revisi_old'");
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $no = $data->no;
            $kategori = $data->kategori;
            $kegiatan = $data->kegiatan;
            $komponen = $data->komponen;
            $uraian = $data->uraian;
            $kode_id = $data->kode_id;
            $id = substr(md5($kategori), 0, 15) . substr(md5($kegiatan), 5, 10) .  substr(md5($komponen), 5, 10) . substr(md5($revisi . $no), 0, 5);
            $crud = new crudData();
            $array = [
                'id' => $id,
                'kategori' => $kategori,
                'kegiatan' => $kegiatan,
                'komponen' => $komponen,
                'uraian' => $uraian,
                'kode_id' => $kode_id,
                'revisi' => $revisi
            ];
            $class = new crudData();
            $save = $class->insertData($tb_komponen, $array);
        }
    }
    public function copyHistoryAkun($tb_akun, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        $revisi_old = $revisi - 1;

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_akun}  WHERE revisi='$revisi_old'");
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $no = $data->no;
            $kategori = $data->kategori;
            $kegiatan = $data->kegiatan;
            $komponen = $data->komponen;
            $akun = $data->akun;
            $uraian = $data->uraian;
            $kode_id = $data->kode_id;
            $akun_id = $data->akun_id;
            $id = substr(md5($kategori), 0, 10) . substr(md5($kegiatan), 5, 10) .  substr(md5($komponen), 5, 10) .  substr(md5($akun), 5, 5)  . substr(md5($revisi . $no), 0, 5);
            $crud = new crudData();
            $array = [
                'id' => $id,
                'kategori' => $kategori,
                'kegiatan' => $kegiatan,
                'komponen' => $komponen,
                'akun' => $akun,
                'uraian' => $uraian,
                'kode_id' => $kode_id,
                'akun_id' => $akun_id,
                'revisi' => $revisi
            ];
            $class = new crudData();
            $save = $class->insertData($tb_akun, $array);
        }
    }
    public function copyHistoryDetail($tb_detail, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        $revisi_old = $revisi - 1;

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_detail}  WHERE revisi='$revisi_old'");
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $no = $data->no;
            $kategori = $data->kategori;
            $kegiatan = $data->kegiatan;
            $komponen = $data->komponen;
            $akun = $data->akun;
            $detail = $data->detail;
            $detail_id = $data->detail_id;
            //$detail_id = $kategori . $kegiatan . $komponen . $akun . $detail . $revisi;
            $uraian = $data->uraian;
            $kode_id = $data->kode_id;

            $komponen_1 = $data->komponen_1;
            $komponen_2 = $data->komponen_2;
            $komponen_3 = $data->komponen_3;
            $komponen_4 = $data->komponen_4;
            $unit_1 = $data->unit_1;
            $unit_2 = $data->unit_2;
            $unit_3 = $data->unit_3;
            $unit_4 = $data->unit_4;
            $volume = $data->volume;
            $unit = $data->unit;
            $harga = $data->satuan;
            $total = $data->total;
            $pembiayaan_id = $data->pembiayaan_id;
            $pembiayaan_kegiatan = $data->pembiayaan_kegiatan;
            $pembiayaan_komponen = $data->pembiayaan_komponen;
            $pembiayaan_akun = $data->pembiayaan_akun;

            $id = substr(md5($akun), 6, 3) . substr(md5($uraian), 0, 4) . substr(md5($volume), 3, 4) . substr(md5($harga), 5, 5) . substr(md5($total), 5, 5) . substr(md5($pembiayaan_akun), 5, 6) . substr(md5($revisi . $no), 0, 5);

            $class_time = new time();
            $time = $class_time->getTime();

            $array = [
                'kategori' => $kategori,
                'kegiatan' => $kegiatan,
                'komponen' => $komponen,
                'akun' => $akun,
                'detail' => $detail,
                'detail_id' => $detail_id,
                'komponen_1' => $komponen_1,
                'komponen_2' => $komponen_2,
                'komponen_3' => $komponen_3,
                'komponen_4' => $komponen_4,
                'unit_1' => $unit_1,
                'unit_2' => $unit_2,
                'unit_3' => $unit_3,
                'unit_4' => $unit_4,
                'volume' => $volume,
                'unit' => $unit,
                'satuan' => $harga,
                'total' => $total,
                'uraian' => $uraian,
                'pembiayaan_id' => $pembiayaan_id,
                'pembiayaan_kegiatan' => $pembiayaan_kegiatan,
                'pembiayaan_komponen' => $pembiayaan_komponen,
                'pembiayaan_akun' => $pembiayaan_akun,
                'time' => $time,
                'id' => $id,
                'kode_id' => $kode_id,
                'revisi' => $revisi
            ];
            $class = new crudData();
            $save = $class->insertData($tb_detail, $array);
        }
    }
    public function maxDetail($tb_detail, $kategori, $kegiatan, $komponen, $akun)
    {
        $db = database::getInstance();
        $sql = $db->runQuery("SELECT max(detail) as maksimal FROM {$tb_detail} where kategori='$kategori' and kegiatan='$kegiatan' and komponen='$komponen' and akun='$akun'");
        $max = $sql->fetch();
        $value = $max['maksimal'];
        return $value;
    }

    public function deleteHistory($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $tb_revisi, $revisi)
    {

        $db = database::getInstance();
        $del = $db->runQuery("DELETE FROM $tb_revisi WHERE revisi='$revisi' ");
        $del = $db->runQuery("DELETE FROM $tb_kegiatan WHERE revisi='$revisi' ");
        $del = $db->runQuery("DELETE FROM $tb_komponen WHERE revisi='$revisi' ");
        $del = $db->runQuery("DELETE FROM $tb_akun WHERE revisi='$revisi' ");
        $del = $db->runQuery("DELETE FROM $tb_detail WHERE revisi='$revisi' ");

        $direct = new toast();
        echo  $direct->redirect('toast', 'delete', 'rkas/revisi_read');
    }



    public function maxRevisi($tb_revisi)
    {
        $db = database::getInstance();
        $sql = $db->runQuery("SELECT max(revisi) as maksimal FROM {$tb_revisi}");
        $max = $sql->fetch();
        $value = $max['maksimal'];
        return $value;
    }

    //IMPORT TL 
    public function createImport($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $tb_revisi, $tb_kegiatan_tl, $tb_komponen_tl, $tb_akun_tl, $tb_detail_tl, $tb_revisi_tl)
    {
        $classTime = new time();
        $dateNow = $classTime->getDate();
        $timeNow = $classTime->getTime();
        $id = substr(md5($dateNow), 0, 15) . substr(md5($timeNow), 5, 20);

        $crud = new crudData();
        $array = [
            'revisi' => '0',
            'tanggal' => $dateNow,
            'time' => $timeNow,
            'id' => $id
        ];
        $save = $crud->insertData($tb_revisi, $array);

        $this->copyTLKegiatan($tb_kegiatan, $tb_kegiatan_tl, $tb_revisi_tl);
        $this->copyTLKomponen($tb_komponen, $tb_komponen_tl, $tb_revisi_tl);
        $this->copyTLAkun($tb_akun, $tb_akun_tl, $tb_revisi_tl);
        $this->copyTLDetail($tb_detail, $tb_detail_tl, $tb_revisi_tl);

        $direct = new toast();
        echo  $direct->redirect('toast', 'save', 'rkas/index');
    }
    public function copyTLKegiatan($tb_kegiatan, $tb_kegiatan_tl, $tb_revisi_tl)
    {
        $revisi = $this->maxRevisi($tb_revisi_tl);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_kegiatan_tl}  WHERE revisi='$revisi'");
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $no = $data->no;
            $kategori = $data->kategori;
            $kegiatan = $data->kegiatan;
            $uraian = $data->uraian;
            $kode_id = $data->kode_id;
            $id = substr(md5($kategori), 0, 15) . substr(md5($kegiatan), 5, 20) . substr(md5($revisi . $no), 0, 5);
            $crud = new crudData();
            $array = [
                'id' => $id,
                'kategori' => $kategori,
                'kegiatan' => $kegiatan,
                'uraian' => $uraian,
                'kode_id' => $kode_id,
                'revisi' => 0
            ];

            $save = $crud->insertData($tb_kegiatan, $array);
        }
    }
    public function copyTLKomponen($tb_komponen, $tb_komponen_tl, $tb_revisi_tl)
    {
        $revisi = $this->maxRevisi($tb_revisi_tl);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_komponen_tl}  WHERE revisi='$revisi'");
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $no = $data->no;
            $kategori = $data->kategori;
            $kegiatan = $data->kegiatan;
            $komponen = $data->komponen;
            $uraian = $data->uraian;
            $kode_id = $data->kode_id;
            $id = substr(md5($kategori), 0, 15) . substr(md5($kegiatan), 5, 10) .  substr(md5($komponen), 5, 10) . substr(md5($revisi . $no), 0, 5);
            $crud = new crudData();
            $array = [
                'id' => $id,
                'kategori' => $kategori,
                'kegiatan' => $kegiatan,
                'komponen' => $komponen,
                'uraian' => $uraian,
                'kode_id' => $kode_id,
                'revisi' => 0
            ];

            $save = $crud->insertData($tb_komponen, $array);
        }
    }
    public function copyTLAkun($tb_akun, $tb_akun_tl, $tb_revisi_tl)
    {
        $revisi = $this->maxRevisi($tb_revisi_tl);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_akun_tl}  WHERE revisi='$revisi'");
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $no = $data->no;
            $kategori = $data->kategori;
            $kegiatan = $data->kegiatan;
            $komponen = $data->komponen;
            $akun = $data->akun;
            $uraian = $data->uraian;
            $kode_id = $data->kode_id;
            $akun_id = $data->akun_id;
            $id = substr(md5($kategori), 0, 10) . substr(md5($kegiatan), 5, 10) .  substr(md5($komponen), 5, 10) .  substr(md5($akun), 5, 5)  . substr(md5($revisi . $no), 0, 5);
            $crud = new crudData();
            $array = [
                'id' => $id,
                'kategori' => $kategori,
                'kegiatan' => $kegiatan,
                'komponen' => $komponen,
                'akun' => $akun,
                'uraian' => $uraian,
                'kode_id' => $kode_id,
                'akun_id' => $akun_id,
                'revisi' => 0
            ];

            $save = $crud->insertData($tb_akun, $array);
        }
    }
    public function copyTLDetail($tb_detail, $tb_detail_tl, $tb_revisi_tl)
    {
        $revisi = $this->maxRevisi($tb_revisi_tl);

        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_detail_tl}  WHERE revisi='$revisi'");
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $no = $data->no;
            $kategori = $data->kategori;
            $kegiatan = $data->kegiatan;
            $komponen = $data->komponen;
            $akun = $data->akun;
            $detail = $data->detail;
            $detail_id = $data->detail_id;
            //$detail_id = $kategori . $kegiatan . $komponen . $akun . $detail . $revisi;
            $uraian = $data->uraian;
            $kode_id = $data->kode_id;

            $komponen_1 = $data->komponen_1;
            $komponen_2 = $data->komponen_2;
            $komponen_3 = $data->komponen_3;
            $komponen_4 = $data->komponen_4;
            $unit_1 = $data->unit_1;
            $unit_2 = $data->unit_2;
            $unit_3 = $data->unit_3;
            $unit_4 = $data->unit_4;
            $volume = $data->volume;
            $unit = $data->unit;
            $harga = $data->satuan;
            $total = $data->total;
            $pembiayaan_id = $data->pembiayaan_id;
            $pembiayaan_kegiatan = $data->pembiayaan_kegiatan;
            $pembiayaan_komponen = $data->pembiayaan_komponen;
            $pembiayaan_akun = $data->pembiayaan_akun;

            $id = substr(md5($akun), 6, 3) . substr(md5($uraian), 0, 4) . substr(md5($volume), 3, 4) . substr(md5($harga), 5, 5) . substr(md5($total), 5, 5) . substr(md5($pembiayaan_akun), 5, 6) . substr(md5($revisi . $no), 0, 5);

            $class_time = new time();
            $time = $class_time->getTime();

            $array = [
                'kategori' => $kategori,
                'kegiatan' => $kegiatan,
                'komponen' => $komponen,
                'akun' => $akun,
                'detail' => $detail,
                'detail_id' => $detail_id,
                'komponen_1' => $komponen_1,
                'komponen_2' => $komponen_2,
                'komponen_3' => $komponen_3,
                'komponen_4' => $komponen_4,
                'unit_1' => $unit_1,
                'unit_2' => $unit_2,
                'unit_3' => $unit_3,
                'unit_4' => $unit_4,
                'volume' => $volume,
                'unit' => $unit,
                'satuan' => $harga,
                'total' => $total,
                'uraian' => $uraian,
                'pembiayaan_id' => $pembiayaan_id,
                'pembiayaan_kegiatan' => $pembiayaan_kegiatan,
                'pembiayaan_komponen' => $pembiayaan_komponen,
                'pembiayaan_akun' => $pembiayaan_akun,
                'time' => $time,
                'id' => $id,
                'kode_id' => $kode_id,
                'revisi' => 0
            ];
            $class = new crudData();
            $save = $class->insertData($tb_detail, $array);
        }
    }
    //JUmlah / SUM
    public function sum($tabel, $field, $kondisi)
    {
        $db = database::getInstance();
        $query = $db->runQuery("SELECT SUM({$field}) FROM {$tabel} {$kondisi}");
        $query->execute();
        $data_sum = $query->fetch();
        $value = $data_sum[0];
        return $value;
    }


    public function perhitungan()
    {
        echo "
            <script type='text/javascript'>
            function sum1(){
                var txt1=parseInt(document.getElementById('komp_1').value);
                var txt2=parseInt(document.getElementById('komp_2').value);
                var txt3=parseInt(document.getElementById('komp_3').value);
                var txt4=parseInt(document.getElementById('komp_4').value);
                var result=(txt1);
                if (!isNaN(result)){
                    document.getElementById('total_volume').value=result;
                }
            }
            function sum2(){
                var txt1NumberValue=parseInt(document.getElementById('komp_1').value);
                var txt2NumberValue=parseInt(document.getElementById('komp_2').value);
                var txt3NumberValue=parseInt(document.getElementById('komp_3').value);
                var txt4NumberValue=parseInt(document.getElementById('komp_4').value);
                var result=((txt1NumberValue)*(txt2NumberValue));
                if (!isNaN(result)){
                    document.getElementById('total_volume').value=result;
                }
            }
            function sum3(){
                var txt1NumberValue=parseInt(document.getElementById('komp_1').value);
                var txt2NumberValue=parseInt(document.getElementById('komp_2').value);
                var txt3NumberValue=parseInt(document.getElementById('komp_3').value);
                var txt4NumberValue=parseInt(document.getElementById('komp_4').value);
                var result=((txt1NumberValue)*(txt2NumberValue)*(txt3NumberValue));
                if (!isNaN(result)){
                    document.getElementById('total_volume').value=result;
                }
            }
            function sum4(){
                var txt1NumberValue=parseInt(document.getElementById('komp_1').value);
                var txt2NumberValue=parseInt(document.getElementById('komp_2').value);
                var txt3NumberValue=parseInt(document.getElementById('komp_3').value);
                var txt4NumberValue=parseInt(document.getElementById('komp_4').value);
                var result=((txt1NumberValue)*(txt2NumberValue)*(txt3NumberValue)*(txt4NumberValue));
                if (!isNaN(result)){
                    document.getElementById('total_volume').value=result;
                }
            }		
            function nilai_total(){
                var txt1Numbersat=parseInt(document.getElementById('total_volume').value);
                var txt2Numbersat=parseInt(document.getElementById('nilai_satuan').value);
                
                var result=((txt1Numbersat)*(txt2Numbersat));
                if (!isNaN(result)){
                    document.getElementById('total').value=result;
                }
            }	
            </script>";
        return true;
    }

    //LIST KATEGORI
    public function list_kategori_print($tahun, $tb_kegiatan,  $tb_komponen, $tb_akun, $tb_detail, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   simakom_ref_kategori  order by kategori asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $kategori_kode = $data->kategori;
            $kategori_uraian = $data->uraian;


            //Jumlah
            $jumlah = $this->sum($tb_detail, 'total', "where kategori='$kategori_kode'  and revisi='$revisi'");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            //Jumlah Surplus/Defisit
            $pendapatan = $this->sum($tb_detail, 'total', "where kategori='A' and revisi='$revisi'");
            $belanja = $this->sum($tb_detail, 'total', "where kategori='B' and revisi='$revisi'");
            $saldo = @($pendapatan - $belanja);
            $saldo_format = @(number_format($saldo, 0, ",", "."));

            if ($kategori_kode == "A") {
                $pd = $this->sum($tb_detail, 'total', "where kategori='B' and revisi='$revisi'");
                $pd_format = @(number_format($pd, 0, ",", "."));
                $surplus = @($jumlah - $pd);
                $surplus_format = @(number_format($surplus, 0, ",", "."));
            } else {
                $pd_format = "";
                $surplus_format = "";
            };

            if ($kategori_kode == "C") {
                $jumlah = $saldo_format;
            } else {
                $jumlah = $jumlah_format;
            };

            echo "
             <tr bgcolor=#FFFFFF height='20'>
                 <td width='5px'><span class='text-danger pl-1'>$kategori_kode</span></td>
                 <td align=left ><span class='text-danger' style=color:#B22222>$kategori_uraian</span></td>
                 <td align=right><span class='text-danger' style=color:#B22222></span></td>
                 <td align=right><span class='text-danger' style=color:#B22222></span></td>
                 <td align=right><span class='text-danger' style=color:#B22222></span></td>
                 <td align=right><span class='text-danger' style=color:#B22222>$jumlah</span></td>
                 <td align=right><span class='text-danger' style=color:#B22222>$pd_format</span></td>
                 <td align=right><span class='text-danger' style=color:#B22222>$surplus_format</span></td>
                 
             </tr>
             ";
            $this->list_kegiatan_print($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kategori_kode, $tb_revisi);
            $no++;
        }
    }

    //LIST KEGIATAN
    public function list_kegiatan_print($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kategori, $tb_revisi)
    {

        $revisi = $this->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_kegiatan}  WHERE kategori = '{$kategori}' and revisi='$revisi' group by kegiatan order by kegiatan asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $kegiatan_kode = $data->kegiatan;
            $kegiatan_uraian = $data->uraian;
            $kategori_kode = $data->kategori;
            $kegiatan_id = $data->id;

            //Kode Custome
            $kegiatan_custome = $this->kodeCustome('simakom_ref_kegiatan', 'kegiatan', $kegiatan_kode, 'kegiatan_custome');

            //Jumlah
            $jumlah = $this->sum($tb_detail, 'total', "where kategori='$kategori_kode' and kegiatan='$kegiatan_kode' and revisi='$revisi'");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            if ($kategori_kode == "A") {
                $pd = $this->sum($tb_detail, 'total', "where kategori='B' and pembiayaan_kegiatan='$kegiatan_kode' and revisi='$revisi'");
                $pd_format = @(number_format($pd, 0, ",", "."));
                $surplus = @($jumlah - $pd);
                $surplus_format = @(number_format($surplus, 0, ",", "."));
            } else {
                $pd_format = "";
                $surplus_format = "";
            };

            echo "
                     <tr bgcolor=#FFFFFF height='20'>
                         <td align=left><span class='text-primary pl-2' style=color:#00008B>$kegiatan_custome</span></td>
                         <td align=left ><span class='text-primary pl-1' style=color:#00008B>$kegiatan_uraian</span></td>
                         <td align=right><span class='text-primary' style=color:#00008B></span></td>
                         <td align=right><span class='text-primary' style=color:#00008B></span></td>
                         <td align=right><span class='text-primary' style=color:#00008B></span></td>
                         <td align=right><span class='text-primary' style=color:#00008B>$jumlah_format</span></td>
                         <td align=right><span class='text-primary' style=color:#00008B>$pd_format</span></td>
                         <td align=right><span class='text-primary' style=color:#00008B>$surplus_format</span></td>
                       
                     </tr>
                     ";
            $this->list_komponen_print($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail,  $kegiatan_kode, $tb_revisi);
            $no++;
        }
    }
    //LIST KOMPONEN
    public function list_komponen_print($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kegiatan, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_komponen}  WHERE kegiatan = '{$kegiatan}'  and revisi='$revisi' group by komponen  order by komponen asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $komponen_kode = $data->komponen;
            $komponen_uraian = $data->uraian;
            $kode_kegiatan = $data->kegiatan;
            $komponen_id = $data->id;

            //Uraian Kegiatan
            $showkegiatan = $db->runQuery("SELECT * FROM   {$tb_kegiatan}  WHERE kegiatan = '{$kode_kegiatan}'");
            $kegiatan = $showkegiatan->fetch(PDO::FETCH_OBJ);
            $kegiatan_uraian = $kegiatan->uraian;
            $kode_kategori = $kegiatan->kategori;
            $kegiatan = $kegiatan->kegiatan;
            $uraian_kategori = $this->uraianRKAS('simakom_ref_kategori', 'kategori', $kode_kategori, 'uraian');
            $title_kegiatan = $kode_kategori . ' : ' . $uraian_kategori . '  --   ' . $kode_kegiatan .  ' : ' . $kegiatan_uraian;


            //Jumlah
            $jumlah = $this->sum($tb_detail, 'total', "where kategori='$kode_kategori' and kegiatan='$kode_kegiatan' and komponen='$komponen_kode'  and revisi='$revisi' ");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            if ($kode_kategori == "A") {
                $pd = $this->sum($tb_detail, 'total', "where kategori='B' and pembiayaan_kegiatan='$kode_kegiatan' and pembiayaan_komponen='$komponen_kode'  and revisi='$revisi'");
                $pd_format = @(number_format($pd, 0, ",", "."));
                $surplus = @($jumlah - $pd);
                $surplus_format = @(number_format($surplus, 0, ",", "."));
            } else {
                $pd_format = "";
                $surplus_format = "";
            };

            echo "
                  <tr bgcolor='#FFFFFF' height='20'>
                      <td align=center><span class='text-info pl-4' style='color:32CD32'>$komponen_kode</span></td>
                      <td align=left ><span class='text-info pl-1' style='color:32CD32'>$komponen_uraian</span></td>
                      <td align=right><span class='text-info' style='color:32CD32'></span></td>
                      <td align=right><span class='text-info' style='color:32CD32'></span></td>
                      <td align=right><span class='text-info' style='color:32CD32'></span></td>
                      <td align=right><span class='text-info' style='color:32CD32'>$jumlah_format</span></td>
                      <td align=right><span class='text-info' style='color:32CD32'>$pd_format</span></td>
                      <td align=right><span class='text-info' style='color:32CD32'>$surplus_format</span></td>     
                  </tr>
                  ";
            $this->list_akun_print($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kode_kegiatan, $komponen_kode, $tb_revisi);
            $no++;
        }
    }
    //LIST AKUN
    public function list_akun_print($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kegiatan, $komponen, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_akun}  WHERE kegiatan = '{$kegiatan}' and komponen='$komponen'  and revisi='$revisi' group by akun  order by akun asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $akun_id = $data->id;
            $akun_kode = $data->akun;
            $akun_uraian = $data->uraian;
            $kode_kategori = $data->kategori;
            $kode_kegiatan = $data->kegiatan;
            $kode_komponen = $data->komponen;

            //Akun Custome
            $akun_custome = $this->kodeCustome('simakom_ref_akun', 'akun', $akun_kode, 'akun_custome');

            $uraian_kategori = $this->uraianRKAS('simakom_ref_kategori', 'kategori', $kode_kategori, 'uraian');
            $uraian_kegiatan = $this->uraianRKAS($tb_kegiatan, 'kegiatan', $kode_kegiatan, 'uraian');
            $uraian_komponen = $this->uraianRKAS($tb_komponen, 'komponen', $kode_komponen, 'uraian');

            $title_kegiatan = $kode_kategori . ' : ' . $uraian_kategori . '  -   ' . $kode_kegiatan .  ' : ' . $uraian_kegiatan . '  -   ' . $kode_komponen . ' : ' . $uraian_komponen;


            //Jumlah
            $jumlah = $this->sum($tb_detail, 'total', "where kategori='$kode_kategori' and kegiatan='$kode_kegiatan' and komponen='$kode_komponen' and akun='$akun_kode'  and revisi='$revisi'");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            if ($kode_kategori == "A") {
                $pd = $this->sum($tb_detail, 'total', "where kategori='B' and pembiayaan_kegiatan='$kode_kegiatan' and pembiayaan_komponen='$kode_komponen' and pembiayaan_akun='$akun_kode'  and revisi='$revisi'");
                $pd_format = @(number_format($pd, 0, ",", "."));
                $surplus = @($jumlah - $pd);
                $surplus_format = @(number_format($surplus, 0, ",", "."));
            } else {
                $pd_format = "";
                $surplus_format = "";
            };

            // $modal = new modal();


            echo "
                  <tr height='20'>
                      <td align=right valign=middle><span class='text-secondary pl-5' style=color:2F4F4F>$akun_custome</span></td>
                      <td align=left valign=middle ><span class='text-secondary pl-1' style=color:2F4F4F>$akun_uraian</span></td>
                      <td align=right valign=middle><span class='text-secondary' style=color:2F4F4F></span></td>
                      <td align=right valign=middle><span class='text-secondary' style=color:2F4F4F></span></td>
                      <td align=right valign=middle><span class='text-secondary' style=color:2F4F4F></span></td>
                      <td align=right valign=middle><span class='text-secondary' style=color:2F4F4F>$jumlah_format</span></td>
                      <td align=right valign=middle><span class='text-secondary' style=color:2F4F4F>$pd_format</span></td>
                      <td align=right valign=middle><span class='text-secondary' style=color:2F4F4F>$surplus_format</span></td>
                     
                  </tr>
                  ";
            $this->list_detail_print($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $akun_kode, $kode_kategori, $kode_kegiatan, $kode_komponen, $tb_revisi);
            $no++;
        }
    }
    //LIST DETAIL
    public function list_detail_print($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $akun_kode, $kode_kategori, $kode_kegiatan, $kode_komponen, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM  $tb_detail WHERE  kategori='{$kode_kategori}' and kegiatan='{$kode_kegiatan}' and komponen='$kode_komponen' and akun = '{$akun_kode}' and revisi='$revisi'  order by detail asc, time asc");
        $no = 1;
        $row = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $akun = $data->akun;
            $id_detail = $data->id;
            $detail_uraian = $data->uraian;

            //Akun Custome
            $akun_custome = $this->kodeCustome('simakom_ref_akun', 'akun', $akun, 'akun_custome');

            $akun_uraian = $data->uraian;
            $kategori = $data->kategori;
            $kegiatan = $data->kegiatan;

            $kategori = $data->kategori;
            $kegiatan = $data->kegiatan;
            $komponen = $data->komponen;
            $akun = $data->akun;
            $uraian = $data->uraian;
            $komponen_1 = $data->komponen_1;
            $komponen_2 = $data->komponen_2;
            $komponen_3 = $data->komponen_3;
            $komponen_4 = $data->komponen_4;
            $unit_1 = $data->unit_1;
            $unit_2 = $data->unit_2;
            $unit_3 = $data->unit_3;
            $unit_4 = $data->unit_4;

            $viewPerh = $this->viewPerhitungan($komponen_1, $komponen_2, $komponen_3, $komponen_4, $unit_1, $unit_2, $unit_3, $unit_4);
            $uraian_detail = $detail_uraian . ' ' . $viewPerh;

            $volume = @(number_format($data->volume, 0, ",", "."));
            $unit = $data->unit;
            $harga = @(number_format($data->satuan, 0, ",", "."));

            $total = number_format($data->total, 0, ",", ".");
            $pembiayaan_kegiatan = $data->pembiayaan_kegiatan;
            $pembiayaan_komponen = $data->pembiayaan_komponen;
            $pembiayaan_akun = $data->pembiayaan_akun;

            $pembiayaan = $pembiayaan_kegiatan . '.' . $pembiayaan_komponen . '.' . $pembiayaan_akun;
            if ($kategori == "A") {
                $kode_pembiayaan = "";
            } else {
                $kode_pembiayaan = $pembiayaan;
            };

            $uraian_kategori = $this->uraianRKAS('simakom_ref_kategori', 'kategori', $kategori, 'uraian');
            $uraian_kegiatan = $this->uraianRKAS($tb_kegiatan, 'kegiatan', $kegiatan, 'uraian');

            $uraian_komponen = $this->uraianRKAS($tb_komponen, 'kode_id', $kategori . $kegiatan . $komponen, 'uraian');

            $uraian_akun = $this->uraianRKAS($tb_akun, 'akun', $akun, 'uraian');
            $title_akun = $kode_kategori . ' : ' . $uraian_kategori . '  -   ' . $kegiatan .  ' : ' . $uraian_kegiatan . '  -   ' . $komponen . ' : ' . $uraian_komponen . ' - ' . $akun_custome . ' : ' . $uraian_akun;
            $rowdetail = $akun_custome . '.' . $row++;

            echo "
                  <tr bgcolor=#FFFFFF height='20' >
                      <td align=left></td>
                      <td align=left><span class='pl-1'><i>$rowdetail - $uraian_detail</i></span></td>
                      <td align=center>$volume</td>
                      <td align=left>$unit</td>
                      <td align=right>$harga</td>
                      <td align=right>$total</td>
                      <td align=left>$kode_pembiayaan</td>
                      <td align=right></td>            
                  </tr>
                  ";
            $no++;
        }
    }


    //LIST KATEGORI
    public function list_kategori_rekap($tahun, $tb_kegiatan,  $tb_komponen, $tb_akun, $tb_detail, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   simakom_ref_kategori  order by kategori asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $kategori_kode = $data->kategori;
            $kategori_uraian = $data->uraian;


            //Jumlah
            $jumlah = $this->sum($tb_detail, 'total', "where kategori='$kategori_kode'  and revisi='$revisi'");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            //Jumlah Surplus/Defisit
            $pendapatan = $this->sum($tb_detail, 'total', "where kategori='A' and revisi='$revisi'");
            $belanja = $this->sum($tb_detail, 'total', "where kategori='B' and revisi='$revisi'");
            $saldo = @($pendapatan - $belanja);
            $saldo_format = @(number_format($saldo, 0, ",", "."));

            if ($kategori_kode == "A") {
                $pd = $this->sum($tb_detail, 'total', "where kategori='B' and revisi='$revisi'");
                $pd_format = @(number_format($pd, 0, ",", "."));
                $surplus = @($jumlah - $pd);
                $surplus_format = @(number_format($surplus, 0, ",", "."));
            } else {
                $pd_format = "";
                $surplus_format = "";
            };

            if ($kategori_kode == "C") {
                $jumlah = $saldo_format;
            } else {
                $jumlah = $jumlah_format;
            };

            echo "
             <tr bgcolor=#FFFFFF height='20'>
                 <td width='5px'><span class='text-danger pl-1'>$kategori_kode</span></td>
                 <td align=left ><span class='text-danger' style=color:#B22222>$kategori_uraian</span></td>

                 <td align=right><span class='text-danger' style=color:#B22222>$jumlah</span></td>
                 <td align=right><span class='text-danger' style=color:#B22222>$pd_format</span></td>
                 <td align=right><span class='text-danger' style=color:#B22222>$surplus_format</span></td>
                 
             </tr>
             ";
            $this->list_kegiatan_rekap($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kategori_kode, $tb_revisi);
            $no++;
        }
    }

    //LIST KEGIATAN
    public function list_kegiatan_rekap($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kategori, $tb_revisi)
    {

        $revisi = $this->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_kegiatan}  WHERE kategori = '{$kategori}' and revisi='$revisi' group by kegiatan order by kegiatan asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $kegiatan_kode = $data->kegiatan;
            $kegiatan_uraian = $data->uraian;
            $kategori_kode = $data->kategori;
            $kegiatan_id = $data->id;

            //Kode Custome
            $kegiatan_custome = $this->kodeCustome('simakom_ref_kegiatan', 'kegiatan', $kegiatan_kode, 'kegiatan_custome');

            //Jumlah
            $jumlah = $this->sum($tb_detail, 'total', "where kategori='$kategori_kode' and kegiatan='$kegiatan_kode' and revisi='$revisi'");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            if ($kategori_kode == "A") {
                $pd = $this->sum($tb_detail, 'total', "where kategori='B' and pembiayaan_kegiatan='$kegiatan_kode' and revisi='$revisi'");
                $pd_format = @(number_format($pd, 0, ",", "."));
                $surplus = @($jumlah - $pd);
                $surplus_format = @(number_format($surplus, 0, ",", "."));
            } else {
                $pd_format = "";
                $surplus_format = "";
            };

            echo "
                     <tr bgcolor=#FFFFFF height='20'>
                         <td align=left><span class='text-primary pl-2' style=color:#00008B>$kegiatan_custome</span></td>
                         <td align=left ><span class='text-primary pl-1' style=color:#00008B>$kegiatan_uraian</span></td>
               
                         <td align=right><span class='text-primary' style=color:#00008B>$jumlah_format</span></td>
                         <td align=right><span class='text-primary' style=color:#00008B>$pd_format</span></td>
                         <td align=right><span class='text-primary' style=color:#00008B>$surplus_format</span></td>
                       
                     </tr>
                     ";
            $this->list_komponen_rekap($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail,  $kegiatan_kode, $tb_revisi);
            $no++;
        }
    }
    //LIST KOMPONEN
    public function list_komponen_rekap($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kegiatan, $tb_revisi)
    {
        $revisi = $this->maxRevisi($tb_revisi);
        $db = database::getInstance();
        $show = $db->runQuery("SELECT * FROM   {$tb_komponen}  WHERE kegiatan = '{$kegiatan}'  and revisi='$revisi' group by komponen  order by komponen asc");
        $no = 1;
        while ($data = $show->fetch(PDO::FETCH_OBJ)) {
            $komponen_kode = $data->komponen;
            $komponen_uraian = $data->uraian;
            $kode_kegiatan = $data->kegiatan;
            $komponen_id = $data->id;

            //Uraian Kegiatan
            $showkegiatan = $db->runQuery("SELECT * FROM   {$tb_kegiatan}  WHERE kegiatan = '{$kode_kegiatan}'");
            $kegiatan = $showkegiatan->fetch(PDO::FETCH_OBJ);
            $kegiatan_uraian = $kegiatan->uraian;
            $kode_kategori = $kegiatan->kategori;
            $kegiatan = $kegiatan->kegiatan;
            $uraian_kategori = $this->uraianRKAS('simakom_ref_kategori', 'kategori', $kode_kategori, 'uraian');
            $title_kegiatan = $kode_kategori . ' : ' . $uraian_kategori . '  --   ' . $kode_kegiatan .  ' : ' . $kegiatan_uraian;


            //Jumlah
            $jumlah = $this->sum($tb_detail, 'total', "where kategori='$kode_kategori' and kegiatan='$kode_kegiatan' and komponen='$komponen_kode'  and revisi='$revisi' ");
            $jumlah_format = @(number_format($jumlah, 0, ",", "."));

            if ($kode_kategori == "A") {
                $pd = $this->sum($tb_detail, 'total', "where kategori='B' and pembiayaan_kegiatan='$kode_kegiatan' and pembiayaan_komponen='$komponen_kode'  and revisi='$revisi'");
                $pd_format = @(number_format($pd, 0, ",", "."));
                $surplus = @($jumlah - $pd);
                $surplus_format = @(number_format($surplus, 0, ",", "."));
            } else {
                $pd_format = "";
                $surplus_format = "";
            };

            echo "
                  <tr bgcolor='#FFFFFF' height='20'>
                      <td align=center><span class='text-info pl-4' style='color:32CD32'>$komponen_kode</span></td>
                      <td align=left ><span class='text-info pl-1' style='color:32CD32'>$komponen_uraian</span></td>

                      <td align=right><span class='text-info' style='color:32CD32'>$jumlah_format</span></td>
                      <td align=right><span class='text-info' style='color:32CD32'>$pd_format</span></td>
                      <td align=right><span class='text-info' style='color:32CD32'>$surplus_format</span></td>     
                  </tr>
                  ";
            // $this->list_akun_print($tb_kegiatan, $tb_komponen, $tb_akun, $tb_detail, $kode_kegiatan, $komponen_kode, $tb_revisi);
            $no++;
        }
    }
    public function splitID($id)
    {
        $len = strlen($id);
        $id = substr($id, 0, $len - 9);
        return $id;
    }
    public function splitTahun($id)
    {
        //$len = strlen($id) - 9;
        //$idx = substr($id, $len, 9);
        $idx = substr($id, -9);
        return $idx;
    }

    public function getTabelbyID($id, $tabel)
    {
        $classtabel = new cekTabel;
        $getTahun = $this->splitTahun($id);
        $value = $classtabel->getTabel($tabel, $getTahun);
        return $value;
    }
}
