<?php

spl_autoload_register(function ($mod) {
    require('../../../../../asset/mod/' . $mod . '.php');
});

$format = new format();

// Load file autoload.php
require '../../../../../asset/bootstrap/asset/phpspreadsheet/autoload.php';


//$tahun = $_GET['tahun'];
//$tahun_tabel = substr($tahun, 2, 2) . substr($tahun, 7, 2);
//$tb_siswa = "tb_siswa" . $tahun_tabel;
$tb_siswa = $_GET['tahun'];

// Include librari PhpSpreadsheet
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Buat sebuah variabel untuk menampung pengaturan style dari header tabel
$style_col = [
    'font' => ['bold' => true], // Set font nya jadi bold
    'font-family' => ['Arial'], // Set font nya jadi bold
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
    ]
];

// Buat sebuah variabel untuk menampung pengaturan style dari isi tabel
$style_row = [
    'font' => ['bold' => false], // Set font nya jadi bold
    'font-family' => ['Arial'], // Set font nya jadi bold
    'alignment' => [
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
    ],
];

// Buat header tabel nya pada baris ke 3
$sheet->setCellValue('A1', 'NO');
$sheet->setCellValue('B1', 'NAMA');
$sheet->setCellValue('C1', 'NIS');
$sheet->setCellValue('D1', 'L/P');
$sheet->setCellValue('E1', 'JENJANG');
$sheet->setCellValue('F1', 'PARALEL');
$sheet->setCellValue('G1', 'ORANG TUA');
$sheet->setCellValue('H1', 'ALAMAT');
$sheet->setCellValue('I1', 'TANG-A');
$sheet->setCellValue('J1', 'TANG-B');
$sheet->setCellValue('K1', 'TANG-C');
$sheet->setCellValue('L1', 'TANG-D');
$sheet->setCellValue('M1', 'TANG-E');
$sheet->setCellValue('N1', 'TANG-F');
$sheet->setCellValue('O1', 'TANG-G');
$sheet->setCellValue('P1', 'TANG-H');
$sheet->setCellValue('Q1', 'TANG-I');
$sheet->setCellValue('R1', 'TANG-J');
$sheet->setCellValue('S1', 'TANG-K');
$sheet->setCellValue('T1', 'TANG-L');
$sheet->setCellValue('U1', 'TANG-M');
$sheet->setCellValue('V1', 'TANG-N');
$sheet->setCellValue('W1', 'TANG-O');
$sheet->setCellValue('X1', 'TANG-P');
$sheet->setCellValue('Y1', 'TANG-Q');
$sheet->setCellValue('Z1', 'TANG-R');
$sheet->setCellValue('AA1', 'TANG-S');
$sheet->setCellValue('AB1', 'TANG-T');
$sheet->setCellValue('AC1', 'TANG-U');
$sheet->setCellValue('AD1', 'TANG-V');
$sheet->setCellValue('AE1', 'TANG-W');
$sheet->setCellValue('AF1', 'TANG-X');
$sheet->setCellValue('AG1', 'TANG-Y');
$sheet->setCellValue('AH1', 'TANG-Z');
$sheet->setCellValue('AI1', 'STATUS');
$sheet->setCellValue('AJ1', 'EMAIL');
$sheet->setCellValue('AK1', 'HP');
$sheet->setCellValue('AL1', 'KATEGORI');
$sheet->setCellValue('AM1', 'STAR BULAN');
$sheet->setCellValue('AN1', 'CATATAN');
$sheet->setCellValue('AO1', 'ID');

// Apply style header yang telah kita buat tadi ke masing-masing kolom header
$sheet->getStyle('A1:AO1')->applyFromArray($style_col);
$spreadsheet->getActiveSheet()->getStyle('A1:AO1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('d5dbdb');

// Set height baris ke 1, 2 dan 3


// Buat query untuk menampilkan semua data siswa
$crud = new crudData();
//$format = new format();
$showSiswa = $crud->showTable($tb_siswa);



$no = 1; // Untuk penomoran tabel, di awal set dengan 1
$row = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
while ($data = $showSiswa->fetch(PDO::FETCH_OBJ)) {

    $format = new format();

    $nama = $format->entityEncode($data->nama);
    $sheet->setCellValue('A' . $row, $no);
    $sheet->setCellValue('B' . $row, $format->entityEncode($data->nama));
    $sheet->setCellValue('C' . $row, $data->nis);
    $sheet->setCellValue('D' . $row, $data->kelamin);
    $sheet->setCellValue('E' . $row, $data->jenjang);
    $sheet->setCellValue('F' . $row, $data->paralel);
    $sheet->setCellValue('G' . $row, $format->entityEncode($data->ortu));
    $sheet->setCellValue('H' . $row, $format->entityEncode($data->alamat));
    $sheet->setCellValue('I' . $row, $data->tang_A);
    $sheet->setCellValue('J' . $row, $data->tang_B);
    $sheet->setCellValue('K' . $row, $data->tang_C);
    $sheet->setCellValue('L' . $row, $data->tang_D);
    $sheet->setCellValue('M' . $row, $data->tang_E);
    $sheet->setCellValue('N' . $row, $data->tang_F);
    $sheet->setCellValue('O' . $row, $data->tang_G);
    $sheet->setCellValue('P' . $row, $data->tang_H);
    $sheet->setCellValue('Q' . $row, $data->tang_I);
    $sheet->setCellValue('R' . $row, $data->tang_J);
    $sheet->setCellValue('S' . $row, $data->tang_K);
    $sheet->setCellValue('T' . $row, $data->tang_L);
    $sheet->setCellValue('U' . $row, $data->tang_M);
    $sheet->setCellValue('V' . $row, $data->tang_N);
    $sheet->setCellValue('W' . $row, $data->tang_O);
    $sheet->setCellValue('X' . $row, $data->tang_P);
    $sheet->setCellValue('Y' . $row, $data->tang_Q);
    $sheet->setCellValue('Z' . $row, $data->tang_R);
    $sheet->setCellValue('AA' . $row, $data->tang_S);
    $sheet->setCellValue('AB' . $row, $data->tang_T);
    $sheet->setCellValue('AC' . $row, $data->tang_U);
    $sheet->setCellValue('AD' . $row, $data->tang_V);
    $sheet->setCellValue('AE' . $row, $data->tang_W);
    $sheet->setCellValue('AF' . $row, $data->tang_X);
    $sheet->setCellValue('AG' . $row, $data->tang_Y);
    $sheet->setCellValue('AH' . $row, $data->tang_Z);
    $sheet->setCellValue('AI' . $row, $data->status);
    $sheet->setCellValue('AJ' . $row, $data->email);
    $sheet->setCellValue('AK' . $row, $data->hp);
    $sheet->setCellValue('AL' . $row, $data->kategori);
    $sheet->setCellValue('AM' . $row, $data->startAt);
    $sheet->setCellValue('AN' . $row, $data->catatan);
    $sheet->setCellValue('Ao' . $row, $data->id);


    // Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
    $sheet->getStyle('A' . $row . ':AO' . $row)->applyFromArray($style_row);


    $sheet->getStyle('A' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet->getStyle('B' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
    $sheet->getStyle('C' . $row . ':F' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet->getStyle('AI' . $row . ':AO' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

    //$sheet->getRowDimension($row)->setRowHeight(20); // Set height tiap row

    // $sheet->getStyle('I' . $row . ':AH' . $row)
    //     ->getNumberFormat()
    //     ->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER);
    //

    $no++; // Tambah 1 setiap kali looping
    $row++; // Tambah 1 setiap kali looping

    //$sheet->getStyle('A1:AM' . $row)->getFont()->setName('Arial');
}

// Set width kolom
$sheet->getColumnDimension('A')->setWidth(5);
$sheet->getColumnDimension('B')->setWidth(35);
$sheet->getColumnDimension('C')->setWidth(15);
$sheet->getColumnDimension('D')->setWidth(10);
$sheet->getColumnDimension('E')->setWidth(10);
$sheet->getColumnDimension('F')->setWidth(20);
$sheet->getColumnDimension('G')->setWidth(35);
$sheet->getColumnDimension('H')->setWidth(40);
$sheet->getColumnDimension('I')->setWidth(15);
$sheet->getColumnDimension('J')->setWidth(15);
$sheet->getColumnDimension('K')->setWidth(15);
$sheet->getColumnDimension('L')->setWidth(15);
$sheet->getColumnDimension('M')->setWidth(15);
$sheet->getColumnDimension('N')->setWidth(15);
$sheet->getColumnDimension('O')->setWidth(15);
$sheet->getColumnDimension('P')->setWidth(15);
$sheet->getColumnDimension('Q')->setWidth(15);
$sheet->getColumnDimension('R')->setWidth(15);
$sheet->getColumnDimension('S')->setWidth(15);
$sheet->getColumnDimension('T')->setWidth(15);
$sheet->getColumnDimension('U')->setWidth(15);
$sheet->getColumnDimension('V')->setWidth(15);
$sheet->getColumnDimension('W')->setWidth(15);
$sheet->getColumnDimension('X')->setWidth(15);
$sheet->getColumnDimension('Y')->setWidth(15);
$sheet->getColumnDimension('Z')->setWidth(15);
$sheet->getColumnDimension('AA')->setWidth(15);
$sheet->getColumnDimension('AB')->setWidth(15);
$sheet->getColumnDimension('AD')->setWidth(15);
$sheet->getColumnDimension('AE')->setWidth(15);
$sheet->getColumnDimension('AF')->setWidth(15);
$sheet->getColumnDimension('AG')->setWidth(15);
$sheet->getColumnDimension('AH')->setWidth(15);
$sheet->getColumnDimension('AI')->setWidth(15);
$sheet->getColumnDimension('AJ')->setWidth(35);
$sheet->getColumnDimension('AK')->setWidth(20);
$sheet->getColumnDimension('AL')->setWidth(15);
$sheet->getColumnDimension('AM')->setWidth(25);
$sheet->getColumnDimension('AN')->setWidth(25);
$sheet->getColumnDimension('AO')->setWidth(25);


// Set orientasi kertas jadi LANDSCAPE
//$sheet->getPageSetup()->setOrientation(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_PORTRAIT);

// Set judul file excel nya
$sheet->setTitle("Data Siswa");

// Proses file excel
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="Data Siswa & Tanggungan.xlsx"'); // Set nama file excel nya
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
