<?php

//Hak Cipta dilindungi Undang-undang. Hak Cipta : Khamdi Rahmani, Reg. Kemenkum HAM No : 000121327. Dilarang merubah isi File tanpa ijin tertulis dari pemegang Hak Cipta. 

class database extends conn
{
    private static $_instance = null;
    private $_pdo;

    public function __construct()
    {
        try {
            $this->_pdo = new PDO(
                'mysql:host=' . $this->_host . ';dbname=' . $this->_dbname,
                $this->_username,
                $this->_password
            );
            $this->_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {

            echo "<script>document.location.href='./creatDB.php'</script>";
        }
    }

    public static function getInstance()
    {
        if (!isset(self::$_instance)) {
            self::$_instance = new database();
        }
        return self::$_instance;
    }

    public function runQuery($query, $bindValue = [])
    {
        try {
            $stmt = $this->_pdo->prepare($query);
            $stmt->execute($bindValue);
        } catch (PDOException $e) {
            die("Ada masalah pada Koneksi / Query : " . $e->getMessage() .
                " (" . $e->getCode() . ")");
        }
        return $stmt;
    }
    public function getQuery($query, $bindValue = [])
    {
        return $this->runQuery($query, $bindValue)->fetchAll(PDO::FETCH_OBJ);
    }
    public function cekDatabase()
    {
        $db = $this->_dbname;
        return $db;
    }
};
