<style>
    .close:focus {
        outline: none;
    }

    .top-right {
        top: 20px;
        right: 20px;
    }

    .toast {
        border: 1px solid coral
    }
</style>
<div class="content-wrapper clearfix">

    <?php require('./layout/headerpage.php'); ?>

    <div class="container col-12 mb-4 pb-5">
        <div class="row">
            <div class="col-12">
                <div class="col-12">
                    <div class="card  mx-2">
                        <div class="timeline-header bg-primary py-2 pl-2">
                            <b class="text-light judul"><span class="bi bi-clipboard-check"></span> Laporan Siswa </b>
                        </div>

                        <!-- /.card-header -->
                        <div class="card-body my-0 mx-1">


                            <div class="row ">
                                <label class="col-lg-1 col-sm-12 col-form-label text-primary mt-0 ">View </label>
                                <div class="col-lg-1 col-sm-12">
                                    <select id="limit" class="form-control form-control-sm fontInput small">

                                        <option value="50">50</option>
                                        <option value="100">100</option>
                                        <option value="200">200</option>
                                        <option value="500">500</option>
                                        <option value="1000">1000</option>

                                    </select>
                                </div>

                                <label class="col-lg-1 col-sm-12 col-form-label text-primary mt-0">Cari Siswa </label>
                                <div class="col-lg-5 col-sm-12 mb-3">
                                    <input type="text" id="search" placeholder="Nama atau NIS" class="form-control form-control-sm fontInput">
                                </div>

                            </div>
                            <table class="table table-condensed table-hover table-sm mb-4 mt-3">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Laporan</th>
                                        <th>NIS</th>
                                        <th>Nama User</th>
                                        <th>Kelas</th>
                                        <th>Buku Pembayaran</th>
                                    </tr>
                                </thead>
                                <tbody id="dataTable"></tbody>
                            </table>
                            <div id="spinner">
                                <img src="../../asset/dokumen/foto/spinner2.gif" width="60" height="60" />
                                <p class="text-success"><i>Sedang memuat Data...</i></p>
                            </div>
                            <div id="recordInfo" class="mb-2"></div>
                            <div id="pagination"></div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--/. container-fluid -->

        <!-- /.content -->
    </div>
</div>


<script>
    $(document).ready(function() {
        $('#spinner').show();
        const loadData = (page = 1, limit = 50, search = '') => {
            $.ajax({
                url: 'view/laporan/siswa/fetch/fetch_laporan_siswa.php',
                type: 'GET',
                data: {
                    page,
                    limit,
                    search
                },
                success: function(data) {
                    const {
                        rows,
                        pagination,
                        totalRecords
                    } = JSON.parse(data);
                    $('#dataTable').html(rows);
                    $('#pagination').html(pagination);
                    $('#recordInfo').text(`Record : ${totalRecords} `);
                    $('#spinner').hide();
                }
            });
        };

        $('#limit').change(function() {
            loadData(1, $(this).val(), $('#search').val());
        });

        $('#pagination').on('click', 'a', function(e) {
            e.preventDefault();
            const page = $(this).data('page');
            const limit = $('#limit').val();
            loadData(page, limit, $('#search').val());
        });




        $('#search').keyup(function() {
            loadData(1, $('#limit').val(), $(this).val());
        });

        loadData();
    });
</script>
<?php

//$ajax = new ajax;
//$output = $ajax->loadData("view/laporan/siswa/fetch/fetch_laporan_siswa.php", "", "");
