<?php

require_once "../../../../../asset/mod/autoLoad.php";
require_once "../../../layout/conn.php";
require_once "../../../layout/session.php";

$crud = new crudData;
$link = new linkpage;
$format = new format();
$classNB = new namaBayar();
$classTr = new transaksi();
$clsSetor = new setor;

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 5;
$search = isset($_GET['search']) ? $_GET['search'] : '';
$offset = ($page - 1) * $limit;


//$query = "SELECT  * FROM  $tb_transaksi group by id_tr WHERE nama LIKE :search || nis LIKE :search order by tanggal desc LIMIT :limit OFFSET :offset";
$query = "SELECT  * FROM  $tb_transaksi WHERE nama LIKE :search || nis LIKE :search || id_tr LIKE :search || tanggal LIKE :search group by id_tr order by tanggal desc LIMIT :limit OFFSET :offset";
$stmt = $pdo->prepare($query);
$stmt->bindValue(':search', "%$search%", PDO::PARAM_STR);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$no = 0;
//$datas = $stmt->fetchAll(PDO::FETCH_ASSOC);
$datas = $stmt->fetchAll(PDO::FETCH_OBJ);

$countDataGroup = $crud->countData($tb_transaksi, " group by id_tr");

$total = $pdo->prepare("SELECT COUNT(*) FROM $tb_transaksi WHERE nama LIKE :search || nis LIKE :search || id_tr LIKE :search || tanggal LIKE :search");
$total->bindValue(':search', "%$search%", PDO::PARAM_STR);
$total->execute();
$totalRows = $total->fetchColumn();
$totalPages = ceil($totalRows / $limit);


$rows = '';


foreach ($datas as $data) {


    if ($data->setor == "Ya") {
        $setor = "Disetor";
    } else {
        $setor = "--";
    };
    $nis = $data->nis;
    $tahap = $data->tahap;
    //nama Bayar

    $ceknamaBayar = $classNB->ceknamaBayar($tahun, $data->jenis, $data->jenjang);

    //startAt

    $startAt = $classTr->startAt($tb_siswa, $nis);
    $cekbulan = $classTr->cekPeriode($startAt, $tahap, $tahun1, $tahun2);
    $siswa_id = $crud->getValue($tb_siswa, "where nis='$nis'", 'id');


    $penerima = $classTr->namaPenerimaByID($data->penerima);

    $count = $crud->countData($tb_transaksi, "where id_tr='$data->id_tr'");
    $sum = $crud->sum($tb_transaksi, 'jumlah', "where id_tr='$data->id_tr'");
    $no++;
    $num = $no + $offset;

    $rows .= "<tr>";
    $rows .= "<td width='20px' align='center'>$num</td>";
    $rows .= "<td width='50px' align='center'><a " . $link->pageIDReprint($siswa_id, $data->id_tr, $tahun, 'transaksi/kuitansi_printpreview') . " class='badge badge-secondary  px-1 py-1 d-inline'> <i class='bi bi-printer'></i> CETAK</a></td>";
    $rows .= "<td>" . $format->dateToIndo($data->tanggal) . "</td>";
    $rows .= "<td>" . $format->entityEncode($data->nama) . "</td>";
    $rows .= "<td>" . $data->nis . "</td>";
    $rows .= "<td>" . $data->jenjang . "-" . $data->paralel . "</td>";
    $rows .= "<td>" . $data->id_tr . "</td>";
    $rows .= "<td>" . $count . "</td>";
    $rows .= "<td>" . $format->ribuan($sum) . "</td>";
    $rows .= "<td>" . $penerima . "</td>";
    $rows .= "</tr>";
}


$pagination = '';
for ($i = 1; $i <= $totalPages; $i++) {
    if ($page == $i) {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-primary px-2 py-1 ml-1" data-page="' . $i . '">' . $i . '</a> ';
    } else {
        $pagination .= '<a href="#" class="pagination_link btn-xs btn-default px-2 py-1 ml-1" data-page="' . $i . '">' . $i . '</a> ';
    };
}

echo json_encode(['rows' => $rows, 'pagination' => $pagination, 'totalRecords' => $totalRows]);
