<?php

spl_autoload_register(function ($mod) {
    require('../../../../../asset/mod/' . $mod . '.php');
});

// Load file autoload.php
require '../../../../../asset/bootstrap/asset/phpspreadsheet/autoload.php';

$clssekolah = new sekolah;
date_default_timezone_set('Asia/Jakarta');
$tanggal = mktime(date("m"), date("d"), date("Y"));
$tglsekarang = date("d-m-Y", $tanggal);
$tahunnow = date("Y", $tanggal);

if (isset($_GET['tahun'])) {
    $tahun = $_GET['tahun'];
} else {
    $tahun = $tahunnow;
};
$tahun1 = substr($tahun, 0, 4);
$tahun2 = substr($tahun, 5, 4);

$tahun_tabel = substr($tahun, 2, 2) . substr($tahun, 7, 2);

$tb_siswa = "tb_siswa" . $tahun_tabel;
$tb_transaksi = "db_transaksi" . $tahun_tabel;
$tb_detailakun = "detail_akun" . $tahun_tabel;



// Include librari PhpSpreadsheet
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spreadsheet = new Spreadsheet();
$sheet1 = $spreadsheet->setActiveSheetIndex(0);

$spreadsheet->getActiveSheet()->getPageSetup()->setOrientation(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_PORTRAIT);
$spreadsheet->getActiveSheet()->getPageSetup()->setPaperSize(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4);
$spreadsheet->getActiveSheet()->getPageMargins()->setTop(1);
$spreadsheet->getActiveSheet()->getPageMargins()->setLeft(1);
$spreadsheet->getActiveSheet()->getPageMargins()->setRight(1);
$spreadsheet->getActiveSheet()->getPageMargins()->setBottom(1);
// Buat sebuah variabel untuk menampung pengaturan style dari header tabel
$style_judul = [
    'font' => ['bold' => true], // Set font nya jadi bold
    'font-family' => ['Arial'], // Set font nya jadi bold
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],

];
$style_col = [
    'font' => ['bold' => true], // Set font nya jadi bold
    'font-family' => ['Arial'], // Set font nya jadi bold
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
    ]
];

// Buat sebuah variabel untuk menampung pengaturan style dari isi tabel
$style_row = [
    'alignment' => [
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
    ],
    'borders' => [
        'top' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border top dengan garis tipis
        'right' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN],  // Set border right dengan garis tipis
        'bottom' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN], // Set border bottom dengan garis tipis
        'left' => ['borderStyle'  => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN] // Set border left dengan garis tipis
    ]
];




//for ($i = 'A'; $i !=  $sheet1->getHighestColumn(); $i++) {
//    $sheet1->getColumnDimension($i)->setAutoSize(TRUE);
//}
$sheet1->getColumnDimension('A')->setWidth(3);
$sheet1->getColumnDimension('B')->setWidth(25);
$sheet1->getColumnDimension('C')->setWidth(10);
$sheet1->getColumnDimension('D')->setWidth(10);
$sheet1->getColumnDimension('E')->setWidth(10);
$sheet1->getColumnDimension('F')->setWidth(15);
$sheet1->getColumnDimension('G')->setWidth(15);
$sheet1->getColumnDimension('H')->setWidth(15);
$sheet1->getColumnDimension('I')->setWidth(15);

$sheet1->setCellValue('A1', 'LAPORAN REKAPITULASI TP. ' . $tahun);
$sheet1->setCellValue('A2', $clssekolah->dataSekolah('sekolah'));
$sheet1->mergeCells('A1:I1');
$sheet1->mergeCells('A2:I2');



// Buat header tabel nya pada baris ke 3
$sheet1->setCellValue('A4', '#');
$sheet1->setCellValue('B4', 'Kode : Jenis Pembayaran');
$sheet1->setCellValue('C4', ' Jenjang ');
$sheet1->setCellValue('D4', ' Bulanan ');
$sheet1->setCellValue('E4', ' Record ');
$sheet1->setCellValue('F4', ' Tanggungan ');
$sheet1->setCellValue('G4', ' Terbayar ');
$sheet1->setCellValue('H4', ' Kurang ');
$sheet1->setCellValue('I4', '   Persen   ');

// Apply style header yang telah kita buat tadi ke masing-masing kolom header
$sheet1->getStyle('A1:I1')->applyFromArray($style_judul);
$sheet1->getStyle('A2:I2')->applyFromArray($style_judul);

$spreadsheet->getActiveSheet(1)->getStyle('A4:I4')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('d5dbdb');
$sheet1->getStyle('A4:I4')->applyFromArray($style_row);
// Set height baris ke 1, 2 dan 3
$sheet1->getRowDimension('1')->setRowHeight(20);


// Buat query untuk menampilkan semua data siswa
$crud = new crudData();
$format = new format();
$clslistTanggungan = new listTanggungan();
$classLaporan = new laporan();
$showSiswa = $crud->showTable($tb_siswa);

$no = 1; // Untuk penomoran tabel, di awal set dengan 1
$row = 5;

$jenjang = strtolower($clssekolah->dataSekolah('jenjang'));


$classForm = new form();
$tingkat = $classForm->optSelect('tb_tingkat', "where {$jenjang}<>'' order by no asc");
while ($datatingkat = $tingkat->fetch(PDO::FETCH_OBJ)) {
    $jenjang_opt = $datatingkat->{$jenjang};

    //    //Jumlah Jenis Per Jenjang
    $namaBayar = new namaBayar();
    $maxJenjang = $namaBayar->maxJenjang();

    if ($jenjang == "paud") {
        $showJenis = $namaBayar->CountTransaksi('tb_nama_bayar', 'tp', $tahun, "kelas='" . $jenjang_opt . "'");
        $count_jjg = $showJenis->rowCount();

        if ($jenjang_opt == "TPA") {
            $showJenis = $namaBayar->CountTransaksi('tb_nama_bayar', 'tp', $tahun, "kelas=''");
            $count_Bef = $showJenis->rowCount();
            $showJenis = $namaBayar->CountTransaksi('tb_nama_bayar', 'tp', $tahun, "kelas=''");
            $count_Jns = $showJenis->rowCount();
        } elseif ($jenjang_opt == "KB") {
            $showJenis = $namaBayar->CountTransaksi('tb_nama_bayar', 'tp', $tahun, "kelas='TPA'");
            $count_Bef = $showJenis->rowCount();
            $showJenis = $namaBayar->CountTransaksi('tb_nama_bayar', 'tp', $tahun, "kelas='TPA' || kelas='KB'");
            $count_Jns = $showJenis->rowCount();
        } elseif ($jenjang_opt == "TK") {
            $showJenis = $namaBayar->CountTransaksi('tb_nama_bayar', 'tp', $tahun, "kelas='TPA' || kelas='KB'");
            $count_Bef = $showJenis->rowCount();
            $showJenis = $namaBayar->CountTransaksi('tb_nama_bayar', 'tp', $tahun, "kelas='TPA' || kelas='KB' || kelas='TK'");
            $count_Jns = $showJenis->rowCount();
        } else {
            $showJenis = $namaBayar->CountTransaksi('tb_nama_bayar', 'tp', $tahun, "kelas='TPA' || kelas='KB' || kelas='TK'");
            $count_Bef = $showJenis->rowCount();
            $showJenis = $namaBayar->CountTransaksi('tb_nama_bayar', 'tp', $tahun, "kelas='TPA' || kelas='KB' || kelas='TK' || kelas='Lulus'");
            $count_Jns = $showJenis->rowCount();
        };
    } elseif ($jenjang != 'paud' && $jenjang_opt == "Lulus") {
        $showJenis = $namaBayar->CountTransaksi('tb_nama_bayar', 'tp', $tahun, "kelas='" . $jenjang_opt . "'");
        $count_jjg = $showJenis->rowCount();

        $showJenis = $namaBayar->CountTransaksi('tb_nama_bayar', 'tp', $tahun, "kelas<='" . $maxJenjang . "'");
        $count_Bef = $showJenis->rowCount();

        $showJenis = $namaBayar->CountTransaksi('tb_nama_bayar', 'tp', $tahun, "kelas<='" . $maxJenjang . "' || kelas='Lulus'");
        $count_Jns = $showJenis->rowCount();
    } else {

        $showJenis = $namaBayar->CountTransaksi('tb_nama_bayar', 'tp', $tahun, "kelas='" . $jenjang_opt . "'");
        $count_jjg = $showJenis->rowCount();

        $showJenis = $namaBayar->CountTransaksi('tb_nama_bayar', 'tp', $tahun, "kelas<'" . $jenjang_opt . "'");
        $count_Bef = $showJenis->rowCount();

        $showJenis = $namaBayar->CountTransaksi('tb_nama_bayar', 'tp', $tahun, "kelas<='" . $jenjang_opt . "'");
        $count_Jns = $showJenis->rowCount();
    };
    $showJenis = $namaBayar->CountTransaksiAll('tb_nama_bayar', 'tp', $tahun);
    $count_All = $showJenis->rowCount();
    //
    if ($jenjang == "sd") {
        $row_total = $count_All + 10;
    } else {
        $row_total = $count_All + 13;
    };

    if ($jenjang_opt == "TPA" || $jenjang_opt == "1" || $jenjang_opt == "7" || $jenjang_opt == "10") {
        $plusrow = 0;
    } elseif ($jenjang_opt == "KB" || $jenjang_opt == "2" || $jenjang_opt == "8" || $jenjang_opt == "11") {
        $plusrow = 1;
    } elseif ($jenjang_opt == "TK" || $jenjang_opt == "3" || $jenjang_opt == "9" || $jenjang_opt == "12") {
        $plusrow = 2;
    } elseif ($jenjang_opt == "4") {
        $plusrow = 3;
    } elseif ($jenjang_opt == "5") {
        $plusrow = 4;
    } elseif ($jenjang_opt == "6") {
        $plusrow = 5;
    } elseif ($jenjang == "sd" && $jenjang_opt == "Lulus") {
        $plusrow = 5;
    } elseif ($jenjang != "sd" && $jenjang_opt == "Lulus") {
        $plusrow = 2;
    } else {
        $plusrow = 0;
    };
    //
    $row_jjg = $row +  $count_Bef + $plusrow;
    $row_jns = $row + $count_Bef + $plusrow + 1;
    //$row_subt = $row + $count_Jns + $plusrow + 1;
    if ($jenjang_opt == "Lulus") {
        $row_subt = $row + $count_Jns + $plusrow + 2;
    } else {
        $row_subt = $row + $count_Jns + $plusrow + 1;
    };

    $sheet1->setCellValue('A' . $row_jjg, $no);
    $sheet1->setCellValue('B' . $row_jjg, 'Jenjang Kelas ' . $jenjang_opt);

    $classLaporan = new laporan();
    $jenisBayar = $classLaporan->ShowjenisBayar($tahun, $jenjang_opt);
    while ($datajenis = $jenisBayar->fetch(PDO::FETCH_OBJ)) {
        $jenis = $datajenis->kode;
        $field = "tang_" . $jenis;


        $tanggungan_jenis = @($crud->sum($tb_siswa, 'tang_' . $jenis, "where jenjang='$jenjang_opt'"));
        $terbayar_jenis = @($crud->sum($tb_transaksi, 'jumlah', "where jenjang='$jenjang_opt' and jenis='$jenis'"));
        $kurang_jenis = @($tanggungan_jenis) - @($terbayar_jenis);
        $persen_jenis = $format->persen($terbayar_jenis, $tanggungan_jenis);

        //SSub Total
        $tanggungan = $clslistTanggungan->tanggunganSiswaIf($tb_siswa, " jenjang='$jenjang_opt' and paralel!=''");
        $terbayar = @($crud->sum($tb_transaksi, 'jumlah', "where jenjang='$jenjang_opt'"));
        $kurang = @($tanggungan) - @($terbayar);
        $persen = $format->persen($terbayar, $tanggungan);

        //Total
        $tanggungan_total = $clslistTanggungan->tanggunganSiswaIf($tb_siswa, " jenjang!=''");
        $terbayar_total = @($crud->sum($tb_transaksi, 'jumlah', ""));
        $kurang_total = @($tanggungan_total) - @($terbayar_total);
        $persen_total = $format->persen($terbayar_total, $tanggungan_total);


        $jenis = $datajenis->kode;
        $sheet1->setCellValue('A' . $row_jns, '');
        $sheet1->setCellValue('B' . $row_jns, $datajenis->kode . ' : ' . $datajenis->nama);
        $sheet1->setCellValue('C' . $row_jns, $datajenis->kelas);
        $sheet1->setCellValue('D' . $row_jns, $datajenis->bulanan);
        $sheet1->setCellValue('E' . $row_jns, $crud->countData($tb_transaksi, "where jenjang='$datajenis->kelas' && jenis='$jenis'"));

        $sheet1->setCellValue('F' . $row_jns, $tanggungan_jenis);
        $sheet1->setCellValue('G' . $row_jns, $kurang_jenis);
        $sheet1->setCellValue('H' . $row_jns, $kurang_jenis);
        $sheet1->setCellValue('I' . $row_jns, $persen_jenis);
        $row_jns++;

        $sheet1->getStyle('A4:I' . $row_jns)->applyFromArray($style_row);
        $sheet1->getStyle('A4:I' . $row_jns + 1)->getFont()->setSize(10);
    }

    //JUmlah Per Jenjang
    $sheet1->setCellValue('B' . $row_subt, 'Jumlah');
    $sheet1->setCellValue('E' . $row_subt, $crud->countData($tb_transaksi, "where jenjang='$jenjang_opt'"));
    $sheet1->setCellValue('F' . $row_subt, $tanggungan);
    $sheet1->setCellValue('G' . $row_subt, $terbayar);
    $sheet1->setCellValue('H' . $row_subt, $kurang);
    $sheet1->setCellValue('I' . $row_subt, $persen);
    $row_subt++;

    // Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
    $sheet1->getStyle('A' . $row . ':A' . $row_jns + 1)->applyFromArray($style_row);
    $sheet1->getStyle('B' . $row . ':B' . $row_jns + 1)->applyFromArray($style_row);
    $sheet1->getStyle('C' . $row . ':C' . $row_jns + 1)->applyFromArray($style_row);
    $sheet1->getStyle('D' . $row . ':D' . $row_jns + 1)->applyFromArray($style_row);
    $sheet1->getStyle('E' . $row . ':E' . $row_jns + 1)->applyFromArray($style_row);
    $sheet1->getStyle('F' . $row . ':F' . $row_jns + 1)->applyFromArray($style_row);
    $sheet1->getStyle('G' . $row . ':G' . $row_jns + 1)->applyFromArray($style_row);
    $sheet1->getStyle('H' . $row . ':H' . $row_jns + 1)->applyFromArray($style_row);
    $sheet1->getStyle('I' . $row . ':I' . $row_jns + 1)->applyFromArray($style_row);

    $sheet1->getStyle('A' . $row . ':A' . $row_jns + 1)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet1->getStyle('B' . $row . ':B' . $row_jns + 1)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
    $sheet1->getStyle('C' . $row . ':C' . $row_jns + 1)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet1->getStyle('D' . $row . ':D' . $row_jns + 1)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet1->getStyle('E' . $row . ':E' . $row_jns + 1)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet1->getStyle('F' . $row . ':F' . $row_jns + 1)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
    $sheet1->getStyle('G' . $row . ':G' . $row_jns + 1)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
    $sheet1->getStyle('H' . $row . ':H' . $row_jns + 1)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
    $sheet1->getStyle('I' . $row . ':I' . $row_jns + 1)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

    $sheet1->getRowDimension($row_jns)->setRowHeight(20);
    //
    $no++;
    $row++;
    $row_jjg++;
    $sheet1->getStyle('A' . $row . ':I' . $row_jjg)->applyFromArray($style_row);
}
//
////JUmlah Total
$sheet1->setCellValue('B' . $row_total, 'TOTAL');
$sheet1->setCellValue('E' . $row_total,  $crud->countData($tb_transaksi, ""));
$sheet1->setCellValue('F' . $row_total, $tanggungan_total);
$sheet1->setCellValue('G' . $row_total, $terbayar_total);
$sheet1->setCellValue('H' . $row_total, $kurang_total);
$sheet1->setCellValue('I' . $row_total, $persen_total);
$sheet1->getStyle('A' . $row_total . ':I' . $row_total)->getFont()->setBold(true);

$sheet1->getStyle('A1')->getFont()->setBold(true);
$sheet1->getStyle('A1')->getFont()->setSize(15);
$sheet1->getStyle('A1:I' . $row_total)->getFont()->setName('Arial');

//// Set orientasi kertas jadi LANDSCAPE
$sheet1->getPageSetup()->setOrientation(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_PORTRAIT);
//
//// Set judul file excel nya
////$spreadsheet->getActiveSheet(1)->setTitle("Rekapitulasi");
$spreadsheet->getActiveSheet()->setTitle("Rekapitulasi");

//SHEET - 2
$spreadsheet->createSheet();
$sheet2 = $spreadsheet->setActiveSheetIndex(1);
$spreadsheet->getActiveSheet()->getPageSetup()->setOrientation(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);
$spreadsheet->getActiveSheet()->getPageSetup()->setPaperSize(\PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4);
$spreadsheet->getActiveSheet()->getPageMargins()->setTop(1);
$spreadsheet->getActiveSheet()->getPageMargins()->setLeft(1);
$spreadsheet->getActiveSheet()->getPageMargins()->setRight(1);
$spreadsheet->getActiveSheet()->getPageMargins()->setBottom(1);

$sheet2->getStyle('A1')->getFont()->setBold(true);
$sheet2->getStyle('A1')->getFont()->setSize(15);


$sheet2->setCellValue('A1', 'RINCIAN TRANSAKSI');
$sheet2->setCellValue('A2', strtoupper($clssekolah->dataSekolah('sekolah')));
$sheet2->mergeCells('A1:K1');
$sheet2->mergeCells('A2:K2');
$sheet2->getStyle('A1:K1')->applyFromArray($style_judul);
$sheet2->getStyle('A2:K2')->applyFromArray($style_judul);



$spreadsheet->getActiveSheet(1)->getStyle('A5:K5')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('d5dbdb');
$sheet2->getStyle('A5:K5')->applyFromArray($style_row);


// Bua2 header tabel nya pada baris ke 3
$sheet2->setCellValue('A5', '#');
$sheet2->setCellValue('B5', 'Tanggal');
$sheet2->setCellValue('C5', 'Nama');
$sheet2->setCellValue('D5', 'NIS');
$sheet2->setCellValue('E5', 'Kelas');
$sheet2->setCellValue('F5', 'Kode : Jenis Pembayaran');
$sheet2->setCellValue('G5', 'Periode');
$sheet2->setCellValue('H5', ' Jumlah ');
$sheet2->setCellValue('I5', ' Metode ');
$sheet2->setCellValue('J5', ' Penerima ');
$sheet2->setCellValue('K5', ' Catatan ');

$sheet2->getPageSetup()->setRowsToRepeatAtTopByStartAndEnd(1, 9);

$sheet2->getColumnDimension('A')->setWidth(3);
$sheet2->getColumnDimension('B')->setWidth(18);
$sheet2->getColumnDimension('C')->setWidth(20);
$sheet2->getColumnDimension('D')->setWidth(10);
$sheet2->getColumnDimension('E')->setWidth(10);
$sheet2->getColumnDimension('F')->setWidth(30);
$sheet2->getColumnDimension('G')->setWidth(15);
$sheet2->getColumnDimension('H')->setWidth(10);
$sheet2->getColumnDimension('I')->setWidth(7);
$sheet2->getColumnDimension('J')->setWidth(20);
$sheet2->getColumnDimension('K')->setWidth(10);


//$showList = $classLaporan->TransaksiDetail($tb_transaksi, $tgl_1, $tgl_2, $penerima_lap, $metode_lap, $jenjang_lap, $paralel_lap);
$showList = $crud->showTable($tb_transaksi . " order by tanggal asc");
$count_trn = $showList->rowCount();
$no = 0;
$row = 5;
$row_end = $count_trn + $row;
//$jmlrow = $classLaporan->CountRecordAll($tb_transaksi, $tgl_1, $tgl_2, $penerima_lap, $metode_lap, $jenjang_lap, $paralel_lap);
while ($data = $showList->fetch(PDO::FETCH_OBJ)) {

    if ($data->jumlah == "" || $data->jumlah == 0) {
        $jumlah = number_format(0, 2, ",", ".");
    } else {
        $jumlah = number_format($data->jumlah, 2, ",", ".");
    };
    if ($data->setor == "Ya") {
        $setor = "Disetor";
    } else {
        $setor = "--";
    };
    $nis = $data->nis;
    $tahap = $data->tahap;
    //nama Bayar
    $classNB = new namaBayar();
    $ceknamaBayar = $classNB->ceknamaBayar($tahun, $data->jenis, $data->jenjang);

    //startAt
    $classTr = new transaksi();
    $startAt = $classTr->startAt($tb_siswa, $nis);
    $cekbulan = $classTr->cekPeriode($startAt, $tahap, $tahun1, $tahun2);

    //nama Bayar
    $classNB = new namaBayar();
    $ceknamaBayar = $classNB->ceknamaBayar($tahun, $data->jenis, $data->jenjang);

    $showJenis = $classNB->shownamaBayar($tahun, $data->jenis, $data->jenjang);
    $datajenis = $showJenis->fetch(PDO::FETCH_OBJ);
    $field_tang = 'tang_' . $datajenis->kode;
    $setbulanan = $datajenis->bulanan; //Cek Apakah Bulanan

    if ($setbulanan == "Tidak") {
        $periode = "Tahap " . $tahap;
    } else {
        $periode = $cekbulan;
    };

    // $link = new linkpage;
    $no++;
    $row++;
    $sheet2->setCellValue('A' . $row, $no);
    $sheet2->setCellValue('B' . $row, $data->time);
    $sheet2->setCellValue('C' . $row, $data->nama);
    $sheet2->setCellValue('D' . $row, $nis);
    $sheet2->setCellValue('E' . $row, $data->jenjang . '-' . $data->paralel);
    $sheet2->setCellValue('F' . $row, $data->jenis . ' : ' . $ceknamaBayar);
    $sheet2->setCellValue('G' . $row, $periode);
    $sheet2->setCellValue('H' . $row, $jumlah);
    $sheet2->setCellValue('I' . $row, $data->metode);
    $sheet2->setCellValue('J' . $row, $crud->getValue('user', "where id='$data->penerima'", 'nama'));
    $sheet2->setCellValue('K' . $row, $data->catatan);

    $sheet2->getStyle('A' . $row . ':A' . $row_end)->applyFromArray($style_row);
    $sheet2->getStyle('B' . $row . ':B' . $row_end)->applyFromArray($style_row);
    $sheet2->getStyle('C' . $row . ':C' . $row_end)->applyFromArray($style_row);
    $sheet2->getStyle('D' . $row . ':D' . $row_end)->applyFromArray($style_row);
    $sheet2->getStyle('E' . $row . ':E' . $row_end)->applyFromArray($style_row);
    $sheet2->getStyle('F' . $row . ':F' . $row_end)->applyFromArray($style_row);
    $sheet2->getStyle('G' . $row . ':G' . $row_end)->applyFromArray($style_row);
    $sheet2->getStyle('H' . $row . ':H' . $row_end)->applyFromArray($style_row);
    $sheet2->getStyle('I' . $row . ':I' . $row_end)->applyFromArray($style_row);
    $sheet2->getStyle('J' . $row . ':J' . $row_end)->applyFromArray($style_row);
    $sheet2->getStyle('K' . $row . ':K' . $row_end)->applyFromArray($style_row);

    $sheet2->getStyle('A' . $row . ':A' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet2->getStyle('B' . $row . ':B' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet2->getStyle('C' . $row . ':C' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
    $sheet2->getStyle('D' . $row . ':D' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet2->getStyle('E' . $row . ':E' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet2->getStyle('F' . $row . ':F' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
    $sheet2->getStyle('G' . $row . ':G' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
    $sheet2->getStyle('H' . $row . ':H' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
    $sheet2->getStyle('I' . $row . ':I' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet2->getStyle('J' . $row . ':J' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
    $sheet2->getStyle('K' . $row . ':K' . $row_end)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);

    $sheet2->getStyle('A1:K' . $row_end)->getFont()->setName('Arial');
    $sheet2->getStyle('A4:K' . $row_end)->getFont()->setSize(10);
}



//$sheet2->getRowDimension($row_jns)->setRowHeight(20);

$spreadsheet->getActiveSheet()->setTitle("Rincian");
// Proses file excel
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="Laporan Transaksi.xlsx"'); // Set nama file excel nya
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
