DROP TABLE IF EXISTS `sekolah`;

CREATE TABLE IF NOT EXISTS `sekolah` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `sekolah` varchar(200) NOT NULL,
  `alamat` varchar(150) NOT NULL,
  `kota` varchar(20) NOT NULL,
  `jenjang` varchar(4) NOT NULL,
  `nama_kuitansi` varchar(25) NOT NULL,
  `info_kuitansi` varchar(10) NOT NULL,
  `info_tahap` varchar(10) NOT NULL,
  `info_kettrans` varchar(20) NOT NULL,
  `bg` varchar(10) NOT NULL,
  `menu` varchar(5) NOT NULL,
  `versi` varchar(10) NOT NULL,
  `bg_color` varchar(20) NOT NULL,
  `nama_pimpinan` varchar(100) NOT NULL,
  `pimpinan` varchar(50) NOT NULL,
  `model_kw` varchar(20) NOT NULL,
  `startPeriode` varchar(20) NOT NULL,
  `tgl_backup` date NOT NULL,
  `kops1` text NOT NULL,
  `kops2` text NOT NULL,
  `simakom_bendahara_nama` varchar(250) NOT NULL,
  `simakom_bendahara_nip` varchar(18) NOT NULL,
  `simakom_atasan_nama` varchar(250) NOT NULL,
  `simakom_atasan_nip` varchar(118) NOT NULL,
  `simakom_atasan_jabatan` varchar(250) NOT NULL,
  `simakom_atasan2_nama` varchar(250) NOT NULL,
  `simakom_atasan2_jabatan` varchar(250) NOT NULL,
  `simakom_ppk_nama` varchar(200) NOT NULL,
  `simakom_ppk_nip` varchar(18) NOT NULL,
  `simakom_ppk_jabatan` varchar(200) NOT NULL,
  `notice` text DEFAULT NULL,
  `notice2` text DEFAULT NULL,
  `tk` text DEFAULT NULL,
  `tp` varchar(10) NOT NULL,
  `webaddress` text NOT NULL,
  `aksesteller` varchar(5) NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `sekolah` (`no`, `sekolah`, `alamat`, `kota`, `jenjang`, `nama_kuitansi`, `info_kuitansi`, `info_tahap`, `info_kettrans`, `bg`, `menu`, `versi`, `bg_color`, `nama_pimpinan`, `pimpinan`, `model_kw`, `startPeriode`, `tgl_backup`, `kops1`, `kops2`, `simakom_bendahara_nama`, `simakom_bendahara_nip`, `simakom_atasan_nama`, `simakom_atasan_nip`, `simakom_atasan_jabatan`, `simakom_atasan2_nama`, `simakom_atasan2_jabatan`, `simakom_ppk_nama`, `simakom_ppk_nip`, `simakom_ppk_jabatan`, `notice`, `notice2`, `tk`, `tp`, `webaddress`, `aksesteller`, `id`) VALUES
	(1,'SMP PANATAGAMA ISLAMIC SCHOOL','Jl. Darmodiharjo No.23a Sukamelang Subang','Subang','SMP','Nama Siswa','ya','ya','ya','primary','','','primary','Egi Fajriyandi, M.Pd','Kepala Sekolah','1','1','2024-11-07','','','Ellisha Hadiaty, SE','12345678','Egi Fajriyandi, M.Pd','12345678','Kepala Sekolah','Dr. Rohmat Buchori, S.Pd.I, M.S.I.','Direktur','','','','Jika ada ketidaksesuaian data, dimohon untuk segera menginformasikan kepada admin dan Kami sangat berterimakasih jika Ayah/Bunda melakukan pembayaran tepat waktu ..','','TERIMA KASIH','2025/2026','http://keuangan.smp.panatagama.sch.id','no','4FC0CC739C4F1307628C88AE1C1EF683');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `serial`;

CREATE TABLE IF NOT EXISTS `serial` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `sekolah` varchar(200) NOT NULL,
  `seri` varchar(100) NOT NULL,
  `aktivasi` varchar(100) NOT NULL,
  `tanggal` date NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `serial` (`no`, `sekolah`, `seri`, `aktivasi`, `tanggal`, `id`) VALUES
	(1,'SMP PANATAGAMA ISLAMIC SCHOOL','956AB8-80AA3S-B80518-217AB8-0633B2','2158P6FF5369C39CDAB5BEC8BD1112F09BF1035FC33E1178EDB','2024-11-07','4FC0CC739C4F1307628C88AE1C1EF683');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `user`;

CREATE TABLE IF NOT EXISTS `user` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` varchar(20) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `kelamin` varchar(1) NOT NULL,
  `email` varchar(120) NOT NULL,
  `hp` varchar(18) NOT NULL,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `level` varchar(20) NOT NULL,
  `status` varchar(10) NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `user` (`no`, `id_user`, `nama`, `kelamin`, `email`, `hp`, `username`, `password`, `level`, `status`, `id`) VALUES
	(11,'9J2mFH','Admin','L','admin@gmail.com','0888888888','admin','e10adc3949ba59abbe56e057f20f883e','admin','Aktif','e3afed0047b08059d0fada10f400c1e5'),
	(30,'5ce8aa025b635b7a9efc','Ellisha Hadiaty, SE','P','','','bendahara','c9ccd7f3c1145515a9d3f7415d5bcbea','bendahara','Aktif','5ce8aa025b635b7a9efc'),
	(31,'5ce8aa025b635b7a9efc','Ellisha Hadiaty, SE','P','','','teller','8482dfb1bca15b503101eb438f52deed','teller','Aktif','5ce8aa025b635b7a9efc'),
	(33,'d1ea3730063442f62a9e','Rismayanti Apipah S. Pd.,M.M. ','P','','','pengawas','f414face756c143bb2be71c33c978073','monitoring','Aktif','d1ea3730063442f62a9e'),
	(34,'c0290f1cd31bb19c496d','RKAS','L','','','rkas','0cae3894da509521aacd6b1917ad5d1e','rkas','Aktif','c0290f1cd31bb19c496d'),
	(35,'b8e6465fbf4f079aea60','Tabungan','P','','','tabungan','c1b1f59dbfe51b882c8b0dd09c86c1ca','tabungan','Aktif','b8e6465fbf4f079aea60'),
	(36,'f134ede43bbb5a900131','Dr. Rohmat Buchori,S.Pd.I,M.S.I.','L','','','Direktur','4fbfd324f5ffcdff5dbf6f019b02eca8','monitoring','Aktif','f134ede43bbb5a900131'),
	(37,'722df1dc467b0a06e210','H. Mokh. Jaenudin / Hj. Citra Dewi','L','','','Owner','72122ce96bfec66e2396d2e25225d70a','monitoring','Aktif','722df1dc467b0a06e210');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `user_siswa`;

CREATE TABLE IF NOT EXISTS `user_siswa` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `kelamin` varchar(1) NOT NULL,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `hp` varchar(15) NOT NULL,
  `email` varchar(150) NOT NULL,
  `id` text NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `nip_2` (`nis`),
  KEY `nip` (`nis`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `user_siswa` (`no`, `nis`, `nama`, `kelamin`, `username`, `password`, `hp`, `email`, `id`, `status`, `created_at`, `updated_at`, `created_by`) VALUES
	(1,'2324010002','AHMAD HAIKAL JIRZIS','L','2324010002','a0534d8d025ee4c9d088eeba528c2607','','','1cbcf4d64da05347c334','Aktif','2024-12-01 01:32:23','2024-12-01 01:32:23','e3afed0047b08059d0fada10f400c1e5'),
	(2,'2324010007','ALIKHA NAYLA PUTRI ANDRYAN','P','2324010007','104a14eba425518cd4192805230b4001','','','4cf5d01390104a14433b','Aktif','2024-12-01 01:32:23','2024-12-01 01:32:23','e3afed0047b08059d0fada10f400c1e5'),
	(3,'2324010008','ALVITO ABINAYAJATI','L','2324010008','9e564f888b9c7255191283c412057200','','','d7dc43ab1a9e56410086','Aktif','2024-12-01 01:32:23','2024-12-01 01:32:23','e3afed0047b08059d0fada10f400c1e5'),
	(4,'2324010004','ANNISA NANDIRA PUTRI','P','2324010004','a4a7d0606ee5f9715cb99d66bb5d139b','','','cdf174a0b3a4a7dcba13','Aktif','2024-12-01 01:32:23','2024-12-01 01:32:23','e3afed0047b08059d0fada10f400c1e5'),
	(5,'2324010003','GADIZA RAYNA SYAHIRA','P','2324010003','23f4701ce149fa4e7c0f5d02fc045507','','','4ae9ed9a8623f4704a10','Aktif','2024-12-01 01:32:23','2024-12-01 01:32:23','e3afed0047b08059d0fada10f400c1e5'),
	(6,'2324010005','NADIRA NATASA','P','2324010005','0d6a4c388fd91a406659a140e4da5b5f','','','abcc5d4d6c0d6a44718c','Aktif','2024-12-01 01:32:23','2024-12-01 01:32:23','e3afed0047b08059d0fada10f400c1e5'),
	(7,'2324010009','RAZAN AZKIA LESMANA','L','2324010009','5d1dc8f17959fbf1bf6b5db0cb82768f','','','4e09279e2e5d1dc1257f','Aktif','2024-12-01 01:32:23','2024-12-01 01:32:23','e3afed0047b08059d0fada10f400c1e5'),
	(8,'2324010001','VIYONA PUTRI RAKHMAN','P','2324010001','51a260c446655f1647aaeee834e16c22','','','81781b035a51a265b2af','Aktif','2024-12-01 01:32:23','2024-12-01 01:32:23','e3afed0047b08059d0fada10f400c1e5'),
	(9,'2324010010','IHSAN KURNIAWAN','L','2324010010','c73a9bf65a7f9b46fdda6b79b11ec210','','','7f04ddbb17c73a9975c4','Aktif','2024-12-01 01:32:23','2024-12-01 01:32:23','e3afed0047b08059d0fada10f400c1e5'),
	(10,'2425020001','AIRIN AZZAHRA','P','2425020001','d504653d33158ac7bc0c7af7b2b7eff3','','','060a56c58ad5046ea1d4','Aktif','2024-12-03 14:27:35','2024-12-03 14:27:35','8690afb4f29f55be337e86996087fea3'),
	(11,'2425020002','AL FIRYAALI ATHALIA HUSNA','P','2425020002','5935efa7f42ad8f839442b23d56d179f','','','733d3a54735935e4afbc','Aktif','2024-12-03 14:27:35','2024-12-03 14:27:35','8690afb4f29f55be337e86996087fea3'),
	(12,'2425020003','ARJUNA PUTRA WIBAWA','L','2425020003','74075d2832d4061117defb4fcdc1f1af','','','7455b0720e740755d00c','Aktif','2024-12-03 14:27:35','2024-12-03 14:27:35','8690afb4f29f55be337e86996087fea3'),
	(13,'2425020004','FIRJANI ALMA AFRINA','P','2425020004','28f8044bb55263ddb35680258a2bd33b','','','2835111d3d28f80806db','Aktif','2024-12-03 14:27:35','2024-12-03 14:27:35','8690afb4f29f55be337e86996087fea3'),
	(14,'2425020005','GHAZI AZKA JUNIOR','L','2425020005','5ee3304f87e1709216cf9512a72e13ab','','','26a91149e05ee3326199','Aktif','2024-12-03 14:27:35','2024-12-03 14:27:35','8690afb4f29f55be337e86996087fea3'),
	(15,'2425020006','HUGA AKBAR RIANTO','L','2425020006','ffa4cf9b5d68b3e89617d2b316c7b739','','','889de2b92cffa4ca7080','Aktif','2024-12-03 14:27:35','2024-12-03 14:27:35','8690afb4f29f55be337e86996087fea3'),
	(16,'2425020007','KHAYLA ALMIRA MARISSA','P','2425020007','554aacdd6cba135b9c287cae5ee3082c','','','b84b7259b0554aa1c58b','Aktif','2024-12-03 14:27:35','2024-12-03 14:27:35','8690afb4f29f55be337e86996087fea3'),
	(17,'2425020008','KAYLA MEOQUANEE INDRAWAN','P','2425020008','056a5784eb4c24849fbb1114a0b8ffdf','','','cc5ad9e0b5056a5690cb','Aktif','2024-12-03 14:27:35','2024-12-03 14:27:35','8690afb4f29f55be337e86996087fea3'),
	(18,'2425020009','MARYAM NAURA IZZATUNNISA','P','2425020009','4cf1f6947314cca61012839dcb92709c','','','6b550aad214cf1fd9f30','Aktif','2024-12-03 14:27:35','2024-12-03 14:27:35','8690afb4f29f55be337e86996087fea3'),
	(19,'2425020010','MUHAMMAD A&amp;#039;LA DANADYAKSA','L','2425020010','83240357fa1df1f15ad2f9acaf4c9686','','','3b2d44301183240a4bc8','Aktif','2024-12-03 14:27:35','2024-12-03 14:27:35','8690afb4f29f55be337e86996087fea3'),
	(20,'2425020011','MUHAMMAD AZKA GHOSSANNY','L','2425020011','77d651340902529eac888f5e727d69b3','','','fcbc0ca21177d65d8041','Aktif','2024-12-03 14:27:35','2024-12-03 14:27:35','8690afb4f29f55be337e86996087fea3'),
	(21,'2425020012','MUHAMMAD TRISTAN ALVITO','L','2425020012','567251747a29fbda173224be9ffe584f','','','14d3e9d5e05672589244','Aktif','2024-12-03 14:27:35','2024-12-03 14:27:35','8690afb4f29f55be337e86996087fea3'),
	(22,'2425020013','RAFFA KHAIRUN FAHMI','L','2425020013','ef0fb2439b4d8adafb665c6d44a718cf','','','5dd084054eef0fbd7715','Aktif','2024-12-03 14:27:35','2024-12-03 14:27:35','8690afb4f29f55be337e86996087fea3'),
	(23,'2425020014','RAFIF AL FADZIMA IRAWAN','L','2425020014','ed8fb33c0512409c8bfa2a6d0391f572','','','e5d5810232ed8fbce19e','Aktif','2024-12-03 14:27:35','2024-12-03 14:27:35','8690afb4f29f55be337e86996087fea3'),
	(24,'2425020015','RIZKINA NUR AULIA AZZAHRO','P','2425020015','c0bc3eb7c13ef16f62c83160f37029b4','','','b70ba5066ec0bc363696','Aktif','2024-12-03 14:27:35','2024-12-03 14:27:35','8690afb4f29f55be337e86996087fea3');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_ref_akun`;

CREATE TABLE IF NOT EXISTS `simakom_ref_akun` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `akun` varchar(6) NOT NULL,
  `akun_custome` varchar(50) NOT NULL,
  `uraian` text NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=225 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_ref_akun` (`no`, `kategori`, `akun`, `akun_custome`, `uraian`, `id`) VALUES
	(17,'A','100103','100103',' Penerimaan Biaya Akomodasi MMP','9ae26ff44c264acbcdb9f37bb5c08fcc9f9'),
	(18,'A','100201','100201',' Penerimaan Biaya Extrakurikuler','7c7523f13ef609df9b1d9f82fed8bd1ce3c'),
	(13,'A','100000','100000',' Penerimaan Saldo Kas Tahun Lalu','14ee22eaba297944f4f6fd9c6dbe2f2b555'),
	(14,'A','100101','100101',' Penerimaan SPP','732e276ec85f14e5ddca80e9dd3badedebc'),
	(15,'A','100102','100102',' Penerimaan Biaya Pendidikan','54ebda338d71682fb4f81166e8399d6a962'),
	(16,'A','100104','100104',' Penerimaan Biaya Kelas KKO','72984ef85cbebaa1de90c11baa503343547'),
	(72,'B','200410','200410',' Kegiatan Tasmi Qur&#039;an','b36b3ad0d379e627438d0839d4eb272c3c8'),
	(71,'B','200409','200409',' Kegiatan Odyssey Plan ( Pisikolog)','a214210b612b919423f37d247a6da55463f'),
	(70,'B','200408','200408',' Kegiatan Wisuda Tahfizh','3009a8f76cff791eabfe4d95d8920dd14c8'),
	(69,'B','200407','200407',' Kegiatan Pramuka','4c36ddda7b4296829526c4e3cc0f16ad6e9'),
	(68,'B','200406','200406',' Kegiatan Peringatan Hari Besar Nasional (kemerdekaan, hri guru, kartini, dll) (Event Internasional)','d6688df476c2c7d3de1b4c76196f76b9455'),
	(67,'B','200405','200405',' Kegiatan PHBI (isromiroj, muharom, maulid nabi)','eb9db715b0143999dd3dbfd88017d342743'),
	(66,'B','200404','200404',' Kegiatan Coding Project','121a28c1fea3530cf9ec833e14b59d7e370'),
	(63,'B','200401','200401',' Kegiatan Firstday Activity','9756342aa9434bea1d90292f9bbc9068762'),
	(64,'B','200402','200402',' Kegiatan Class Meeting','800d427f7b19cf64663869ea521be46c450'),
	(65,'B','200403','200403',' Kegiatan STEMbased Learning','de345b20a5d60ae7858f187e586f73574fa'),
	(53,'B','200101','200101',' Penyusunan KOSP','fae1f94c506115eaf8357ff9942318ca6e7'),
	(54,'B','200102','200102',' Penyusunan ATP &amp; Modul Ajar','bc0db1ef7e8b638c4f42fc735ee62e349bb'),
	(36,'A','100301','100301',' Bantuan Operasional Sekolah (BOS)','a6061a0c10b13bf137460ec8e143a214b05'),
	(37,'A','199999','199999',' Penerimaan Lain','174d10d8134ad94f0c285f19d5f8238d516'),
	(38,'A','100105','100105',' Penerimaan Biaya Kelas Akademik','123faaaa42b5d906c7d0fa6b50781c14bca'),
	(55,'B','200103','200103',' Raker','bd0b3e43c34a47cdbad54ae0dc3f8c01f54'),
	(56,'B','200201','200201',' Pelaksanaan PTS','fafe0a5ad92e1f868955045785ae87e5a59'),
	(57,'B','200202','200202',' Pelaksanaan PAS','452bfed404cb95d3bd44843dc50ed5f7151'),
	(58,'B','200203','200203',' Asessment Bahasa Inggris','9e9bebb2682febc01765a65b9bd7c73dc76'),
	(59,'B','200204','200204',' Pelaksanaan PAT','b543ca4b56d3cd5b149133d753cca5bdc86'),
	(60,'B','200301','200301',' Lomba Nasional','8aee09e623dfe2f7a1b551114bc7387ba44'),
	(61,'B','200302','200302',' Lomba Internasional','004ca31ed6cc03654d5fdf8016b45636370'),
	(62,'B','200303','200303',' Lomba Komisariat/Kabupaten','d9bcad1eca7b1bb53826afdcbb44dc3a6ca'),
	(50,'A','100002','100002',' Penerimaan Pembayaran Piutang Tahun lalu','bb36c34eb6644abd00d2d4669de00b12fe4'),
	(51,'A','100001','100001',' Penerimaan Saldo Bank Tahun Lalu','e2a6a1ace3526682325fbdf3406e4e795e5'),
	(52,'A','100401','100401',' Sumbangan Wakaf Infaq dan Sodaqoh','b603648a5ab54a5ef1a2220ae5bcde23676'),
	(73,'B','200411','200411',' Kegiatan Culinary Bazaar/Cooking Day','6347de7ea58afab25943e23b482df63ee1a'),
	(74,'B','200412','200412',' Kegiatan Talent Mapping/Aptitude Test','bf9eeb6625b113b89458c88c0edaa07dd62'),
	(75,'B','200413','200413',' Kegiatan Open House (trail Class)','555c267769f8f926de7a1a2393f283afb37'),
	(76,'B','200414','200414',' Kegiatan Future Leaders&#039; Camp','d630881cd860bf9a0c9a5d76786a05603bb'),
	(77,'B','200415','200415',' Kegiatan Basic Research','72c12c6ea840a9127d95f0426101121ec33'),
	(78,'B','200416','200416',' Kegiatan Edu Trip','14c909b93f05727af64c77bf22b99e60a21'),
	(79,'B','200417','200417',' Kegiatan Daurah Qur&#039;an','43e967cb0e08b622b2f7fc531f5fe46a93b'),
	(80,'B','200418','200418',' Kegiatan Olympiad Coaching','ad558f1d97f9a6502439316eb4d31dd61fc'),
	(81,'B','200419','200419',' Kegiatan Filed Trip','789149522a71b1d73e46ebb997dc4cb1cf5'),
	(82,'B','200420','200420',' Kegiatan Special Day','21ead6490ea7724af431ddb03c8ee380d61'),
	(83,'B','200421','200421',' Kegiatan Expert Arrival','d4a25f155e208121c7dfa2fb10dc5245b59'),
	(84,'B','200422','200422',' Kegiatan Ramadhan dan Itikaf','3ed2928725a528f6675b2f6983e3dac6351'),
	(85,'B','200423','200423',' Kegiatan Pentas Seni','e95b2b84f18ba722b87d4d1b444a001f020'),
	(86,'B','200424','200424',' Projek Penguatan P3','cf08ec7aced6814e8ef8b992862f2e3b903'),
	(87,'B','200501','200501',' Promosi Sekolah ( Souvenir + Fee Pendaftaran)','269727a2b3422927ded01cb6c25f9cd1758'),
	(88,'B','200502','200502',' Brosur, Spanduk, Map PPDB','e298165053c78f08c8a8883b0e4748e76ab'),
	(89,'B','200503','200503',' Digital Marketing &amp; MOU','c5a8081a0b50c26d844943d4ef192008aba'),
	(90,'B','200504','200504',' Panitia PPDB (wawancara n Test PPDB)','2ba1245d064388272fcb1220c4376409ae7'),
	(91,'B','200505','200505',' Home Visit','f586ff8517e916ef34cbb8d8fef8febbafd'),
	(92,'B','200601','200601',' Tinta Printer','fe685cb7c788f34ee4996677acf2d082cba'),
	(93,'B','200602','200602',' Spidol','27982b006f030d75f416f3fe617f84e81a6'),
	(94,'B','200603','200603',' Ballpoint','2bbb64f4948501adc02c079fc167cb9b5c4'),
	(95,'B','200604','200604',' Tinta Spidol','894ba5d3ca43f3b5483b6c3c3de2539503e'),
	(96,'B','200605','200605',' Stempel','57546c17be8d31dde328274d4a566e58170'),
	(97,'B','200606','200606',' Tinta Stempel','9d43605d09ea3b985e0567a1258fb6edb05'),
	(98,'B','200607','200607',' Penggaris Kayu','9fd36857f0a7589113c2f87c0751301e0e7'),
	(99,'B','200608','200608',' Type x','723ad4a7696067238662136cf80898cc045'),
	(100,'B','200609','200609',' Penghapus papan tulis','21d223e3b8353004bb0c48c2605b70e5ceb'),
	(101,'B','200610','200610',' Penggaris segitiga Besar','8c102a51c5ae62eb1bd8ba240e6dcc93cb1'),
	(102,'B','200611','200611',' Busur derajat Besar','99a541b1767705fed6f436608b692312ca3'),
	(103,'B','200612','200612',' Set Penggaris','93295df6dd0f83ecbe76015b8487d5270ec'),
	(104,'B','200613','200613',' Lem kertas Besar','28f5120653a8a3395a8d9991c05c5cbed47'),
	(105,'B','200614','200614',' Stapler','e484924ae85ed1ae35f0c409e803cbac43c'),
	(106,'B','200615','200615',' Isi Stapler','3d3c965b3e80829edbf4c66e9511597c761'),
	(107,'B','200616','200616',' Paper clip','63376d365d6ccac86291184f51e749ad752'),
	(108,'B','200617','200617',' Stop map','8e20f33650fe757d57b5efa40446fa10b7b'),
	(109,'B','200618','200618',' Sneilheckter','00a7955db8975a079f2bcc2470832666607'),
	(110,'B','200619','200619',' kertas concorde','a81e9040b2d45e8fdc31851d7b8b9aa6d7c'),
	(111,'B','200620','200620',' Lakban bening','e6d73ff42ca37b83669344b5eeb16ace6c4'),
	(112,'B','200621','200621',' Lakban hitam','78d0db637a6be95c725a8a509d9c3ed52f2'),
	(113,'B','200622','200622',' Lakban kertas','74f43b97b107bc17968cbfdc8b5a97dc799'),
	(114,'B','200623','200623',' Doubletip','91296996831f9d72cd1f83ba1527ff274ad'),
	(115,'B','200624','200624',' Label stiker','40922b7f18a81589d9b5bfb0fd67135d011'),
	(116,'B','200625','200625',' kertas kado','5ef9934e88e3b0826d9795880c1e6c109ff'),
	(117,'B','200626','200626',' Totebag','50e6ad5ec6ecdca921b94eaa93d06ba82f7'),
	(118,'B','200627','200627',' map sleting','bb2df5082823f0244a95dec9e5ea753d718'),
	(119,'B','200628','200628',' map holder','27b8bce892d9da5c02939e399ef61ec6af0'),
	(120,'B','200629','200629',' Odner file','78162b534e46698ea7541bbdf7cf124aa54'),
	(121,'B','200630','200630',' kertas bufalo','401e95d96df7923699c9a6c402e628f9a63'),
	(122,'B','200631','200631',' kertas HVS A4','a78d9c1d169f71cfaa8e4db7906be4d1e0d'),
	(123,'B','200632','200632',' kertas HVS F4','193872f954d96db8829aae70631e7436aab'),
	(124,'B','200633','200633',' kertas Rapor A4','e9e8509b72d958aebca36b1b8f1d731d113'),
	(125,'B','200634','200634',' Cutter','87ae00c4397ee2b06d59eb0d7f11cc68e49'),
	(126,'B','200635','200635',' Pembolong kertas','e8e162640f0a298595ce9ee867020b6a804'),
	(127,'B','200636','200636',' Keyring','dbedb1bcb4b13d65bd19e267762106b52f9'),
	(128,'B','200637','200637',' Lanyard guru n Staf','fba98cce89c2fdd246b3e8576c20097521e'),
	(129,'B','200638','200638',' Peper Note Besar','afaee984acb2676187d90035e9044943417'),
	(130,'B','200639','200639',' Pulpen Gel','aa116c7c94ce207db391bde9ee1a1178868'),
	(131,'B','200640','200640',' Schedule Board Big','4c5c0e5e6c8ee62a90aa553c4f1f77b64cb'),
	(132,'B','200641','200641',' Dudukan Lakban','fd676edf29796d0549ba8c103d57ec4825d'),
	(133,'B','200642','200642',' Stabilo Warna','727fe0a71834216333f5b5aa2e201e216be'),
	(134,'B','200643','200643',' Box file','2eafe2ccf7fb2bd16ad58f42562cb885aac'),
	(135,'B','200644','200644',' Rak Dokumen','d6a1cd07dabfa7e41dc236d9b99feeeff4a'),
	(136,'B','200645','200645',' Isi Cutter','73ca02972464d13a4ad286bee45828dbb84'),
	(137,'B','200701','200701',' Amplop buram Besar','cfe5a0b5a40b4ddca214ba3a1b8ef6b8ff2'),
	(138,'B','200702','200702',' Amplop putih sedang','3e9ce6f74e105f9e250fa2de4838def18ce'),
	(139,'B','200703','200703',' Amplop Kecil','7dc35cea71442eb9700650cf3d48fe2805f'),
	(140,'B','200704','200704',' Materai 10.000','b1ea9bb8bca9540f6d28fc1a3ccc666c792'),
	(141,'B','200801','200801',' Sabun Cuci Tangan','0196d9752bc04c20d5c3d5de2f8ca7edafe'),
	(142,'B','200802','200802',' Masker','3e731971ec06f2d4f275fb030f7227013e8'),
	(143,'B','200803','200803',' Obat  obatan UKS','99646e8670b2b36fc526df6c4c11834a430'),
	(144,'B','200804','200804',' Perlengkapan UKS','b28de7f845ff663636fa7dc9eece7250277'),
	(145,'B','200901','200901',' Pengadaan alat olahraga','b37fac3f1acf6c41cd0056e4e9a05547298'),
	(146,'B','200902','200902',' Perlengkapan praktik Seni rupa','d726518409653dd63a09dc1d86480ee1a18'),
	(147,'B','200903','200903',' Pengadaan bahan praktik IPA','5a304615e59a563a523e4ddb4adb4cde57e'),
	(148,'B','200904','200904',' Pengadaan bahan praktik IPS','d69d7ac9fea6fe06c0717cc701ac79cc6e5'),
	(149,'B','200905','200905',' Pengadaan bahan praktik matematika','0d7440ed9298c4c770295bc2516ec5c73a8'),
	(150,'B','201001','201001',' Kegiatan KKKS','7205927daeeda6c67d3f1ae63524de4c17c'),
	(151,'B','201002','201002',' Kegiatan KKG guru','6191d9a03f47c61443077e569f27932d470'),
	(152,'B','201003','201003',' Kegiatan KKG PAI','8c0c53a416d2e934dfc7ca5afbe0bb49b17'),
	(153,'B','201004','201004',' Kegiatan KKG PJOK','e298a1f431dbdff3a93e2bbaea249ce7d47'),
	(154,'B','201005','201005',' Kegiatan Upgreding guru','b74b3ff57c48eda2bf3d8c8d019d7243899'),
	(155,'B','201006','201006',' Kegiatan Kedinasan','1acbf888c0941afffdc2c7e5443a3dcbf16'),
	(156,'B','201101','201101','Overhead Kepersonaliaan','8620654f6ad3e80f72c5e56d969f7f9004a'),
	(157,'B','201102','201102',' Perjalanan Dinas dan Humas','2908e9c011c6ecb18ac4f98720687b019f3'),
	(158,'B','201103','201103',' THR guru dan Pegawai','89c3c88d08a9132856c0278bb893af0ea3e'),
	(159,'B','201201','201201',' Seragam guru dan Karyawan','ca294205968d8ef1c90658b59fa72433a37'),
	(160,'B','201202','201202',' Kegiatan Study Banding','7f522e54608e425f7069cdb1b0bc9b032e0'),
	(161,'B','201301','201301',' Rapat wali murid awal tahun','a561b35b5b7be09a160876dfa54c4ba1869'),
	(162,'B','201302','201302',' Program PPC','64eca661bdf5c11a5c276369a133c2e8c8a'),
	(163,'B','201303','201303',' Rapat wali murid','0808f7fe63bec872dd91dcfae57396fd160'),
	(164,'B','201304','201304',' Rapat wali murid akhir tahun','690ddbe66515244222b634691829f908af8'),
	(165,'B','201401','201401',' Maintenance AC','e3ad01979fd46613cb349b52889666cb55f'),
	(166,'B','201402','201402',' Pulsa Operator SMP','9c0e545ec566671a742a40b23852c6f302d'),
	(167,'B','201403','201403',' Maintenance Mobil dan Motor operasional','3b213aacc8098719e0755e3599f7a8c3f60'),
	(168,'B','201404','201404',' Maintenance Printer','b8a26aeb58dc4fe74d453a6a93bb256de28'),
	(169,'B','201405','201405',' Listrik','94f6d1149bdf9233061b774460c6b5b30f5'),
	(170,'B','201406','201406',' Wifi dan Telfon','b3eb7f91f0799870455540d00f85d55035f'),
	(171,'B','201407','201407',' Maintenance Komputer/Laptop','ac25c74e9d2abafc435a27cadaa13bd2536'),
	(172,'B','201501','201501',' Fasilitas Sekolah','0b465072fdba23327c2fad3fe4262b5c383'),
	(173,'B','201502','201502',' Buku referensi guru','f27635bc9afbfa8ba3dcedc7c604f24cb31'),
	(174,'B','201503','201503',' Buku perpustakaan','30f28d4b9812dfc839cb91bbc4869408a65'),
	(175,'B','201601','201601',' Burung Garuda dan photo presiden dan wakil','13174a5ae720f55769df3985b7a45fc945c'),
	(176,'B','201602','201602',' Dekorasi Kelas','d8c5bb17b7dbe74d5ac5fca1f07520d26b7'),
	(177,'B','201603','201603',' alat kebersihan','fc84b3c024524e8b207c89de638adb23676'),
	(178,'B','201701','201701',' bahan pembersih lantai','a66fad44699270df625bd3b78ac1ff362c4'),
	(179,'B','201702','201702',' bahan pembersih kamar mandi','a5fad663865a88a801f25361471583c34af'),
	(180,'B','201703','201703',' Pewangi ruangan','6e48cba0ec9358dbcc101258c3602c0facf'),
	(181,'B','201704','201704',' Serbet Tangan','90481e4c9c0d1b1d4f722c0eba5f41f0b97'),
	(182,'B','201705','201705',' Plastik sampah','e1e5b84d6a4a713b65fdd418c29d095c9d1'),
	(183,'B','201706','201706',' Ember','de4ae824e0c8af610387d98257cef9824b1'),
	(184,'B','201707','201707',' Gayung','430af0034a5ab04690804525b47ccdb7e00'),
	(185,'B','201708','201708',' Sapu','83222b4903463c6ee078000cad19e634a1a'),
	(186,'B','201709','201709',' alat pel','c06ed39e0bf0aacd3882a3d96d7c90be7dc'),
	(187,'B','201710','201710',' Sapu Lidi','c5242b7f3a54328744330242b1718315da5'),
	(188,'B','201801','201801',' Perawatan bangunan','96ab5cc2f028ce5722b3a4a422306aa9a06'),
	(189,'B','201802','201802',' Perbaikan mebeler','451ca5ca2c6db89e8d6c161d262b739de2c'),
	(190,'B','201901','201901',' Asuransi','7e422d8c8f68291d00ebd496a92651c17f4'),
	(191,'B','201902','201902',' Aplikasi BSI','11cb8bae9fb1e6f78e457889c2e381ce298'),
	(192,'B','202001','202001',' Peran masyarakat','16a9ef155d8347b1af585e112073f95f8c8'),
	(193,'B','202002','202002',' Pajak bangunan','ce7c33ae075211a3e1d76b30c0578872d2e'),
	(194,'B','202003','202003',' CCTV','872b94af2e168fb2d83744337145969aa57'),
	(195,'B','202004','202004',' Biaya Gedung','a2cfaac9470f824180f183c4975e37e5a9c'),
	(196,'B','202101','202101',' Dental &amp; Medical Check Up','93877243a753b94eb97d8dbc1f4ea905151'),
	(197,'B','202102','202102',' Buku Pelajaran 1 Tahun','4b80de6d6b1a0fb785c78c89e1d006a35fd'),
	(198,'B','202103','202103',' Buku Saku','e8b3ed0ab3b41af4659aadf42609d73e80f'),
	(199,'B','202104','202104',' Al Qur&#039;an','c0a9603234fb5a5a3776744cd9903a97990'),
	(200,'B','202105','202105',' Modul Tilawati','bd42fb12a5d223c64efc0a49cdb68baa198'),
	(201,'B','202201','202201',' Chromebook','8e7e5259818414f151a5da6e159e8dfbc4f'),
	(202,'B','202202','202202',' Seragam 6stel','d2d37b889e1a29090a06b692ea1c84dffac'),
	(203,'B','202203','202203',' Cover Rapot','20d432840b68a8a65efefce322505285521'),
	(204,'B','202204','202204',' Pin Sekolah','efa46b748973d409c2f655351014fc0fcb9'),
	(205,'B','202205','202205',' Aplikasi BSI','4ddf353bc73480978e457889c2e381ce298'),
	(206,'B','202206','202206',' Fasilitas Kelas','c215b25a2c969298b7e72c6c105ad298f41'),
	(207,'B','201104','201104',' Gaji guru dan Karyawan','e10b0e03a5bfc30ae32ace73e6582f80031'),
	(208,'B','201105','201105',' Tunjangan Gaji guru dari Dana BOS','22e58c737316c98d3246063efd4966cb65a'),
	(210,'B','200104','200104','ANBK','dde4acfdb0be07aae9fac964abdbca7fbc1'),
	(211,'B','200304','200304','Lomba kedinasan','fb76d4134077b3cb8658523eedbfc1ff47d'),
	(212,'B','200305','200305','Lomba Non Kedinasan','8651668492d31851765cd01c204596185d0'),
	(213,'B','200425','200425','Kegiatan market Day','35386d7f44c05418388c847904fe3b2afab'),
	(214,'B','200426','200426','Mini Research Project','5274282b5f93bf9646628843e2fe96d88bf'),
	(215,'B','200427','200427','Oddyse Plan','e68e945d5244a81be3102f3710c089080e7'),
	(216,'B','200428','200428','Project P5','d4256244492ac625e1e55b34d3bb24e4514'),
	(217,'B','201007','201007','Perjalanan Dinas dan Humas','36c9bbeac58dab9a2979ef7cade60cb9099'),
	(218,'B','201408','201408','TP Link','7f2264fd031a37ea63e39329249f4871725'),
	(219,'B','201409','201409','BPJS','52cc6bdbc253f01b51f25a72f1f8361e28e'),
	(220,'B','201410','201410','Makan Guru','3d3602f8bb928c4781251b5888d8d0c6e42'),
	(221,'B','201411','201411','Overhead','13b9d98a6333ad94bd3d77aa902ded54fe4'),
	(222,'B','202207','202207','Sovenir','6004b25b2674d3acc7297d2b8a897f017d6'),
	(223,'B','202106','202106','Assesment English (Cambriadge)','ca98ab2d8251636f5edb97b1afa1bbfa661'),
	(224,'B','201412','201412','Air Minum','c927f04afc6df964c3cf6aae13acda5023b');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_ref_kegiatan`;

CREATE TABLE IF NOT EXISTS `simakom_ref_kegiatan` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(100) NOT NULL,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `kegiatan_custome` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=127 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_ref_kegiatan` (`no`, `id`, `kategori`, `kegiatan`, `kegiatan_custome`, `uraian`) VALUES
	(112,'a9b7ba70783b617682775be85f192af3021','A','1000','1000','Penerimaan Saldo Tahun Lalu'),
	(113,'aa68c75c4a77c87eb516f153367af446a2d','A','1003','1003','Penerimaan Sumbangan Pemerintah'),
	(114,'5ec829debe54b19f0c285f19d5f8238d516','A','1999','1999','Penerimaan Lain'),
	(115,'b8c37e33defde5196797f48c50918cfed34','A','1001','1001','Penerimaan Pendapatan Asli sekolah'),
	(116,'08f90c1a41715530d57fb65210fd5641805','B','2000','2000','BELANJA PENGEMBANGAN KURIKULUM'),
	(117,'d0fb963ff976f9caa85c9573cde9eecc49c','B','2001','2001','BELANJA PENGEMBANGAN STANDARD PROSES'),
	(118,'4ba29b9f9e5732e4b0a350a73d74491c374','B','2002','2002','BELANJA PENGEMBANGAN PENDIDIKAN DAN TENAGA PENDIDIK'),
	(119,'a591024321c5e2be1e7995c3691c587c2b4','B','2003','2003','BELANJA PENGEMBANGAN STANDAR PENGELOLAAN'),
	(120,'b8b4b727d6f5d1b432ac766b69336db5531','B','2004','2004','BELANJA PENGEMBANGAN SARANA DAN PRASARANA'),
	(121,'d47268e9db2e9aa1a4664e16cca14a573a8','B','2005','2005','BELANJA PENGEMBANGAN STANDAR PEMBIAYAAN'),
	(122,'ea5a486c712a91e1a4664e16cca14a573a8','B','2006','2006','BELANJA PENGEMBANGAN STANDAR PEMBIAYAAN'),
	(123,'a00e5eb0973d246c5153b9fa7b50a30303f','B','2007','2007','PENERIMAAN SISWA BARU'),
	(124,'fba9d88164f3e2d5467853399716b596568','A','1002','1002','Penerimaan Uang Extra Kurikuler'),
	(125,'a36e841c5230a793c0924129aa796561a71','B','2999','2999','BELANJA LAINNYA'),
	(126,'fed33392d3a48aac9354242c284f97a5e37','A','1004','1004','Penerimaan Sumbangan Masyarakat');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_nama_bayar`;

CREATE TABLE IF NOT EXISTS `tb_nama_bayar` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(10) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kode` varchar(2) NOT NULL,
  `bulanan` varchar(10) NOT NULL,
  `id` varchar(15) NOT NULL,
  `blok` varchar(20) NOT NULL,
  `kelas` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_nama_bayar` (`no`, `tp`, `nama`, `kode`, `bulanan`, `id`, `blok`, `kelas`) VALUES
	(31,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024A8','','8'),
	(32,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024A9','','9'),
	(34,'2023/2024','SPP','B','Ya','2023/2024B7','','7'),
	(35,'2023/2024','SPP','B','Ya','2023/2024B8','','8'),
	(36,'2023/2024','SPP','B','Ya','2023/2024B9','','9'),
	(53,'2023/2024','Biaya Pendidikan','C','Tidak','2023/2024C8','','8'),
	(54,'2023/2024','Biaya Pendidikan','C','Tidak','2023/2024C9','','9'),
	(61,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024ALULUS','','LULUS'),
	(62,'2023/2024','Biaya Pendidikan','C','Tidak','2023/2024C7','','7'),
	(63,'2023/2024','Extrakurikuler','D','Tidak','2023/2024D7','','7'),
	(64,'2023/2024','Extrakurikuler','D','Tidak','2023/2024D8','','8'),
	(65,'2023/2024','Extrakurikuler','D','Tidak','2023/2024D9','','9'),
	(66,'2023/2024','Extrakurikuler','D','Tidak','2023/2024DLulus','','Lulus'),
	(67,'2023/2024','Kas Kelas','E','Ya','2023/2024E7','','7'),
	(68,'2023/2024','Kas Kelas','E','Ya','2023/2024E8','','8'),
	(69,'2023/2024','Kas Kelas','E','Ya','2023/2024E9','','9'),
	(70,'2023/2024','Kas Kelas','E','Ya','2023/2024ELulus','','Lulus'),
	(71,'2024/2025','Tanggungan Tahun Lalu','A','Tidak','2024/2025A8','','8'),
	(72,'2024/2025','Tanggungan Tahun Lalu','A','Tidak','2024/2025A9','','9'),
	(73,'2024/2025','Tanggungan Tahun Lalu','A','Tidak','2024/2025ALulus','','Lulus'),
	(74,'2024/2025','SPP','B','Ya','2024/2025B7','','7'),
	(75,'2024/2025','SPP','B','Ya','2024/2025B8','','8'),
	(76,'2024/2025','SPP','B','Ya','2024/2025B9','','9'),
	(77,'2024/2025','Biaya Pendidikan','C','Tidak','2024/2025C7','','7'),
	(78,'2024/2025','Biaya Pendidikan','C','Tidak','2024/2025C8','','8'),
	(79,'2024/2025','Biaya Pendidikan','C','Tidak','2024/2025C9','','9'),
	(80,'2024/2025','Extrakurikuler','D','Ya','2024/2025D7','','7'),
	(81,'2024/2025','Extrakurikuler','D','Ya','2024/2025D8','','8'),
	(82,'2024/2025','Extrakurikuler','D','Ya','2024/2025D9','','9'),
	(83,'2024/2025','Uang Pendaftaran Siswa Baru','E','Tidak','2024/2025E7','','7'),
	(84,'2024/2025','Uang Pendaftaran Siswa Baru','E','Tidak','2024/2025E8','','8'),
	(85,'2024/2025','Uang Pendaftaran Siswa Baru','E','Tidak','2024/2025E9','','9'),
	(86,'2025/2026','Tanggungan Tahun Lalu','A','Tidak','2025/2026A8','','8'),
	(87,'2025/2026','Tanggungan Tahun Lalu','A','Tidak','2025/2026A9','','9'),
	(88,'2025/2026','Tanggungan Tahun Lalu','A','Tidak','2025/2026ALulus','','Lulus'),
	(89,'2025/2026','SPP','B','Ya','2025/2026B7','','7'),
	(90,'2025/2026','SPP','B','Ya','2025/2026B8','','8'),
	(91,'2025/2026','SPP','B','Ya','2025/2026B9','','9'),
	(92,'2025/2026','Biaya Pendidikan','C','Tidak','2025/2026C9','','9'),
	(93,'2025/2026','Biaya Pendidikan','C','Tidak','2025/2026C8','','8'),
	(94,'2025/2026','Biaya Pendidikan','C','Tidak','2025/2026C7','','7'),
	(95,'2025/2026','Extrakurikuler','D','Ya','2025/2026D7','','7'),
	(96,'2025/2026','Extrakurikuler','D','Ya','2025/2026D8','','8'),
	(97,'2025/2026','Extrakurikuler','D','Ya','2025/2026D9','','9'),
	(98,'2025/2026','Uang Pendaftaran Siswa Baru','E','Tidak','2025/2026E7','','7'),
	(99,'2025/2026','Uang Pendaftaran Siswa Baru','E','Tidak','2025/2026E8','','8'),
	(100,'2025/2026','Uang Pendaftaran Siswa Baru','E','Tidak','2025/2026E9','','9');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_paralel`;

CREATE TABLE IF NOT EXISTS `tb_paralel` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(50) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `status` varchar(15) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_paralel` (`no`, `id`, `paralel`, `status`) VALUES
	(18,'9d5ed678fe57e75fa5704cf40','B','Aktif'),
	(21,'0d61f8370cad82c486547f599','C','Aktif'),
	(23,'7fc56270e7a70c1fbfac34ac2','A','Aktif'),
	(24,'f623e75af30e6f2052d0bd5ba','D','Aktif'),
	(25,'3a3ea00cfc35009f23e17ec68','E','Aktif'),
	(26,'800618943025ed73eb5b6b972','F','Aktif'),
	(27,'dfcf28d07345df1fb088c98f0','G','Aktif'),
	(33,'e11c1bc57b97131059d58b826','LULUS','Aktif');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa_kategori`;

CREATE TABLE IF NOT EXISTS `tb_siswa_kategori` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(200) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_siswa_kategori` (`no`, `kategori`, `id`, `created_at`) VALUES
	(1,'Umum','919db3a7bfc497f00ddfb51592d','2023-05-24 05:31:46'),
	(4,'MMP','606670ce12a5a75f2ada86cae30','2023-07-31 08:44:47'),
	(5,'Akademik','1603223377224863b9c36f969e2','2023-07-31 08:44:57'),
	(6,'KKO','de3ad54b3bd47253639bd484582','2023-07-31 08:45:02');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_tp`;

CREATE TABLE IF NOT EXISTS `tb_tp` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(9) NOT NULL,
  `backup` varchar(100) NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tp` (`no`, `tp`, `backup`, `time`, `id`, `created_at`, `created_by`) VALUES
	(17,'2024/2025','','2024-11-30 23:47:06','07811dc6c4229125388313f4f','2024-11-30 23:47:06','e3afed0047b08059d0fada10f400c1e5'),
	(18,'2025/2026','','2024-12-01 01:39:03','312351bff079905af7c19d51e','2024-12-01 01:39:03','e3afed0047b08059d0fada10f400c1e5'),
	(19,'2026/2027','','2025-07-23 15:54:44','c92a103243744e4ae87f39e82','2025-07-23 15:54:44','e3afed0047b08059d0fada10f400c1e5');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_walikelas`;

CREATE TABLE IF NOT EXISTS `tb_walikelas` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(9) NOT NULL,
  `jenjang` varchar(2) NOT NULL,
  `paralel` varchar(100) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `nip` varchar(18) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_walikelas` (`no`, `tp`, `jenjang`, `paralel`, `nama`, `nip`, `id`, `created_at`, `created_by`) VALUES
	(3,'2023/2024','7','A','Hani Halimah Fauzani, S. Pd','12345678','75eef25d55142bac636a','2024-12-01 01:23:55','e3afed0047b08059d0fada10f400c1e5');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `whatsapp`;

CREATE TABLE IF NOT EXISTS `whatsapp` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `aktif` varchar(1) NOT NULL,
  `sistem` varchar(2) NOT NULL,
  `key_api` text DEFAULT NULL,
  `server` text NOT NULL,
  `token` varchar(100) DEFAULT NULL,
  `device` varchar(15) DEFAULT NULL,
  `idinstance` text NOT NULL,
  `admin` varchar(15) DEFAULT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `whatsapp` (`no`, `aktif`, `sistem`, `key_api`, `server`, `token`, `device`, `idinstance`, `admin`, `id`) VALUES
	(1,'','','','','0','','','0','4FC0CC739C4F1307628C88AE1C1EF683');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_periode`;

CREATE TABLE IF NOT EXISTS `tabungan_periode` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tahun` varchar(9) NOT NULL,
  `status` varchar(6) NOT NULL,
  `created_at` datetime NOT NULL,
  `closed_at` datetime DEFAULT NULL,
  `closed_by` varchar(100) DEFAULT NULL,
  `id` varchar(25) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `tahun` (`tahun`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tabungan_periode` (`no`, `tahun`, `status`, `created_at`, `closed_at`, `closed_by`, `id`) VALUES
	(1,'2022/2023','close','2023-04-20 11:33:23','2023-10-03 05:06:19','tabungan','38eafdfa86559e303bd0'),
	(23,'2024/2025','open','2024-12-04 05:18:40','1901-01-01 00:00:00','','b97ac6497f36acec1b1f'),
	(24,'2025/2026','close','2025-06-16 22:12:58','1901-01-01 00:00:00','','13db618a1a7a067c1b1f');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_komponen2526`;

CREATE TABLE IF NOT EXISTS `simakom_komponen2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `simakom_komponen2526` (`no`, `kategori`, `kegiatan`, `komponen`, `uraian`, `kode_id`, `id`, `revisi`) VALUES
	(1,'A','1000','AA','Penerimaan Saldo Kas dan Bank Tahun Lalu','A1000AA','7fc56270e7a70faa70783b6172dffc6cb0696a3b','0'),
	(2,'A','1000','AB','Penerimaan Saldo Piutang Tahun Lalu','A1000AB','7fc56270e7a70faa70783b6176b051f63d7a2ef4','0'),
	(3,'A','1001','AA','Penerimaan SPP','A1001AA','7fc56270e7a70fae33defde512dffc6cb06e45ee','0'),
	(4,'A','1001','AB','Penerimaan Biaya Pendidikan','A1001AB','7fc56270e7a70fae33defde516b051f63d77d066','0'),
	(5,'A','1002','AA','Penerimaan Uang Extra Kurikuler','A1002AA','7fc56270e7a70fa88164f3e2d2dffc6cb06751d3','0'),
	(6,'A','1003','AA','Sumbangan Pemerintah Pusat','A1003AA','7fc56270e7a70fa75c4a77c872dffc6cb06faeac','0'),
	(7,'A','1004','AA','Sumbangan Wakaf Infaq dan Sodaqoh','A1004AA','7fc56270e7a70fa392d3a48aa2dffc6cb06fad6f','0'),
	(8,'B','2000','BA','Penyusunan Kurikulum','B2000BA','9d5ed678fe57bccc1a41715530cf62601df0a800','0'),
	(9,'B','2000','BB','Proses Pembelajaran dan Evaluasi','B2000BB','9d5ed678fe57bccc1a4171553048db16a7eea20a','0'),
	(10,'B','2000','BC','Pelaksanaan Pembinaan Lomba','B2000BC','9d5ed678fe57bccc1a4171553b377112c2784eb1','0'),
	(11,'B','2000','BD','Pengembangan Kegiatan Pembelajaran','B2000BD','9d5ed678fe57bccc1a4171553565be47147d2490','0'),
	(12,'B','2001','BA','Penerimaan Peserta Didik Baru (PPDB)','B2001BA','9d5ed678fe57bcc63ff976f9c0cf62601df44195','0'),
	(13,'B','2001','BB','Alat Pendukung Proses Pembelajaran / ATK','B2001BB','9d5ed678fe57bcc63ff976f9c048db16a7e0e510','0'),
	(14,'B','2001','BC','Pembelian Benda POS','B2001BC','9d5ed678fe57bcc63ff976f9cb377112c27af032','0'),
	(15,'B','2001','BD','Peralatan kesehatan dan keselamatan','B2001BD','9d5ed678fe57bcc63ff976f9c565be4714773f76','0'),
	(16,'B','2001','BE','Pembelian Alat / Bahan Penunjang KBM','B2001BE','9d5ed678fe57bcc63ff976f9c429c679f9a738cc','0'),
	(17,'B','2002','BA','Rapat Kerja Guru dan Pegawai','B2002BA','9d5ed678fe57bccb9f9e5732e0cf62601df7658d','0'),
	(18,'B','2002','BB','Honorarium','B2002BB','9d5ed678fe57bccb9f9e5732e048db16a7e9c3ce','0'),
	(19,'B','2002','BC','Pengembangan Manajemen Sekolah','B2002BC','9d5ed678fe57bccb9f9e5732eb377112c278f03a','0'),
	(20,'B','2003','BA','Rapat Pengelolaan Sekolah','B2003BA','9d5ed678fe57bcc24321c5e2b0cf62601dff803d','0'),
	(21,'B','2003','BB','Langganan daya dan jasa','B2003BB','9d5ed678fe57bcc24321c5e2b048db16a7e7f514','0'),
	(22,'B','2003','BC','Belanja Modal','B2003BC','9d5ed678fe57bcc24321c5e2bb377112c278fc4c','0'),
	(23,'B','2004','BA','Pemeliharaan Kelas','B2004BA','9d5ed678fe57bcc727d6f5d1b0cf62601dfdefd4','0'),
	(26,'B','2005','BA','Pembiayaan Program Pembelajaran','B2005BA','9d5ed678fe57bcc8e9db2e9aa0cf62601df3994f','0'),
	(27,'B','2005','BB','Pembiayaan lain-lain','B2005BB','9d5ed678fe57bcc8e9db2e9aa048db16a7ecf2e4','0'),
	(28,'B','2006','BA','Perlengkapan Siswa ( Kelas 8 )','B2006BA','9d5ed678fe57bcc86c712a91e0cf62601df5c7d5','0'),
	(30,'B','2999','BA','Belanja Lainnya','B2999BA','9d5ed678fe57bcc41c5230a790cf62601df28fd0','0'),
	(31,'B','2006','BB','Perlengkapan Siswa ( Kelas 9 )','B2006BB','9d5ed86c712a91e048db16a7eee539e93e3618cbe725-06','0'),
	(32,'B','2006','BC','Perlengkapan Siswa Baru ( Kelas 7 )','B2006BC','9d5ed86c712a91eb377112c272bc87f3e73f10508d25-06','0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_kegiatan2526`;

CREATE TABLE IF NOT EXISTS `simakom_kegiatan2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `simakom_kegiatan2526` (`no`, `kategori`, `kegiatan`, `uraian`, `kode_id`, `id`, `revisi`) VALUES
	(1,'A','1000','Penerimaan Saldo Tahun Lalu','A1000','7fc56270e7a70faa70783b617e9998dc4dd96a3b','0'),
	(2,'A','1001','Penerimaan Pendapatan Asli sekolah','A1001','7fc56270e7a70fae33defde51cf91e1e03ea2ef4','0'),
	(3,'A','1002','Penerimaan Uang Extra Kurikuler','A1002','7fc56270e7a70fa88164f3e2d9109ee7702e45ee','0'),
	(4,'A','1003','Penerimaan Sumbangan Pemerintah','A1003','7fc56270e7a70fa75c4a77c87f97fb686b27d066','0'),
	(5,'A','1004','Penerimaan Sumbangan Masyarakat','A1004','7fc56270e7a70fa392d3a48aa149a87a38b751d3','0'),
	(6,'A','1999','Penerimaan Lain','A1999','7fc56270e7a70fa9debe54b19a5f78d9a65faeac','0'),
	(7,'B','2000','BELANJA PENGEMBANGAN KURIKULUM','B2000','9d5ed678fe57bccc1a417155361a5c4b8d2af032','0'),
	(8,'B','2001','BELANJA PENGEMBANGAN STANDARD PROSES','B2001','9d5ed678fe57bcc63ff976f9c37fc81fe0373f76','0'),
	(9,'B','2002','BELANJA PENGEMBANGAN PENDIDIKAN DAN TENAGA PENDIDIK','B2002','9d5ed678fe57bccb9f9e5732ed33761840f738cc','0'),
	(10,'B','2003','BELANJA PENGEMBANGAN STANDAR PENGELOLAAN','B2003','9d5ed678fe57bcc24321c5e2bdbd23ed35f7658d','0'),
	(11,'B','2004','BELANJA PENGEMBANGAN SARANA DAN PRASARANA','B2004','9d5ed678fe57bcc727d6f5d1b61fff7be689c3ce','0'),
	(12,'B','2005','BELANJA PENGEMBANGAN STANDAR PEMBIAYAAN','B2005','9d5ed678fe57bcc8e9db2e9aa3827bba3af8f03a','0'),
	(13,'B','2006','BELANJA PENGEMBANGAN STANDAR PEMBIAYAAN','B2006','9d5ed678fe57bcc86c712a91e48443cd802f803d','0'),
	(15,'B','2999','BELANJA LAINNYA','B2999','9d5ed678fe57bcc41c5230a79c2102036d28fc4c','0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_akun2526`;

CREATE TABLE IF NOT EXISTS `simakom_akun2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `akun` float NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `akun_id` varchar(15) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=191 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `simakom_akun2526` (`no`, `kategori`, `kegiatan`, `komponen`, `akun`, `uraian`, `kode_id`, `akun_id`, `id`, `revisi`) VALUES
	(1,'A','1000','AA',100000,'Penerimaan Saldo Kas dan Bank Tahun Lalu','A1000AA','A1000100000AA','7fc56270e7a70783b6172dffc6cb062eaba96a3b','0'),
	(2,'A','1000','AA',100001,'Penerimaan Saldo Bank Tahun Lalu','A1000AA','A1000100001AA','7fc56270e7a70783b6172dffc6cb061ace3a2ef4','0'),
	(3,'A','1000','AB',100002,'Penerimaan Pembayaran Piutang Tahun lalu','A1000AB','A1000100002AB','7fc56270e7a70783b6176b051f63d734eb6e45ee','0'),
	(4,'A','1001','AA',100101,'Penerimaan SPP','A1001AA','A1001100101AA','7fc56270e7e33defde512dffc6cb0676ec8751d3','0'),
	(5,'A','1001','AB',100102,'Penerimaan Biaya Pendidikan','A1001AB','A1001100102AB','7fc56270e7e33defde516b051f63d7a338dfaeac','0'),
	(6,'A','1002','AA',100201,'Penerimaan Biaya Extrakurikuler','A1002AA','A1002100201AA','7fc56270e788164f3e2d2dffc6cb063f13ed72d1','0'),
	(7,'A','1003','AA',100301,'Bantuan Operasional Sekolah (BOS)','A1003AA','A1003100301AA','7fc56270e775c4a77c872dffc6cb06a0c10fad6f','0'),
	(8,'A','1004','AA',100401,'Sumbangan Wakaf Infaq dan Sodaqoh','A1004AA','A1004100401AA','7fc56270e7392d3a48aa2dffc6cb0648a5aea20a','0'),
	(9,'B','2000','BA',200101,'Penyusunan KOSP','B2000BA','B2000200101BA','9d5ed678fec1a41715530cf62601df94c5084eb1','0'),
	(10,'B','2000','BA',200102,'Penyusunan ATP & Modul Ajar','B2000BA','B2000200102BA','9d5ed678fec1a41715530cf62601df1ef7ed2490','0'),
	(11,'B','2000','BA',200103,'Raker','B2000BA','B2000200103BA','9d5ed678fec1a41715530cf62601dfe43c344195','0'),
	(12,'B','2000','BB',200201,'Pelaksanaan PTS','B2000BB','B2000200201BB','9d5ed678fec1a4171553048db16a7ea5ad90e510','0'),
	(13,'B','2000','BB',200202,'Pelaksanaan PAS','B2000BB','B2000200202BB','9d5ed678fec1a4171553048db16a7eed404af032','0'),
	(15,'B','2000','BB',200204,'Pelaksanaan PAT','B2000BB','B2000200204BB','9d5ed678fec1a4171553048db16a7ea4b56738cc','0'),
	(18,'B','2000','BC',200303,'Lomba Komisariat/Kabupaten','B2000BC','B2000200303BC','9d5ed678fec1a4171553b377112c27d1eca8f03a','0'),
	(19,'B','2000','BD',200401,'Kegiatan Firstday Activity','B2000BD','B2000200401BD','9d5ed678fec1a4171553565be4714742aa9f803d','0'),
	(20,'B','2000','BD',200402,'Kegiatan Class Meeting','B2000BD','B2000200402BD','9d5ed678fec1a4171553565be4714727f7b7f514','0'),
	(21,'B','2000','BD',200403,'Kegiatan STEM-based Learning','B2000BD','B2000200403BD','9d5ed678fec1a4171553565be47147b20a58fc4c','0'),
	(22,'B','2000','BD',200404,'Kegiatan Coding Project','B2000BD','B2000200404BD','9d5ed678fec1a4171553565be471478c1fedefd4','0'),
	(23,'B','2000','BD',200405,'Kegiatan PHBI (isromiroj, muharom, maulid nabi)','B2000BD','B2000200405BD','9d5ed678fec1a4171553565be47147715b0c4de9','0'),
	(24,'B','2000','BD',200406,'Kegiatan Peringatan Hari Besar Nasional (kemerdekaan, hri guru, kartini, dll) (Event Internasional)','B2000BD','B2000200406BD','9d5ed678fec1a4171553565be47147df4762c621','0'),
	(25,'B','2000','BD',200407,'Kegiatan Pramuka','B2000BD','B2000200407BD','9d5ed678fec1a4171553565be47147dda7b3994f','0'),
	(26,'B','2000','BD',200408,'Kegiatan Wisuda Tahfizh','B2000BD','B2000200408BD','9d5ed678fec1a4171553565be471478f76ccf2e4','0'),
	(27,'B','2000','BD',200409,'Kegiatan Odyssey Plan ( Pisikolog)','B2000BD','B2000200409BD','9d5ed678fec1a4171553565be4714710b615c7d5','0'),
	(28,'B','2000','BD',200410,'Kegiatan Tasmi Qur\'an','B2000BD','B2000200410BD','9d5ed678fec1a4171553565be47147ad0d39f9ce','0'),
	(29,'B','2000','BD',200411,'Kegiatan Culinary Bazaar/Cooking Day','B2000BD','B2000200411BD','9d5ed678fec1a4171553565be47147e7ea528fd0','0'),
	(31,'B','2000','BD',200413,'Kegiatan Open House (trail Class)','B2000BD','B2000200413BD','9d5ed678fec1a4171553565be47147677691732c','0'),
	(32,'B','2000','BD',200414,'Kegiatan Future Leaders\' Camp','B2000BD','B2000200414BD','9d5ed678fec1a4171553565be4714781cd8e1eee','0'),
	(33,'B','2000','BD',200415,'Kegiatan Basic Research','B2000BD','B2000200415BD','9d5ed678fec1a4171553565be47147c6ea87d06a','0'),
	(34,'B','2000','BD',200416,'Kegiatan Edu Trip','B2000BD','B2000200416BD','9d5ed678fec1a4171553565be471479b93f26180','0'),
	(35,'B','2000','BD',200417,'Kegiatan Daurah Qur\'an','B2000BD','B2000200417BD','9d5ed678fec1a4171553565be471477cb0eb6aea','0'),
	(36,'B','2000','BD',200418,'Kegiatan Olympiad Coaching','B2000BD','B2000200418BD','9d5ed678fec1a4171553565be47147f1d97842f3','0'),
	(37,'B','2000','BD',200419,'Kegiatan Filed Trip','B2000BD','B2000200419BD','9d5ed678fec1a4171553565be471479522a2a452','0'),
	(38,'B','2000','BD',200420,'Kegiatan Special Day','B2000BD','B2000200420BD','9d5ed678fec1a4171553565be471476490e21add','0'),
	(39,'B','2000','BD',200421,'Kegiatan Expert Arrival','B2000BD','B2000200421BD','9d5ed678fec1a4171553565be47147f155ea27ef','0'),
	(40,'B','2000','BD',200422,'Kegiatan Ramadhan dan Itikaf','B2000BD','B2000200422BD','9d5ed678fec1a4171553565be47147287252ba10','0'),
	(41,'B','2000','BD',200423,'Kegiatan Pentas Seni','B2000BD','B2000200423BD','9d5ed678fec1a4171553565be47147b84f12f1ee','0'),
	(43,'B','2001','BA',200501,'Promosi Sekolah ( Souvenir + Fee Pendaftaran)','B2001BA','B2001200501BA','9d5ed678fe63ff976f9c0cf62601df7a2b3e46d0','0'),
	(44,'B','2001','BA',200502,'Brosur, Spanduk, Map PPDB','B2001BA','B2001200502BA','9d5ed678fe63ff976f9c0cf62601df65053bf97f','0'),
	(45,'B','2001','BA',200503,'Digital Marketing & MOU','B2001BA','B2001200503BA','9d5ed678fe63ff976f9c0cf62601df81a0b2c4a8','0'),
	(46,'B','2001','BA',200504,'Panitia PPDB (wawancara n Test PPDB)','B2001BA','B2001200504BA','9d5ed678fe63ff976f9c0cf62601df45d066d4a6','0'),
	(47,'B','2001','BA',200505,'Home Visit','B2001BA','B2001200505BA','9d5ed678fe63ff976f9c0cf62601dff851765cfe','0'),
	(48,'B','2001','BB',200601,'Tinta Printer','B2001BB','B2001200601BB','9d5ed678fe63ff976f9c048db16a7ecb7c7a3458','0'),
	(49,'B','2001','BB',200602,'Spidol','B2001BB','B2001200602BB','9d5ed678fe63ff976f9c048db16a7eb006f8c961','0'),
	(50,'B','2001','BB',200603,'Ballpoint','B2001BB','B2001200603BB','9d5ed678fe63ff976f9c048db16a7e4f494a71d8','0'),
	(51,'B','2001','BB',200604,'Tinta Spidol','B2001BB','B2001200604BB','9d5ed678fe63ff976f9c048db16a7e5d3ca5759d','0'),
	(52,'B','2001','BB',200605,'Stempel','B2001BB','B2001200605BB','9d5ed678fe63ff976f9c048db16a7ec17bef75c3','0'),
	(53,'B','2001','BB',200606,'Tinta Stempel','B2001BB','B2001200606BB','9d5ed678fe63ff976f9c048db16a7e05d09b7923','0'),
	(54,'B','2001','BB',200607,'Penggaris Kayu','B2001BB','B2001200607BB','9d5ed678fe63ff976f9c048db16a7e857f088dda','0'),
	(55,'B','2001','BB',200608,'Type x','B2001BB','B2001200608BB','9d5ed678fe63ff976f9c048db16a7e4a769671f8','0'),
	(56,'B','2001','BB',200609,'Penghapus papan tulis','B2001BB','B2001200609BB','9d5ed678fe63ff976f9c048db16a7e3e3b8e7db5','0'),
	(57,'B','2001','BB',200610,'Penggaris segitiga Besar','B2001BB','B2001200610BB','9d5ed678fe63ff976f9c048db16a7ea51c568267','0'),
	(58,'B','2001','BB',200611,'Busur derajat Besar','B2001BB','B2001200611BB','9d5ed678fe63ff976f9c048db16a7e1b17603b90','0'),
	(59,'B','2001','BB',200612,'Set Penggaris','B2001BB','B2001200612BB','9d5ed678fe63ff976f9c048db16a7edf6dd307fd','0'),
	(60,'B','2001','BB',200613,'Lem kertas Besar','B2001BB','B2001200613BB','9d5ed678fe63ff976f9c048db16a7e2065318230','0'),
	(61,'B','2001','BB',200614,'Stapler','B2001BB','B2001200614BB','9d5ed678fe63ff976f9c048db16a7e24ae8f157b','0'),
	(62,'B','2001','BB',200615,'Isi Stapler','B2001BB','B2001200615BB','9d5ed678fe63ff976f9c048db16a7e65b3eb34f3','0'),
	(63,'B','2001','BB',200616,'Paper clip','B2001BB','B2001200616BB','9d5ed678fe63ff976f9c048db16a7ed365da91f7','0'),
	(64,'B','2001','BB',200617,'Stop map','B2001BB','B2001200617BB','9d5ed678fe63ff976f9c048db16a7e336507ba15','0'),
	(65,'B','2001','BB',200618,'Sneilheckter','B2001BB','B2001200618BB','9d5ed678fe63ff976f9c048db16a7e55db884150','0'),
	(66,'B','2001','BB',200619,'kertas concorde','B2001BB','B2001200619BB','9d5ed678fe63ff976f9c048db16a7e040b2fb849','0'),
	(67,'B','2001','BB',200620,'Lakban bening','B2001BB','B2001200620BB','9d5ed678fe63ff976f9c048db16a7eff42c275a9','0'),
	(68,'B','2001','BB',200621,'Lakban hitam','B2001BB','B2001200621BB','9d5ed678fe63ff976f9c048db16a7eb637aa7228','0'),
	(69,'B','2001','BB',200622,'Lakban kertas','B2001BB','B2001200622BB','9d5ed678fe63ff976f9c048db16a7eb97b1a74b5','0'),
	(70,'B','2001','BB',200623,'Doubletip','B2001BB','B2001200623BB','9d5ed678fe63ff976f9c048db16a7e99683c4258','0'),
	(71,'B','2001','BB',200624,'Label stiker','B2001BB','B2001200624BB','9d5ed678fe63ff976f9c048db16a7eb7f18871c1','0'),
	(72,'B','2001','BB',200625,'kertas kado','B2001BB','B2001200625BB','9d5ed678fe63ff976f9c048db16a7e34e8831c8f','0'),
	(73,'B','2001','BB',200626,'Totebag','B2001BB','B2001200626BB','9d5ed678fe63ff976f9c048db16a7ed5ec6207f4','0'),
	(74,'B','2001','BB',200627,' map sleting','B2001BB','B2001200627BB','9d5ed678fe63ff976f9c048db16a7e50828ba55f','0'),
	(75,'B','2001','BB',200628,' map holder','B2001BB','B2001200628BB','9d5ed678fe63ff976f9c048db16a7ece892a8614','0'),
	(76,'B','2001','BB',200629,' Odner file','B2001BB','B2001200629BB','9d5ed678fe63ff976f9c048db16a7eb534eb1e0a','0'),
	(77,'B','2001','BB',200630,' kertas bufalo','B2001BB','B2001200630BB','9d5ed678fe63ff976f9c048db16a7e5d96d38b18','0'),
	(78,'B','2001','BB',200631,' kertas HVS A4','B2001BB','B2001200631BB','9d5ed678fe63ff976f9c048db16a7ec1d1631b7b','0'),
	(79,'B','2001','BB',200632,' kertas HVS F4','B2001BB','B2001200632BB','9d5ed678fe63ff976f9c048db16a7e2f95413c02','0'),
	(80,'B','2001','BB',200633,' kertas Rapor A4','B2001BB','B2001200633BB','9d5ed678fe63ff976f9c048db16a7e09b7206eb1','0'),
	(81,'B','2001','BB',200634,' Cutter','B2001BB','B2001200634BB','9d5ed678fe63ff976f9c048db16a7e0c43918bbc','0'),
	(82,'B','2001','BB',200635,' Pembolong kertas','B2001BB','B2001200635BB','9d5ed678fe63ff976f9c048db16a7e2640f37bc1','0'),
	(83,'B','2001','BB',200636,' Keyring','B2001BB','B2001200636BB','9d5ed678fe63ff976f9c048db16a7e1bcb4914b6','0'),
	(84,'B','2001','BB',200637,' Lanyard guru n Staf','B2001BB','B2001200637BB','9d5ed678fe63ff976f9c048db16a7ecce89bbf14','0'),
	(85,'B','2001','BB',200638,' Peper Note Besar','B2001BB','B2001200638BB','9d5ed678fe63ff976f9c048db16a7e984ac962e6','0'),
	(86,'B','2001','BB',200639,' Pulpen Gel','B2001BB','B2001200639BB','9d5ed678fe63ff976f9c048db16a7ec7c94d5f03','0'),
	(87,'B','2001','BB',200640,' Schedule Board Big','B2001BB','B2001200640BB','9d5ed678fe63ff976f9c048db16a7ee5e6c5072d','0'),
	(88,'B','2001','BB',200641,' Dudukan Lakban','B2001BB','B2001200641BB','9d5ed678fe63ff976f9c048db16a7eedf2956d9b','0'),
	(89,'B','2001','BB',200642,' Stabilo Warna','B2001BB','B2001200642BB','9d5ed678fe63ff976f9c048db16a7e0a718d2716','0'),
	(90,'B','2001','BB',200643,' Box file','B2001BB','B2001200643BB','9d5ed678fe63ff976f9c048db16a7e2ccf7e6477','0'),
	(91,'B','2001','BB',200644,' Rak Dokumen','B2001BB','B2001200644BB','9d5ed678fe63ff976f9c048db16a7ed07daf4368','0'),
	(92,'B','2001','BB',200645,' Isi Cutter','B2001BB','B2001200645BB','9d5ed678fe63ff976f9c048db16a7e29724ebf11','0'),
	(93,'B','2001','BC',200701,' Amplop buram Besar','B2001BC','B2001200701BC','9d5ed678fe63ff976f9cb377112c270b5a4fb9ce','0'),
	(94,'B','2001','BC',200702,' Amplop putih sedang','B2001BC','B2001200702BC','9d5ed678fe63ff976f9cb377112c276f74e95b30','0'),
	(95,'B','2001','BC',200703,' Amplop Kecil','B2001BC','B2001200703BC','9d5ed678fe63ff976f9cb377112c27cea7164b2c','0'),
	(96,'B','2001','BC',200704,' Materai 10.000','B2001BC','B2001200704BC','9d5ed678fe63ff976f9cb377112c27bb8bc92daa','0'),
	(97,'B','2001','BD',200801,' Sabun Cuci Tangan','B2001BD','B2001200801BD','9d5ed678fe63ff976f9c565be471479752b86380','0'),
	(98,'B','2001','BD',200802,' Masker','B2001BD','B2001200802BD','9d5ed678fe63ff976f9c565be47147971ecdb2f4','0'),
	(99,'B','2001','BD',200803,' Obat - obatan UKS','B2001BD','B2001200803BD','9d5ed678fe63ff976f9c565be47147e8670814f0','0'),
	(100,'B','2001','BD',200804,' Perlengkapan UKS','B2001BD','B2001200804BD','9d5ed678fe63ff976f9c565be471477f845d81b9','0'),
	(101,'B','2001','BE',200901,' Pengadaan alat olahraga','B2001BE','B2001200901BE','9d5ed678fe63ff976f9c429c679f9ac3f1ab0f07','0'),
	(102,'B','2001','BE',200902,' Perlengkapan praktik Seni rupa','B2001BE','B2001200902BE','9d5ed678fe63ff976f9c429c679f9a18409be6c5','0'),
	(103,'B','2001','BE',200903,' Pengadaan bahan praktik IPA','B2001BE','B2001200903BE','9d5ed678fe63ff976f9c429c679f9a615e528b0e','0'),
	(104,'B','2001','BE',200904,' Pengadaan bahan praktik IPS','B2001BE','B2001200904BE','9d5ed678fe63ff976f9c429c679f9aac9fe84f7b','0'),
	(105,'B','2001','BE',200905,' Pengadaan bahan praktik matematika','B2001BE','B2001200905BE','9d5ed678fe63ff976f9c429c679f9a0ed9213448','0'),
	(106,'B','2002','BA',201001,' Kegiatan KKKS','B2002BA','B2002201001BA','9d5ed678feb9f9e5732e0cf62601df27daee3ce1','0'),
	(107,'B','2002','BA',201002,' Kegiatan KKG guru','B2002BA','B2002201002BA','9d5ed678feb9f9e5732e0cf62601df9a03fbbe90','0'),
	(108,'B','2002','BA',201003,' Kegiatan KKG PAI','B2002BA','B2002201003BA','9d5ed678feb9f9e5732e0cf62601df3a4162a66a','0'),
	(109,'B','2002','BA',201004,' Kegiatan KKG PJOK','B2002BA','B2002201004BA','9d5ed678feb9f9e5732e0cf62601df1f4317d7c4','0'),
	(111,'B','2002','BA',201006,' Kegiatan Kedinasan','B2002BA','B2002201006BA','9d5ed678feb9f9e5732e0cf62601df888c0d64af','0'),
	(113,'B','2002','BB',201102,' Perjalanan Dinas dan Humas','B2002BB','B2002201102BB','9d5ed678feb9f9e5732e048db16a7e9c0114bc8f','0'),
	(115,'B','2002','BC',201201,' Seragam guru dan Karyawan','B2002BC','B2002201201BC','9d5ed678feb9f9e5732eb377112c2720596c88a4','0'),
	(117,'B','2003','BA',201301,' Rapat wali murid awal tahun','B2003BA','B2003201301BA','9d5ed678fe24321c5e2b0cf62601df35b5bed5fc','0'),
	(120,'B','2003','BA',201304,' Rapat wali murid akhir tahun','B2003BA','B2003201304BA','9d5ed678fe24321c5e2b0cf62601dfbe665f0f4b','0'),
	(121,'B','2003','BB',201401,' Maintenance AC','B2003BB','B2003201401BB','9d5ed678fe24321c5e2b048db16a7e1979feb62f','0'),
	(122,'B','2003','BB',201402,' Pulsa Operator SMP','B2003BB','B2003201402BB','9d5ed678fe24321c5e2b048db16a7e45ec5a4bab','0'),
	(124,'B','2003','BB',201404,' Maintenance Printer','B2003BB','B2003201404BB','9d5ed678fe24321c5e2b048db16a7eaeb58f6c0c','0'),
	(127,'B','2003','BB',201407,' Maintenance Komputer/Laptop','B2003BB','B2003201407BB','9d5ed678fe24321c5e2b048db16a7e74e9dc22b7','0'),
	(128,'B','2003','BC',201501,' Fasilitas Sekolah','B2003BC','B2003201501BC','9d5ed678fe24321c5e2bb377112c27072fd2f863','0'),
	(132,'B','2004','BA',201602,' Dekorasi Kelas','B2004BA','B2004201602BA','9d5ed678fe727d6f5d1b0cf62601dfb17b7a9bd0','0'),
	(149,'B','2005','BB',202002,' Pajak bangunan','B2005BB','B2005202002BB','9d5ed678fe8e9db2e9aa048db16a7e3ae07f0bb9','0'),
	(165,'B','2005','BA',202101,' Dental & Medical Check Up','B2005BA','B2005202101BA','43a759d5ed268e90cf62601df84b7923b9964c53e625-06','0'),
	(167,'B','2006','BA',202102,' Buku Pelajaran 1 Tahun','B2006BA','B2006202102BA','6d6b19d5eda486c0cf62601df84b7923b9964c53e625-06','0'),
	(168,'B','2006','BA',202103,' Buku Saku','B2006BA','B2006202103BA','0ab3b9d5eda486c0cf62601df84b7923b9964c53e625-06','0'),
	(169,'B','2006','BB',202102,' Buku Pelajaran 1 Tahun','B2006BB','B2006202102BB','6d6b19d5eda486c048db16a7eee539e93e3618cbe725-06','0'),
	(170,'B','2006','BB',202103,' Buku Saku','B2006BB','B2006202103BB','0ab3b9d5eda486c048db16a7eee539e93e3618cbe725-06','0'),
	(171,'B','2006','BB',202106,'Assesment English (Cambriadge)','B2006BB','B2006202106BB','2d8259d5eda486c048db16a7eee539e93e3618cbe725-06','0'),
	(172,'B','2006','BC',202102,' Buku Pelajaran 1 Tahun','B2006BC','B2006202102BC','6d6b19d5eda486cb377112c272bc87f3e73f10508d25-06','0'),
	(173,'B','2006','BC',202103,' Buku Saku','B2006BC','B2006202103BC','0ab3b9d5eda486cb377112c272bc87f3e73f10508d25-06','0'),
	(174,'B','2006','BC',202201,' Chromebook','B2006BC','B2006202201BC','598189d5eda486cb377112c272bc87f3e73f10508d25-06','0'),
	(175,'B','2006','BC',202202,' Seragam 6stel','B2006BC','B2006202202BC','889e19d5eda486cb377112c272bc87f3e73f10508d25-06','0'),
	(176,'B','2006','BC',202203,' Cover Rapot','B2006BC','B2006202203BC','840b69d5eda486cb377112c272bc87f3e73f10508d25-06','0'),
	(177,'B','2006','BC',202204,' Pin Sekolah','B2006BC','B2006202204BC','748979d5eda486cb377112c272bc87f3e73f10508d25-06','0'),
	(178,'B','2006','BC',202205,' Aplikasi BSI','B2006BC','B2006202205BC','3bc739d5eda486cb377112c272bc87f3e73f10508d25-06','0'),
	(179,'B','2006','BC',202207,'Sovenir','B2006BC','B2006202207BC','5b2679d5eda486cb377112c272bc87f3e73f10508d25-06','0'),
	(180,'B','2000','BA',200104,'ANBK','B2000BA','B2000200104BA','fdb0b9d5ed90c1a0cf62601df84b7923b9964c53e625-06','0'),
	(181,'B','2000','BC',200304,'Lomba kedinasan','B2000BC','B2000200304BC','134079d5ed90c1ab377112c272bc87f3e73f10508d25-06','0'),
	(182,'B','2000','BC',200305,'Lomba Non Kedinasan','B2000BC','B2000200305BC','8492d9d5ed90c1ab377112c272bc87f3e73f10508d25-06','0'),
	(183,'B','2000','BD',200428,'Project P5','B2000BD','B2000200428BD','444929d5ed90c1a565be4714701a8bc2354cbaea3625-06','0'),
	(184,'B','2005','BA',201104,' Gaji guru dan Karyawan','B2005BA','B2005201104BA','03a5b9d5ed268e90cf62601df84b7923b9964c53e625-06','0'),
	(185,'B','2005','BA',201405,' Listrik','B2005BA','B2005201405BA','149bd9d5ed268e90cf62601df84b7923b9964c53e625-06','0'),
	(186,'B','2005','BA',201406,' Wifi dan Telfon','B2005BA','B2005201406BA','91f079d5ed268e90cf62601df84b7923b9964c53e625-06','0'),
	(187,'B','2005','BA',201409,'BPJS','B2005BA','B2005201409BA','dbc259d5ed268e90cf62601df84b7923b9964c53e625-06','0'),
	(188,'B','2005','BA',201410,'Makan Guru','B2005BA','B2005201410BA','f8bb99d5ed268e90cf62601df84b7923b9964c53e625-06','0'),
	(189,'B','2005','BA',201411,'Overhead','B2005BA','B2005201411BA','8a6339d5ed268e90cf62601df84b7923b9964c53e625-06','0'),
	(190,'B','2005','BA',201412,'Air Minum','B2005BA','B2005201412BA','4afc69d5ed268e90cf62601df84b7923b9964c53e625-06','0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_detail2526`;

CREATE TABLE IF NOT EXISTS `simakom_detail2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `akun` float NOT NULL,
  `detail` float NOT NULL,
  `detail_id` varchar(20) NOT NULL,
  `uraian` text NOT NULL,
  `volume` varchar(15) NOT NULL,
  `satuan` varchar(50) NOT NULL,
  `unit` varchar(50) NOT NULL,
  `total` varchar(15) NOT NULL,
  `komponen_1` varchar(10) NOT NULL,
  `komponen_2` varchar(10) NOT NULL,
  `komponen_3` varchar(10) NOT NULL,
  `komponen_4` varchar(10) NOT NULL,
  `unit_1` varchar(100) NOT NULL,
  `unit_2` varchar(100) NOT NULL,
  `unit_3` varchar(100) NOT NULL,
  `unit_4` varchar(100) NOT NULL,
  `pembiayaan_id` varchar(50) NOT NULL,
  `pembiayaan_kegiatan` varchar(4) NOT NULL,
  `pembiayaan_komponen` varchar(5) NOT NULL,
  `pembiayaan_akun` varchar(6) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  `time` datetime NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=191 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `simakom_detail2526` (`no`, `kategori`, `kegiatan`, `komponen`, `akun`, `detail`, `detail_id`, `uraian`, `volume`, `satuan`, `unit`, `total`, `komponen_1`, `komponen_2`, `komponen_3`, `komponen_4`, `unit_1`, `unit_2`, `unit_3`, `unit_4`, `pembiayaan_id`, `pembiayaan_kegiatan`, `pembiayaan_komponen`, `pembiayaan_akun`, `revisi`, `time`, `kode_id`, `id`) VALUES
	(1,'A','1000','AA',100000,1,'A1000AA10000000100','Penerimaan Saldo Kas Tahun Lalu','1','0','Tahun','0','','','','','','','','','','','','','0','2025-06-13 08:55:28','A1000AA','eab3d34a4230849508495cd98f096a3b'),
	(2,'A','1000','AA',100001,1,'A1000AA10000100100','Penerimaan Saldo Bank BSI Tahun Lalu','1','0','Tahun','0','','','','','','','','','','','','','0','2025-06-13 08:55:28','A1000AA','acefec7a4230849508495cd98f0a2ef4'),
	(3,'A','1000','AB',100002,1,'A1000AB10000200100','Penerimaan Pembayaran Piutang Tahun lalu','1','0','Tahun','0','','','','','','','','','','','','','0','2025-06-13 08:55:28','A1000AB','4eb8327a4230849508495cd98f0e45ee'),
	(4,'A','1001','AA',100101,1,'A1001AA10010100100','Penerimaan SPP','1','327500000','Tahun','327500000','','','','','','','','','','','','','0','2025-07-09 21:23:11','A1001AA','6ec3ce9a423e32c5e32c5cd98f0751d3'),
	(5,'A','1001','AB',100102,1,'A1001AB10010200100','Penerimaan Biaya Pendidikan','1','431700000','Tahun','431700000','','','','','','','','','','','','','0','2025-07-09 21:22:44','A1001AB','338a738a423d219fd219fcd98f0faeac'),
	(6,'A','1002','AA',100201,1,'A1002AA10020100100','Penerimaan Biaya Extrakurikuler','1','0','Bulan','0','','','','','','','','','','','','','0','2025-06-13 08:55:28','A1002AA','f130dcaa4230849508495cd98f0d72d1'),
	(7,'A','1003','AA',100301,1,'A1003AA10030100100','Bantuan Operasional Sekolah (BOS)','0',' 31320000 ','Tahun','0','','','','','','','','','','','','','0','2025-06-16 13:26:03','A1003AA','0c19c09a4230849508495cd98f0fad6f'),
	(8,'B','2000','BA',200101,1,'B2000BA20010100100','Penyusunan KOSP','1','50000','Paket','50000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 14:59:39','B2000BA','4c58484a423d2829d2829a338d7ea20a'),
	(9,'B','2000','BA',200102,1,'B2000BA20010200100','Penyusunan ATP &amp; Modul Ajar','1','400000','Paket','400000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:00:03','B2000BA','ef7bda3a423732a2732a2a338d784eb1'),
	(10,'B','2000','BA',200103,1,'B2000BA20010300100','Raker','1','250000','Paket','250000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 08:55:28','B2000BA','43c2d98a42304ce904ce9a338d7d2490'),
	(11,'B','2000','BB',200201,1,'B2000BB20020100100','Pelaksanaan PTS','2','50000','Paket','100000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:00:52','B2000BB','5adf13ca423fd467fd467a338d744195'),
	(12,'B','2000','BB',200202,1,'B2000BB20020200100','Pelaksanaan PAS','1','50000','Paket','50000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 08:55:28','B2000BB','d4026bfa423fd467fd467a338d70e510'),
	(13,'B','2000','BB',200204,1,'B2000BB20020400100','Pelaksanaan PAT','1','50000','Paket','50000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 08:55:28','B2000BB','4b52b4ea423fd467fd467a338d7af032'),
	(16,'B','2000','BC',200303,1,'B2000BC20030300100','Lomba Komisariat/Kabupaten','43','12000','Siswa','516000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:05:16','B2000BC','1ec13d2d2f12741f0435aa338d77658d'),
	(17,'B','2000','BD',200401,1,'B2000BD20040100100','Kegiatan Firstday Activity','43','40000','Siswa','1720000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 08:55:28','B2000BD','2aa19bc4d3fb1bb42c3daa338d79c3ce'),
	(19,'B','2000','BD',200402,1,'B2000BD20040200100','Kegiatan Class Meeting','43','11700','Siswa','503100','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:03:27','B2000BD','7f76bbc4d3fb1bb42c3daa338d7f803d'),
	(20,'B','2000','BD',200403,1,'B2000BD20040300100','Kegiatan STEM-based Learning','43','145000','Siswa','6235000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:04:22','B2000BD','20a1a504d3ffd467d3d98a338d77f514'),
	(21,'B','2000','BD',200404,1,'B2000BD20040400100','Kegiatan Coding Project','0','95000','Siswa','0','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:06:49','B2000BD','c1f77c664bd85dc49b5c4a338d78fc4c'),
	(22,'B','2000','BD',200405,1,'B2000BD20040500100','Kegiatan PHBI (isromiroj, muharom, maulid nabi)','43','31000','Siswa','1333000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:05:00','B2000BD','15b4dfc4d3fdd62bf6766a338d7defd4'),
	(23,'B','2000','BD',200406,1,'B2000BD20040600100','Kegiatan Peringatan Hari Besar Nasional (kemerdekaan, hri guru, kartini, dll) (Event Internasional)','43','44000','Siswa','1892000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:06:24','B2000BD','f4792504d3f61603ad950a338d7c4de9'),
	(24,'B','2000','BD',200407,1,'B2000BD20040700100','Kegiatan Pramuka','43','42000','Siswa','1806000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:07:04','B2000BD','da7d0504d3fe065dcbf86a338d72c621'),
	(25,'B','2000','BD',200408,1,'B2000BD20040800100','Kegiatan Wisuda Tahfizh','43','150000','Siswa','6450000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:08:03','B2000BD','f76a5544d3f55e0392913a338d73994f'),
	(26,'B','2000','BD',200409,1,'B2000BD20040900100','Kegiatan Odyssey Plan ( Pisikolog)','14','280000','Siswa','3920000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:09:34','B2000BD','0b615014d3f61603ad950a338d7cf2e4'),
	(27,'B','2000','BD',200410,1,'B2000BD20041000100','Kegiatan Tasmi Qur&#039;an','0','50000','Siswa','0','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:11:07','B2000BD','d0d84f14d3ffd467d3d98a338d75c7d5'),
	(28,'B','2000','BD',200411,1,'B2000BD20041100100','Market Day','43','10000','Siswa','430000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:15:18','B2000BD','7ea67d14d3ffd467d3d98a338d79f9ce'),
	(30,'B','2000','BD',200413,1,'B2000BD20041300100','Kegiatan Open House (trail class)','43','25000','Siswa','1075000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:10:21','B2000BD','776cf874d3fb1bb42c3daa338d79ac05'),
	(31,'B','2000','BD',200414,1,'B2000BD20041400100','Kegiatan Future Leaders&#039; Camp','43','28000','Siswa','1204000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:15:45','B2000BD','1cd8d9b4d3f61603ad950a338d71732c'),
	(32,'B','2000','BD',200415,1,'B2000BD20041500100','Mini Research Project','1','2000000','satuan','2000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:22:24','B2000BD','6eaf7354d3f85dc4e86f1a338d7e1eee'),
	(33,'B','2000','BD',200416,1,'B2000BD20041600100','Kegiatan Edu Tour','43','450000','Siswa','19350000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:17:17','B2000BD','b9304964d3fa0e8e95cd7a338d77d06a'),
	(34,'B','2000','BD',200417,1,'B2000BD20041700100','Kegiatan Daurah Qur&#039;an','43','12000','Siswa','516000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:18:57','B2000BD','cb04a4b4d3ffd467d3d98a338d726180'),
	(35,'B','2000','BD',200418,1,'B2000BD20041800100','Kegiatan Olympiad Coaching','0','25000','Siswa','0','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:18:27','B2000BD','1d931734d3f53810a0e8ea338d7b6aea'),
	(36,'B','2000','BD',200419,1,'B2000BD20041900100','Kegiatan Filed Trip','43','20000','Siswa','860000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:20:50','B2000BD','522d22b4d3ffd467d3d98a338d7842f3'),
	(38,'B','2000','BD',200421,1,'B2000BD20042100100','Kegiatan Expert Arrival','43','25000','Siswa','1075000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:19:49','B2000BD','15561b54d3f53810a0e8ea338d721add'),
	(39,'B','2000','BD',200422,1,'B2000BD20042200100','Kegiatan Ramadhan dan Itikaf','43','30000','Siswa','1290000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:23:06','B2000BD','872d5bd4d3fb1bb42c3daa338d7a27ef'),
	(40,'B','2000','BD',200423,1,'B2000BD20042300100','Kegiatan Pentas Seni','43','150000','Siswa','6450000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:23:44','B2000BD','84fc71e4d3f55e0392913a338d72ba10'),
	(42,'B','2001','BA',200501,1,'B2001BA20050100100','Promosi Sekolah ( Souvenir + Fee Pendaftaran)','1','3000000','Paket','3000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:25:45','B2001BA','a2be348d208dd62b08495a338d7bff82'),
	(43,'B','2001','BA',200502,1,'B2001BA20050200100','Brosur, Spanduk, Map PPDB','0','5000000','Paket','0','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:27:48','B2001BA','505a247a423adbbdadbbda338d7e46d0'),
	(44,'B','2001','BA',200503,1,'B2001BA20050300100','Digital Marketing &amp; MOU','0','3000000','Paket','0','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:28:06','B2001BA','1a0d2b9a4237cfba7cfbaa338d7bf97f'),
	(45,'B','2001','BA',200504,1,'B2001BA20050400100','Panitia PPDB (wawancara n test PPDB)','14','35000','Paket','490000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:29:49','B2001BA','5d00d674d3f97dcd6f852a338d72c4a8'),
	(46,'B','2001','BA',200505,1,'B2001BA20050500100','Home Visit','43','10000','Paket','430000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:29:00','B2001BA','851c2cc4d3f886c78fd5fa338d76d4a6'),
	(47,'B','2001','BB',200601,1,'B2001BB20060100100','Tinta Printer','8','90000','Pcs','720000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:33:55','B2001BB','b7c66fb0f89d60c556a3ea338d765cfe'),
	(48,'B','2001','BB',200602,1,'B2001BB20060200100','Spidol','18','7000','Pcs','126000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:34:51','B2001BB','00611c2e728d8be841ebca338d7a3458'),
	(49,'B','2001','BB',200603,1,'B2001BB20060300100','Ballpoint','2','30000','Pak','60000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:35:29','B2001BB','f49cd11e728fd4672eabaa338d78c961'),
	(50,'B','2001','BB',200604,1,'B2001BB20060400100','Tinta Spidol','2','97200','Pcs','194400','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:37:19','B2001BB','d3ca030e7282ce41e4444a338d7a71d8'),
	(51,'B','2001','BB',200605,1,'B2001BB20060500100','Stempel','0','75000','Pcs','0','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:31:28','B2001BB','17bbdebe728b1bb4dd62ba338d75759d'),
	(52,'B','2001','BB',200606,1,'B2001BB20060600100','Tinta stempel','2','25000','Pcs','50000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:37:34','B2001BB','5d0389be7282741fcdf31a338d7f75c3'),
	(53,'B','2001','BB',200607,1,'B2001BB20060700100','Penggaris Kayu','3','15000','Pcs','45000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:38:10','B2001BB','57f2853e7282741fcdf31a338d7b7923'),
	(54,'B','2001','BB',200608,1,'B2001BB20060800100','Type x','5','6000','Pcs','30000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:39:28','B2001BB','a76ccafa3b72741ffd467a338d788dda'),
	(55,'B','2001','BB',200609,1,'B2001BB20060900100','Penghapus Papan Tulis','5','10000','Pcs','50000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:40:21','B2001BB','e3b5794bc872741f13150a338d7671f8'),
	(56,'B','2001','BB',200610,1,'B2001BB20061000100','Penggaris segitiga besar','2','20000','Pcs','40000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:42:52','B2001BB','51c7a1ae728131506dd7ea338d7e7db5'),
	(57,'B','2001','BB',200611,1,'B2001BB20061100100','Busur derajat besar','0','50000','Pcs','0','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:33:11','B2001BB','b17f0eca423fd467fd467a338d768267'),
	(58,'B','2001','BB',200612,1,'B2001BB20061200100','Set penggaris','4','10000','Pcs','40000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:44:33','B2001BB','f6d1301a423886c7886c7a338d703b90'),
	(59,'B','2001','BB',200613,1,'B2001BB20061300100','Lem kertas Besar','5','9000','Pcs','45000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:45:02','B2001BB','06519e3e728886c713150a338d7307fd'),
	(60,'B','2001','BB',200614,1,'B2001BB20061400100','Stapler','4','15000','Pcs','60000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:45:38','B2001BB','4ae8747e72853810fd467a338d718230'),
	(61,'B','2001','BB',200615,1,'B2001BB20061500100','Isi stapler','1','15000','Pak','15000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:46:18','B2001BB','5b37fc4a4235381053810a338d7f157b'),
	(62,'B','2001','BB',200616,1,'B2001BB20061600100','Paper clip','5','15000','Pak','75000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:46:58','B2001BB','3650c32a3b753810c2cefa338d7b34f3'),
	(63,'B','2001','BB',200617,1,'B2001BB20061700100','Stop map','3','65000','Pak','195000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 08:55:28','B2001BB','365ef63bc871d0f80ac80a338d7a91f7'),
	(64,'B','2001','BB',200618,1,'B2001BB20061800100','Sneilheckter','0','30000','Pak','0','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:34:11','B2001BB','5dbaa79bc8713150526ada338d77ba15'),
	(65,'B','2001','BB',200619,1,'B2001BB20061900100','Kertas concorde','5','50000','Pak','250000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:48:16','B2001BB','40b643ca3b7048a261603a338d784150'),
	(66,'B','2001','BB',200620,1,'B2001BB20062000100','Lakban bening','3','20000','Pak','60000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:49:49','B2001BB','f4252adbc8713150526ada338d7fb849'),
	(67,'B','2001','BB',200621,1,'B2001BB20062100100','Lakban hitam','3','20000','Pak','60000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:50:26','B2001BB','6374d29bc8713150526ada338d7275a9'),
	(68,'B','2001','BB',200622,1,'B2001BB20062200100','Lakban kertas','9','15000','Pak','135000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:51:28','B2001BB','97bdc45bc8713150526ada338d7a7228'),
	(69,'B','2001','BB',200623,1,'B2001BB20062300100','Doubletip','5','10000','Pak','50000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 08:55:28','B2001BB','9686275a3b72741ffd467a338d7a74b5'),
	(70,'B','2001','BB',200624,1,'B2001BB20062400100','Label stiker','10','5000','Pak','50000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 08:55:28','B2001BB','7f1916a94467f7fefd467a338d7c4258'),
	(71,'B','2001','BB',200625,1,'B2001BB20062500100','Kertas kado','3','15000','Pcs','45000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 08:55:28','B2001BB','4e8a0f2bc87886c722457a338d7871c1'),
	(72,'B','2001','BB',200626,1,'B2001BB20062600100','Totebag','60','4000','Pak','240000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:53:22','B2001BB','5ec69881370cb56f255aea338d731c8f'),
	(73,'B','2001','BB',200627,1,'B2001BB20062700100','Map sleting','0','20000','Pcs','0','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:35:14','B2001BB','082359a9446cdf3161603a338d7207f4'),
	(74,'B','2001','BB',200628,1,'B2001BB20062800100','Map holder','60','30000','Pcs','1800000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:54:11','B2001BB','e8965f09446cdf3161603a338d7ba55f'),
	(75,'B','2001','BB',200629,1,'B2001BB20062900100','Odner file','15','35000','Pcs','525000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:55:26','B2001BB','5349617ce4153810a7754a338d7a8614'),
	(76,'B','2001','BB',200630,1,'B2001BB20063000100','Kertas bufalo','0','15000','Paket','0','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:35:58','B2001BB','d96dd69bc87886c722457a338d7b1e0a'),
	(77,'B','2001','BB',200631,1,'B2001BB20063100100','Kertas HVS A4','3','250000','Dus','750000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:56:32','B2001BB','1d1e58ee72855e03732a2a338d738b18'),
	(78,'B','2001','BB',200632,1,'B2001BB20063200100','Kertas HVS F4','2','250000','Dus','500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:57:32','B2001BB','f955122e72855e03732a2a338d731b7b'),
	(79,'B','2001','BB',200633,1,'B2001BB20063300100','Kertas Rapor F4','6','200000','Rim','1200000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:58:43','B2001BB','9b70216a4236426564265a338d713c02'),
	(80,'B','2001','BB',200634,1,'B2001BB20063400100','Cutter','1','50000','Pak','50000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 09:59:28','B2001BB','c433f73e728f543cb43d7a338d706eb1'),
	(81,'B','2001','BB',200635,1,'B2001BB20063500100','Pembolong Kertas','2','35000','Pcs','70000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:00:20','B2001BB','640a17ee7283d5a595ff1a338d718bbc'),
	(82,'B','2001','BB',200636,1,'B2001BB20063600100','Keyring','1','25000','Pak','25000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 08:55:28','B2001BB','bcb37b9a4235381053810a338d737bc1'),
	(83,'B','2001','BB',200637,1,'B2001BB20063700100','Lanyard guru n Staf','5','10000','Pcs','50000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:01:21','B2001BB','ce839bb9091886c7526ada338d7914b6'),
	(84,'B','2001','BB',200638,1,'B2001BB20063800100','Peper Note Besar','4','5000','Pak','20000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:02:06','B2001BB','84af3c6bc877f7fe886c7a338d7bbf14'),
	(85,'B','2001','BB',200639,1,'B2001BB20063900100','Pulpen Gel','4','25000','Pcs','100000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:04:32','B2001BB','7c9b8cca4236dd7e6dd7ea338d7962e6'),
	(86,'B','2001','BB',200640,1,'B2001BB20064000100','Schedule Board Big','4','15000','Pcs','60000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:05:19','B2001BB','5e6a3c8bc87886c722457a338d7d5f03'),
	(87,'B','2001','BB',200641,1,'B2001BB20064100100','Dudukan Lakban','2','25000','Pcs','50000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 08:55:28','B2001BB','df22698e72853810fd467a338d75072d'),
	(88,'B','2001','BB',200642,1,'B2001BB20064200100','Stabilo Warna','8','4000','Pcs','32000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:06:06','B2001BB','a71133da3b77f7fe53810a338d756d9b'),
	(89,'B','2001','BB',200643,1,'B2001BB20064300100','Box File','12','15000','Pcs','180000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:06:48','B2001BB','ccf5c439091131509cbb9a338d7d2716'),
	(90,'B','2001','BB',200644,1,'B2001BB20064400100','Rak Dokumen','2','100000','Pcs','200000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:07:33','B2001BB','07d6d1ebc872eaba04ce9a338d7e6477'),
	(91,'B','2001','BB',200645,1,'B2001BB20064500100','Isi Cutter','1','30000','Pak','30000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:08:00','B2001BB','972e06fa423fd467fd467a338d7f4368'),
	(92,'B','2001','BC',200701,1,'B2001BC20070100100','Amplop putih besar','2','14000','Pak','28000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:10:19','B2001BC','b5a9de9e728886c713150a338d7ebf11'),
	(93,'B','2001','BC',200702,1,'B2001BC20070200100','Amplop putih sedang','2','12000','Pak','24000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:10:52','B2001BC','f74924de728886c713150a338d7fb9ce'),
	(94,'B','2001','BC',200703,1,'B2001BC20070300100','Amplop Kecil','2','10000','Pak','20000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 08:55:29','B2001BC','ea7471ce7282741fcdf31a338d795b30'),
	(95,'B','2001','BC',200704,1,'B2001BC20070400100','Materai 10.000','20','12000','Pcs','240000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:11:38','B2001BC','b8b8b8573cb2741f04ce9a338d764b2c'),
	(96,'B','2001','BD',200801,1,'B2001BD20080100100','Sabun Cuci Tangan','0','15000','Botol','0','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:38:25','B2001BD','75218344e45886c7713caa338d792daa'),
	(97,'B','2001','BD',200802,1,'B2001BD20080200100','Masker','2','35000','Pak','70000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:12:30','B2001BD','71ebbc4e728131506dd7ea338d786380'),
	(98,'B','2001','BD',200803,1,'B2001BD20080300100','Obat - obatan UKS','2','500000','Paket','1000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 08:55:29','B2001BD','8676b7ae728732a2c545fa338d7db2f4'),
	(99,'B','2001','BD',200804,1,'B2001BD20080400100','Perlengkapan UKS','1','500000','Paket','500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:13:02','B2001BD','f842d94a423c545fc545fa338d7814f0'),
	(100,'B','2001','BE',200901,1,'B2001BE20090100100','Pengadaan alat olahraga','1','800000','Paket','800000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:13:48','B2001BE','3f15cafa423f0216f0216a338d7d81b9'),
	(101,'B','2001','BE',200902,1,'B2001BE20090200100','Perlengkapan praktik seni rupa','1','500000','Paket','500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:16:16','B2001BE','84033fda423c545fc545fa338d7b0f07'),
	(102,'B','2001','BE',200903,1,'B2001BE20090300100','Pengadaan bahan praktik IPA','1','1200000','Paket','1200000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:17:50','B2001BE','15e8fafa423f0216f0216a338d7be6c5'),
	(103,'B','2001','BE',200904,1,'B2001BE20090400100','Pengadaan bahan praktik IPS','1','600000','Paket','600000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:18:36','B2001BE','c9f94dda423732a2732a2a338d728b0e'),
	(104,'B','2001','BE',200905,1,'B2001BE20090500100','Pengadaan bahan praktik Matematika','1','500000','Paket','500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:19:25','B2001BE','ed994dda423732a2732a2a338d784f7b'),
	(105,'B','2002','BA',201001,1,'B2002BA20100100100','Kegiatan KKKS','0','100000','Bulan','0','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:40:46','B2002BA','7da98ecad4d2eaba86626a338d713448'),
	(106,'B','2002','BA',201002,1,'B2002BA20100200100','Kegiatan KKG Guru','0','40000','Bulan','0','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:41:16','B2002BA','a0371f6ad4d048a28fd5fa338d7e3ce1'),
	(107,'B','2002','BA',201003,1,'B2002BA20100300100','Kegiatan KKG PAI','0','10000','Bulan','0','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:42:19','B2002BA','a41865cad4d2741f37ad0a338d7bbe90'),
	(108,'B','2002','BA',201004,1,'B2002BA20100400100','Kegiatan KKG PJOK','0','10000','Bulan','0','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:43:17','B2002BA','f43251ead4d2741f37ad0a338d72a66a'),
	(110,'B','2002','BA',201006,1,'B2002BA20100600100','Kegiatan Kedinasan','1','500000','Tahun','500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:20:15','B2002BA','88cc249ad4d616032c3daa338d707aeb'),
	(112,'B','2002','BB',201102,1,'B2002BB20110200100','Perjalanan Dinas dan Humas','1','500000','Bulan','500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:52:54','B2002BB','c0190889446dd62bf0216a338d78c578'),
	(116,'B','2002','BC',201201,1,'B2002BC20120100100','Seragam Guru dan Karyawan','8','300000','Orang','2400000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 08:55:29','B2002BC','059b9c00f8904ce92c3daa338d7a8d48'),
	(118,'B','2003','BA',201301,1,'B2003BA20130100100','Rapat wali murid awal tahun','43','15000','Siswa','645000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:22:00','B2003BA','5b5bf294d3fcdf310435aa338d7408b7'),
	(121,'B','2003','BA',201304,1,'B2003BA20130400100','Rapat wali murid akhir tahun','43','15000','Siswa','645000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:23:15','B2003BA','e66c2c84d3f886c78fd5fa338d7eb62f'),
	(122,'B','2003','BB',201401,1,'B2003BB20140100100','Maintenance AC','6','150000','Bulan','900000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:23:50','B2003BB','9799c4c909104ce9c2fe4a338d7a4bab'),
	(123,'B','2003','BB',201402,1,'B2003BB20140200100','Pulsa Operator SMP','10','100000','Bulan','1000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:24:31','B2003BB','5ecf6239446713cabb2c3a338d7e36e7'),
	(125,'B','2003','BB',201404,1,'B2003BB20140400100','Maintenance Printer','4','100000','Bulan','400000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:25:08','B2003BB','eb5137aff673d3888c964a338d74721d'),
	(128,'B','2003','BB',201407,1,'B2003BB20140700100','Maintenance Komputer/Laptop','2','250000','Paket','500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 08:55:29','B2003BB','4e9996fe72855e03732a2a338d72f863'),
	(133,'B','2004','BA',201602,1,'B2004BA20160200100','Dekorasi Kelas','3','100000','Paket','300000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:27:14','B2004BA','17be819e728732a2c545fa338d7a2a68'),
	(150,'B','2005','BB',202002,1,'B2005BB20200200100','Pajak Bangunan','1','300000','Paket','300000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 10:37:32','B2005BB','ae07d95ad4da82eae353ca338d7f80f7'),
	(164,'A','1004','AA',100401,1,'A1004AA10040100100','Sumbangan Wakaf Infaq dan Sodaqoh','1','0','Tahun','0','','','','','','','','','','','','','0','2025-06-13 08:55:29','A1004AA','8a56005a4230849508495cd98f07f565'),
	(165,'B','2006','BA',202102,1,'B2006BA20210200100','Buku Pelajaran Siswa Kelas 8','18','2210000','Siswa','39780000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 14:27:24','B2006BA','6d6144b922f11a3384487f960a338d71'),
	(167,'B','2006','BA',202103,1,'B2006BA20210300100','Buku Saku Siswa kelas 8','18','30000','pcs','540000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 14:31:28','B2006BA','0ab17dd922f13150deb81a15aa338d71'),
	(168,'B','2006','BB',202102,1,'B2006BB20210200100','Buku Pelajaran Siswa Kelas 9','11','2210000','Siswa','24310000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 14:40:52','B2006BB','6d6c0ea922f11a3384487f960a338d71'),
	(169,'B','2006','BB',202103,1,'B2006BB20210300100','Buku Saku Siswa kelas 9','11','30000','pcs','330000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 14:35:34','B2006BB','0abe47d2bd413150de39f226fa338d71'),
	(170,'B','2006','BB',202106,1,'B2006BB20210600100','Assesment English (Cambriadge)','11','1000000','Siswa','11000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 14:39:24','B2006BB','2d87a7a2bd4c545f84425b401a338d71'),
	(171,'B','2006','BC',202102,1,'B2006BC20210200100','Buku Pelajaran Siswa Kelas 7','14','2210000','Siswa','30940000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 14:42:38','B2006BC','6d641a2323811a3384f1c2e71a338d71'),
	(172,'B','2006','BC',202103,1,'B2006BC20210300100','Buku Saku Siswa kelas 7','14','15000','Siswa','210000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 14:45:50','B2006BC','0ab95463238886c7f84fe9e20a338d71'),
	(173,'B','2006','BC',202201,1,'B2006BC20220100100','Chromebook','15','4500000','Pcs','67500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 14:48:30','B2006BC','598c58b31c7fd148ded2b9bdfa338d71'),
	(174,'B','2006','BC',202202,1,'B2006BC20220200100','Seragam 6 Stel','14','2055000','Siswa','28770000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 14:50:56','B2006BC','88955f33238290a4d23e466b8a338d71'),
	(175,'B','2006','BC',202203,1,'B2006BC20220300100','Cover Rapot','14','55000','Siswa','770000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 14:52:06','B2006BC','840f2de3238e065d56cc8c76ba338d71'),
	(176,'B','2006','BC',202204,1,'B2006BC20220400100','Pin Sekolah','14','21000','Siswa','294000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 14:52:45','B2006BC','7485810323821bf2c624deadea338d71'),
	(177,'B','2006','BC',202205,1,'B2006BC20220500100','Aplikasi BSI','14','50000','Siswa','700000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 14:53:26','B2006BC','3bc75e23238fd46739a82eacaa338d71'),
	(178,'B','2006','BC',202207,1,'B2006BC20220700100','Sovenir','14','130000','Siswa','1820000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 14:55:05','B2006BC','5b2464b3238b405260c4d5417a338d71'),
	(179,'B','2000','BA',200104,1,'B2000BA20010400100','ANBK','18','23000','Paket','414000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 14:58:44','B2000BA','fdba741922f31d2f60aaa621fa338d71'),
	(180,'B','2000','BC',200304,1,'B2000BC20030400100','Lomba kedinasan','1','150000','Siswa','150000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:03:29','B2000BC','13466e4a423dd62b6fdd62b6fa338d71'),
	(181,'B','2000','BC',200305,1,'B2000BC20030500100','Lomba Non Kedinasan','43','10000','Siswa','430000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:04:21','B2000BC','849abda62162741f66e2f28b4a338d71'),
	(182,'B','2000','BD',200428,1,'B2000BD20042800100','Project P5','43','20000','Siswa','860000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-13 15:24:20','B2000BD','444a0416216cdf31c0698fd9ea338d71'),
	(183,'B','2003','BC',201501,1,'B2003BC20150100100','TP Link','1','700000','pcs','700000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-14 09:56:08','B2003BC','72f63d8a423a82eacaa82eacaa338d71'),
	(184,'B','2005','BA',201104,1,'B2005BA20110400100','Honor Guru','13','19000000','Bulan','247000000','','','','','','','','','A1001AA10010100100','1001','AA','100101','0','2025-06-14 10:16:18','B2005BA','03a7dc8ce417d972925065ff276ec85f'),
	(185,'B','2005','BA',201405,1,'B2005BA20140500100','Listrik','12','3000000','Bulan','36000000','','','','','','','','','A1001AA10010100100','1001','AA','100101','0','2025-06-14 10:17:11','B2005BA','14949e0ad4d7cfba9a6c7eeaf76ec85f'),
	(186,'B','2005','BA',201406,1,'B2005BA20140600100','Wifi','13','580000','Bulan','7540000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-14 10:18:17','B2005BA','91fdbbdce41e898129dfcd698a338d71'),
	(187,'B','2005','BA',201409,1,'B2005BA20140900100','BPJS','13','3150213','Bulan','40952769','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-14 10:19:21','B2005BA','dbcc697ce41c8eec2904bec2aa338d71'),
	(188,'B','2005','BA',201410,1,'B2005BA20141000100','Makan Guru','12','1540000','Bulan','18480000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-14 10:20:38','B2005BA','f8ba2a8ad4d4c20e0087284ffa338d71'),
	(189,'B','2005','BA',201412,1,'B2005BA20141200100','Air Minum','12','450000','Bulan','5400000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-14 10:22:14','B2005BA','4afb5baad4d1c580ae47956baa338d71'),
	(190,'B','2005','BA',201411,1,'B2005BA20141100100','Overhead','1','10000000','Tahun','10000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-14 10:23:47','B2005BA','8a6d48da423aaf52b4aaf52b4a338d71');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_jurnal2526`;

CREATE TABLE IF NOT EXISTS `simakom_jurnal2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  `id` varchar(40) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_revisi2526`;

CREATE TABLE IF NOT EXISTS `simakom_revisi2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `revisi` float NOT NULL,
  `tanggal` date NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `simakom_revisi2526` (`no`, `revisi`, `tanggal`, `time`, `id`) VALUES
	(1,'0','2025-06-13','2025-06-13 08:55:26','ba9ccb1c3183efdc16108117079f29809a0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_transaksi2526`;

CREATE TABLE IF NOT EXISTS `simakom_transaksi2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `bukti` float NOT NULL,
  `bukti_sistem` float NOT NULL,
  `jenis` float NOT NULL,
  `kategori` varchar(3) NOT NULL,
  `rkas_kategori` varchar(1) NOT NULL,
  `rkas_kegiatan` varchar(5) NOT NULL,
  `rkas_komponen` varchar(5) NOT NULL,
  `rkas_akun` float NOT NULL,
  `rkas_detail_id` varchar(25) NOT NULL,
  `uraian` text NOT NULL,
  `debet` varchar(15) NOT NULL,
  `kredit` varchar(15) NOT NULL,
  `penerima` varchar(100) DEFAULT NULL,
  `penerima_jabatan` varchar(100) DEFAULT NULL,
  `pembiayaan_id` varchar(50) NOT NULL,
  `pembiayaan_kegiatan` varchar(4) NOT NULL,
  `pembiayaan_komponen` varchar(5) NOT NULL,
  `pembiayaan_akun` varchar(6) NOT NULL,
  `pajak` tinyint(1) NOT NULL,
  `pajak_akun` varchar(10) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  `id_setor` varchar(25) NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_lpj2526`;

CREATE TABLE IF NOT EXISTS `simakom_lpj2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `periode` varchar(2) NOT NULL,
  `tahun` varchar(9) NOT NULL,
  `bku_awal` varchar(15) NOT NULL,
  `bku_debet` varchar(15) NOT NULL,
  `bku_kredit` varchar(15) NOT NULL,
  `bku_akhir` varchar(15) NOT NULL,
  `bank_awal` varchar(15) NOT NULL,
  `bank_debet` varchar(15) NOT NULL,
  `bank_kredit` varchar(15) NOT NULL,
  `bank_akhir` varchar(15) NOT NULL,
  `tunai_awal` varchar(15) NOT NULL,
  `tunai_debet` varchar(15) NOT NULL,
  `tunai_kredit` varchar(15) NOT NULL,
  `tunai_akhir` varchar(15) NOT NULL,
  `bank_riil` varchar(15) NOT NULL,
  `tunai_riil` varchar(15) NOT NULL,
  `bank_selisih` varchar(15) NOT NULL,
  `tunai_selisih` varchar(15) NOT NULL,
  `selisihtunai_keterangan1` text NOT NULL,
  `selisihtunai_keterangan2` text NOT NULL,
  `selisihbank_keterangan1` text NOT NULL,
  `selisihbank_keterangan2` text NOT NULL,
  `rekening_nama1` text NOT NULL,
  `rekening_jumlah1` varchar(15) NOT NULL,
  `rekening_nama2` text NOT NULL,
  `rekening_jumlah2` varchar(15) NOT NULL,
  `rekening_nama3` text NOT NULL,
  `rekening_jumlah3` varchar(15) NOT NULL,
  `catatan` text NOT NULL,
  `pecahan_100` varchar(10) NOT NULL,
  `pecahan_75` varchar(10) NOT NULL,
  `pecahan_50` varchar(10) NOT NULL,
  `pecahan_20` varchar(10) NOT NULL,
  `pecahan_10` varchar(10) NOT NULL,
  `pecahan_5` varchar(10) NOT NULL,
  `pecahan_2` varchar(10) NOT NULL,
  `pecahan_1` varchar(10) NOT NULL,
  `pecahan_05` varchar(10) NOT NULL,
  `pecahan_02` varchar(10) NOT NULL,
  `pecahan_01` varchar(10) NOT NULL,
  `pecahan_005` varchar(10) NOT NULL,
  `id` varchar(30) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `db_setor2526`;

CREATE TABLE IF NOT EXISTS `db_setor2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal_draf` datetime NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  `setor_status` varchar(10) NOT NULL,
  `setor_tanggal` datetime NOT NULL,
  `terima_status` varchar(10) NOT NULL,
  `terima_tanggal` datetime NOT NULL,
  `penyetor` varchar(50) NOT NULL,
  `penerima` varchar(50) NOT NULL,
  `metode` varchar(2) NOT NULL,
  `id_rkas` varchar(50) NOT NULL,
  `tahun` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `created_by` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa_min2526`;

CREATE TABLE IF NOT EXISTS `tb_siswa_min2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=220 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_siswa_min2526` (`no`, `nama`, `nis`, `jenjang`, `paralel`, `id`) VALUES
	(176,'AHMAD HAIKAL JIRZIS','2324010002','9','A','a0534d8d02aaeae3cee0'),
	(177,'ALIKHA NAYLA PUTRI ANDRYAN','2324010007','9','A','104a14eba4706c9d764c'),
	(178,'ALVITO ABINAYAJATI','2324010008','9','A','9e564f888b985566519c'),
	(179,'ANNISA NANDIRA PUTRI','2324010004','9','A','a4a7d0606e623852b6bd'),
	(180,'GADIZA RAYNA SYAHIRA','2324010003','9','A','23f4701ce1bb783aaa57'),
	(181,'NADIRA NATASA','2324010005','9','A','0d6a4c388fa9c8110006'),
	(182,'RAZAN AZKIA LESMANA','2324010009','9','A','5d1dc8f1792ef2825230'),
	(183,'VIYONA PUTRI RAKHMAN','2324010001','9','A','51a260c4460d12866d18'),
	(184,'IHSAN KURNIAWAN','2324010010','9','A','c73a9bf65a3dead22581'),
	(185,'AIRIN AZZAHRA','2425020001','8','A','d504653d336fea9e6f41'),
	(186,'AL FIRYAALI ATHALIA HUSNA','2425020002','8','A','5935efa7f4ff365a6691'),
	(187,'ARJUNA PUTRA WIBAWA','2425020003','8','A','74075d2832b160b67a91'),
	(188,'FIRJANI ALMA AFRINA','2425020004','8','A','28f8044bb50a31656f72'),
	(189,'GHAZI AZKA JUNIOR','2425020005','8','A','5ee3304f873a7810126c'),
	(190,'HUGA AKBAR RIANTO','2425020006','8','A','ffa4cf9b5db2c98d1fcf'),
	(191,'KHAYLA ALMIRA MARISSA','2425020007','8','A','554aacdd6ca5918cc8e2'),
	(192,'KAYLA MEOQUANEE INDRAWAN','2425020008','8','A','056a5784ebefac8c6cad'),
	(193,'MARYAM NAURA IZZATUNNISA','2425020009','8','A','4cf1f694731e888c73bc'),
	(194,'MUHAMMAD A&amp;#039;LA DANADYAKSA','2425020010','8','A','83240357fac0cddf9236'),
	(195,'MUHAMMAD AZKA GHOSSANNY','2425020011','8','A','77d65134092a2c48c2b3'),
	(196,'MUHAMMAD TRISTAN ALVITO','2425020012','8','A','567251747a0fe0006904'),
	(197,'RAFFA KHAIRUN FAHMI','2425020013','8','A','ef0fb2439b91e91a915f'),
	(198,'RAFIF AL FADZIMA IRAWAN','2425020014','8','A','ed8fb33c0597e678f4db'),
	(199,'RIZKINA NUR AULIA AZZAHRO','2425020015','8','A','c0bc3eb7c17b171d9cd0'),
	(200,'DYLAN ZACKY','2425020016','8','A','4fdf1ddcb5471c500064'),
	(201,'NAJMA CETTA DESANDRA','2425020017','8','A','91075c122f103114328d'),
	(202,'HAURA ZIYADATUZZAHRA','2425020018','8','A','a7fa21817b58992dcbfb'),
	(203,'NAJLA ZAHIA MEHRIN','2425020019','9','A','4999c56fa825b776c5d4'),
	(204,'ALVINO MUHAMMAD RASYHA NOORIS','2425020020','9','A','dacf3d336cea8f90c3f2'),
	(205,'MUHAMMAD DANIEL AKRAM','2526030009','7','A','62db1d2bc6c20f00ff41'),
	(206,'FAATIH ZIBRAN AL AYUUBY','2526030005','7','A','1c75bccafa99ffb70a27'),
	(207,'NAZWA MAUDI AULIA','2526030011','7','A','55ea71c2c1810b1fcc1e'),
	(208,'KIASATINA AMILIA GUNAWAN','2526030008','7','A','895e742ee238552f6874'),
	(209,'MUHAMMAD KINZA MIFZAL','2526030010','7','A','d59440ae1bdc8bd6ef42'),
	(210,'CHANTIQA DESVYRA','2526030004','7','A','92cfa022247701aac412'),
	(211,'PAKSI HEKSA UTAMA','2526030012','7','A','9f813ece9814033652f7'),
	(212,'ALDYANSYAH DARAJAT','2526030002','7','A','df8d64ecb7a33c94fbe5'),
	(213,'QALESYA QAIREEN ROYCE','2526030013','7','A','53eb6993baa0cc8ec09d'),
	(214,'MEYZHILA AURORA NOVIANDRE','2526030007','7','A','e0459fe08613f40ad209'),
	(215,'REYZO AKENO AL-FARISI','2526030014','7','A','1d2199acc171654bf7c7'),
	(216,'ANAYA MIKHAYLA SEPUTRI','2526030003','7','A','6bd753e4d11239c3c9af'),
	(217,'ADZANIA LETISHA PUTRI','2526030001','7','A','8eb03c4b380e60bcd946'),
	(218,'KEANU RAJA INDRAWAN','2526030006','7','A','c31967445e31c707f993'),
	(219,'JAFAR SIDIK','2526030015','7','A','285b05b1d8afc4ddf88a');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa2526`;

CREATE TABLE IF NOT EXISTS `tb_siswa2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `kelamin` varchar(20) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `ortu` varchar(75) DEFAULT NULL,
  `alamat` text DEFAULT NULL,
  `tang_A` varchar(10) NOT NULL,
  `tang_B` varchar(10) NOT NULL,
  `tang_C` varchar(10) NOT NULL,
  `tang_D` varchar(10) NOT NULL,
  `tang_E` varchar(10) NOT NULL,
  `tang_F` varchar(10) NOT NULL,
  `tang_G` varchar(10) NOT NULL,
  `tang_H` varchar(10) NOT NULL,
  `tang_I` varchar(10) NOT NULL,
  `tang_J` varchar(10) NOT NULL,
  `tang_K` varchar(10) NOT NULL,
  `tang_L` varchar(10) NOT NULL,
  `tang_M` varchar(10) NOT NULL,
  `tang_N` varchar(10) NOT NULL,
  `tang_O` varchar(10) NOT NULL,
  `tang_P` varchar(10) NOT NULL,
  `tang_Q` varchar(10) NOT NULL,
  `tang_R` varchar(10) NOT NULL,
  `tang_S` varchar(10) NOT NULL,
  `tang_T` varchar(10) NOT NULL,
  `tang_U` varchar(10) NOT NULL,
  `tang_V` varchar(10) NOT NULL,
  `tang_W` varchar(10) NOT NULL,
  `tang_X` varchar(10) NOT NULL,
  `tang_Y` varchar(10) NOT NULL,
  `tang_Z` varchar(10) NOT NULL,
  `status` varchar(15) NOT NULL,
  `email` varchar(75) NOT NULL,
  `hp` varchar(15) NOT NULL,
  `kategori` varchar(200) NOT NULL,
  `startAt` varchar(2) NOT NULL,
  `catatan` text DEFAULT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=220 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_siswa2526` (`no`, `nama`, `nis`, `kelamin`, `jenjang`, `paralel`, `ortu`, `alamat`, `tang_A`, `tang_B`, `tang_C`, `tang_D`, `tang_E`, `tang_F`, `tang_G`, `tang_H`, `tang_I`, `tang_J`, `tang_K`, `tang_L`, `tang_M`, `tang_N`, `tang_O`, `tang_P`, `tang_Q`, `tang_R`, `tang_S`, `tang_T`, `tang_U`, `tang_V`, `tang_W`, `tang_X`, `tang_Y`, `tang_Z`, `status`, `email`, `hp`, `kategori`, `startAt`, `catatan`, `id`) VALUES
	(176,'AHMAD HAIKAL JIRZIS','2324010002','L','9','A','Andhi Kusnanto - Fitriyani','Grand Subang residence Blok D2 No #2 Belendung Cibogo-Subang','0','6138000','7250000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','a0534d8d02aaeae3cee0'),
	(177,'ALIKHA NAYLA PUTRI ANDRYAN','2324010007','P','9','A','Anggi Andrian Priatna - Leni Anggraeni','Jl. Apel 6 Blok II No.09 RT 79/22 Perumnas-Subang','0','6138000','7250000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','104a14eba4706c9d764c'),
	(178,'ALVITO ABINAYAJATI','2324010008','L','9','A','Wahyu Waluyojati,S.Sos - Dini Amalia','Bumi Abdi Praja RT 59/16 Sukamelang-Subang','0','6600000','7250000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','9e564f888b985566519c'),
	(179,'ANNISA NANDIRA PUTRI','2324010004','P','9','A','Asep Nandang - Ira amelia','Jl. R.A kartini Pesona Permata Hijau Blok B 85 RT 60/21 Pasirkareumbi-Subang','0','6600000','7250000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','a4a7d0606e623852b6bd'),
	(180,'GADIZA RAYNA SYAHIRA','2324010003','P','9','A','Juli Satia - Diani Ratnasari','Perumnas Jl. Sawo I No.76 RT.22/80 Karanganyar-Subang','0','6600000','7250000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','23f4701ce1bb783aaa57'),
	(181,'NADIRA NATASA','2324010005','P','9','A','Deden Suhandi - Dian Novianti','Cipaku RT 07/02 Cibogo-Subang','0','6600000','7250000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','0d6a4c388fa9c8110006'),
	(182,'RAZAN AZKIA LESMANA','2324010009','L','9','A','Eka Lesmana, S.Kep - Mila Nurmalia, S.AN','Blok Bumi Sari rt 042/005 Dngdeur-Subang','0','6600000','7250000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','5d1dc8f1792ef2825230'),
	(183,'VIYONA PUTRI RAKHMAN','2324010001','P','9','A','Yoppi Ismana Rakhman - Tina Inayati','Puri Subang Asri Jl. Wortel No.06 RT 64/17 Sukamelang-Subang','0','3300000','3625000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','51a260c4460d12866d18'),
	(184,'IHSAN KURNIAWAN','2324010010','L','9','A','Fajar Kurniawan - Dewi Maylasari','PT. Pertamina EP Regional 2 Zona 7 Subang Field Jl raya Pagaden-Pamanukan, Kp.Sukagalih Desa Sukamulya RT.30 RW.08 Kec. Pagaden Kab. Subang-412521','0','6600000','7250000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','c73a9bf65a3dead22581'),
	(185,'AIRIN AZZAHRA','2425020001','P','8','A','Agung Budhi Santosa - Popy Rosefianti','JL. Otista GG.Merak No.04 RT 005/002 kelurahan Soklat Kecamatan Subang','0','7254000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','d504653d336fea9e6f41'),
	(186,'AL FIRYAALI ATHALIA HUSNA','2425020002','P','8','A','Yudi Hendarsah, S.An - Yani Yuliani','GG. H. Sulaeman o.19 Blok sukamanah RT 048/013 Kelurahan Karanganyar Kecamatan Subang','0','7800000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','5935efa7f4ff365a6691'),
	(187,'ARJUNA PUTRA WIBAWA','2425020003','L','8','A','Savitra Wibawa, S.Si - Dianita Artsiyanti Triyani','Komp Cipaganti Rahayu Regency Blok F No 27A RT 006/011 Kelurahan Mekarjaya Kecamatan Rancasari Kota Bandung','0','7800000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','74075d2832b160b67a91'),
	(188,'FIRJANI ALMA AFRINA','2425020004','P','8','A','Saeful Ramadhan - Aliyah','Blok Bongas Kidul RT 002/005 Kelurahan Sumberjaya Kecamat Sumberjaya Kabupaten Majalengka','0','7800000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','28f8044bb50a31656f72'),
	(189,'GHAZI AZKA JUNIOR','2425020005','L','8','A','Epi slamet, SS - Lina Ambarsari','Puri permai Blok C2 No.30 RT 009/005 Kecamatan Tigaraksa Kabupaten/Kota Tangerang-Banten','0','7254000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','5ee3304f873a7810126c'),
	(190,'HUGA AKBAR RIANTO','2425020006','L','8','A','HERU RIYANTO - ATIN KURNIA','KP. KALIANGSANA RT 06/01, KALIJATI, SUBANG','0','7800000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','ffa4cf9b5db2c98d1fcf'),
	(191,'KHAYLA ALMIRA MARISSA','2425020007','P','8','A','Abdul Kholiq, SPD - Rita Kurniasari Rusyati, S.KP','Komp Pesona Bali Blok C3 No 8 RT 010/008 Kelurahan Bojongsoang, Kecamatan Bojongsoang Kabupaten Bandung ','0','7800000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','554aacdd6ca5918cc8e2'),
	(192,'KAYLA MEOQUANEE INDRAWAN','2425020008','P','8','A','RUDY INDRAWAN - RISSA ISMAWATI','BUANA GRAHA KECANA NO. A15 FT 09/30','0','7800000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','056a5784ebefac8c6cad'),
	(193,'MARYAM NAURA IZZATUNNISA','2425020009','P','8','A','Bambang Irawan - Selvy Sylvania Devianty','Jl. M.Dedeng S No.64 RT 020/007 Kelurahan Pasirkareumbi Kecamatan Subang','0','7800000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','4cf1f694731e888c73bc'),
	(194,'MUHAMMAD A&amp;#039;LA DANADYAKSA','2425020010','L','8','A','Fuzi Fauzi Subangkit - Say Dwi Ardini','Dsn Krajan Utara RT 008/002 Desa Sindangsari Kecamatan Cikaum Kabupaten Subang','0','7800000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','83240357fac0cddf9236'),
	(195,'MUHAMMAD AZKA GHOSSANNY','2425020011','L','8','A','Asep Hidayat, S.Pd - Susani Siti Nurul Fitria','Jl. Pasir Harja RT 016/010 Desa Sukamelang Kecamatan Subang','0','7800000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','77d65134092a2c48c2b3'),
	(196,'MUHAMMAD TRISTAN ALVITO','2425020012','L','8','A','Aryo Wibisono - Puji Nurati','Perumahan Kelapa Residence Blok A 20 RT 058/005 Kelurahan Dangdeur Kecamatan Subang','0','7800000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','567251747a0fe0006904'),
	(197,'RAFFA KHAIRUN FAHMI','2425020013','L','8','A','Edi Yusuf - Mira Sofari','Harva Residence Blok Harmonia No 05 RT 070/019 Kelurahan Cigadung Kecamatan Subang','0','7800000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','ef0fb2439b91e91a915f'),
	(198,'RAFIF AL FADZIMA IRAWAN','2425020014','L','8','A','Lee kin weng - Euis Gracea Winatiar','Jl. Lingkar Sukasari Kp.Sukasari RT 007/004 Kelurahan Harapan Mulia Kecamatan Kemayoran Jakarta Pusat','0','7800000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','ed8fb33c0597e678f4db'),
	(199,'RIZKINA NUR AULIA AZZAHRO','2425020015','P','8','A','Paidi - Siti Maemunah','Gg. Pisang No.28 RT.059/016 Kelurahan KaranganyarnKecamatan Subang','0','7800000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','c0bc3eb7c17b171d9cd0'),
	(200,'DYLAN ZACKY','2425020016','L','8','A','Jackie F - Emillia','Sukamelang RT.064/017 kelurahan Sukamelang, Kecamatan Subang Kabupaten subang-Jawabarat','0','7800000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','4fdf1ddcb5471c500064'),
	(201,'NAJMA CETTA DESANDRA','2425020017','P','8','A','Andre Yulianto - Wita Koswitaningrum','Jl. Gelatik Raya No.37 RT.002 RW 012, kelurahan Depok Jaya Kecamatan Pancoran Mas Kota Depok','0','7800000','6500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','91075c122f103114328d'),
	(202,'HAURA ZIYADATUZZAHRA','2425020018','P','8','A','Ahmad Nuryanto - Siti Rohayah','Blok B RT.01/02 Kelurahan Belawa Kecamatan Lemahabang Kabupaten/Kota Cirebon','0','3900000','3250000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','a7fa21817b58992dcbfb'),
	(203,'NAJLA ZAHIA MEHRIN','2425020019','P','9','A','lukman Fariz - Susita Dewi Agustin','Kp. Lengkong RT.006/002 Kel. Pagaden, Kec. Pagaden Kabupaten Subang-Jawabarat','0','7800000','7250000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','4999c56fa825b776c5d4'),
	(204,'ALVINO MUHAMMAD RASYHA NOORIS','2425020020','L','9','A','Vicky Zulfikar Nooris - Inna Tri Maryana','Jl.P. Karimun Jawa 3 NO 257 RT 004/013 Kel. Aren Jaya, Kec. Bekasi Timur Kota Bekasi-Jawabarat','0','7800000','7250000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','dacf3d336cea8f90c3f2'),
	(205,'MUHAMMAD DANIEL AKRAM','2526030009','L','7','A','','','0','8400000','17000000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','62db1d2bc6c20f00ff41'),
	(206,'FAATIH ZIBRAN AL AYUUBY','2526030005','L','7','A','','','0','8400000','17000000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','1c75bccafa99ffb70a27'),
	(207,'NAZWA MAUDI AULIA','2526030011','P','7','A','','','0','8400000','17000000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','55ea71c2c1810b1fcc1e'),
	(208,'KIASATINA AMILIA GUNAWAN','2526030008','P','7','A','DENY SUTEJA GINANJAR/ANITA NUR AMILIA','JL. DUKUH 2 NO. 117 PERUMNAS RT/RW 043/008 SUKAMELANG SUBANG','0','8400000','15750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','895e742ee238552f6874'),
	(209,'MUHAMMAD KINZA MIFZAL','2526030010','L','7','A','','','0','8400000','16500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','d59440ae1bdc8bd6ef42'),
	(210,'CHANTIQA DESVYRA','2526030004','P','7','A','','','0','8400000','16500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','92cfa022247701aac412'),
	(211,'PAKSI HEKSA UTAMA','2526030012','L','7','A','SUKADI/EUIS CARKESIH','PENDEUY','0','8400000','15750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','9f813ece9814033652f7'),
	(212,'ALDYANSYAH DARAJAT','2526030002','L','7','A','DARAJAR/NANI SURYANI','GRAHA SUBANG KENCANA 2','0','8400000','15750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','df8d64ecb7a33c94fbe5'),
	(213,'QALESYA QAIREEN ROYCE','2526030013','P','7','A','SENDY ROYCE RIZAL/NURLATIFAH','JL. KAPTEN HANAFI PERUM GSK 2 RT/RW 046/15','0','8400000','15750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','53eb6993baa0cc8ec09d'),
	(214,'MEYZHILA AURORA NOVIANDRE','2526030007','P','7','A','DONAL NOVIANDRE/ELVIRA ROSSA','JL. GANG TENGAH NO. 8','0','8400000','15750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','e0459fe08613f40ad209'),
	(215,'REYZO AKENO AL-FARISI','2526030014','L','7','A','FARISI/RANI ISYANA ROMULA REKKERS','BUANA SUBANG KECANA','0','8400000','15750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','1d2199acc171654bf7c7'),
	(216,'ANAYA MIKHAYLA SEPUTRI','2526030003','P','7','A','ASEP SOLEH/RENA SUSANTI','KANKIR RT 72/19 SUKARAHAYU KARANGANYAR SUBANG','0','8400000','15750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','6bd753e4d11239c3c9af'),
	(217,'ADZANIA LETISHA PUTRI','2526030001','P','7','A','ASEP NANDANG/IRA AMELIA','JL. S. PARMAN NO. 9 RT 27/07 KELURAHAN SOKLAT SUBANG','0','8400000','15750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','8eb03c4b380e60bcd946'),
	(218,'KEANU RAJA INDRAWAN','2526030006','L','7','A','RUDY INDRAWAN/RISSA ISMAWATI','BUANA GRAHA KECANA NO. A15 FT 09/30','0','8400000','15250000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','81385888137','Umum','1','','c31967445e31c707f993'),
	(219,'JAFAR SIDIK','2526030015','L','7','A','','','0','4200000','9750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Umum','1','','285b05b1d8afc4ddf88a');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_list2526`;

CREATE TABLE IF NOT EXISTS `payment_list2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(120) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `hp` varchar(18) NOT NULL,
  `email` varchar(100) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `status` varchar(15) NOT NULL,
  `keterangan` text DEFAULT NULL,
  `payment_id` varchar(50) NOT NULL,
  `tahun` varchar(9) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_list_detail2526`;

CREATE TABLE IF NOT EXISTS `payment_list_detail2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` datetime NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `jenjang` varchar(5) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `kategori` varchar(30) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `tahap` float NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `random` varchar(20) NOT NULL,
  `penerima` varchar(100) NOT NULL,
  `setor` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `metode` varchar(20) NOT NULL,
  `catatan` text DEFAULT NULL,
  `time` datetime NOT NULL,
  `ip` varchar(30) NOT NULL,
  `browser` text DEFAULT NULL,
  `id_tr` varchar(50) NOT NULL,
  `payment_id` varchar(50) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_set`;

CREATE TABLE IF NOT EXISTS `payment_set` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `aktif` varchar(1) DEFAULT NULL,
  `sistem` varchar(2) NOT NULL,
  `api` text DEFAULT NULL,
  `callback` text DEFAULT NULL,
  `fee` varchar(15) NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `payment_set` (`no`, `aktif`, `sistem`, `api`, `callback`, `fee`, `id`) VALUES
	(1,'','','','','0','4FC0CC739C4F1307628C88AE1C1EF683');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_siswa2526`;

CREATE TABLE IF NOT EXISTS `tabungan_siswa2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `rekening` varchar(20) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `saldo` varchar(15) NOT NULL,
  `status` varchar(15) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `db_transaksi2526`;

CREATE TABLE IF NOT EXISTS `db_transaksi2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` datetime NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `jenjang` varchar(5) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `kategori` varchar(30) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `tahap` float NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `random` varchar(20) NOT NULL,
  `penerima` varchar(100) NOT NULL,
  `setor` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `metode` varchar(20) NOT NULL,
  `catatan` text DEFAULT NULL,
  `time` datetime NOT NULL,
  `ip` varchar(30) NOT NULL,
  `browser` text DEFAULT NULL,
  `id_tr` varchar(50) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `db_transaksi2526` (`no`, `tanggal`, `nis`, `nama`, `kelamin`, `jenjang`, `paralel`, `kategori`, `jenis`, `tahap`, `jumlah`, `random`, `penerima`, `setor`, `id_setor`, `metode`, `catatan`, `time`, `ip`, `browser`, `id_tr`, `id`) VALUES
	(2,'2025-06-02 00:00:00','2526030006','KEANU RAJA INDRAWAN','L','7','A','Umum','C',1,'7625000','C08CE9XKUG88','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-06-16 11:15:15','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36 Edg/137.0.0.0','A1F8F8FCC110AB','5934E15CVAPU9HF5AD8B'),
	(3,'2025-04-15 00:00:00','2526030009','MUHAMMAD DANIEL AKRAM','L','7','A','Umum','C',1,'8500000','566FA5PFFX89','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-06-25 14:02:24','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36 Edg/137.0.0.0','9A5C68DC46B55C','DF119726GS6FWXS3A90E'),
	(4,'2025-04-30 00:00:00','2526030009','MUHAMMAD DANIEL AKRAM','L','7','A','Umum','C',2,'8500000','41512KHKWKA6','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-06-25 14:02:48','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36 Edg/137.0.0.0','8EC8FCDC46751B','8535B8C9B4HQZR5D0600'),
	(5,'2025-04-30 00:00:00','2526030005','FAATIH ZIBRAN AL AYUUBY','L','7','A','Umum','C',1,'8500000','5C973DWTBO1C','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-06-25 14:05:03','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36 Edg/137.0.0.0','48F692E8E6D6AF','37A9231657GFQN20E94C'),
	(6,'2025-04-28 00:00:00','2526030011','NAZWA MAUDI AULIA','P','7','A','Umum','C',1,'10000000','EF886GKQKFA6','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-06-25 14:06:45','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36 Edg/137.0.0.0','A6DD981EF9FB8F','AED4DA27FVJOKCWE6D41'),
	(7,'2025-04-14 00:00:00','2526030008','KIASATINA AMILIA GUNAWAN','P','7','A','Umum','C',1,'5000000','974CFW4QC206','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-06-25 14:07:32','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36 Edg/137.0.0.0','99EF2D4916CEE5','33CCEF76YFTMIG9A8A79'),
	(8,'2025-04-16 00:00:00','2526030010','MUHAMMAD KINZA MIFZAL','L','7','A','Umum','C',1,'16500000','07B26UXWIM9E','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-06-25 14:08:22','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36 Edg/137.0.0.0','0A99AA1CBAB5C4','D3CBF733YXIOPGEDF84A'),
	(9,'2025-04-16 00:00:00','2526030004','CHANTIQA DESVYRA','P','7','A','Umum','C',1,'5000000','F00B4X2VBZ85','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-06-25 14:11:16','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36 Edg/137.0.0.0','0DC47E68EDEC0D','76B3C6B2E6NL5GO47EB9'),
	(10,'2025-04-20 00:00:00','2526030012','PAKSI HEKSA UTAMA','L','7','A','Umum','C',1,'5000000','A59AF1DRMR4F','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-06-25 14:12:42','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36 Edg/137.0.0.0','BFC5993AD9496A','F400442BGB45YYQFDE48'),
	(11,'2025-04-28 00:00:00','2526030007','MEYZHILA AURORA NOVIANDRE','P','7','A','Umum','C',1,'5750000','765C2SX7S284','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-06-25 14:56:04','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36 Edg/137.0.0.0','0520E3765A0F3D','135068296FOHJ3P4ECE4'),
	(12,'2025-07-07 00:00:00','2526030008','KIASATINA AMILIA GUNAWAN','P','7','A','Umum','B',1,'700000','F5A82Z58YA72','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-09 21:00:33','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','50E0714916EDCC','F55B9711J2F41AX0ABEB'),
	(13,'2025-07-01 00:00:00','2526030002','ALDYANSYAH DARAJAT','L','7','A','Umum','C',1,'5000000','CC28141CEIE6','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-09 21:04:42','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0717D88631EB8C','F94DD3B612KDTZ66908A'),
	(14,'2025-07-02 00:00:00','2526030005','FAATIH ZIBRAN AL AYUUBY','L','7','A','Umum','C',2,'8500000','3AB91IN6538E','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-09 21:07:16','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0538BEE8E6D288','2A17137FHCPJBC4653B4'),
	(15,'2025-07-07 00:00:00','2526030008','KIASATINA AMILIA GUNAWAN','P','7','A','Umum','C',2,'7500000','46D94P43ZB31','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-09 21:08:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','03A11D4916F637','8D347BFAGZC3KCPBFE11'),
	(16,'2025-07-04 00:00:00','2526030013','QALESYA QAIREEN ROYCE','P','7','A','Umum','C',1,'6500000','9316E5P12MC0','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-09 21:10:14','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','574C86F7E5FF1C','F652F67759PQUEU84A7B'),
	(17,'2025-07-09 00:00:00','2425020020','ALVINO MUHAMMAD RASYHA NOORIS','L','9','A','Umum','C',1,'1900000','E4980MVWA74C','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-10 16:37:17','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3A37BD3D332A42','9E06EDDB22PHQFUD5D82'),
	(18,'2025-07-05 00:00:00','2324010001','VIYONA PUTRI RAKHMAN','P','9','A','Umum','B',1,'275000','A42E935LP96A','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-10 16:42:46','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','BF028D60C40BED','81F7034EM27L4BHA1D7D'),
	(21,'2025-07-07 00:00:00','2425020020','ALVINO MUHAMMAD RASYHA NOORIS','L','9','A','Umum','B',1,'650000','9128DP5PAODE','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-10 19:56:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','90409A3D3356BD','FF04B6B34GNXE1Q7AAFC'),
	(22,'2025-07-07 00:00:00','2425020009','MARYAM NAURA IZZATUNNISA','P','8','A','Umum','B',1,'650000','627F9HGSNYBB','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-10 19:58:07','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','13AC5CF69465F9','FB1E6D65Y6FHHIIF26E5'),
	(23,'2025-07-06 00:00:00','2425020003','ARJUNA PUTRA WIBAWA','L','8','A','Umum','B',1,'650000','1D80CZP9OKD5','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-10 19:59:22','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','457F195D288CAC','770147022FN62MY2B3EC'),
	(24,'2025-07-08 00:00:00','2425020002','AL FIRYAALI ATHALIA HUSNA','P','8','A','Umum','B',1,'650000','165CFZGEZI20','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-10 20:00:20','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','ADB121EFA79D2A','CBBB9C20JTEJGW432A5D'),
	(25,'2025-07-10 00:00:00','2425020004','FIRJANI ALMA AFRINA','P','8','A','Umum','B',1,'650000','C3669XHEMOB6','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-10 20:01:45','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D96A46044BC147','E5E57C199FD1BDAFAAC0'),
	(26,'2025-07-10 00:00:00','2425020005','GHAZI AZKA JUNIOR','L','8','A','Umum','B',1,'604500','2B3FDIWXV43B','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-10 20:02:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D015FA304F520C','2F619D71S98BOB4F391B'),
	(27,'2025-07-10 00:00:00','2425020010','MUHAMMAD A&#039;LA DANADYAKSA','L','8','A','Umum','B',1,'650000','25053ZKU5F25','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-10 20:04:47','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8791100357AF82','689EFE048542UC4F2AC3'),
	(28,'2025-07-10 00:00:00','2425020012','MUHAMMAD TRISTAN ALVITO','L','8','A','Umum','B',1,'650000','0634F1Q72C8A','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-10 20:05:31','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','23067D51749002','E34623BB4N976GQ17346'),
	(29,'2025-07-11 00:00:00','2526030014','REYZO AKENO AL-FARISI','L','7','A','Umum','C',1,'10000000','25D0954O0NCA','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-11 15:58:22','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','5FB3F199ACB995','E9A78E29TB8GSMLF6F23'),
	(30,'2025-07-11 00:00:00','2526030015','JAFAR SIDIK','L','7','A','Umum','C',1,'2000000','B9413HBI6Z14','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-11 15:58:56','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9F410005B1A9DF','C3D5A705KWWE4M34AC36'),
	(31,'2025-07-10 00:00:00','2425020008','KAYLA MEOQUANEE INDRAWAN','P','8','A','Umum','C',1,'6500000','C7AE58ENNB9B','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 19:41:31','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','A81FE15784B57F','AC5102D4FGW8LQK2FC26'),
	(32,'2025-07-10 00:00:00','2425020011','MUHAMMAD AZKA GHOSSANNY','L','8','A','Umum','C',1,'6500000','426920B3HVD6','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 19:42:38','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','26E23651345B26','85050169H361JKJ9D23F'),
	(33,'2025-07-11 00:00:00','2425020004','FIRJANI ALMA AFRINA','P','8','A','Umum','C',1,'6500000','4A789J7EAMA5','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 19:43:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','BFB2F9044B6D36','05AE7612U6GPM4H534CF'),
	(34,'2025-07-11 00:00:00','2425020009','MARYAM NAURA IZZATUNNISA','P','8','A','Umum','C',1,'6500000','7DF8B3ORZ4F4','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 19:44:56','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C5A689F694AE20','52EA0DD6EBWHEJK8FFBA'),
	(36,'2025-07-11 00:00:00','2425020016','DYLAN ZACKY','L','8','A','Umum','B',1,'650000','97B77CEYL9F9','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 19:57:58','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','B26E9F1DDC5D12','61128EB0IDV3XEECC0B3'),
	(37,'2025-07-11 00:00:00','2425020017','NAJMA CETTA DESANDRA','P','8','A','Umum','B',1,'650000','F79C576ZM3FF','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 20:00:27','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','1A879A5C12ED81','A0D77574NXZ4O0N2A6D1'),
	(38,'2025-07-11 00:00:00','2425020017','NAJMA CETTA DESANDRA','P','8','A','Umum','C',1,'6500000','F79C5EJ63D28','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 20:00:27','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','1A879A5C12ED81','10EF5E383Q9K3WZ93718'),
	(39,'2025-07-11 00:00:00','2324010008','ALVITO ABINAYAJATI','L','9','A','Umum','C',1,'2000000','7EC88OPT9GA7','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 20:02:33','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2DAE604F882E7A','8E95B81DWJ6M95VCA3E6'),
	(40,'2025-07-11 00:00:00','2324010009','RAZAN AZKIA LESMANA','L','9','A','Umum','B',1,'550000','C6C92KG6BZ11','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 20:05:17','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F17ACFC8F1B7BB','C9C4799A1LI0DQSDE9AB'),
	(41,'2025-07-11 00:00:00','2324010009','RAZAN AZKIA LESMANA','L','9','A','Umum','C',1,'7250000','C6C92EF26J0E','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 20:05:17','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F17ACFC8F1B7BB','640D6AFEL4V09ZS9793F'),
	(42,'2025-07-11 00:00:00','2425020013','RAFFA KHAIRUN FAHMI','L','8','A','Umum','B',1,'650000','24CEFSRKRDFC','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 20:13:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4E4359B2430EF3','69A0432DILH852XD0FC5'),
	(43,'2025-07-11 00:00:00','2425020013','RAFFA KHAIRUN FAHMI','L','8','A','Umum','C',1,'6500000','24CEFXX2ZXFC','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 20:13:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4E4359B2430EF3','EF30DB93M8LASH3C3C99'),
	(44,'2025-07-12 00:00:00','2425020002','AL FIRYAALI ATHALIA HUSNA','P','8','A','Umum','C',1,'6500000','23CE0ZMGTTD4','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 20:14:33','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','07D317EFA78E2A','A16274944Y9FASI167DE'),
	(45,'2025-07-12 00:00:00','2425020001','AIRIN AZZAHRA','P','8','A','Umum','B',1,'604500','B1DE32QKNN52','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 20:15:48','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','91F0A5653D70DA','3F020E14LRAGJ5A29BDA'),
	(46,'2025-07-12 00:00:00','2425020019','NAJLA ZAHIA MEHRIN','P','9','A','Umum','B',1,'650000','ED6BDMJN3S1C','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 20:18:22','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','65BC0AC56FF7C8','689FBA0396Q6OKUB9C65'),
	(47,'2025-07-12 00:00:00','2425020019','NAJLA ZAHIA MEHRIN','P','9','A','Umum','C',1,'7250000','4AEEEA9I9KA8','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-12 20:18:23','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','65BC0AC56FF7C8','1B71E466UGV4MFD66161'),
	(48,'2025-07-11 00:00:00','2526030003','ANAYA MIKHAYLA SEPUTRI','P','7','A','Umum','C',1,'5750000','BF66FZX8K657','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-13 21:17:16','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','6DCAFE53E41B4A','D8E99837H5N4GHKF2371'),
	(49,'2025-07-11 00:00:00','2526030003','ANAYA MIKHAYLA SEPUTRI','P','7','A','Umum','B',1,'700000','2710BW9RKD69','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-13 21:22:36','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9808AF53E4CFF0','FFDBE82EDMUCGHCF3E66'),
	(50,'2025-07-14 00:00:00','2324010010','IHSAN KURNIAWAN','L','9','A','Umum','B',1,'550000','848E5P9R2L07','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-14 13:14:13','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C4AA709BF6AF4C','88DB17D4B85I98OD3269'),
	(51,'2025-07-14 00:00:00','2324010010','IHSAN KURNIAWAN','L','9','A','Umum','C',1,'7250000','848E5TBERZ87','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-14 13:14:13','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C4AA709BF6AF4C','62B0CA572VK6RJV47160'),
	(52,'2025-07-14 00:00:00','2324010003','GADIZA RAYNA SYAHIRA','P','9','A','Umum','B',1,'550000','5E2DAHRHCGC9','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-14 13:15:02','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2062D9701C0260','B1115A70IH8RGY8D9E1E'),
	(53,'2025-07-14 00:00:00','2324010003','GADIZA RAYNA SYAHIRA','P','9','A','Umum','C',1,'7250000','5E2DA1YYDI26','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-14 13:15:02','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2062D9701C0260','B862D9E2TODK6CYCAE06'),
	(54,'2025-07-15 00:00:00','2324010008','ALVITO ABINAYAJATI','L','9','A','Umum','B',1,'550000','ED614E7TQCAE','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-15 11:27:36','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','1361834F8846AA','ABBDFAA8QR24TJUF0035'),
	(55,'2025-07-15 00:00:00','2324010007','ALIKHA NAYLA PUTRI ANDRYAN','P','9','A','Umum','B',1,'511500','EC6B44W8U398','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-15 11:28:59','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8F18B514EBB7C5','DE8E7A048E812UA0695B'),
	(56,'2025-07-15 00:00:00','2324010007','ALIKHA NAYLA PUTRI ANDRYAN','P','9','A','Umum','C',1,'4000000','EC6B493V2K86','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-15 11:28:59','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8F18B514EBB7C5','BBDB8CE87FXIG4BEB2FD'),
	(57,'2025-07-11 00:00:00','2324010001','VIYONA PUTRI RAKHMAN','P','9','A','Umum','C',1,'1100000','D91348QJZN81','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-15 12:38:11','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','5219D760C45305','06213F32P4GDD5E07CEA'),
	(58,'2025-07-15 00:00:00','2425020005','GHAZI AZKA JUNIOR','L','8','A','Umum','C',1,'1500000','986F1PLV6CA9','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-15 16:50:43','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0EB6D2304F15D5','5F796577SVYLFC07DD04'),
	(59,'2025-07-15 00:00:00','2526030007','MEYZHILA AURORA NOVIANDRE','P','7','A','Umum','C',2,'5750000','E0F05UX75D1F','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-15 16:52:04','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D07AA79FE00E97','7B2B24F636O384K3449B'),
	(60,'2025-07-15 00:00:00','2526030002','ALDYANSYAH DARAJAT','L','7','A','Umum','C',2,'5000000','63E45Q1S7W12','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-15 16:53:06','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','1BCF3D64EC4D1A','0F47EC5DR46GIYE7717A'),
	(61,'2025-07-15 00:00:00','2526030006','KEANU RAJA INDRAWAN','L','7','A','Umum','C',2,'7625000','950302DUVJA8','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-15 16:54:15','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','E5736867446F26','1A1C0097SEKDEC87C6D8'),
	(64,'2025-07-15 00:00:00','2526030012','PAKSI HEKSA UTAMA','L','7','A','Umum','B',1,'700000','ACAF8SYN8Q45','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-15 16:57:33','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','6727D93ECEBD63','5271B1C2W7GQB5YB92E0'),
	(65,'2025-07-15 00:00:00','2526030012','PAKSI HEKSA UTAMA','L','7','A','Umum','C',2,'7000000','ACAF8ZEV7VA4','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-15 16:57:33','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','6727D93ECEBD63','3BE84C6ACEAEFGX26429'),
	(66,'2025-07-15 00:00:00','2526030013','QALESYA QAIREEN ROYCE','P','7','A','Umum','B',1,'700000','3C972EINWM1B','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-15 16:58:48','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','CD92DF6993F02A','A2B5C3F2NREB7TJ1EE46'),
	(67,'2025-07-15 00:00:00','2526030013','QALESYA QAIREEN ROYCE','P','7','A','Umum','C',2,'6500000','3C972XPIJL5C','e3afed0047b08059d0fada10f400c1e5','','','Bank','','2025-07-15 16:58:48','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','CD92DF6993F02A','663E6EDEY5Y2YV46A5D4');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_transaksi2526`;

CREATE TABLE IF NOT EXISTS `tabungan_transaksi2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `jurnal` varchar(1) NOT NULL,
  `catatan` text NOT NULL,
  `created_by` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



-- ------------------------------------------------ 

