DROP TABLE IF EXISTS `sekolah`;

CREATE TABLE IF NOT EXISTS `sekolah` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `sekolah` varchar(200) NOT NULL,
  `alamat` varchar(150) NOT NULL,
  `kota` varchar(20) NOT NULL,
  `jenjang` varchar(4) NOT NULL,
  `nama_kuitansi` varchar(25) NOT NULL,
  `info_kuitansi` varchar(10) NOT NULL,
  `info_tahap` varchar(10) NOT NULL,
  `info_kettrans` varchar(20) NOT NULL,
  `bg` varchar(10) NOT NULL,
  `menu` varchar(5) NOT NULL,
  `versi` varchar(10) NOT NULL,
  `bg_color` varchar(20) NOT NULL,
  `nama_pimpinan` varchar(100) NOT NULL,
  `pimpinan` varchar(50) NOT NULL,
  `model_kw` varchar(20) NOT NULL,
  `startPeriode` varchar(20) NOT NULL,
  `tgl_backup` date NOT NULL,
  `kops1` text NOT NULL,
  `kops2` text NOT NULL,
  `simakom_bendahara_nama` varchar(250) NOT NULL,
  `simakom_bendahara_nip` varchar(18) NOT NULL,
  `simakom_atasan_nama` varchar(250) NOT NULL,
  `simakom_atasan_nip` varchar(118) NOT NULL,
  `simakom_atasan_jabatan` varchar(250) NOT NULL,
  `simakom_atasan2_nama` varchar(250) NOT NULL,
  `simakom_atasan2_jabatan` varchar(250) NOT NULL,
  `simakom_ppk_nama` varchar(200) NOT NULL,
  `simakom_ppk_nip` varchar(18) NOT NULL,
  `simakom_ppk_jabatan` varchar(200) NOT NULL,
  `notice` text,
  `notice2` text,
  `tk` text,
  `tp` varchar(10) NOT NULL,
  `webaddress` text NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `sekolah` (`no`, `sekolah`, `alamat`, `kota`, `jenjang`, `nama_kuitansi`, `info_kuitansi`, `info_tahap`, `info_kettrans`, `bg`, `menu`, `versi`, `bg_color`, `nama_pimpinan`, `pimpinan`, `model_kw`, `startPeriode`, `tgl_backup`, `kops1`, `kops2`, `simakom_bendahara_nama`, `simakom_bendahara_nip`, `simakom_atasan_nama`, `simakom_atasan_nip`, `simakom_atasan_jabatan`, `simakom_atasan2_nama`, `simakom_atasan2_jabatan`, `simakom_ppk_nama`, `simakom_ppk_nip`, `simakom_ppk_jabatan`, `notice`, `notice2`, `tk`, `tp`, `webaddress`, `id`) VALUES
	(1,'SMA Mulia Jakarta','Jakarta','Jakarta','SMA','Nama Siswa','ya','ya','no','primary','','','primary','','','6','1','2023-10-01','','','KHumaira','1123232','AHmad','22545','Ketua Yayasan','','','','','','Tes Teks 1','Tess Lagi Teks 2','TERIMA KASIH','2024/2025','http://localhost/akssimakom6','527101586215FB60385E3E29321B94B6');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `serial`;

CREATE TABLE IF NOT EXISTS `serial` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `sekolah` varchar(200) NOT NULL,
  `seri` varchar(100) NOT NULL,
  `aktivasi` varchar(100) NOT NULL,
  `tanggal` date NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `serial` (`no`, `sekolah`, `seri`, `aktivasi`, `tanggal`, `id`) VALUES
	(1,'SMA Mulia Jakarta','8F9E58-45722S-58677A-4BDE58-9412A2','E108AF12A2AF2DE9EE5B98CB56EFFCB4B0CBF1679A8ADB0F89A','2023-10-01','527101586215FB60385E3E29321B94B6');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `user`;

CREATE TABLE IF NOT EXISTS `user` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` varchar(20) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `kelamin` varchar(1) NOT NULL,
  `email` varchar(120) NOT NULL,
  `hp` varchar(18) NOT NULL,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `level` varchar(20) NOT NULL,
  `status` varchar(10) NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;

INSERT INTO `user` (`no`, `id_user`, `nama`, `kelamin`, `email`, `hp`, `username`, `password`, `level`, `status`, `id`) VALUES
	(11,'9J2mFH','Khamdi','L','khamdirahmani@gmail.com','085328635677','admin','e10adc3949ba59abbe56e057f20f883e','admin','Aktif','50463efa59739fd6caf07114793ee291'),
	(26,'d0f83653fdb01ed928a4','Siti','P','','','tabungan','c1b1f59dbfe51b882c8b0dd09c86c1ca','tabungan','Aktif','d0f83653fdb01ed928a4'),
	(27,'606ef979469528e637f6','Khumairah','P','','','bendahara','c9ccd7f3c1145515a9d3f7415d5bcbea','bendahara','Aktif','606ef979469528e637f6'),
	(28,'4bc2be4245c022748235','Ahmad','L','','','kepala','870f669e4bbbfa8a6fde65549826d1c4','monitoring','Aktif','4bc2be4245c022748235'),
	(29,'6088971c048fb45e4317','Nisa','P','','','teller','8482dfb1bca15b503101eb438f52deed','teller','Aktif','6088971c048fb45e4317');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `user_siswa`;

CREATE TABLE IF NOT EXISTS `user_siswa` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `kelamin` varchar(1) NOT NULL,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `hp` varchar(15) NOT NULL,
  `email` varchar(150) NOT NULL,
  `id` text NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `nip_2` (`nis`),
  KEY `nip` (`nis`)
) ENGINE=InnoDB AUTO_INCREMENT=864 DEFAULT CHARSET=latin1;

INSERT INTO `user_siswa` (`no`, `nis`, `nama`, `kelamin`, `username`, `password`, `hp`, `email`, `id`, `status`, `created_at`, `updated_at`, `created_by`) VALUES
	(863,'230005','ARYA MAULANA','L','230005','4befdf5e38f03dbe8c375a38ea83e108','085328635677','khamdirahmani@gmail.com','14294515444befd9875d','Aktif','2024-10-20 19:46:03','2024-10-20 19:46:03','50463efa59739fd6caf07114793ee291');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_ref_akun`;

CREATE TABLE IF NOT EXISTS `simakom_ref_akun` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `akun` varchar(6) NOT NULL,
  `akun_custome` varchar(50) NOT NULL,
  `uraian` text NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=latin1;

INSERT INTO `simakom_ref_akun` (`no`, `kategori`, `akun`, `akun_custome`, `uraian`, `id`) VALUES
	(19,'A','100202','100202','Pendapatan Sewa GOR','be9bbf8e7cb2de034bee59162bafcaaefb0'),
	(17,'A','100103','100103','Penerimaan Biaya Akomodasi MMP','9ae26ff44c264acbcdb9f37bb5c08fcc9f9'),
	(18,'A','100201','100201','Pendapatan Ternak Ikan','7c7523f13ef609d154a6ac2187a5c8735fa'),
	(13,'A','100000','100000','Penerimaan Saldo Tahun Lalu','14ee22eaba29794682775be85f192af3021'),
	(14,'A','100101','100101','Penerimaan SPP','732e276ec85f14e5ddca80e9dd3badedebc'),
	(15,'A','100102','100102','Penerimaan Sumbangan Pengembangan Sekolah','54ebda338d716823ef59a48ec57a173850c'),
	(16,'A','100104','100104','Penerimaan Biaya Kelas KKO','72984ef85cbebaa1de90c11baa503343547'),
	(20,'B','200101','200101','Belanja Honorarium Guru Tidak Tetap','fae1f94c506115ec42df2a0fd12dbe9c7aa'),
	(21,'B','200102','200102','Belanja Honorarium Pegawai Tidak Tetap','bc0db1ef7e8b6388b70ac689b02eee2cda0'),
	(22,'B','200103','200103','Belanja Honorarium Pembina Ekstra Internal','bd0b3e43c34a47ccdb67d115df7de21d9b8'),
	(23,'B','200104','200104','Belanja Honorarium Pembina Ekstra Eksternal','dde4acfdb0be07ac132ad5a295fc9f4b8ad'),
	(24,'B','200201','200201','Belanja Pemeliharaan Gedung dan Bangunan','fafe0a5ad92e1f86d2c833d5982ea8d01c1'),
	(25,'B','200202','200202','Belanja Pemeliharaan Peralatan dan Mesin','452bfed404cb95dbfaadfd1aa56e52d612a'),
	(26,'B','200301','200301','Belanja Keperluan Perkantoran','8aee09e623dfe2f7d11e4d0ad60d0a5ca38'),
	(27,'B','200302','200302','Belanja Bahan','004ca31ed6cc0360fe946d3365893f2b99d'),
	(28,'B','200401','200401','Belanja Jasa Profesi','9756342aa9434be8f1e85b87a4163c6354d'),
	(29,'B','200402','200402','Belanja Sewa','800d427f7b19cf62174b86e51875116f576'),
	(30,'B','200403','200403','Belanja Langganan Daya dan Jasa','de345b20a5d60aecea768241b2e0d2fcb0d'),
	(42,'B','200107','200107','Belanja Honorarium THR Guru Tidak Tetap','6752ca88e78474b7acd301cfefc889b658a'),
	(41,'B','200106','200106','Belanja Penunjang Kegiatan Pendidikan','7a303a097dd4e0259280330a6809291f824'),
	(34,'B','299999','299999','Belanja Lainnya','94cfaff110fc98938230b1e4e53541cfbc5'),
	(35,'B','200105','200105','Belanja Honor Kegiatan','e085d8a5248ec1cee089e4a2bff2e804231'),
	(36,'A','100301','100301','Bantuan Operasional Sekolah (BOS)','a6061a0c10b13bf137460ec8e143a214b05'),
	(37,'A','199999','199999','Penerimaan Lain','174d10d8134ad94f0c285f19d5f8238d516'),
	(38,'A','100105','100105','Penerimaan Biaya Kelas Akademik','123faaaa42b5d906c7d0fa6b50781c14bca'),
	(39,'B','200501','200501','Belanja Perjaanan Dinas','269727a2b342292f278b69e51643ea9e1b8'),
	(40,'B','200210','200210','Belanja Pengadaan Tanah','71464592903d1ac6bfb8cdcfed812c0c969'),
	(43,'B','200108','200108','Belanja Honorarium THR Pegawai Tidak Tetap','1fdbafb8171bc612ee72f9fa507f8e4fa32'),
	(44,'B','200109','200109','Belanja Honorarium Ke-13 Guru Tidak Tetap','b746153e7a27362c6c611539f2d9acd0094'),
	(45,'B','200110','200110','Belanja Honorarium Ke-13 Pegawai Tidak Tetap','f234d714e94e229d926d70b864ce568ad54'),
	(46,'B','200111','200111','Belanja Tunjangan Reward Kehadiran Guru Tidak Tetap','6e59975fd49e3d83bcf5381468064911efa'),
	(47,'B','200112','200112','Belanja Tunjangan Reward Kehadiran Pegawai Tidak Tetap','8655f16996c8058e106e2bc0ab56d9a4f0b'),
	(48,'B','200113','200113','Belanja Honorarium Petugas Piket Hari Libur','d6155c6ec9d14c2bdc408fb3fe9db1bfa3e'),
	(49,'A','100302','100302','Uang Kegiatan','8acdf12cd77f6e7b488840a65a20ab6e33d');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_ref_kegiatan`;

CREATE TABLE IF NOT EXISTS `simakom_ref_kegiatan` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(100) NOT NULL,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `kegiatan_custome` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=latin1;

INSERT INTO `simakom_ref_kegiatan` (`no`, `id`, `kategori`, `kegiatan`, `kegiatan_custome`, `uraian`) VALUES
	(112,'a9b7ba70783b617682775be85f192af3021','A','1000','1000','Penerimaan Saldo Tahun Lalu'),
	(113,'b8c37e33defde51c9354242c284f97a5e37','A','1001','1001','Penerimaan Sumbangan Masyarakat'),
	(114,'5ec829debe54b19f0c285f19d5f8238d516','A','1999','1999','Penerimaan Lain'),
	(115,'fba9d88164f3e2d96797f48c50918cfed34','A','1002','1002','Penerimaan Pendapatan Asli sekolah'),
	(116,'08f90c1a41715538b72664c9498459011e6','B','2000','2000','Belanja Kegiatan Standar Kelulusan'),
	(117,'d0fb963ff976f9c653181e9d8ca9683b483','B','2001','2001','Belanja Kegiatan Standar Isi'),
	(118,'4ba29b9f9e5732ec04affa66cf010b62572','B','2002','2002','Belanja Kegiatan Standar Proses'),
	(119,'a591024321c5e2b16506375d817b0241e6f','B','2003','2003','Belanja Kegiatan Standar Pengelolaan'),
	(120,'b8b4b727d6f5d1b10479106d6c3105ea2a5','B','2004','2004','Belanja Kegiatan Standar Tendik'),
	(121,'d47268e9db2e9aa32fc56790236f069da49','B','2005','2005','Belanja Kegiatan Standar Pembiayaan'),
	(122,'ea5a486c712a91eb215f8699c222f811cdc','B','2006','2006','Belanja Kegiatan Standar Sarana Prasarana'),
	(123,'a00e5eb0973d2463c5686760dfed4295acd','B','2007','2007','Belanja Kegiatan Standar Penilaian'),
	(124,'aa68c75c4a77c870bcef3a2582241da86d0','A','1003','1003','Penerimaan Uang Kegiatan'),
	(125,'a36e841c5230a796600fd02a16301a5fb97','B','2999','2999','Belanja Lain-lain');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_nama_bayar`;

CREATE TABLE IF NOT EXISTS `tb_nama_bayar` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(10) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kode` varchar(2) NOT NULL,
  `bulanan` varchar(10) NOT NULL,
  `id` varchar(15) NOT NULL,
  `blok` varchar(20) NOT NULL,
  `kelas` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=latin1;

INSERT INTO `tb_nama_bayar` (`no`, `tp`, `nama`, `kode`, `bulanan`, `id`, `blok`, `kelas`) VALUES
	(31,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024A8','','11'),
	(32,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024A9','','12'),
	(34,'2023/2024','Sumbangan Operasional Sekolah (SOP)','B','Ya','2023/2024B10','','10'),
	(35,'2023/2024','Sumbangan Operasional Sekolah (SOP)','B','Ya','2023/2024B8','','11'),
	(36,'2023/2024','Sumbangan Operasional Sekolah (SOP)','B','Ya','2023/2024B9','','12'),
	(53,'2023/2024','Uang Kegiatan','C','Tidak','2023/2024C8','','11'),
	(54,'2023/2024','Uang Kegiatan','C','Tidak','2023/2024C9','','12'),
	(61,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024ALulus','','LULUS'),
	(62,'2023/2024','Uang Kegiatan','C','Tidak','2023/2024C7','','10'),
	(63,'2024/2025','Tanggungan Tahun Lalu','A','Tidak','2024/2025A11','','11'),
	(64,'2024/2025','Tanggungan Tahun Lalu','A','Tidak','2024/2025A12','','12'),
	(65,'2024/2025','Tanggungan Tahun Lalu','A','Tidak','2024/2025ALULUS','','LULUS'),
	(66,'2024/2025','Sumbangan Operasional Sekolah (SOP)','B','Ya','2024/2025B10','','10'),
	(67,'2024/2025','Sumbangan Operasional Sekolah (SOP)','B','Ya','2024/2025B11','','11'),
	(68,'2024/2025','Sumbangan Operasional Sekolah (SOP)','B','Ya','2024/2025B12','','12'),
	(69,'2024/2025','Uang Kegiatan','C','Tidak','2024/2025C11','','11'),
	(70,'2024/2025','Uang Kegiatan','C','Tidak','2024/2025C12','','12'),
	(71,'2024/2025','Uang Kegiatan','C','Tidak','2024/2025C10','no','10');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_paralel`;

CREATE TABLE IF NOT EXISTS `tb_paralel` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(50) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `status` varchar(15) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1;

INSERT INTO `tb_paralel` (`no`, `id`, `paralel`, `status`) VALUES
	(18,'9d5ed678fe57e75fa5704cf40','B','Aktif'),
	(21,'0d61f8370cad82c486547f599','C','Aktif'),
	(23,'7fc56270e7a70c1fbfac34ac2','A','Aktif'),
	(24,'f623e75af30e6f2052d0bd5ba','D','Aktif'),
	(25,'3a3ea00cfc35009f23e17ec68','E','Aktif'),
	(26,'800618943025ed73eb5b6b972','F','Aktif'),
	(27,'dfcf28d07345df1fb088c98f0','G','Aktif'),
	(33,'e11c1bc57b97131059d58b826','LULUS','Aktif');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa_kategori`;

CREATE TABLE IF NOT EXISTS `tb_siswa_kategori` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(200) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO `tb_siswa_kategori` (`no`, `kategori`, `id`, `created_at`) VALUES
	(1,'Umum','919db3a7bfc497f00ddfb51592d','2023-05-24 05:31:46'),
	(4,'MMP','606670ce12a5a75f2ada86cae30','2023-07-31 08:44:47'),
	(5,'Akademik','1603223377224863b9c36f969e2','2023-07-31 08:44:57'),
	(7,'KKO 1','e45de3ad54b35ceec0902c1a7','2024-09-12 20:49:08');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_tp`;

CREATE TABLE IF NOT EXISTS `tb_tp` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(9) NOT NULL,
  `backup` varchar(100) NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;

INSERT INTO `tb_tp` (`no`, `tp`, `backup`, `time`, `id`, `created_at`, `created_by`) VALUES
	(13,'2023/2024','','2023-07-10 14:24:48','5531a5834816c3f04945cbc9d','2023-07-10 14:24:48','113ccaa98a0a30bc5204ed2fccc9c515'),
	(14,'2022/2023','','2023-10-27 05:08:41','3a824154b16ea6f0c7d72ce60','2023-10-27 05:08:41','50463efa59739fd6caf07114793ee291'),
	(18,'2024/2025','','2024-07-26 21:04:55','07811dc6c4221f9d6a9f78d4b','2024-07-26 21:04:55','50463efa59739fd6caf07114793ee291'),
	(19,'2025/2026','','2024-08-28 04:20:56','312351bff0793dcb28339caf0','2024-08-28 04:20:56','d0f83653fdb01ed928a4');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_walikelas`;

CREATE TABLE IF NOT EXISTS `tb_walikelas` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(9) NOT NULL,
  `jenjang` varchar(2) NOT NULL,
  `paralel` varchar(100) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `nip` varchar(18) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `tb_walikelas` (`no`, `tp`, `jenjang`, `paralel`, `nama`, `nip`, `id`, `created_at`, `created_by`) VALUES
	(1,'2023/2024','10','A','Siti Munawaroh, S. Pd','123456789','7564a25f9e600f6062c9','2023-10-01 21:24:02','113ccaa98a0a30bc5204ed2fccc9c515'),
	(2,'2023/2024','11','A','Sunari, S. Pd','2334566789','699781fdd84031dc76c0','2023-10-01 21:24:56','113ccaa98a0a30bc5204ed2fccc9c515'),
	(3,'2023/2024','12','A','Kurniasari, S. Pd','334567894','64e6a875450b8503641a','2023-10-01 21:25:16','113ccaa98a0a30bc5204ed2fccc9c515');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `whatsapp`;

CREATE TABLE IF NOT EXISTS `whatsapp` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `aktif` varchar(1) NOT NULL,
  `sistem` varchar(2) NOT NULL,
  `key_api` text,
  `server` text NOT NULL,
  `token` varchar(100) DEFAULT NULL,
  `device` varchar(15) DEFAULT NULL,
  `idinstance` text NOT NULL,
  `admin` varchar(15) DEFAULT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `whatsapp` (`no`, `aktif`, `sistem`, `key_api`, `server`, `token`, `device`, `idinstance`, `admin`, `id`) VALUES
	(1,'','1','','','0','','','0','E0C1A06358CCF7F36F2D151AFBD46E4A');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_periode`;

CREATE TABLE IF NOT EXISTS `tabungan_periode` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tahun` varchar(9) NOT NULL,
  `status` varchar(6) NOT NULL,
  `created_at` datetime NOT NULL,
  `closed_at` datetime DEFAULT NULL,
  `closed_by` varchar(100) DEFAULT NULL,
  `id` varchar(25) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `tahun` (`tahun`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=latin1;

INSERT INTO `tabungan_periode` (`no`, `tahun`, `status`, `created_at`, `closed_at`, `closed_by`, `id`) VALUES
	(21,'2022/2023','close','2023-04-20 11:33:23','2023-10-27 05:41:52','tabungan','38eafdfa86559e303bd0'),
	(22,'2023/2024','close','2023-04-21 19:57:26','2024-07-08 16:40:51','tabungan','da6363e171cecab03bd0'),
	(25,'2024/2025','open','2024-07-31 05:47:56','1901-01-01 00:00:00','','b97ac648a0ce450c1b1f'),
	(26,'2025/2026','close','2024-08-28 04:21:13','1901-01-01 00:00:00','','13db61814b7a0e1c1b1f');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_komponen2425`;

CREATE TABLE IF NOT EXISTS `simakom_komponen2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=latin1;

INSERT INTO `simakom_komponen2425` (`no`, `kategori`, `kegiatan`, `komponen`, `uraian`, `kode_id`, `id`, `revisi`) VALUES
	(1,'A','1000','A','Saldo Tahun Lalu','A1000A','7fc56270e7a70faa70783b617270e7a70fa96a3b','0'),
	(2,'A','1001','A','Sumbangan Masyarakat','A1001A','7fc56270e7a70fae33defde51270e7a70faa2ef4','0'),
	(3,'A','1003','A','Penerimaan Uang Kegiatan','A1003A','7fc56270e7a70fa75c4a77c87270e7a70fae45ee','0'),
	(4,'B','2000','A','Pemberian Beasiswa Siswa Berprestasi','B2000A','9d5ed678fe57bccc1a4171553270e7a70fa751d3','0'),
	(5,'B','2000','B','Kegiatan Pelepasan dan Wisuda Kelas IX','B2000B','9d5ed678fe57bccc1a4171553678fe57bccfaeac','0'),
	(6,'B','2002','A','Perlengkapan Laboratorium Komputer','B2002A','9d5ed678fe57bccb9f9e5732e270e7a70fa44195','0'),
	(7,'B','2002','B','Pengembangan Aplikasi Perpustakaan','B2002B','9d5ed678fe57bccb9f9e5732e678fe57bcc0e510','0'),
	(8,'B','2002','B','Lomba O2SN','B2002B','9d5ed678fe57bccb9f9e5732e678fe57bccaf032','0'),
	(9,'B','2002','C','Lomba POPDA','B2002C','9d5ed678fe57bccb9f9e5732e8370cad1d473f76','0'),
	(10,'B','2002','D','Reward Pembimbing Juara Lomba Resmi Tingkat Kabupaten dan tingkat diatasnya','B2002D','9d5ed678fe57bccb9f9e5732e75af30e62b738cc','0'),
	(11,'B','2002','F','Lomba online akademik','B2002F','9d5ed678fe57bccb9f9e5732e89430253159c3ce','0'),
	(12,'B','2002','G','Pengembangan Sarana dan Prasarana Multimedia','B2002G','9d5ed678fe57bccb9f9e5732e8d0734569a8f03a','0'),
	(13,'B','2002','H','Kegiatan PPDB','B2002H','9d5ed678fe57bccb9f9e5732e50f86825a1f803d','0'),
	(14,'B','2002','I','Kegiatan Penegakan Kedisiplinan Sekolah','B2002I','9d5ed678fe57bccb9f9e5732e6794b63bf97f514','0'),
	(15,'B','2002','I','Pengiriman Lomba OSN','B2002I','9d5ed678fe57bccb9f9e5732e6794b63bf98fc4c','0'),
	(16,'B','2002','L','PenyelenggaraanÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â Lomba Class Meeting','B2002L','9d5ed678fe57bccb9f9e5732eec3b48a1ee3994f','0'),
	(17,'B','2002','L','Kegiatan Kemah Pramuka Pelantikan Penggalang Rakit dan Dianpimru','B2002L','9d5ed678fe57bccb9f9e5732eec3b48a1eecf2e4','0'),
	(18,'B','2002','N','Kegiatan Pesantren Romadhon','B2002N','9d5ed678fe57bccb9f9e5732e07cb7f3c4a9f9ce','0'),
	(19,'B','2002','R','Lomba Jambore Ranting','B2002R','9d5ed678fe57bccb9f9e5732e3d405731277d06a','0'),
	(20,'B','2002','S','Lomba Jambore Cabang','B2002S','9d5ed678fe57bccb9f9e5732e8dcc983a7026180','0'),
	(21,'B','2002','T','Lomba Cerdas Tangkas Pramuka ( LCTP )','B2002T','9d5ed678fe57bccb9f9e5732e18c950afbfb6aea','0'),
	(22,'B','2002','U','Lomba Olimpiade PMR','B2002U','9d5ed678fe57bccb9f9e5732e360da93c0a842f3','0'),
	(23,'B','2002','Q','Latihan Dasar Kepemimpinan PMR Madya','B2002Q','9d5ed678fe57bccb9f9e5732e4c9ca568502a452','0'),
	(24,'B','2002','P','Lomba Jumbara Cabang','B2002P','9d5ed678fe57bccb9f9e5732eedb103a28721add','0'),
	(25,'B','2002','O','Pilkasis dan Latihan Dasar Kepemimpinan OSIS','B2002O','9d5ed678fe57bccb9f9e5732e17753c37b92ba10','0'),
	(26,'B','2003','A','Kegiatan Penyusunan EDS','B2003A','9d5ed678fe57bcc24321c5e2b270e7a70fabff82','0'),
	(27,'B','2003','C','Pelaksanaan Kegiatan Tingkat KKM','B2003C','9d5ed678fe57bcc24321c5e2b8370cad1d4bf97f','0'),
	(28,'B','2003','D','Kegiatan Penyusunan RKJM, RKT','B2003D','9d5ed678fe57bcc24321c5e2b75af30e62b2c4a8','0'),
	(29,'B','2003','D','Peningkatan Kompetensi Tenaga Administrasi Perkantoran','B2003D','9d5ed678fe57bcc24321c5e2b75af30e62b6d4a6','0'),
	(30,'B','2003','E','Honor dan Tunjangan GTT dan PTT','B2003E','9d5ed678fe57bcc24321c5e2b00cfc3533265cfe','0'),
	(31,'B','2003','F','Rakor Komite','B2003F','9d5ed678fe57bcc24321c5e2b8943025315a3458','0'),
	(32,'B','2003','H','Transport Pelaksanaan Home Visit','B2003H','9d5ed678fe57bcc24321c5e2b50f86825a1a71d8','0'),
	(33,'B','2003','G','Dana Sosial Peserta Didik','B2003G','9d5ed678fe57bcc24321c5e2b8d0734569a5759d','0'),
	(34,'B','2003','B','Kegiatan Pengelolaan Administrasi Kantor dan Rumah Tangga','B2003B','9d5ed678fe57bcc24321c5e2b678fe57bccb7923','0'),
	(35,'B','2004','A','Perjalanan Dinas Kepala Dalam dan luar Kota dalam Rangka Peningkatan Kompetensi dan Koordinasi','B2004A','9d5ed678fe57bcc727d6f5d1b270e7a70fa88dda','0'),
	(36,'B','2004','B','Pengiriman Peserta MGMP dan Sejenisnya','B2004B','9d5ed678fe57bcc727d6f5d1b678fe57bcc03b90','0'),
	(37,'B','2005','B','Pelaksanaan Kegiatan HUT RI','B2005B','9d5ed678fe57bcc8e9db2e9aa678fe57bcc7ba15','0'),
	(38,'B','2006','A','Pengadaan Sarana Fisik Meubeler','B2006A','9d5ed678fe57bcc86c712a91e270e7a70fa84150','0'),
	(39,'B','2006','B','Pengembangan Laboratorium IPA','B2006B','9d5ed678fe57bcc86c712a91e678fe57bccfb849','0'),
	(40,'B','2006','C','Pemeliharaan dan pengadaan alat elektronik','B2006C','9d5ed678fe57bcc86c712a91e8370cad1d4275a9','0'),
	(41,'B','2006','D','Pengadaan dan pemeliharaan sarana olah raga','B2006D','9d5ed678fe57bcc86c712a91e75af30e62ba7228','0'),
	(42,'B','2006','E','Pemeliharaan gedung','B2006E','9d5ed678fe57bcc86c712a91e00cfc35332a74b5','0'),
	(43,'B','2006','G','Pengembangan Perpustakaan','B2006G','9d5ed678fe57bcc86c712a91e8d0734569a871c1','0'),
	(44,'B','2006','H','Pemeliharaan halaman dan taman','B2006H','9d5ed678fe57bcc86c712a91e50f86825a131c8f','0'),
	(45,'B','2006','I','Pemeliharaan peralatan drumband','B2006I','9d5ed678fe57bcc86c712a91e6794b63bf9ba55f','0'),
	(46,'B','2006','F','Kebutuhan UKS dan P3K','B2006F','9d5ed678fe57bcc86c712a91e8943025315a8614','0'),
	(47,'B','2007','A','Penyelenggaraan Workshop/IHT Mandiri Peningkatan Kompetensi Penilaian','B2007A','9d5ed678fe57bcceb0973d246270e7a70fab1e0a','0'),
	(48,'B','2007','B','Kegiatan Asesmen Sumatif Akhir Semester Gasal/Penilaian Akhir Semester Gasal','B2007B','9d5ed678fe57bcceb0973d246678fe57bcc38b18','0'),
	(49,'B','2007','C','Asesmen Sumatif Akhir Sumatif Genap/Penilaian Akhir Tahun','B2007C','9d5ed678fe57bcceb0973d2468370cad1d431b7b','0'),
	(50,'B','2007','E','Sumatif Harian/Penilaian Harian','B2007E','9d5ed678fe57bcceb0973d24600cfc3533206eb1','0'),
	(51,'B','2007','D','Asesmen Nasional Berbasis Komputer (ANBK) ','B2007D','9d5ed678fe57bcceb0973d24675af30e62b914b6','0'),
	(52,'B','2001','A','Penyelenggaraan Kegiatan Keputrian','B2001A','9d5ed678fe57bcc63ff976f9c270e7a70fad5f03','0'),
	(53,'B','2001','B','TIM Pengelola PKG, SKP dan Supervisi Guru','B2001B','9d5ed678fe57bcc63ff976f9c678fe57bcc5072d','0'),
	(54,'B','2002','M','Pengiriman Lomba OSN Kabupaten','B2002M','9d5ed678fe57bccb9f9e5732ec7bdcc3ce6f4368','0'),
	(55,'B','2002','K','Gladian Pimpinan Regu dan Kemah Pelantikan','B2002K','9d5ed678fe57bccb9f9e5732e6a11b03839fb9ce','0'),
	(56,'B','2002','J','Kemah Penerimaan Tamu Penggalang','B2002J','9d5ed678fe57bccb9f9e5732e70aca8241995b30','0'),
	(57,'B','2002','E','Pengiriman Pramuka Garuda Kabupaten','B2002E','9d5ed678fe57bccb9f9e5732e00cfc3533264b2c','0'),
	(58,'B','2005','A','Pemberian Bantuan Sosial dan keringanan Siswa Tidak Mampu','B2005A','9d5ed678fe57bcc8e9db2e9aa270e7a70fa92daa','0'),
	(59,'A','1002','A','Hasil Sewa GOR','A1002A','7fc56270e7a70fa88164f3e2d270e7a70fab0f07','0'),
	(60,'B','2001','C','Kegiatan Workshop KTSP','B2001C','9d5ed678fe57bcc63ff976f9c8370cad1d4be6c5','0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_kegiatan2425`;

CREATE TABLE IF NOT EXISTS `simakom_kegiatan2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

INSERT INTO `simakom_kegiatan2425` (`no`, `kategori`, `kegiatan`, `uraian`, `kode_id`, `id`, `revisi`) VALUES
	(1,'A','1000','Penerimaan Saldo Tahun Lalu','A1000','7fc56270e7a70faa70783b617e9998dc4dd96a3b','0'),
	(2,'A','1001','Penerimaan Sumbangan Masyarakat','A1001','7fc56270e7a70fae33defde51cf91e1e03ea2ef4','0'),
	(3,'B','2001','Belanja Kegiatan Standar Isi','B2001','9d5ed678fe57bcc63ff976f9c37fc81fe03e45ee','0'),
	(4,'B','2005','Belanja Kegiatan Standar Pembiayaan','B2005','9d5ed678fe57bcc8e9db2e9aa3827bba3af7d066','0'),
	(5,'B','2002','Belanja Kegiatan Standar Proses','B2002','9d5ed678fe57bccb9f9e5732ed33761840f751d3','0'),
	(6,'B','2007','Belanja Kegiatan Standar Penilaian','B2007','9d5ed678fe57bcceb0973d24649a4a920fc0a800','0'),
	(7,'B','2000','Belanja Kegiatan Standar Kelulusan','B2000','9d5ed678fe57bccc1a417155361a5c4b8d2ea20a','0'),
	(8,'B','2004','Belanja Kegiatan Standar Tendik','B2004','9d5ed678fe57bcc727d6f5d1b61fff7be6884eb1','0'),
	(9,'B','2006','Belanja Kegiatan Standar Sarana Prasarana','B2006','9d5ed678fe57bcc86c712a91e48443cd802d2490','0'),
	(10,'B','2003','Belanja Kegiatan Standar Pengelolaan','B2003','9d5ed678fe57bcc24321c5e2bdbd23ed35f44195','0'),
	(11,'A','1003','Penerimaan Uang Kegiatan','A1003','7fc56270e7a70fa75c4a77c87f97fb686b273f76','0'),
	(12,'A','1002','Penerimaan Pendapatan Asli sekolah','A1002','7fc56270e7a70fa88164f3e2d9109ee7702738cc','0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_akun2425`;

CREATE TABLE IF NOT EXISTS `simakom_akun2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `akun` float NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `akun_id` varchar(15) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=101 DEFAULT CHARSET=latin1;

INSERT INTO `simakom_akun2425` (`no`, `kategori`, `kegiatan`, `komponen`, `akun`, `uraian`, `kode_id`, `akun_id`, `id`, `revisi`) VALUES
	(1,'A','1000','A',100000,'Penerimaan Saldo Tahun Lalu','A1000A','A1000100000A','7fc56270e7a70783b617270e7a70fa2eaba96a3b','0'),
	(2,'A','1001','A',100102,'Penerimaan Sumbangan Pengembangan Sekolah','A1001A','A1001100102A','7fc56270e7e33defde51270e7a70faa338da2ef4','0'),
	(3,'A','1003','A',100302,'Uang Kegiatan','A1003A','A1003100302A','7fc56270e775c4a77c87270e7a70fa12cd7faeac','0'),
	(4,'B','2000','A',200106,'Belanja Penunjang Kegiatan Pendidikan','B2000A','B2000200106A','9d5ed678fec1a4171553270e7a70faa097dfad6f','0'),
	(5,'B','2000','B',200501,'Belanja Perjaanan Dinas','B2000B','B2000200501B','9d5ed678fec1a4171553678fe57bcc7a2b30a800','0'),
	(6,'B','2000','B',200105,'Belanja Honor Kegiatan','B2000B','B2000200105B','9d5ed678fec1a4171553678fe57bcc8a524ea20a','0'),
	(7,'B','2000','B',200302,'Belanja Bahan','B2000B','B2000200302B','9d5ed678fec1a4171553678fe57bcc31ed684eb1','0'),
	(8,'B','2000','B',200106,'Belanja Penunjang Kegiatan Pendidikan','B2000B','B2000200106B','9d5ed678fec1a4171553678fe57bcca097dd2490','0'),
	(9,'B','2000','B',200402,'Belanja Sewa','B2000B','B2000200402B','9d5ed678fec1a4171553678fe57bcc27f7b44195','0'),
	(10,'B','2001','A',200105,'Belanja Honor Kegiatan','B2001A','B2001200105F','9d5ed678fe63ff976f9c270e7a70fa8a524bda8f','0'),
	(11,'B','2002','A',200302,'Belanja Bahan','B2002A','B2002200302A','9d5ed678feb9f9e5732e270e7a70fa31ed69f9ce','0'),
	(12,'B','2002','A',200401,'Belanja Jasa Profesi','B2002A','B2002200401A','9d5ed678feb9f9e5732e270e7a70fa42aa928fd0','0'),
	(13,'B','2002','B',200301,'Belanja Keperluan Perkantoran','B2002B','B2002200301B','9d5ed678feb9f9e5732e678fe57bcc9e6239ac05','0'),
	(14,'B','2002','M',200105,'Belanja Honor Kegiatan','B2002M','B2002200105Z3','9d5ed678feb9f9e5732ec7bdcc3ce68a5245f55a','0'),
	(15,'B','2002','I',200105,'Belanja Honor Kegiatan','B2002I','B2002200105I','9d5ed678feb9f9e5732e6794b63bf98a524b67bf','0'),
	(16,'B','2002','C',200106,'Belanja Penunjang Kegiatan Pendidikan','B2002C','B2002200106C','9d5ed678feb9f9e5732e8370cad1d4a097d7d06a','0'),
	(17,'B','2002','D',200106,'Belanja Penunjang Kegiatan Pendidikan','B2002D','B2002200106D','9d5ed678feb9f9e5732e75af30e62ba097d26180','0'),
	(18,'B','2002','F',200106,'Belanja Penunjang Kegiatan Pendidikan','B2002F','B2002200106F','9d5ed678feb9f9e5732e8943025315a097d842f3','0'),
	(19,'B','2002','H',200302,'Belanja Bahan','B2002H','B2002200302H','9d5ed678feb9f9e5732e50f86825a131ed62f1ee','0'),
	(20,'B','2002','L',200302,'Belanja Bahan','B2002L','B2002200302L','9d5ed678feb9f9e5732eec3b48a1ee31ed6a3458','0'),
	(21,'B','2002','N',200105,'Belanja Honor Kegiatan','B2002N','B2002200105N','9d5ed678feb9f9e5732e07cb7f3c4a8a5245759d','0'),
	(22,'B','2002','N',200401,'Belanja Jasa Profesi','B2002N','B2002200401N','9d5ed678feb9f9e5732e07cb7f3c4a42aa9b7923','0'),
	(23,'B','2002','R',200302,'Belanja Bahan','B2002R','B2002200302R','9d5ed678feb9f9e5732e3d4057312731ed6b34f3','0'),
	(24,'B','2002','R',200105,'Belanja Honor Kegiatan','B2002R','B2002200105R','9d5ed678feb9f9e5732e3d405731278a5247ba15','0'),
	(25,'B','2002','S',200105,'Belanja Honor Kegiatan','B2002S','B2002200105S','9d5ed678feb9f9e5732e8dcc983a708a52484150','0'),
	(26,'B','2002','S',200302,'Belanja Bahan','B2002S','B2002200302S','9d5ed678feb9f9e5732e8dcc983a7031ed6275a9','0'),
	(27,'B','2002','T',200105,'Belanja Honor Kegiatan','B2002T','B2002200105T','9d5ed678feb9f9e5732e18c950afbf8a524a7228','0'),
	(28,'B','2002','T',200106,'Belanja Penunjang Kegiatan Pendidikan','B2002T','B2002200106T','9d5ed678feb9f9e5732e18c950afbfa097da74b5','0'),
	(29,'B','2002','T',200302,'Belanja Bahan','B2002T','B2002200302T','9d5ed678feb9f9e5732e18c950afbf31ed6c4258','0'),
	(30,'B','2002','U',200106,'Belanja Penunjang Kegiatan Pendidikan','B2002U','B2002200106U','9d5ed678feb9f9e5732e360da93c0aa097d31c8f','0'),
	(31,'B','2002','U',200302,'Belanja Bahan','B2002U','B2002200302U','9d5ed678feb9f9e5732e360da93c0a31ed6207f4','0'),
	(32,'B','2002','Q',200105,'Belanja Honor Kegiatan','B2002Q','B2002200105V','9d5ed678feb9f9e5732e4c9ca568508a524ba55f','0'),
	(33,'B','2002','Q',200302,'Belanja Bahan','B2002Q','B2002200302V','9d5ed678feb9f9e5732e4c9ca5685031ed6a8614','0'),
	(34,'B','2002','P',200106,'Belanja Penunjang Kegiatan Pendidikan','B2002P','B2002200106W','9d5ed678feb9f9e5732eedb103a287a097d38b18','0'),
	(35,'B','2002','P',200302,'Belanja Bahan','B2002P','B2002200302W','9d5ed678feb9f9e5732eedb103a28731ed631b7b','0'),
	(36,'B','2002','O',200105,'Belanja Honor Kegiatan','B2002O','B2002200105Y','9d5ed678feb9f9e5732e17753c37b98a52406eb1','0'),
	(37,'B','2002','O',200302,'Belanja Bahan','B2002O','B2002200302Y','9d5ed678feb9f9e5732e17753c37b931ed618bbc','0'),
	(38,'B','2003','A',200302,'Belanja Bahan','B2003A','B2003200302A','9d5ed678fe24321c5e2b270e7a70fa31ed6bbf14','0'),
	(39,'B','2003','C',299999,'Belanja Lainnya','B2003C','B2003299999C','9d5ed678fe24321c5e2b8370cad1d4ff110d5f03','0'),
	(40,'B','2003','D',200302,'Belanja Bahan','B2003D','B2003200302D','9d5ed678fe24321c5e2b75af30e62b31ed65072d','0'),
	(41,'B','2003','D',200501,'Belanja Perjaanan Dinas','B2003D','B2003200501D','9d5ed678fe24321c5e2b75af30e62b7a2b356d9b','0'),
	(42,'B','2003','E',200102,'Belanja Honorarium Pegawai Tidak Tetap','B2003E','B2003200102E','9d5ed678fe24321c5e2b00cfc353321ef7ed2716','0'),
	(43,'B','2003','E',200101,'Belanja Honorarium Guru Tidak Tetap','B2003E','B2003200101E','9d5ed678fe24321c5e2b00cfc3533294c50e6477','0'),
	(44,'B','2003','E',200107,'Belanja Honorarium THR Guru Tidak Tetap','B2003E','B2003200107E','9d5ed678fe24321c5e2b00cfc35332a88e7f4368','0'),
	(45,'B','2003','E',200108,'Belanja Honorarium THR Pegawai Tidak Tetap','B2003E','B2003200108E','9d5ed678fe24321c5e2b00cfc35332fb817ebf11','0'),
	(46,'B','2003','E',200113,'Belanja Honorarium Petugas Piket Hari Libur','B2003E','B2003200113E','9d5ed678fe24321c5e2b00cfc35332c6ec986380','0'),
	(47,'B','2003','F',200105,'Belanja Honor Kegiatan','B2003F','B2003200105F','9d5ed678fe24321c5e2b89430253158a524814f0','0'),
	(48,'B','2003','F',200402,'Belanja Sewa','B2003F','B2003200402F','9d5ed678fe24321c5e2b894302531527f7bd81b9','0'),
	(49,'B','2002','K',200302,'Belanja Bahan','B2002K','B2002200302Z5','9d5ed678feb9f9e5732e6a11b0383931ed6e344c','0'),
	(50,'B','2003','H',200106,'Belanja Penunjang Kegiatan Pendidikan','B2003H','B2003200106H','9d5ed678fe24321c5e2b50f86825a1a097d84f7b','0'),
	(51,'B','2003','G',200105,'Belanja Honor Kegiatan','B2003G','B2003200105I','9d5ed678fe24321c5e2b8d0734569a8a52413448','0'),
	(52,'B','2003','B',200501,'Belanja Perjaanan Dinas','B2003B','B2003200501J','9d5ed678fe24321c5e2b678fe57bcc7a2b3e3ce1','0'),
	(53,'B','2003','B',299999,'Belanja Lainnya','B2003B','B2003299999J','9d5ed678fe24321c5e2b678fe57bccff110bbe90','0'),
	(54,'B','2003','B',200403,'Belanja Langganan Daya dan Jasa','B2003B','B2003200403J','9d5ed678fe24321c5e2b678fe57bccb20a52a66a','0'),
	(55,'B','2003','B',200302,'Belanja Bahan','B2003B','B2003200302J','9d5ed678fe24321c5e2b678fe57bcc31ed67d7c4','0'),
	(56,'B','2004','A',200501,'Belanja Perjaanan Dinas','B2004A','B2004200501A','9d5ed678fe727d6f5d1b270e7a70fa7a2b307aeb','0'),
	(57,'B','2002','L',200105,'Belanja Honor Kegiatan','B2002L','B2002200105L','9d5ed678feb9f9e5732eec3b48a1ee8a524f0bb9','0'),
	(58,'B','2005','B',200302,'Belanja Bahan','B2005B','B2005200302D','9d5ed678fe8e9db2e9aa678fe57bcc31ed6f0f4b','0'),
	(59,'B','2005','B',200106,'Belanja Penunjang Kegiatan Pendidikan','B2005B','B2005200106D','9d5ed678fe8e9db2e9aa678fe57bcca097deb62f','0'),
	(60,'B','2006','A',200301,'Belanja Keperluan Perkantoran','B2006A','B2006200301A','9d5ed678fe86c712a91e270e7a70fa9e623a4bab','0'),
	(61,'B','2006','B',200301,'Belanja Keperluan Perkantoran','B2006B','B2006200301B','9d5ed678fe86c712a91e678fe57bcc9e623e36e7','0'),
	(62,'B','2006','C',200202,'Belanja Pemeliharaan Peralatan dan Mesin','B2006C','B2006200202C','9d5ed678fe86c712a91e8370cad1d4ed404f6c0c','0'),
	(63,'B','2006','D',200201,'Belanja Pemeliharaan Gedung dan Bangunan','B2006D','B2006200201D','9d5ed678fe86c712a91e75af30e62ba5ad94721d','0'),
	(64,'B','2006','E',200201,'Belanja Pemeliharaan Gedung dan Bangunan','B2006E','B2006200201E','9d5ed678fe86c712a91e00cfc35332a5ad917129','0'),
	(65,'B','2006','G',200301,'Belanja Keperluan Perkantoran','B2006G','B2006200301G','9d5ed678fe86c712a91e8d0734569a9e6232f863','0'),
	(66,'B','2006','H',200302,'Belanja Bahan','B2006H','B2006200302H','9d5ed678fe86c712a91e50f86825a131ed65db5a','0'),
	(67,'B','2006','I',200202,'Belanja Pemeliharaan Peralatan dan Mesin','B2006I','B2006200202J','9d5ed678fe86c712a91e6794b63bf9ed40411927','0'),
	(68,'B','2006','F',200301,'Belanja Keperluan Perkantoran','B2006F','B2006200301K','9d5ed678fe86c712a91e89430253159e623a9bd0','0'),
	(69,'B','2007','A',200401,'Belanja Jasa Profesi','B2007A','B2007200401A','9d5ed678feeb0973d246270e7a70fa42aa9a2a68','0'),
	(70,'B','2007','B',200106,'Belanja Penunjang Kegiatan Pendidikan','B2007B','B2007200106B','9d5ed678feeb0973d246678fe57bcca097dfc275','0'),
	(71,'B','2007','C',200106,'Belanja Penunjang Kegiatan Pendidikan','B2007C','B2007200106C','9d5ed678feeb0973d2468370cad1d4a097d61c0a','0'),
	(72,'B','2007','E',200302,'Belanja Bahan','B2007E','B2007200302E','9d5ed678feeb0973d24600cfc3533231ed62323c','0'),
	(73,'B','2007','D',200106,'Belanja Penunjang Kegiatan Pendidikan','B2007D','B2007200106H','9d5ed678feeb0973d24675af30e62ba097dbe30a','0'),
	(74,'B','2007','D',200105,'Belanja Honor Kegiatan','B2007D','B2007200105H','9d5ed678feeb0973d24675af30e62b8a5246caa1','0'),
	(75,'B','2004','B',200501,'Belanja Perjaanan Dinas','B2004B','B2004200501D','9d5ed678fe727d6f5d1b678fe57bcc7a2b3612b9','0'),
	(76,'B','2002','G',200105,'Belanja Honor Kegiatan','B2002G','B2002200105G','9d5ed678feb9f9e5732e8d0734569a8a524f80f7','0'),
	(77,'B','2002','H',200105,'Belanja Honor Kegiatan','B2002H','B2002200105H','9d5ed678feb9f9e5732e50f86825a18a524b356b','0'),
	(78,'B','2002','N',200106,'Belanja Penunjang Kegiatan Pendidikan','B2002N','B2002200106N','9d5ed678feb9f9e5732e07cb7f3c4aa097dadeb1','0'),
	(79,'B','2002','Q',200106,'Belanja Penunjang Kegiatan Pendidikan','B2002Q','B2002200106V','9d5ed678feb9f9e5732e4c9ca56850a097d3042e','0'),
	(80,'B','2001','B',200105,'Belanja Honor Kegiatan','B2001B','B2001200105G','9d5ed678fe63ff976f9c678fe57bcc8a5246a209','0'),
	(81,'B','2003','A',200106,'Belanja Penunjang Kegiatan Pendidikan','B2003A','B2003200106A','9d5ed678fe24321c5e2b270e7a70faa097d2ba3f','0'),
	(82,'B','2003','C',200106,'Belanja Penunjang Kegiatan Pendidikan','B2003C','B2003200106C','9d5ed678fe24321c5e2b8370cad1d4a097d5394c','0'),
	(83,'B','2003','F',200106,'Belanja Penunjang Kegiatan Pendidikan','B2003F','B2003200106F','9d5ed678fe24321c5e2b8943025315a097d58ad0','0'),
	(84,'B','2004','A',200106,'Belanja Penunjang Kegiatan Pendidikan','B2004A','B2004200106A','9d5ed678fe727d6f5d1b270e7a70faa097dddd8b','0'),
	(85,'B','2006','D',200202,'Belanja Pemeliharaan Peralatan dan Mesin','B2006D','B2006200202D','9d5ed678fe86c712a91e75af30e62bed40490611','0'),
	(86,'B','2006','E',200201,'Belanja Pemeliharaan Gedung dan Bangunan','B2006E','B2006200201E','9d5ed678fe86c712a91e00cfc35332a5ad9e10e3','0'),
	(87,'B','2006','H',200201,'Belanja Pemeliharaan Gedung dan Bangunan','B2006H','B2006200201H','9d5ed678fe86c712a91e50f86825a1a5ad9ed36e','0'),
	(88,'B','2007','A',200106,'Belanja Penunjang Kegiatan Pendidikan','B2007A','B2007200106A','9d5ed678feeb0973d246270e7a70faa097d898dc','0'),
	(89,'B','2003','B',200106,'Belanja Penunjang Kegiatan Pendidikan','B2003B','B2003200106K','9d5ed678fe24321c5e2b678fe57bcca097d2028d','0'),
	(90,'B','2002','K',200302,'Belanja Bahan','B2002K','B2002200302Z5','9d5ed678feb9f9e5732e6a11b0383931ed6b03a7','0'),
	(91,'B','2002','J',200105,'Belanja Honor Kegiatan','B2002J','B2002200105Z6','9d5ed678feb9f9e5732e70aca824198a52488f02','0'),
	(92,'B','2002','J',200302,'Belanja Bahan','B2002J','B2002200302Z6','9d5ed678feb9f9e5732e70aca8241931ed678d9e','0'),
	(93,'B','2002','E',200105,'Belanja Honor Kegiatan','B2002E','B2002200105Z7','9d5ed678feb9f9e5732e00cfc353328a524f55ca','0'),
	(94,'B','2002','E',200302,'Belanja Bahan','B2002E','B2002200302Z7','9d5ed678feb9f9e5732e00cfc3533231ed659671','0'),
	(95,'B','2002','K',200105,'Belanja Honor Kegiatan','B2002K','B2002200105Z5','9d5ed678feb9f9e5732e6a11b038398a524116dc','0'),
	(96,'B','2005','A',200105,'Belanja Honor Kegiatan','B2005A','B2005200105E1','9d5ed678fe8e9db2e9aa270e7a70fa8a524371db','0'),
	(97,'A','1002','A',100202,'Pendapatan Sewa GOR','A1002A','A1002100202A','7fc56270e788164f3e2d270e7a70faf8e7c5e90a','0'),
	(98,'B','2001','C',200105,'Belanja Honor Kegiatan','B2001C','B2001200105C','9d5ed678fe63ff976f9c8370cad1d48a524a9dd1','0'),
	(99,'B','2001','C',200302,'Belanja Bahan','B2001C','B2001200302C','9d5ed678fe63ff976f9c8370cad1d431ed6a4e23','0'),
	(100,'B','2001','C',200401,'Belanja Jasa Profesi','B2001C','B2001200401C','9d5ed678fe63ff976f9c8370cad1d442aa97f1a6','0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_detail2425`;

CREATE TABLE IF NOT EXISTS `simakom_detail2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `akun` float NOT NULL,
  `detail` float NOT NULL,
  `detail_id` varchar(20) NOT NULL,
  `uraian` text NOT NULL,
  `volume` varchar(15) NOT NULL,
  `satuan` varchar(50) NOT NULL,
  `unit` varchar(50) NOT NULL,
  `total` varchar(15) NOT NULL,
  `komponen_1` varchar(10) NOT NULL,
  `komponen_2` varchar(10) NOT NULL,
  `komponen_3` varchar(10) NOT NULL,
  `komponen_4` varchar(10) NOT NULL,
  `unit_1` varchar(100) NOT NULL,
  `unit_2` varchar(100) NOT NULL,
  `unit_3` varchar(100) NOT NULL,
  `unit_4` varchar(100) NOT NULL,
  `pembiayaan_id` varchar(50) NOT NULL,
  `pembiayaan_kegiatan` varchar(4) NOT NULL,
  `pembiayaan_komponen` varchar(5) NOT NULL,
  `pembiayaan_akun` varchar(6) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  `time` datetime NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=234 DEFAULT CHARSET=latin1;

INSERT INTO `simakom_detail2425` (`no`, `kategori`, `kegiatan`, `komponen`, `akun`, `detail`, `detail_id`, `uraian`, `volume`, `satuan`, `unit`, `total`, `komponen_1`, `komponen_2`, `komponen_3`, `komponen_4`, `unit_1`, `unit_2`, `unit_3`, `unit_4`, `pembiayaan_id`, `pembiayaan_kegiatan`, `pembiayaan_komponen`, `pembiayaan_akun`, `revisi`, `time`, `kode_id`, `id`) VALUES
	(1,'A','1000','A',100000,1,'A1000A10000000100','Saldo Tahun Lalu','1','750000','Tahun','750000','','','','','','','','','','','','','0','2024-06-09 09:48:25','A1000A','eab9436a4232973529735cd98f096a3b'),
	(2,'A','1001','A',100102,1,'A1001A10010200100','SOP','125','735000','Siswa','91875000','','','','','','','','','','','','','0','2024-06-09 09:48:25','A1001A','33828a7f1847771edb9d0cd98f0a2ef4'),
	(3,'A','1001','A',100102,2,'A1001A10010200200','Uang Pangkal','400','450000','Siswa','180000000','','','','','','','','','','','','','0','2024-06-09 09:48:25','A1001A','33893a680421c580cd229cd98f0e45ee'),
	(4,'A','1001','A',100102,3,'A1001A10010200300','Akomodasi Siswa','150','690000','Siswa','103500000','','','','','','','','','','','','','0','2024-06-09 09:48:25','A1001A','33888fc605fad257732ffcd98f07d066'),
	(5,'A','1003','A',100302,1,'A1003A10030200100','Uang Kegiatan','400','775000','Siswa','310000000','','','','','','','','','','','','','0','2024-06-09 09:48:25','A1003A','2cd8aea804260c3f4e755cd98f0fad6f'),
	(6,'B','2000','A',200106,1,'B2000A20010600100','Beasiswa Peringkat 1 Paralel','5','450000','st','2250000','5','1','','','siswa','tahun','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:25','B2000A','09787b4a3b71c5801ae23a338d7ea20a'),
	(7,'B','2000','A',200106,2,'B2000A20010600200','Beasiswa Peringkat II Paralel','5','337500','st','1687500','5','1','','','siswa','tahun','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:25','B2000A','097fa69a3b74db07b9e1aa338d784eb1'),
	(8,'B','2000','A',200106,3,'B2000A20010600300','Beasiswa Peringkat III Paralel','5','225000','st','1125000','5','1','','','siswa','tahun','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:25','B2000A','097a6f2a3b73d38888319a338d7d2490'),
	(9,'B','2007','C',200106,2,'B2007C20010600200','Honor Panitia Pelaksana','1','4500000','Paket','4500000','','','','','','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:25','B2007C','09753b4a423fd148fd148a338d717765'),
	(10,'B','2003','B',200106,9,'B2003B20010600900','Belanja Keperluan Kantor','1','750000','paket','750000','','','','','','','','','A1000A10000000100','1000','A','100000','0','2024-06-09 09:48:25','B2003B','097a7f7a42329735297352eaba2713ef'),
	(11,'A','1001','A',100102,4,'A1001A10010200400','Infak Pembangunan','125','700000','Siswa','87500000','','','','','','','','','','','','','0','2024-06-09 09:48:25','A1001A','3387467f184a82ea54cffcd98f00489a'),
	(12,'B','2000','B',200106,1,'B2000B20010600100','Persiapan dan gladi bersih','1','300000','paket','300000','1','','','','paket','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','097c79da42304ce904ce9a338d78fc4c'),
	(13,'B','2000','B',200106,7,'B2000B20010600700','Samir','256','17500','orang','4480000','2256','','','','orang','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','0971b6b8499981d87093da338d75c7d5'),
	(14,'B','2000','B',200106,8,'B2000B20010600800','Sleyer peringkat 10 besar','10','35000','orang','350000','10','','','','orang','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','0977e2c944697dcd00a19a338d79f9ce'),
	(15,'B','2000','B',200106,9,'B2000B20010600900','Baner spot','1','311500','unit','311500','1','','','','unit','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','0977e2fa42394b2d94b2da338d728fd0'),
	(16,'B','2000','B',200106,10,'B2000B20010601000','Baner','1','360000','unit','360000','1','','','','unit','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','097a460a42363e1063e10a338d79ac05'),
	(17,'B','2000','B',200106,11,'B2000B20010601100','Penataan dan kebersihan','6','50000','orang','300000','1','6','','','kali','orang','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','09755649091fd46704ce9a338d71732c'),
	(18,'B','2000','B',200106,12,'B2000B20010601200','Foto wisuda','256','10000','orang','2560000','256','','','','orang','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','097bc2084992741f09acfa338d7e1eee'),
	(19,'B','2000','B',200106,13,'B2000B20010601300','Dokumantasi','1','300000','paket','300000','1','','','','paket','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','0970666a42304ce904ce9a338d77d06a'),
	(20,'B','2000','B',200302,15,'B2000B20030201500','Snak dan minuman teh pucuk','625','13000','paket','8125000','625','','','','paket','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','1edf24d50907c2619d33ca338d7b6aea'),
	(21,'B','2000','B',200302,16,'B2000B20030201600','Tas snak dan sablon','625','3000','buah','1875000','625','','','','buah','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','1edf6dc50908bdc101141a338d7842f3'),
	(22,'B','2000','B',200302,18,'B2000B20030201800','Snak latihan','81','5000','orang','405000','81','','','','orang','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','1ed682cc5177f7fe88844a338d721add'),
	(23,'B','2000','B',200302,19,'B2000B20030201900','Konsumsi undangan khusus','1','250000','paket','250000','1','','','','paket','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','1edffd2a42355e0355e03a338d7a27ef'),
	(24,'B','2000','B',200302,20,'B2000B20030202000','Buket','1','50000','unit','50000','1','','','','unit','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','1ed1fcea423fd467fd467a338d72ba10'),
	(25,'B','2000','B',200302,21,'B2000B20030202100','Konsumsi rapat panitia','3','240000','kali','720000','3','','','','kali','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','1ed13dfbc87a7f5f34c60a338d72f1ee'),
	(26,'B','2000','B',200402,22,'B2000B20040202200','Sewa tarub','396','7500','meter','2970000','396','','','','meter','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','7f73bcd1f2313c824f6f6a338d7bff82'),
	(27,'B','2000','B',200402,23,'B2000B20040202300','Sewa klambu','8','10000','meter','80000','8','','','','meter','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','7f740680f892741fd8be8a338d7e46d0'),
	(28,'B','2000','B',200402,24,'B2000B20040202400','Sewa kursi','400','2000','unit','800000','400','','','','unit','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','7f75f438042c1a41a0e8ea338d7bf97f'),
	(29,'B','2000','B',200402,25,'B2000B20040202500','Sewa sound system','1','1000000','unit','1000000','1','','','','unit','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','7f7a0b4a423c545fc545fa338d72c4a8'),
	(30,'B','2000','B',200402,26,'B2000B20040202600','Panggung dan perlengkapanya','1','1000000','paket','1000000','1','','','','paket','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','7f7973ba423c545fc545fa338d76d4a6'),
	(31,'B','2000','B',200402,27,'B2000B20040202700','Dekor panggung','1','700000','paket','700000','1','','','','paket','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','7f74e7da423a82eaa82eaa338d765cfe'),
	(32,'B','2000','B',200402,28,'B2000B20040202800','Sewa kostum tari','3','100000','orang','300000','3','','','','orang','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','7f76b12bc872eaba04ce9a338d7a3458'),
	(33,'B','2000','B',200501,30,'B2000B20050103000','Transpot komite','10','50000','orang','500000','1','10','','','kali','orang','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2000B','a2b75a99446fd467732a2a338d7a71d8'),
	(34,'B','2001','B',200105,1,'B2001B20010500100','Insentif TIM PKG dan SKP','1','1550000','Tahun','1550000','1','','','','Tahun','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:25','B2001B','a52eaa1a4233d0513d051a338d7caf49'),
	(35,'B','2002','J',200302,3,'B2002J20030200300','Konsumsi Dewan Penggalang','180','10000','OK','1800000','60','3','','','Siswa','Keg','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:25','B2002J','1edab2b117b2741fc2fe4a338d701088'),
	(36,'B','2003','F',200105,1,'B2003F20010500100','insentif Panitia Pelaksana Rapat Pleno','1','1800000','kegiatan','1800000','1','','','','kegiatan','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2003F','a52866aa423c2fe4c2fe4a338d7c2055'),
	(37,'B','2002','A',200302,1,'B2002A20030200100','Papan Pengumuman','2','276000','Paket','552000','','','','','','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2002A','1edbd77e7282782e892eda338d7914b6'),
	(38,'B','2002','A',200401,1,'B2002A20040100100','Service Program/Software Komputer/Laptop','40','100000','Unit','4000000','40','','','','Unit','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2002A','2aa385059202eaba8c482a338d7bbf14'),
	(39,'B','2002','A',200401,2,'B2002A20040100200','Service Hardware Komputer/Laptop','40','50000','Unit','2000000','40','','','','Unit','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:25','B2002A','2aa9f445920fd46743866a338d7962e6'),
	(40,'B','2002','C',200106,3,'B2002C20010600300','Insentif pelatih','5','150000','ok','750000','5','1','','','orang','kegiatan','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:25','B2002C','097bd86a3b7dd62b29735a338d756d9b'),
	(41,'B','2002','C',200106,4,'B2002C20010600400','Akomodasi peserta tahap seleksi pra POPDA','25','41000','pk','1025000','25','1','','','peserta','kegiatan','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:25','B2002C','097860496a08b156e9684a338d7d2716'),
	(42,'B','2002','C',200106,5,'B2002C20010600500','Akomodasi training champ pra POPDA','15','73000','pk','1095000','15','1','','','peserta','kegiatan','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:25','B2002C','097436531c76089a8c64ba338d7e6477'),
	(43,'B','2002','C',200106,6,'B2002C20010600600','Akomodasi pelaksanaan lomba POPDA kabupaten','20','80000','pk','1600000','20','1','','','peserta','kegiatan','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:25','B2002C','0970f141370d8be8d3d98a338d7f4368'),
	(44,'B','2002','D',200106,1,'B2002D20010600100','Reward Juara POPDA Kabupaten 2024','22','200000','ok','4400000','22','1','','','orang','kegiatan','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002D','097183b767d616036dd51a338d7ebf11'),
	(45,'B','2002','D',200106,2,'B2002D20010600200','Reward Juara KSM Kabupaten 2023','3','350000','ck','1050000','3','1','','','cabang','kegiatan','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002D','0978f3cbc8700a19bb2c3a338d7fb9ce'),
	(46,'B','2002','D',200106,3,'B2002D20010600300','Reward Juara OSN Kabupaten','3','350000','ck','1050000','3','1','','','cabang','kegiatan','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002D','0978a3abc8700a19bb2c3a338d795b30'),
	(47,'B','2002','D',200106,4,'B2002D20010600400','Reward Juara O2SN Kabupaten','2','350000','ck','700000','2','1','','','cabang','kegiatan','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2002D','09775e6e72800a19a82eaa338d764b2c'),
	(48,'B','2002','D',200106,5,'B2002D20010600500','Reward Pelatih Lomba','13','200000','ct','2600000','13','1','','','cabang','tahun','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2002D','097e823ce41616031707fa338d792daa'),
	(49,'B','2002','F',200106,7,'B2002F20010600700','Akomodasi kegiatan lomba akademik online','2','900000','kegiatan','1800000','2','','','','kegiatan','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002F','097eb4be7288c964c2fe4a338d7db2f4'),
	(50,'B','2002','G',200105,1,'B2002G20010500100','Insentif TIM Pengelola IT','36','150000','OB','5400000','3','12','','','Orang','Bulan','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002G','a52f25ca14edd62b47956a338d7814f0'),
	(51,'B','2002','G',200105,2,'B2002G20010500200','Insentif penulis berita/artikel/essay','60','30000','OB','1800000','12','5','','','Bulan','Orang','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2002G','a52c064b03013150c2fe4a338d7d81b9'),
	(52,'B','2002','H',200105,1,'B2002H20010500100','Insentif Pembuatan Soal Seleksi','4','50000','pk','200000','4','1','','','paket','kegiatan','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2002H','a525995ff67fd46761603a338d7e3ce1'),
	(53,'B','2002','H',200105,2,'B2002H20010500200','Insentif Pengawas Seleksi','12','50000','ok','600000','12','1','','','orang','kegiatan','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002H','a524a3bad4dfd467a425fa338d7bbe90'),
	(54,'B','2002','H',200105,3,'B2002H20010500300','Insentif Proktor/Teknisi','2','50000','ok','100000','2','1','','','orang','kegiatan','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2002H','a52fdebe728fd4672eabaa338d72a66a'),
	(55,'B','2002','J',200302,5,'B2002J20030200500','Pengadaan tanda Nomor Gudep kelas 7','256','2000','Siswa','512000','','','','','','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002J','1ed71ce8499c1a41c127ba338d707758'),
	(56,'B','2002','H',200302,4,'B2002H20030200400','Konsumsi Rapat','95','18000','ok','1710000','19','5','','','orang','kali','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002H','1ed77c2b4ba6f686501a6a338d74bc8f'),
	(57,'B','2002','H',200302,5,'B2002H20030200500','Konsumsi Seleksi dan Pemberkasan','76','25000','oh','1900000','19','4','','','0rang','hari','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002H','1edd04d7939538109e483a338d75072e'),
	(58,'B','2002','H',200302,6,'B2002H20030200600','Konsumsi Daftar Ulang','57','25000','oh','1425000','19','3','','','orang','hari','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002H','1ed488632a153810518eba338d7c88a4'),
	(59,'B','2002','H',200302,7,'B2002H20030200700','Konsumsi Pengawas Seleksi CBT','12','18000','ok','216000','12','1','','','orang','kegiatan','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002H','1ed8e0dad4d6f6862e87aa338d7a8d48'),
	(60,'B','2002','H',200302,8,'B2002H20030200800','Snack Piket Sekretariat','30','9000','oh','270000','5','6','','','orang','hari','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002H','1ed92ca73cbdc7efde10ea338d7ed5fc'),
	(61,'B','2002','H',200302,9,'B2002H20030200900','Snack Daftar Ulang dan Seleksi','76','7500','oh','570000','19','4','','','orang','hari','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002H','1ed836c793913c82d9d70a338d7408b7'),
	(62,'B','2002','L',200105,2,'B2002L20010500200','Insentif Juri/Wasit','18','50000','Ok','900000','9','2','','','Orang','Keg','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002L','a52c2fb922ffd4678c964a338d70ca97'),
	(63,'B','2002','L',200302,1,'B2002L20030200100','Belanja hadiah classmeeting','2','2275000','kegiatan','4550000','2','','','','kegiatan','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002L','1edb328e72805e58b39aaa338d742812'),
	(64,'B','2002','L',200302,2,'B2002L20030200200','Konsumsi juri','24','25000','ko','600000','2','12','','','kegiatan ','orang','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2002L','1ed68631de753810a425fa338d75150e'),
	(65,'B','2002','L',200302,3,'B2002L20030200300','Konsumsi panitia','18','25000','ko','450000','2','9','','','kegiatan','orang','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2002L','1ed0506922f538101c580a338d7be30a'),
	(66,'B','2002','L',200302,4,'B2002L20030200400','Snack juri dan panitia','42','5000','ko','210000','2','21','','','kegiatan','orang','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2002L','1ed38930c6e7f7fe4fe9ea338d76caa1'),
	(67,'B','2002','L',200302,5,'B2002L20030200500','Snack petugas OSIS','180','5000','kah','900000','2','15','6','','kegiatan','anak','hari','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2002L','1ed4537117b7f7fe8c964a338d7b6309'),
	(68,'B','2002','N',200106,1,'B2002N20010600100','Insentif Pendamping dan Pemateri','252','10000','oh','2520000','42','6','','','orang','hari','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002N','0977ab16b062741ff2da0a338d7f0bb9'),
	(69,'B','2002','N',200401,1,'B2002N20040100100','Honor Pemateri Eksternal','4','125000','op','500000','2','2','','','orang','pertemuan','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2002N','2aa478bff67c2cef732a2a338d7adeb1'),
	(70,'B','2002','K',200105,3,'B2002K20010500300','Insentif Pemateri dari luar','2','200000','OK','400000','','','','','','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002K','a527600e72861603d2829a338d7eaf3f'),
	(71,'B','2001','B',200105,2,'B2001B20010500200','Insentif TIM Supervisi Guru','2','1300000','Semester','2600000','2','','','','Semester','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2001B','a52fbebe7286e4901707fa338d7fec80'),
	(72,'B','2002','K',200302,7,'B2002K20030200700','Konsumsi Peserta Dianpinru','500','10000','OK','5000000','100','5','','','Siswa','Keg','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002K','1edbb6063112741fadbbda338d7dc9d7'),
	(73,'B','2002','J',200105,2,'B2002J20010500200','Insentif Jaga Malam','2','50000','Orang','100000','','','','','','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002J','a528e75e728fd4672eabaa338d75c729'),
	(74,'B','2002','J',200302,1,'B2002J20030200100','Belanja Perlengkapan Api Unggun','1','177000','Keg','177000','','','','','','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002J','1edbe92a423dc0cddc0cda338d788a50'),
	(75,'B','2001','A',200105,2,'B2001A20010500200','Honor Narasumber dari Puskesmas','4','105000','pertemuan','420000','4','','','','Pertemuan','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2001A','a524552ff67713ca428eea338d733953'),
	(76,'B','2002','O',200105,2,'B2002O20010500200','Insentif Pelatih','4','50000','OK','200000','2','2 ','','','Orang','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002O','a52ec5aff67fd46761603a338d7cc79c'),
	(77,'B','2002','R',200302,2,'B2002R20030200200','Snack Latihan','180','5000','ok','900000','45','4','','','orang','kali','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002R','1ed4726117b7f7fe8c964a338d788f02'),
	(78,'B','2002','T',200106,2,'B2002T20010600200','Insentif Pelatih','16','50000','ok','800000','4','4','','','orang','kali','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002T','097ec5ad97bfd467a0e8ea338d7116dc'),
	(79,'B','2002','T',200302,1,'B2002T20030200100','Snack Latihan','56','5000','oh','280000','14','4','','','orang','hari','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002T','1ed472614087f7fe4fc96a338d7371db'),
	(80,'B','2002','U',200106,2,'B2002U20010600200','insentif Pendamping','1','75000','ok','75000','1','1','','','orang','kegiatan','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002U','0972750a423b1bb4b1bb4a338d7dba75'),
	(81,'B','2002','U',200302,1,'B2002U20030200100','Snack Latihan','28','5000','ok','140000','7','4','','','orang','kali','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002U','1ed472675ff7f7fecc0c4a338d7ca622'),
	(82,'B','2002','Q',200106,1,'B2002Q20010600100','Insentif Pemateri Eksternal','1','125000','ok','125000','1','1','','','orang','kegiatan','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002Q','0978a18a423c2cefc2cefa338d78bae7'),
	(83,'B','2002','Q',200106,2,'B2002Q20010600200','Insentif Pemateri Internal','4','50000','ok','200000','4','1','','','orang','kegiatan','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002Q','09778cdff67fd46761603a338d796a0b'),
	(84,'B','2002','Q',200106,3,'B2002Q20010600300','Insentif Pelaksana kegiatan','2','100000','ok','200000','2','1','','','orang','kegiatan','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002Q','0974ca9e7282eaba61603a338d7864c2'),
	(85,'B','2002','Q',200302,2,'B2002Q20030200200','Konsumsi Peserta LDK','50','15000','oh','750000','25','2','','','orang','hari','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002Q','1edaf027c76886c729735a338d77e160'),
	(86,'B','2002','P',200106,2,'B2002P20010600200','insentif Pendamping','4','75000','oh','300000','2','2','','','orang','hari','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002P','0972750ff67b1bb404ce9a338d7c81c2'),
	(87,'B','2002','P',200302,1,'B2002P20030200100','Perlengkapan','1','1000000','pk','1000000','1','1','','','paket','kegiatan','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2002P','1ed59bba423c545fc545fa338d7281d5'),
	(88,'B','2002','J',200302,6,'B2002J20030200600','Belanja hadiah untuk peserta','1','400000','Paket','400000','','','','','','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002J','1ed66c2a423d2829d2829a338d745d07'),
	(89,'B','2002','O',200302,2,'B2002O20030200200','Konsumsi Rapat','20','20000','ok','400000','10','2','','','orang','kali','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002O','1ed77c21370cdf31d2829a338d77f1a6'),
	(90,'B','2002','O',200302,4,'B2002O20030200400','Konsumsi Panitia Pelaksana LDK dan Pilkasis','30','25000','ok','750000','10','3','','','orang','kali','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002O','1edd61373cb5381029735a338d7f7d63'),
	(91,'B','2002','O',200302,5,'B2002O20030200500','Snack Kegiatan Tahapan LDK dan Pilkasis','126','5000','ok','630000','42','3','','','orang','kali','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002O','1ed8786059b7f7fe74c19a338d77d9a2'),
	(92,'B','2003','A',200106,1,'B2003A20010600100','Insentif Tim TPM Penyusunan EDM-RKAM','200','50000','OK','10000000','20','10','','','Orang','Keg','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003A','0975c2c4a68fd467aaf52a338d7b7056'),
	(93,'B','2003','A',200302,1,'B2003A20030200100','Konsumsi Rapat','200','25000','OK','5000000','20','10','','','Orang','Keg','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003A','1ed77c24a6853810adbbda338d76e4d9'),
	(94,'B','2003','C',200106,1,'B2003C20010600100','Iuran Kas KKM Kecamatan','1590','2500','Siswa','3975000','795','2','','','Siswa','Semester','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2003C','0971fed41cca9b36507fba338d77b409'),
	(95,'B','2003','C',200106,2,'B2003C20010600200','Iuran Kas KKM Kabupaten','1590','2000','Siswa','3180000','795','2','','','Siswa','Semester','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003C','097e91941ccc1a417aa8aa338d7164cc'),
	(96,'B','2003','C',299999,1,'B2003C29999900100','Iuran KKM MTs Kecamatan','1590','2500','Siswa','3975000','795','2','','','Siswa','Semester','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003C','f11db3141cca9b36507fba338d756c66'),
	(97,'B','2003','C',299999,2,'B2003C29999900200','Iuran KKM MTs kabupaten','1590','2000','Siswa','3180000','795','2','','','Siswa','Semester','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003C','f11e2b841ccc1a417aa8aa338d70cf06'),
	(98,'B','2003','C',299999,3,'B2003C29999900300','Iuran Aksioma','1590','2500','Siswa','3975000','795','2','','','Siswa','Semester','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003C','f11b7b941cca9b36507fba338d7e7c1d'),
	(99,'B','2003','D',200302,1,'B2003D20030200100','Konsumsi Kegiatan Bimtek Tenaga Administrasi','10','30000','OK','300000','10','1','','','Orang','Keg','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2003D','1ed6d3f94461315004ce9a338d7605b3'),
	(100,'B','2003','D',200501,1,'B2003D20050100100','Perjalanan Dinas Pengiriman Kegiatan Bimtek','16','50000','OK','800000','8','2','','','Pegawai','Keg','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2003D','a2b95b3d97bfd467a0e8ea338d72b860'),
	(101,'B','2003','E',200101,1,'B2003E20010100100','Belanja Honorarium Guru Tidak Tetap','17','800000','OB','13600000','','','','','','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2003E','4c59e36fdf2a0e8e1c6b9a338d766e78'),
	(102,'B','2003','E',200101,2,'B2003E20010100200','Belanja Honorarium Guru Tidak Tetap','12','4500000','Bulan','54000000','12','','','','Bulan','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003E','4c59e36ad4dfd1486c65ba338d7eb37b'),
	(103,'B','2003','E',200102,1,'B2003E20010200100','Belanja Honorarium Pegawai Tidak Tetap','12','3287000','Bulan','39444000','12','','','','Bulan','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2003E','ef7ed0bad4d2650ef3702a338d717bad'),
	(104,'B','2003','E',200102,2,'B2003E20010200200','Belanja Honorarium Pegawai Tidak Tetap','24','500000','OB','12000000','12','2','','','Bulan','Orang','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2003E','ef7ed0b1de7732a251f7ba338d7abe2f'),
	(105,'B','2003','E',200107,1,'B2003E20010700100','Belanja Honorarium THR Guru Tidak Tetap','2','800000','OB','1600000','1','2','','','Bulan','Orang','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2003E','88edc59e728a0e8ed3d98a338d766f42'),
	(106,'B','2003','E',200107,2,'B2003E20010700200','Belanja Honorarium THR Guru Tidak Tetap','6','800000','OB','4800000','1','6','','','Bulan','Orang','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003E','88edc599091a0e8ef6766a338d7d60d2'),
	(107,'B','2003','E',200108,1,'B2003E20010800100','Belanja Honorarium THR Pegawai Tidak Tetap','3','500000','OB','1500000','1','3','','','Bulan','Orang','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2003E','b81e571bc87732a2f0216a338d76c052'),
	(108,'B','2003','E',200108,2,'B2003E20010800200','Belanja Honorarium THR Pegawai Tidak Tetap','8','300000','OB','2400000','1','8','','','Bulan','Orang','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2003E','b81e5710f8904ce92c3daa338d778013'),
	(109,'B','2003','E',200108,3,'B2003E20010800300','Belanja Honorarium THR Pegawai Tidak Tetap','3','800000','OB','2400000','1','3','','','Bulan','Orang','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2003E','b81e571bc87a0e8e2c3daa338d7c8e58'),
	(110,'B','2003','E',200113,1,'B2003E20011300100','Belanja Honorarium Petugas Piket Hari Libur','1','6500000','Tahun','6500000','1','','','','Tahun','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003E','6eca0ada423744d7744d7a338d7059ff'),
	(111,'B','2003','F',200106,2,'B2003F20010600200','Transport Rapat Rutin','120','100000','OK','12000000','10','12','','','Orang','Keg','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2003F','097cce7fb5c2eaba51f7ba338d703747'),
	(112,'B','2003','F',200402,1,'B2003F20040200100','Sewa Tarub [Rapat Pleno]','1','2880000','Unit','2880000','','','','','','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003F','7f75386a4230ebba0ebbaa338d77dd50'),
	(113,'B','2003','F',200402,2,'B2003F20040200200','Sewa Panggung [Rapat Pleno]','1','600000','Unit','600000','','','','','','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003F','7f7e3b3a423a425fa425fa338d765b6f'),
	(114,'B','2003','F',200402,3,'B2003F20040200300','Sewa Sound Sistem  [Rapat Pleno]','1','1000000','Unit','1000000','','','','','','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003F','7f7a368a423c545fc545fa338d7f9bb7'),
	(115,'B','2003','H',200106,1,'B2003H20010600100','home visit reguler bagi kelas V11','256','20000','wali murid','5120000','1','256','','','kali','wali murid','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2003H','097066d8499cdf31336dda338d717a72'),
	(116,'B','2003','H',200106,2,'B2003H20010600200','Home Visit Kasus','150','20000','orang','3000000','75','2','1','','kali','kali ','kegiatan','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003H','097bb86605fcdf317cfbaa338d79e6d4'),
	(117,'B','2003','G',200105,2,'B2003G20010500200','Dana sosial anak sakit','36','200000','bulan','7200000','3','12','','','kali ','bulan','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003G','a52672ea14e61603adaaaa338d7f7f65'),
	(118,'B','2003','B',200106,4,'B2003B20010600400','Akomodasi Tamu Dinas','12','750000','Keg','9000000','','','','','','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2003B','0970c6bad4d297356ac22a338d7a2e11'),
	(119,'B','2003','B',200302,1,'B2003B20030200100','Belanja Keperluan Minum (Gula/Teh/Kopi/Galon)','12','1750000','Bulan','21000000','','','','','','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2003B','1ed8557ad4df65a0f9af8a338d705e48'),
	(120,'B','2003','B',200403,2,'B2003B20040300200','Langganan Telpon','12','60000','Bulan','720000','','','','','','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2003B','20a09d9ad4d6dd7e34c6012cd7783241'),
	(121,'B','2003','B',200403,3,'B2003B20040300300','Langganan Internet','12','500000','Bulan','6000000','','','','','','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2003B','20ad1bdad4d732a2318dea338d7a5b06'),
	(122,'B','2003','B',200501,1,'B2003B20050100100','Belanja Perjalanan Pengiriman Laporan','72','50000','OB','3600000','2','3','12','','Orang','Keg','Bulan','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2003B','a2b8429b90efd4676315412cd77d04fe'),
	(123,'B','2003','B',200501,2,'B2003B20050100200','Perjaanan Rapat Dinas dalam Kota','24','100000','OK','2400000','2','1','12','','Orang','Kegiatan','Bulan','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2003B','a2b207b1de72eaba2c3da12cd77761b0'),
	(124,'B','2003','B',299999,1,'B2003B29999900100','Iuran Kegiatan FKKB','12','200000','Bulan','2400000','','','','','','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003B','f110fd4ad4d616032c3daa338d7335e2'),
	(125,'B','2004','A',200106,1,'B2004A20010600100','Belanja Akomodasi Rapat KKM Kedu','12','500000','Keg','6000000','','','','','','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2004A','097eacbad4d732a2318dea338d787277'),
	(126,'B','2004','A',200501,1,'B2004A20050100100','Perjalanan Dinas Dalam Kota','48','100000','Keg','4800000','4','12','','','Keg','Bulan','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2004A','a2b3459e92e2eabaf676612cd775bbac'),
	(127,'B','2004','A',200501,2,'B2004A20050100200','Perjalanan Dinas Luar Kota','12','500000','Keg','6000000','','','','','','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2004A','a2b1acbad4d732a2318de12cd77a9b2b'),
	(128,'B','2005','B',200106,1,'B2005B20010600100','Lomba tumpeng tingkat kecamatan','1','700000','unit','700000','1','','','','unit','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2005B','0979adba423a82eaa82eaa338d7ba7df'),
	(129,'B','2005','B',200106,2,'B2005B20010600200','Lomba tingkat kecamatan','50','75000','orang','3750000','50','','','','orang','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2005B','0971c817c76b1bb4de638a338d7cc1d6'),
	(130,'B','2005','B',200106,3,'B2005B20010600300','Hadiah lomba di MTs','30','20000','hadiah','600000','30','','','','hadiah','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2005B','09702d973cbcdf31a425fa338d7883b7'),
	(131,'B','2005','B',200106,4,'B2005B20010600400','Iuran ke Kecamatan','1','2000000','iuran','2000000','1','','','','iuran','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2005B','097c7e6a4234386643866a338d7944de'),
	(132,'B','2005','B',200302,2,'B2005B20030200200','Transpot upacara','67','50000','orang','3350000','67','','','','orang','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2005B','1ed7a1bb90bfd467e6aa0a338d7af605'),
	(133,'B','2005','B',200302,1,'B2005B20030200100','Tasyakuran/konsumsi','67','25000','orang','1675000','67','','','','orang','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2005B','1ed22b9b90b538103e15aa338d7e3a95'),
	(134,'B','2006','A',200301,2,'B2006A20030100200','Lemari buku referensi','1','4000000','unit','4000000','1','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006A','e6239b3a4238c4828c48212cd7719a6a'),
	(135,'B','2006','A',200301,1,'B2006A20030100100','Meja kursi siswa','32','600000','stel','19200000','32','','','','stel','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006A','e62d2fb4d3fa425fece6712cd77df680'),
	(136,'B','2006','A',200301,3,'B2006A20030100300','Meja sirkulasi perpustakaan','1','2320000','unit','2320000','1','','','','','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006A','e62d62da42309ad009ad012cd772763d'),
	(137,'B','2006','A',200301,4,'B2006A20030100400','Meja baca perpustakaan','5','1000000','set','5000000','','','','','','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006A','e62cac5a3b7c545fadbbd12cd77970ab'),
	(138,'B','2006','A',200301,5,'B2006A20030100500','Meja dan kursi guru','10','800000','stel','8000000','8','','','','stel','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006A','e625a899446a0e8e9291312cd773a1e6'),
	(139,'B','2006','A',200301,11,'B2006A20030101100','Komputer','1','10000000','unit','10000000','','','','','','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006A','e622b40a423aaf52aaf5212cd77f655f'),
	(140,'B','2006','A',200301,12,'B2006A20030101200','Mebelair meja dan kursi Kepala laboratorium PAI','1','2340000','Unit','2340000','','','','','','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006A','e62a721a423d594dd594d12cd774ee9e'),
	(141,'B','2006','A',200301,13,'B2006A20030101300','Pembelian papan tulis white board lab PAI','6','700000','Unit','4200000','6','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006A','e626dfc9091a82ea1276a12cd77d647f'),
	(142,'B','2006','B',200301,1,'B2006B20030100100','Lemari alat praktikum','2','4000000','unit','8000000','2','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006B','e62a70de7288c4829291312cd77df790'),
	(143,'B','2006','B',200301,2,'B2006B20030100200','Travo 5 ampere','5','600000','unit','3000000','5','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006B','e62ae26a3b7a425f7cfba12cd7786564'),
	(144,'B','2006','B',200301,3,'B2006B20030100300','Pengadaan alat elektronik','4','250000','set','1000000','4','','','','set','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006B','e626c13ff6755e03c545f12cd77b66e0'),
	(145,'B','2006','B',200301,4,'B2006B20030100400','Torso peredaran darah manusia','1','1000000','unit','1000000','1','','','','unit ','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2006B','e62b872a423c545fc545fa338d7e0bc5'),
	(146,'B','2006','B',200301,5,'B2006B20030100500','Torso sistem reproduksi manusia','2','1000000','unit','2000000','2','','','','unit','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2006B','e62d362e728c545f43866a338d7dbea8'),
	(147,'B','2006','B',200301,6,'B2006B20030100600','Torso sistem gerak manusia','1','1000000','unit','1000000','1','','','','unit','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2006B','e62c9c7a423c545fc545fa338d7520ff'),
	(148,'B','2006','B',200301,7,'B2006B20030100700','Torso sistem pencernaan manusia','1','1000000','unit','1000000','1','','','','unit','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2006B','e621f12a423c545fc545fa338d7ed798'),
	(149,'B','2006','B',200301,8,'B2006B20030100800','Torso sistem ekskresi manusia','1','1000000','unit','1000000','1','','','','unit','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2006B','e629bf8a423c545fc545fa338d720752'),
	(150,'B','2006','B',200301,9,'B2006B20030100900','Torso sistem syaraf manusia','1','1000000','unit','1000000','1','','','','unit','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2006B','e62f7e3a423c545fc545fa338d7e1433'),
	(151,'B','2006','C',200202,1,'B2006C20020200100','kabel listrik','2','500000','rol','1000000','2','','','','rol','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006C','d40c0d1e728732a2c545f12cd7754b5e'),
	(152,'B','2006','C',200202,2,'B2006C20020200200','Stop kontak','20','65000','unit','1300000','5','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006C','d404ef713701d0f86e49012cd7723bb8'),
	(153,'B','2006','C',200202,3,'B2006C20020200300','Lampu','48','40000','unit','1920000','24','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006C','d40bb6fe92e048a2db35612cd7735071'),
	(154,'B','2006','C',200202,5,'B2006C20020200500','klem kabel','10','10000','bungkus','100000','10','','','','bungkus','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006C','d40620694462741f2eaba12cd77faf4c'),
	(155,'B','2006','C',200202,6,'B2006C20020200600','steker','10','30000','unit','300000','10','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006C','d402b9794461315004ce912cd772c7cd'),
	(156,'B','2006','C',200202,7,'B2006C20020200700','Kipas angin kelas','6','675000','unit','4050000','6','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006C','d40f05e9091ca7f19677c12cd77f5e10'),
	(157,'B','2001','A',200105,1,'B2001A20010500100','Honor Narasumber Kegiatan dari eksternal','24','55000','pertemuan','1320000','24','','','','pertemuan','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2001A','a52e38e1de7e065d4ea4da338d742d47'),
	(158,'B','2006','D',200201,1,'B2006D20020100100','pengecatan lapangan multifungsi','1','10000000','unit','10000000','1','','','','unit','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2006D','5ad7f30a423aaf52aaf52a338d7f11a7'),
	(159,'B','2002','K',200302,2,'B2002K20030200200','Konsumsi Pembina','48','25000','OK','1200000','8','6','','','Orang','Keg','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002K','1ed8aede92e5381086626a338d7a2eda'),
	(160,'B','2002','K',200302,3,'B2002K20030200300','Konsumsi Dewan Penggalang','165','15000','OK','2475000','55','3','','','Siswa','Keg','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002K','1edab2b6527886c770bb5a338d73444f'),
	(161,'B','2002','K',200302,4,'B2002K20030200400','Air Mineral','10','35000','Dus','350000','','','','','','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002K','1ed340d944697dcd00a19a338d7e6949'),
	(162,'B','2002','K',200302,5,'B2002K20030200500','Belanja hadiah untuk peserta','1','400000','Paket','400000','','','','','','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002K','1ed66c2a423d2829d2829a338d7786bd'),
	(163,'B','2006','D',200202,2,'B2006D20020200200','Bola voli','2','900000','unit','1800000','2','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006D','d403836e7288c964c2fe412cd770e0a0'),
	(164,'B','2006','D',200202,3,'B2006D20020200300','Bola sepak','2','400000','unit','800000','2','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006D','d400331e728d2829a0e8e12cd77bd1f7'),
	(165,'B','2006','D',200202,4,'B2006D20020200400','Bola futsal','2','250000','unit','500000','2','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006D','d40d898e72855e03732a212cd775538a'),
	(166,'B','2006','D',200202,5,'B2006D20020200500','Alat angkat badan','1','1000000','unit','1000000','1','','','','unit','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2006D','d401856a423c545fc545fa338d763edc'),
	(167,'B','2002','K',200302,1,'B2002K20030200100','Belanja Perlengkapan Kegiatan','1','400000','paket','400000','','','','','','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2002K','1eddf9da423d2829d2829a338d72c404'),
	(168,'B','2006','E',200201,2,'B2006E20020100200','Pembuatan ruang OSIS [Sumber BOS]','1','125000000','ruang','125000000','1','','','','ruang','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006E','5ad5f43a423b52c9b52c912cd77ddd99'),
	(169,'B','2006','E',200201,1,'B2006E20020100100','Pengecatan ruang perpustakaan','136','50000','meter/segi','6800000','136','','','','meter/segi','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006E','5ad29f50e18fd4673f6f712cd77c9d91'),
	(170,'B','2006','E',200201,4,'B2006E20020100400','Kran air dapur, WC dan tempat cuci tangan','30','20000','unit','600000','30','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006E','5adffb173cbcdf31a425f12cd77c4bb4'),
	(171,'B','2003','B',200106,7,'B2003B20010600700','Langganan Koran','12','100000','Bulan','1200000','','','','','','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2003B','0974090ad4d2eaba8662612cd77e7a37'),
	(172,'B','2006','E',200201,5,'B2006E20020100500','Pengecatan Ruang Laboratorium PAI','1','2000000','Paket','2000000','','','','','','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006E','5adead5a423438664386612cd777b6cd'),
	(173,'B','2006','G',200301,1,'B2006G20030100100','Alat stapler buku','2','150000','unit','300000','2','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006G','e62b8c6e728dd62b04ce912cd7797012'),
	(174,'B','2006','G',200301,3,'B2006G20030100300','Kamus Bahasa Inggris-Indonesia','32','100000','unit','3200000','32','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006G','e6230964d3f2eabaec28e12cd77169c8'),
	(175,'B','2006','G',200301,4,'B2006G20030100400','Punch Hole','2','75000','unit','150000','2','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006G','e62e51be728b1bb4dd62b12cd7783822'),
	(176,'B','2002','O',200302,7,'B2002O20030200700','Air Mineral','7','35000','dk','245000','7','1','','','dus','kegiatan','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2002O','1ed340d4e4597dcda8fd4a338d777076'),
	(177,'B','2002','O',200105,1,'B2002O20010500100','Narasumber Pemateri','8','50000','ok','400000','8','1','','','orang','kali','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002O','a522d1e0f89fd467d2829a338d7c2d8a'),
	(178,'B','2002','J',200302,4,'B2002J20030200400','Air Mineral','20','20000','Buah','400000','','','','','','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002J','1ed340d1370cdf31d2829a338d7626ae'),
	(179,'B','2000','B',200105,1,'B2000B20010500100','Insentif Panitia Pelaksana Pelepasan Pesdik Kelas 9','1','2500000','kegiatan','2500000','1','','','','kegiatan','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2000B','a52ba74a4233c92e3c92ea338d79732a'),
	(180,'B','2006','G',200301,13,'B2006G20030101300','Atlas','32','100000','eksemplar','3200000','32','','','','eksemplar','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006G','e62a6564d3f2eabaec28e12cd77cf179'),
	(181,'B','2007','C',200106,1,'B2007C20010600100','Honor pembuat Kisi-kisi dan soal','45','50000','OK','2250000','3','15','','','Tingkat','Mapel','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2007C','0974459349cfd4671ae23a338d715fda'),
	(182,'B','2006','G',200301,14,'B2006G20030101400','Buku ensiklopedi sains dan teknologi','1','3850000','paket','3850000','','','','','','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2006G','e6255e4a423cac62cac62a338d7b4889'),
	(183,'B','2006','H',200201,1,'B2006H20020100100','Pavingisasi halaman','270','75000','m2','20250000','270','','','','m2','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006H','5ad25895972b1bb4df32212cd77ccc58'),
	(184,'B','2002','I',200105,1,'B2002I20010500100','Insentif Pembina Kesiswaan','72','80000','OB','5760000','6','12','','','Orang','Bulan','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002I','a5212f2b90ed8be81fac2a338d756c26'),
	(185,'B','2006','H',200302,1,'B2006H20030200100','Bensin penyiraman halaman','20','12000','liter','240000','20','','','','liter','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2006H','1ed2d1613703dd5da7f5fa338d74de53'),
	(186,'B','2006','H',200302,2,'B2006H20030200200','Herbisida penyemprot rumput halaman dan taman','12','100000','botol','1200000','12','','','','botol','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2006H','1edeb84ad4d2eaba86626a338d78c302'),
	(187,'B','2006','H',200302,3,'B2006H20030200300','Bunga untuk taman','25','100000','pohon','2500000','25','','','','pohon','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2006H','1ed313896a02eaba3c92ea338d7e4914'),
	(188,'B','2006','H',200302,4,'B2006H20030200400','Pembuangan sampah','2','400000','Kegiatan','800000','2','','','','','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2006H','1edfa14e728d2829a0e8ea338d799af9'),
	(189,'B','2006','H',200302,5,'B2006H20030200500','Perbaikan  instalasi air halaman dan taman','2','1000000','Kegiatan','2000000','2','','','','','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2006H','1ed7fcfe728c545f43866a338d7629ed'),
	(190,'B','2006','H',200302,6,'B2006H20030200600','Pembuatan kebun','1','1000000','kegiatan','1000000','1','','','','kegiatan ','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2006H','1ed125da423c545fc545fa338d774f74'),
	(191,'B','2006','I',200202,1,'B2006I20020200100','Tongkat mayoret','5','200000','unit','1000000','5','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006I','d402f40a3b761603c545f12cd77b095e'),
	(192,'B','2006','I',200202,3,'B2006I20020200300','Bas drumb','1','3000000','unit','3000000','1','','','','unit','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2006I','d401beea4237cfba7cfbaa338d72b477'),
	(193,'B','2006','H',200302,8,'B2006H20030200800','Sapu lidi','60','7000','unit','420000','20','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006H','1ed503fb03071b9a428ee12cd77ed1b9'),
	(194,'B','2006','I',200202,4,'B2006I20020200400','Baju mayoret','4','500000','stel','2000000','4','','','','Stel','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006I','d40dd5eff67732a24386612cd779ff1d'),
	(195,'B','2006','I',200202,5,'B2006I20020200500','Stik Drumd dan pemukul','40','35000','stel ','1400000','40','','','','stel','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006I','d4001fa592097dcdc679512cd77cd192'),
	(196,'B','2006','C',200202,11,'B2006C20020201100','Pemeliharaan mesin jahit','1','5000000','kegiatan','5000000','1','','','','kegiatan','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006C','d40a3eca423adbbdadbbd12cd771da78'),
	(197,'B','2006','I',200202,7,'B2006I20020200700','Membrand drumb','15','50000','unit','750000','15','','','','unit','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006I','d40746831c7fd4672973512cd77c2c49'),
	(198,'B','2006','F',200301,1,'B2006F20030100100','Peralatan dan obat-obatan UKS dan P3K','2','2000000','Semester','4000000','1','','','','kegiatan','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2006F','e622867e728438668c48212cd7752b9c'),
	(199,'B','2007','A',200106,1,'B2007A20010600100','Konsumsi kegiatan','100','50000','Orang/Hari','5000000','50','2','','','Orang','Hari','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2007A','097e14c9139fd467adbbd12cd7719b92'),
	(200,'B','2007','A',200401,1,'B2007A20040100100','Honor Nara Sumber','3','500000','Orang','1500000','3','','','','Orang','','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2007A','2aa60dfbc87732a2f021612cd77de7a8'),
	(201,'B','2003','B',200302,2,'B2003B20030200200','KOnsumsi Rapat Dinas','670','26000','OK','17420000','67','10','','','Orang','Kegiatan','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2003B','1ed1179276cae8b92cd33a338d706a92'),
	(202,'B','2007','B',200106,2,'B2007B20010600200','honor panitia pelaksana','1','4500000','keg','4500000','1','','','','kegiatan','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2007B','097eab5a423fd148fd148a338d71fee9'),
	(203,'B','2007','B',200106,3,'B2007B20010600300','Honor pengawas ruang (non ASN)','80','20000','hari/orang','1600000','8','10','','','hari','orang','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2007B','097f1fe3ab3cdf31d3d98a338d700f80'),
	(204,'B','2007','B',200106,1,'B2007B20010600100','Honor Pembuat Kisi-kisi','45','50000','OK','2250000','3','15','','','Tingkat','Mapel','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2007B','0971e81349cfd4671ae23a338d75679c'),
	(205,'B','2007','E',200302,1,'B2007E20030200100','Penggandaan Soal Sumatif/Penilaian Harian','60000','250','Mapel/siswa','15000000','15','800','5','','Mapel','Siswa','lembar','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2007E','1edc2a1226d2bbac7f46112cd77014c5'),
	(206,'B','2007','D',200105,3,'B2007D20010500300','Honor Proktor dan Teknisi ANBK','6','80000','OK','480000','3','2','','','Hari','Orang','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2007D','a52917d9091d8be88fd5f12cd77ae553'),
	(207,'B','2007','D',200105,2,'B2007D20010500200','Insentif Pelaksana Tryout ANBK dan AKMI','4','1500000','Paket','6000000','4','','','','Kegiatan','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2007D','a52dfbfff67f0216318dea338d72ca73'),
	(208,'B','2007','D',200105,1,'B2007D20010500100','Honor Pengawas ANBK','8','50000','Ruang/hari','400000','2','1','2','2','Sesi','ruang','pengawas','hari','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2007D','a5201e50f89fd467d282912cd77745d4'),
	(209,'B','2007','D',200105,4,'B2007D20010500400','Honor Panitia ANBK Utama','1','2500000','kegiatan','2500000','2','6','','','kegiatan','Periode','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2007D','a526735a4233c92e3c92e12cd770026e'),
	(210,'B','2007','D',200106,1,'B2007D20010600100','Try Out ANBK','50','50000','Siswa/Keg','2500000','1','50','','','Kegiatan','Siswa','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2007D','0978e297c76fd4673c92e12cd7704be1'),
	(211,'B','2004','B',200501,1,'B2004B20050100100','Perjadin Kegiatan MGMP dalam kota','90','100000','pewrtemuan','9000000','15','6','','','mapel','pertemuan','','','A1003A10030200100','1003','A','100302','0','2024-06-09 09:48:26','B2004B','a2b3aaf39852eaba6ac2212cd775167a'),
	(212,'B','2002','L',200105,1,'B2002L20010500100','Insentif Pelaksana Kegiatan Classmeeting','2','1500000','kegiatan','3000000','2','','','','kegiatan','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002L','a52f8e8e728f02167cfbaa338d7b3a2f'),
	(213,'B','2002','R',200105,1,'B2002R20010500100','Insentif Panitia Pelaksana Jambore Ranting','1','600000','kegiatan','600000','1','','','','kegiatan','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002R','a523ee4a423a425fa425fa338d7b1636'),
	(214,'B','2002','S',200105,1,'B2002S20010500100','Insentif Pelaksana Kegiatan Jambore Cabang','1','300000','kegiatan','300000','1','','','','kegiatan','','','','A1001A10010200300','1001','A','100102','0','2024-06-09 09:48:26','B2002S','a52c5cfa42304ce904ce9a338d7d1eda'),
	(215,'B','2002','N',200105,1,'B2002N20010500100','Insentif Pelaksana Kegiatan','1','400000','kegiatan','400000','1','','','','kegiatan','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002N','a520a65a423d2829d2829a338d77efa7'),
	(216,'B','2007','C',200106,3,'B2007C20010600300','Honor pengawas ruang (non ASN)','80','20000','OH','1600000','8','10','','','hari','Orang','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2007C','097f1fe3ab3cdf31d3d98a338d736f5a'),
	(217,'B','2002','B',200301,1,'B2002B20030100100','Pengadaan Aplikasi Perpustakaan Digital','1','1500000','Paket','1500000','','','','','','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002B','e6223b5a423f0216f0216a338d731cc4'),
	(218,'B','2002','J',200302,2,'B2002J20030200200','Konsumsi Pembina','18','25000','OK','450000','6','3','','','Orang','Keg','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002J','1ed8aed922f538101c580a338d7a8675'),
	(219,'B','2002','M',200105,1,'B2002M20010500100','Insentif Pendamping/Pelatih','4','100000','Ok','400000','','','','','','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002M','a5255caff672eabad2829a338d786309'),
	(220,'B','2002','K',200105,2,'B2002K20010500200','Insentif Pemateri','28','50000','Materi','1400000','','','','','','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2002K','a5210c575fffd467c6795a338d76ace7'),
	(221,'B','2002','E',200105,1,'B2002E20010500100','Insentif Pendamping Saat Ujian dan Pelantikan','2','75000','OK','150000','','','','','','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002E','a524459e728b1bb4dd62ba338d701e3c'),
	(222,'B','2002','E',200105,2,'B2002E20010500200','Insentif pelatih','1','50000','OK','50000','','','','','','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002E','a52bd86a423fd467fd467a338d725d5e'),
	(223,'B','2002','E',200302,1,'B2002E20030200100','Belanja Perlengkapan seleksi','1','150000','Paket','150000','','','','','','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002E','1ed2042a423dd62bdd62ba338d7c12fd'),
	(224,'B','2002','E',200302,2,'B2002E20030200200','Konsumsi saat latihan','8','20000','OH','160000','2','4','','','Orang','hari','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002E','1ed89490f89cdf3141ebca338d7455c3'),
	(225,'B','2002','E',200302,3,'B2002E20030200300','Pendaftaran Peserta','2','100000','OK','200000','','','','','','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2002E','1edc858e7282eaba61603a338d7fecf4'),
	(226,'B','2006','C',200202,12,'B2006C20020201200','Perbaikan Pompa Air','1','500000','paket','500000','','','','','','','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2006C','d4069b8a423732a2732a2a338d7a8039'),
	(227,'B','2005','A',200105,1,'B2005A20010500100','Insentif Tim Beasiswa dan Keringan Biaya','2','1150000','Semester','2300000','','','','','','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2005A','a52615be728abfe14f338a338d78cee4'),
	(228,'B','2005','B',200106,5,'B2005B20010600500','IURAN HUT RI TK. DESA','1','500000','TH','500000','1','','','','TH','','','','A1001A10010200200','1001','A','100102','0','2024-06-09 09:48:26','B2005B','097589aa423732a2732a2a338d7974ac'),
	(229,'A','1002','A',100202,1,'A1002A10020200100','Penerimaan Hasil Sewa GOR','1','10000000','Tahun','10000000','','','','','','','','','','','','','0','2024-06-09 09:48:26','A1002A','8e7bc2ca423aaf52aaf52cd98f01b589'),
	(230,'B','2001','C',200105,1,'B2001C20010500100','Honor Panitia','1','2000000','Paket','2000000','','','','','','','','','A1002A10020200100','1002','A','100202','0','2024-06-09 09:48:26','B2001C','a52304fa4234386643866f8e7cb70661'),
	(231,'B','2001','C',200302,1,'B2001C20030200100','Konsumsi Kegiatan','150','25000','Dus','3750000','50','3','','','Orang','hari','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2001C','1edf9ba605f53810de638a338d7fc25b'),
	(232,'B','2001','C',200302,2,'B2001C20030200200','Cetak Banner','24','25000','meter','600000','4','6','','','meter','meter','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2001C','1ed99841de753810a425fa338d77dcad'),
	(233,'B','2001','C',200401,1,'B2001C20040100100','Honor Nara Sumber','6','500000','OK','3000000','2','3','','','Orang','Hari','','','A1001A10010200100','1001','A','100102','0','2024-06-09 09:48:26','B2001C','2aa60df9091732a27cfbaa338d735cd5');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_jurnal2425`;

CREATE TABLE IF NOT EXISTS `simakom_jurnal2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  `id` varchar(40) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_revisi2425`;

CREATE TABLE IF NOT EXISTS `simakom_revisi2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `revisi` float NOT NULL,
  `tanggal` date NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `simakom_revisi2425` (`no`, `revisi`, `tanggal`, `time`, `id`) VALUES
	(1,'0','2024-06-09','2024-06-09 09:48:25','5a25a0186554b37d1b92788127b9610c51c');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_transaksi2425`;

CREATE TABLE IF NOT EXISTS `simakom_transaksi2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `bukti` float NOT NULL,
  `bukti_sistem` float NOT NULL,
  `jenis` float NOT NULL,
  `kategori` varchar(3) NOT NULL,
  `rkas_kategori` varchar(1) NOT NULL,
  `rkas_kegiatan` varchar(5) NOT NULL,
  `rkas_komponen` varchar(5) NOT NULL,
  `rkas_akun` float NOT NULL,
  `rkas_detail_id` varchar(25) NOT NULL,
  `uraian` text NOT NULL,
  `debet` varchar(15) NOT NULL,
  `kredit` varchar(15) NOT NULL,
  `penerima` varchar(100) DEFAULT NULL,
  `penerima_jabatan` varchar(100) DEFAULT NULL,
  `pembiayaan_id` varchar(50) NOT NULL,
  `pembiayaan_kegiatan` varchar(4) NOT NULL,
  `pembiayaan_komponen` varchar(5) NOT NULL,
  `pembiayaan_akun` varchar(6) NOT NULL,
  `pajak` tinyint(1) NOT NULL,
  `pajak_akun` varchar(10) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  `id_setor` varchar(25) NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_lpj2425`;

CREATE TABLE IF NOT EXISTS `simakom_lpj2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `periode` varchar(2) NOT NULL,
  `tahun` varchar(9) NOT NULL,
  `bku_awal` varchar(15) NOT NULL,
  `bku_debet` varchar(15) NOT NULL,
  `bku_kredit` varchar(15) NOT NULL,
  `bku_akhir` varchar(15) NOT NULL,
  `bank_awal` varchar(15) NOT NULL,
  `bank_debet` varchar(15) NOT NULL,
  `bank_kredit` varchar(15) NOT NULL,
  `bank_akhir` varchar(15) NOT NULL,
  `tunai_awal` varchar(15) NOT NULL,
  `tunai_debet` varchar(15) NOT NULL,
  `tunai_kredit` varchar(15) NOT NULL,
  `tunai_akhir` varchar(15) NOT NULL,
  `bank_riil` varchar(15) NOT NULL,
  `tunai_riil` varchar(15) NOT NULL,
  `bank_selisih` varchar(15) NOT NULL,
  `tunai_selisih` varchar(15) NOT NULL,
  `selisihtunai_keterangan1` text NOT NULL,
  `selisihtunai_keterangan2` text NOT NULL,
  `selisihbank_keterangan1` text NOT NULL,
  `selisihbank_keterangan2` text NOT NULL,
  `rekening_nama1` text NOT NULL,
  `rekening_jumlah1` varchar(15) NOT NULL,
  `rekening_nama2` text NOT NULL,
  `rekening_jumlah2` varchar(15) NOT NULL,
  `rekening_nama3` text NOT NULL,
  `rekening_jumlah3` varchar(15) NOT NULL,
  `catatan` text NOT NULL,
  `pecahan_100` varchar(10) NOT NULL,
  `pecahan_75` varchar(10) NOT NULL,
  `pecahan_50` varchar(10) NOT NULL,
  `pecahan_20` varchar(10) NOT NULL,
  `pecahan_10` varchar(10) NOT NULL,
  `pecahan_5` varchar(10) NOT NULL,
  `pecahan_2` varchar(10) NOT NULL,
  `pecahan_1` varchar(10) NOT NULL,
  `pecahan_05` varchar(10) NOT NULL,
  `pecahan_02` varchar(10) NOT NULL,
  `pecahan_01` varchar(10) NOT NULL,
  `pecahan_005` varchar(10) NOT NULL,
  `id` varchar(30) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `db_setor2425`;

CREATE TABLE IF NOT EXISTS `db_setor2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal_draf` datetime NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  `setor_status` varchar(10) NOT NULL,
  `setor_tanggal` datetime NOT NULL,
  `terima_status` varchar(10) NOT NULL,
  `terima_tanggal` datetime NOT NULL,
  `penyetor` varchar(50) NOT NULL,
  `penerima` varchar(50) NOT NULL,
  `metode` varchar(2) NOT NULL,
  `id_rkas` varchar(50) NOT NULL,
  `tahun` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `created_by` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `db_setor2425` (`no`, `tanggal_draf`, `jumlah`, `uraian`, `setor_status`, `setor_tanggal`, `terima_status`, `terima_tanggal`, `penyetor`, `penerima`, `metode`, `id_rkas`, `tahun`, `id_setor`, `created_by`, `created_at`, `id`) VALUES
	(1,'2024-08-26 00:00:00','','Terima  Uang Pangkal','2','2024-10-25 05:10:55','1','0000-01-01 00:00:00','50463efa59739fd6caf07114793ee291','','1','A1001A10010200200','2024/2025','9fdff60ab20d50a02c','50463efa59739fd6caf07114793ee291','2024-08-26 04:23:53','9fdff60ab20d50a02c');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa_min2425`;

CREATE TABLE IF NOT EXISTS `tb_siswa_min2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=latin1;

INSERT INTO `tb_siswa_min2425` (`no`, `nama`, `nis`, `jenjang`, `paralel`, `id`) VALUES
	(1,'AHMAD RO&#039;MADHON','230003','10','A','686ef63ffba3ab4c7884'),
	(2,'DWI ANGGRAENI PUSPITASARI','230004','10','A','802746f5d2b5aabe0c10'),
	(3,'ARYA MAULANA','230005','10','A','4befdf5e38e70175aed0'),
	(4,'PUTRI AZIZAH','230006','10','A','465a5b31c184212d2a2c'),
	(5,'BAGAS KUNCORO','230007','10','A','65c15f0abd38ebb7a869'),
	(6,'BAGUS PRADANA','230008','10','A','a36d026bee5f7fc1331f'),
	(7,'BANGUN KUSUMA','230009','10','A','18f5c303288f641a2a76'),
	(8,'DIKA RIFAI','230010','10','A','778a822d7c4f29b6abbb'),
	(9,'FAIZAL NUR HODAYAT','230011','10','A','38add8e05aafafde9ab1'),
	(10,'FEBIAN TRI KUSUMA','230012','10','A','ce09a8214adf38a1cf25'),
	(11,'GANDA PUTRA','230013','10','A','73cd1f4b84ccf011bbb7'),
	(12,'IHRAM AHMAD','230014','10','A','d70ba12008f48421b758'),
	(13,'JOHAN ABDUL AZIZ','230015','10','A','a86ed253965f52d5e288'),
	(14,'MOH ANWAR','230016','10','A','1d041d6b1b7916554225'),
	(15,'MUHAMMAD ABDUL QOHAR','230017','10','A','59c172ba5830e5324fe9'),
	(16,'MUHAMMAD RIZKY','230018','10','A','73d8004991651322f4bd'),
	(17,'NUR PURWATI','230019','10','A','d866f0b6636b27ba66fb'),
	(18,'RAISA KUSWARA','230020','10','A','214ac7b6748c09cb64b3'),
	(19,'RENAL PRADANA','230021','10','A','ed53e6ddd41d37d03df1'),
	(20,'REVAN PRAKARSA','230022','11','A','6ebd0ecdc8b4b52e40b6'),
	(21,'RISKA MUSTIKA SARI','230023','11','A','dcdf0025a33020389f2f'),
	(22,'RISQI PUTWI MELASARI','230024','11','A','e06b6ae4b741c975a523'),
	(23,'RIZQI RETNASARI','230025','11','A','963e6026f5d628778bbf'),
	(24,'SALWA SITI PUSPITA','230026','11','A','d69b27d1359d93086206'),
	(25,'SASKIA PRAWESWARI','230027','11','A','3f87c597d66cf29500fc'),
	(26,'SHIFA UMAMA','230028','11','A','e8b9ec3e2e944ba4bd0e'),
	(27,'SYIFA NUR MUSTIKA','230029','11','A','9696de2f552814b510ef'),
	(28,'TEGAR SANJAYA','230030','11','A','b6999de3c9de3e86948c'),
	(29,'TRI OKTARINI','230031','11','A','1ecc87c2bb621d813c1a'),
	(30,'VESLINA PUTRI','230032','11','A','3da2ac708a9f47754112'),
	(31,'WISNU BAYU AJI','230033','11','A','34a42eda0e6e38debad2'),
	(32,'ALI ARYANTO','230034','11','A','64ddc1f3642348fc91a0'),
	(33,'AMANDA OKTAVIANI','230035','11','A','1cda3d1b69c7db8a3307'),
	(34,'ARIFA KUSUMAWATI','230036','11','A','01b43d953a2d86752d0b'),
	(35,'ASKA ALIF NURMAYA','230037','11','A','79023ef7d1228a5140d1'),
	(36,'BANI AHMAD','230038','11','A','840c578ce925a58193b4'),
	(37,'BASNO PERDANA','230039','11','A','b0b7725cd3e8d574ca2a'),
	(38,'EKA NUR KHOERI','230040','11','A','c76531cd7c9683d93a56'),
	(39,'FARDINAN RIFKI','230041','11','A','28c212d2ca807c624936'),
	(40,'FARADILA SALSABILA','230042','12','A','517567cd8805f3c88f04'),
	(41,'FATAN NUR ROCHMAN','230043','12','A','15a4cb50500ea162c008'),
	(42,'FERY HANANTO','230044','12','A','808f9755730f2c9d03e3'),
	(43,'ICA MUSTIKASARI','230045','12','A','1e7c1613d64bb9116211'),
	(44,'IQBAL MUHAMAD','230046','12','A','8e60b5388ac9e65beb1e'),
	(45,'JAMALUDDIN ','230047','12','A','4df54f518f6b6e1f1799'),
	(46,'KENZI ANASTASYA PUTRI','230048','12','A','bd6badbc1d93dea9078a'),
	(47,'MUDIR ABDILLAH','230049','12','A','ea6d72b5101e582c8fc0'),
	(48,'MUHAMMAD FACHRUDIN','230050','12','A','0289145cb05e41389422'),
	(49,'NANDA ZIDNA AULIA','230051','12','A','7bebd0edabd017207028'),
	(50,'NOVAL NUR WIJAYA','230052','12','A','f429d88f76ae731282ef'),
	(51,'NUR AZRIEL MAULANA','230053','12','A','b7ddbd11028fc5cd72bc'),
	(52,'RACHMATIKA PUTRI','230054','12','A','fa4524dbc9c3fefce69b'),
	(53,'RAFA FERNANDO','230055','12','A','c1235bfd5d56d341acba'),
	(54,'REVAN KURNIAWAN','230056','12','A','4b64b810ecaa1977c024'),
	(55,'RIZKI ABDULLAH','230057','12','A','59a63e98d5fafa54c929'),
	(56,'RIZKY ARIF','230058','12','A','62b3cdd800ddd058a8d4'),
	(57,'SUSILOWATI','230059','12','A','ff7f3e38c3eccdef403f'),
	(58,'TASYA SISKA','230060','12','A','f51c3ce2aea6c2884265'),
	(59,'TAUFIK NUR HIDAYAT','230061','12','A','39b998ae411c7a8d07f7'),
	(60,'VIOLEN INDRIJATI','230062','12','A','1bbca767093d38e5027a'),
	(61,'WAKHIDAH','230063','12','A','c5ef0f2ee0500e81da8d'),
	(62,'WINDA','230064','12','A','9aa8db6134cffc13fb3c'),
	(63,'ZAHROTUL MUSTIKA','230065','12','A','1af04cd4724a176744a0'),
	(64,'Fuad Karmani','23260','Lulus','LULUS','c7f06a3e0a43c3ed6640');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa2425`;

CREATE TABLE IF NOT EXISTS `tb_siswa2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `kelamin` varchar(20) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `ortu` varchar(75) DEFAULT NULL,
  `alamat` text,
  `tang_A` varchar(10) NOT NULL,
  `tang_B` varchar(10) NOT NULL,
  `tang_C` varchar(10) NOT NULL,
  `tang_D` varchar(10) NOT NULL,
  `tang_E` varchar(10) NOT NULL,
  `tang_F` varchar(10) NOT NULL,
  `tang_G` varchar(10) NOT NULL,
  `tang_H` varchar(10) NOT NULL,
  `tang_I` varchar(10) NOT NULL,
  `tang_J` varchar(10) NOT NULL,
  `tang_K` varchar(10) NOT NULL,
  `tang_L` varchar(10) NOT NULL,
  `tang_M` varchar(10) NOT NULL,
  `tang_N` varchar(10) NOT NULL,
  `tang_O` varchar(10) NOT NULL,
  `tang_P` varchar(10) NOT NULL,
  `tang_Q` varchar(10) NOT NULL,
  `tang_R` varchar(10) NOT NULL,
  `tang_S` varchar(10) NOT NULL,
  `tang_T` varchar(10) NOT NULL,
  `tang_U` varchar(10) NOT NULL,
  `tang_V` varchar(10) NOT NULL,
  `tang_W` varchar(10) NOT NULL,
  `tang_X` varchar(10) NOT NULL,
  `tang_Y` varchar(10) NOT NULL,
  `tang_Z` varchar(10) NOT NULL,
  `status` varchar(15) NOT NULL,
  `email` varchar(75) NOT NULL,
  `hp` varchar(15) NOT NULL,
  `kategori` varchar(200) NOT NULL,
  `startAt` varchar(2) NOT NULL,
  `catatan` text,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=latin1;

INSERT INTO `tb_siswa2425` (`no`, `nama`, `nis`, `kelamin`, `jenjang`, `paralel`, `ortu`, `alamat`, `tang_A`, `tang_B`, `tang_C`, `tang_D`, `tang_E`, `tang_F`, `tang_G`, `tang_H`, `tang_I`, `tang_J`, `tang_K`, `tang_L`, `tang_M`, `tang_N`, `tang_O`, `tang_P`, `tang_Q`, `tang_R`, `tang_S`, `tang_T`, `tang_U`, `tang_V`, `tang_W`, `tang_X`, `tang_Y`, `tang_Z`, `status`, `email`, `hp`, `kategori`, `startAt`, `catatan`, `id`) VALUES
	(1,'AHMAD RO&#039;MADHON','230003','L','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Tidak','khamdirahmani@gmail.com','085328635677','Umum','2','Beasiswa Ini','686ef63ffba3ab4c7884'),
	(2,'DWI ANGGRAENI PUSPITASARI','230004','P','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'802746f5d2b5aabe0c10'),
	(3,'ARYA MAULANA','230005','L','10','A','Ahmad','Rt 01 Rw 01','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'4befdf5e38e70175aed0'),
	(4,'PUTRI AZIZAH','230006','P','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','2',NULL,'465a5b31c184212d2a2c'),
	(5,'BAGAS KUNCORO','230007','L','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','2',NULL,'65c15f0abd38ebb7a869'),
	(6,'BAGUS PRADANA','230008','L','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','2',NULL,'a36d026bee5f7fc1331f'),
	(7,'BANGUN KUSUMA','230009','L','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'18f5c303288f641a2a76'),
	(8,'DIKA RIFAI','230010','L','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'778a822d7c4f29b6abbb'),
	(9,'FAIZAL NUR HODAYAT','230011','L','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'38add8e05aafafde9ab1'),
	(10,'FEBIAN TRI KUSUMA','230012','L','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'ce09a8214adf38a1cf25'),
	(11,'GANDA PUTRA','230013','L','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'73cd1f4b84ccf011bbb7'),
	(12,'IHRAM AHMAD','230014','L','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'d70ba12008f48421b758'),
	(13,'JOHAN ABDUL AZIZ','230015','L','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'a86ed253965f52d5e288'),
	(14,'MOH ANWAR','230016','L','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'1d041d6b1b7916554225'),
	(15,'MUHAMMAD ABDUL QOHAR','230017','L','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'59c172ba5830e5324fe9'),
	(16,'MUHAMMAD RIZKY','230018','L','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'73d8004991651322f4bd'),
	(17,'NUR PURWATI','230019','P','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'d866f0b6636b27ba66fb'),
	(18,'RAISA KUSWARA','230020','L','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'214ac7b6748c09cb64b3'),
	(19,'RENAL PRADANA','230021','L','10','A','','','0','2400000','9500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'ed53e6ddd41d37d03df1'),
	(20,'REVAN PRAKARSA','230022','L','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'6ebd0ecdc8b4b52e40b6'),
	(21,'RISKA MUSTIKA SARI','230023','P','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'dcdf0025a33020389f2f'),
	(22,'RISQI PUTWI MELASARI','230024','P','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'e06b6ae4b741c975a523'),
	(23,'RIZQI RETNASARI','230025','P','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'963e6026f5d628778bbf'),
	(24,'SALWA SITI PUSPITA','230026','P','11','A','','','250000','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'d69b27d1359d93086206'),
	(25,'SASKIA PRAWESWARI','230027','P','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'3f87c597d66cf29500fc'),
	(26,'SHIFA UMAMA','230028','P','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'e8b9ec3e2e944ba4bd0e'),
	(27,'SYIFA NUR MUSTIKA','230029','P','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'9696de2f552814b510ef'),
	(28,'TEGAR SANJAYA','230030','L','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'b6999de3c9de3e86948c'),
	(29,'TRI OKTARINI','230031','P','11','A','','','4000000','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'1ecc87c2bb621d813c1a'),
	(30,'VESLINA PUTRI','230032','P','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'3da2ac708a9f47754112'),
	(31,'WISNU BAYU AJI','230033','L','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'34a42eda0e6e38debad2'),
	(32,'ALI ARYANTO','230034','L','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'64ddc1f3642348fc91a0'),
	(33,'AMANDA OKTAVIANI','230035','P','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'1cda3d1b69c7db8a3307'),
	(34,'ARIFA KUSUMAWATI','230036','P','11','A','','','1500000','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'01b43d953a2d86752d0b'),
	(35,'ASKA ALIF NURMAYA','230037','P','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'79023ef7d1228a5140d1'),
	(36,'BANI AHMAD','230038','L','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'840c578ce925a58193b4'),
	(37,'BASNO PERDANA','230039','L','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'b0b7725cd3e8d574ca2a'),
	(38,'EKA NUR KHOERI','230040','P','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'c76531cd7c9683d93a56'),
	(39,'FARDINAN RIFKI','230041','L','11','A','','','0','1200000','750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'28c212d2ca807c624936'),
	(40,'FARADILA SALSABILA','230042','P','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'517567cd8805f3c88f04'),
	(41,'FATAN NUR ROCHMAN','230043','L','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'15a4cb50500ea162c008'),
	(42,'FERY HANANTO','230044','L','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'808f9755730f2c9d03e3'),
	(43,'ICA MUSTIKASARI','230045','P','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'1e7c1613d64bb9116211'),
	(44,'IQBAL MUHAMAD','230046','L','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'8e60b5388ac9e65beb1e'),
	(45,'JAMALUDDIN ','230047','L','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'4df54f518f6b6e1f1799'),
	(46,'KENZI ANASTASYA PUTRI','230048','P','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'bd6badbc1d93dea9078a'),
	(47,'MUDIR ABDILLAH','230049','L','12','A','','','450000','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'ea6d72b5101e582c8fc0'),
	(48,'MUHAMMAD FACHRUDIN','230050','L','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'0289145cb05e41389422'),
	(49,'NANDA ZIDNA AULIA','230051','P','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'7bebd0edabd017207028'),
	(50,'NOVAL NUR WIJAYA','230052','L','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'f429d88f76ae731282ef'),
	(51,'NUR AZRIEL MAULANA','230053','L','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'b7ddbd11028fc5cd72bc'),
	(52,'RACHMATIKA PUTRI','230054','P','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'fa4524dbc9c3fefce69b'),
	(53,'RAFA FERNANDO','230055','L','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'c1235bfd5d56d341acba'),
	(54,'REVAN KURNIAWAN','230056','L','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'4b64b810ecaa1977c024'),
	(55,'RIZKI ABDULLAH','230057','L','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'59a63e98d5fafa54c929'),
	(56,'RIZKY ARIF','230058','L','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'62b3cdd800ddd058a8d4'),
	(57,'SUSILOWATI','230059','P','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'ff7f3e38c3eccdef403f'),
	(58,'TASYA SISKA','230060','P','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'f51c3ce2aea6c2884265'),
	(59,'TAUFIK NUR HIDAYAT','230061','L','12','A','','','3200000','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'39b998ae411c7a8d07f7'),
	(60,'VIOLEN INDRIJATI','230062','P','12','A','','','500000','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'1bbca767093d38e5027a'),
	(61,'WAKHIDAH','230063','P','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'c5ef0f2ee0500e81da8d'),
	(62,'WINDA','230064','P','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'9aa8db6134cffc13fb3c'),
	(63,'ZAHROTUL MUSTIKA','230065','P','12','A','','','0','1200000','850000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','khamdirahmani@gmail.com','085328635677','Umum','1',NULL,'1af04cd4724a176744a0'),
	(64,'Fuad Karmani','23260','L','Lulus','LULUS','','','1250000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','Akademik','1',NULL,'c7f06a3e0a43c3ed6640');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_list2425`;

CREATE TABLE IF NOT EXISTS `payment_list2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(120) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `hp` varchar(18) NOT NULL,
  `email` varchar(100) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `status` varchar(15) NOT NULL,
  `keterangan` text,
  `payment_id` varchar(50) NOT NULL,
  `tahun` varchar(9) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO `payment_list2425` (`no`, `tanggal`, `nis`, `nama`, `jenjang`, `paralel`, `hp`, `email`, `jumlah`, `status`, `keterangan`, `payment_id`, `tahun`, `created_at`, `id`) VALUES
	(5,'2024-10-19','230004','DWI ANGGRAENI PUSPITASARI','10','A','085328635677','khamdirahmani@gmail.com','900000','DRAF','','SIMAKOM2425_230004_639BA4D1C76E9C8','2024/2025','2024-10-19 19:59:10','d3163c152a26a386100b2e15097b1e2a'),
	(6,'2024-10-20','230003','AHMAD RO\'MADHON','10','A','085328635677','khamdirahmani@gmail.com','200000','DRAF','','SIMAKOM2425_230003_0A23A100CBC1693','2024/2025','2024-10-20 04:58:37','f73e4a509f13fd8fb4a76a728272b93f'),
	(8,'2024-10-26','230005','ARYA MAULANA','10','A','085328635677','khamdirahmani@gmail.com','150000','DRAF','','SIMAKOM2425_230005_776E8FCDCB70D16','2024/2025','2024-10-26 20:17:57','ffb7e8217b231de627a1df81c532ea44');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_list_detail2425`;

CREATE TABLE IF NOT EXISTS `payment_list_detail2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` datetime NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `jenjang` varchar(5) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `kategori` varchar(30) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `tahap` float NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `random` varchar(20) NOT NULL,
  `penerima` varchar(100) NOT NULL,
  `setor` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `metode` varchar(20) NOT NULL,
  `catatan` text,
  `time` datetime NOT NULL,
  `ip` varchar(30) NOT NULL,
  `browser` text,
  `id_tr` varchar(50) NOT NULL,
  `payment_id` varchar(50) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

INSERT INTO `payment_list_detail2425` (`no`, `tanggal`, `nis`, `nama`, `kelamin`, `jenjang`, `paralel`, `kategori`, `jenis`, `tahap`, `jumlah`, `random`, `penerima`, `setor`, `id_setor`, `metode`, `catatan`, `time`, `ip`, `browser`, `id_tr`, `payment_id`, `id`) VALUES
	(12,'2024-10-20 00:00:00','230003','AHMAD RO\'MADHON','L','10','A','Umum','B',3,'200000','4A713ZEMYE1F','Payment_Gateway','','','Bank','','2024-10-20 04:58:37','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:131.0) Gecko/20100101 Firefox/131.0','SIMAKOM2425_230003_0A23A100CBC1693','SIMAKOM2425_230003_0A23A100CBC1693','BA223EF41C8RIGKFC891'),
	(11,'2024-10-19 00:00:00','230004','DWI ANGGRAENI PUSPITASARI','P','10','A','Umum','C',1,'500000','B65188TBDXDA','Payment_Gateway','','','Bank','','2024-10-19 19:59:10','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:131.0) Gecko/20100101 Firefox/131.0','SIMAKOM2425_230004_639BA4D1C76E9C8','SIMAKOM2425_230004_639BA4D1C76E9C8','9DAF02A7UKL2WGX9BDEB'),
	(10,'2024-10-19 00:00:00','230004','DWI ANGGRAENI PUSPITASARI','P','10','A','Umum','B',2,'200000','D24D1UV4QRDD','Payment_Gateway','','','Bank','','2024-10-19 19:58:52','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:131.0) Gecko/20100101 Firefox/131.0','SIMAKOM2425_230004_639BA4D1C76E9C8','SIMAKOM2425_230004_639BA4D1C76E9C8','0012175DVQH5OXCCBB8E'),
	(9,'2024-10-19 00:00:00','230004','DWI ANGGRAENI PUSPITASARI','P','10','A','Umum','B',1,'200000','D24D1XTPAZ77','Payment_Gateway','','','Bank','','2024-10-19 19:58:52','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:131.0) Gecko/20100101 Firefox/131.0','SIMAKOM2425_230004_639BA4D1C76E9C8','SIMAKOM2425_230004_639BA4D1C76E9C8','9F367B09E8E8VSK36B4A'),
	(14,'2024-10-26 00:00:00','230005','ARYA MAULANA','L','10','A','Umum','B',2,'100000','3FCFEELTCK10','Payment_Gateway','','','Bank','','2024-10-26 05:19:40','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:131.0) Gecko/20100101 Firefox/131.0','SIMAKOM2425_230005_776E8FCDCB70D16','SIMAKOM2425_230005_776E8FCDCB70D16','666A57A4UEOHMDL8F508'),
	(15,'2024-10-26 00:00:00','230005','ARYA MAULANA','L','10','A','Umum','C',2,'50000','65DA43S4FWE0','Payment_Gateway','','','Bank','','2024-10-26 20:17:57','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:131.0) Gecko/20100101 Firefox/131.0','SIMAKOM2425_230005_776E8FCDCB70D16','SIMAKOM2425_230005_776E8FCDCB70D16','5551818A9B31JCU5F82C');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_set`;

CREATE TABLE IF NOT EXISTS `payment_set` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `aktif` varchar(1) DEFAULT NULL,
  `sistem` varchar(2) NOT NULL,
  `api` text,
  `callback` text,
  `fee` varchar(15) NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_siswa2425`;

CREATE TABLE IF NOT EXISTS `tabungan_siswa2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `rekening` varchar(20) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `saldo` varchar(15) NOT NULL,
  `status` varchar(15) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `tabungan_siswa2425` (`no`, `nama`, `nis`, `rekening`, `kelamin`, `saldo`, `status`, `id`, `created_at`, `updated_at`, `created_by`) VALUES
	(1,'ADHITYA NUR RAHMAT','230002','230002','L','100000','Aktif','4d32e045c04dc8b13523','2024-08-27 05:33:00','2024-08-27 05:33:00','d0f83653fdb01ed928a4'),
	(2,'AHMAD ROMADHON','230003','230003','L','305000','Aktif','e7b90eb764686ef13523','2024-08-27 05:33:19','2024-08-27 05:33:19','d0f83653fdb01ed928a4');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `db_transaksi2425`;

CREATE TABLE IF NOT EXISTS `db_transaksi2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` datetime NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `jenjang` varchar(5) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `kategori` varchar(30) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `tahap` float NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `random` varchar(20) NOT NULL,
  `penerima` varchar(100) NOT NULL,
  `setor` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `metode` varchar(20) NOT NULL,
  `catatan` text,
  `time` datetime NOT NULL,
  `ip` varchar(30) NOT NULL,
  `browser` text,
  `id_tr` varchar(50) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=latin1;

INSERT INTO `db_transaksi2425` (`no`, `tanggal`, `nis`, `nama`, `kelamin`, `jenjang`, `paralel`, `kategori`, `jenis`, `tahap`, `jumlah`, `random`, `penerima`, `setor`, `id_setor`, `metode`, `catatan`, `time`, `ip`, `browser`, `id_tr`, `id`) VALUES
	(1,'2024-08-25 00:00:00','230010','DIKA RIFAI','L','10','A','Umum','B',1,'100000','4EB004Y3252D','50463efa59739fd6caf07114793ee291','2','9fdff60ab20d50a02c','Tunai','','2024-08-25 14:09:38','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','269231822DCD02','600ADA549QWTSA2D98C9'),
	(2,'2024-08-25 00:00:00','230010','DIKA RIFAI','L','10','A','Umum','C',1,'50000','9E72CS86M7D2','50463efa59739fd6caf07114793ee291','2','9fdff60ab20d50a02c','Tunai','','2024-08-25 14:09:39','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','269231822DCD02','BD63368BMGS3U8DAE027'),
	(3,'2024-08-25 00:00:00','230030','TEGAR SANJAYA','L','11','A','Umum','B',1,'100000','B6F9FSDPRTB3','50463efa59739fd6caf07114793ee291','','','Tunai','','2024-08-25 17:39:56','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','90F00F9DE33EC2','7DD22D997OK8SAV2AC37'),
	(4,'2024-08-25 00:00:00','230030','TEGAR SANJAYA','L','11','A','Umum','B',2,'100000','B6F9FDZUHQ57','50463efa59739fd6caf07114793ee291','','','Tunai','','2024-08-25 17:39:56','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','90F00F9DE33EC2','646B1FBEFVHAMKW32A37'),
	(5,'2024-08-25 00:00:00','230030','TEGAR SANJAYA','L','11','A','Umum','C',1,'75000','B6F9F2VPL064','50463efa59739fd6caf07114793ee291','','','Tunai','','2024-08-25 17:39:56','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','90F00F9DE33EC2','8559A174QWKHRE5DC64A'),
	(6,'2024-08-25 00:00:00','230006','PUTRI AZIZAH','P','10','A','Umum','B',2,'100000','AB3F9SWF8K7A','50463efa59739fd6caf07114793ee291','2','9fdff60ab20d50a02c','Tunai','','2024-08-25 17:41:13','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','FBDDC55B31C43B','69F32FC95LZOUJA3977B'),
	(7,'2024-08-25 00:00:00','230006','PUTRI AZIZAH','P','10','A','Umum','C',1,'45000','AB3F9HCVMS7F','50463efa59739fd6caf07114793ee291','2','9fdff60ab20d50a02c','Tunai','','2024-08-25 17:41:13','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','FBDDC55B31C43B','483409A3UA5PKLG764E8'),
	(8,'2024-08-25 00:00:00','230032','VESLINA PUTRI','P','11','A','Umum','B',1,'100000','25749JVAAL32','50463efa59739fd6caf07114793ee291','','','Tunai','','2024-08-25 17:42:26','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','8D66D9AC70D9CC','942197089TIMTGH69BB7'),
	(9,'2024-08-25 00:00:00','230032','VESLINA PUTRI','P','11','A','Umum','C',1,'50000','25749O376Y78','50463efa59739fd6caf07114793ee291','','','Tunai','','2024-08-25 17:42:26','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','8D66D9AC70D9CC','D66F1F33U1MRBPNE6FB7'),
	(10,'2024-08-25 00:00:00','230012','FEBIAN TRI KUSUMA','L','10','A','Umum','B',1,'100000','BC75DWACDI0E','50463efa59739fd6caf07114793ee291','2','9fdff60ab20d50a02c','Tunai','','2024-08-25 18:28:03','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','B79245A821FD0E','1E4EA790NSAJ1QR57B6A'),
	(11,'2024-08-25 00:00:00','230005','ARYA MAULANA','L','10','A','Umum','B',1,'100000','AB56CNQMCHFA','50463efa59739fd6caf07114793ee291','2','9fdff60ab20d50a02c','Tunai','','2024-08-25 18:31:09','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','765463DF5EA457','91BEAD8C5UP36327BD2A'),
	(12,'2024-08-25 00:00:00','230005','ARYA MAULANA','L','10','A','Umum','C',1,'50000','AB56CWD4M8D2','50463efa59739fd6caf07114793ee291','2','9fdff60ab20d50a02c','Tunai','','2024-08-25 18:31:09','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','765463DF5EA457','88A7AE3ACMHYJ3H0439B'),
	(13,'2024-08-26 00:00:00','230003','AHMAD RO&#039;MADHON','L','10','A','Umum','B',1,'100000','414CAFQUSV6E','50463efa59739fd6caf07114793ee291','2','9fdff60ab20d50a02c','Tunai','','2024-08-26 20:22:57','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','217EBEF63F185C','7811A64A9NP3QJ32C99B'),
	(14,'2024-08-26 00:00:00','230003','AHMAD RO&#039;MADHON','L','10','A','Umum','B',2,'100000','55806EO9I04C','50463efa59739fd6caf07114793ee291','2','9fdff60ab20d50a02c','Tunai','','2024-08-26 20:22:58','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','217EBEF63F185C','1D8DD7571VEBRPQ5EDAE'),
	(15,'2024-08-26 00:00:00','230003','AHMAD RO&#039;MADHON','L','10','A','Umum','C',1,'65000','55806GPA6L00','50463efa59739fd6caf07114793ee291','2','9fdff60ab20d50a02c','Tunai','','2024-08-26 20:22:58','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','217EBEF63F185C','5057FEB0V7H5H7I92A80'),
	(16,'2024-08-30 00:00:00','230007','BAGAS KUNCORO','L','10','A','Umum','B',2,'100000','E9AEBR5NNG70','50463efa59739fd6caf07114793ee291','','','Tunai','','2024-08-30 16:11:17','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:128.0) Gecko/20100101 Firefox/128.0','3C8EA95F0A6449','5944969FE9EG2ZO8673E');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_transaksi2425`;

CREATE TABLE IF NOT EXISTS `tabungan_transaksi2425` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `jurnal` varchar(1) NOT NULL,
  `catatan` text NOT NULL,
  `created_by` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `tabungan_transaksi2425` (`no`, `tanggal`, `nis`, `nama`, `jenis`, `jumlah`, `jurnal`, `catatan`, `created_by`, `created_at`, `id`) VALUES
	(1,'2024-07-08','230002','ADHITYA NUR RAHMAT','D','50000','','PIP','d0f83653fdb01ed928a4','2024-07-08 16:46:01','8d54bdb0fe675e01017b4d32e'),
	(2,'2024-07-09','230002','ADHITYA NUR RAHMAT','D','75000','','','d0f83653fdb01ed928a4','2024-07-09 05:28:38','8d54bda5e9f4d55270994d32e'),
	(3,'2024-08-25','230002','ADHITYA NUR RAHMAT','D','75000','','bantuan','d0f83653fdb01ed928a4','2024-08-25 20:56:46','8d54b0adec1dcc1270994d32e');

-- ------------------------------------------------ 

